/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.domino.test.api.client;

import io.vertx.config.ConfigRetriever;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import org.dominokit.domino.api.client.ApplicationStartHandler;
import org.dominokit.domino.api.client.ClientApp;
import org.dominokit.domino.api.client.ModuleConfiguration;
import org.dominokit.domino.api.client.ModuleConfigurator;
import org.dominokit.domino.api.client.mvp.slots.IsSlot;
import org.dominokit.domino.api.server.ServerApp;
import org.dominokit.domino.api.server.config.ServerConfiguration;
import org.dominokit.domino.api.server.config.ServerConfigurationLoader;
import org.dominokit.domino.api.server.config.VertxConfiguration;
import org.dominokit.domino.api.server.entrypoint.VertxContext;
import org.dominokit.domino.api.server.entrypoint.VertxEntryPointContext;
import org.dominokit.domino.api.shared.extension.DominoEventListener;
import org.dominokit.domino.service.discovery.VertxServiceDiscovery;
import org.dominokit.domino.test.api.DominoTestServer;
import org.dominokit.domino.test.api.TestConfigReader;
import org.dominokit.domino.test.api.client.BeforeClientStart;
import org.dominokit.domino.test.api.client.CanCustomizeClient;
import org.dominokit.domino.test.api.client.CanStartClient;
import org.dominokit.domino.test.api.client.ClientContext;
import org.dominokit.domino.test.api.client.FakeDominoOptions;
import org.dominokit.domino.test.api.client.FakeSlot;
import org.dominokit.domino.test.api.client.ListenerHandler;
import org.dominokit.domino.test.api.client.StartCompleted;
import org.dominokit.domino.test.api.client.TestClientAppFactory;
import org.dominokit.domino.test.api.client.TestFailedResponseBean;
import org.dominokit.domino.test.api.client.TestRoutingListener;
import org.dominokit.domino.test.api.client.TestServerRouter;
import org.dominokit.domino.test.history.TestDominoHistory;
import org.dominokit.rest.DominoRestConfig;
import org.dominokit.rest.VertxInstanceProvider;
import org.dominokit.rest.jvm.DefaultProvider;
import org.dominokit.rest.shared.request.RequestRouter;
import org.dominokit.rest.shared.request.ServerRequest;
import org.easymock.EasyMock;

public class DominoTestClient
implements CanCustomizeClient,
CanStartClient,
ClientContext {
    public static final Logger LOGGER = Logger.getLogger(DominoTestClient.class.getName());
    private List<ModuleConfiguration> modules;
    private List<ListenerOf> listenersOf = new ArrayList<ListenerOf>();
    private VertxEntryPointContext testEntryPointContext;
    private Vertx vertx;
    private boolean withServer = false;
    private TestContext testContext;
    private BeforeClientStart beforeClientStart = context -> {};
    private StartCompleted startCompleted = context -> {};
    private DominoTestServer.AfterLoadHandler afterLoadHandler = context -> {};
    private ConfigOverrideHandler configOverrideHandler = () -> {};

    private DominoTestClient(ModuleConfiguration ... configurations) {
        this(Arrays.asList(configurations));
    }

    private DominoTestClient(List<ModuleConfiguration> configurations) {
        this.modules = configurations;
        VertxOptions vertxOptions = new VertxOptions();
        vertxOptions.setBlockedThreadCheckInterval(3600000L);
        vertxOptions.setWorkerPoolSize(50);
        this.vertx = Vertx.vertx((VertxOptions)vertxOptions);
        this.init();
    }

    public static CanCustomizeClient useModules(ModuleConfiguration ... configurations) {
        return new DominoTestClient(configurations);
    }

    public static CanCustomizeClient useModules(List<ModuleConfiguration> configurations) {
        return new DominoTestClient(configurations);
    }

    @Override
    public CanCustomizeClient overrideConfig(ConfigOverrideHandler handler) {
        this.configOverrideHandler = handler;
        return this;
    }

    @Override
    public <L extends DominoEventListener> CanCustomizeClient listenerOf(Class<L> listenerType, ListenerHandler<L> handler) {
        this.listenersOf.add(new ListenerOf(listenerType, handler));
        return this;
    }

    @Override
    public CanCustomizeClient onBeforeClientStart(BeforeClientStart beforeClientStart) {
        this.beforeClientStart = beforeClientStart;
        return this;
    }

    @Override
    public CanCustomizeClient onClientStarted(StartCompleted startCompleted) {
        this.startCompleted = startCompleted;
        return this;
    }

    @Override
    public CanCustomizeClient withServer(TestContext testContext, DominoTestServer.AfterLoadHandler afterLoadHandler) {
        this.afterLoadHandler = afterLoadHandler;
        return this.withServer(testContext);
    }

    @Override
    public CanCustomizeClient withServer(TestContext testContext) {
        this.testContext = testContext;
        this.withServer = true;
        return this;
    }

    @Override
    public void start(String configFileName, JsonObject additionalConfig) {
        this.start(configFileName, additionalConfig, () -> {});
    }

    @Override
    public void start(String configFileName, JsonObject additionalConfig, StartCompletedHandler onCompleteHandler) {
        JsonObject config = new TestConfigReader(this.vertx, configFileName).getTestConfig();
        additionalConfig.mergeIn(config);
        VertxConfiguration testServerConfiguration = new VertxConfiguration(config);
        this.testEntryPointContext = new VertxEntryPointContext((RoutingContext)EasyMock.createMock(RoutingContext.class), (ServerConfiguration)testServerConfiguration, this.vertx);
        VertxContext vertxContext = VertxContext.VertxContextBuilder.vertx((Vertx)this.vertx).router(Router.router((Vertx)this.vertx)).serverConfiguration((ServerConfiguration)testServerConfiguration).vertxServiceDiscovery(new VertxServiceDiscovery(this.vertx)).configRetriever(ConfigRetriever.create((Vertx)this.vertx)).build();
        new ServerConfigurationLoader(vertxContext).loadModules();
        this.modules.forEach(this::configureModule);
        this.configOverrideHandler.overrideConfig();
        ClientApp.make().slotsManager().registerSlot("body-slot", (IsSlot)new FakeSlot());
        this.listenersOf.forEach(c -> ((ListenerOf)c).handler.handle(this.getListener(((ListenerOf)c).listenerName)));
        if (this.withServer) {
            Async async = this.testContext.async();
            LOGGER.info("Starting server ... ");
            DominoTestServer.vertx((Vertx)this.vertx()).onAfterLoad(serverContext -> {
                ((VertxContext)ServerApp.make().serverContext()).httpServerOptions().setPort(serverContext.getActualPort());
                DominoRestConfig.getInstance().setServerRouter((RequestRouter)TestClientAppFactory.serverRouter);
                this.afterLoadHandler.handle(serverContext);
                this.doStart(() -> {
                    this.startCompleted.onStarted(this);
                    onCompleteHandler.onStarted();
                    LOGGER.info("Server started on port [" + serverContext.getActualPort() + "]");
                    async.complete();
                });
            }).start();
        } else {
            this.doStart(() -> {
                this.startCompleted.onStarted(this);
                onCompleteHandler.onStarted();
            });
        }
    }

    public String get() {
        Iterator<VertxInstanceProvider> iterator = ServiceLoader.load(VertxInstanceProvider.class).iterator();
        Object provider = iterator.hasNext() ? iterator.next() : new DefaultProvider();
        String protocol = provider.getProtocol();
        String host = provider.getHost();
        int port = provider.getPort();
        return protocol + "://" + host + ":" + port + "/";
    }

    @Override
    public void start() {
        this.start("config.json", () -> {});
    }

    @Override
    public void start(StartCompletedHandler onCompletedHandler) {
        this.start("config.json", onCompletedHandler);
    }

    @Override
    public void start(String configFileName) {
        this.start(configFileName, new JsonObject(), () -> {});
    }

    @Override
    public void start(String configFileName, StartCompletedHandler onCompletedHandler) {
        this.start(configFileName, new JsonObject(), onCompletedHandler);
    }

    @Override
    public void start(JsonObject additionalConfig) {
        this.start("config.json", additionalConfig, () -> {});
    }

    @Override
    public void start(JsonObject additionalConfig, StartCompletedHandler onCompletedHandler) {
        this.start("config.json", additionalConfig, onCompletedHandler);
    }

    private void doStart(ApplicationStartHandler applicationStartHandler) {
        this.getDominoOptions().setApplicationStartHandler(applicationStartHandler);
        ClientApp.make().run(dominoOptions -> this.beforeClientStart.onBeforeStart(this));
        LOGGER.info("Test client started.");
    }

    private void init() {
        TestClientAppFactory.make(this.vertx);
    }

    private void configureModule(ModuleConfiguration configuration) {
        new ModuleConfigurator().configureModule(configuration);
    }

    public <L extends DominoEventListener> L getListener(Class<L> listenerType) {
        return TestClientAppFactory.listenersRepository.getListener(listenerType);
    }

    @Override
    public TestDominoHistory history() {
        return (TestDominoHistory)ClientApp.make().getHistory();
    }

    @Override
    public void setRoutingListener(TestServerRouter.RoutingListener routingListener) {
        TestClientAppFactory.serverRouter.setRoutingListener(routingListener);
    }

    @Override
    public TestRoutingListener getDefaultRoutingListener() {
        return TestClientAppFactory.serverRouter.getDefaultRoutingListener();
    }

    @Override
    public void removeRoutingListener() {
        TestClientAppFactory.serverRouter.removeRoutingListener();
    }

    @Override
    public TestResponse forRequest(String requestKey) {
        return new TestResponse(requestKey);
    }

    @Override
    public TestResponse forRequest(Class<? extends ServerRequest> request) {
        return this.forRequest(request.getCanonicalName());
    }

    public Future<TestServerRouter.ResponseReply> onRequestCompleted(Class<? extends ServerRequest> request) {
        Future completeFuture = Future.future();
        TestClientAppFactory.serverRouter.onRequestCompleted(request, (Future<TestServerRouter.ResponseReply>)completeFuture);
        return completeFuture;
    }

    public Future<TestServerRouter.ResponseReply> onRequestCompleted(Class<? extends ServerRequest> request, RequestCompleteHandler completeHandler) {
        Future completeFuture = Future.future();
        completeFuture.setHandler(completeHandler::onCompleted);
        TestClientAppFactory.serverRouter.onRequestCompleted(request, (Future<TestServerRouter.ResponseReply>)completeFuture);
        return completeFuture;
    }

    @Override
    public Vertx vertx() {
        return this.vertx;
    }

    @Override
    public VertxEntryPointContext vertxEntryPointContext() {
        return this.testEntryPointContext;
    }

    @Override
    public FakeDominoOptions getDominoOptions() {
        return TestClientAppFactory.dominoOptions;
    }

    public void setTestContext(TestContext testContext) {
        this.testContext = testContext;
    }

    @FunctionalInterface
    public static interface RequestCompleteHandler {
        public void onCompleted(AsyncResult<TestServerRouter.ResponseReply> var1);
    }

    @FunctionalInterface
    public static interface StartCompletedHandler {
        public void onStarted();
    }

    @FunctionalInterface
    public static interface ConfigOverrideHandler {
        public void overrideConfig();
    }

    public static class TestResponse {
        private String request;
        private TestFailedResponseBean failedResponseBean;

        private TestResponse(String request) {
            this.request = request;
            this.failedResponseBean = new TestFailedResponseBean();
        }

        public void returnResponse(Object response) {
            TestClientAppFactory.serverRouter.fakeResponse(this.request, new TestServerRouter.SuccessReply<Object>(response));
        }

        public TestResponse failStatusCode(int status) {
            this.failedResponseBean.setStatusCode(status);
            return this;
        }

        public TestResponse failStatusText(String statusText) {
            this.failedResponseBean.setStatusText(statusText);
            return this;
        }

        public TestResponse failHeaders(Map<String, String> headers) {
            this.failedResponseBean.setHeaders(headers);
            return this;
        }

        public TestResponse failBody(String body) {
            this.failedResponseBean.setBody(body);
            return this;
        }

        public TestResponse failError(Throwable error) {
            this.failedResponseBean.setThrowable(error);
            return this;
        }

        public void thenFail() {
            TestClientAppFactory.serverRouter.fakeResponse(this.request, new TestServerRouter.FailedReply(this.failedResponseBean));
        }

        public void failWith(Exception error) {
            this.failedResponseBean.setThrowable(error);
            TestClientAppFactory.serverRouter.fakeResponse(this.request, new TestServerRouter.FailedReply(this.failedResponseBean));
        }
    }

    private static class ListenerOf {
        private final Class<? extends DominoEventListener> listenerName;
        private final ListenerHandler handler;

        private ListenerOf(Class<? extends DominoEventListener> listenerName, ListenerHandler handler) {
            this.listenerName = listenerName;
            this.handler = handler;
        }
    }
}

