/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.domino.test.api.client;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import org.dominokit.domino.api.client.extension.PresentersNamesRegistry;

public class TestNamedPresenters
implements PresentersNamesRegistry {
    public static final Logger LOGGER = Logger.getLogger(TestNamedPresenters.class.getName());
    private final Map<String, Deque<String>> NAMED_PRESENTERS = new HashMap<String, Deque<String>>();
    private final Map<String, List<PresentersNamesRegistry.ParentFunction>> PARENT_FUNCTIONS = new HashMap<String, List<PresentersNamesRegistry.ParentFunction>>();

    private void registerPresenterName(String name) {
        LOGGER.info(" >> REGISTERING PRESENTER [" + name + "]");
        String key = name.toLowerCase();
        if (!this.NAMED_PRESENTERS.containsKey(key)) {
            this.NAMED_PRESENTERS.put(key, new LinkedList());
        }
        this.NAMED_PRESENTERS.get(key).push(name);
        if (this.PARENT_FUNCTIONS.containsKey(key)) {
            this.PARENT_FUNCTIONS.get(key).forEach(PresentersNamesRegistry.ParentFunction::apply);
            this.PARENT_FUNCTIONS.remove(key);
        }
    }

    public void registerPresenter(String name) {
        this.registerPresenterName(name);
    }

    private void removePresenterName(String name) {
        LOGGER.info(" << REMOVING PRESENTER [" + name + "]");
        String key = name.toLowerCase();
        if (this.NAMED_PRESENTERS.containsKey(key)) {
            this.NAMED_PRESENTERS.get(key).pop();
            if (this.NAMED_PRESENTERS.get(key).isEmpty()) {
                this.NAMED_PRESENTERS.remove(key);
                this.PARENT_FUNCTIONS.remove(key);
            }
        }
    }

    public void removePresenter(String name) {
        this.registerPresenterName(name);
    }

    public Optional<String> get(String name) {
        if (this.NAMED_PRESENTERS.containsKey(name.toLowerCase())) {
            return Optional.ofNullable(this.NAMED_PRESENTERS.get(name.toLowerCase()).peek());
        }
        return Optional.empty();
    }

    public void whenPresent(String name, PresentersNamesRegistry.ParentFunction parentFunction) {
        String key = name.toLowerCase();
        if (this.get(name).isPresent()) {
            parentFunction.apply();
        } else {
            this.addFunction(key, parentFunction);
        }
    }

    private void addFunction(String key, PresentersNamesRegistry.ParentFunction parentFunction) {
        if (!this.PARENT_FUNCTIONS.containsKey(key)) {
            this.PARENT_FUNCTIONS.put(key, new ArrayList());
        }
        this.PARENT_FUNCTIONS.get(key).add(parentFunction);
    }
}

