/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.domino.test.api.client;

import java.util.List;
import org.dominokit.domino.api.server.request.DefaultMultiMap;
import org.dominokit.domino.api.server.request.MultiMap;
import org.dominokit.domino.api.server.response.ResponseContext;
import org.dominokit.domino.api.server.response.ResponseEndHandler;
import org.dominokit.rest.shared.request.ResponseBean;

public class TestResponseContext<S extends ResponseBean>
implements ResponseContext<S> {
    private S responseBean;
    private S[] responseArray;
    private List<S> responseList;
    private String bodyString;
    private boolean ended;
    private int statusCode;
    private MultiMap<String, String> headers = new DefaultMultiMap();
    private ResponseEndHandler endHandler;

    public ResponseContext<S> putHeader(String name, String value) {
        this.headers.add((Object)name, (Object)value);
        return this;
    }

    public ResponseContext<S> putHeader(String name, Iterable<String> values) {
        this.headers.add((Object)name, values);
        return this;
    }

    public ResponseContext<S> statusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public void end() {
        this.ended = true;
        this.callEndHandler();
    }

    public void end(S body) {
        this.ended = true;
        this.responseBean = body;
        this.callEndHandler();
    }

    public void end(String body) {
        this.ended = true;
        this.bodyString = body;
        this.callEndHandler();
    }

    public void end(S[] bodyArray) {
        this.ended = true;
        this.responseArray = bodyArray;
        this.callEndHandler();
    }

    public void end(List<S> bodyList) {
        this.ended = true;
        this.responseList = bodyList;
        this.callEndHandler();
    }

    private void callEndHandler() {
        this.endHandler.onResponseEnded();
    }

    public void endHandler(ResponseEndHandler endHandler) {
        this.endHandler = endHandler;
    }

    public String getBodyString() {
        return this.bodyString;
    }

    public boolean isEnded() {
        return this.ended;
    }

    public MultiMap<String, String> getHeaders() {
        return this.headers;
    }

    public S getResponseBean() {
        return this.responseBean;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public S[] getResponseArray() {
        return this.responseArray;
    }

    public List<S> getResponseList() {
        return this.responseList;
    }
}

