/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.domino.service.discovery;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceReference;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.dominokit.domino.service.discovery.type.EventBusServiceDiscovery;
import org.dominokit.domino.service.discovery.type.HttpServiceDiscovery;
import org.dominokit.domino.service.discovery.type.JDBCServiceDiscovery;
import org.dominokit.domino.service.discovery.type.MessageSourceServiceDiscovery;
import org.dominokit.domino.service.discovery.type.MongoServiceDiscovery;
import org.dominokit.domino.service.discovery.type.RedisServiceDiscovery;

public class VertxServiceDiscovery {
    private ServiceDiscovery serviceDiscovery;

    public VertxServiceDiscovery(Vertx vertx) {
        this.serviceDiscovery = ServiceDiscovery.create((Vertx)vertx);
    }

    public ServiceDiscovery serviceDiscovery() {
        return this.serviceDiscovery;
    }

    public HttpServiceDiscovery http() {
        return new HttpServiceDiscovery(this.serviceDiscovery);
    }

    public EventBusServiceDiscovery eventBus() {
        return new EventBusServiceDiscovery(this.serviceDiscovery);
    }

    public MessageSourceServiceDiscovery messageSource() {
        return new MessageSourceServiceDiscovery(this.serviceDiscovery);
    }

    public JDBCServiceDiscovery jdbc() {
        return new JDBCServiceDiscovery(this.serviceDiscovery);
    }

    public RedisServiceDiscovery redis() {
        return new RedisServiceDiscovery(this.serviceDiscovery);
    }

    public MongoServiceDiscovery mongo() {
        return new MongoServiceDiscovery(this.serviceDiscovery);
    }

    public void unpublish(Record record, Handler<AsyncResult<Void>> handler) {
        this.serviceDiscovery.unpublish(record.getRegistration(), handler);
    }

    public void publishRecord(Record record, Handler<AsyncResult<Record>> handler) {
        this.serviceDiscovery.publish(record, handler);
    }

    public void lookup(Function<Record, Boolean> filter, Handler<AsyncResult<Record>> handler) {
        this.lookup(filter, false, handler);
    }

    public void lookupIncludeOutOfService(Function<Record, Boolean> filter, Handler<AsyncResult<Record>> handler) {
        this.lookup(filter, true, handler);
    }

    private void lookup(Function<Record, Boolean> filter, boolean includeOutOfService, Handler<AsyncResult<Record>> handler) {
        if (Objects.isNull(filter)) {
            throw new InvalidFilterException();
        }
        this.serviceDiscovery.getRecord(filter, includeOutOfService, handler);
    }

    public void lookupByJson(JsonObject jsonFilter, Handler<AsyncResult<Record>> handler) {
        this.serviceDiscovery.getRecord(jsonFilter, handler);
    }

    public void lookupAll(Function<Record, Boolean> filter, Handler<AsyncResult<List<Record>>> handler) {
        this.lookupAll(filter, false, handler);
    }

    public void lookupAllIncludeOutOfService(Function<Record, Boolean> filter, Handler<AsyncResult<List<Record>>> handler) {
        this.lookupAll(filter, true, handler);
    }

    private void lookupAll(Function<Record, Boolean> filter, boolean includeOutOfService, Handler<AsyncResult<List<Record>>> handler) {
        if (Objects.isNull(filter)) {
            throw new InvalidFilterException();
        }
        this.serviceDiscovery.getRecords(filter, includeOutOfService, handler);
    }

    public void lookupAllByJson(JsonObject jsonFilter, Handler<AsyncResult<List<Record>>> handler) {
        this.serviceDiscovery.getRecords(jsonFilter, handler);
    }

    public ServiceReference lookupForAReference(Record record) {
        return this.serviceDiscovery.getReference(record);
    }

    public ServiceReference lookupForAReferenceWithConfiguration(Record record, JsonObject configuration) {
        return this.serviceDiscovery.getReferenceWithConfiguration(record, configuration);
    }

    public void releaseServiceObject(Object object) {
        ServiceDiscovery.releaseServiceObject((ServiceDiscovery)this.serviceDiscovery, (Object)object);
    }

    public static class InvalidFilterException
    extends RuntimeException {
    }
}

