/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.domino.service.discovery.configuration;

import io.vertx.core.json.JsonObject;
import java.util.Objects;

public abstract class BaseServiceConfiguration {
    private final String name;
    protected JsonObject metadata;

    BaseServiceConfiguration(String name) {
        if (!this.isValid(name)) {
            throw new InvalidServiceNameException();
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected boolean isValid(String value) {
        return Objects.nonNull(value) && !value.trim().isEmpty();
    }

    public JsonObject getMetadata() {
        return this.metadata;
    }

    public abstract <T extends BaseServiceConfiguration> T metadata(JsonObject var1);

    public static class InvalidServiceNameException
    extends RuntimeException {
    }
}

