/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.domino.service.discovery.configuration;

import io.vertx.core.json.JsonObject;
import org.dominokit.domino.service.discovery.configuration.BaseServiceConfiguration;

public class HttpEndpointConfiguration
extends BaseServiceConfiguration {
    private final String host;
    private String root = "/";
    private int port = 80;
    private boolean ssl = false;

    public HttpEndpointConfiguration(String name, String host) {
        super(name);
        if (!this.isValid(host)) {
            throw new InvalidHttpEndpointHostException();
        }
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public HttpEndpointConfiguration root(String root) {
        this.root = root;
        return this;
    }

    public HttpEndpointConfiguration port(int port) {
        this.port = port;
        return this;
    }

    public HttpEndpointConfiguration ssl(boolean ssl) {
        this.ssl = ssl;
        return this;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public String getRoot() {
        return this.root;
    }

    public int getPort() {
        return this.port;
    }

    public HttpEndpointConfiguration metadata(JsonObject metadata) {
        this.metadata = metadata;
        return this;
    }

    public static class InvalidHttpEndpointHostException
    extends RuntimeException {
    }
}

