/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.domino.service.discovery.type;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.types.EventBusService;
import java.util.function.Function;
import org.dominokit.domino.service.discovery.configuration.EventBusServiceConfiguration;

public class EventBusServiceDiscovery {
    private final ServiceDiscovery serviceDiscovery;

    public EventBusServiceDiscovery(ServiceDiscovery serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
    }

    public void publish(EventBusServiceConfiguration configuration, Handler<AsyncResult<Record>> handler) {
        this.serviceDiscovery.publish(this.createEventBusRecord(configuration), handler);
    }

    private Record createEventBusRecord(EventBusServiceConfiguration configuration) {
        return EventBusService.createRecord((String)configuration.getName(), (String)configuration.getAddress(), configuration.getServiceClass(), (JsonObject)configuration.getMetadata());
    }

    public <T> void getProxy(Class<T> serviceClass, Handler<AsyncResult<T>> handler) {
        EventBusService.getProxy((ServiceDiscovery)this.serviceDiscovery, serviceClass, handler);
    }

    public <T> void getServiceProxy(Function<Record, Boolean> filter, Class<T> serviceClass, Handler<AsyncResult<T>> handler) {
        EventBusService.getServiceProxy((ServiceDiscovery)this.serviceDiscovery, filter, serviceClass, handler);
    }

    public <T> void getServiceProxy(JsonObject jsonFilter, Class<T> serviceClass, Handler<AsyncResult<T>> handler) {
        EventBusService.getServiceProxyWithJsonFilter((ServiceDiscovery)this.serviceDiscovery, (JsonObject)jsonFilter, serviceClass, handler);
    }
}

