/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.domino.service.discovery.type;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpClient;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.WebClient;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.types.HttpEndpoint;
import java.util.function.Function;
import org.dominokit.domino.service.discovery.configuration.HttpEndpointConfiguration;

public class HttpServiceDiscovery {
    private final ServiceDiscovery serviceDiscovery;

    public HttpServiceDiscovery(ServiceDiscovery serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
    }

    public void publish(HttpEndpointConfiguration configuration, Handler<AsyncResult<Record>> handler) {
        this.serviceDiscovery.publish(this.createHttpEndpointRecord(configuration), handler);
    }

    private Record createHttpEndpointRecord(HttpEndpointConfiguration configuration) {
        return HttpEndpoint.createRecord((String)configuration.getName(), (boolean)configuration.isSsl(), (String)configuration.getHost(), (int)configuration.getPort(), (String)configuration.getRoot(), (JsonObject)configuration.getMetadata());
    }

    public void getHttpClient(Function<Record, Boolean> filter, Handler<AsyncResult<HttpClient>> handler) {
        HttpEndpoint.getClient((ServiceDiscovery)this.serviceDiscovery, filter, handler);
    }

    public void getHttpClient(Function<Record, Boolean> filter, JsonObject configuration, Handler<AsyncResult<HttpClient>> handler) {
        HttpEndpoint.getClient((ServiceDiscovery)this.serviceDiscovery, filter, (JsonObject)configuration, handler);
    }

    public void getHttpClient(JsonObject jsonFilter, Handler<AsyncResult<HttpClient>> handler) {
        HttpEndpoint.getClient((ServiceDiscovery)this.serviceDiscovery, (JsonObject)jsonFilter, handler);
    }

    public void getHttpClient(JsonObject jsonFilter, JsonObject configuration, Handler<AsyncResult<HttpClient>> handler) {
        HttpEndpoint.getClient((ServiceDiscovery)this.serviceDiscovery, (JsonObject)jsonFilter, (JsonObject)configuration, handler);
    }

    public void getWebClient(Function<Record, Boolean> filter, Handler<AsyncResult<WebClient>> handler) {
        HttpEndpoint.getWebClient((ServiceDiscovery)this.serviceDiscovery, filter, handler);
    }

    public void getWebClient(Function<Record, Boolean> filter, JsonObject configuration, Handler<AsyncResult<WebClient>> handler) {
        HttpEndpoint.getWebClient((ServiceDiscovery)this.serviceDiscovery, filter, (JsonObject)configuration, handler);
    }

    public void getWebClient(JsonObject jsonFilter, Handler<AsyncResult<WebClient>> handler) {
        HttpEndpoint.getWebClient((ServiceDiscovery)this.serviceDiscovery, (JsonObject)jsonFilter, handler);
    }

    public void getWebClient(JsonObject jsonFilter, JsonObject configuration, Handler<AsyncResult<WebClient>> handler) {
        HttpEndpoint.getWebClient((ServiceDiscovery)this.serviceDiscovery, (JsonObject)jsonFilter, (JsonObject)configuration, handler);
    }
}

