/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.domino.service.discovery.type;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.types.MessageSource;
import java.util.function.Function;
import org.dominokit.domino.service.discovery.configuration.MessageSourceConfiguration;

public class MessageSourceServiceDiscovery {
    private final ServiceDiscovery serviceDiscovery;

    public MessageSourceServiceDiscovery(ServiceDiscovery serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
    }

    public void publish(MessageSourceConfiguration configuration, Handler<AsyncResult<Record>> handler) {
        this.serviceDiscovery.publish(this.createMessageSourceRecord(configuration), handler);
    }

    private Record createMessageSourceRecord(MessageSourceConfiguration configuration) {
        return MessageSource.createRecord((String)configuration.getName(), (String)configuration.getAddress(), configuration.getMessageType(), (JsonObject)configuration.getMetadata());
    }

    public <T> void getConsumer(Function<Record, Boolean> filter, Handler<AsyncResult<MessageConsumer<T>>> handler) {
        MessageSource.getConsumer((ServiceDiscovery)this.serviceDiscovery, filter, handler);
    }

    public <T> void getConsumer(JsonObject jsonFilter, Handler<AsyncResult<MessageConsumer<T>>> handler) {
        MessageSource.getConsumer((ServiceDiscovery)this.serviceDiscovery, (JsonObject)jsonFilter, handler);
    }
}

