/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.domino.service.discovery.type;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.types.MongoDataSource;
import java.util.function.Function;
import org.dominokit.domino.service.discovery.configuration.DataSourceServiceConfiguration;

public class MongoServiceDiscovery {
    private final ServiceDiscovery serviceDiscovery;

    public MongoServiceDiscovery(ServiceDiscovery serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
    }

    public void publish(DataSourceServiceConfiguration configuration, Handler<AsyncResult<Record>> handler) {
        this.serviceDiscovery.publish(this.createMongoRecord(configuration), handler);
    }

    private Record createMongoRecord(DataSourceServiceConfiguration configuration) {
        return MongoDataSource.createRecord((String)configuration.getName(), (JsonObject)configuration.getLocation(), (JsonObject)configuration.getMetadata());
    }

    public void getClient(Function<Record, Boolean> filter, Handler<AsyncResult<MongoClient>> handler) {
        MongoDataSource.getMongoClient((ServiceDiscovery)this.serviceDiscovery, filter, handler);
    }

    public void getClient(JsonObject jsonFilter, Handler<AsyncResult<MongoClient>> handler) {
        MongoDataSource.getMongoClient((ServiceDiscovery)this.serviceDiscovery, (JsonObject)jsonFilter, handler);
    }

    public void getClient(JsonObject jsonFilter, JsonObject configuration, Handler<AsyncResult<MongoClient>> handler) {
        MongoDataSource.getMongoClient((ServiceDiscovery)this.serviceDiscovery, (JsonObject)jsonFilter, (JsonObject)configuration, handler);
    }
}

