/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.domino.service.discovery.type;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.RedisClient;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.types.RedisDataSource;
import java.util.function.Function;
import org.dominokit.domino.service.discovery.configuration.DataSourceServiceConfiguration;

public class RedisServiceDiscovery {
    private final ServiceDiscovery serviceDiscovery;

    public RedisServiceDiscovery(ServiceDiscovery serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
    }

    public void publish(DataSourceServiceConfiguration configuration, Handler<AsyncResult<Record>> handler) {
        this.serviceDiscovery.publish(this.createRedisRecord(configuration), handler);
    }

    private Record createRedisRecord(DataSourceServiceConfiguration configuration) {
        return RedisDataSource.createRecord((String)configuration.getName(), (JsonObject)configuration.getLocation(), (JsonObject)configuration.getMetadata());
    }

    public void getClient(Function<Record, Boolean> filter, Handler<AsyncResult<RedisClient>> handler) {
        RedisDataSource.getRedisClient((ServiceDiscovery)this.serviceDiscovery, filter, handler);
    }

    public void getClient(Function<Record, Boolean> filter, JsonObject configuration, Handler<AsyncResult<RedisClient>> handler) {
        RedisDataSource.getRedisClient((ServiceDiscovery)this.serviceDiscovery, filter, (JsonObject)configuration, handler);
    }

    public void getClient(JsonObject jsonFilter, Handler<AsyncResult<RedisClient>> handler) {
        RedisDataSource.getRedisClient((ServiceDiscovery)this.serviceDiscovery, (JsonObject)jsonFilter, handler);
    }

    public void getClient(JsonObject jsonFilter, JsonObject configuration, Handler<AsyncResult<RedisClient>> handler) {
        RedisDataSource.getRedisClient((ServiceDiscovery)this.serviceDiscovery, (JsonObject)jsonFilter, (JsonObject)configuration, handler);
    }
}

