/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.domino.http.server.config;

import com.google.auto.service.AutoService;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.JksOptions;
import org.dominokit.domino.api.server.config.HttpServerConfigurator;
import org.dominokit.domino.api.server.config.ServerConfiguration;
import org.dominokit.domino.api.server.entrypoint.VertxContext;

@AutoService(value={HttpServerConfigurator.class})
public class JksServerConfigurator
implements HttpServerConfigurator {
    public void configureHttpServer(VertxContext context, HttpServerOptions options) {
        if (this.jksEnabled(context.config())) {
            this.applyConfigurations(context.config(), options);
        }
    }

    private boolean jksEnabled(ServerConfiguration config) {
        return config.getBoolean("ssl.jks.enabled", Boolean.valueOf(false));
    }

    private void applyConfigurations(ServerConfiguration configuration, HttpServerOptions options) {
        this.validateConfiguration(configuration);
        if (this.sslEnabled(configuration).booleanValue()) {
            this.enableSsl(configuration, options);
        }
    }

    private void enableSsl(ServerConfiguration configuration, HttpServerOptions options) {
        options.setSsl(Boolean.TRUE.booleanValue());
        options.setHost("localhost");
        options.setKeyStoreOptions(new JksOptions().setPath(this.getPath(configuration)).setPassword(this.getSecret(configuration))).setPort(this.getPort(configuration));
    }

    private String getPath(ServerConfiguration configuration) {
        return configuration.getString("ssl.jks.path");
    }

    private String getSecret(ServerConfiguration configuration) {
        return configuration.getString("ssl.jks.password");
    }

    private int getPort(ServerConfiguration configuration) {
        return configuration.getInteger("https.port", Integer.valueOf(443));
    }

    private void validateConfiguration(ServerConfiguration configuration) {
        if (this.sslEnabled(configuration).booleanValue()) {
            this.validateSslPathAndPassword(configuration);
        }
    }

    private Boolean sslEnabled(ServerConfiguration configuration) {
        return configuration.getBoolean("ssl.enabled", Boolean.valueOf(false));
    }

    private void validateSslPathAndPassword(ServerConfiguration configuration) {
        if (this.missingSslJksPath(configuration)) {
            throw new MissingJksPathInConfigurationException();
        }
        if (this.missingSslJksPassword(configuration)) {
            throw new MissingJksPasswordInConfigurationException();
        }
    }

    private boolean missingSslJksPath(ServerConfiguration configuration) {
        return configuration.getString("ssl.jks.path", "").isEmpty();
    }

    private boolean missingSslJksPassword(ServerConfiguration configuration) {
        return configuration.getString("ssl.jks.password", "").isEmpty();
    }

    class MissingJksPasswordInConfigurationException
    extends RuntimeException {
        MissingJksPasswordInConfigurationException() {
        }
    }

    class MissingJksPathInConfigurationException
    extends RuntimeException {
        MissingJksPathInConfigurationException() {
        }
    }
}

