/*
 * Copyright © 2019 Dominokit
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dominokit.domino.ui.style;

import org.dominokit.domino.ui.themes.Theme;

public interface Color {

  String getStyle();

  String getName();

  String getHex();

  String getBackground();

  Color RED =
      new Color() {
        @Override
        public String getStyle() {
          return "col-red";
        }

        @Override
        public String getName() {
          return "RED";
        }

        @Override
        public String getHex() {
          return "#F44336";
        }

        @Override
        public String getBackground() {
          return "bg-red";
        }
      };

  Color RED_LIGHTEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-1-red";
        }

        @Override
        public String getName() {
          return "RED LIGHTEN 1";
        }

        @Override
        public String getHex() {
          return "#ef5350";
        }

        @Override
        public String getBackground() {
          return "bg-l-1-red";
        }
      };

  Color RED_LIGHTEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-2-red";
        }

        @Override
        public String getName() {
          return "RED LIGHTEN 2";
        }

        @Override
        public String getHex() {
          return "#e57373";
        }

        @Override
        public String getBackground() {
          return "bg-l-2-red";
        }
      };

  Color RED_LIGHTEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-3-red";
        }

        @Override
        public String getName() {
          return "RED LIGHTEN 3";
        }

        @Override
        public String getHex() {
          return "#ef9a9a";
        }

        @Override
        public String getBackground() {
          return "bg-l-3-red";
        }
      };

  Color RED_LIGHTEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-4-red";
        }

        @Override
        public String getName() {
          return "RED LIGHTEN 4";
        }

        @Override
        public String getHex() {
          return "#ffcdd2";
        }

        @Override
        public String getBackground() {
          return "bg-l-4-red";
        }
      };

  Color RED_LIGHTEN_5 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-5-red";
        }

        @Override
        public String getName() {
          return "RED LIGHTEN 5";
        }

        @Override
        public String getHex() {
          return "#ffebee";
        }

        @Override
        public String getBackground() {
          return "bg-l-5-red";
        }
      };

  Color RED_DARKEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-1-red";
        }

        @Override
        public String getName() {
          return "RED DARKEN 1";
        }

        @Override
        public String getHex() {
          return "#e53935";
        }

        @Override
        public String getBackground() {
          return "bg-d-1-red";
        }
      };

  Color RED_DARKEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-2-red";
        }

        @Override
        public String getName() {
          return "RED DARKEN 2";
        }

        @Override
        public String getHex() {
          return "#d32f2f";
        }

        @Override
        public String getBackground() {
          return "bg-d-2-red";
        }
      };

  Color RED_DARKEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-3-red";
        }

        @Override
        public String getName() {
          return "RED DARKEN 3";
        }

        @Override
        public String getHex() {
          return "#c62828";
        }

        @Override
        public String getBackground() {
          return "bg-d-3-red";
        }
      };

  Color RED_DARKEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-4-red";
        }

        @Override
        public String getName() {
          return "RED DARKEN 4";
        }

        @Override
        public String getHex() {
          return "#b71c1c";
        }

        @Override
        public String getBackground() {
          return "bg-d-4-red";
        }
      };

  Color PINK =
      new Color() {
        @Override
        public String getStyle() {
          return "col-pink";
        }

        @Override
        public String getName() {
          return "PINK";
        }

        @Override
        public String getHex() {
          return "#E91E63";
        }

        @Override
        public String getBackground() {
          return "bg-pink";
        }
      };

  Color PINK_LIGHTEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-1-pink";
        }

        @Override
        public String getName() {
          return "PINK LIGHTEN 1";
        }

        @Override
        public String getHex() {
          return "#ec407a";
        }

        @Override
        public String getBackground() {
          return "bg-l-1-pink";
        }
      };

  Color PINK_LIGHTEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-2-pink";
        }

        @Override
        public String getName() {
          return "PINK LIGHTEN 2";
        }

        @Override
        public String getHex() {
          return "#f06292";
        }

        @Override
        public String getBackground() {
          return "bg-l-2-pink";
        }
      };

  Color PINK_LIGHTEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-3-pink";
        }

        @Override
        public String getName() {
          return "PINK LIGHTEN 3";
        }

        @Override
        public String getHex() {
          return "#f48fb1";
        }

        @Override
        public String getBackground() {
          return "bg-l-3-pink";
        }
      };

  Color PINK_LIGHTEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-4-pink";
        }

        @Override
        public String getName() {
          return "PINK LIGHTEN 4";
        }

        @Override
        public String getHex() {
          return "#f8bbd0";
        }

        @Override
        public String getBackground() {
          return "bg-l-4-pink";
        }
      };

  Color PINK_LIGHTEN_5 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-5-pink";
        }

        @Override
        public String getName() {
          return "PINK LIGHTEN 5";
        }

        @Override
        public String getHex() {
          return "#fce4ec";
        }

        @Override
        public String getBackground() {
          return "bg-l-5-pink";
        }
      };

  Color PINK_DARKEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-1-pink";
        }

        @Override
        public String getName() {
          return "PINK DARKEN 1";
        }

        @Override
        public String getHex() {
          return "#d81b60";
        }

        @Override
        public String getBackground() {
          return "bg-d-1-pink";
        }
      };

  Color PINK_DARKEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-2-pink";
        }

        @Override
        public String getName() {
          return "PINK DARKEN 2";
        }

        @Override
        public String getHex() {
          return "#c2185b";
        }

        @Override
        public String getBackground() {
          return "bg-d-2-pink";
        }
      };

  Color PINK_DARKEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-3-pink";
        }

        @Override
        public String getName() {
          return "PINK DARKEN 3";
        }

        @Override
        public String getHex() {
          return "#ad1457";
        }

        @Override
        public String getBackground() {
          return "bg-d-3-pink";
        }
      };

  Color PINK_DARKEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-4-pink";
        }

        @Override
        public String getName() {
          return "PINK DARKEN 4";
        }

        @Override
        public String getHex() {
          return "#880e4f";
        }

        @Override
        public String getBackground() {
          return "bg-d-4-pink";
        }
      };

  Color PURPLE =
      new Color() {
        @Override
        public String getStyle() {
          return "col-purple";
        }

        @Override
        public String getName() {
          return "PURPLE";
        }

        @Override
        public String getHex() {
          return "#9C27B0";
        }

        @Override
        public String getBackground() {
          return "bg-purple";
        }
      };

  Color PURPLE_LIGHTEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-1-purple";
        }

        @Override
        public String getName() {
          return "PURPLE LIGHTEN 1";
        }

        @Override
        public String getHex() {
          return "#ab47bc";
        }

        @Override
        public String getBackground() {
          return "bg-l-1-purple";
        }
      };

  Color PURPLE_LIGHTEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-2-purple";
        }

        @Override
        public String getName() {
          return "PURPLE LIGHTEN 2";
        }

        @Override
        public String getHex() {
          return "#ba68c8";
        }

        @Override
        public String getBackground() {
          return "bg-l-2-purple";
        }
      };

  Color PURPLE_LIGHTEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-3-purple";
        }

        @Override
        public String getName() {
          return "PURPLE LIGHTEN 3";
        }

        @Override
        public String getHex() {
          return "#ce93d8";
        }

        @Override
        public String getBackground() {
          return "bg-l-3-purple";
        }
      };

  Color PURPLE_LIGHTEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-4-purple";
        }

        @Override
        public String getName() {
          return "PURPLE LIGHTEN 4";
        }

        @Override
        public String getHex() {
          return "#e1bee7";
        }

        @Override
        public String getBackground() {
          return "bg-l-4-purple";
        }
      };

  Color PURPLE_LIGHTEN_5 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-5-purple";
        }

        @Override
        public String getName() {
          return "PURPLE LIGHTEN 5";
        }

        @Override
        public String getHex() {
          return "#f3e5f5";
        }

        @Override
        public String getBackground() {
          return "bg-l-5-purple";
        }
      };

  Color PURPLE_DARKEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-1-purple";
        }

        @Override
        public String getName() {
          return "PURPLE DARKEN 1";
        }

        @Override
        public String getHex() {
          return "#8e24aa";
        }

        @Override
        public String getBackground() {
          return "bg-d-1-purple";
        }
      };

  Color PURPLE_DARKEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-2-purple";
        }

        @Override
        public String getName() {
          return "PURPLE DARKEN 2";
        }

        @Override
        public String getHex() {
          return "#7b1fa2";
        }

        @Override
        public String getBackground() {
          return "bg-d-2-purple";
        }
      };

  Color PURPLE_DARKEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-3-purple";
        }

        @Override
        public String getName() {
          return "PURPLE DARKEN 3";
        }

        @Override
        public String getHex() {
          return "#6a1b9a";
        }

        @Override
        public String getBackground() {
          return "bg-d-3-purple";
        }
      };

  Color PURPLE_DARKEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-4-purple";
        }

        @Override
        public String getName() {
          return "PURPLE DARKEN 4";
        }

        @Override
        public String getHex() {
          return "#4a148c";
        }

        @Override
        public String getBackground() {
          return "bg-d-4-purple";
        }
      };

  Color DEEP_PURPLE =
      new Color() {
        @Override
        public String getStyle() {
          return "col-deep-purple";
        }

        @Override
        public String getName() {
          return "DEEP PURPLE";
        }

        @Override
        public String getHex() {
          return "#673AB7";
        }

        @Override
        public String getBackground() {
          return "bg-deep-purple";
        }
      };

  Color DEEP_PURPLE_LIGHTEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-1-deep-purple";
        }

        @Override
        public String getName() {
          return "DEEP PURPLE LIGHTEN 1";
        }

        @Override
        public String getHex() {
          return "#7e57c2";
        }

        @Override
        public String getBackground() {
          return "bg-l-1-deep-purple";
        }
      };

  Color DEEP_PURPLE_LIGHTEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-2-deep-purple";
        }

        @Override
        public String getName() {
          return "DEEP PURPLE LIGHTEN 2";
        }

        @Override
        public String getHex() {
          return "#9575cd";
        }

        @Override
        public String getBackground() {
          return "bg-l-2-deep-purple";
        }
      };

  Color DEEP_PURPLE_LIGHTEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-3-deep-purple";
        }

        @Override
        public String getName() {
          return "DEEP PURPLE LIGHTEN 3";
        }

        @Override
        public String getHex() {
          return "#b39ddb";
        }

        @Override
        public String getBackground() {
          return "bg-l-3-deep-purple";
        }
      };

  Color DEEP_PURPLE_LIGHTEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-4-deep-purple";
        }

        @Override
        public String getName() {
          return "DEEP PURPLE LIGHTEN 4";
        }

        @Override
        public String getHex() {
          return "#d1c4e9";
        }

        @Override
        public String getBackground() {
          return "bg-l-4-deep-purple";
        }
      };

  Color DEEP_PURPLE_LIGHTEN_5 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-5-deep-purple";
        }

        @Override
        public String getName() {
          return "DEEP PURPLE LIGHTEN 5";
        }

        @Override
        public String getHex() {
          return "#ede7f6";
        }

        @Override
        public String getBackground() {
          return "bg-l-5-deep-purple";
        }
      };

  Color DEEP_PURPLE_DARKEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-1-deep-purple";
        }

        @Override
        public String getName() {
          return "DEEP PURPLE DARKEN 1";
        }

        @Override
        public String getHex() {
          return "#5e35b1";
        }

        @Override
        public String getBackground() {
          return "bg-d-1-deep-purple";
        }
      };

  Color DEEP_PURPLE_DARKEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-2-deep-purple";
        }

        @Override
        public String getName() {
          return "DEEP PURPLE DARKEN 2";
        }

        @Override
        public String getHex() {
          return "#512da8";
        }

        @Override
        public String getBackground() {
          return "bg-d-2-deep-purple";
        }
      };

  Color DEEP_PURPLE_DARKEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-3-deep-purple";
        }

        @Override
        public String getName() {
          return "DEEP PURPLE DARKEN 3";
        }

        @Override
        public String getHex() {
          return "#4527a0";
        }

        @Override
        public String getBackground() {
          return "bg-d-3-deep-purple";
        }
      };

  Color DEEP_PURPLE_DARKEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-4-deep-purple";
        }

        @Override
        public String getName() {
          return "DEEP PURPLE DARKEN 4";
        }

        @Override
        public String getHex() {
          return "#311b92";
        }

        @Override
        public String getBackground() {
          return "bg-d-4-deep-purple";
        }
      };

  Color INDIGO =
      new Color() {
        @Override
        public String getStyle() {
          return "col-indigo";
        }

        @Override
        public String getName() {
          return "INDIGO";
        }

        @Override
        public String getHex() {
          return "#3F51B5";
        }

        @Override
        public String getBackground() {
          return "bg-indigo";
        }
      };

  Color INDIGO_LIGHTEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-1-indigo";
        }

        @Override
        public String getName() {
          return "INDIGO LIGHTEN 1";
        }

        @Override
        public String getHex() {
          return "#5c6bc0";
        }

        @Override
        public String getBackground() {
          return "bg-l-1-indigo";
        }
      };

  Color INDIGO_LIGHTEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-2-indigo";
        }

        @Override
        public String getName() {
          return "INDIGO LIGHTEN 2";
        }

        @Override
        public String getHex() {
          return "#7986cb";
        }

        @Override
        public String getBackground() {
          return "bg-l-2-indigo";
        }
      };

  Color INDIGO_LIGHTEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-3-indigo";
        }

        @Override
        public String getName() {
          return "INDIGO LIGHTEN 3";
        }

        @Override
        public String getHex() {
          return "#9fa8da";
        }

        @Override
        public String getBackground() {
          return "bg-l-3-indigo";
        }
      };

  Color INDIGO_LIGHTEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-4-indigo";
        }

        @Override
        public String getName() {
          return "INDIGO LIGHTEN 4";
        }

        @Override
        public String getHex() {
          return "#c5cae9";
        }

        @Override
        public String getBackground() {
          return "bg-l-4-indigo";
        }
      };

  Color INDIGO_LIGHTEN_5 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-5-indigo";
        }

        @Override
        public String getName() {
          return "INDIGO LIGHTEN 5";
        }

        @Override
        public String getHex() {
          return "#e8eaf6";
        }

        @Override
        public String getBackground() {
          return "bg-l-5-indigo";
        }
      };

  Color INDIGO_DARKEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-1-indigo";
        }

        @Override
        public String getName() {
          return "INDIGO DARKEN 1";
        }

        @Override
        public String getHex() {
          return "#3949ab";
        }

        @Override
        public String getBackground() {
          return "bg-d-1-indigo";
        }
      };

  Color INDIGO_DARKEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-2-indigo";
        }

        @Override
        public String getName() {
          return "INDIGO DARKEN 2";
        }

        @Override
        public String getHex() {
          return "#303f9f";
        }

        @Override
        public String getBackground() {
          return "bg-d-2-indigo";
        }
      };

  Color INDIGO_DARKEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-3-indigo";
        }

        @Override
        public String getName() {
          return "INDIGO DARKEN 3";
        }

        @Override
        public String getHex() {
          return "#283593";
        }

        @Override
        public String getBackground() {
          return "bg-d-3-indigo";
        }
      };

  Color INDIGO_DARKEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-4-indigo";
        }

        @Override
        public String getName() {
          return "INDIGO DARKEN 4";
        }

        @Override
        public String getHex() {
          return "#1a237e";
        }

        @Override
        public String getBackground() {
          return "bg-d-4-indigo";
        }
      };

  Color BLUE =
      new Color() {
        @Override
        public String getStyle() {
          return "col-blue";
        }

        @Override
        public String getName() {
          return "BLUE";
        }

        @Override
        public String getHex() {
          return "#2196F3";
        }

        @Override
        public String getBackground() {
          return "bg-blue";
        }
      };

  Color BLUE_LIGHTEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-1-blue";
        }

        @Override
        public String getName() {
          return "BLUE LIGHTEN 1";
        }

        @Override
        public String getHex() {
          return "#42a5f5";
        }

        @Override
        public String getBackground() {
          return "bg-l-1-blue";
        }
      };

  Color BLUE_LIGHTEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-2-blue";
        }

        @Override
        public String getName() {
          return "BLUE LIGHTEN 2";
        }

        @Override
        public String getHex() {
          return "#64b5f6";
        }

        @Override
        public String getBackground() {
          return "bg-l-2-blue";
        }
      };

  Color BLUE_LIGHTEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-3-blue";
        }

        @Override
        public String getName() {
          return "BLUE LIGHTEN 3";
        }

        @Override
        public String getHex() {
          return "#90caf9";
        }

        @Override
        public String getBackground() {
          return "bg-l-3-blue";
        }
      };

  Color BLUE_LIGHTEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-4-blue";
        }

        @Override
        public String getName() {
          return "BLUE LIGHTEN 4";
        }

        @Override
        public String getHex() {
          return "#bbdefb";
        }

        @Override
        public String getBackground() {
          return "bg-l-4-blue";
        }
      };

  Color BLUE_LIGHTEN_5 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-5-blue";
        }

        @Override
        public String getName() {
          return "BLUE LIGHTEN 5";
        }

        @Override
        public String getHex() {
          return "#e3f2fd";
        }

        @Override
        public String getBackground() {
          return "bg-l-5-blue";
        }
      };

  Color BLUE_DARKEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-1-blue";
        }

        @Override
        public String getName() {
          return "BLUE DARKEN 1";
        }

        @Override
        public String getHex() {
          return "#1e88e5";
        }

        @Override
        public String getBackground() {
          return "bg-d-1-blue";
        }
      };

  Color BLUE_DARKEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-2-blue";
        }

        @Override
        public String getName() {
          return "BLUE DARKEN 2";
        }

        @Override
        public String getHex() {
          return "#1976d2";
        }

        @Override
        public String getBackground() {
          return "bg-d-2-blue";
        }
      };

  Color BLUE_DARKEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-3-blue";
        }

        @Override
        public String getName() {
          return "BLUE DARKEN 3";
        }

        @Override
        public String getHex() {
          return "#1565c0";
        }

        @Override
        public String getBackground() {
          return "bg-d-3-blue";
        }
      };

  Color BLUE_DARKEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-4-blue";
        }

        @Override
        public String getName() {
          return "BLUE DARKEN 4";
        }

        @Override
        public String getHex() {
          return "#0d47a1";
        }

        @Override
        public String getBackground() {
          return "bg-d-4-blue";
        }
      };

  Color LIGHT_BLUE =
      new Color() {
        @Override
        public String getStyle() {
          return "col-light-blue";
        }

        @Override
        public String getName() {
          return "LIGHT BLUE";
        }

        @Override
        public String getHex() {
          return "#03A9F4";
        }

        @Override
        public String getBackground() {
          return "bg-blue";
        }
      };

  Color LIGHT_BLUE_LIGHTEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-1-light-blue";
        }

        @Override
        public String getName() {
          return "LIGHT BLUE LIGHTEN 1";
        }

        @Override
        public String getHex() {
          return "#29b6f6";
        }

        @Override
        public String getBackground() {
          return "bg-l-1-light-blue";
        }
      };

  Color LIGHT_BLUE_LIGHTEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-2-light-blue";
        }

        @Override
        public String getName() {
          return "LIGHT BLUE LIGHTEN 2";
        }

        @Override
        public String getHex() {
          return "#4fc3f7";
        }

        @Override
        public String getBackground() {
          return "bg-l-2-light-blue";
        }
      };

  Color LIGHT_BLUE_LIGHTEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-3-light-blue";
        }

        @Override
        public String getName() {
          return "LIGHT BLUE LIGHTEN 3";
        }

        @Override
        public String getHex() {
          return "#81d4fa";
        }

        @Override
        public String getBackground() {
          return "bg-l-3-light-blue";
        }
      };

  Color LIGHT_BLUE_LIGHTEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-4-light-blue";
        }

        @Override
        public String getName() {
          return "LIGHT BLUE LIGHTEN 4";
        }

        @Override
        public String getHex() {
          return "#b3e5fc";
        }

        @Override
        public String getBackground() {
          return "bg-l-4-light-blue";
        }
      };

  Color LIGHT_BLUE_LIGHTEN_5 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-5-light-blue";
        }

        @Override
        public String getName() {
          return "LIGHT BLUE LIGHTEN 5";
        }

        @Override
        public String getHex() {
          return "#e1f5fe";
        }

        @Override
        public String getBackground() {
          return "bg-l-5-light-blue";
        }
      };

  Color LIGHT_BLUE_DARKEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-1-light-blue";
        }

        @Override
        public String getName() {
          return "LIGHT BLUE DARKEN 1";
        }

        @Override
        public String getHex() {
          return "#039be5";
        }

        @Override
        public String getBackground() {
          return "bg-d-1-light-blue";
        }
      };

  Color LIGHT_BLUE_DARKEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-2-light-blue";
        }

        @Override
        public String getName() {
          return "LIGHT BLUE DARKEN 2";
        }

        @Override
        public String getHex() {
          return "#0288d1";
        }

        @Override
        public String getBackground() {
          return "bg-d-2-light-blue";
        }
      };

  Color LIGHT_BLUE_DARKEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-3-light-blue";
        }

        @Override
        public String getName() {
          return "LIGHT BLUE DARKEN 3";
        }

        @Override
        public String getHex() {
          return "#0277bd";
        }

        @Override
        public String getBackground() {
          return "bg-d-3-light-blue";
        }
      };

  Color LIGHT_BLUE_DARKEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-4-light-blue";
        }

        @Override
        public String getName() {
          return "LIGHT BLUE DARKEN 4";
        }

        @Override
        public String getHex() {
          return "#01579b";
        }

        @Override
        public String getBackground() {
          return "bg-d-4-light-blue";
        }
      };

  Color CYAN =
      new Color() {
        @Override
        public String getStyle() {
          return "col-cyan";
        }

        @Override
        public String getName() {
          return "CYAN";
        }

        @Override
        public String getHex() {
          return "#00BCD4";
        }

        @Override
        public String getBackground() {
          return "bg-cyan";
        }
      };

  Color CYAN_LIGHTEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-1-cyan";
        }

        @Override
        public String getName() {
          return "CYAN LIGHTEN 1";
        }

        @Override
        public String getHex() {
          return "#26c6da";
        }

        @Override
        public String getBackground() {
          return "bg-l-1-cyan";
        }
      };

  Color CYAN_LIGHTEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-2-cyan";
        }

        @Override
        public String getName() {
          return "CYAN LIGHTEN 2";
        }

        @Override
        public String getHex() {
          return "#4dd0e1";
        }

        @Override
        public String getBackground() {
          return "bg-l-2-cyan";
        }
      };

  Color CYAN_LIGHTEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-3-cyan";
        }

        @Override
        public String getName() {
          return "CYAN LIGHTEN 3";
        }

        @Override
        public String getHex() {
          return "#80deea";
        }

        @Override
        public String getBackground() {
          return "bg-l-3-cyan";
        }
      };

  Color CYAN_LIGHTEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-4-cyan";
        }

        @Override
        public String getName() {
          return "CYAN LIGHTEN 4";
        }

        @Override
        public String getHex() {
          return "#b2ebf2";
        }

        @Override
        public String getBackground() {
          return "bg-l-4-cyan";
        }
      };

  Color CYAN_LIGHTEN_5 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-5-cyan";
        }

        @Override
        public String getName() {
          return "CYAN LIGHTEN 5";
        }

        @Override
        public String getHex() {
          return "#e0f7fa";
        }

        @Override
        public String getBackground() {
          return "bg-l-5-cyan";
        }
      };

  Color CYAN_DARKEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-1-cyan";
        }

        @Override
        public String getName() {
          return "CYAN DARKEN 1";
        }

        @Override
        public String getHex() {
          return "#00acc1";
        }

        @Override
        public String getBackground() {
          return "bg-d-1-cyan";
        }
      };

  Color CYAN_DARKEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-2-cyan";
        }

        @Override
        public String getName() {
          return "CYAN DARKEN 2";
        }

        @Override
        public String getHex() {
          return "#0097a7";
        }

        @Override
        public String getBackground() {
          return "bg-d-2-cyan";
        }
      };

  Color CYAN_DARKEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-3-cyan";
        }

        @Override
        public String getName() {
          return "CYAN DARKEN 3";
        }

        @Override
        public String getHex() {
          return "#00838f";
        }

        @Override
        public String getBackground() {
          return "bg-d-3-cyan";
        }
      };

  Color CYAN_DARKEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-4-cyan";
        }

        @Override
        public String getName() {
          return "CYAN DARKEN 4";
        }

        @Override
        public String getHex() {
          return "#006064";
        }

        @Override
        public String getBackground() {
          return "bg-d-4-cyan";
        }
      };

  Color TEAL =
      new Color() {
        @Override
        public String getStyle() {
          return "col-teal";
        }

        @Override
        public String getName() {
          return "TEAL";
        }

        @Override
        public String getHex() {
          return "#009688";
        }

        @Override
        public String getBackground() {
          return "bg-teal";
        }
      };

  Color TEAL_LIGHTEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-1-teal";
        }

        @Override
        public String getName() {
          return "TEAL LIGHTEN 1";
        }

        @Override
        public String getHex() {
          return "#26a69a";
        }

        @Override
        public String getBackground() {
          return "bg-l-1-teal";
        }
      };

  Color TEAL_LIGHTEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-2-teal";
        }

        @Override
        public String getName() {
          return "TEAL LIGHTEN 2";
        }

        @Override
        public String getHex() {
          return "#4db6ac";
        }

        @Override
        public String getBackground() {
          return "bg-l-2-teal";
        }
      };

  Color TEAL_LIGHTEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-3-teal";
        }

        @Override
        public String getName() {
          return "TEAL LIGHTEN 3";
        }

        @Override
        public String getHex() {
          return "#80cbc4";
        }

        @Override
        public String getBackground() {
          return "bg-l-3-teal";
        }
      };

  Color TEAL_LIGHTEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-4-teal";
        }

        @Override
        public String getName() {
          return "TEAL LIGHTEN 4";
        }

        @Override
        public String getHex() {
          return "#b2dfdb";
        }

        @Override
        public String getBackground() {
          return "bg-l-4-teal";
        }
      };

  Color TEAL_LIGHTEN_5 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-5-teal";
        }

        @Override
        public String getName() {
          return "TEAL LIGHTEN 5";
        }

        @Override
        public String getHex() {
          return "#e0f2f1";
        }

        @Override
        public String getBackground() {
          return "bg-l-5-teal";
        }
      };

  Color TEAL_DARKEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-1-teal";
        }

        @Override
        public String getName() {
          return "TEAL DARKEN 1";
        }

        @Override
        public String getHex() {
          return "#00897b";
        }

        @Override
        public String getBackground() {
          return "bg-d-1-teal";
        }
      };

  Color TEAL_DARKEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-2-teal";
        }

        @Override
        public String getName() {
          return "TEAL DARKEN 2";
        }

        @Override
        public String getHex() {
          return "#00796b";
        }

        @Override
        public String getBackground() {
          return "bg-d-2-teal";
        }
      };

  Color TEAL_DARKEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-3-teal";
        }

        @Override
        public String getName() {
          return "TEAL DARKEN 3";
        }

        @Override
        public String getHex() {
          return "#00695c";
        }

        @Override
        public String getBackground() {
          return "bg-d-3-teal";
        }
      };

  Color TEAL_DARKEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-4-teal";
        }

        @Override
        public String getName() {
          return "TEAL DARKEN 4";
        }

        @Override
        public String getHex() {
          return "#004d40";
        }

        @Override
        public String getBackground() {
          return "bg-d-4-teal";
        }
      };

  Color GREEN =
      new Color() {
        @Override
        public String getStyle() {
          return "col-green";
        }

        @Override
        public String getName() {
          return "GREEN";
        }

        @Override
        public String getHex() {
          return "#4CAF50";
        }

        @Override
        public String getBackground() {
          return "bg-green";
        }
      };

  Color GREEN_LIGHTEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-1-green";
        }

        @Override
        public String getName() {
          return "GREEN LIGHTEN 1";
        }

        @Override
        public String getHex() {
          return "#66bb6a";
        }

        @Override
        public String getBackground() {
          return "bg-l-1-green";
        }
      };

  Color GREEN_LIGHTEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-2-green";
        }

        @Override
        public String getName() {
          return "GREEN LIGHTEN 2";
        }

        @Override
        public String getHex() {
          return "#81c784";
        }

        @Override
        public String getBackground() {
          return "bg-l-2-green";
        }
      };

  Color GREEN_LIGHTEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-3-green";
        }

        @Override
        public String getName() {
          return "GREEN LIGHTEN 3";
        }

        @Override
        public String getHex() {
          return "#a5d6a7";
        }

        @Override
        public String getBackground() {
          return "bg-l-3-green";
        }
      };

  Color GREEN_LIGHTEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-4-green";
        }

        @Override
        public String getName() {
          return "GREEN LIGHTEN 4";
        }

        @Override
        public String getHex() {
          return "#c8e6c9";
        }

        @Override
        public String getBackground() {
          return "bg-l-4-green";
        }
      };

  Color GREEN_LIGHTEN_5 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-5-green";
        }

        @Override
        public String getName() {
          return "GREEN LIGHTEN 5";
        }

        @Override
        public String getHex() {
          return "#e8f5e9";
        }

        @Override
        public String getBackground() {
          return "bg-l-5-green";
        }
      };

  Color GREEN_DARKEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-1-green";
        }

        @Override
        public String getName() {
          return "GREEN DARKEN 1";
        }

        @Override
        public String getHex() {
          return "#43a047";
        }

        @Override
        public String getBackground() {
          return "bg-d-1-green";
        }
      };

  Color GREEN_DARKEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-2-green";
        }

        @Override
        public String getName() {
          return "GREEN DARKEN 2";
        }

        @Override
        public String getHex() {
          return "#388e3c";
        }

        @Override
        public String getBackground() {
          return "bg-d-2-green";
        }
      };

  Color GREEN_DARKEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-3-green";
        }

        @Override
        public String getName() {
          return "GREEN DARKEN 3";
        }

        @Override
        public String getHex() {
          return "#2e7d32";
        }

        @Override
        public String getBackground() {
          return "bg-d-3-green";
        }
      };

  Color GREEN_DARKEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-4-green";
        }

        @Override
        public String getName() {
          return "GREEN DARKEN 4";
        }

        @Override
        public String getHex() {
          return "#1b5e20";
        }

        @Override
        public String getBackground() {
          return "bg-d-4-green";
        }
      };

  Color LIGHT_GREEN =
      new Color() {
        @Override
        public String getStyle() {
          return "col-light-green";
        }

        @Override
        public String getName() {
          return "LIGHT GREEN";
        }

        @Override
        public String getHex() {
          return "#8BC34A";
        }

        @Override
        public String getBackground() {
          return "bg-light-green";
        }
      };

  Color LIGHT_GREEN_LIGHTEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-1-light-green";
        }

        @Override
        public String getName() {
          return "LIGHT GREEN LIGHTEN 1";
        }

        @Override
        public String getHex() {
          return "#9ccc65";
        }

        @Override
        public String getBackground() {
          return "bg-l-1-light-green";
        }
      };

  Color LIGHT_GREEN_LIGHTEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-2-light-green";
        }

        @Override
        public String getName() {
          return "LIGHT GREEN LIGHTEN 2";
        }

        @Override
        public String getHex() {
          return "#aed581";
        }

        @Override
        public String getBackground() {
          return "bg-l-2-light-green";
        }
      };

  Color LIGHT_GREEN_LIGHTEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-3-light-green";
        }

        @Override
        public String getName() {
          return "LIGHT GREEN LIGHTEN 3";
        }

        @Override
        public String getHex() {
          return "#c5e1a5";
        }

        @Override
        public String getBackground() {
          return "bg-l-3-light-green";
        }
      };

  Color LIGHT_GREEN_LIGHTEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-4-light-green";
        }

        @Override
        public String getName() {
          return "LIGHT GREEN LIGHTEN 4";
        }

        @Override
        public String getHex() {
          return "#dcedc8";
        }

        @Override
        public String getBackground() {
          return "bg-l-4-light-green";
        }
      };

  Color LIGHT_GREEN_LIGHTEN_5 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-5-light-green";
        }

        @Override
        public String getName() {
          return "LIGHT GREEN LIGHTEN 5";
        }

        @Override
        public String getHex() {
          return "#f1f8e9";
        }

        @Override
        public String getBackground() {
          return "bg-l-5-light-green";
        }
      };

  Color LIGHT_GREEN_DARKEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-1-light-green";
        }

        @Override
        public String getName() {
          return "LIGHT GREEN DARKEN 1";
        }

        @Override
        public String getHex() {
          return "#7cb342";
        }

        @Override
        public String getBackground() {
          return "bg-d-1-light-green";
        }
      };

  Color LIGHT_GREEN_DARKEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-2-light-green";
        }

        @Override
        public String getName() {
          return "LIGHT GREEN DARKEN 2";
        }

        @Override
        public String getHex() {
          return "#689f38";
        }

        @Override
        public String getBackground() {
          return "bg-d-2-light-green";
        }
      };

  Color LIGHT_GREEN_DARKEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-3-light-green";
        }

        @Override
        public String getName() {
          return "LIGHT GREEN DARKEN 3";
        }

        @Override
        public String getHex() {
          return "#558b2f";
        }

        @Override
        public String getBackground() {
          return "bg-d-3-light-green";
        }
      };

  Color LIGHT_GREEN_DARKEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-4-light-green";
        }

        @Override
        public String getName() {
          return "LIGHT GREEN DARKEN 4";
        }

        @Override
        public String getHex() {
          return "#33691e";
        }

        @Override
        public String getBackground() {
          return "bg-d-4-light-green";
        }
      };

  Color LIME =
      new Color() {
        @Override
        public String getStyle() {
          return "col-lime";
        }

        @Override
        public String getName() {
          return "LIME";
        }

        @Override
        public String getHex() {
          return "#CDDC39";
        }

        @Override
        public String getBackground() {
          return "bg-lime";
        }
      };

  Color LIME_LIGHTEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-1-lime";
        }

        @Override
        public String getName() {
          return "LIME LIGHTEN 1";
        }

        @Override
        public String getHex() {
          return "#d4e157";
        }

        @Override
        public String getBackground() {
          return "bg-l-1-lime";
        }
      };

  Color LIME_LIGHTEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-2-lime";
        }

        @Override
        public String getName() {
          return "LIME LIGHTEN 2";
        }

        @Override
        public String getHex() {
          return "#dce775";
        }

        @Override
        public String getBackground() {
          return "bg-l-2-lime";
        }
      };

  Color LIME_LIGHTEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-3-lime";
        }

        @Override
        public String getName() {
          return "LIME LIGHTEN 3";
        }

        @Override
        public String getHex() {
          return "#e6ee9c";
        }

        @Override
        public String getBackground() {
          return "bg-l-3-lime";
        }
      };

  Color LIME_LIGHTEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-4-lime";
        }

        @Override
        public String getName() {
          return "LIME LIGHTEN 4";
        }

        @Override
        public String getHex() {
          return "#f0f4c3";
        }

        @Override
        public String getBackground() {
          return "bg-l-4-lime";
        }
      };

  Color LIME_LIGHTEN_5 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-5-lime";
        }

        @Override
        public String getName() {
          return "LIME LIGHTEN 5";
        }

        @Override
        public String getHex() {
          return "#f9fbe7";
        }

        @Override
        public String getBackground() {
          return "bg-l-5-lime";
        }
      };

  Color LIME_DARKEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-1-lime";
        }

        @Override
        public String getName() {
          return "LIME DARKEN 1";
        }

        @Override
        public String getHex() {
          return "#c0ca33";
        }

        @Override
        public String getBackground() {
          return "bg-d-1-lime";
        }
      };

  Color LIME_DARKEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-2-lime";
        }

        @Override
        public String getName() {
          return "LIME DARKEN 2";
        }

        @Override
        public String getHex() {
          return "#afb42b";
        }

        @Override
        public String getBackground() {
          return "bg-d-2-lime";
        }
      };

  Color LIME_DARKEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-3-lime";
        }

        @Override
        public String getName() {
          return "LIME DARKEN 3";
        }

        @Override
        public String getHex() {
          return "#9e9d24";
        }

        @Override
        public String getBackground() {
          return "bg-d-3-lime";
        }
      };

  Color LIME_DARKEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-4-lime";
        }

        @Override
        public String getName() {
          return "LIME DARKEN 4";
        }

        @Override
        public String getHex() {
          return "#827717";
        }

        @Override
        public String getBackground() {
          return "bg-d-4-lime";
        }
      };

  Color YELLOW =
      new Color() {
        @Override
        public String getStyle() {
          return "col-yellow";
        }

        @Override
        public String getName() {
          return "YELLOW";
        }

        @Override
        public String getHex() {
          return "#FFEB3B";
        }

        @Override
        public String getBackground() {
          return "bg-yellow";
        }
      };

  Color YELLOW_LIGHTEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-1-yellow";
        }

        @Override
        public String getName() {
          return "YELLOW LIGHTEN 1";
        }

        @Override
        public String getHex() {
          return "#ffee58";
        }

        @Override
        public String getBackground() {
          return "bg-l-1-yellow";
        }
      };

  Color YELLOW_LIGHTEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-2-yellow";
        }

        @Override
        public String getName() {
          return "YELLOW LIGHTEN 2";
        }

        @Override
        public String getHex() {
          return "#fff176";
        }

        @Override
        public String getBackground() {
          return "bg-l-2-yellow";
        }
      };

  Color YELLOW_LIGHTEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-3-yellow";
        }

        @Override
        public String getName() {
          return "YELLOW LIGHTEN 3";
        }

        @Override
        public String getHex() {
          return "#fff59d";
        }

        @Override
        public String getBackground() {
          return "bg-l-3-yellow";
        }
      };

  Color YELLOW_LIGHTEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-4-yellow";
        }

        @Override
        public String getName() {
          return "YELLOW LIGHTEN 4";
        }

        @Override
        public String getHex() {
          return "#fff9c4";
        }

        @Override
        public String getBackground() {
          return "bg-l-4-yellow";
        }
      };

  Color YELLOW_LIGHTEN_5 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-5-yellow";
        }

        @Override
        public String getName() {
          return "YELLOW LIGHTEN 5";
        }

        @Override
        public String getHex() {
          return "#fffde7";
        }

        @Override
        public String getBackground() {
          return "bg-l-5-yellow";
        }
      };

  Color YELLOW_DARKEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-1-yellow";
        }

        @Override
        public String getName() {
          return "YELLOW DARKEN 1";
        }

        @Override
        public String getHex() {
          return "#fdd835";
        }

        @Override
        public String getBackground() {
          return "bg-d-1-yellow";
        }
      };

  Color YELLOW_DARKEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-2-yellow";
        }

        @Override
        public String getName() {
          return "YELLOW DARKEN 2";
        }

        @Override
        public String getHex() {
          return "#fbc02d";
        }

        @Override
        public String getBackground() {
          return "bg-d-2-yellow";
        }
      };

  Color YELLOW_DARKEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-3-yellow";
        }

        @Override
        public String getName() {
          return "YELLOW DARKEN 3";
        }

        @Override
        public String getHex() {
          return "#f9a825";
        }

        @Override
        public String getBackground() {
          return "bg-d-3-yellow";
        }
      };

  Color YELLOW_DARKEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-4-yellow";
        }

        @Override
        public String getName() {
          return "YELLOW DARKEN 4";
        }

        @Override
        public String getHex() {
          return "#f57f17";
        }

        @Override
        public String getBackground() {
          return "bg-d-4-yellow";
        }
      };

  Color AMBER =
      new Color() {
        @Override
        public String getStyle() {
          return "col-amber";
        }

        @Override
        public String getName() {
          return "AMBER";
        }

        @Override
        public String getHex() {
          return "#FFC107";
        }

        @Override
        public String getBackground() {
          return "bg-amber";
        }
      };

  Color AMBER_LIGHTEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-1-amber";
        }

        @Override
        public String getName() {
          return "AMBER LIGHTEN 1";
        }

        @Override
        public String getHex() {
          return "#ffca28";
        }

        @Override
        public String getBackground() {
          return "bg-l-1-amber";
        }
      };

  Color AMBER_LIGHTEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-2-amber";
        }

        @Override
        public String getName() {
          return "AMBER LIGHTEN 2";
        }

        @Override
        public String getHex() {
          return "#ffd54f";
        }

        @Override
        public String getBackground() {
          return "bg-l-2-amber";
        }
      };

  Color AMBER_LIGHTEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-3-amber";
        }

        @Override
        public String getName() {
          return "AMBER LIGHTEN 3";
        }

        @Override
        public String getHex() {
          return "#ffe082";
        }

        @Override
        public String getBackground() {
          return "bg-l-3-amber";
        }
      };

  Color AMBER_LIGHTEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-4-amber";
        }

        @Override
        public String getName() {
          return "AMBER LIGHTEN 4";
        }

        @Override
        public String getHex() {
          return "#ffecb3";
        }

        @Override
        public String getBackground() {
          return "bg-l-4-amber";
        }
      };

  Color AMBER_LIGHTEN_5 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-5-amber";
        }

        @Override
        public String getName() {
          return "AMBER LIGHTEN 5";
        }

        @Override
        public String getHex() {
          return "#fff8e1";
        }

        @Override
        public String getBackground() {
          return "bg-l-5-amber";
        }
      };

  Color AMBER_DARKEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-1-amber";
        }

        @Override
        public String getName() {
          return "AMBER DARKEN 1";
        }

        @Override
        public String getHex() {
          return "#ffb300";
        }

        @Override
        public String getBackground() {
          return "bg-d-1-amber";
        }
      };

  Color AMBER_DARKEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-2-amber";
        }

        @Override
        public String getName() {
          return "AMBER DARKEN 2";
        }

        @Override
        public String getHex() {
          return "#ffa000";
        }

        @Override
        public String getBackground() {
          return "bg-d-2-amber";
        }
      };

  Color AMBER_DARKEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-3-amber";
        }

        @Override
        public String getName() {
          return "AMBER DARKEN 3";
        }

        @Override
        public String getHex() {
          return "#ff8f00";
        }

        @Override
        public String getBackground() {
          return "bg-d-3-amber";
        }
      };

  Color AMBER_DARKEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-4-amber";
        }

        @Override
        public String getName() {
          return "AMBER DARKEN 4";
        }

        @Override
        public String getHex() {
          return "#ff6f00";
        }

        @Override
        public String getBackground() {
          return "bg-d-4-amber";
        }
      };

  Color ORANGE =
      new Color() {
        @Override
        public String getStyle() {
          return "col-orange";
        }

        @Override
        public String getName() {
          return "ORANGE";
        }

        @Override
        public String getHex() {
          return "#FF9800";
        }

        @Override
        public String getBackground() {
          return "bg-orange";
        }
      };

  Color ORANGE_LIGHTEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-1-orange";
        }

        @Override
        public String getName() {
          return "ORANGE LIGHTEN 1";
        }

        @Override
        public String getHex() {
          return "#ffa726";
        }

        @Override
        public String getBackground() {
          return "bg-l-1-orange";
        }
      };

  Color ORANGE_LIGHTEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-2-orange";
        }

        @Override
        public String getName() {
          return "ORANGE LIGHTEN 2";
        }

        @Override
        public String getHex() {
          return "#ffb74d";
        }

        @Override
        public String getBackground() {
          return "bg-l-2-orange";
        }
      };

  Color ORANGE_LIGHTEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-3-orange";
        }

        @Override
        public String getName() {
          return "ORANGE LIGHTEN 3";
        }

        @Override
        public String getHex() {
          return "#ffcc80";
        }

        @Override
        public String getBackground() {
          return "bg-l-3-orange";
        }
      };

  Color ORANGE_LIGHTEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-4-orange";
        }

        @Override
        public String getName() {
          return "ORANGE LIGHTEN 4";
        }

        @Override
        public String getHex() {
          return "#ffe0b2";
        }

        @Override
        public String getBackground() {
          return "bg-l-4-orange";
        }
      };

  Color ORANGE_LIGHTEN_5 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-5-orange";
        }

        @Override
        public String getName() {
          return "ORANGE LIGHTEN 5";
        }

        @Override
        public String getHex() {
          return "#fff3e0";
        }

        @Override
        public String getBackground() {
          return "bg-l-5-orange";
        }
      };

  Color ORANGE_DARKEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-1-orange";
        }

        @Override
        public String getName() {
          return "ORANGE DARKEN 1";
        }

        @Override
        public String getHex() {
          return "#fb8c00";
        }

        @Override
        public String getBackground() {
          return "bg-d-1-orange";
        }
      };

  Color ORANGE_DARKEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-2-orange";
        }

        @Override
        public String getName() {
          return "ORANGE DARKEN 2";
        }

        @Override
        public String getHex() {
          return "#f57c00";
        }

        @Override
        public String getBackground() {
          return "bg-d-2-orange";
        }
      };

  Color ORANGE_DARKEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-3-orange";
        }

        @Override
        public String getName() {
          return "ORANGE DARKEN 3";
        }

        @Override
        public String getHex() {
          return "#ef6c00";
        }

        @Override
        public String getBackground() {
          return "bg-d-3-orange";
        }
      };

  Color ORANGE_DARKEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-4-orange";
        }

        @Override
        public String getName() {
          return "ORANGE DARKEN 4";
        }

        @Override
        public String getHex() {
          return "#e65100";
        }

        @Override
        public String getBackground() {
          return "bg-d-4-orange";
        }
      };

  Color DEEP_ORANGE =
      new Color() {
        @Override
        public String getStyle() {
          return "col-deep-orange";
        }

        @Override
        public String getName() {
          return "DEEP ORANGE";
        }

        @Override
        public String getHex() {
          return "#FF5722";
        }

        @Override
        public String getBackground() {
          return "bg-deep-orange";
        }
      };

  Color DEEP_ORANGE_LIGHTEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-1-deep-orange";
        }

        @Override
        public String getName() {
          return "DEEP ORANGE LIGHTEN 1";
        }

        @Override
        public String getHex() {
          return "#ff7043";
        }

        @Override
        public String getBackground() {
          return "bg-l-1-deep-orange";
        }
      };

  Color DEEP_ORANGE_LIGHTEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-2-deep-orange";
        }

        @Override
        public String getName() {
          return "DEEP ORANGE LIGHTEN 2";
        }

        @Override
        public String getHex() {
          return "#ff8a65";
        }

        @Override
        public String getBackground() {
          return "bg-l-2-deep-orange";
        }
      };

  Color DEEP_ORANGE_LIGHTEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-3-deep-orange";
        }

        @Override
        public String getName() {
          return "DEEP ORANGE LIGHTEN 3";
        }

        @Override
        public String getHex() {
          return "#ffab91";
        }

        @Override
        public String getBackground() {
          return "bg-l-3-deep-orange";
        }
      };

  Color DEEP_ORANGE_LIGHTEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-4-deep-orange";
        }

        @Override
        public String getName() {
          return "DEEP ORANGE LIGHTEN 4";
        }

        @Override
        public String getHex() {
          return "#ffccbc";
        }

        @Override
        public String getBackground() {
          return "bg-l-4-deep-orange";
        }
      };

  Color DEEP_ORANGE_LIGHTEN_5 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-5-deep-orange";
        }

        @Override
        public String getName() {
          return "DEEP ORANGE LIGHTEN 5";
        }

        @Override
        public String getHex() {
          return "#fbe9e7";
        }

        @Override
        public String getBackground() {
          return "bg-l-5-deep-orange";
        }
      };

  Color DEEP_ORANGE_DARKEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-1-deep-orange";
        }

        @Override
        public String getName() {
          return "DEEP ORANGE DARKEN 1";
        }

        @Override
        public String getHex() {
          return "#f4511e";
        }

        @Override
        public String getBackground() {
          return "bg-d-1-deep-orange";
        }
      };

  Color DEEP_ORANGE_DARKEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-2-deep-orange";
        }

        @Override
        public String getName() {
          return "DEEP ORANGE DARKEN 2";
        }

        @Override
        public String getHex() {
          return "#e64a19";
        }

        @Override
        public String getBackground() {
          return "bg-d-2-deep-orange";
        }
      };

  Color DEEP_ORANGE_DARKEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-3-deep-orange";
        }

        @Override
        public String getName() {
          return "DEEP ORANGE DARKEN 3";
        }

        @Override
        public String getHex() {
          return "#d84315";
        }

        @Override
        public String getBackground() {
          return "bg-d-3-deep-orange";
        }
      };

  Color DEEP_ORANGE_DARKEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-4-deep-orange";
        }

        @Override
        public String getName() {
          return "DEEP ORANGE DARKEN 4";
        }

        @Override
        public String getHex() {
          return "#bf360c";
        }

        @Override
        public String getBackground() {
          return "bg-d-4-deep-orange";
        }
      };

  Color BROWN =
      new Color() {
        @Override
        public String getStyle() {
          return "col-brown";
        }

        @Override
        public String getName() {
          return "BROWN";
        }

        @Override
        public String getHex() {
          return "#795548";
        }

        @Override
        public String getBackground() {
          return "bg-brown";
        }
      };

  Color BROWN_LIGHTEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-1-brown";
        }

        @Override
        public String getName() {
          return "BROWN LIGHTEN 1";
        }

        @Override
        public String getHex() {
          return "#8d6e63";
        }

        @Override
        public String getBackground() {
          return "bg-l-1-brown";
        }
      };

  Color BROWN_LIGHTEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-2-brown";
        }

        @Override
        public String getName() {
          return "BROWN LIGHTEN 2";
        }

        @Override
        public String getHex() {
          return "#a1887f";
        }

        @Override
        public String getBackground() {
          return "bg-l-2-brown";
        }
      };

  Color BROWN_LIGHTEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-3-brown";
        }

        @Override
        public String getName() {
          return "BROWN LIGHTEN 3";
        }

        @Override
        public String getHex() {
          return "#bcaaa4";
        }

        @Override
        public String getBackground() {
          return "bg-l-3-brown";
        }
      };

  Color BROWN_LIGHTEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-4-brown";
        }

        @Override
        public String getName() {
          return "BROWN LIGHTEN 4";
        }

        @Override
        public String getHex() {
          return "#d7ccc8";
        }

        @Override
        public String getBackground() {
          return "bg-l-4-brown";
        }
      };

  Color BROWN_LIGHTEN_5 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-5-brown";
        }

        @Override
        public String getName() {
          return "BROWN LIGHTEN 5";
        }

        @Override
        public String getHex() {
          return "#efebe9";
        }

        @Override
        public String getBackground() {
          return "bg-l-5-brown";
        }
      };

  Color BROWN_DARKEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-1-brown";
        }

        @Override
        public String getName() {
          return "BROWN DARKEN 1";
        }

        @Override
        public String getHex() {
          return "#6d4c41";
        }

        @Override
        public String getBackground() {
          return "bg-d-1-brown";
        }
      };

  Color BROWN_DARKEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-2-brown";
        }

        @Override
        public String getName() {
          return "BROWN DARKEN 2";
        }

        @Override
        public String getHex() {
          return "#5d4037";
        }

        @Override
        public String getBackground() {
          return "bg-d-2-brown";
        }
      };

  Color BROWN_DARKEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-3-brown";
        }

        @Override
        public String getName() {
          return "BROWN DARKEN 3";
        }

        @Override
        public String getHex() {
          return "#4e342e";
        }

        @Override
        public String getBackground() {
          return "bg-d-3-brown";
        }
      };

  Color BROWN_DARKEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-4-brown";
        }

        @Override
        public String getName() {
          return "BROWN DARKEN 4";
        }

        @Override
        public String getHex() {
          return "#3e2723";
        }

        @Override
        public String getBackground() {
          return "bg-d-4-brown";
        }
      };

  Color GREY =
      new Color() {
        @Override
        public String getStyle() {
          return "col-grey";
        }

        @Override
        public String getName() {
          return "GREY";
        }

        @Override
        public String getHex() {
          return "#9E9E9E";
        }

        @Override
        public String getBackground() {
          return "bg-grey";
        }
      };

  Color GREY_LIGHTEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-1-grey";
        }

        @Override
        public String getName() {
          return "GREY LIGHTEN 1";
        }

        @Override
        public String getHex() {
          return "#bdbdbd";
        }

        @Override
        public String getBackground() {
          return "bg-l-1-grey";
        }
      };

  Color GREY_LIGHTEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-2-grey";
        }

        @Override
        public String getName() {
          return "GREY LIGHTEN 2";
        }

        @Override
        public String getHex() {
          return "#e0e0e0";
        }

        @Override
        public String getBackground() {
          return "bg-l-2-grey";
        }
      };

  Color GREY_LIGHTEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-3-grey";
        }

        @Override
        public String getName() {
          return "GREY LIGHTEN 3";
        }

        @Override
        public String getHex() {
          return "#eeeeee";
        }

        @Override
        public String getBackground() {
          return "bg-l-3-grey";
        }
      };

  Color GREY_LIGHTEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-4-grey";
        }

        @Override
        public String getName() {
          return "GREY LIGHTEN 4";
        }

        @Override
        public String getHex() {
          return "#f5f5f5";
        }

        @Override
        public String getBackground() {
          return "bg-l-4-grey";
        }
      };

  Color GREY_LIGHTEN_5 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-5-grey";
        }

        @Override
        public String getName() {
          return "GREY LIGHTEN 5";
        }

        @Override
        public String getHex() {
          return "#fafafa";
        }

        @Override
        public String getBackground() {
          return "bg-l-5-grey";
        }
      };

  Color GREY_DARKEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-1-grey";
        }

        @Override
        public String getName() {
          return "GREY DARKEN 1";
        }

        @Override
        public String getHex() {
          return "#757575";
        }

        @Override
        public String getBackground() {
          return "bg-d-1-grey";
        }
      };

  Color GREY_DARKEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-2-grey";
        }

        @Override
        public String getName() {
          return "GREY DARKEN 2";
        }

        @Override
        public String getHex() {
          return "#616161";
        }

        @Override
        public String getBackground() {
          return "bg-d-2-grey";
        }
      };

  Color GREY_DARKEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-3-grey";
        }

        @Override
        public String getName() {
          return "GREY DARKEN 3";
        }

        @Override
        public String getHex() {
          return "#424242";
        }

        @Override
        public String getBackground() {
          return "bg-d-3-grey";
        }
      };

  Color GREY_DARKEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-4-grey";
        }

        @Override
        public String getName() {
          return "GREY DARKEN 4";
        }

        @Override
        public String getHex() {
          return "#212121";
        }

        @Override
        public String getBackground() {
          return "bg-d-4-grey";
        }
      };

  Color BLUE_GREY =
      new Color() {
        @Override
        public String getStyle() {
          return "col-blue-grey";
        }

        @Override
        public String getName() {
          return "BLUE GREY";
        }

        @Override
        public String getHex() {
          return "#607D8B";
        }

        @Override
        public String getBackground() {
          return "bg-blue-grey";
        }
      };

  Color BLUE_GREY_LIGHTEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-1-blue-grey";
        }

        @Override
        public String getName() {
          return "BLUE GREY LIGHTEN 1";
        }

        @Override
        public String getHex() {
          return "#78909c";
        }

        @Override
        public String getBackground() {
          return "bg-l-1-blue-grey";
        }
      };

  Color BLUE_GREY_LIGHTEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-2-blue-grey";
        }

        @Override
        public String getName() {
          return "BLUE GREY LIGHTEN 2";
        }

        @Override
        public String getHex() {
          return "#90a4ae";
        }

        @Override
        public String getBackground() {
          return "bg-l-2-blue-grey";
        }
      };

  Color BLUE_GREY_LIGHTEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-3-blue-grey";
        }

        @Override
        public String getName() {
          return "BLUE GREY LIGHTEN 3";
        }

        @Override
        public String getHex() {
          return "#b0bec5";
        }

        @Override
        public String getBackground() {
          return "bg-l-3-blue-grey";
        }
      };

  Color BLUE_GREY_LIGHTEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-4-blue-grey";
        }

        @Override
        public String getName() {
          return "BLUE GREY LIGHTEN 4";
        }

        @Override
        public String getHex() {
          return "#cfd8dc";
        }

        @Override
        public String getBackground() {
          return "bg-l-4-blue-grey";
        }
      };

  Color BLUE_GREY_LIGHTEN_5 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-l-5-blue-grey";
        }

        @Override
        public String getName() {
          return "BLUE GREY LIGHTEN 5";
        }

        @Override
        public String getHex() {
          return "#eceff1";
        }

        @Override
        public String getBackground() {
          return "bg-l-5-blue-grey";
        }
      };

  Color BLUE_GREY_DARKEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-1-blue-grey";
        }

        @Override
        public String getName() {
          return "BLUE GREY DARKEN 1";
        }

        @Override
        public String getHex() {
          return "#546e7a";
        }

        @Override
        public String getBackground() {
          return "bg-d-1-blue-grey";
        }
      };

  Color BLUE_GREY_DARKEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-2-blue-grey";
        }

        @Override
        public String getName() {
          return "BLUE GREY DARKEN 2";
        }

        @Override
        public String getHex() {
          return "#455a64";
        }

        @Override
        public String getBackground() {
          return "bg-d-2-blue-grey";
        }
      };

  Color BLUE_GREY_DARKEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-3-blue-grey";
        }

        @Override
        public String getName() {
          return "BLUE GREY DARKEN 3";
        }

        @Override
        public String getHex() {
          return "#37474f";
        }

        @Override
        public String getBackground() {
          return "bg-d-3-blue-grey";
        }
      };

  Color BLUE_GREY_DARKEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-d-4-blue-grey";
        }

        @Override
        public String getName() {
          return "BLUE GREY DARKEN 4";
        }

        @Override
        public String getHex() {
          return "#263238";
        }

        @Override
        public String getBackground() {
          return "bg-d-4-blue-grey";
        }
      };

  Color BLACK =
      new Color() {
        @Override
        public String getStyle() {
          return "col-black";
        }

        @Override
        public String getName() {
          return "BLACK";
        }

        @Override
        public String getHex() {
          return "#000000";
        }

        @Override
        public String getBackground() {
          return "bg-black";
        }
      };

  Color BLACK_LIGHTEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-black";
        }

        @Override
        public String getName() {
          return "BLACK LIGHTEN 1";
        }

        @Override
        public String getHex() {
          return "#000000";
        }

        @Override
        public String getBackground() {
          return "bg-black";
        }
      };

  Color BLACK_LIGHTEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-black";
        }

        @Override
        public String getName() {
          return "BLACK LIGHTEN 2";
        }

        @Override
        public String getHex() {
          return "#000000";
        }

        @Override
        public String getBackground() {
          return "bg-black";
        }
      };

  Color BLACK_LIGHTEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-black";
        }

        @Override
        public String getName() {
          return "BLACK LIGHTEN 3";
        }

        @Override
        public String getHex() {
          return "#000000";
        }

        @Override
        public String getBackground() {
          return "bg-black";
        }
      };

  Color BLACK_LIGHTEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-black";
        }

        @Override
        public String getName() {
          return "BLACK LIGHTEN 4";
        }

        @Override
        public String getHex() {
          return "#000000";
        }

        @Override
        public String getBackground() {
          return "bg-black";
        }
      };

  Color BLACK_LIGHTEN_5 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-black";
        }

        @Override
        public String getName() {
          return "BLACK LIGHTEN 5";
        }

        @Override
        public String getHex() {
          return "#000000";
        }

        @Override
        public String getBackground() {
          return "bg-black";
        }
      };

  Color BLACK_DARKEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-black";
        }

        @Override
        public String getName() {
          return "BLACK DARKEN 1";
        }

        @Override
        public String getHex() {
          return "#000000";
        }

        @Override
        public String getBackground() {
          return "bg-black";
        }
      };

  Color BLACK_DARKEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-black";
        }

        @Override
        public String getName() {
          return "BLACK DARKEN 2";
        }

        @Override
        public String getHex() {
          return "#000000";
        }

        @Override
        public String getBackground() {
          return "bg-black";
        }
      };

  Color BLACK_DARKEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-black";
        }

        @Override
        public String getName() {
          return "BLACK DARKEN 3";
        }

        @Override
        public String getHex() {
          return "#000000";
        }

        @Override
        public String getBackground() {
          return "bg-black";
        }
      };

  Color BLACK_DARKEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-black";
        }

        @Override
        public String getName() {
          return "BLACK DARKEN 4";
        }

        @Override
        public String getHex() {
          return "#000000";
        }

        @Override
        public String getBackground() {
          return "bg-black";
        }
      };

  Color WHITE =
      new Color() {
        @Override
        public String getStyle() {
          return "col-white";
        }

        @Override
        public String getName() {
          return "WHITE";
        }

        @Override
        public String getHex() {
          return "#FFFFFF";
        }

        @Override
        public String getBackground() {
          return "bg-white";
        }
      };

  Color WHITE_LIGHTEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-white";
        }

        @Override
        public String getName() {
          return "WHITE LIGHTEN 1";
        }

        @Override
        public String getHex() {
          return "#ffffff";
        }

        @Override
        public String getBackground() {
          return "bg-white";
        }
      };

  Color WHITE_LIGHTEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-white";
        }

        @Override
        public String getName() {
          return "WHITE LIGHTEN 2";
        }

        @Override
        public String getHex() {
          return "#ffffff";
        }

        @Override
        public String getBackground() {
          return "bg-white";
        }
      };

  Color WHITE_LIGHTEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-white";
        }

        @Override
        public String getName() {
          return "WHITE LIGHTEN 3";
        }

        @Override
        public String getHex() {
          return "#ffffff";
        }

        @Override
        public String getBackground() {
          return "bg-white";
        }
      };

  Color WHITE_LIGHTEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-white";
        }

        @Override
        public String getName() {
          return "WHITE LIGHTEN 4";
        }

        @Override
        public String getHex() {
          return "#ffffff";
        }

        @Override
        public String getBackground() {
          return "bg-white";
        }
      };

  Color WHITE_LIGHTEN_5 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-white";
        }

        @Override
        public String getName() {
          return "WHITE LIGHTEN 5";
        }

        @Override
        public String getHex() {
          return "#ffffff";
        }

        @Override
        public String getBackground() {
          return "bg-white";
        }
      };

  Color WHITE_DARKEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-white";
        }

        @Override
        public String getName() {
          return "WHITE DARKEN 1";
        }

        @Override
        public String getHex() {
          return "#ffffff";
        }

        @Override
        public String getBackground() {
          return "bg-white";
        }
      };

  Color WHITE_DARKEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-white";
        }

        @Override
        public String getName() {
          return "WHITE DARKEN 2";
        }

        @Override
        public String getHex() {
          return "#ffffff";
        }

        @Override
        public String getBackground() {
          return "bg-white";
        }
      };

  Color WHITE_DARKEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-white";
        }

        @Override
        public String getName() {
          return "WHITE DARKEN 3";
        }

        @Override
        public String getHex() {
          return "#ffffff";
        }

        @Override
        public String getBackground() {
          return "bg-white";
        }
      };

  Color WHITE_DARKEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-white";
        }

        @Override
        public String getName() {
          return "WHITE DARKEN 4";
        }

        @Override
        public String getHex() {
          return "#ffffff";
        }

        @Override
        public String getBackground() {
          return "bg-white";
        }
      };

  Color TRANSPARENT =
      new Color() {
        @Override
        public String getStyle() {
          return "col-transparent";
        }

        @Override
        public String getName() {
          return "TRANSPARENT";
        }

        @Override
        public String getHex() {
          return "transparent";
        }

        @Override
        public String getBackground() {
          return "bg-transparent";
        }
      };

  Color TRANSPARENT_LIGHTEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-transparent";
        }

        @Override
        public String getName() {
          return "TRANSPARENT LIGHTEN 1";
        }

        @Override
        public String getHex() {
          return "transparent";
        }

        @Override
        public String getBackground() {
          return "bg-transparent";
        }
      };

  Color TRANSPARENT_LIGHTEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-transparent";
        }

        @Override
        public String getName() {
          return "TRANSPARENT LIGHTEN 2";
        }

        @Override
        public String getHex() {
          return "transparent";
        }

        @Override
        public String getBackground() {
          return "bg-transparent";
        }
      };

  Color TRANSPARENT_LIGHTEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-transparent";
        }

        @Override
        public String getName() {
          return "TRANSPARENT LIGHTEN 3";
        }

        @Override
        public String getHex() {
          return "transparent";
        }

        @Override
        public String getBackground() {
          return "bg-transparent";
        }
      };

  Color TRANSPARENT_LIGHTEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-transparent";
        }

        @Override
        public String getName() {
          return "TRANSPARENT LIGHTEN 4";
        }

        @Override
        public String getHex() {
          return "transparent";
        }

        @Override
        public String getBackground() {
          return "bg-transparent";
        }
      };

  Color TRANSPARENT_LIGHTEN_5 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-transparent";
        }

        @Override
        public String getName() {
          return "TRANSPARENT LIGHTEN 5";
        }

        @Override
        public String getHex() {
          return "transparent";
        }

        @Override
        public String getBackground() {
          return "bg-transparent";
        }
      };

  Color TRANSPARENT_DARKEN_1 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-transparent";
        }

        @Override
        public String getName() {
          return "TRANSPARENT DARKEN 1";
        }

        @Override
        public String getHex() {
          return "transparent";
        }

        @Override
        public String getBackground() {
          return "bg-transparent";
        }
      };

  Color TRANSPARENT_DARKEN_2 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-transparent";
        }

        @Override
        public String getName() {
          return "TRANSPARENT DARKEN 2";
        }

        @Override
        public String getHex() {
          return "transparent";
        }

        @Override
        public String getBackground() {
          return "bg-transparent";
        }
      };

  Color TRANSPARENT_DARKEN_3 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-transparent";
        }

        @Override
        public String getName() {
          return "TRANSPARENT DARKEN 3";
        }

        @Override
        public String getHex() {
          return "transparent";
        }

        @Override
        public String getBackground() {
          return "bg-transparent";
        }
      };

  Color TRANSPARENT_DARKEN_4 =
      new Color() {
        @Override
        public String getStyle() {
          return "col-transparent";
        }

        @Override
        public String getName() {
          return "TRANSPARENT DARKEN 4";
        }

        @Override
        public String getHex() {
          return "transparent";
        }

        @Override
        public String getBackground() {
          return "bg-transparent";
        }
      };

  Color THEME =
      new Color() {
        @Override
        public String getStyle() {
          return "col-theme";
        }

        @Override
        public String getName() {
          return "THEME";
        }

        @Override
        public String getHex() {
          return Theme.currentTheme.getScheme().color().getHex();
        }

        @Override
        public String getBackground() {
          return "bg-theme";
        }
      };

  static Color of(String name) {
    switch (name) {
      case "RED":
        return Color.RED;

      case "RED DARKEN 1":
        return Color.RED_DARKEN_1;

      case "RED DARKEN 2":
        return Color.RED_DARKEN_2;

      case "RED DARKEN 3":
        return Color.RED_DARKEN_3;

      case "RED DARKEN 4":
        return Color.RED_DARKEN_4;

      case "RED LIGHTEN 1":
        return Color.RED_LIGHTEN_1;

      case "RED LIGHTEN 2":
        return Color.RED_LIGHTEN_2;

      case "RED LIGHTEN 3":
        return Color.RED_LIGHTEN_3;

      case "RED LIGHTEN 4":
        return Color.RED_LIGHTEN_4;

      case "RED LIGHTEN 5":
        return Color.RED_LIGHTEN_5;

      case "PINK":
        return Color.PINK;

      case "PINK DARKEN 1":
        return Color.PINK_DARKEN_1;

      case "PINK DARKEN 2":
        return Color.PINK_DARKEN_2;

      case "PINK DARKEN 3":
        return Color.PINK_DARKEN_3;

      case "PINK DARKEN 4":
        return Color.PINK_DARKEN_4;

      case "PINK LIGHTEN 1":
        return Color.PINK_LIGHTEN_1;

      case "PINK LIGHTEN 2":
        return Color.PINK_LIGHTEN_2;

      case "PINK LIGHTEN 3":
        return Color.PINK_LIGHTEN_3;

      case "PINK LIGHTEN 4":
        return Color.PINK_LIGHTEN_4;

      case "PINK LIGHTEN 5":
        return Color.PINK_LIGHTEN_5;

      case "PURPLE":
        return Color.PURPLE;

      case "PURPLE DARKEN 1":
        return Color.PURPLE_DARKEN_1;

      case "PURPLE DARKEN 2":
        return Color.PURPLE_DARKEN_2;

      case "PURPLE DARKEN 3":
        return Color.PURPLE_DARKEN_3;

      case "PURPLE DARKEN 4":
        return Color.PURPLE_DARKEN_4;

      case "PURPLE LIGHTEN 1":
        return Color.PURPLE_LIGHTEN_1;

      case "PURPLE LIGHTEN 2":
        return Color.PURPLE_LIGHTEN_2;

      case "PURPLE LIGHTEN 3":
        return Color.PURPLE_LIGHTEN_3;

      case "PURPLE LIGHTEN 4":
        return Color.PURPLE_LIGHTEN_4;

      case "PURPLE LIGHTEN 5":
        return Color.PURPLE_LIGHTEN_5;

      case "DEEP PURPLE":
        return Color.DEEP_PURPLE;

      case "DEEP PURPLE DARKEN 1":
        return Color.DEEP_PURPLE_DARKEN_1;

      case "DEEP PURPLE DARKEN 2":
        return Color.DEEP_PURPLE_DARKEN_2;

      case "DEEP PURPLE DARKEN 3":
        return Color.DEEP_PURPLE_DARKEN_3;

      case "DEEP PURPLE DARKEN 4":
        return Color.DEEP_PURPLE_DARKEN_4;

      case "DEEP PURPLE LIGHTEN 1":
        return Color.DEEP_PURPLE_LIGHTEN_1;

      case "DEEP PURPLE LIGHTEN 2":
        return Color.DEEP_PURPLE_LIGHTEN_2;

      case "DEEP PURPLE LIGHTEN 3":
        return Color.DEEP_PURPLE_LIGHTEN_3;

      case "DEEP PURPLE LIGHTEN 4":
        return Color.DEEP_PURPLE_LIGHTEN_4;

      case "DEEP PURPLE LIGHTEN 5":
        return Color.DEEP_PURPLE_LIGHTEN_5;

      case "INDIGO":
        return Color.INDIGO;

      case "INDIGO DARKEN 1":
        return Color.INDIGO_DARKEN_1;

      case "INDIGO DARKEN 2":
        return Color.INDIGO_DARKEN_2;

      case "INDIGO DARKEN 3":
        return Color.INDIGO_DARKEN_3;

      case "INDIGO DARKEN 4":
        return Color.INDIGO_DARKEN_4;

      case "INDIGO LIGHTEN 1":
        return Color.INDIGO_LIGHTEN_1;

      case "INDIGO LIGHTEN 2":
        return Color.INDIGO_LIGHTEN_2;

      case "INDIGO LIGHTEN 3":
        return Color.INDIGO_LIGHTEN_3;

      case "INDIGO LIGHTEN 4":
        return Color.INDIGO_LIGHTEN_4;

      case "INDIGO LIGHTEN 5":
        return Color.INDIGO_LIGHTEN_5;

      case "BLUE":
        return Color.BLUE;

      case "BLUE DARKEN 1":
        return Color.BLUE_DARKEN_1;

      case "BLUE DARKEN 2":
        return Color.BLUE_DARKEN_2;

      case "BLUE DARKEN 3":
        return Color.BLUE_DARKEN_3;

      case "BLUE DARKEN 4":
        return Color.BLUE_DARKEN_4;

      case "BLUE LIGHTEN 1":
        return Color.BLUE_LIGHTEN_1;

      case "BLUE LIGHTEN 2":
        return Color.BLUE_LIGHTEN_2;

      case "BLUE LIGHTEN 3":
        return Color.BLUE_LIGHTEN_3;

      case "BLUE LIGHTEN 4":
        return Color.BLUE_LIGHTEN_4;

      case "BLUE LIGHTEN 5":
        return Color.BLUE_LIGHTEN_5;

      case "LIGHT BLUE":
        return Color.LIGHT_BLUE;

      case "LIGHT BLUE DARKEN 1":
        return Color.LIGHT_BLUE_DARKEN_1;

      case "LIGHT BLUE DARKEN 2":
        return Color.LIGHT_BLUE_DARKEN_2;

      case "LIGHT BLUE DARKEN 3":
        return Color.LIGHT_BLUE_DARKEN_3;

      case "LIGHT BLUE DARKEN 4":
        return Color.LIGHT_BLUE_DARKEN_4;

      case "LIGHT BLUE LIGHTEN 1":
        return Color.LIGHT_BLUE_LIGHTEN_1;

      case "LIGHT BLUE LIGHTEN 2":
        return Color.LIGHT_BLUE_LIGHTEN_2;

      case "LIGHT BLUE LIGHTEN 3":
        return Color.LIGHT_BLUE_LIGHTEN_3;

      case "LIGHT BLUE LIGHTEN 4":
        return Color.LIGHT_BLUE_LIGHTEN_4;

      case "LIGHT BLUE LIGHTEN 5":
        return Color.LIGHT_BLUE_LIGHTEN_5;

      case "CYAN":
        return Color.CYAN;

      case "CYAN DARKEN 1":
        return Color.CYAN_DARKEN_1;

      case "CYAN DARKEN 2":
        return Color.CYAN_DARKEN_2;

      case "CYAN DARKEN 3":
        return Color.CYAN_DARKEN_3;

      case "CYAN DARKEN 4":
        return Color.CYAN_DARKEN_4;

      case "CYAN LIGHTEN 1":
        return Color.CYAN_LIGHTEN_1;

      case "CYAN LIGHTEN 2":
        return Color.CYAN_LIGHTEN_2;

      case "CYAN LIGHTEN 3":
        return Color.CYAN_LIGHTEN_3;

      case "CYAN LIGHTEN 4":
        return Color.CYAN_LIGHTEN_4;

      case "CYAN LIGHTEN 5":
        return Color.CYAN_LIGHTEN_5;

      case "TEAL":
        return Color.TEAL;

      case "TEAL DARKEN 1":
        return Color.TEAL_DARKEN_1;

      case "TEAL DARKEN 2":
        return Color.TEAL_DARKEN_2;

      case "TEAL DARKEN 3":
        return Color.TEAL_DARKEN_3;

      case "TEAL DARKEN 4":
        return Color.TEAL_DARKEN_4;

      case "TEAL LIGHTEN 1":
        return Color.TEAL_LIGHTEN_1;

      case "TEAL LIGHTEN 2":
        return Color.TEAL_LIGHTEN_2;

      case "TEAL LIGHTEN 3":
        return Color.TEAL_LIGHTEN_3;

      case "TEAL LIGHTEN 4":
        return Color.TEAL_LIGHTEN_4;

      case "TEAL LIGHTEN 5":
        return Color.TEAL_LIGHTEN_5;

      case "GREEN":
        return Color.GREEN;

      case "GREEN DARKEN 1":
        return Color.GREEN_DARKEN_1;

      case "GREEN DARKEN 2":
        return Color.GREEN_DARKEN_2;

      case "GREEN DARKEN 3":
        return Color.GREEN_DARKEN_3;

      case "GREEN DARKEN 4":
        return Color.GREEN_DARKEN_4;

      case "GREEN LIGHTEN 1":
        return Color.GREEN_LIGHTEN_1;

      case "GREEN LIGHTEN 2":
        return Color.GREEN_LIGHTEN_2;

      case "GREEN LIGHTEN 3":
        return Color.GREEN_LIGHTEN_3;

      case "GREEN LIGHTEN 4":
        return Color.GREEN_LIGHTEN_4;

      case "GREEN LIGHTEN 5":
        return Color.GREEN_LIGHTEN_5;

      case "LIGHT GREEN":
        return Color.LIGHT_GREEN;

      case "LIGHT GREEN DARKEN 1":
        return Color.LIGHT_GREEN_DARKEN_1;

      case "LIGHT GREEN DARKEN 2":
        return Color.LIGHT_GREEN_DARKEN_2;

      case "LIGHT GREEN DARKEN 3":
        return Color.LIGHT_GREEN_DARKEN_3;

      case "LIGHT GREEN DARKEN 4":
        return Color.LIGHT_GREEN_DARKEN_4;

      case "LIGHT GREEN LIGHTEN 1":
        return Color.LIGHT_GREEN_LIGHTEN_1;

      case "LIGHT GREEN LIGHTEN 2":
        return Color.LIGHT_GREEN_LIGHTEN_2;

      case "LIGHT GREEN LIGHTEN 3":
        return Color.LIGHT_GREEN_LIGHTEN_3;

      case "LIGHT GREEN LIGHTEN 4":
        return Color.LIGHT_GREEN_LIGHTEN_4;

      case "LIGHT GREEN LIGHTEN 5":
        return Color.LIGHT_GREEN_LIGHTEN_5;

      case "LIME":
        return Color.LIME;

      case "LIME DARKEN 1":
        return Color.LIME_DARKEN_1;

      case "LIME DARKEN 2":
        return Color.LIME_DARKEN_2;

      case "LIME DARKEN 3":
        return Color.LIME_DARKEN_3;

      case "LIME DARKEN 4":
        return Color.LIME_DARKEN_4;

      case "LIME LIGHTEN 1":
        return Color.LIME_LIGHTEN_1;

      case "LIME LIGHTEN 2":
        return Color.LIME_LIGHTEN_2;

      case "LIME LIGHTEN 3":
        return Color.LIME_LIGHTEN_3;

      case "LIME LIGHTEN 4":
        return Color.LIME_LIGHTEN_4;

      case "LIME LIGHTEN 5":
        return Color.LIME_LIGHTEN_5;

      case "YELLOW":
        return Color.YELLOW;

      case "YELLOW DARKEN 1":
        return Color.YELLOW_DARKEN_1;

      case "YELLOW DARKEN 2":
        return Color.YELLOW_DARKEN_2;

      case "YELLOW DARKEN 3":
        return Color.YELLOW_DARKEN_3;

      case "YELLOW DARKEN 4":
        return Color.YELLOW_DARKEN_4;

      case "YELLOW LIGHTEN 1":
        return Color.YELLOW_LIGHTEN_1;

      case "YELLOW LIGHTEN 2":
        return Color.YELLOW_LIGHTEN_2;

      case "YELLOW LIGHTEN 3":
        return Color.YELLOW_LIGHTEN_3;

      case "YELLOW LIGHTEN 4":
        return Color.YELLOW_LIGHTEN_4;

      case "YELLOW LIGHTEN 5":
        return Color.YELLOW_LIGHTEN_5;

      case "AMBER":
        return Color.AMBER;

      case "AMBER DARKEN 1":
        return Color.AMBER_DARKEN_1;

      case "AMBER DARKEN 2":
        return Color.AMBER_DARKEN_2;

      case "AMBER DARKEN 3":
        return Color.AMBER_DARKEN_3;

      case "AMBER DARKEN 4":
        return Color.AMBER_DARKEN_4;

      case "AMBER LIGHTEN 1":
        return Color.AMBER_LIGHTEN_1;

      case "AMBER LIGHTEN 2":
        return Color.AMBER_LIGHTEN_2;

      case "AMBER LIGHTEN 3":
        return Color.AMBER_LIGHTEN_3;

      case "AMBER LIGHTEN 4":
        return Color.AMBER_LIGHTEN_4;

      case "AMBER LIGHTEN 5":
        return Color.AMBER_LIGHTEN_5;

      case "ORANGE":
        return Color.ORANGE;

      case "ORANGE DARKEN 1":
        return Color.ORANGE_DARKEN_1;

      case "ORANGE DARKEN 2":
        return Color.ORANGE_DARKEN_2;

      case "ORANGE DARKEN 3":
        return Color.ORANGE_DARKEN_3;

      case "ORANGE DARKEN 4":
        return Color.ORANGE_DARKEN_4;

      case "ORANGE LIGHTEN 1":
        return Color.ORANGE_LIGHTEN_1;

      case "ORANGE LIGHTEN 2":
        return Color.ORANGE_LIGHTEN_2;

      case "ORANGE LIGHTEN 3":
        return Color.ORANGE_LIGHTEN_3;

      case "ORANGE LIGHTEN 4":
        return Color.ORANGE_LIGHTEN_4;

      case "ORANGE LIGHTEN 5":
        return Color.ORANGE_LIGHTEN_5;

      case "DEEP ORANGE":
        return Color.DEEP_ORANGE;

      case "DEEP ORANGE DARKEN 1":
        return Color.DEEP_ORANGE_DARKEN_1;

      case "DEEP ORANGE DARKEN 2":
        return Color.DEEP_ORANGE_DARKEN_2;

      case "DEEP ORANGE DARKEN 3":
        return Color.DEEP_ORANGE_DARKEN_3;

      case "DEEP ORANGE DARKEN 4":
        return Color.DEEP_ORANGE_DARKEN_4;

      case "DEEP ORANGE LIGHTEN 1":
        return Color.DEEP_ORANGE_LIGHTEN_1;

      case "DEEP ORANGE LIGHTEN 2":
        return Color.DEEP_ORANGE_LIGHTEN_2;

      case "DEEP ORANGE LIGHTEN 3":
        return Color.DEEP_ORANGE_LIGHTEN_3;

      case "DEEP ORANGE LIGHTEN 4":
        return Color.DEEP_ORANGE_LIGHTEN_4;

      case "DEEP ORANGE LIGHTEN 5":
        return Color.DEEP_ORANGE_LIGHTEN_5;

      case "BROWN":
        return Color.BROWN;

      case "BROWN DARKEN 1":
        return Color.BROWN_DARKEN_1;

      case "BROWN DARKEN 2":
        return Color.BROWN_DARKEN_2;

      case "BROWN DARKEN 3":
        return Color.BROWN_DARKEN_3;

      case "BROWN DARKEN 4":
        return Color.BROWN_DARKEN_4;

      case "BROWN LIGHTEN 1":
        return Color.BROWN_LIGHTEN_1;

      case "BROWN LIGHTEN 2":
        return Color.BROWN_LIGHTEN_2;

      case "BROWN LIGHTEN 3":
        return Color.BROWN_LIGHTEN_3;

      case "BROWN LIGHTEN 4":
        return Color.BROWN_LIGHTEN_4;

      case "BROWN LIGHTEN 5":
        return Color.BROWN_LIGHTEN_5;

      case "GREY":
        return Color.GREY;

      case "GREY DARKEN 1":
        return Color.GREY_DARKEN_1;

      case "GREY DARKEN 2":
        return Color.GREY_DARKEN_2;

      case "GREY DARKEN 3":
        return Color.GREY_DARKEN_3;

      case "GREY DARKEN 4":
        return Color.GREY_DARKEN_4;

      case "GREY LIGHTEN 1":
        return Color.GREY_LIGHTEN_1;

      case "GREY LIGHTEN 2":
        return Color.GREY_LIGHTEN_2;

      case "GREY LIGHTEN 3":
        return Color.GREY_LIGHTEN_3;

      case "GREY LIGHTEN 4":
        return Color.GREY_LIGHTEN_4;

      case "GREY LIGHTEN 5":
        return Color.GREY_LIGHTEN_5;

      case "BLUE GREY":
        return Color.BLUE_GREY;

      case "BLUE GREY DARKEN 1":
        return Color.BLUE_GREY_DARKEN_1;

      case "BLUE GREY DARKEN 2":
        return Color.BLUE_GREY_DARKEN_2;

      case "BLUE GREY DARKEN 3":
        return Color.BLUE_GREY_DARKEN_3;

      case "BLUE GREY DARKEN 4":
        return Color.BLUE_GREY_DARKEN_4;

      case "BLUE GREY LIGHTEN 1":
        return Color.BLUE_GREY_LIGHTEN_1;

      case "BLUE GREY LIGHTEN 2":
        return Color.BLUE_GREY_LIGHTEN_2;

      case "BLUE GREY LIGHTEN 3":
        return Color.BLUE_GREY_LIGHTEN_3;

      case "BLUE GREY LIGHTEN 4":
        return Color.BLUE_GREY_LIGHTEN_4;

      case "BLUE GREY LIGHTEN 5":
        return Color.BLUE_GREY_LIGHTEN_5;

      case "BLACK":
        return Color.BLACK;

      case "BLACK DARKEN 1":
        return Color.BLACK_DARKEN_1;

      case "BLACK DARKEN 2":
        return Color.BLACK_DARKEN_2;

      case "BLACK DARKEN 3":
        return Color.BLACK_DARKEN_3;

      case "BLACK DARKEN 4":
        return Color.BLACK_DARKEN_4;

      case "BLACK LIGHTEN 1":
        return Color.BLACK_LIGHTEN_1;

      case "BLACK LIGHTEN 2":
        return Color.BLACK_LIGHTEN_2;

      case "BLACK LIGHTEN 3":
        return Color.BLACK_LIGHTEN_3;

      case "BLACK LIGHTEN 4":
        return Color.BLACK_LIGHTEN_4;

      case "BLACK LIGHTEN 5":
        return Color.BLACK_LIGHTEN_5;

      case "WHITE":
        return Color.WHITE;

      case "WHITE DARKEN 1":
        return Color.WHITE_DARKEN_1;

      case "WHITE DARKEN 2":
        return Color.WHITE_DARKEN_2;

      case "WHITE DARKEN 3":
        return Color.WHITE_DARKEN_3;

      case "WHITE DARKEN 4":
        return Color.WHITE_DARKEN_4;

      case "WHITE LIGHTEN 1":
        return Color.WHITE_LIGHTEN_1;

      case "WHITE LIGHTEN 2":
        return Color.WHITE_LIGHTEN_2;

      case "WHITE LIGHTEN 3":
        return Color.WHITE_LIGHTEN_3;

      case "WHITE LIGHTEN 4":
        return Color.WHITE_LIGHTEN_4;

      case "WHITE LIGHTEN 5":
        return Color.WHITE_LIGHTEN_5;

      case "TRANSPARENT":
        return Color.TRANSPARENT;

      case "TRANSPARENT DARKEN 1":
        return Color.TRANSPARENT_DARKEN_1;

      case "TRANSPARENT DARKEN 2":
        return Color.TRANSPARENT_DARKEN_2;

      case "TRANSPARENT DARKEN 3":
        return Color.TRANSPARENT_DARKEN_3;

      case "TRANSPARENT DARKEN 4":
        return Color.TRANSPARENT_DARKEN_4;

      case "TRANSPARENT LIGHTEN 1":
        return Color.TRANSPARENT_LIGHTEN_1;

      case "TRANSPARENT LIGHTEN 2":
        return Color.TRANSPARENT_LIGHTEN_2;

      case "TRANSPARENT LIGHTEN 3":
        return Color.TRANSPARENT_LIGHTEN_3;

      case "TRANSPARENT LIGHTEN 4":
        return Color.TRANSPARENT_LIGHTEN_4;

      case "TRANSPARENT LIGHTEN 5":
        return Color.TRANSPARENT_LIGHTEN_5;
      default:
        throw new IllegalArgumentException("Color [" + name + "] not found!");
    }
  }
}
