/*
 * Copyright © 2019 Dominokit
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dominokit.domino.ui.button;

/** A constants class to reference css classes used in Button components */
public class ButtonStyles {
  /** The main css class for a button */
  public static final String BUTTON = "btn";
  /** a css class to change the button display to block */
  public static final String BUTTON_BLOCK = "btn-block";
  /** a css class to make the button looks like a link */
  public static final String BUTTON_LINK = "btn-link";
  /** the main css class for buttons toolbar */
  public static final String BUTTON_TOOLBAR = "btn-toolbar";
  /** a css class to change the button to a circle button */
  public static final String BUTTON_CIRCLE = "circle";
  /** a css class to style the arrow in a dropdown button */
  public static final String CARET = "caret";
  /** the main css class for a dropdown button */
  public static final String BUTTON_DROPDOWN = "btn-dropdown";
  /** the css class for a toggled dropdown button */
  public static final String DROPDOWN_TOGGLE = "dropdown-toggle";
  /** a css class to linkify a button */
  public static final String LINK = "link";
  /** the mani css class for buttons group */
  public static final String BTN_GROUP = "btn-group";
  /** the css class for a vertical buttons group */
  public static final String BTN_GROUP_VERTICAL = "btn-group-vertical";
  /** a css class to justify a button */
  public static final String JUSTIFIED = "justified";
  /** the main css class for bordered buttons */
  public static final String BUTTON_BORDERED = "btn-bordered";
  /** a css class to make a button bordered */
  public static final String BTN_GROUP_BORDERED = "bordered";
}
