/*
 * Copyright © 2019 Dominokit
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dominokit.domino.ui.dropdown;

/** Default CSS classes for {@link DropDownMenu} */
public class DropDownStyles {
  /** CSS class for dropdown header element */
  public static final String DROPDOWN_HEADER = "dropdown-header";
  /** CSS class for a dropdown */
  public static final String DROPDOWN = "dropdown";
  /** CSS class for a dropdown menu element */
  public static final String DROPDOWN_MENU = "dropdown-menu";
  /** CSS class for a dropdown title container element */
  public static final String DROPDOWN_TITLE_CONTAINER = "dropdown-title-container";
  /** CSS class for a dropdown search container element */
  public static final String DROPDOWN_SEARCH_CONTAINER = "dropdown-search-container";
  /** CSS class for a dropdown search box element */
  public static final String DROPDOWN_SEARCH_BOX = "dropdown-search-box";
  /** CSS class for a dropdown no results element */
  public static final String NO_RESULTS = "no-results";
  /** CSS class for a dropdown divider element */
  public static final String DIVIDER = "divider";
}
