/*
 * Copyright © 2019 Dominokit
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dominokit.domino.ui.grid;

/** Default CSS classes for {@link GridLayout} */
public class GridStyles {
  /** CSS style for a grid column */
  public static final String GRID_COL = "grid-col";
  /** CSS style for column condense */
  public static final String CONDENSE = "condense";

  /** CSS style for grid column XLarge size */
  public static final String SPAN_XL = "span-xl";
  /** CSS style for grid column Large size */
  public static final String SPAN_L = "span-l";
  /** CSS style for grid column Medium size */
  public static final String SPAN_M = "span-m";
  /** CSS style for grid column Small size */
  public static final String SPAN_S = "span-s";
  /** CSS style for grid column XSmall size */
  public static final String SPAN_XS = "span-xs";

  /** CSS style for grid column XLarge offset */
  public static final String OFFSET_XL = "offset-xl";
  /** CSS style for grid column Large offset */
  public static final String OFFSET_L = "offset-l";
  /** CSS style for grid column Medium offset */
  public static final String OFFSET_M = "offset-m";
  /** CSS style for grid column Small offset */
  public static final String OFFSET_S = "offset-s";
  /** CSS style for grid column XSmall offset */
  public static final String OFFSET_XS = "offset-xs";

  /** CSS style for grid row with 12 columns */
  public static final String ROW_12 = "row-12";
  /** CSS style for grid row with 16 columns */
  public static final String ROW_16 = "row-16";
  /** CSS style for grid row with 18 columns */
  public static final String ROW_18 = "row-18";
  /** CSS style for grid row with 24 columns */
  public static final String ROW_24 = "row-24";
  /** CSS style for grid row with 32 columns */
  public static final String ROW_32 = "row-32";

  /** CSS style for grid layout */
  public static final String LAYOUT_GRID = "layout-grid";
  /** CSS style for grid layout content */
  public static final String LAYOUT_CONTENT = "layout-content";
  /** CSS style for grid layout header */
  public static final String LAYOUT_HEADER = "layout-header";
  /** CSS style for grid layout footer */
  public static final String LAYOUT_FOOTER = "layout-footer";
  /** CSS style for grid layout left section */
  public static final String LAYOUT_LEFT = "layout-left";
  /** CSS style for grid layout right section */
  public static final String LAYOUT_RIGHT = "layout-right";
  /** CSS style for grid row */
  public static final String GRID_ROW = "grid-row";
}
