/*
 * Copyright © 2019 Dominokit
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dominokit.domino.ui.media;

/** Default CSS classes for {@link MediaObject} */
public class MediaStyles {
  /** CSS class for media header element */
  public static final String MEDIA_HEADING = "media-heading";
  /** CSS class for media body */
  public static final String MEDIA_BODY = "media-body";
  /** CSS class for media object */
  public static final String MEDIA = "media";
  /** CSS class for media left element */
  public static final String MEDIA_LEFT = "media-left";
  /** CSS class for media right element */
  public static final String MEDIA_RIGHT = "media-right";
  /** CSS class for middle alignment */
  public static final String MEDIA_MIDDLE = "media-middle";
  /** CSS class for bottom alignment */
  public static final String MEDIA_BOTTOM = "media-bottom";
  /** CSS class for top alignment */
  public static final String MEDIA_TOP = "media-top";
}
