/*
 * Copyright © 2019 Dominokit
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dominokit.domino.ui.progress;

/** A constants class for {@link Progress} and {@link ProgressBar} css classes */
public class ProgressStyles {
  /** the main Progress css class */
  public static final String progress = "progress";
  /** the main ProgressBar css class */
  public static final String progress_bar = "progress-bar";
  /** The css to add the stripes effect to a ProgressBar */
  public static final String progress_bar_striped = "progress-bar-striped";
  /** The css to add the animated effect to a ProgressBar */
  public static final String active = "active";
  /** The css to indicate the operation is progressing successfully */
  public static final String progress_bar_success = "progress-bar-success";
  /** The css to indicate the operation is progressing with warnings */
  public static final String progress_bar_warning = "progress-bar-warning";
  /** The css to indicate the operation is progressing successfully with some info */
  public static final String progress_bar_info = "progress-bar-info";
  /** The css to indicate the operation is progressing with errors */
  public static final String progress_bar_danger = "progress-bar-danger";
}
