/*
 * Copyright © 2019 Dominokit
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dominokit.domino.ui.spin;

/** Default CSS classes for {@link SpinSelect} and {@link SpinItem} */
public class SpinStyles {
  /** CSS class for previous element */
  public static final String PREV = "prev";
  /** CSS class for disabled spin */
  public static final String DISABLED = "disabled";
  /** CSS class for next element */
  public static final String NEXT = "next";
  /** CSS class for spin content element */
  public static final String SPIN_CONTENT = "spin-content";
  /** CSS class for spin container */
  public static final String SPIN_CONTAINER = "spin-container";
  /** CSS class for horizontal spin */
  public static final String H_SPIN = "h-spin";
  /** CSS class for vertical spin */
  public static final String V_SPIN = "v-spin";
  /** CSS class for spin item */
  public static final String SPIN_ITEM = "spin-item";
}
