/*
 * Copyright © 2019 Dominokit
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dominokit.domino.ui.utils;

import elemental2.dom.HTMLElement;
import org.jboss.elemento.IsElement;

/**
 * A component that can be wrapped in an {@link HtmlComponentBuilder} should implement this
 * interface
 *
 * @param <E> the the type of the component root element
 * @param <C> the type of the component implementing this interface
 */
public interface IsHtmlComponent<E extends HTMLElement, C extends IsElement<E>> {
  /** @return the {@link HtmlComponentBuilder} wrapping the component */
  HtmlComponentBuilder<E, C> htmlBuilder();
}
