/*
 * Copyright © 2019 Dominokit
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dominokit.domino.ui.icons.lib;

import java.util.Arrays;
import org.dominokit.domino.ui.icons.MdiIcon;
import org.dominokit.domino.ui.icons.MdiMeta;

/** This is a generated class, please don't modify */
public class IconsMeta {
  public static MdiIcon ab_testing() {
    return MdiIcon.create(
        "mdi-ab-testing",
        new MdiMeta(
            "ab-testing",
            "F01C9",
            Arrays.asList("Developer / Languages"),
            Arrays.asList(),
            "Michael Richins",
            "4.0.96"));
  }

  public static MdiIcon abacus() {
    return MdiIcon.create(
        "mdi-abacus",
        new MdiMeta(
            "abacus",
            "F16E0",
            Arrays.asList("Math"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.9.55"));
  }

  public static MdiIcon abjad_arabic() {
    return MdiIcon.create(
        "mdi-abjad-arabic",
        new MdiMeta(
            "abjad-arabic",
            "F1328",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("writing-system-arabic"),
            "Haley Halcyon",
            "4.9.95"));
  }

  public static MdiIcon abjad_hebrew() {
    return MdiIcon.create(
        "mdi-abjad-hebrew",
        new MdiMeta(
            "abjad-hebrew",
            "F1329",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("writing-system-hebrew"),
            "Haley Halcyon",
            "4.9.95"));
  }

  public static MdiIcon abugida_devanagari() {
    return MdiIcon.create(
        "mdi-abugida-devanagari",
        new MdiMeta(
            "abugida-devanagari",
            "F132A",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("writing-system-devanagari"),
            "Haley Halcyon",
            "4.9.95"));
  }

  public static MdiIcon abugida_thai() {
    return MdiIcon.create(
        "mdi-abugida-thai",
        new MdiMeta(
            "abugida-thai",
            "F132B",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("writing-system-thai"),
            "Haley Halcyon",
            "4.9.95"));
  }

  public static MdiIcon access_point() {
    return MdiIcon.create(
        "mdi-access-point",
        new MdiMeta(
            "access-point",
            "F0003",
            Arrays.asList(),
            Arrays.asList("wireless"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon access_point_check() {
    return MdiIcon.create(
        "mdi-access-point-check",
        new MdiMeta(
            "access-point-check",
            "F1538",
            Arrays.asList(),
            Arrays.asList("access-point-success", "access-point-tick"),
            "Colton Wiscombe",
            "5.4.55"));
  }

  public static MdiIcon access_point_minus() {
    return MdiIcon.create(
        "mdi-access-point-minus",
        new MdiMeta(
            "access-point-minus",
            "F1539",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.4.55"));
  }

  public static MdiIcon access_point_network() {
    return MdiIcon.create(
        "mdi-access-point-network",
        new MdiMeta(
            "access-point-network", "F0002", Arrays.asList(), Arrays.asList(), "Simran", "1.5.54"));
  }

  public static MdiIcon access_point_network_off() {
    return MdiIcon.create(
        "mdi-access-point-network-off",
        new MdiMeta(
            "access-point-network-off",
            "F0BE1",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon access_point_off() {
    return MdiIcon.create(
        "mdi-access-point-off",
        new MdiMeta(
            "access-point-off",
            "F1511",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.4.55"));
  }

  public static MdiIcon access_point_plus() {
    return MdiIcon.create(
        "mdi-access-point-plus",
        new MdiMeta(
            "access-point-plus",
            "F153A",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.4.55"));
  }

  public static MdiIcon access_point_remove() {
    return MdiIcon.create(
        "mdi-access-point-remove",
        new MdiMeta(
            "access-point-remove",
            "F153B",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.4.55"));
  }

  public static MdiIcon account() {
    return MdiIcon.create(
        "mdi-account",
        new MdiMeta(
            "account",
            "F0004",
            Arrays.asList("Account / User", "Home Automation"),
            Arrays.asList("person", "user"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon account_alert() {
    return MdiIcon.create(
        "mdi-account-alert",
        new MdiMeta(
            "account-alert",
            "F0005",
            Arrays.asList("Account / User", "Alert / Error"),
            Arrays.asList(
                "user-alert", "account-warning", "user-warning", "person-alert", "person-warning"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon account_alert_outline() {
    return MdiIcon.create(
        "mdi-account-alert-outline",
        new MdiMeta(
            "account-alert-outline",
            "F0B50",
            Arrays.asList("Account / User", "Alert / Error"),
            Arrays.asList(
                "user-alert-outline",
                "account-warning-outline",
                "user-warning-outline",
                "person-warning-outline",
                "person-alert-outline"),
            "Coffeemate",
            "3.0.39"));
  }

  public static MdiIcon account_arrow_down() {
    return MdiIcon.create(
        "mdi-account-arrow-down",
        new MdiMeta(
            "account-arrow-down",
            "F1868",
            Arrays.asList("Account / User"),
            Arrays.asList("account-download"),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon account_arrow_down_outline() {
    return MdiIcon.create(
        "mdi-account-arrow-down-outline",
        new MdiMeta(
            "account-arrow-down-outline",
            "F1869",
            Arrays.asList("Account / User"),
            Arrays.asList("account-download-outline"),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon account_arrow_left() {
    return MdiIcon.create(
        "mdi-account-arrow-left",
        new MdiMeta(
            "account-arrow-left",
            "F0B51",
            Arrays.asList("Account / User"),
            Arrays.asList("user-arrow-left", "person-arrow-left"),
            "Coffeemate",
            "3.0.39"));
  }

  public static MdiIcon account_arrow_left_outline() {
    return MdiIcon.create(
        "mdi-account-arrow-left-outline",
        new MdiMeta(
            "account-arrow-left-outline",
            "F0B52",
            Arrays.asList("Account / User"),
            Arrays.asList("user-arrow-left-outline", "person-arrow-left-outline"),
            "Coffeemate",
            "3.0.39"));
  }

  public static MdiIcon account_arrow_right() {
    return MdiIcon.create(
        "mdi-account-arrow-right",
        new MdiMeta(
            "account-arrow-right",
            "F0B53",
            Arrays.asList("Account / User"),
            Arrays.asList("user-arrow-right", "person-arrow-right"),
            "Coffeemate",
            "3.0.39"));
  }

  public static MdiIcon account_arrow_right_outline() {
    return MdiIcon.create(
        "mdi-account-arrow-right-outline",
        new MdiMeta(
            "account-arrow-right-outline",
            "F0B54",
            Arrays.asList("Account / User"),
            Arrays.asList("user-arrow-right-outline", "person-arrow-right-outline"),
            "Coffeemate",
            "3.0.39"));
  }

  public static MdiIcon account_arrow_up() {
    return MdiIcon.create(
        "mdi-account-arrow-up",
        new MdiMeta(
            "account-arrow-up",
            "F1867",
            Arrays.asList("Account / User"),
            Arrays.asList("account-upload"),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon account_arrow_up_outline() {
    return MdiIcon.create(
        "mdi-account-arrow-up-outline",
        new MdiMeta(
            "account-arrow-up-outline",
            "F186A",
            Arrays.asList("Account / User"),
            Arrays.asList("account-upload-outline"),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon account_badge() {
    return MdiIcon.create(
        "mdi-account-badge",
        new MdiMeta(
            "account-badge",
            "F1B0A",
            Arrays.asList("Account / User"),
            Arrays.asList("account-online", "user-online"),
            "Andrej Sharapov",
            "6.9.96"));
  }

  public static MdiIcon account_badge_outline() {
    return MdiIcon.create(
        "mdi-account-badge-outline",
        new MdiMeta(
            "account-badge-outline",
            "F1B0B",
            Arrays.asList("Account / User"),
            Arrays.asList("user-online-outline", "account-online-outline"),
            "Andrej Sharapov",
            "6.9.96"));
  }

  public static MdiIcon account_box() {
    return MdiIcon.create(
        "mdi-account-box",
        new MdiMeta(
            "account-box",
            "F0006",
            Arrays.asList("Account / User"),
            Arrays.asList("selfie", "user-box", "person-box", "contact"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon account_box_multiple() {
    return MdiIcon.create(
        "mdi-account-box-multiple",
        new MdiMeta(
            "account-box-multiple",
            "F0934",
            Arrays.asList("Account / User"),
            Arrays.asList(
                "switch-account",
                "user-box-multiple",
                "account-boxes",
                "user-boxes",
                "person-box-multiple",
                "person-boxes"),
            "Google",
            "2.4.85"));
  }

  public static MdiIcon account_box_multiple_outline() {
    return MdiIcon.create(
        "mdi-account-box-multiple-outline",
        new MdiMeta(
            "account-box-multiple-outline",
            "F100A",
            Arrays.asList("Account / User"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.1.95"));
  }

  public static MdiIcon account_box_outline() {
    return MdiIcon.create(
        "mdi-account-box-outline",
        new MdiMeta(
            "account-box-outline",
            "F0007",
            Arrays.asList("Account / User"),
            Arrays.asList(
                "selfie-outline",
                "user-box-outline",
                "portrait",
                "contact-outline",
                "person-box-outline"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon account_cancel() {
    return MdiIcon.create(
        "mdi-account-cancel",
        new MdiMeta(
            "account-cancel",
            "F12DF",
            Arrays.asList("Account / User"),
            Arrays.asList("user-cancel", "user-block", "person-cancel", "person-block"),
            "Simran",
            "4.8.95"));
  }

  public static MdiIcon account_cancel_outline() {
    return MdiIcon.create(
        "mdi-account-cancel-outline",
        new MdiMeta(
            "account-cancel-outline",
            "F12E0",
            Arrays.asList("Account / User"),
            Arrays.asList(
                "user-cancel-outline",
                "user-block-outline",
                "person-cancel-outline",
                "person-block-outline"),
            "Simran",
            "4.8.95"));
  }

  public static MdiIcon account_card() {
    return MdiIcon.create(
        "mdi-account-card",
        new MdiMeta(
            "account-card",
            "F1BA4",
            Arrays.asList("Account / User"),
            Arrays.asList(),
            "Jeff Anders",
            "7.0.96"));
  }

  public static MdiIcon account_card_outline() {
    return MdiIcon.create(
        "mdi-account-card-outline",
        new MdiMeta(
            "account-card-outline",
            "F1BA5",
            Arrays.asList("Account / User"),
            Arrays.asList(),
            "Jeff Anders",
            "7.0.96"));
  }

  public static MdiIcon account_cash() {
    return MdiIcon.create(
        "mdi-account-cash",
        new MdiMeta(
            "account-cash",
            "F1097",
            Arrays.asList("Account / User", "Banking", "Currency"),
            Arrays.asList(),
            "Jacob Wright",
            "4.2.95"));
  }

  public static MdiIcon account_cash_outline() {
    return MdiIcon.create(
        "mdi-account-cash-outline",
        new MdiMeta(
            "account-cash-outline",
            "F1098",
            Arrays.asList("Account / User", "Banking", "Currency"),
            Arrays.asList(),
            "Jacob Wright",
            "4.2.95"));
  }

  public static MdiIcon account_check() {
    return MdiIcon.create(
        "mdi-account-check",
        new MdiMeta(
            "account-check",
            "F0008",
            Arrays.asList("Account / User"),
            Arrays.asList(
                "user-check",
                "account-tick",
                "user-tick",
                "person-check",
                "person-tick",
                "how-to-reg",
                "account-success"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon account_check_outline() {
    return MdiIcon.create(
        "mdi-account-check-outline",
        new MdiMeta(
            "account-check-outline",
            "F0BE2",
            Arrays.asList("Account / User"),
            Arrays.asList(
                "account-tick-outline",
                "user-check-outline",
                "user-tick-outline",
                "person-check-outline",
                "person-tick-outline",
                "how-to-reg-outline",
                "account-success-outline"),
            "Google",
            "3.2.89"));
  }

  public static MdiIcon account_child() {
    return MdiIcon.create(
        "mdi-account-child",
        new MdiMeta(
            "account-child",
            "F0A89",
            Arrays.asList("Account / User"),
            Arrays.asList("user-child", "person-child", "guardian"),
            "Google",
            "2.7.94"));
  }

  public static MdiIcon account_child_circle() {
    return MdiIcon.create(
        "mdi-account-child-circle",
        new MdiMeta(
            "account-child-circle",
            "F0A8A",
            Arrays.asList("Account / User"),
            Arrays.asList("user-child-circle", "person-child-circle", "guardian-circle"),
            "Google",
            "2.7.94"));
  }

  public static MdiIcon account_child_outline() {
    return MdiIcon.create(
        "mdi-account-child-outline",
        new MdiMeta(
            "account-child-outline",
            "F10C8",
            Arrays.asList("Account / User"),
            Arrays.asList(),
            "Sascha Wohlgemuth",
            "4.3.95"));
  }

  public static MdiIcon account_circle() {
    return MdiIcon.create(
        "mdi-account-circle",
        new MdiMeta(
            "account-circle",
            "F0009",
            Arrays.asList("Account / User"),
            Arrays.asList("user-circle", "person-circle"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon account_circle_outline() {
    return MdiIcon.create(
        "mdi-account-circle-outline",
        new MdiMeta(
            "account-circle-outline",
            "F0B55",
            Arrays.asList("Account / User"),
            Arrays.asList("user-circle-outline", "person-circle-outline"),
            "Google",
            "3.0.39"));
  }

  public static MdiIcon account_clock() {
    return MdiIcon.create(
        "mdi-account-clock",
        new MdiMeta(
            "account-clock",
            "F0B56",
            Arrays.asList("Account / User", "Date / Time"),
            Arrays.asList("user-clock", "account-pending", "person-clock"),
            "Coffeemate",
            "3.0.39"));
  }

  public static MdiIcon account_clock_outline() {
    return MdiIcon.create(
        "mdi-account-clock-outline",
        new MdiMeta(
            "account-clock-outline",
            "F0B57",
            Arrays.asList("Account / User", "Date / Time"),
            Arrays.asList("user-clock-outline", "account-pending-outline", "person-clock-outline"),
            "Coffeemate",
            "3.0.39"));
  }

  public static MdiIcon account_cog() {
    return MdiIcon.create(
        "mdi-account-cog",
        new MdiMeta(
            "account-cog",
            "F1370",
            Arrays.asList("Account / User", "Settings"),
            Arrays.asList("account-settings"),
            "Michael Irigoyen",
            "4.9.95"));
  }

  public static MdiIcon account_cog_outline() {
    return MdiIcon.create(
        "mdi-account-cog-outline",
        new MdiMeta(
            "account-cog-outline",
            "F1371",
            Arrays.asList("Account / User", "Settings"),
            Arrays.asList("account-settings-outline"),
            "Michael Irigoyen",
            "4.9.95"));
  }

  public static MdiIcon account_convert() {
    return MdiIcon.create(
        "mdi-account-convert",
        new MdiMeta(
            "account-convert",
            "F000A",
            Arrays.asList("Account / User"),
            Arrays.asList("user-convert", "person-convert"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon account_convert_outline() {
    return MdiIcon.create(
        "mdi-account-convert-outline",
        new MdiMeta(
            "account-convert-outline",
            "F1301",
            Arrays.asList("Account / User"),
            Arrays.asList(),
            "Simran",
            "4.8.95"));
  }

  public static MdiIcon account_cowboy_hat() {
    return MdiIcon.create(
        "mdi-account-cowboy-hat",
        new MdiMeta(
            "account-cowboy-hat",
            "F0E9B",
            Arrays.asList("Account / User", "Agriculture"),
            Arrays.asList("rancher"),
            "Augustin Ursu",
            "3.7.94"));
  }

  public static MdiIcon account_cowboy_hat_outline() {
    return MdiIcon.create(
        "mdi-account-cowboy-hat-outline",
        new MdiMeta(
            "account-cowboy-hat-outline",
            "F17F3",
            Arrays.asList("Account / User", "Agriculture"),
            Arrays.asList("rancher-outline"),
            "Jeff Anders",
            "6.1.95"));
  }

  public static MdiIcon account_credit_card() {
    return MdiIcon.create(
        "mdi-account-credit-card",
        new MdiMeta(
            "account-credit-card",
            "F1BA6",
            Arrays.asList("Account / User", "Banking"),
            Arrays.asList("account-payment", "cardholder"),
            "Jeff Anders",
            "7.0.96"));
  }

  public static MdiIcon account_credit_card_outline() {
    return MdiIcon.create(
        "mdi-account-credit-card-outline",
        new MdiMeta(
            "account-credit-card-outline",
            "F1BA7",
            Arrays.asList("Account / User", "Banking"),
            Arrays.asList("account-payment-outline", "cardholder-outline"),
            "Jeff Anders",
            "7.0.96"));
  }

  public static MdiIcon account_details() {
    return MdiIcon.create(
        "mdi-account-details",
        new MdiMeta(
            "account-details",
            "F0631",
            Arrays.asList("Account / User", "Settings"),
            Arrays.asList("user-details", "person-details"),
            "Google",
            "1.6.50"));
  }

  public static MdiIcon account_details_outline() {
    return MdiIcon.create(
        "mdi-account-details-outline",
        new MdiMeta(
            "account-details-outline",
            "F1372",
            Arrays.asList("Account / User", "Settings"),
            Arrays.asList("person-details-outline", "user-details-outline"),
            "Simran",
            "4.9.95"));
  }

  public static MdiIcon account_edit() {
    return MdiIcon.create(
        "mdi-account-edit",
        new MdiMeta(
            "account-edit",
            "F06BC",
            Arrays.asList("Account / User", "Edit / Modify"),
            Arrays.asList("user-edit", "person-edit"),
            "Michael Richins",
            "1.8.36"));
  }

  public static MdiIcon account_edit_outline() {
    return MdiIcon.create(
        "mdi-account-edit-outline",
        new MdiMeta(
            "account-edit-outline",
            "F0FFB",
            Arrays.asList("Account / User", "Edit / Modify"),
            Arrays.asList(),
            "Michael Richins",
            "4.0.96"));
  }

  public static MdiIcon account_eye() {
    return MdiIcon.create(
        "mdi-account-eye",
        new MdiMeta(
            "account-eye",
            "F0420",
            Arrays.asList("Account / User"),
            Arrays.asList("account-view"),
            "Michael Irigoyen",
            "1.5.54"));
  }

  public static MdiIcon account_eye_outline() {
    return MdiIcon.create(
        "mdi-account-eye-outline",
        new MdiMeta(
            "account-eye-outline",
            "F127B",
            Arrays.asList("Account / User"),
            Arrays.asList("account-view-outline"),
            "Michael Irigoyen",
            "4.7.95"));
  }

  public static MdiIcon account_filter() {
    return MdiIcon.create(
        "mdi-account-filter",
        new MdiMeta(
            "account-filter",
            "F0936",
            Arrays.asList("Account / User"),
            Arrays.asList("account-funnel", "leads"),
            "Michael Irigoyen",
            "2.4.85"));
  }

  public static MdiIcon account_filter_outline() {
    return MdiIcon.create(
        "mdi-account-filter-outline",
        new MdiMeta(
            "account-filter-outline",
            "F0F9D",
            Arrays.asList("Account / User"),
            Arrays.asList("account-funnel-outline", "leads-outline"),
            "Michael Irigoyen",
            "4.0.96"));
  }

  public static MdiIcon account_group() {
    return MdiIcon.create(
        "mdi-account-group",
        new MdiMeta(
            "account-group",
            "F0849",
            Arrays.asList("Account / User", "Home Automation"),
            Arrays.asList(
                "user-group", "users-group", "person-group", "people-group", "accounts-group"),
            "GreenTurtwig",
            "2.1.99"));
  }

  public static MdiIcon account_group_outline() {
    return MdiIcon.create(
        "mdi-account-group-outline",
        new MdiMeta(
            "account-group-outline",
            "F0B58",
            Arrays.asList("Account / User"),
            Arrays.asList(
                "user-group-outline",
                "users-group-outline",
                "person-group-outline",
                "people-group-outline",
                "accounts-group-outline"),
            "GreenTurtwig",
            "3.0.39"));
  }

  public static MdiIcon account_hard_hat() {
    return MdiIcon.create(
        "mdi-account-hard-hat",
        new MdiMeta(
            "account-hard-hat",
            "F05B5",
            Arrays.asList("Account / User"),
            Arrays.asList("worker", "construction"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon account_hard_hat_outline() {
    return MdiIcon.create(
        "mdi-account-hard-hat-outline",
        new MdiMeta(
            "account-hard-hat-outline",
            "F1A1F",
            Arrays.asList("Account / User"),
            Arrays.asList("worker-outline", "construction-outline"),
            "Contributors",
            "6.6.96"));
  }

  public static MdiIcon account_heart() {
    return MdiIcon.create(
        "mdi-account-heart",
        new MdiMeta(
            "account-heart",
            "F0899",
            Arrays.asList("Account / User", "Medical / Hospital"),
            Arrays.asList("user-heart", "person-heart"),
            "Michael Irigoyen",
            "2.2.43"));
  }

  public static MdiIcon account_heart_outline() {
    return MdiIcon.create(
        "mdi-account-heart-outline",
        new MdiMeta(
            "account-heart-outline",
            "F0BE3",
            Arrays.asList("Account / User", "Medical / Hospital"),
            Arrays.asList("user-heart-outline", "person-heart-outline"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon account_injury() {
    return MdiIcon.create(
        "mdi-account-injury",
        new MdiMeta(
            "account-injury",
            "F1815",
            Arrays.asList("Medical / Hospital", "Account / User"),
            Arrays.asList("account-disability", "patient"),
            "Google",
            "6.1.95"));
  }

  public static MdiIcon account_injury_outline() {
    return MdiIcon.create(
        "mdi-account-injury-outline",
        new MdiMeta(
            "account-injury-outline",
            "F1816",
            Arrays.asList("Account / User", "Medical / Hospital"),
            Arrays.asList("account-disability-outline", "patient-outline"),
            "Google",
            "6.1.95"));
  }

  public static MdiIcon account_key() {
    return MdiIcon.create(
        "mdi-account-key",
        new MdiMeta(
            "account-key",
            "F000B",
            Arrays.asList("Account / User"),
            Arrays.asList("user-key", "person-key"),
            "REJack",
            "1.5.54"));
  }

  public static MdiIcon account_key_outline() {
    return MdiIcon.create(
        "mdi-account-key-outline",
        new MdiMeta(
            "account-key-outline",
            "F0BE4",
            Arrays.asList("Account / User"),
            Arrays.asList("user-key-outline", "person-key-outline"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon account_lock() {
    return MdiIcon.create(
        "mdi-account-lock",
        new MdiMeta(
            "account-lock",
            "F115E",
            Arrays.asList("Account / User", "Lock"),
            Arrays.asList("account-security", "account-secure", "user-lock", "person-lock"),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon account_lock_open() {
    return MdiIcon.create(
        "mdi-account-lock-open",
        new MdiMeta(
            "account-lock-open",
            "F1960",
            Arrays.asList("Account / User", "Lock"),
            Arrays.asList("account-unlocked", "user-unlocked", "user-lock-open"),
            "Michael Irigoyen",
            "6.5.95"));
  }

  public static MdiIcon account_lock_open_outline() {
    return MdiIcon.create(
        "mdi-account-lock-open-outline",
        new MdiMeta(
            "account-lock-open-outline",
            "F1961",
            Arrays.asList("Account / User", "Lock"),
            Arrays.asList(
                "user-lock-open-outline", "user-unlocked-outline", "account-unlocked-outline"),
            "Michael Irigoyen",
            "6.5.95"));
  }

  public static MdiIcon account_lock_outline() {
    return MdiIcon.create(
        "mdi-account-lock-outline",
        new MdiMeta(
            "account-lock-outline",
            "F115F",
            Arrays.asList("Account / User", "Lock"),
            Arrays.asList(
                "account-security-outline",
                "account-secure-outline",
                "person-lock-outline",
                "user-lock-outline"),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon account_minus() {
    return MdiIcon.create(
        "mdi-account-minus",
        new MdiMeta(
            "account-minus",
            "F000D",
            Arrays.asList("Account / User"),
            Arrays.asList("user-minus", "person-minus"),
            "REJack",
            "1.5.54"));
  }

  public static MdiIcon account_minus_outline() {
    return MdiIcon.create(
        "mdi-account-minus-outline",
        new MdiMeta(
            "account-minus-outline",
            "F0AEC",
            Arrays.asList("Account / User"),
            Arrays.asList("user-minus-outline", "person-minus-outline"),
            "Peter Noble",
            "2.8.94"));
  }

  public static MdiIcon account_multiple() {
    return MdiIcon.create(
        "mdi-account-multiple",
        new MdiMeta(
            "account-multiple",
            "F000E",
            Arrays.asList("Account / User"),
            Arrays.asList(
                "people", "user-multiple", "group", "accounts", "users", "person-multiple"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon account_multiple_check() {
    return MdiIcon.create(
        "mdi-account-multiple-check",
        new MdiMeta(
            "account-multiple-check",
            "F08C5",
            Arrays.asList("Account / User"),
            Arrays.asList(
                "user-multiple-check",
                "account-multiple-tick",
                "accounts-check",
                "accounts-tick",
                "users-check",
                "users-tick",
                "user-multiple-tick",
                "person-multiple-check",
                "person-multiple-tick",
                "people-check",
                "people-tick",
                "account-multiple-success"),
            "Roberto Graham",
            "2.3.50"));
  }

  public static MdiIcon account_multiple_check_outline() {
    return MdiIcon.create(
        "mdi-account-multiple-check-outline",
        new MdiMeta(
            "account-multiple-check-outline",
            "F11FE",
            Arrays.asList("Account / User"),
            Arrays.asList(
                "user-multiple-check-outline",
                "account-multiple-tick-outline",
                "accounts-check-outline",
                "accounts-tick-outline",
                "users-check-outline",
                "users-tick-outline",
                "user-multiple-tick-outline",
                "person-multiple-check-outline",
                "person-multiple-tick-outline",
                "people-check-outline",
                "people-tick-outline",
                "account-multiple-success-outline"),
            "Michael Richins",
            "4.6.95"));
  }

  public static MdiIcon account_multiple_minus() {
    return MdiIcon.create(
        "mdi-account-multiple-minus",
        new MdiMeta(
            "account-multiple-minus",
            "F05D3",
            Arrays.asList("Account / User"),
            Arrays.asList(
                "user-multiple-minus",
                "accounts-minus",
                "users-minus",
                "people-minus",
                "person-multiple-minus"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon account_multiple_minus_outline() {
    return MdiIcon.create(
        "mdi-account-multiple-minus-outline",
        new MdiMeta(
            "account-multiple-minus-outline",
            "F0BE5",
            Arrays.asList("Account / User"),
            Arrays.asList(
                "accounts-minus-outline",
                "people-minus-outline",
                "user-multiple-minus-outline",
                "users-minus-outline",
                "person-multiple-minus-outline"),
            "Google",
            "3.2.89"));
  }

  public static MdiIcon account_multiple_outline() {
    return MdiIcon.create(
        "mdi-account-multiple-outline",
        new MdiMeta(
            "account-multiple-outline",
            "F000F",
            Arrays.asList("Account / User"),
            Arrays.asList(
                "user-multiple-outline", "people-outline", "accounts-outline", "users-outline"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon account_multiple_plus() {
    return MdiIcon.create(
        "mdi-account-multiple-plus",
        new MdiMeta(
            "account-multiple-plus",
            "F0010",
            Arrays.asList("Account / User"),
            Arrays.asList(
                "user-multiple-plus",
                "group-add",
                "accounts-plus",
                "users-plus",
                "person-multiple-plus",
                "people-plus",
                "person-multiple-add",
                "people-add",
                "account-multiple-add",
                "accounts-add",
                "user-multiple-add",
                "users-add",
                "invite"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon account_multiple_plus_outline() {
    return MdiIcon.create(
        "mdi-account-multiple-plus-outline",
        new MdiMeta(
            "account-multiple-plus-outline",
            "F0800",
            Arrays.asList("Account / User"),
            Arrays.asList(
                "group-add-outline",
                "user-multiple-plus-outline",
                "accounts-plus-outline",
                "users-plus-outline",
                "person-multiple-plus-outline",
                "people-plus-outline",
                "person-multiple-add-outline",
                "people-add-outline",
                "account-multiple-add-outline",
                "accounts-add-outline",
                "user-multiple-add-outline",
                "users-add-outline",
                "invite"),
            "Google",
            "2.1.19"));
  }

  public static MdiIcon account_multiple_remove() {
    return MdiIcon.create(
        "mdi-account-multiple-remove",
        new MdiMeta(
            "account-multiple-remove",
            "F120A",
            Arrays.asList("Account / User"),
            Arrays.asList("user-multiple-remove", "person-multiple-remove"),
            "Michael Richins",
            "4.6.95"));
  }

  public static MdiIcon account_multiple_remove_outline() {
    return MdiIcon.create(
        "mdi-account-multiple-remove-outline",
        new MdiMeta(
            "account-multiple-remove-outline",
            "F120B",
            Arrays.asList("Account / User"),
            Arrays.asList("user-multiple-remove-outline", "person-multiple-remove-outline"),
            "Michael Richins",
            "4.6.95"));
  }

  public static MdiIcon account_music() {
    return MdiIcon.create(
        "mdi-account-music",
        new MdiMeta(
            "account-music",
            "F0803",
            Arrays.asList("Account / User"),
            Arrays.asList("artist"),
            "Google",
            "2.1.19"));
  }

  public static MdiIcon account_music_outline() {
    return MdiIcon.create(
        "mdi-account-music-outline",
        new MdiMeta(
            "account-music-outline",
            "F0CE9",
            Arrays.asList("Account / User"),
            Arrays.asList("artist-outline"),
            "GreenTurtwig",
            "3.3.92"));
  }

  public static MdiIcon account_network() {
    return MdiIcon.create(
        "mdi-account-network",
        new MdiMeta(
            "account-network",
            "F0011",
            Arrays.asList("Account / User"),
            Arrays.asList("user-network", "person-network"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon account_network_off() {
    return MdiIcon.create(
        "mdi-account-network-off",
        new MdiMeta(
            "account-network-off",
            "F1AF1",
            Arrays.asList("Account / User"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.9.96"));
  }

  public static MdiIcon account_network_off_outline() {
    return MdiIcon.create(
        "mdi-account-network-off-outline",
        new MdiMeta(
            "account-network-off-outline",
            "F1AF2",
            Arrays.asList("Account / User"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.9.96"));
  }

  public static MdiIcon account_network_outline() {
    return MdiIcon.create(
        "mdi-account-network-outline",
        new MdiMeta(
            "account-network-outline",
            "F0BE6",
            Arrays.asList("Account / User"),
            Arrays.asList("user-network-outline", "person-network-outline"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon account_off() {
    return MdiIcon.create(
        "mdi-account-off",
        new MdiMeta(
            "account-off",
            "F0012",
            Arrays.asList("Account / User"),
            Arrays.asList("user-off", "person-off"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon account_off_outline() {
    return MdiIcon.create(
        "mdi-account-off-outline",
        new MdiMeta(
            "account-off-outline",
            "F0BE7",
            Arrays.asList("Account / User"),
            Arrays.asList("user-off-outline", "person-off-outline"),
            "Austin Andrews",
            "3.2.89"));
  }

  public static MdiIcon account_outline() {
    return MdiIcon.create(
        "mdi-account-outline",
        new MdiMeta(
            "account-outline",
            "F0013",
            Arrays.asList("Account / User"),
            Arrays.asList("user-outline", "perm-identity", "person-outline"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon account_plus() {
    return MdiIcon.create(
        "mdi-account-plus",
        new MdiMeta(
            "account-plus",
            "F0014",
            Arrays.asList("Account / User", "Home Automation"),
            Arrays.asList(
                "register",
                "user-plus",
                "person-add",
                "account-add",
                "person-plus",
                "user-add",
                "invite"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon account_plus_outline() {
    return MdiIcon.create(
        "mdi-account-plus-outline",
        new MdiMeta(
            "account-plus-outline",
            "F0801",
            Arrays.asList("Account / User"),
            Arrays.asList(
                "person-add-outline",
                "register-outline",
                "user-plus-outline",
                "account-add-outline",
                "person-plus-outline",
                "user-add-outline",
                "invite"),
            "GreenTurtwig",
            "2.1.19"));
  }

  public static MdiIcon account_question() {
    return MdiIcon.create(
        "mdi-account-question",
        new MdiMeta(
            "account-question",
            "F0B59",
            Arrays.asList("Account / User"),
            Arrays.asList(
                "user-help",
                "account-question-mark",
                "account-help",
                "user-question",
                "person-question",
                "person-help"),
            "Coffeemate",
            "3.0.39"));
  }

  public static MdiIcon account_question_outline() {
    return MdiIcon.create(
        "mdi-account-question-outline",
        new MdiMeta(
            "account-question-outline",
            "F0B5A",
            Arrays.asList("Account / User"),
            Arrays.asList(
                "account-question-mark-outline",
                "user-help-outline",
                "account-help-outline",
                "user-question-outline",
                "person-question-outline",
                "person-help-outline"),
            "Coffeemate",
            "3.0.39"));
  }

  public static MdiIcon account_reactivate() {
    return MdiIcon.create(
        "mdi-account-reactivate",
        new MdiMeta(
            "account-reactivate",
            "F152B",
            Arrays.asList("Account / User"),
            Arrays.asList(),
            "François Risoud",
            "5.4.55"));
  }

  public static MdiIcon account_reactivate_outline() {
    return MdiIcon.create(
        "mdi-account-reactivate-outline",
        new MdiMeta(
            "account-reactivate-outline",
            "F152C",
            Arrays.asList("Account / User"),
            Arrays.asList(),
            "François Risoud",
            "5.4.55"));
  }

  public static MdiIcon account_remove() {
    return MdiIcon.create(
        "mdi-account-remove",
        new MdiMeta(
            "account-remove",
            "F0015",
            Arrays.asList("Account / User"),
            Arrays.asList("user-remove", "person-remove"),
            "REJack",
            "1.5.54"));
  }

  public static MdiIcon account_remove_outline() {
    return MdiIcon.create(
        "mdi-account-remove-outline",
        new MdiMeta(
            "account-remove-outline",
            "F0AED",
            Arrays.asList("Account / User"),
            Arrays.asList("user-remove-outline", "person-remove-outline"),
            "Austin Andrews",
            "2.8.94"));
  }

  public static MdiIcon account_school() {
    return MdiIcon.create(
        "mdi-account-school",
        new MdiMeta(
            "account-school",
            "F1A20",
            Arrays.asList("Account / User"),
            Arrays.asList("account-student", "account-graduation"),
            "Contributors",
            "6.6.96"));
  }

  public static MdiIcon account_school_outline() {
    return MdiIcon.create(
        "mdi-account-school-outline",
        new MdiMeta(
            "account-school-outline",
            "F1A21",
            Arrays.asList("Account / User"),
            Arrays.asList("account-student-outline", "account-graduation-outline"),
            "Contributors",
            "6.6.96"));
  }

  public static MdiIcon account_search() {
    return MdiIcon.create(
        "mdi-account-search",
        new MdiMeta(
            "account-search",
            "F0016",
            Arrays.asList("Account / User"),
            Arrays.asList("user-search", "person-search"),
            "GreenTurtwig",
            "1.5.54"));
  }

  public static MdiIcon account_search_outline() {
    return MdiIcon.create(
        "mdi-account-search-outline",
        new MdiMeta(
            "account-search-outline",
            "F0935",
            Arrays.asList("Account / User"),
            Arrays.asList("user-search-outline", "person-search-outline"),
            "GreenTurtwig",
            "2.4.85"));
  }

  public static MdiIcon account_settings() {
    return MdiIcon.create(
        "mdi-account-settings",
        new MdiMeta(
            "account-settings",
            "F0630",
            Arrays.asList("Account / User", "Settings"),
            Arrays.asList("user-settings", "person-settings"),
            "Austin Andrews",
            "1.6.50"));
  }

  public static MdiIcon account_settings_outline() {
    return MdiIcon.create(
        "mdi-account-settings-outline",
        new MdiMeta(
            "account-settings-outline",
            "F10C9",
            Arrays.asList("Account / User", "Settings"),
            Arrays.asList(),
            "Sascha Wohlgemuth",
            "4.3.95"));
  }

  public static MdiIcon account_star() {
    return MdiIcon.create(
        "mdi-account-star",
        new MdiMeta(
            "account-star",
            "F0017",
            Arrays.asList("Account / User"),
            Arrays.asList("user-star", "person-star", "account-favorite"),
            "REJack",
            "1.5.54"));
  }

  public static MdiIcon account_star_outline() {
    return MdiIcon.create(
        "mdi-account-star-outline",
        new MdiMeta(
            "account-star-outline",
            "F0BE8",
            Arrays.asList("Account / User"),
            Arrays.asList("user-star-outline", "person-star-outline"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon account_supervisor() {
    return MdiIcon.create(
        "mdi-account-supervisor",
        new MdiMeta(
            "account-supervisor",
            "F0A8B",
            Arrays.asList("Account / User"),
            Arrays.asList("user-supervisor", "person-supervisor"),
            "Google",
            "2.7.94"));
  }

  public static MdiIcon account_supervisor_circle() {
    return MdiIcon.create(
        "mdi-account-supervisor-circle",
        new MdiMeta(
            "account-supervisor-circle",
            "F0A8C",
            Arrays.asList("Account / User"),
            Arrays.asList("user-supervisor-circle", "person-supervisor-circle"),
            "Google",
            "2.7.94"));
  }

  public static MdiIcon account_supervisor_circle_outline() {
    return MdiIcon.create(
        "mdi-account-supervisor-circle-outline",
        new MdiMeta(
            "account-supervisor-circle-outline",
            "F14EC",
            Arrays.asList("Account / User"),
            Arrays.asList(),
            "Google",
            "5.4.55"));
  }

  public static MdiIcon account_supervisor_outline() {
    return MdiIcon.create(
        "mdi-account-supervisor-outline",
        new MdiMeta(
            "account-supervisor-outline",
            "F112D",
            Arrays.asList("Account / User"),
            Arrays.asList(),
            "Sascha Wohlgemuth",
            "4.4.95"));
  }

  public static MdiIcon account_switch() {
    return MdiIcon.create(
        "mdi-account-switch",
        new MdiMeta(
            "account-switch",
            "F0019",
            Arrays.asList("Account / User"),
            Arrays.asList(
                "user-switch", "accounts-switch", "users-switch", "person-switch", "people-switch"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon account_switch_outline() {
    return MdiIcon.create(
        "mdi-account-switch-outline",
        new MdiMeta(
            "account-switch-outline",
            "F04CB",
            Arrays.asList("Account / User"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon account_sync() {
    return MdiIcon.create(
        "mdi-account-sync",
        new MdiMeta(
            "account-sync",
            "F191B",
            Arrays.asList("Account / User"),
            Arrays.asList("account-cache"),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon account_sync_outline() {
    return MdiIcon.create(
        "mdi-account-sync-outline",
        new MdiMeta(
            "account-sync-outline",
            "F191C",
            Arrays.asList("Account / User"),
            Arrays.asList("account-cache-outline"),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon account_tag() {
    return MdiIcon.create(
        "mdi-account-tag",
        new MdiMeta(
            "account-tag",
            "F1C1B",
            Arrays.asList("Account / User"),
            Arrays.asList(),
            "Matthew Terry",
            "7.1.96"));
  }

  public static MdiIcon account_tag_outline() {
    return MdiIcon.create(
        "mdi-account-tag-outline",
        new MdiMeta(
            "account-tag-outline",
            "F1C1C",
            Arrays.asList("Account / User"),
            Arrays.asList(),
            "Matthew Terry",
            "7.1.96"));
  }

  public static MdiIcon account_tie() {
    return MdiIcon.create(
        "mdi-account-tie",
        new MdiMeta(
            "account-tie",
            "F0CE3",
            Arrays.asList("Account / User", "People / Family"),
            Arrays.asList("person-tie", "user-tie"),
            "Michael Irigoyen",
            "3.3.92"));
  }

  public static MdiIcon account_tie_hat() {
    return MdiIcon.create(
        "mdi-account-tie-hat",
        new MdiMeta(
            "account-tie-hat",
            "F1898",
            Arrays.asList("Account / User", "Transportation + Flying"),
            Arrays.asList("account-pilot"),
            "Michael Irigoyen",
            "6.3.95"));
  }

  public static MdiIcon account_tie_hat_outline() {
    return MdiIcon.create(
        "mdi-account-tie-hat-outline",
        new MdiMeta(
            "account-tie-hat-outline",
            "F1899",
            Arrays.asList("Account / User", "Transportation + Flying"),
            Arrays.asList("account-pilot-outline"),
            "Michael Irigoyen",
            "6.3.95"));
  }

  public static MdiIcon account_tie_outline() {
    return MdiIcon.create(
        "mdi-account-tie-outline",
        new MdiMeta(
            "account-tie-outline",
            "F10CA",
            Arrays.asList("Account / User"),
            Arrays.asList(),
            "Sascha Wohlgemuth",
            "4.3.95"));
  }

  public static MdiIcon account_tie_voice() {
    return MdiIcon.create(
        "mdi-account-tie-voice",
        new MdiMeta(
            "account-tie-voice",
            "F1308",
            Arrays.asList("Account / User"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.8.95"));
  }

  public static MdiIcon account_tie_voice_off() {
    return MdiIcon.create(
        "mdi-account-tie-voice-off",
        new MdiMeta(
            "account-tie-voice-off",
            "F130A",
            Arrays.asList("Account / User"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.8.95"));
  }

  public static MdiIcon account_tie_voice_off_outline() {
    return MdiIcon.create(
        "mdi-account-tie-voice-off-outline",
        new MdiMeta(
            "account-tie-voice-off-outline",
            "F130B",
            Arrays.asList("Account / User"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.8.95"));
  }

  public static MdiIcon account_tie_voice_outline() {
    return MdiIcon.create(
        "mdi-account-tie-voice-outline",
        new MdiMeta(
            "account-tie-voice-outline",
            "F1309",
            Arrays.asList("Account / User"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.8.95"));
  }

  public static MdiIcon account_tie_woman() {
    return MdiIcon.create(
        "mdi-account-tie-woman",
        new MdiMeta(
            "account-tie-woman",
            "F1A8C",
            Arrays.asList("Account / User", "People / Family"),
            Arrays.asList("business-woman"),
            "Simran",
            "6.8.96"));
  }

  public static MdiIcon account_voice() {
    return MdiIcon.create(
        "mdi-account-voice",
        new MdiMeta(
            "account-voice",
            "F05CB",
            Arrays.asList("Account / User"),
            Arrays.asList("record-voice-over", "speak", "talk", "speaking", "talking"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon account_voice_off() {
    return MdiIcon.create(
        "mdi-account-voice-off",
        new MdiMeta(
            "account-voice-off",
            "F0ED4",
            Arrays.asList("Account / User"),
            Arrays.asList(),
            "Google",
            "3.7.95"));
  }

  public static MdiIcon account_wrench() {
    return MdiIcon.create(
        "mdi-account-wrench",
        new MdiMeta(
            "account-wrench",
            "F189A",
            Arrays.asList("Account / User"),
            Arrays.asList("account-service"),
            "Michael Irigoyen",
            "6.3.95"));
  }

  public static MdiIcon account_wrench_outline() {
    return MdiIcon.create(
        "mdi-account-wrench-outline",
        new MdiMeta(
            "account-wrench-outline",
            "F189B",
            Arrays.asList("Account / User"),
            Arrays.asList("account-service-outline"),
            "Michael Irigoyen",
            "6.3.95"));
  }

  public static MdiIcon adjust() {
    return MdiIcon.create(
        "mdi-adjust",
        new MdiMeta("adjust", "F001A", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon advertisements() {
    return MdiIcon.create(
        "mdi-advertisements",
        new MdiMeta(
            "advertisements",
            "F192A",
            Arrays.asList(),
            Arrays.asList("ads"),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon advertisements_off() {
    return MdiIcon.create(
        "mdi-advertisements-off",
        new MdiMeta(
            "advertisements-off",
            "F192B",
            Arrays.asList(),
            Arrays.asList("ads-off"),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon air_conditioner() {
    return MdiIcon.create(
        "mdi-air-conditioner",
        new MdiMeta(
            "air-conditioner",
            "F001B",
            Arrays.asList("Home Automation", "Automotive"),
            Arrays.asList("ac-unit"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon air_filter() {
    return MdiIcon.create(
        "mdi-air-filter",
        new MdiMeta(
            "air-filter",
            "F0D43",
            Arrays.asList("Home Automation"),
            Arrays.asList("water-filter", "filter"),
            "Michael Irigoyen",
            "3.4.93"));
  }

  public static MdiIcon air_horn() {
    return MdiIcon.create(
        "mdi-air-horn",
        new MdiMeta(
            "air-horn", "F0DAC", Arrays.asList(), Arrays.asList(), "Colton Wiscombe", "3.5.94"));
  }

  public static MdiIcon air_humidifier() {
    return MdiIcon.create(
        "mdi-air-humidifier",
        new MdiMeta(
            "air-humidifier",
            "F1099",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.2.95"));
  }

  public static MdiIcon air_humidifier_off() {
    return MdiIcon.create(
        "mdi-air-humidifier-off",
        new MdiMeta(
            "air-humidifier-off",
            "F1466",
            Arrays.asList("Home Automation"),
            Arrays.asList("air-dehumidifier"),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon air_purifier() {
    return MdiIcon.create(
        "mdi-air-purifier",
        new MdiMeta(
            "air-purifier",
            "F0D44",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Google",
            "3.4.93"));
  }

  public static MdiIcon air_purifier_off() {
    return MdiIcon.create(
        "mdi-air-purifier-off",
        new MdiMeta(
            "air-purifier-off",
            "F1B57",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Andrej Sharapov",
            "7.0.96"));
  }

  public static MdiIcon airbag() {
    return MdiIcon.create(
        "mdi-airbag",
        new MdiMeta(
            "airbag",
            "F0BE9",
            Arrays.asList("Automotive"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon airballoon() {
    return MdiIcon.create(
        "mdi-airballoon",
        new MdiMeta(
            "airballoon",
            "F001C",
            Arrays.asList("Transportation + Other", "Transportation + Flying"),
            Arrays.asList("hot-air-balloon"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon airballoon_outline() {
    return MdiIcon.create(
        "mdi-airballoon-outline",
        new MdiMeta(
            "airballoon-outline",
            "F100B",
            Arrays.asList("Transportation + Flying"),
            Arrays.asList("hot-air-balloon-outline"),
            "Michael Irigoyen",
            "4.1.95"));
  }

  public static MdiIcon airplane() {
    return MdiIcon.create(
        "mdi-airplane",
        new MdiMeta(
            "airplane",
            "F001D",
            Arrays.asList("Transportation + Flying", "Navigation"),
            Arrays.asList(
                "aeroplane",
                "airplanemode-active",
                "flight",
                "local-airport",
                "flight-mode",
                "plane"),
            "Colton Wiscombe",
            "1.5.54"));
  }

  public static MdiIcon airplane_alert() {
    return MdiIcon.create(
        "mdi-airplane-alert",
        new MdiMeta(
            "airplane-alert",
            "F187A",
            Arrays.asList("Transportation + Flying", "Alert / Error"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon airplane_check() {
    return MdiIcon.create(
        "mdi-airplane-check",
        new MdiMeta(
            "airplane-check",
            "F187B",
            Arrays.asList("Transportation + Flying"),
            Arrays.asList("airplace-success", "airplane-tick"),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon airplane_clock() {
    return MdiIcon.create(
        "mdi-airplane-clock",
        new MdiMeta(
            "airplane-clock",
            "F187C",
            Arrays.asList("Transportation + Flying", "Date / Time"),
            Arrays.asList("airplane-schedule", "airplane-time", "airplane-date"),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon airplane_cog() {
    return MdiIcon.create(
        "mdi-airplane-cog",
        new MdiMeta(
            "airplane-cog",
            "F187D",
            Arrays.asList("Transportation + Flying", "Settings"),
            Arrays.asList("airplane-settings"),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon airplane_edit() {
    return MdiIcon.create(
        "mdi-airplane-edit",
        new MdiMeta(
            "airplane-edit",
            "F187E",
            Arrays.asList("Transportation + Flying", "Edit / Modify"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon airplane_landing() {
    return MdiIcon.create(
        "mdi-airplane-landing",
        new MdiMeta(
            "airplane-landing",
            "F05D4",
            Arrays.asList("Transportation + Flying"),
            Arrays.asList("aeroplane-landing", "flight-land", "plane-landing"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon airplane_marker() {
    return MdiIcon.create(
        "mdi-airplane-marker",
        new MdiMeta(
            "airplane-marker",
            "F187F",
            Arrays.asList("Transportation + Flying", "Navigation"),
            Arrays.asList("airplane-location", "airplane-gps"),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon airplane_minus() {
    return MdiIcon.create(
        "mdi-airplane-minus",
        new MdiMeta(
            "airplane-minus",
            "F1880",
            Arrays.asList("Transportation + Flying"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon airplane_off() {
    return MdiIcon.create(
        "mdi-airplane-off",
        new MdiMeta(
            "airplane-off",
            "F001E",
            Arrays.asList("Transportation + Flying"),
            Arrays.asList("aeroplane-off", "airplanemode-inactive", "flight-mode-off", "plane-off"),
            "Colton Wiscombe",
            "1.5.54"));
  }

  public static MdiIcon airplane_plus() {
    return MdiIcon.create(
        "mdi-airplane-plus",
        new MdiMeta(
            "airplane-plus",
            "F1881",
            Arrays.asList("Transportation + Flying"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon airplane_remove() {
    return MdiIcon.create(
        "mdi-airplane-remove",
        new MdiMeta(
            "airplane-remove",
            "F1882",
            Arrays.asList("Transportation + Flying"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon airplane_search() {
    return MdiIcon.create(
        "mdi-airplane-search",
        new MdiMeta(
            "airplane-search",
            "F1883",
            Arrays.asList("Transportation + Flying"),
            Arrays.asList("airplane-find"),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon airplane_settings() {
    return MdiIcon.create(
        "mdi-airplane-settings",
        new MdiMeta(
            "airplane-settings",
            "F1884",
            Arrays.asList("Transportation + Flying", "Settings"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon airplane_takeoff() {
    return MdiIcon.create(
        "mdi-airplane-takeoff",
        new MdiMeta(
            "airplane-takeoff",
            "F05D5",
            Arrays.asList("Transportation + Flying"),
            Arrays.asList(
                "aeroplane-takeoff", "flight-takeoff", "plane-takeoff", "airplane-take-off"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon airport() {
    return MdiIcon.create(
        "mdi-airport",
        new MdiMeta(
            "airport",
            "F084B",
            Arrays.asList("Places", "Transportation + Flying"),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.1.99"));
  }

  public static MdiIcon alarm() {
    return MdiIcon.create(
        "mdi-alarm",
        new MdiMeta(
            "alarm",
            "F0020",
            Arrays.asList("Date / Time"),
            Arrays.asList("access-alarms", "alarm-clock"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon alarm_bell() {
    return MdiIcon.create(
        "mdi-alarm-bell",
        new MdiMeta(
            "alarm-bell",
            "F078E",
            Arrays.asList("Notification"),
            Arrays.asList(),
            "Michael Richins",
            "2.0.46"));
  }

  public static MdiIcon alarm_check() {
    return MdiIcon.create(
        "mdi-alarm-check",
        new MdiMeta(
            "alarm-check",
            "F0021",
            Arrays.asList("Date / Time"),
            Arrays.asList(
                "alarm-on", "alarm-tick", "alarm-clock-check", "alarm-clock-tick", "alarm-success"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon alarm_light() {
    return MdiIcon.create(
        "mdi-alarm-light",
        new MdiMeta(
            "alarm-light",
            "F078F",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Michael Richins",
            "2.0.46"));
  }

  public static MdiIcon alarm_light_off() {
    return MdiIcon.create(
        "mdi-alarm-light-off",
        new MdiMeta(
            "alarm-light-off",
            "F171E",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.9.55"));
  }

  public static MdiIcon alarm_light_off_outline() {
    return MdiIcon.create(
        "mdi-alarm-light-off-outline",
        new MdiMeta(
            "alarm-light-off-outline",
            "F171F",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.9.55"));
  }

  public static MdiIcon alarm_light_outline() {
    return MdiIcon.create(
        "mdi-alarm-light-outline",
        new MdiMeta(
            "alarm-light-outline",
            "F0BEA",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Austin Andrews",
            "3.2.89"));
  }

  public static MdiIcon alarm_multiple() {
    return MdiIcon.create(
        "mdi-alarm-multiple",
        new MdiMeta(
            "alarm-multiple",
            "F0022",
            Arrays.asList("Date / Time"),
            Arrays.asList("alarms", "alarm-clock-multiple", "alarm-clocks"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon alarm_note() {
    return MdiIcon.create(
        "mdi-alarm-note",
        new MdiMeta(
            "alarm-note", "F0E71", Arrays.asList(), Arrays.asList(), "Michael Richins", "3.7.94"));
  }

  public static MdiIcon alarm_note_off() {
    return MdiIcon.create(
        "mdi-alarm-note-off",
        new MdiMeta(
            "alarm-note-off",
            "F0E72",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "3.7.94"));
  }

  public static MdiIcon alarm_off() {
    return MdiIcon.create(
        "mdi-alarm-off",
        new MdiMeta(
            "alarm-off",
            "F0023",
            Arrays.asList("Date / Time"),
            Arrays.asList("alarm-clock-off"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon alarm_panel() {
    return MdiIcon.create(
        "mdi-alarm-panel",
        new MdiMeta(
            "alarm-panel",
            "F15C4",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.6.55"));
  }

  public static MdiIcon alarm_panel_outline() {
    return MdiIcon.create(
        "mdi-alarm-panel-outline",
        new MdiMeta(
            "alarm-panel-outline",
            "F15C5",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.6.55"));
  }

  public static MdiIcon alarm_plus() {
    return MdiIcon.create(
        "mdi-alarm-plus",
        new MdiMeta(
            "alarm-plus",
            "F0024",
            Arrays.asList("Date / Time"),
            Arrays.asList("add-alarm", "alarm-clock-plus", "alarm-clock-add", "alarm-add"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon alarm_snooze() {
    return MdiIcon.create(
        "mdi-alarm-snooze",
        new MdiMeta(
            "alarm-snooze",
            "F068E",
            Arrays.asList("Date / Time"),
            Arrays.asList("alarm-clock-snooze"),
            "Google",
            "1.7.12"));
  }

  public static MdiIcon album() {
    return MdiIcon.create(
        "mdi-album",
        new MdiMeta(
            "album",
            "F0025",
            Arrays.asList("Audio", "Music"),
            Arrays.asList("vinyl", "record"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon alert() {
    return MdiIcon.create(
        "mdi-alert",
        new MdiMeta(
            "alert",
            "F0026",
            Arrays.asList("Alert / Error"),
            Arrays.asList("warning", "report-problem"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon alert_box() {
    return MdiIcon.create(
        "mdi-alert-box",
        new MdiMeta(
            "alert-box",
            "F0027",
            Arrays.asList("Alert / Error"),
            Arrays.asList("warning-box"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon alert_box_outline() {
    return MdiIcon.create(
        "mdi-alert-box-outline",
        new MdiMeta(
            "alert-box-outline",
            "F0CE4",
            Arrays.asList("Alert / Error"),
            Arrays.asList("warning-box-outline"),
            "Peter Noble",
            "3.3.92"));
  }

  public static MdiIcon alert_circle() {
    return MdiIcon.create(
        "mdi-alert-circle",
        new MdiMeta(
            "alert-circle",
            "F0028",
            Arrays.asList("Alert / Error"),
            Arrays.asList("warning-circle", "error"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon alert_circle_check() {
    return MdiIcon.create(
        "mdi-alert-circle-check",
        new MdiMeta(
            "alert-circle-check",
            "F11ED",
            Arrays.asList("Alert / Error"),
            Arrays.asList("alert-circle-success"),
            "Austin Andrews",
            "4.5.95"));
  }

  public static MdiIcon alert_circle_check_outline() {
    return MdiIcon.create(
        "mdi-alert-circle-check-outline",
        new MdiMeta(
            "alert-circle-check-outline",
            "F11EE",
            Arrays.asList("Alert / Error"),
            Arrays.asList("alert-circle-success-outline"),
            "Austin Andrews",
            "4.5.95"));
  }

  public static MdiIcon alert_circle_outline() {
    return MdiIcon.create(
        "mdi-alert-circle-outline",
        new MdiMeta(
            "alert-circle-outline",
            "F05D6",
            Arrays.asList("Alert / Error"),
            Arrays.asList("warning-circle-outline", "error-outline", "git-issue"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon alert_decagram() {
    return MdiIcon.create(
        "mdi-alert-decagram",
        new MdiMeta(
            "alert-decagram",
            "F06BD",
            Arrays.asList("Alert / Error"),
            Arrays.asList("new-releases", "warning-decagram"),
            "Google",
            "1.8.36"));
  }

  public static MdiIcon alert_decagram_outline() {
    return MdiIcon.create(
        "mdi-alert-decagram-outline",
        new MdiMeta(
            "alert-decagram-outline",
            "F0CE5",
            Arrays.asList("Alert / Error"),
            Arrays.asList("warning-decagram-outline"),
            "Peter Noble",
            "3.3.92"));
  }

  public static MdiIcon alert_minus() {
    return MdiIcon.create(
        "mdi-alert-minus",
        new MdiMeta(
            "alert-minus",
            "F14BB",
            Arrays.asList("Alert / Error"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.3.45"));
  }

  public static MdiIcon alert_minus_outline() {
    return MdiIcon.create(
        "mdi-alert-minus-outline",
        new MdiMeta(
            "alert-minus-outline",
            "F14BE",
            Arrays.asList("Alert / Error"),
            Arrays.asList(),
            "Alessandro Rossignoli",
            "5.3.45"));
  }

  public static MdiIcon alert_octagon() {
    return MdiIcon.create(
        "mdi-alert-octagon",
        new MdiMeta(
            "alert-octagon",
            "F0029",
            Arrays.asList("Alert / Error"),
            Arrays.asList("warning-octagon", "report", "stop-alert"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon alert_octagon_outline() {
    return MdiIcon.create(
        "mdi-alert-octagon-outline",
        new MdiMeta(
            "alert-octagon-outline",
            "F0CE6",
            Arrays.asList("Alert / Error"),
            Arrays.asList("warning-octagon-outline", "stop-alert-outline"),
            "Peter Noble",
            "3.3.92"));
  }

  public static MdiIcon alert_octagram() {
    return MdiIcon.create(
        "mdi-alert-octagram",
        new MdiMeta(
            "alert-octagram",
            "F0767",
            Arrays.asList("Alert / Error"),
            Arrays.asList("warning-octagram"),
            "Austin Andrews",
            "1.9.32"));
  }

  public static MdiIcon alert_octagram_outline() {
    return MdiIcon.create(
        "mdi-alert-octagram-outline",
        new MdiMeta(
            "alert-octagram-outline",
            "F0CE7",
            Arrays.asList("Alert / Error"),
            Arrays.asList("warning-octagram-outline"),
            "Peter Noble",
            "3.3.92"));
  }

  public static MdiIcon alert_outline() {
    return MdiIcon.create(
        "mdi-alert-outline",
        new MdiMeta(
            "alert-outline",
            "F002A",
            Arrays.asList("Alert / Error"),
            Arrays.asList("warning-outline"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon alert_plus() {
    return MdiIcon.create(
        "mdi-alert-plus",
        new MdiMeta(
            "alert-plus",
            "F14BA",
            Arrays.asList("Alert / Error"),
            Arrays.asList(),
            "Austin Andrews",
            "5.3.45"));
  }

  public static MdiIcon alert_plus_outline() {
    return MdiIcon.create(
        "mdi-alert-plus-outline",
        new MdiMeta(
            "alert-plus-outline",
            "F14BD",
            Arrays.asList("Alert / Error"),
            Arrays.asList(),
            "Alessandro Rossignoli",
            "5.3.45"));
  }

  public static MdiIcon alert_remove() {
    return MdiIcon.create(
        "mdi-alert-remove",
        new MdiMeta(
            "alert-remove",
            "F14BC",
            Arrays.asList("Alert / Error"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.3.45"));
  }

  public static MdiIcon alert_remove_outline() {
    return MdiIcon.create(
        "mdi-alert-remove-outline",
        new MdiMeta(
            "alert-remove-outline",
            "F14BF",
            Arrays.asList("Alert / Error"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.3.45"));
  }

  public static MdiIcon alert_rhombus() {
    return MdiIcon.create(
        "mdi-alert-rhombus",
        new MdiMeta(
            "alert-rhombus",
            "F11CE",
            Arrays.asList("Alert / Error"),
            Arrays.asList(),
            "Michael Richins",
            "4.5.95"));
  }

  public static MdiIcon alert_rhombus_outline() {
    return MdiIcon.create(
        "mdi-alert-rhombus-outline",
        new MdiMeta(
            "alert-rhombus-outline",
            "F11CF",
            Arrays.asList("Alert / Error"),
            Arrays.asList(),
            "Michael Richins",
            "4.5.95"));
  }

  public static MdiIcon alien() {
    return MdiIcon.create(
        "mdi-alien",
        new MdiMeta(
            "alien", "F089A", Arrays.asList(), Arrays.asList(), "Austin Andrews", "2.2.43"));
  }

  public static MdiIcon alien_outline() {
    return MdiIcon.create(
        "mdi-alien-outline",
        new MdiMeta(
            "alien-outline",
            "F10CB",
            Arrays.asList(),
            Arrays.asList(),
            "Sascha Wohlgemuth",
            "4.3.95"));
  }

  public static MdiIcon align_horizontal_center() {
    return MdiIcon.create(
        "mdi-align-horizontal-center",
        new MdiMeta(
            "align-horizontal-center",
            "F11C3",
            Arrays.asList(),
            Arrays.asList("align-horizontal-centre"),
            "Google",
            "4.5.95"));
  }

  public static MdiIcon align_horizontal_distribute() {
    return MdiIcon.create(
        "mdi-align-horizontal-distribute",
        new MdiMeta(
            "align-horizontal-distribute",
            "F1962",
            Arrays.asList("Text / Content / Format"),
            Arrays.asList(),
            "Google",
            "6.5.95"));
  }

  public static MdiIcon align_horizontal_left() {
    return MdiIcon.create(
        "mdi-align-horizontal-left",
        new MdiMeta(
            "align-horizontal-left",
            "F11C2",
            Arrays.asList(),
            Arrays.asList(),
            "Google",
            "4.5.95"));
  }

  public static MdiIcon align_horizontal_right() {
    return MdiIcon.create(
        "mdi-align-horizontal-right",
        new MdiMeta(
            "align-horizontal-right",
            "F11C4",
            Arrays.asList(),
            Arrays.asList(),
            "Google",
            "4.5.95"));
  }

  public static MdiIcon align_vertical_bottom() {
    return MdiIcon.create(
        "mdi-align-vertical-bottom",
        new MdiMeta(
            "align-vertical-bottom",
            "F11C5",
            Arrays.asList(),
            Arrays.asList(),
            "Google",
            "4.5.95"));
  }

  public static MdiIcon align_vertical_center() {
    return MdiIcon.create(
        "mdi-align-vertical-center",
        new MdiMeta(
            "align-vertical-center",
            "F11C6",
            Arrays.asList(),
            Arrays.asList("align-vertical-centre"),
            "Google",
            "4.5.95"));
  }

  public static MdiIcon align_vertical_distribute() {
    return MdiIcon.create(
        "mdi-align-vertical-distribute",
        new MdiMeta(
            "align-vertical-distribute",
            "F1963",
            Arrays.asList("Text / Content / Format"),
            Arrays.asList(),
            "Google",
            "6.5.95"));
  }

  public static MdiIcon align_vertical_top() {
    return MdiIcon.create(
        "mdi-align-vertical-top",
        new MdiMeta(
            "align-vertical-top", "F11C7", Arrays.asList(), Arrays.asList(), "Google", "4.5.95"));
  }

  public static MdiIcon all_inclusive() {
    return MdiIcon.create(
        "mdi-all-inclusive",
        new MdiMeta(
            "all-inclusive",
            "F06BE",
            Arrays.asList(),
            Arrays.asList("infinity", "forever"),
            "Google",
            "1.8.36"));
  }

  public static MdiIcon all_inclusive_box() {
    return MdiIcon.create(
        "mdi-all-inclusive-box",
        new MdiMeta(
            "all-inclusive-box",
            "F188D",
            Arrays.asList(),
            Arrays.asList("infinity-box", "forever-box"),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon all_inclusive_box_outline() {
    return MdiIcon.create(
        "mdi-all-inclusive-box-outline",
        new MdiMeta(
            "all-inclusive-box-outline",
            "F188E",
            Arrays.asList(),
            Arrays.asList("forever-box-outline", "infinity-box-outline"),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon allergy() {
    return MdiIcon.create(
        "mdi-allergy",
        new MdiMeta(
            "allergy",
            "F1258",
            Arrays.asList("Medical / Hospital"),
            Arrays.asList("hand", "rash", "germ"),
            "Michael Richins",
            "4.7.95"));
  }

  public static MdiIcon alpha() {
    return MdiIcon.create(
        "mdi-alpha",
        new MdiMeta(
            "alpha",
            "F002B",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon alpha_a() {
    return MdiIcon.create(
        "mdi-alpha-a",
        new MdiMeta(
            "alpha-a",
            "F0AEE",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-a", "letter-a"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_a_box() {
    return MdiIcon.create(
        "mdi-alpha-a-box",
        new MdiMeta(
            "alpha-a-box",
            "F0B08",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-a-box", "letter-a-box"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_a_box_outline() {
    return MdiIcon.create(
        "mdi-alpha-a-box-outline",
        new MdiMeta(
            "alpha-a-box-outline",
            "F0BEB",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-a-box-outline", "letter-a-box-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_a_circle() {
    return MdiIcon.create(
        "mdi-alpha-a-circle",
        new MdiMeta(
            "alpha-a-circle",
            "F0BEC",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-a-circle", "letter-a-circle"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_a_circle_outline() {
    return MdiIcon.create(
        "mdi-alpha-a-circle-outline",
        new MdiMeta(
            "alpha-a-circle-outline",
            "F0BED",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-a-circle-outline", "letter-a-circle-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_b() {
    return MdiIcon.create(
        "mdi-alpha-b",
        new MdiMeta(
            "alpha-b",
            "F0AEF",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-b", "letter-b"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_b_box() {
    return MdiIcon.create(
        "mdi-alpha-b-box",
        new MdiMeta(
            "alpha-b-box",
            "F0B09",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-b-box", "letter-b-box"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_b_box_outline() {
    return MdiIcon.create(
        "mdi-alpha-b-box-outline",
        new MdiMeta(
            "alpha-b-box-outline",
            "F0BEE",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-b-box-outline", "letter-b-box-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_b_circle() {
    return MdiIcon.create(
        "mdi-alpha-b-circle",
        new MdiMeta(
            "alpha-b-circle",
            "F0BEF",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-b-circle", "letter-b-circle"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_b_circle_outline() {
    return MdiIcon.create(
        "mdi-alpha-b-circle-outline",
        new MdiMeta(
            "alpha-b-circle-outline",
            "F0BF0",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-b-circle-outline", "letter-b-circle-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_c() {
    return MdiIcon.create(
        "mdi-alpha-c",
        new MdiMeta(
            "alpha-c",
            "F0AF0",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-c", "letter-c"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_c_box() {
    return MdiIcon.create(
        "mdi-alpha-c-box",
        new MdiMeta(
            "alpha-c-box",
            "F0B0A",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-c-box", "letter-c-box"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_c_box_outline() {
    return MdiIcon.create(
        "mdi-alpha-c-box-outline",
        new MdiMeta(
            "alpha-c-box-outline",
            "F0BF1",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-c-box-outline", "letter-c-box-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_c_circle() {
    return MdiIcon.create(
        "mdi-alpha-c-circle",
        new MdiMeta(
            "alpha-c-circle",
            "F0BF2",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-c-circle", "letter-c-circle"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_c_circle_outline() {
    return MdiIcon.create(
        "mdi-alpha-c-circle-outline",
        new MdiMeta(
            "alpha-c-circle-outline",
            "F0BF3",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-c-circle-outline", "letter-c-circle-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_d() {
    return MdiIcon.create(
        "mdi-alpha-d",
        new MdiMeta(
            "alpha-d",
            "F0AF1",
            Arrays.asList("Automotive", "Alpha / Numeric"),
            Arrays.asList("alphabet-d", "letter-d", "drive"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_d_box() {
    return MdiIcon.create(
        "mdi-alpha-d-box",
        new MdiMeta(
            "alpha-d-box",
            "F0B0B",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-d-box", "letter-d-box"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_d_box_outline() {
    return MdiIcon.create(
        "mdi-alpha-d-box-outline",
        new MdiMeta(
            "alpha-d-box-outline",
            "F0BF4",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-d-box-outline", "letter-d-box-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_d_circle() {
    return MdiIcon.create(
        "mdi-alpha-d-circle",
        new MdiMeta(
            "alpha-d-circle",
            "F0BF5",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-d-circle", "letter-d-circle"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_d_circle_outline() {
    return MdiIcon.create(
        "mdi-alpha-d-circle-outline",
        new MdiMeta(
            "alpha-d-circle-outline",
            "F0BF6",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-d-circle-outline", "letter-d-circle-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_e() {
    return MdiIcon.create(
        "mdi-alpha-e",
        new MdiMeta(
            "alpha-e",
            "F0AF2",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-e", "letter-e"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_e_box() {
    return MdiIcon.create(
        "mdi-alpha-e-box",
        new MdiMeta(
            "alpha-e-box",
            "F0B0C",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-e-box", "letter-e-box"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_e_box_outline() {
    return MdiIcon.create(
        "mdi-alpha-e-box-outline",
        new MdiMeta(
            "alpha-e-box-outline",
            "F0BF7",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-e-box-outline", "letter-e-box-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_e_circle() {
    return MdiIcon.create(
        "mdi-alpha-e-circle",
        new MdiMeta(
            "alpha-e-circle",
            "F0BF8",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-e-circle", "letter-e-circle"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_e_circle_outline() {
    return MdiIcon.create(
        "mdi-alpha-e-circle-outline",
        new MdiMeta(
            "alpha-e-circle-outline",
            "F0BF9",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-e-circle-outline", "letter-e-circle-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_f() {
    return MdiIcon.create(
        "mdi-alpha-f",
        new MdiMeta(
            "alpha-f",
            "F0AF3",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-f", "letter-f"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_f_box() {
    return MdiIcon.create(
        "mdi-alpha-f-box",
        new MdiMeta(
            "alpha-f-box",
            "F0B0D",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-f-box", "letter-f-box"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_f_box_outline() {
    return MdiIcon.create(
        "mdi-alpha-f-box-outline",
        new MdiMeta(
            "alpha-f-box-outline",
            "F0BFA",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-f-box-outline", "letter-f-box-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_f_circle() {
    return MdiIcon.create(
        "mdi-alpha-f-circle",
        new MdiMeta(
            "alpha-f-circle",
            "F0BFB",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-f-circle", "letter-f-circle"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_f_circle_outline() {
    return MdiIcon.create(
        "mdi-alpha-f-circle-outline",
        new MdiMeta(
            "alpha-f-circle-outline",
            "F0BFC",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-f-circle-outline", "letter-f-circle-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_g() {
    return MdiIcon.create(
        "mdi-alpha-g",
        new MdiMeta(
            "alpha-g",
            "F0AF4",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-g", "letter-g"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_g_box() {
    return MdiIcon.create(
        "mdi-alpha-g-box",
        new MdiMeta(
            "alpha-g-box",
            "F0B0E",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-g-box", "letter-g-box"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_g_box_outline() {
    return MdiIcon.create(
        "mdi-alpha-g-box-outline",
        new MdiMeta(
            "alpha-g-box-outline",
            "F0BFD",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-g-box-outline", "letter-g-box-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_g_circle() {
    return MdiIcon.create(
        "mdi-alpha-g-circle",
        new MdiMeta(
            "alpha-g-circle",
            "F0BFE",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-g-circle", "letter-g-circle"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_g_circle_outline() {
    return MdiIcon.create(
        "mdi-alpha-g-circle-outline",
        new MdiMeta(
            "alpha-g-circle-outline",
            "F0BFF",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-g-circle-outline", "letter-g-circle-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_h() {
    return MdiIcon.create(
        "mdi-alpha-h",
        new MdiMeta(
            "alpha-h",
            "F0AF5",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-h", "letter-h"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_h_box() {
    return MdiIcon.create(
        "mdi-alpha-h-box",
        new MdiMeta(
            "alpha-h-box",
            "F0B0F",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-h-box", "letter-h-box"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_h_box_outline() {
    return MdiIcon.create(
        "mdi-alpha-h-box-outline",
        new MdiMeta(
            "alpha-h-box-outline",
            "F0C00",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-h-box-outline", "letter-h-box-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_h_circle() {
    return MdiIcon.create(
        "mdi-alpha-h-circle",
        new MdiMeta(
            "alpha-h-circle",
            "F0C01",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-h-circle", "letter-h-circle"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_h_circle_outline() {
    return MdiIcon.create(
        "mdi-alpha-h-circle-outline",
        new MdiMeta(
            "alpha-h-circle-outline",
            "F0C02",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-h-circle-outline", "letter-h-circle-outline", "helipad"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_i() {
    return MdiIcon.create(
        "mdi-alpha-i",
        new MdiMeta(
            "alpha-i",
            "F0AF6",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-i", "letter-i", "roman-numeral-1"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_i_box() {
    return MdiIcon.create(
        "mdi-alpha-i-box",
        new MdiMeta(
            "alpha-i-box",
            "F0B10",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-i-box", "letter-i-box"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_i_box_outline() {
    return MdiIcon.create(
        "mdi-alpha-i-box-outline",
        new MdiMeta(
            "alpha-i-box-outline",
            "F0C03",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-i-box-outline", "letter-i-box-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_i_circle() {
    return MdiIcon.create(
        "mdi-alpha-i-circle",
        new MdiMeta(
            "alpha-i-circle",
            "F0C04",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-i-circle", "letter-i-circle"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_i_circle_outline() {
    return MdiIcon.create(
        "mdi-alpha-i-circle-outline",
        new MdiMeta(
            "alpha-i-circle-outline",
            "F0C05",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-i-circle-outline", "letter-i-circle-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_j() {
    return MdiIcon.create(
        "mdi-alpha-j",
        new MdiMeta(
            "alpha-j",
            "F0AF7",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-j", "letter-j"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_j_box() {
    return MdiIcon.create(
        "mdi-alpha-j-box",
        new MdiMeta(
            "alpha-j-box",
            "F0B11",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-j-box", "letter-j-box"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_j_box_outline() {
    return MdiIcon.create(
        "mdi-alpha-j-box-outline",
        new MdiMeta(
            "alpha-j-box-outline",
            "F0C06",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-j-box-outline", "letter-j-box-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_j_circle() {
    return MdiIcon.create(
        "mdi-alpha-j-circle",
        new MdiMeta(
            "alpha-j-circle",
            "F0C07",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-j-circle", "letter-j-circle"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_j_circle_outline() {
    return MdiIcon.create(
        "mdi-alpha-j-circle-outline",
        new MdiMeta(
            "alpha-j-circle-outline",
            "F0C08",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-j-circle-outline", "letter-j-circle-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_k() {
    return MdiIcon.create(
        "mdi-alpha-k",
        new MdiMeta(
            "alpha-k",
            "F0AF8",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-k", "letter-k"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_k_box() {
    return MdiIcon.create(
        "mdi-alpha-k-box",
        new MdiMeta(
            "alpha-k-box",
            "F0B12",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-k-box", "letter-k-box"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_k_box_outline() {
    return MdiIcon.create(
        "mdi-alpha-k-box-outline",
        new MdiMeta(
            "alpha-k-box-outline",
            "F0C09",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-k-box-outline", "letter-k-box-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_k_circle() {
    return MdiIcon.create(
        "mdi-alpha-k-circle",
        new MdiMeta(
            "alpha-k-circle",
            "F0C0A",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-k-circle", "letter-k-circle"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_k_circle_outline() {
    return MdiIcon.create(
        "mdi-alpha-k-circle-outline",
        new MdiMeta(
            "alpha-k-circle-outline",
            "F0C0B",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-k-circle-outline", "letter-k-circle-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_l() {
    return MdiIcon.create(
        "mdi-alpha-l",
        new MdiMeta(
            "alpha-l",
            "F0AF9",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-l", "letter-l"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_l_box() {
    return MdiIcon.create(
        "mdi-alpha-l-box",
        new MdiMeta(
            "alpha-l-box",
            "F0B13",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-l-box", "letter-l-box"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_l_box_outline() {
    return MdiIcon.create(
        "mdi-alpha-l-box-outline",
        new MdiMeta(
            "alpha-l-box-outline",
            "F0C0C",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-l-box-outline", "letter-l-box-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_l_circle() {
    return MdiIcon.create(
        "mdi-alpha-l-circle",
        new MdiMeta(
            "alpha-l-circle",
            "F0C0D",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-l-circle", "letter-l-circle"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_l_circle_outline() {
    return MdiIcon.create(
        "mdi-alpha-l-circle-outline",
        new MdiMeta(
            "alpha-l-circle-outline",
            "F0C0E",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-l-circle-outline", "letter-l-circle-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_m() {
    return MdiIcon.create(
        "mdi-alpha-m",
        new MdiMeta(
            "alpha-m",
            "F0AFA",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-m", "letter-m"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_m_box() {
    return MdiIcon.create(
        "mdi-alpha-m-box",
        new MdiMeta(
            "alpha-m-box",
            "F0B14",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-m-box", "letter-m-box"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_m_box_outline() {
    return MdiIcon.create(
        "mdi-alpha-m-box-outline",
        new MdiMeta(
            "alpha-m-box-outline",
            "F0C0F",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-m-box-outline", "letter-m-box-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_m_circle() {
    return MdiIcon.create(
        "mdi-alpha-m-circle",
        new MdiMeta(
            "alpha-m-circle",
            "F0C10",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-m-circle", "letter-m-circle"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_m_circle_outline() {
    return MdiIcon.create(
        "mdi-alpha-m-circle-outline",
        new MdiMeta(
            "alpha-m-circle-outline",
            "F0C11",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-m-circle-outline", "letter-m-circle-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_n() {
    return MdiIcon.create(
        "mdi-alpha-n",
        new MdiMeta(
            "alpha-n",
            "F0AFB",
            Arrays.asList("Automotive", "Alpha / Numeric"),
            Arrays.asList("alphabet-n", "letter-n", "neutral"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_n_box() {
    return MdiIcon.create(
        "mdi-alpha-n-box",
        new MdiMeta(
            "alpha-n-box",
            "F0B15",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-n-box", "letter-n-box"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_n_box_outline() {
    return MdiIcon.create(
        "mdi-alpha-n-box-outline",
        new MdiMeta(
            "alpha-n-box-outline",
            "F0C12",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-n-box-outline", "letter-n-box-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_n_circle() {
    return MdiIcon.create(
        "mdi-alpha-n-circle",
        new MdiMeta(
            "alpha-n-circle",
            "F0C13",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-n-circle", "letter-n-circle"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_n_circle_outline() {
    return MdiIcon.create(
        "mdi-alpha-n-circle-outline",
        new MdiMeta(
            "alpha-n-circle-outline",
            "F0C14",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-n-circle-outline", "letter-n-circle-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_o() {
    return MdiIcon.create(
        "mdi-alpha-o",
        new MdiMeta(
            "alpha-o",
            "F0AFC",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-o", "letter-o"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_o_box() {
    return MdiIcon.create(
        "mdi-alpha-o-box",
        new MdiMeta(
            "alpha-o-box",
            "F0B16",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-o-box", "letter-o-box"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_o_box_outline() {
    return MdiIcon.create(
        "mdi-alpha-o-box-outline",
        new MdiMeta(
            "alpha-o-box-outline",
            "F0C15",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-o-box-outline", "letter-o-box-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_o_circle() {
    return MdiIcon.create(
        "mdi-alpha-o-circle",
        new MdiMeta(
            "alpha-o-circle",
            "F0C16",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-o-circle", "letter-o-circle"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_o_circle_outline() {
    return MdiIcon.create(
        "mdi-alpha-o-circle-outline",
        new MdiMeta(
            "alpha-o-circle-outline",
            "F0C17",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-o-circle-outline", "letter-o-circle-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_p() {
    return MdiIcon.create(
        "mdi-alpha-p",
        new MdiMeta(
            "alpha-p",
            "F0AFD",
            Arrays.asList("Automotive", "Alpha / Numeric"),
            Arrays.asList("alphabet-p", "letter-p", "park"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_p_box() {
    return MdiIcon.create(
        "mdi-alpha-p-box",
        new MdiMeta(
            "alpha-p-box",
            "F0B17",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-p-box", "letter-p-box"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_p_box_outline() {
    return MdiIcon.create(
        "mdi-alpha-p-box-outline",
        new MdiMeta(
            "alpha-p-box-outline",
            "F0C18",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-p-box-outline", "letter-p-box-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_p_circle() {
    return MdiIcon.create(
        "mdi-alpha-p-circle",
        new MdiMeta(
            "alpha-p-circle",
            "F0C19",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-p-circle", "letter-p-circle"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_p_circle_outline() {
    return MdiIcon.create(
        "mdi-alpha-p-circle-outline",
        new MdiMeta(
            "alpha-p-circle-outline",
            "F0C1A",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-p-circle-outline", "letter-p-circle-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_q() {
    return MdiIcon.create(
        "mdi-alpha-q",
        new MdiMeta(
            "alpha-q",
            "F0AFE",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-q", "letter-q"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_q_box() {
    return MdiIcon.create(
        "mdi-alpha-q-box",
        new MdiMeta(
            "alpha-q-box",
            "F0B18",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-q-box", "letter-q-box"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_q_box_outline() {
    return MdiIcon.create(
        "mdi-alpha-q-box-outline",
        new MdiMeta(
            "alpha-q-box-outline",
            "F0C1B",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-q-box-outline", "letter-q-box-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_q_circle() {
    return MdiIcon.create(
        "mdi-alpha-q-circle",
        new MdiMeta(
            "alpha-q-circle",
            "F0C1C",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-q-circle", "letter-q-circle"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_q_circle_outline() {
    return MdiIcon.create(
        "mdi-alpha-q-circle-outline",
        new MdiMeta(
            "alpha-q-circle-outline",
            "F0C1D",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-q-circle-outline", "letter-q-circle-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_r() {
    return MdiIcon.create(
        "mdi-alpha-r",
        new MdiMeta(
            "alpha-r",
            "F0AFF",
            Arrays.asList("Automotive", "Alpha / Numeric"),
            Arrays.asList("alphabet-r", "letter-r", "reverse"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_r_box() {
    return MdiIcon.create(
        "mdi-alpha-r-box",
        new MdiMeta(
            "alpha-r-box",
            "F0B19",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-r-box", "letter-r-box"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_r_box_outline() {
    return MdiIcon.create(
        "mdi-alpha-r-box-outline",
        new MdiMeta(
            "alpha-r-box-outline",
            "F0C1E",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-r-box-outline", "letter-r-box-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_r_circle() {
    return MdiIcon.create(
        "mdi-alpha-r-circle",
        new MdiMeta(
            "alpha-r-circle",
            "F0C1F",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-r-circle", "letter-r-circle"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_r_circle_outline() {
    return MdiIcon.create(
        "mdi-alpha-r-circle-outline",
        new MdiMeta(
            "alpha-r-circle-outline",
            "F0C20",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-r-circle-outline", "letter-r-circle-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_s() {
    return MdiIcon.create(
        "mdi-alpha-s",
        new MdiMeta(
            "alpha-s",
            "F0B00",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-s", "letter-s"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_s_box() {
    return MdiIcon.create(
        "mdi-alpha-s-box",
        new MdiMeta(
            "alpha-s-box",
            "F0B1A",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-s-box", "letter-s-box"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_s_box_outline() {
    return MdiIcon.create(
        "mdi-alpha-s-box-outline",
        new MdiMeta(
            "alpha-s-box-outline",
            "F0C21",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-s-box-outline", "letter-s-box-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_s_circle() {
    return MdiIcon.create(
        "mdi-alpha-s-circle",
        new MdiMeta(
            "alpha-s-circle",
            "F0C22",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-s-circle", "letter-s-circle"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_s_circle_outline() {
    return MdiIcon.create(
        "mdi-alpha-s-circle-outline",
        new MdiMeta(
            "alpha-s-circle-outline",
            "F0C23",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-s-circle-outline", "letter-s-circle-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_t() {
    return MdiIcon.create(
        "mdi-alpha-t",
        new MdiMeta(
            "alpha-t",
            "F0B01",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-t", "letter-t"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_t_box() {
    return MdiIcon.create(
        "mdi-alpha-t-box",
        new MdiMeta(
            "alpha-t-box",
            "F0B1B",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-t-box", "letter-t-box"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_t_box_outline() {
    return MdiIcon.create(
        "mdi-alpha-t-box-outline",
        new MdiMeta(
            "alpha-t-box-outline",
            "F0C24",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-t-box-outline", "letter-t-box-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_t_circle() {
    return MdiIcon.create(
        "mdi-alpha-t-circle",
        new MdiMeta(
            "alpha-t-circle",
            "F0C25",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-t-circle", "letter-t-circle"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_t_circle_outline() {
    return MdiIcon.create(
        "mdi-alpha-t-circle-outline",
        new MdiMeta(
            "alpha-t-circle-outline",
            "F0C26",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-t-circle-outline", "letter-t-circle-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_u() {
    return MdiIcon.create(
        "mdi-alpha-u",
        new MdiMeta(
            "alpha-u",
            "F0B02",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-u", "letter-u"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_u_box() {
    return MdiIcon.create(
        "mdi-alpha-u-box",
        new MdiMeta(
            "alpha-u-box",
            "F0B1C",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-u-box", "letter-u-box"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_u_box_outline() {
    return MdiIcon.create(
        "mdi-alpha-u-box-outline",
        new MdiMeta(
            "alpha-u-box-outline",
            "F0C27",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-u-box-outline", "letter-u-box-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_u_circle() {
    return MdiIcon.create(
        "mdi-alpha-u-circle",
        new MdiMeta(
            "alpha-u-circle",
            "F0C28",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-u-circle", "letter-u-circle"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_u_circle_outline() {
    return MdiIcon.create(
        "mdi-alpha-u-circle-outline",
        new MdiMeta(
            "alpha-u-circle-outline",
            "F0C29",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-u-circle-outline", "letter-u-circle-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_v() {
    return MdiIcon.create(
        "mdi-alpha-v",
        new MdiMeta(
            "alpha-v",
            "F0B03",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-v", "letter-v", "roman-numeral-5"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_v_box() {
    return MdiIcon.create(
        "mdi-alpha-v-box",
        new MdiMeta(
            "alpha-v-box",
            "F0B1D",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-v-box", "letter-v-box"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_v_box_outline() {
    return MdiIcon.create(
        "mdi-alpha-v-box-outline",
        new MdiMeta(
            "alpha-v-box-outline",
            "F0C2A",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-v-box-outline", "letter-v-box-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_v_circle() {
    return MdiIcon.create(
        "mdi-alpha-v-circle",
        new MdiMeta(
            "alpha-v-circle",
            "F0C2B",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-v-circle", "letter-v-circle"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_v_circle_outline() {
    return MdiIcon.create(
        "mdi-alpha-v-circle-outline",
        new MdiMeta(
            "alpha-v-circle-outline",
            "F0C2C",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-v-circle-outline", "letter-v-circle-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_w() {
    return MdiIcon.create(
        "mdi-alpha-w",
        new MdiMeta(
            "alpha-w",
            "F0B04",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-w", "letter-w"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_w_box() {
    return MdiIcon.create(
        "mdi-alpha-w-box",
        new MdiMeta(
            "alpha-w-box",
            "F0B1E",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-w-box", "letter-w-box"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_w_box_outline() {
    return MdiIcon.create(
        "mdi-alpha-w-box-outline",
        new MdiMeta(
            "alpha-w-box-outline",
            "F0C2D",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-w-box-outline", "letter-w-box-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_w_circle() {
    return MdiIcon.create(
        "mdi-alpha-w-circle",
        new MdiMeta(
            "alpha-w-circle",
            "F0C2E",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-w-circle", "letter-w-circle"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_w_circle_outline() {
    return MdiIcon.create(
        "mdi-alpha-w-circle-outline",
        new MdiMeta(
            "alpha-w-circle-outline",
            "F0C2F",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-w-circle-outline", "letter-w-circle-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_x() {
    return MdiIcon.create(
        "mdi-alpha-x",
        new MdiMeta(
            "alpha-x",
            "F0B05",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-x", "letter-x", "roman-numeral-10"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_x_box() {
    return MdiIcon.create(
        "mdi-alpha-x-box",
        new MdiMeta(
            "alpha-x-box",
            "F0B1F",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-x-box", "letter-x-box"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_x_box_outline() {
    return MdiIcon.create(
        "mdi-alpha-x-box-outline",
        new MdiMeta(
            "alpha-x-box-outline",
            "F0C30",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-x-box-outline", "letter-x-box-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_x_circle() {
    return MdiIcon.create(
        "mdi-alpha-x-circle",
        new MdiMeta(
            "alpha-x-circle",
            "F0C31",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-x-circle", "letter-x-circle"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_x_circle_outline() {
    return MdiIcon.create(
        "mdi-alpha-x-circle-outline",
        new MdiMeta(
            "alpha-x-circle-outline",
            "F0C32",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-x-circle-outline", "letter-x-circle-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_y() {
    return MdiIcon.create(
        "mdi-alpha-y",
        new MdiMeta(
            "alpha-y",
            "F0B06",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-y", "letter-y"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_y_box() {
    return MdiIcon.create(
        "mdi-alpha-y-box",
        new MdiMeta(
            "alpha-y-box",
            "F0B20",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-y-box", "letter-y-box"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_y_box_outline() {
    return MdiIcon.create(
        "mdi-alpha-y-box-outline",
        new MdiMeta(
            "alpha-y-box-outline",
            "F0C33",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-y-box-outline", "letter-y-box-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_y_circle() {
    return MdiIcon.create(
        "mdi-alpha-y-circle",
        new MdiMeta(
            "alpha-y-circle",
            "F0C34",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-y-circle", "letter-y-circle"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_y_circle_outline() {
    return MdiIcon.create(
        "mdi-alpha-y-circle-outline",
        new MdiMeta(
            "alpha-y-circle-outline",
            "F0C35",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-y-circle-outline", "letter-y-circle-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_z() {
    return MdiIcon.create(
        "mdi-alpha-z",
        new MdiMeta(
            "alpha-z",
            "F0B07",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-z", "letter-z"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_z_box() {
    return MdiIcon.create(
        "mdi-alpha-z-box",
        new MdiMeta(
            "alpha-z-box",
            "F0B21",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-z-box", "letter-z-box"),
            "GreenTurtwig",
            "2.8.94"));
  }

  public static MdiIcon alpha_z_box_outline() {
    return MdiIcon.create(
        "mdi-alpha-z-box-outline",
        new MdiMeta(
            "alpha-z-box-outline",
            "F0C36",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-z-box-outline", "letter-z-box-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_z_circle() {
    return MdiIcon.create(
        "mdi-alpha-z-circle",
        new MdiMeta(
            "alpha-z-circle",
            "F0C37",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-z-circle", "letter-z-circle"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alpha_z_circle_outline() {
    return MdiIcon.create(
        "mdi-alpha-z-circle-outline",
        new MdiMeta(
            "alpha-z-circle-outline",
            "F0C38",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("alphabet-z-circle-outline", "letter-z-circle-outline"),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon alphabet_aurebesh() {
    return MdiIcon.create(
        "mdi-alphabet-aurebesh",
        new MdiMeta(
            "alphabet-aurebesh",
            "F132C",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("writing-system-aurebesh"),
            "Haley Halcyon",
            "4.9.95"));
  }

  public static MdiIcon alphabet_cyrillic() {
    return MdiIcon.create(
        "mdi-alphabet-cyrillic",
        new MdiMeta(
            "alphabet-cyrillic",
            "F132D",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("writing-system-cyrillic"),
            "Haley Halcyon",
            "4.9.95"));
  }

  public static MdiIcon alphabet_greek() {
    return MdiIcon.create(
        "mdi-alphabet-greek",
        new MdiMeta(
            "alphabet-greek",
            "F132E",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("writing-system-greek"),
            "Haley Halcyon",
            "4.9.95"));
  }

  public static MdiIcon alphabet_latin() {
    return MdiIcon.create(
        "mdi-alphabet-latin",
        new MdiMeta(
            "alphabet-latin",
            "F132F",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("writing-system-latin"),
            "Haley Halcyon",
            "4.9.95"));
  }

  public static MdiIcon alphabet_piqad() {
    return MdiIcon.create(
        "mdi-alphabet-piqad",
        new MdiMeta(
            "alphabet-piqad",
            "F1330",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("writing-system-piqad"),
            "Haley Halcyon",
            "4.9.95"));
  }

  public static MdiIcon alphabet_tengwar() {
    return MdiIcon.create(
        "mdi-alphabet-tengwar",
        new MdiMeta(
            "alphabet-tengwar",
            "F1337",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("writing-system-tengwar"),
            "Haley Halcyon",
            "4.9.95"));
  }

  public static MdiIcon alphabetical() {
    return MdiIcon.create(
        "mdi-alphabetical",
        new MdiMeta(
            "alphabetical",
            "F002C",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("letters", "a-b-c", "abc"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon alphabetical_off() {
    return MdiIcon.create(
        "mdi-alphabetical-off",
        new MdiMeta(
            "alphabetical-off",
            "F100C",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("letters-off", "abc-off", "a-b-c-off"),
            "Michael Richins",
            "4.1.95"));
  }

  public static MdiIcon alphabetical_variant() {
    return MdiIcon.create(
        "mdi-alphabetical-variant",
        new MdiMeta(
            "alphabetical-variant",
            "F100D",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("letters", "abc", "a-b-c"),
            "Michael Richins",
            "4.1.95"));
  }

  public static MdiIcon alphabetical_variant_off() {
    return MdiIcon.create(
        "mdi-alphabetical-variant-off",
        new MdiMeta(
            "alphabetical-variant-off",
            "F100E",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList("letters-off", "abc-off", "a-b-c-off"),
            "Michael Richins",
            "4.1.95"));
  }

  public static MdiIcon altimeter() {
    return MdiIcon.create(
        "mdi-altimeter",
        new MdiMeta("altimeter", "F05D7", Arrays.asList(), Arrays.asList(), "Simran", "1.5.54"));
  }

  public static MdiIcon ambulance() {
    return MdiIcon.create(
        "mdi-ambulance",
        new MdiMeta(
            "ambulance",
            "F002F",
            Arrays.asList("Transportation + Road", "Medical / Hospital"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon ammunition() {
    return MdiIcon.create(
        "mdi-ammunition",
        new MdiMeta(
            "ammunition",
            "F0CE8",
            Arrays.asList(),
            Arrays.asList("bullets"),
            "Michael Irigoyen",
            "3.3.92"));
  }

  public static MdiIcon ampersand() {
    return MdiIcon.create(
        "mdi-ampersand",
        new MdiMeta(
            "ampersand",
            "F0A8D",
            Arrays.asList(),
            Arrays.asList("and"),
            "Michael Irigoyen",
            "2.7.94"));
  }

  public static MdiIcon amplifier() {
    return MdiIcon.create(
        "mdi-amplifier",
        new MdiMeta(
            "amplifier",
            "F0030",
            Arrays.asList("Home Automation", "Music"),
            Arrays.asList(),
            "Christopher Schreiner",
            "1.5.54"));
  }

  public static MdiIcon amplifier_off() {
    return MdiIcon.create(
        "mdi-amplifier-off",
        new MdiMeta(
            "amplifier-off",
            "F11B5",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.5.95"));
  }

  public static MdiIcon anchor() {
    return MdiIcon.create(
        "mdi-anchor",
        new MdiMeta(
            "anchor",
            "F0031",
            Arrays.asList("Transportation + Water"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  @Deprecated
  public static MdiIcon android() {
    return MdiIcon.create(
        "mdi-android",
        new MdiMeta(
            "android",
            "F0032",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  @Deprecated
  public static MdiIcon android_studio() {
    return MdiIcon.create(
        "mdi-android-studio",
        new MdiMeta(
            "android-studio",
            "F0034",
            Arrays.asList("Brand / Logo"),
            Arrays.asList("math-compass-variant"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon angle_acute() {
    return MdiIcon.create(
        "mdi-angle-acute",
        new MdiMeta(
            "angle-acute",
            "F0937",
            Arrays.asList("Math"),
            Arrays.asList(),
            "Haley Halcyon",
            "2.4.85"));
  }

  public static MdiIcon angle_obtuse() {
    return MdiIcon.create(
        "mdi-angle-obtuse",
        new MdiMeta(
            "angle-obtuse",
            "F0938",
            Arrays.asList("Math"),
            Arrays.asList(),
            "Haley Halcyon",
            "2.4.85"));
  }

  public static MdiIcon angle_right() {
    return MdiIcon.create(
        "mdi-angle-right",
        new MdiMeta(
            "angle-right",
            "F0939",
            Arrays.asList("Math"),
            Arrays.asList(),
            "Haley Halcyon",
            "2.4.85"));
  }

  @Deprecated
  public static MdiIcon angular() {
    return MdiIcon.create(
        "mdi-angular",
        new MdiMeta(
            "angular",
            "F06B2",
            Arrays.asList("Brand / Logo", "Developer / Languages"),
            Arrays.asList(),
            "Contributors",
            "1.7.22"));
  }

  @Deprecated
  public static MdiIcon angularjs() {
    return MdiIcon.create(
        "mdi-angularjs",
        new MdiMeta(
            "angularjs",
            "F06BF",
            Arrays.asList("Brand / Logo", "Developer / Languages"),
            Arrays.asList(),
            "Contributors",
            "1.8.36"));
  }

  public static MdiIcon animation() {
    return MdiIcon.create(
        "mdi-animation",
        new MdiMeta(
            "animation",
            "F05D8",
            Arrays.asList(),
            Arrays.asList("auto-awesome-motion"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon animation_outline() {
    return MdiIcon.create(
        "mdi-animation-outline",
        new MdiMeta(
            "animation-outline",
            "F0A8F",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.7.94"));
  }

  public static MdiIcon animation_play() {
    return MdiIcon.create(
        "mdi-animation-play",
        new MdiMeta(
            "animation-play", "F093A", Arrays.asList(), Arrays.asList(), "Google", "2.4.85"));
  }

  public static MdiIcon animation_play_outline() {
    return MdiIcon.create(
        "mdi-animation-play-outline",
        new MdiMeta(
            "animation-play-outline",
            "F0A90",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.7.94"));
  }

  @Deprecated
  public static MdiIcon ansible() {
    return MdiIcon.create(
        "mdi-ansible",
        new MdiMeta(
            "ansible",
            "F109A",
            Arrays.asList("Developer / Languages", "Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "4.2.95"));
  }

  public static MdiIcon antenna() {
    return MdiIcon.create(
        "mdi-antenna",
        new MdiMeta("antenna", "F1119", Arrays.asList(), Arrays.asList(), "Google", "4.3.95"));
  }

  public static MdiIcon anvil() {
    return MdiIcon.create(
        "mdi-anvil",
        new MdiMeta("anvil", "F089B", Arrays.asList(), Arrays.asList(), "Nick", "2.2.43"));
  }

  @Deprecated
  public static MdiIcon apache_kafka() {
    return MdiIcon.create(
        "mdi-apache-kafka",
        new MdiMeta(
            "apache-kafka",
            "F100F",
            Arrays.asList("Brand / Logo", "Developer / Languages"),
            Arrays.asList(),
            "Contributors",
            "4.1.95"));
  }

  public static MdiIcon api() {
    return MdiIcon.create(
        "mdi-api",
        new MdiMeta(
            "api",
            "F109B",
            Arrays.asList("Developer / Languages"),
            Arrays.asList(),
            "Google",
            "4.2.95"));
  }

  public static MdiIcon api_off() {
    return MdiIcon.create(
        "mdi-api-off",
        new MdiMeta(
            "api-off",
            "F1257",
            Arrays.asList("Developer / Languages"),
            Arrays.asList(),
            "sergiocarlotto",
            "4.6.95"));
  }

  @Deprecated
  public static MdiIcon apple() {
    return MdiIcon.create(
        "mdi-apple",
        new MdiMeta(
            "apple",
            "F0035",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "1.5.54"));
  }

  @Deprecated
  public static MdiIcon apple_finder() {
    return MdiIcon.create(
        "mdi-apple-finder",
        new MdiMeta(
            "apple-finder",
            "F0036",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "1.5.54"));
  }

  @Deprecated
  public static MdiIcon apple_icloud() {
    return MdiIcon.create(
        "mdi-apple-icloud",
        new MdiMeta(
            "apple-icloud",
            "F0038",
            Arrays.asList("Brand / Logo"),
            Arrays.asList("apple-mobileme"),
            "Contributors",
            "1.5.54"));
  }

  @Deprecated
  public static MdiIcon apple_ios() {
    return MdiIcon.create(
        "mdi-apple-ios",
        new MdiMeta(
            "apple-ios",
            "F0037",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "1.5.54"));
  }

  public static MdiIcon apple_keyboard_caps() {
    return MdiIcon.create(
        "mdi-apple-keyboard-caps",
        new MdiMeta(
            "apple-keyboard-caps",
            "F0632",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.6.50"));
  }

  public static MdiIcon apple_keyboard_command() {
    return MdiIcon.create(
        "mdi-apple-keyboard-command",
        new MdiMeta(
            "apple-keyboard-command",
            "F0633",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.6.50"));
  }

  public static MdiIcon apple_keyboard_control() {
    return MdiIcon.create(
        "mdi-apple-keyboard-control",
        new MdiMeta(
            "apple-keyboard-control",
            "F0634",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.6.50"));
  }

  public static MdiIcon apple_keyboard_option() {
    return MdiIcon.create(
        "mdi-apple-keyboard-option",
        new MdiMeta(
            "apple-keyboard-option",
            "F0635",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.6.50"));
  }

  public static MdiIcon apple_keyboard_shift() {
    return MdiIcon.create(
        "mdi-apple-keyboard-shift",
        new MdiMeta(
            "apple-keyboard-shift",
            "F0636",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.6.50"));
  }

  @Deprecated
  public static MdiIcon apple_safari() {
    return MdiIcon.create(
        "mdi-apple-safari",
        new MdiMeta(
            "apple-safari",
            "F0039",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "1.5.54"));
  }

  public static MdiIcon application() {
    return MdiIcon.create(
        "mdi-application",
        new MdiMeta(
            "application",
            "F08C6",
            Arrays.asList(),
            Arrays.asList("iframe"),
            "Michael Irigoyen",
            "2.3.50"));
  }

  public static MdiIcon application_array() {
    return MdiIcon.create(
        "mdi-application-array",
        new MdiMeta(
            "application-array",
            "F10F5",
            Arrays.asList("Developer / Languages"),
            Arrays.asList("iframe-array"),
            "Michael Irigoyen",
            "4.3.95"));
  }

  public static MdiIcon application_array_outline() {
    return MdiIcon.create(
        "mdi-application-array-outline",
        new MdiMeta(
            "application-array-outline",
            "F10F6",
            Arrays.asList("Developer / Languages"),
            Arrays.asList("iframe-array-outline"),
            "Michael Irigoyen",
            "4.3.95"));
  }

  public static MdiIcon application_braces() {
    return MdiIcon.create(
        "mdi-application-braces",
        new MdiMeta(
            "application-braces",
            "F10F7",
            Arrays.asList("Developer / Languages"),
            Arrays.asList("iframe-braces"),
            "Michael Irigoyen",
            "4.3.95"));
  }

  public static MdiIcon application_braces_outline() {
    return MdiIcon.create(
        "mdi-application-braces-outline",
        new MdiMeta(
            "application-braces-outline",
            "F10F8",
            Arrays.asList("Developer / Languages"),
            Arrays.asList("iframe-braces-outline"),
            "Michael Irigoyen",
            "4.3.95"));
  }

  public static MdiIcon application_brackets() {
    return MdiIcon.create(
        "mdi-application-brackets",
        new MdiMeta(
            "application-brackets",
            "F0C8B",
            Arrays.asList("Developer / Languages"),
            Arrays.asList("iframe-brackets"),
            "Michael Richins",
            "3.2.89"));
  }

  public static MdiIcon application_brackets_outline() {
    return MdiIcon.create(
        "mdi-application-brackets-outline",
        new MdiMeta(
            "application-brackets-outline",
            "F0C8C",
            Arrays.asList("Developer / Languages"),
            Arrays.asList("iframe-brackets-outline"),
            "Michael Richins",
            "3.2.89"));
  }

  public static MdiIcon application_cog() {
    return MdiIcon.create(
        "mdi-application-cog",
        new MdiMeta(
            "application-cog",
            "F0675",
            Arrays.asList("Settings"),
            Arrays.asList("iframe-cog"),
            "Michael Irigoyen",
            "1.7.12"));
  }

  public static MdiIcon application_cog_outline() {
    return MdiIcon.create(
        "mdi-application-cog-outline",
        new MdiMeta(
            "application-cog-outline",
            "F1577",
            Arrays.asList("Settings"),
            Arrays.asList("application-settings", "iframe-cog-outline"),
            "Michael Irigoyen",
            "5.5.55"));
  }

  public static MdiIcon application_edit() {
    return MdiIcon.create(
        "mdi-application-edit",
        new MdiMeta(
            "application-edit",
            "F00AE",
            Arrays.asList("Edit / Modify"),
            Arrays.asList("iframe-edit"),
            "Michael Irigoyen",
            "1.5.54"));
  }

  public static MdiIcon application_edit_outline() {
    return MdiIcon.create(
        "mdi-application-edit-outline",
        new MdiMeta(
            "application-edit-outline",
            "F0619",
            Arrays.asList("Edit / Modify"),
            Arrays.asList("iframe-edit-outline"),
            "Michael Irigoyen",
            "1.6.50"));
  }

  public static MdiIcon application_export() {
    return MdiIcon.create(
        "mdi-application-export",
        new MdiMeta(
            "application-export",
            "F0DAD",
            Arrays.asList(),
            Arrays.asList("iframe-export-outline"),
            "Austin Andrews",
            "3.5.94"));
  }

  public static MdiIcon application_import() {
    return MdiIcon.create(
        "mdi-application-import",
        new MdiMeta(
            "application-import",
            "F0DAE",
            Arrays.asList(),
            Arrays.asList("iframe-import-outline"),
            "Austin Andrews",
            "3.5.94"));
  }

  public static MdiIcon application_outline() {
    return MdiIcon.create(
        "mdi-application-outline",
        new MdiMeta(
            "application-outline",
            "F0614",
            Arrays.asList(),
            Arrays.asList("web-asset", "iframe-outline"),
            "Austin Andrews",
            "1.6.50"));
  }

  public static MdiIcon application_parentheses() {
    return MdiIcon.create(
        "mdi-application-parentheses",
        new MdiMeta(
            "application-parentheses",
            "F10F9",
            Arrays.asList("Developer / Languages"),
            Arrays.asList("iframe-parentheses"),
            "Michael Irigoyen",
            "4.3.95"));
  }

  public static MdiIcon application_parentheses_outline() {
    return MdiIcon.create(
        "mdi-application-parentheses-outline",
        new MdiMeta(
            "application-parentheses-outline",
            "F10FA",
            Arrays.asList("Developer / Languages"),
            Arrays.asList("iframe-parentheses-outline"),
            "Michael Irigoyen",
            "4.3.95"));
  }

  public static MdiIcon application_settings() {
    return MdiIcon.create(
        "mdi-application-settings",
        new MdiMeta(
            "application-settings",
            "F0B60",
            Arrays.asList("Settings"),
            Arrays.asList("iframe-settings"),
            "Michael Irigoyen",
            "3.0.39"));
  }

  public static MdiIcon application_settings_outline() {
    return MdiIcon.create(
        "mdi-application-settings-outline",
        new MdiMeta(
            "application-settings-outline",
            "F1555",
            Arrays.asList("Settings"),
            Arrays.asList("iframe-settings-outline"),
            "CoreyVidal",
            "5.5.55"));
  }

  public static MdiIcon application_variable() {
    return MdiIcon.create(
        "mdi-application-variable",
        new MdiMeta(
            "application-variable",
            "F10FB",
            Arrays.asList("Developer / Languages"),
            Arrays.asList("iframe-variable"),
            "Michael Irigoyen",
            "4.3.95"));
  }

  public static MdiIcon application_variable_outline() {
    return MdiIcon.create(
        "mdi-application-variable-outline",
        new MdiMeta(
            "application-variable-outline",
            "F10FC",
            Arrays.asList("Developer / Languages"),
            Arrays.asList("iframe-variable-outline"),
            "Michael Irigoyen",
            "4.3.95"));
  }

  public static MdiIcon approximately_equal() {
    return MdiIcon.create(
        "mdi-approximately-equal",
        new MdiMeta(
            "approximately-equal",
            "F0F9E",
            Arrays.asList("Math"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.0.96"));
  }

  public static MdiIcon approximately_equal_box() {
    return MdiIcon.create(
        "mdi-approximately-equal-box",
        new MdiMeta(
            "approximately-equal-box",
            "F0F9F",
            Arrays.asList("Math"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.0.96"));
  }

  public static MdiIcon apps() {
    return MdiIcon.create(
        "mdi-apps",
        new MdiMeta("apps", "F003B", Arrays.asList("View"), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon apps_box() {
    return MdiIcon.create(
        "mdi-apps-box",
        new MdiMeta("apps-box", "F0D46", Arrays.asList(), Arrays.asList(), "Google", "3.4.93"));
  }

  @Deprecated
  public static MdiIcon arch() {
    return MdiIcon.create(
        "mdi-arch",
        new MdiMeta(
            "arch",
            "F08C7",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "2.3.50"));
  }

  public static MdiIcon archive() {
    return MdiIcon.create(
        "mdi-archive",
        new MdiMeta(
            "archive", "F003C", Arrays.asList(), Arrays.asList("box"), "Austin Andrews", "1.5.54"));
  }

  public static MdiIcon archive_alert() {
    return MdiIcon.create(
        "mdi-archive-alert",
        new MdiMeta(
            "archive-alert",
            "F14FD",
            Arrays.asList("Alert / Error"),
            Arrays.asList("box-alert"),
            "Austin Andrews",
            "5.4.55"));
  }

  public static MdiIcon archive_alert_outline() {
    return MdiIcon.create(
        "mdi-archive-alert-outline",
        new MdiMeta(
            "archive-alert-outline",
            "F14FE",
            Arrays.asList("Alert / Error"),
            Arrays.asList("box-alert-outline"),
            "Austin Andrews",
            "5.4.55"));
  }

  public static MdiIcon archive_arrow_down() {
    return MdiIcon.create(
        "mdi-archive-arrow-down",
        new MdiMeta(
            "archive-arrow-down",
            "F1259",
            Arrays.asList(),
            Arrays.asList("box-arrow-down", "this-side-down"),
            "frankgrinaert",
            "4.7.95"));
  }

  public static MdiIcon archive_arrow_down_outline() {
    return MdiIcon.create(
        "mdi-archive-arrow-down-outline",
        new MdiMeta(
            "archive-arrow-down-outline",
            "F125A",
            Arrays.asList(),
            Arrays.asList("box-arrow-down", "this-side-down-outline"),
            "frankgrinaert",
            "4.7.95"));
  }

  public static MdiIcon archive_arrow_up() {
    return MdiIcon.create(
        "mdi-archive-arrow-up",
        new MdiMeta(
            "archive-arrow-up",
            "F125B",
            Arrays.asList(),
            Arrays.asList("box-arrow-up", "this-side-up"),
            "frankgrinaert",
            "4.7.95"));
  }

  public static MdiIcon archive_arrow_up_outline() {
    return MdiIcon.create(
        "mdi-archive-arrow-up-outline",
        new MdiMeta(
            "archive-arrow-up-outline",
            "F125C",
            Arrays.asList(),
            Arrays.asList("box-arrow-up-outline", "this-side-up-outline"),
            "frankgrinaert",
            "4.7.95"));
  }

  public static MdiIcon archive_cancel() {
    return MdiIcon.create(
        "mdi-archive-cancel",
        new MdiMeta(
            "archive-cancel",
            "F174B",
            Arrays.asList(),
            Arrays.asList("box-cancel"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_cancel_outline() {
    return MdiIcon.create(
        "mdi-archive-cancel-outline",
        new MdiMeta(
            "archive-cancel-outline",
            "F174C",
            Arrays.asList(),
            Arrays.asList("box-cancel-outline"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_check() {
    return MdiIcon.create(
        "mdi-archive-check",
        new MdiMeta(
            "archive-check",
            "F174D",
            Arrays.asList(),
            Arrays.asList("box-check", "archive-success", "box-success"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_check_outline() {
    return MdiIcon.create(
        "mdi-archive-check-outline",
        new MdiMeta(
            "archive-check-outline",
            "F174E",
            Arrays.asList(),
            Arrays.asList("box-check-outline", "archive-success-outline", "box-success-outline"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_clock() {
    return MdiIcon.create(
        "mdi-archive-clock",
        new MdiMeta(
            "archive-clock",
            "F174F",
            Arrays.asList("Date / Time"),
            Arrays.asList("box-clock", "box-time", "archive-time"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_clock_outline() {
    return MdiIcon.create(
        "mdi-archive-clock-outline",
        new MdiMeta(
            "archive-clock-outline",
            "F1750",
            Arrays.asList("Date / Time"),
            Arrays.asList("box-clock-outline", "box-time-outline", "archive-time-outline"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_cog() {
    return MdiIcon.create(
        "mdi-archive-cog",
        new MdiMeta(
            "archive-cog",
            "F1751",
            Arrays.asList("Settings"),
            Arrays.asList("box-cog"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_cog_outline() {
    return MdiIcon.create(
        "mdi-archive-cog-outline",
        new MdiMeta(
            "archive-cog-outline",
            "F1752",
            Arrays.asList("Settings"),
            Arrays.asList("box-cog-outline"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_edit() {
    return MdiIcon.create(
        "mdi-archive-edit",
        new MdiMeta(
            "archive-edit",
            "F1753",
            Arrays.asList("Edit / Modify"),
            Arrays.asList("box-edit"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_edit_outline() {
    return MdiIcon.create(
        "mdi-archive-edit-outline",
        new MdiMeta(
            "archive-edit-outline",
            "F1754",
            Arrays.asList("Edit / Modify"),
            Arrays.asList("box-edit-outline"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_eye() {
    return MdiIcon.create(
        "mdi-archive-eye",
        new MdiMeta(
            "archive-eye",
            "F1755",
            Arrays.asList(),
            Arrays.asList("archive-view", "box-eye", "box-view"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_eye_outline() {
    return MdiIcon.create(
        "mdi-archive-eye-outline",
        new MdiMeta(
            "archive-eye-outline",
            "F1756",
            Arrays.asList(),
            Arrays.asList("archive-view-outline", "box-eye-outline", "box-view-outline"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_lock() {
    return MdiIcon.create(
        "mdi-archive-lock",
        new MdiMeta(
            "archive-lock",
            "F1757",
            Arrays.asList("Lock"),
            Arrays.asList("box-lock"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_lock_open() {
    return MdiIcon.create(
        "mdi-archive-lock-open",
        new MdiMeta(
            "archive-lock-open",
            "F1758",
            Arrays.asList("Lock"),
            Arrays.asList("box-lock-open"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_lock_open_outline() {
    return MdiIcon.create(
        "mdi-archive-lock-open-outline",
        new MdiMeta(
            "archive-lock-open-outline",
            "F1759",
            Arrays.asList("Lock"),
            Arrays.asList("box-lock-open-outline"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_lock_outline() {
    return MdiIcon.create(
        "mdi-archive-lock-outline",
        new MdiMeta(
            "archive-lock-outline",
            "F175A",
            Arrays.asList("Lock"),
            Arrays.asList("box-lock-outline"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_marker() {
    return MdiIcon.create(
        "mdi-archive-marker",
        new MdiMeta(
            "archive-marker",
            "F175B",
            Arrays.asList("Navigation"),
            Arrays.asList("archive-location", "box-marker", "box-location"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_marker_outline() {
    return MdiIcon.create(
        "mdi-archive-marker-outline",
        new MdiMeta(
            "archive-marker-outline",
            "F175C",
            Arrays.asList("Navigation"),
            Arrays.asList("archive-location-outline", "box-marker-outline", "box-location-outline"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_minus() {
    return MdiIcon.create(
        "mdi-archive-minus",
        new MdiMeta(
            "archive-minus",
            "F175D",
            Arrays.asList(),
            Arrays.asList("box-minus"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_minus_outline() {
    return MdiIcon.create(
        "mdi-archive-minus-outline",
        new MdiMeta(
            "archive-minus-outline",
            "F175E",
            Arrays.asList(),
            Arrays.asList("box-minus-outline"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_music() {
    return MdiIcon.create(
        "mdi-archive-music",
        new MdiMeta(
            "archive-music",
            "F175F",
            Arrays.asList("Music"),
            Arrays.asList("box-music"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_music_outline() {
    return MdiIcon.create(
        "mdi-archive-music-outline",
        new MdiMeta(
            "archive-music-outline",
            "F1760",
            Arrays.asList("Music"),
            Arrays.asList("box-music-outline"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_off() {
    return MdiIcon.create(
        "mdi-archive-off",
        new MdiMeta(
            "archive-off",
            "F1761",
            Arrays.asList(),
            Arrays.asList("box-off"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_off_outline() {
    return MdiIcon.create(
        "mdi-archive-off-outline",
        new MdiMeta(
            "archive-off-outline",
            "F1762",
            Arrays.asList(),
            Arrays.asList("box-off-outline"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_outline() {
    return MdiIcon.create(
        "mdi-archive-outline",
        new MdiMeta(
            "archive-outline",
            "F120E",
            Arrays.asList(),
            Arrays.asList("box-outline"),
            "James Coyle",
            "4.6.95"));
  }

  public static MdiIcon archive_plus() {
    return MdiIcon.create(
        "mdi-archive-plus",
        new MdiMeta(
            "archive-plus",
            "F1763",
            Arrays.asList(),
            Arrays.asList("archive-add", "box-plus", "box-add"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_plus_outline() {
    return MdiIcon.create(
        "mdi-archive-plus-outline",
        new MdiMeta(
            "archive-plus-outline",
            "F1764",
            Arrays.asList(),
            Arrays.asList("archive-add-outline", "box-plus-outline", "box-add-outline"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_refresh() {
    return MdiIcon.create(
        "mdi-archive-refresh",
        new MdiMeta(
            "archive-refresh",
            "F1765",
            Arrays.asList(),
            Arrays.asList("box-refresh"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_refresh_outline() {
    return MdiIcon.create(
        "mdi-archive-refresh-outline",
        new MdiMeta(
            "archive-refresh-outline",
            "F1766",
            Arrays.asList(),
            Arrays.asList("box-refresh-outline"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_remove() {
    return MdiIcon.create(
        "mdi-archive-remove",
        new MdiMeta(
            "archive-remove",
            "F1767",
            Arrays.asList(),
            Arrays.asList("box-remove"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_remove_outline() {
    return MdiIcon.create(
        "mdi-archive-remove-outline",
        new MdiMeta(
            "archive-remove-outline",
            "F1768",
            Arrays.asList(),
            Arrays.asList("box-remove-outline"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_search() {
    return MdiIcon.create(
        "mdi-archive-search",
        new MdiMeta(
            "archive-search",
            "F1769",
            Arrays.asList(),
            Arrays.asList("box-search"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_search_outline() {
    return MdiIcon.create(
        "mdi-archive-search-outline",
        new MdiMeta(
            "archive-search-outline",
            "F176A",
            Arrays.asList(),
            Arrays.asList("box-search-outline"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_settings() {
    return MdiIcon.create(
        "mdi-archive-settings",
        new MdiMeta(
            "archive-settings",
            "F176B",
            Arrays.asList("Settings"),
            Arrays.asList("box-settings"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_settings_outline() {
    return MdiIcon.create(
        "mdi-archive-settings-outline",
        new MdiMeta(
            "archive-settings-outline",
            "F176C",
            Arrays.asList("Settings"),
            Arrays.asList("box-settings-outline"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_star() {
    return MdiIcon.create(
        "mdi-archive-star",
        new MdiMeta(
            "archive-star",
            "F176D",
            Arrays.asList(),
            Arrays.asList("archive-favorite", "box-star", "box-favorite"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_star_outline() {
    return MdiIcon.create(
        "mdi-archive-star-outline",
        new MdiMeta(
            "archive-star-outline",
            "F176E",
            Arrays.asList(),
            Arrays.asList("archive-favorite-outline", "box-star-outline", "box-favorite-outline"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_sync() {
    return MdiIcon.create(
        "mdi-archive-sync",
        new MdiMeta(
            "archive-sync",
            "F176F",
            Arrays.asList(),
            Arrays.asList("box-sync"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon archive_sync_outline() {
    return MdiIcon.create(
        "mdi-archive-sync-outline",
        new MdiMeta(
            "archive-sync-outline",
            "F1770",
            Arrays.asList(),
            Arrays.asList("box-sync-outline"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arm_flex() {
    return MdiIcon.create(
        "mdi-arm-flex",
        new MdiMeta("arm-flex", "F0FD7", Arrays.asList(), Arrays.asList(), "yuanruili", "4.2.95"));
  }

  public static MdiIcon arm_flex_outline() {
    return MdiIcon.create(
        "mdi-arm-flex-outline",
        new MdiMeta(
            "arm-flex-outline", "F0FD6", Arrays.asList(), Arrays.asList(), "yuanruili", "4.2.95"));
  }

  public static MdiIcon arrange_bring_forward() {
    return MdiIcon.create(
        "mdi-arrange-bring-forward",
        new MdiMeta(
            "arrange-bring-forward",
            "F003D",
            Arrays.asList("Arrange", "Geographic Information System"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrange_bring_to_front() {
    return MdiIcon.create(
        "mdi-arrange-bring-to-front",
        new MdiMeta(
            "arrange-bring-to-front",
            "F003E",
            Arrays.asList("Arrange", "Geographic Information System"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrange_send_backward() {
    return MdiIcon.create(
        "mdi-arrange-send-backward",
        new MdiMeta(
            "arrange-send-backward",
            "F003F",
            Arrays.asList("Arrange", "Geographic Information System"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrange_send_to_back() {
    return MdiIcon.create(
        "mdi-arrange-send-to-back",
        new MdiMeta(
            "arrange-send-to-back",
            "F0040",
            Arrays.asList("Arrange", "Geographic Information System"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_all() {
    return MdiIcon.create(
        "mdi-arrow-all",
        new MdiMeta(
            "arrow-all",
            "F0041",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_bottom_left() {
    return MdiIcon.create(
        "mdi-arrow-bottom-left",
        new MdiMeta(
            "arrow-bottom-left",
            "F0042",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-down-left"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_bottom_left_bold_box() {
    return MdiIcon.create(
        "mdi-arrow-bottom-left-bold-box",
        new MdiMeta(
            "arrow-bottom-left-bold-box",
            "F1964",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.5.95"));
  }

  public static MdiIcon arrow_bottom_left_bold_box_outline() {
    return MdiIcon.create(
        "mdi-arrow-bottom-left-bold-box-outline",
        new MdiMeta(
            "arrow-bottom-left-bold-box-outline",
            "F1965",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.5.95"));
  }

  public static MdiIcon arrow_bottom_left_bold_outline() {
    return MdiIcon.create(
        "mdi-arrow-bottom-left-bold-outline",
        new MdiMeta(
            "arrow-bottom-left-bold-outline",
            "F09B7",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-down-left-bold-outline"),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon arrow_bottom_left_thick() {
    return MdiIcon.create(
        "mdi-arrow-bottom-left-thick",
        new MdiMeta(
            "arrow-bottom-left-thick",
            "F09B8",
            Arrays.asList("Arrow"),
            Arrays.asList(
                "arrow-down-left-thick", "arrow-bottom-left-bold", "arrow-down-left-bold"),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon arrow_bottom_left_thin() {
    return MdiIcon.create(
        "mdi-arrow-bottom-left-thin",
        new MdiMeta(
            "arrow-bottom-left-thin",
            "F19B6",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Matt Stayner",
            "6.5.95"));
  }

  public static MdiIcon arrow_bottom_left_thin_circle_outline() {
    return MdiIcon.create(
        "mdi-arrow-bottom-left-thin-circle-outline",
        new MdiMeta(
            "arrow-bottom-left-thin-circle-outline",
            "F1596",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Google",
            "5.5.55"));
  }

  public static MdiIcon arrow_bottom_right() {
    return MdiIcon.create(
        "mdi-arrow-bottom-right",
        new MdiMeta(
            "arrow-bottom-right",
            "F0043",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-down-right"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_bottom_right_bold_box() {
    return MdiIcon.create(
        "mdi-arrow-bottom-right-bold-box",
        new MdiMeta(
            "arrow-bottom-right-bold-box",
            "F1966",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.5.95"));
  }

  public static MdiIcon arrow_bottom_right_bold_box_outline() {
    return MdiIcon.create(
        "mdi-arrow-bottom-right-bold-box-outline",
        new MdiMeta(
            "arrow-bottom-right-bold-box-outline",
            "F1967",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.5.95"));
  }

  public static MdiIcon arrow_bottom_right_bold_outline() {
    return MdiIcon.create(
        "mdi-arrow-bottom-right-bold-outline",
        new MdiMeta(
            "arrow-bottom-right-bold-outline",
            "F09B9",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-down-right-bold-outline"),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon arrow_bottom_right_thick() {
    return MdiIcon.create(
        "mdi-arrow-bottom-right-thick",
        new MdiMeta(
            "arrow-bottom-right-thick",
            "F09BA",
            Arrays.asList("Arrow"),
            Arrays.asList(
                "arrow-down-right-thick", "arrow-bottom-right-bold", "arrow-down-right-bold"),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon arrow_bottom_right_thin() {
    return MdiIcon.create(
        "mdi-arrow-bottom-right-thin",
        new MdiMeta(
            "arrow-bottom-right-thin",
            "F19B7",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Matt Stayner",
            "6.5.95"));
  }

  public static MdiIcon arrow_bottom_right_thin_circle_outline() {
    return MdiIcon.create(
        "mdi-arrow-bottom-right-thin-circle-outline",
        new MdiMeta(
            "arrow-bottom-right-thin-circle-outline",
            "F1595",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Google",
            "5.5.55"));
  }

  public static MdiIcon arrow_collapse() {
    return MdiIcon.create(
        "mdi-arrow-collapse",
        new MdiMeta(
            "arrow-collapse",
            "F0615",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-compress"),
            "Austin Andrews",
            "1.6.50"));
  }

  public static MdiIcon arrow_collapse_all() {
    return MdiIcon.create(
        "mdi-arrow-collapse-all",
        new MdiMeta(
            "arrow-collapse-all",
            "F0044",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-compress-all"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_collapse_down() {
    return MdiIcon.create(
        "mdi-arrow-collapse-down",
        new MdiMeta(
            "arrow-collapse-down",
            "F0792",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-compress-down"),
            "Michael Richins",
            "2.0.46"));
  }

  public static MdiIcon arrow_collapse_horizontal() {
    return MdiIcon.create(
        "mdi-arrow-collapse-horizontal",
        new MdiMeta(
            "arrow-collapse-horizontal",
            "F084C",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Google",
            "2.1.99"));
  }

  public static MdiIcon arrow_collapse_left() {
    return MdiIcon.create(
        "mdi-arrow-collapse-left",
        new MdiMeta(
            "arrow-collapse-left",
            "F0793",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-compress-left"),
            "Michael Richins",
            "2.0.46"));
  }

  public static MdiIcon arrow_collapse_right() {
    return MdiIcon.create(
        "mdi-arrow-collapse-right",
        new MdiMeta(
            "arrow-collapse-right",
            "F0794",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-compress-right"),
            "Michael Richins",
            "2.0.46"));
  }

  public static MdiIcon arrow_collapse_up() {
    return MdiIcon.create(
        "mdi-arrow-collapse-up",
        new MdiMeta(
            "arrow-collapse-up",
            "F0795",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-compress-up"),
            "Michael Richins",
            "2.0.46"));
  }

  public static MdiIcon arrow_collapse_vertical() {
    return MdiIcon.create(
        "mdi-arrow-collapse-vertical",
        new MdiMeta(
            "arrow-collapse-vertical",
            "F084D",
            Arrays.asList("Arrow"),
            Arrays.asList("compress"),
            "Google",
            "2.1.99"));
  }

  public static MdiIcon arrow_decision() {
    return MdiIcon.create(
        "mdi-arrow-decision",
        new MdiMeta(
            "arrow-decision",
            "F09BB",
            Arrays.asList("Arrow"),
            Arrays.asList("proxy"),
            "Michael Richins",
            "2.5.94"));
  }

  public static MdiIcon arrow_decision_auto() {
    return MdiIcon.create(
        "mdi-arrow-decision-auto",
        new MdiMeta(
            "arrow-decision-auto",
            "F09BC",
            Arrays.asList(),
            Arrays.asList("proxy-auto"),
            "Michael Richins",
            "2.5.94"));
  }

  public static MdiIcon arrow_decision_auto_outline() {
    return MdiIcon.create(
        "mdi-arrow-decision-auto-outline",
        new MdiMeta(
            "arrow-decision-auto-outline",
            "F09BD",
            Arrays.asList(),
            Arrays.asList("proxy-auto-outline"),
            "Michael Richins",
            "2.5.94"));
  }

  public static MdiIcon arrow_decision_outline() {
    return MdiIcon.create(
        "mdi-arrow-decision-outline",
        new MdiMeta(
            "arrow-decision-outline",
            "F09BE",
            Arrays.asList("Arrow"),
            Arrays.asList("proxy-outline"),
            "Michael Richins",
            "2.5.94"));
  }

  public static MdiIcon arrow_down() {
    return MdiIcon.create(
        "mdi-arrow-down",
        new MdiMeta(
            "arrow-down",
            "F0045",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-downward", "arrow-bottom"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_down_bold() {
    return MdiIcon.create(
        "mdi-arrow-down-bold",
        new MdiMeta(
            "arrow-down-bold",
            "F072E",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-bottom-bold"),
            "Austin Andrews",
            "1.9.32"));
  }

  public static MdiIcon arrow_down_bold_box() {
    return MdiIcon.create(
        "mdi-arrow-down-bold-box",
        new MdiMeta(
            "arrow-down-bold-box",
            "F072F",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-bottom-bold-box"),
            "Austin Andrews",
            "1.9.32"));
  }

  public static MdiIcon arrow_down_bold_box_outline() {
    return MdiIcon.create(
        "mdi-arrow-down-bold-box-outline",
        new MdiMeta(
            "arrow-down-bold-box-outline",
            "F0730",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-bottom-bold-box-outline"),
            "Austin Andrews",
            "1.9.32"));
  }

  public static MdiIcon arrow_down_bold_circle() {
    return MdiIcon.create(
        "mdi-arrow-down-bold-circle",
        new MdiMeta(
            "arrow-down-bold-circle",
            "F0047",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-bottom-bold-circle"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_down_bold_circle_outline() {
    return MdiIcon.create(
        "mdi-arrow-down-bold-circle-outline",
        new MdiMeta(
            "arrow-down-bold-circle-outline",
            "F0048",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-bottom-bold-circle-outline"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_down_bold_hexagon_outline() {
    return MdiIcon.create(
        "mdi-arrow-down-bold-hexagon-outline",
        new MdiMeta(
            "arrow-down-bold-hexagon-outline",
            "F0049",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-bottom-bold-hexagon-outline"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_down_bold_outline() {
    return MdiIcon.create(
        "mdi-arrow-down-bold-outline",
        new MdiMeta(
            "arrow-down-bold-outline",
            "F09BF",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-bottom-bold-outline"),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon arrow_down_box() {
    return MdiIcon.create(
        "mdi-arrow-down-box",
        new MdiMeta(
            "arrow-down-box",
            "F06C0",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-bottom-box"),
            "Austin Andrews",
            "1.8.36"));
  }

  public static MdiIcon arrow_down_circle() {
    return MdiIcon.create(
        "mdi-arrow-down-circle",
        new MdiMeta(
            "arrow-down-circle",
            "F0CDB",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-bottom-circle"),
            "Austin Andrews",
            "3.3.92"));
  }

  public static MdiIcon arrow_down_circle_outline() {
    return MdiIcon.create(
        "mdi-arrow-down-circle-outline",
        new MdiMeta(
            "arrow-down-circle-outline",
            "F0CDC",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-bottom-circle-outline"),
            "Austin Andrews",
            "3.3.92"));
  }

  public static MdiIcon arrow_down_drop_circle() {
    return MdiIcon.create(
        "mdi-arrow-down-drop-circle",
        new MdiMeta(
            "arrow-down-drop-circle",
            "F004A",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-drop-down-circle", "arrow-bottom-drop-circle"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon arrow_down_drop_circle_outline() {
    return MdiIcon.create(
        "mdi-arrow-down-drop-circle-outline",
        new MdiMeta(
            "arrow-down-drop-circle-outline",
            "F004B",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-bottom-drop-circle-outline"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_down_left() {
    return MdiIcon.create(
        "mdi-arrow-down-left",
        new MdiMeta(
            "arrow-down-left",
            "F17A1",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_down_left_bold() {
    return MdiIcon.create(
        "mdi-arrow-down-left-bold",
        new MdiMeta(
            "arrow-down-left-bold",
            "F17A2",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_down_right() {
    return MdiIcon.create(
        "mdi-arrow-down-right",
        new MdiMeta(
            "arrow-down-right",
            "F17A3",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_down_right_bold() {
    return MdiIcon.create(
        "mdi-arrow-down-right-bold",
        new MdiMeta(
            "arrow-down-right-bold",
            "F17A4",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_down_thick() {
    return MdiIcon.create(
        "mdi-arrow-down-thick",
        new MdiMeta(
            "arrow-down-thick",
            "F0046",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-bottom-thick", "arrow-down-bold", "arrow-bottom-bold"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_down_thin() {
    return MdiIcon.create(
        "mdi-arrow-down-thin",
        new MdiMeta(
            "arrow-down-thin",
            "F19B3",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Matt Stayner",
            "6.5.95"));
  }

  public static MdiIcon arrow_down_thin_circle_outline() {
    return MdiIcon.create(
        "mdi-arrow-down-thin-circle-outline",
        new MdiMeta(
            "arrow-down-thin-circle-outline",
            "F1599",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Google",
            "5.5.55"));
  }

  public static MdiIcon arrow_expand() {
    return MdiIcon.create(
        "mdi-arrow-expand",
        new MdiMeta(
            "arrow-expand",
            "F0616",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "1.6.50"));
  }

  public static MdiIcon arrow_expand_all() {
    return MdiIcon.create(
        "mdi-arrow-expand-all",
        new MdiMeta(
            "arrow-expand-all",
            "F004C",
            Arrays.asList("Arrow", "Geographic Information System"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_expand_down() {
    return MdiIcon.create(
        "mdi-arrow-expand-down",
        new MdiMeta(
            "arrow-expand-down",
            "F0796",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Michael Richins",
            "2.0.46"));
  }

  public static MdiIcon arrow_expand_horizontal() {
    return MdiIcon.create(
        "mdi-arrow-expand-horizontal",
        new MdiMeta(
            "arrow-expand-horizontal",
            "F084E",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Google",
            "2.1.99"));
  }

  public static MdiIcon arrow_expand_left() {
    return MdiIcon.create(
        "mdi-arrow-expand-left",
        new MdiMeta(
            "arrow-expand-left",
            "F0797",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Michael Richins",
            "2.0.46"));
  }

  public static MdiIcon arrow_expand_right() {
    return MdiIcon.create(
        "mdi-arrow-expand-right",
        new MdiMeta(
            "arrow-expand-right",
            "F0798",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Michael Richins",
            "2.0.46"));
  }

  public static MdiIcon arrow_expand_up() {
    return MdiIcon.create(
        "mdi-arrow-expand-up",
        new MdiMeta(
            "arrow-expand-up",
            "F0799",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Michael Richins",
            "2.0.46"));
  }

  public static MdiIcon arrow_expand_vertical() {
    return MdiIcon.create(
        "mdi-arrow-expand-vertical",
        new MdiMeta(
            "arrow-expand-vertical",
            "F084F",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Google",
            "2.1.99"));
  }

  public static MdiIcon arrow_horizontal_lock() {
    return MdiIcon.create(
        "mdi-arrow-horizontal-lock",
        new MdiMeta(
            "arrow-horizontal-lock",
            "F115B",
            Arrays.asList("Lock", "Arrow"),
            Arrays.asList("scroll-horizontal-lock"),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon arrow_left() {
    return MdiIcon.create(
        "mdi-arrow-left",
        new MdiMeta(
            "arrow-left",
            "F004D",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-back"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon arrow_left_bold() {
    return MdiIcon.create(
        "mdi-arrow-left-bold",
        new MdiMeta(
            "arrow-left-bold",
            "F0731",
            Arrays.asList("Arrow", "Automotive"),
            Arrays.asList(),
            "Austin Andrews",
            "1.9.32"));
  }

  public static MdiIcon arrow_left_bold_box() {
    return MdiIcon.create(
        "mdi-arrow-left-bold-box",
        new MdiMeta(
            "arrow-left-bold-box",
            "F0732",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "1.9.32"));
  }

  public static MdiIcon arrow_left_bold_box_outline() {
    return MdiIcon.create(
        "mdi-arrow-left-bold-box-outline",
        new MdiMeta(
            "arrow-left-bold-box-outline",
            "F0733",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "1.9.32"));
  }

  public static MdiIcon arrow_left_bold_circle() {
    return MdiIcon.create(
        "mdi-arrow-left-bold-circle",
        new MdiMeta(
            "arrow-left-bold-circle",
            "F004F",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_left_bold_circle_outline() {
    return MdiIcon.create(
        "mdi-arrow-left-bold-circle-outline",
        new MdiMeta(
            "arrow-left-bold-circle-outline",
            "F0050",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_left_bold_hexagon_outline() {
    return MdiIcon.create(
        "mdi-arrow-left-bold-hexagon-outline",
        new MdiMeta(
            "arrow-left-bold-hexagon-outline",
            "F0051",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_left_bold_outline() {
    return MdiIcon.create(
        "mdi-arrow-left-bold-outline",
        new MdiMeta(
            "arrow-left-bold-outline",
            "F09C0",
            Arrays.asList("Arrow", "Automotive"),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon arrow_left_bottom() {
    return MdiIcon.create(
        "mdi-arrow-left-bottom",
        new MdiMeta(
            "arrow-left-bottom",
            "F17A5",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_left_bottom_bold() {
    return MdiIcon.create(
        "mdi-arrow-left-bottom-bold",
        new MdiMeta(
            "arrow-left-bottom-bold",
            "F17A6",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_left_box() {
    return MdiIcon.create(
        "mdi-arrow-left-box",
        new MdiMeta(
            "arrow-left-box",
            "F06C1",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "1.8.36"));
  }

  public static MdiIcon arrow_left_circle() {
    return MdiIcon.create(
        "mdi-arrow-left-circle",
        new MdiMeta(
            "arrow-left-circle",
            "F0CDD",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-back-circle"),
            "Austin Andrews",
            "3.3.92"));
  }

  public static MdiIcon arrow_left_circle_outline() {
    return MdiIcon.create(
        "mdi-arrow-left-circle-outline",
        new MdiMeta(
            "arrow-left-circle-outline",
            "F0CDE",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "3.3.92"));
  }

  public static MdiIcon arrow_left_drop_circle() {
    return MdiIcon.create(
        "mdi-arrow-left-drop-circle",
        new MdiMeta(
            "arrow-left-drop-circle",
            "F0052",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_left_drop_circle_outline() {
    return MdiIcon.create(
        "mdi-arrow-left-drop-circle-outline",
        new MdiMeta(
            "arrow-left-drop-circle-outline",
            "F0053",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_left_right() {
    return MdiIcon.create(
        "mdi-arrow-left-right",
        new MdiMeta(
            "arrow-left-right",
            "F0E73",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "ginlime",
            "3.7.94"));
  }

  public static MdiIcon arrow_left_right_bold() {
    return MdiIcon.create(
        "mdi-arrow-left-right-bold",
        new MdiMeta(
            "arrow-left-right-bold",
            "F0E74",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "3.7.94"));
  }

  public static MdiIcon arrow_left_right_bold_outline() {
    return MdiIcon.create(
        "mdi-arrow-left-right-bold-outline",
        new MdiMeta(
            "arrow-left-right-bold-outline",
            "F09C1",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon arrow_left_thick() {
    return MdiIcon.create(
        "mdi-arrow-left-thick",
        new MdiMeta(
            "arrow-left-thick",
            "F004E",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-left-bold"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_left_thin() {
    return MdiIcon.create(
        "mdi-arrow-left-thin",
        new MdiMeta(
            "arrow-left-thin",
            "F19B1",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Matt Stayner",
            "6.5.95"));
  }

  public static MdiIcon arrow_left_thin_circle_outline() {
    return MdiIcon.create(
        "mdi-arrow-left-thin-circle-outline",
        new MdiMeta(
            "arrow-left-thin-circle-outline",
            "F159A",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Google",
            "5.5.55"));
  }

  public static MdiIcon arrow_left_top() {
    return MdiIcon.create(
        "mdi-arrow-left-top",
        new MdiMeta(
            "arrow-left-top",
            "F17A7",
            Arrays.asList(),
            Arrays.asList("turn-left"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_left_top_bold() {
    return MdiIcon.create(
        "mdi-arrow-left-top-bold",
        new MdiMeta(
            "arrow-left-top-bold",
            "F17A8",
            Arrays.asList(),
            Arrays.asList("turn-left-bold"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_projectile() {
    return MdiIcon.create(
        "mdi-arrow-projectile",
        new MdiMeta(
            "arrow-projectile",
            "F1840",
            Arrays.asList("Gaming / RPG", "Sport"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon arrow_projectile_multiple() {
    return MdiIcon.create(
        "mdi-arrow-projectile-multiple",
        new MdiMeta(
            "arrow-projectile-multiple",
            "F183F",
            Arrays.asList("Gaming / RPG", "Sport"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon arrow_right() {
    return MdiIcon.create(
        "mdi-arrow-right",
        new MdiMeta(
            "arrow-right",
            "F0054",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-forward"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon arrow_right_bold() {
    return MdiIcon.create(
        "mdi-arrow-right-bold",
        new MdiMeta(
            "arrow-right-bold",
            "F0734",
            Arrays.asList("Arrow", "Automotive"),
            Arrays.asList(),
            "Austin Andrews",
            "1.9.32"));
  }

  public static MdiIcon arrow_right_bold_box() {
    return MdiIcon.create(
        "mdi-arrow-right-bold-box",
        new MdiMeta(
            "arrow-right-bold-box",
            "F0735",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "1.9.32"));
  }

  public static MdiIcon arrow_right_bold_box_outline() {
    return MdiIcon.create(
        "mdi-arrow-right-bold-box-outline",
        new MdiMeta(
            "arrow-right-bold-box-outline",
            "F0736",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "1.9.32"));
  }

  public static MdiIcon arrow_right_bold_circle() {
    return MdiIcon.create(
        "mdi-arrow-right-bold-circle",
        new MdiMeta(
            "arrow-right-bold-circle",
            "F0056",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_right_bold_circle_outline() {
    return MdiIcon.create(
        "mdi-arrow-right-bold-circle-outline",
        new MdiMeta(
            "arrow-right-bold-circle-outline",
            "F0057",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_right_bold_hexagon_outline() {
    return MdiIcon.create(
        "mdi-arrow-right-bold-hexagon-outline",
        new MdiMeta(
            "arrow-right-bold-hexagon-outline",
            "F0058",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_right_bold_outline() {
    return MdiIcon.create(
        "mdi-arrow-right-bold-outline",
        new MdiMeta(
            "arrow-right-bold-outline",
            "F09C2",
            Arrays.asList("Arrow", "Automotive"),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon arrow_right_bottom() {
    return MdiIcon.create(
        "mdi-arrow-right-bottom",
        new MdiMeta(
            "arrow-right-bottom",
            "F17A9",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_right_bottom_bold() {
    return MdiIcon.create(
        "mdi-arrow-right-bottom-bold",
        new MdiMeta(
            "arrow-right-bottom-bold",
            "F17AA",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_right_box() {
    return MdiIcon.create(
        "mdi-arrow-right-box",
        new MdiMeta(
            "arrow-right-box",
            "F06C2",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "1.8.36"));
  }

  public static MdiIcon arrow_right_circle() {
    return MdiIcon.create(
        "mdi-arrow-right-circle",
        new MdiMeta(
            "arrow-right-circle",
            "F0CDF",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-forward-circle"),
            "Austin Andrews",
            "3.3.92"));
  }

  public static MdiIcon arrow_right_circle_outline() {
    return MdiIcon.create(
        "mdi-arrow-right-circle-outline",
        new MdiMeta(
            "arrow-right-circle-outline",
            "F0CE0",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "3.3.92"));
  }

  public static MdiIcon arrow_right_drop_circle() {
    return MdiIcon.create(
        "mdi-arrow-right-drop-circle",
        new MdiMeta(
            "arrow-right-drop-circle",
            "F0059",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_right_drop_circle_outline() {
    return MdiIcon.create(
        "mdi-arrow-right-drop-circle-outline",
        new MdiMeta(
            "arrow-right-drop-circle-outline",
            "F005A",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_right_thick() {
    return MdiIcon.create(
        "mdi-arrow-right-thick",
        new MdiMeta(
            "arrow-right-thick",
            "F0055",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-right-bold"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_right_thin() {
    return MdiIcon.create(
        "mdi-arrow-right-thin",
        new MdiMeta(
            "arrow-right-thin",
            "F19B0",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Matt Stayner",
            "6.5.95"));
  }

  public static MdiIcon arrow_right_thin_circle_outline() {
    return MdiIcon.create(
        "mdi-arrow-right-thin-circle-outline",
        new MdiMeta(
            "arrow-right-thin-circle-outline",
            "F1598",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Google",
            "5.5.55"));
  }

  public static MdiIcon arrow_right_top() {
    return MdiIcon.create(
        "mdi-arrow-right-top",
        new MdiMeta(
            "arrow-right-top",
            "F17AB",
            Arrays.asList(),
            Arrays.asList("turn-right"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_right_top_bold() {
    return MdiIcon.create(
        "mdi-arrow-right-top-bold",
        new MdiMeta(
            "arrow-right-top-bold",
            "F17AC",
            Arrays.asList(),
            Arrays.asList("turn-right-bold"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_split_horizontal() {
    return MdiIcon.create(
        "mdi-arrow-split-horizontal",
        new MdiMeta(
            "arrow-split-horizontal",
            "F093B",
            Arrays.asList("Arrow"),
            Arrays.asList("resize-vertical", "resize"),
            "Michael Richins",
            "2.4.85"));
  }

  public static MdiIcon arrow_split_vertical() {
    return MdiIcon.create(
        "mdi-arrow-split-vertical",
        new MdiMeta(
            "arrow-split-vertical",
            "F093C",
            Arrays.asList("Arrow"),
            Arrays.asList("resize-horizontal", "resize"),
            "Michael Richins",
            "2.4.85"));
  }

  public static MdiIcon arrow_top_left() {
    return MdiIcon.create(
        "mdi-arrow-top-left",
        new MdiMeta(
            "arrow-top-left",
            "F005B",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-up-left"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_top_left_bold_box() {
    return MdiIcon.create(
        "mdi-arrow-top-left-bold-box",
        new MdiMeta(
            "arrow-top-left-bold-box",
            "F1968",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.5.95"));
  }

  public static MdiIcon arrow_top_left_bold_box_outline() {
    return MdiIcon.create(
        "mdi-arrow-top-left-bold-box-outline",
        new MdiMeta(
            "arrow-top-left-bold-box-outline",
            "F1969",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.5.95"));
  }

  public static MdiIcon arrow_top_left_bold_outline() {
    return MdiIcon.create(
        "mdi-arrow-top-left-bold-outline",
        new MdiMeta(
            "arrow-top-left-bold-outline",
            "F09C3",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-up-left-bold-outline"),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon arrow_top_left_bottom_right() {
    return MdiIcon.create(
        "mdi-arrow-top-left-bottom-right",
        new MdiMeta(
            "arrow-top-left-bottom-right",
            "F0E75",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "ginlime",
            "3.7.94"));
  }

  public static MdiIcon arrow_top_left_bottom_right_bold() {
    return MdiIcon.create(
        "mdi-arrow-top-left-bottom-right-bold",
        new MdiMeta(
            "arrow-top-left-bottom-right-bold",
            "F0E76",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "3.7.94"));
  }

  public static MdiIcon arrow_top_left_thick() {
    return MdiIcon.create(
        "mdi-arrow-top-left-thick",
        new MdiMeta(
            "arrow-top-left-thick",
            "F09C4",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-up-left-thick", "arrow-top-left-bold", "arrow-up-left-bold"),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon arrow_top_left_thin() {
    return MdiIcon.create(
        "mdi-arrow-top-left-thin",
        new MdiMeta(
            "arrow-top-left-thin",
            "F19B5",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Matt Stayner",
            "6.5.95"));
  }

  public static MdiIcon arrow_top_left_thin_circle_outline() {
    return MdiIcon.create(
        "mdi-arrow-top-left-thin-circle-outline",
        new MdiMeta(
            "arrow-top-left-thin-circle-outline",
            "F1593",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Google",
            "5.5.55"));
  }

  public static MdiIcon arrow_top_right() {
    return MdiIcon.create(
        "mdi-arrow-top-right",
        new MdiMeta(
            "arrow-top-right",
            "F005C",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-up-right"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_top_right_bold_box() {
    return MdiIcon.create(
        "mdi-arrow-top-right-bold-box",
        new MdiMeta(
            "arrow-top-right-bold-box",
            "F196A",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.5.95"));
  }

  public static MdiIcon arrow_top_right_bold_box_outline() {
    return MdiIcon.create(
        "mdi-arrow-top-right-bold-box-outline",
        new MdiMeta(
            "arrow-top-right-bold-box-outline",
            "F196B",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.5.95"));
  }

  public static MdiIcon arrow_top_right_bold_outline() {
    return MdiIcon.create(
        "mdi-arrow-top-right-bold-outline",
        new MdiMeta(
            "arrow-top-right-bold-outline",
            "F09C5",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-up-right-bold-outline"),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon arrow_top_right_bottom_left() {
    return MdiIcon.create(
        "mdi-arrow-top-right-bottom-left",
        new MdiMeta(
            "arrow-top-right-bottom-left",
            "F0E77",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "ginlime",
            "3.7.94"));
  }

  public static MdiIcon arrow_top_right_bottom_left_bold() {
    return MdiIcon.create(
        "mdi-arrow-top-right-bottom-left-bold",
        new MdiMeta(
            "arrow-top-right-bottom-left-bold",
            "F0E78",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "3.7.94"));
  }

  public static MdiIcon arrow_top_right_thick() {
    return MdiIcon.create(
        "mdi-arrow-top-right-thick",
        new MdiMeta(
            "arrow-top-right-thick",
            "F09C6",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-up-right-thick", "arrow-top-right-bold", "arrow-up-right-bold"),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon arrow_top_right_thin() {
    return MdiIcon.create(
        "mdi-arrow-top-right-thin",
        new MdiMeta(
            "arrow-top-right-thin",
            "F19B4",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Matt Stayner",
            "6.5.95"));
  }

  public static MdiIcon arrow_top_right_thin_circle_outline() {
    return MdiIcon.create(
        "mdi-arrow-top-right-thin-circle-outline",
        new MdiMeta(
            "arrow-top-right-thin-circle-outline",
            "F1594",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Google",
            "5.5.55"));
  }

  public static MdiIcon arrow_u_down_left() {
    return MdiIcon.create(
        "mdi-arrow-u-down-left",
        new MdiMeta(
            "arrow-u-down-left",
            "F17AD",
            Arrays.asList(),
            Arrays.asList("u-turn-left"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_u_down_left_bold() {
    return MdiIcon.create(
        "mdi-arrow-u-down-left-bold",
        new MdiMeta(
            "arrow-u-down-left-bold",
            "F17AE",
            Arrays.asList(),
            Arrays.asList("u-turn-left-bold"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_u_down_right() {
    return MdiIcon.create(
        "mdi-arrow-u-down-right",
        new MdiMeta(
            "arrow-u-down-right",
            "F17AF",
            Arrays.asList(),
            Arrays.asList("u-turn-right"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_u_down_right_bold() {
    return MdiIcon.create(
        "mdi-arrow-u-down-right-bold",
        new MdiMeta(
            "arrow-u-down-right-bold",
            "F17B0",
            Arrays.asList(),
            Arrays.asList("u-turn-right-bold"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_u_left_bottom() {
    return MdiIcon.create(
        "mdi-arrow-u-left-bottom",
        new MdiMeta(
            "arrow-u-left-bottom",
            "F17B1",
            Arrays.asList(),
            Arrays.asList("undo"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_u_left_bottom_bold() {
    return MdiIcon.create(
        "mdi-arrow-u-left-bottom-bold",
        new MdiMeta(
            "arrow-u-left-bottom-bold",
            "F17B2",
            Arrays.asList(),
            Arrays.asList("undo"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_u_left_top() {
    return MdiIcon.create(
        "mdi-arrow-u-left-top",
        new MdiMeta(
            "arrow-u-left-top",
            "F17B3",
            Arrays.asList(),
            Arrays.asList("undo"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_u_left_top_bold() {
    return MdiIcon.create(
        "mdi-arrow-u-left-top-bold",
        new MdiMeta(
            "arrow-u-left-top-bold",
            "F17B4",
            Arrays.asList(),
            Arrays.asList("undo"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_u_right_bottom() {
    return MdiIcon.create(
        "mdi-arrow-u-right-bottom",
        new MdiMeta(
            "arrow-u-right-bottom",
            "F17B5",
            Arrays.asList(),
            Arrays.asList("redo"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_u_right_bottom_bold() {
    return MdiIcon.create(
        "mdi-arrow-u-right-bottom-bold",
        new MdiMeta(
            "arrow-u-right-bottom-bold",
            "F17B6",
            Arrays.asList(),
            Arrays.asList("redo"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_u_right_top() {
    return MdiIcon.create(
        "mdi-arrow-u-right-top",
        new MdiMeta(
            "arrow-u-right-top",
            "F17B7",
            Arrays.asList(),
            Arrays.asList("redo"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_u_right_top_bold() {
    return MdiIcon.create(
        "mdi-arrow-u-right-top-bold",
        new MdiMeta(
            "arrow-u-right-top-bold",
            "F17B8",
            Arrays.asList(),
            Arrays.asList("redo"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_u_up_left() {
    return MdiIcon.create(
        "mdi-arrow-u-up-left",
        new MdiMeta(
            "arrow-u-up-left",
            "F17B9",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_u_up_left_bold() {
    return MdiIcon.create(
        "mdi-arrow-u-up-left-bold",
        new MdiMeta(
            "arrow-u-up-left-bold",
            "F17BA",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_u_up_right() {
    return MdiIcon.create(
        "mdi-arrow-u-up-right",
        new MdiMeta(
            "arrow-u-up-right",
            "F17BB",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_u_up_right_bold() {
    return MdiIcon.create(
        "mdi-arrow-u-up-right-bold",
        new MdiMeta(
            "arrow-u-up-right-bold",
            "F17BC",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_up() {
    return MdiIcon.create(
        "mdi-arrow-up",
        new MdiMeta(
            "arrow-up",
            "F005D",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-upward", "arrow-top"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_up_bold() {
    return MdiIcon.create(
        "mdi-arrow-up-bold",
        new MdiMeta(
            "arrow-up-bold",
            "F0737",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-top-bold"),
            "Austin Andrews",
            "1.9.32"));
  }

  public static MdiIcon arrow_up_bold_box() {
    return MdiIcon.create(
        "mdi-arrow-up-bold-box",
        new MdiMeta(
            "arrow-up-bold-box",
            "F0738",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-top-bold-box"),
            "Austin Andrews",
            "1.9.32"));
  }

  public static MdiIcon arrow_up_bold_box_outline() {
    return MdiIcon.create(
        "mdi-arrow-up-bold-box-outline",
        new MdiMeta(
            "arrow-up-bold-box-outline",
            "F0739",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-top-bold-box-outline"),
            "Austin Andrews",
            "1.9.32"));
  }

  public static MdiIcon arrow_up_bold_circle() {
    return MdiIcon.create(
        "mdi-arrow-up-bold-circle",
        new MdiMeta(
            "arrow-up-bold-circle",
            "F005F",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-top-bold-circle"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_up_bold_circle_outline() {
    return MdiIcon.create(
        "mdi-arrow-up-bold-circle-outline",
        new MdiMeta(
            "arrow-up-bold-circle-outline",
            "F0060",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-top-bold-circle-outline"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_up_bold_hexagon_outline() {
    return MdiIcon.create(
        "mdi-arrow-up-bold-hexagon-outline",
        new MdiMeta(
            "arrow-up-bold-hexagon-outline",
            "F0061",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-top-bold-hexagon-outline"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_up_bold_outline() {
    return MdiIcon.create(
        "mdi-arrow-up-bold-outline",
        new MdiMeta(
            "arrow-up-bold-outline",
            "F09C7",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-top-bold-outline"),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon arrow_up_box() {
    return MdiIcon.create(
        "mdi-arrow-up-box",
        new MdiMeta(
            "arrow-up-box",
            "F06C3",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "1.8.36"));
  }

  public static MdiIcon arrow_up_circle() {
    return MdiIcon.create(
        "mdi-arrow-up-circle",
        new MdiMeta(
            "arrow-up-circle",
            "F0CE1",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-top-circle"),
            "Austin Andrews",
            "3.3.92"));
  }

  public static MdiIcon arrow_up_circle_outline() {
    return MdiIcon.create(
        "mdi-arrow-up-circle-outline",
        new MdiMeta(
            "arrow-up-circle-outline",
            "F0CE2",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-top-circle-outline"),
            "Austin Andrews",
            "3.3.92"));
  }

  public static MdiIcon arrow_up_down() {
    return MdiIcon.create(
        "mdi-arrow-up-down",
        new MdiMeta(
            "arrow-up-down",
            "F0E79",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "ginlime",
            "3.7.94"));
  }

  public static MdiIcon arrow_up_down_bold() {
    return MdiIcon.create(
        "mdi-arrow-up-down-bold",
        new MdiMeta(
            "arrow-up-down-bold",
            "F0E7A",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "3.7.94"));
  }

  public static MdiIcon arrow_up_down_bold_outline() {
    return MdiIcon.create(
        "mdi-arrow-up-down-bold-outline",
        new MdiMeta(
            "arrow-up-down-bold-outline",
            "F09C8",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon arrow_up_drop_circle() {
    return MdiIcon.create(
        "mdi-arrow-up-drop-circle",
        new MdiMeta(
            "arrow-up-drop-circle",
            "F0062",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-top-drop-circle"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_up_drop_circle_outline() {
    return MdiIcon.create(
        "mdi-arrow-up-drop-circle-outline",
        new MdiMeta(
            "arrow-up-drop-circle-outline",
            "F0063",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-top-drop-circle-outline"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_up_left() {
    return MdiIcon.create(
        "mdi-arrow-up-left",
        new MdiMeta(
            "arrow-up-left",
            "F17BD",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_up_left_bold() {
    return MdiIcon.create(
        "mdi-arrow-up-left-bold",
        new MdiMeta(
            "arrow-up-left-bold",
            "F17BE",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_up_right() {
    return MdiIcon.create(
        "mdi-arrow-up-right",
        new MdiMeta(
            "arrow-up-right",
            "F17BF",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_up_right_bold() {
    return MdiIcon.create(
        "mdi-arrow-up-right-bold",
        new MdiMeta(
            "arrow-up-right-bold",
            "F17C0",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon arrow_up_thick() {
    return MdiIcon.create(
        "mdi-arrow-up-thick",
        new MdiMeta(
            "arrow-up-thick",
            "F005E",
            Arrays.asList("Arrow"),
            Arrays.asList("arrow-top-thick", "arrow-up-bold", "arrow-top-bold"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon arrow_up_thin() {
    return MdiIcon.create(
        "mdi-arrow-up-thin",
        new MdiMeta(
            "arrow-up-thin",
            "F19B2",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Matt Stayner",
            "6.5.95"));
  }

  public static MdiIcon arrow_up_thin_circle_outline() {
    return MdiIcon.create(
        "mdi-arrow-up-thin-circle-outline",
        new MdiMeta(
            "arrow-up-thin-circle-outline",
            "F1597",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Google",
            "5.5.55"));
  }

  public static MdiIcon arrow_vertical_lock() {
    return MdiIcon.create(
        "mdi-arrow-vertical-lock",
        new MdiMeta(
            "arrow-vertical-lock",
            "F115C",
            Arrays.asList("Lock", "Arrow"),
            Arrays.asList("scroll-vertical-lock"),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon artboard() {
    return MdiIcon.create(
        "mdi-artboard",
        new MdiMeta(
            "artboard",
            "F1B9A",
            Arrays.asList("Drawing / Art"),
            Arrays.asList("canvas", "frame"),
            "Sintija",
            "7.0.96"));
  }

  @Deprecated
  public static MdiIcon artstation() {
    return MdiIcon.create(
        "mdi-artstation",
        new MdiMeta(
            "artstation",
            "F0B5B",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "3.0.39"));
  }

  public static MdiIcon aspect_ratio() {
    return MdiIcon.create(
        "mdi-aspect-ratio",
        new MdiMeta("aspect-ratio", "F0A24", Arrays.asList(), Arrays.asList(), "Google", "2.6.95"));
  }

  public static MdiIcon assistant() {
    return MdiIcon.create(
        "mdi-assistant",
        new MdiMeta("assistant", "F0064", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon asterisk() {
    return MdiIcon.create(
        "mdi-asterisk",
        new MdiMeta(
            "asterisk",
            "F06C4",
            Arrays.asList(),
            Arrays.asList("required"),
            "Michael Irigoyen",
            "1.8.36"));
  }

  public static MdiIcon asterisk_circle_outline() {
    return MdiIcon.create(
        "mdi-asterisk-circle-outline",
        new MdiMeta(
            "asterisk-circle-outline",
            "F1A27",
            Arrays.asList(),
            Arrays.asList("required-circle"),
            "mocking-mike",
            "6.6.96"));
  }

  public static MdiIcon at() {
    return MdiIcon.create(
        "mdi-at",
        new MdiMeta(
            "at", "F0065", Arrays.asList(), Arrays.asList("alternate-email"), "Google", "1.5.54"));
  }

  @Deprecated
  public static MdiIcon atlassian() {
    return MdiIcon.create(
        "mdi-atlassian",
        new MdiMeta(
            "atlassian",
            "F0804",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "2.1.19"));
  }

  public static MdiIcon atm() {
    return MdiIcon.create(
        "mdi-atm",
        new MdiMeta("atm", "F0D47", Arrays.asList(), Arrays.asList(), "Google", "3.4.93"));
  }

  public static MdiIcon atom() {
    return MdiIcon.create(
        "mdi-atom",
        new MdiMeta(
            "atom",
            "F0768",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Roberto Graham",
            "1.9.32"));
  }

  public static MdiIcon atom_variant() {
    return MdiIcon.create(
        "mdi-atom-variant",
        new MdiMeta(
            "atom-variant",
            "F0E7B",
            Arrays.asList("Science"),
            Arrays.asList("orbit"),
            "Austin Andrews",
            "3.7.94"));
  }

  public static MdiIcon attachment() {
    return MdiIcon.create(
        "mdi-attachment",
        new MdiMeta(
            "attachment",
            "F0066",
            Arrays.asList(),
            Arrays.asList("paperclip-horizontal"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon attachment_check() {
    return MdiIcon.create(
        "mdi-attachment-check",
        new MdiMeta(
            "attachment-check",
            "F1AC1",
            Arrays.asList(),
            Arrays.asList("attachment-tick", "paperclip-check", "paperclip-tick"),
            "Colton Wiscombe",
            "6.8.96"));
  }

  public static MdiIcon attachment_lock() {
    return MdiIcon.create(
        "mdi-attachment-lock",
        new MdiMeta(
            "attachment-lock",
            "F19C4",
            Arrays.asList("Lock"),
            Arrays.asList("paperclip-lock"),
            "Simran",
            "6.6.96"));
  }

  public static MdiIcon attachment_minus() {
    return MdiIcon.create(
        "mdi-attachment-minus",
        new MdiMeta(
            "attachment-minus",
            "F1AC2",
            Arrays.asList(),
            Arrays.asList("paperclip-minus", "paperclip-subtract", "attachment-subtract"),
            "Colton Wiscombe",
            "6.8.96"));
  }

  public static MdiIcon attachment_off() {
    return MdiIcon.create(
        "mdi-attachment-off",
        new MdiMeta(
            "attachment-off",
            "F1AC3",
            Arrays.asList(),
            Arrays.asList("paperclip-off"),
            "Colton Wiscombe",
            "6.8.96"));
  }

  public static MdiIcon attachment_plus() {
    return MdiIcon.create(
        "mdi-attachment-plus",
        new MdiMeta(
            "attachment-plus",
            "F1AC4",
            Arrays.asList(),
            Arrays.asList("paperclip-plus", "paperclip-add", "attachment-add"),
            "Colton Wiscombe",
            "6.8.96"));
  }

  public static MdiIcon attachment_remove() {
    return MdiIcon.create(
        "mdi-attachment-remove",
        new MdiMeta(
            "attachment-remove",
            "F1AC5",
            Arrays.asList(),
            Arrays.asList("paperclip-remove"),
            "Colton Wiscombe",
            "6.8.96"));
  }

  public static MdiIcon atv() {
    return MdiIcon.create(
        "mdi-atv",
        new MdiMeta(
            "atv",
            "F1B70",
            Arrays.asList("Transportation + Other", "Sport"),
            Arrays.asList("quad", "trike", "two-wheeler", "all-terrain-vehicle"),
            "Google",
            "7.0.96"));
  }

  public static MdiIcon audio_input_rca() {
    return MdiIcon.create(
        "mdi-audio-input-rca",
        new MdiMeta(
            "audio-input-rca",
            "F186B",
            Arrays.asList("Audio"),
            Arrays.asList(),
            "GreenTurtwig",
            "6.2.95"));
  }

  public static MdiIcon audio_input_stereo_minijack() {
    return MdiIcon.create(
        "mdi-audio-input-stereo-minijack",
        new MdiMeta(
            "audio-input-stereo-minijack",
            "F186C",
            Arrays.asList("Audio"),
            Arrays.asList(),
            "GreenTurtwig",
            "6.2.95"));
  }

  public static MdiIcon audio_input_xlr() {
    return MdiIcon.create(
        "mdi-audio-input-xlr",
        new MdiMeta(
            "audio-input-xlr",
            "F186D",
            Arrays.asList("Audio"),
            Arrays.asList(),
            "GreenTurtwig",
            "6.2.95"));
  }

  public static MdiIcon audio_video() {
    return MdiIcon.create(
        "mdi-audio-video",
        new MdiMeta(
            "audio-video",
            "F093D",
            Arrays.asList("Home Automation", "Audio"),
            Arrays.asList("av-receiver"),
            "Michael Richins",
            "2.4.85"));
  }

  public static MdiIcon audio_video_off() {
    return MdiIcon.create(
        "mdi-audio-video-off",
        new MdiMeta(
            "audio-video-off",
            "F11B6",
            Arrays.asList("Home Automation", "Audio"),
            Arrays.asList("av-receiver-off"),
            "Michael Irigoyen",
            "4.5.95"));
  }

  public static MdiIcon augmented_reality() {
    return MdiIcon.create(
        "mdi-augmented-reality",
        new MdiMeta(
            "augmented-reality",
            "F0850",
            Arrays.asList(),
            Arrays.asList(),
            "GreenTurtwig",
            "2.1.99"));
  }

  public static MdiIcon aurora() {
    return MdiIcon.create(
        "mdi-aurora",
        new MdiMeta(
            "aurora",
            "F1BB9",
            Arrays.asList("Science", "Weather"),
            Arrays.asList(
                "aurora-borealis",
                "aurora-australis",
                "northern-lights",
                "southern-lights",
                "polar-lights"),
            "Jeff Anders",
            "7.1.96"));
  }

  public static MdiIcon auto_download() {
    return MdiIcon.create(
        "mdi-auto-download",
        new MdiMeta(
            "auto-download",
            "F137E",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "4.9.95"));
  }

  public static MdiIcon auto_fix() {
    return MdiIcon.create(
        "mdi-auto-fix",
        new MdiMeta(
            "auto-fix",
            "F0068",
            Arrays.asList("Photography"),
            Arrays.asList("magic", "wand", "auto-fix-high"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon auto_mode() {
    return MdiIcon.create(
        "mdi-auto-mode",
        new MdiMeta(
            "auto-mode", "F1C20", Arrays.asList(), Arrays.asList(), "Jeff Anders", "7.2.96"));
  }

  public static MdiIcon auto_upload() {
    return MdiIcon.create(
        "mdi-auto-upload",
        new MdiMeta("auto-upload", "F0069", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon autorenew() {
    return MdiIcon.create(
        "mdi-autorenew",
        new MdiMeta(
            "autorenew",
            "F006A",
            Arrays.asList("Arrow"),
            Arrays.asList("clockwise-arrows", "circular-arrows", "circle-arrows", "sync"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon autorenew_off() {
    return MdiIcon.create(
        "mdi-autorenew-off",
        new MdiMeta(
            "autorenew-off",
            "F19E7",
            Arrays.asList("Arrow"),
            Arrays.asList(
                "clockwise-arrows-off", "circular-arrows-off", "circle-arrows-off", "sync-off"),
            "Colton Wiscombe",
            "6.6.96"));
  }

  public static MdiIcon av_timer() {
    return MdiIcon.create(
        "mdi-av-timer",
        new MdiMeta(
            "av-timer",
            "F006B",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon awning() {
    return MdiIcon.create(
        "mdi-awning",
        new MdiMeta(
            "awning",
            "F1B87",
            Arrays.asList("Home Automation"),
            Arrays.asList("marquise", "sun-shade"),
            "Jeff Anders",
            "7.0.96"));
  }

  public static MdiIcon awning_outline() {
    return MdiIcon.create(
        "mdi-awning-outline",
        new MdiMeta(
            "awning-outline",
            "F1B88",
            Arrays.asList("Home Automation"),
            Arrays.asList("marquise-outline", "sun-shade-outline"),
            "Jeff Anders",
            "7.0.96"));
  }

  @Deprecated
  public static MdiIcon aws() {
    return MdiIcon.create(
        "mdi-aws",
        new MdiMeta(
            "aws",
            "F0E0F",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "3.6.95"));
  }

  public static MdiIcon axe() {
    return MdiIcon.create(
        "mdi-axe",
        new MdiMeta(
            "axe", "F08C8", Arrays.asList("Hardware / Tools"), Arrays.asList(), "Nick", "2.3.50"));
  }

  public static MdiIcon axe_battle() {
    return MdiIcon.create(
        "mdi-axe-battle",
        new MdiMeta(
            "axe-battle",
            "F1842",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon axis() {
    return MdiIcon.create(
        "mdi-axis",
        new MdiMeta("axis", "F0D48", Arrays.asList(), Arrays.asList(), "Austin Andrews", "3.4.93"));
  }

  public static MdiIcon axis_arrow() {
    return MdiIcon.create(
        "mdi-axis-arrow",
        new MdiMeta(
            "axis-arrow",
            "F0D49",
            Arrays.asList("Arrow"),
            Arrays.asList("accelerometer", "gyro"),
            "Austin Andrews",
            "3.4.93"));
  }

  public static MdiIcon axis_arrow_info() {
    return MdiIcon.create(
        "mdi-axis-arrow-info",
        new MdiMeta(
            "axis-arrow-info",
            "F140E",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "5.1.45"));
  }

  public static MdiIcon axis_arrow_lock() {
    return MdiIcon.create(
        "mdi-axis-arrow-lock",
        new MdiMeta(
            "axis-arrow-lock",
            "F0D4A",
            Arrays.asList("Lock", "Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "3.4.93"));
  }

  public static MdiIcon axis_lock() {
    return MdiIcon.create(
        "mdi-axis-lock",
        new MdiMeta(
            "axis-lock",
            "F0D4B",
            Arrays.asList("Lock"),
            Arrays.asList(),
            "Austin Andrews",
            "3.4.93"));
  }

  public static MdiIcon axis_x_arrow() {
    return MdiIcon.create(
        "mdi-axis-x-arrow",
        new MdiMeta(
            "axis-x-arrow",
            "F0D4C",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "3.4.93"));
  }

  public static MdiIcon axis_x_arrow_lock() {
    return MdiIcon.create(
        "mdi-axis-x-arrow-lock",
        new MdiMeta(
            "axis-x-arrow-lock",
            "F0D4D",
            Arrays.asList("Lock", "Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "3.4.93"));
  }

  public static MdiIcon axis_x_rotate_clockwise() {
    return MdiIcon.create(
        "mdi-axis-x-rotate-clockwise",
        new MdiMeta(
            "axis-x-rotate-clockwise",
            "F0D4E",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "3.4.93"));
  }

  public static MdiIcon axis_x_rotate_counterclockwise() {
    return MdiIcon.create(
        "mdi-axis-x-rotate-counterclockwise",
        new MdiMeta(
            "axis-x-rotate-counterclockwise",
            "F0D4F",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "3.4.93"));
  }

  public static MdiIcon axis_x_y_arrow_lock() {
    return MdiIcon.create(
        "mdi-axis-x-y-arrow-lock",
        new MdiMeta(
            "axis-x-y-arrow-lock",
            "F0D50",
            Arrays.asList("Lock", "Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "3.4.93"));
  }

  public static MdiIcon axis_y_arrow() {
    return MdiIcon.create(
        "mdi-axis-y-arrow",
        new MdiMeta(
            "axis-y-arrow",
            "F0D51",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "3.4.93"));
  }

  public static MdiIcon axis_y_arrow_lock() {
    return MdiIcon.create(
        "mdi-axis-y-arrow-lock",
        new MdiMeta(
            "axis-y-arrow-lock",
            "F0D52",
            Arrays.asList("Lock", "Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "3.4.93"));
  }

  public static MdiIcon axis_y_rotate_clockwise() {
    return MdiIcon.create(
        "mdi-axis-y-rotate-clockwise",
        new MdiMeta(
            "axis-y-rotate-clockwise",
            "F0D53",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "3.4.93"));
  }

  public static MdiIcon axis_y_rotate_counterclockwise() {
    return MdiIcon.create(
        "mdi-axis-y-rotate-counterclockwise",
        new MdiMeta(
            "axis-y-rotate-counterclockwise",
            "F0D54",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "3.4.93"));
  }

  public static MdiIcon axis_z_arrow() {
    return MdiIcon.create(
        "mdi-axis-z-arrow",
        new MdiMeta(
            "axis-z-arrow",
            "F0D55",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "3.4.93"));
  }

  public static MdiIcon axis_z_arrow_lock() {
    return MdiIcon.create(
        "mdi-axis-z-arrow-lock",
        new MdiMeta(
            "axis-z-arrow-lock",
            "F0D56",
            Arrays.asList("Lock", "Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "3.4.93"));
  }

  public static MdiIcon axis_z_rotate_clockwise() {
    return MdiIcon.create(
        "mdi-axis-z-rotate-clockwise",
        new MdiMeta(
            "axis-z-rotate-clockwise",
            "F0D57",
            Arrays.asList(),
            Arrays.asList("vertical-rotate-clockwise"),
            "Michael Irigoyen",
            "3.4.93"));
  }

  public static MdiIcon axis_z_rotate_counterclockwise() {
    return MdiIcon.create(
        "mdi-axis-z-rotate-counterclockwise",
        new MdiMeta(
            "axis-z-rotate-counterclockwise",
            "F0D58",
            Arrays.asList(),
            Arrays.asList("vertical-rotate-counterclockwise"),
            "Michael Irigoyen",
            "3.4.93"));
  }

  @Deprecated
  public static MdiIcon babel() {
    return MdiIcon.create(
        "mdi-babel",
        new MdiMeta(
            "babel",
            "F0A25",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "2.6.95"));
  }

  public static MdiIcon baby() {
    return MdiIcon.create(
        "mdi-baby",
        new MdiMeta(
            "baby",
            "F006C",
            Arrays.asList("People / Family"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon baby_bottle() {
    return MdiIcon.create(
        "mdi-baby-bottle",
        new MdiMeta(
            "baby-bottle",
            "F0F39",
            Arrays.asList("People / Family"),
            Arrays.asList(),
            "Michael Richins",
            "3.9.97"));
  }

  public static MdiIcon baby_bottle_outline() {
    return MdiIcon.create(
        "mdi-baby-bottle-outline",
        new MdiMeta(
            "baby-bottle-outline",
            "F0F3A",
            Arrays.asList("People / Family"),
            Arrays.asList(),
            "Michael Richins",
            "3.9.97"));
  }

  public static MdiIcon baby_buggy() {
    return MdiIcon.create(
        "mdi-baby-buggy",
        new MdiMeta(
            "baby-buggy",
            "F13E0",
            Arrays.asList("People / Family"),
            Arrays.asList("stroller", "pram", "carriage"),
            "Moma Design Studio",
            "5.1.45"));
  }

  public static MdiIcon baby_buggy_off() {
    return MdiIcon.create(
        "mdi-baby-buggy-off",
        new MdiMeta(
            "baby-buggy-off",
            "F1AF3",
            Arrays.asList("People / Family"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.9.96"));
  }

  public static MdiIcon baby_carriage() {
    return MdiIcon.create(
        "mdi-baby-carriage",
        new MdiMeta(
            "baby-carriage",
            "F068F",
            Arrays.asList("People / Family"),
            Arrays.asList("child-friendly", "stroller", "pram", "buggy"),
            "Google",
            "1.7.12"));
  }

  public static MdiIcon baby_carriage_off() {
    return MdiIcon.create(
        "mdi-baby-carriage-off",
        new MdiMeta(
            "baby-carriage-off",
            "F0FA0",
            Arrays.asList("People / Family"),
            Arrays.asList("child-friendly-off", "stroller-off", "pram-off", "buggy-off"),
            "Michael Richins",
            "4.0.96"));
  }

  public static MdiIcon baby_face() {
    return MdiIcon.create(
        "mdi-baby-face",
        new MdiMeta(
            "baby-face",
            "F0E7C",
            Arrays.asList("People / Family"),
            Arrays.asList("emoji-baby", "emoticon-baby"),
            "Google",
            "3.7.94"));
  }

  public static MdiIcon baby_face_outline() {
    return MdiIcon.create(
        "mdi-baby-face-outline",
        new MdiMeta(
            "baby-face-outline",
            "F0E7D",
            Arrays.asList("People / Family"),
            Arrays.asList("emoji-baby-outline", "emoticon-baby-outline"),
            "Google",
            "3.7.94"));
  }

  public static MdiIcon backburger() {
    return MdiIcon.create(
        "mdi-backburger",
        new MdiMeta(
            "backburger",
            "F006D",
            Arrays.asList(),
            Arrays.asList("hamburger-menu-back"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon backspace() {
    return MdiIcon.create(
        "mdi-backspace",
        new MdiMeta(
            "backspace",
            "F006E",
            Arrays.asList(),
            Arrays.asList("erase", "clear"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon backspace_outline() {
    return MdiIcon.create(
        "mdi-backspace-outline",
        new MdiMeta(
            "backspace-outline",
            "F0B5C",
            Arrays.asList(),
            Arrays.asList("erase-outline", "clear-outline"),
            "Google",
            "3.0.39"));
  }

  public static MdiIcon backspace_reverse() {
    return MdiIcon.create(
        "mdi-backspace-reverse",
        new MdiMeta(
            "backspace-reverse",
            "F0E7E",
            Arrays.asList(),
            Arrays.asList("clear-reverse", "erase-reverse"),
            "Michael Irigoyen",
            "3.7.94"));
  }

  public static MdiIcon backspace_reverse_outline() {
    return MdiIcon.create(
        "mdi-backspace-reverse-outline",
        new MdiMeta(
            "backspace-reverse-outline",
            "F0E7F",
            Arrays.asList(),
            Arrays.asList("clear-reverse-outline", "erase-reverse-outline"),
            "Michael Irigoyen",
            "3.7.94"));
  }

  public static MdiIcon backup_restore() {
    return MdiIcon.create(
        "mdi-backup-restore",
        new MdiMeta(
            "backup-restore",
            "F006F",
            Arrays.asList(),
            Arrays.asList("settings-backup-restore"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon bacteria() {
    return MdiIcon.create(
        "mdi-bacteria",
        new MdiMeta(
            "bacteria",
            "F0ED5",
            Arrays.asList("Science", "Medical / Hospital"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.8.95"));
  }

  public static MdiIcon bacteria_outline() {
    return MdiIcon.create(
        "mdi-bacteria-outline",
        new MdiMeta(
            "bacteria-outline",
            "F0ED6",
            Arrays.asList("Science", "Medical / Hospital"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.8.95"));
  }

  public static MdiIcon badge_account() {
    return MdiIcon.create(
        "mdi-badge-account",
        new MdiMeta(
            "badge-account",
            "F0DA7",
            Arrays.asList("Account / User"),
            Arrays.asList("user-badge", "person-badge"),
            "Michael Richins",
            "3.5.94"));
  }

  public static MdiIcon badge_account_alert() {
    return MdiIcon.create(
        "mdi-badge-account-alert",
        new MdiMeta(
            "badge-account-alert",
            "F0DA8",
            Arrays.asList("Account / User", "Alert / Error"),
            Arrays.asList(
                "user-badge-alert",
                "person-badge-alert",
                "account-badge-warning",
                "user-badge-warning",
                "person-badge-warning"),
            "Michael Richins",
            "3.5.94"));
  }

  public static MdiIcon badge_account_alert_outline() {
    return MdiIcon.create(
        "mdi-badge-account-alert-outline",
        new MdiMeta(
            "badge-account-alert-outline",
            "F0DA9",
            Arrays.asList("Account / User", "Alert / Error"),
            Arrays.asList(
                "user-badge-alert-outline",
                "person-badge-alert-outline",
                "account-badge-warning-outline",
                "user-badge-warning-outline",
                "person-badge-warning-outline"),
            "Michael Richins",
            "3.5.94"));
  }

  public static MdiIcon badge_account_horizontal() {
    return MdiIcon.create(
        "mdi-badge-account-horizontal",
        new MdiMeta(
            "badge-account-horizontal",
            "F0E0D",
            Arrays.asList("Account / User"),
            Arrays.asList(),
            "Google",
            "3.6.95"));
  }

  public static MdiIcon badge_account_horizontal_outline() {
    return MdiIcon.create(
        "mdi-badge-account-horizontal-outline",
        new MdiMeta(
            "badge-account-horizontal-outline",
            "F0E0E",
            Arrays.asList("Account / User"),
            Arrays.asList(),
            "Google",
            "3.6.95"));
  }

  public static MdiIcon badge_account_outline() {
    return MdiIcon.create(
        "mdi-badge-account-outline",
        new MdiMeta(
            "badge-account-outline",
            "F0DAA",
            Arrays.asList("Account / User"),
            Arrays.asList("user-badge-outline", "person-badge-outline"),
            "Michael Richins",
            "3.5.94"));
  }

  public static MdiIcon badminton() {
    return MdiIcon.create(
        "mdi-badminton",
        new MdiMeta(
            "badminton",
            "F0851",
            Arrays.asList("Sport"),
            Arrays.asList("shuttlecock"),
            "Nick",
            "2.1.99"));
  }

  public static MdiIcon bag_carry_on() {
    return MdiIcon.create(
        "mdi-bag-carry-on",
        new MdiMeta(
            "bag-carry-on",
            "F0F3B",
            Arrays.asList("Transportation + Flying"),
            Arrays.asList("carry-on-luggage"),
            "Google",
            "3.9.97"));
  }

  public static MdiIcon bag_carry_on_check() {
    return MdiIcon.create(
        "mdi-bag-carry-on-check",
        new MdiMeta(
            "bag-carry-on-check",
            "F0D65",
            Arrays.asList("Transportation + Flying"),
            Arrays.asList("carry-on-bag-tick", "carry-on-bag-check"),
            "Google",
            "3.4.93"));
  }

  public static MdiIcon bag_carry_on_off() {
    return MdiIcon.create(
        "mdi-bag-carry-on-off",
        new MdiMeta(
            "bag-carry-on-off",
            "F0F3C",
            Arrays.asList("Transportation + Flying"),
            Arrays.asList("carry-on-luggage-off"),
            "Google",
            "3.9.97"));
  }

  public static MdiIcon bag_checked() {
    return MdiIcon.create(
        "mdi-bag-checked",
        new MdiMeta(
            "bag-checked",
            "F0F3D",
            Arrays.asList("Transportation + Flying"),
            Arrays.asList("luggage"),
            "Google",
            "3.9.97"));
  }

  public static MdiIcon bag_personal() {
    return MdiIcon.create(
        "mdi-bag-personal",
        new MdiMeta(
            "bag-personal",
            "F0E10",
            Arrays.asList("Transportation + Flying"),
            Arrays.asList("backpack"),
            "Michael Richins",
            "3.6.95"));
  }

  public static MdiIcon bag_personal_off() {
    return MdiIcon.create(
        "mdi-bag-personal-off",
        new MdiMeta(
            "bag-personal-off",
            "F0E11",
            Arrays.asList("Transportation + Flying"),
            Arrays.asList("backpack-off"),
            "Michael Richins",
            "3.6.95"));
  }

  public static MdiIcon bag_personal_off_outline() {
    return MdiIcon.create(
        "mdi-bag-personal-off-outline",
        new MdiMeta(
            "bag-personal-off-outline",
            "F0E12",
            Arrays.asList("Transportation + Flying"),
            Arrays.asList("backpack-off-outline"),
            "Michael Richins",
            "3.6.95"));
  }

  public static MdiIcon bag_personal_outline() {
    return MdiIcon.create(
        "mdi-bag-personal-outline",
        new MdiMeta(
            "bag-personal-outline",
            "F0E13",
            Arrays.asList("Transportation + Flying"),
            Arrays.asList("backpack-outline"),
            "Michael Richins",
            "3.6.95"));
  }

  public static MdiIcon bag_personal_tag() {
    return MdiIcon.create(
        "mdi-bag-personal-tag",
        new MdiMeta(
            "bag-personal-tag",
            "F1B0C",
            Arrays.asList(),
            Arrays.asList("property-tag"),
            "Matthew Terry",
            "6.9.96"));
  }

  public static MdiIcon bag_personal_tag_outline() {
    return MdiIcon.create(
        "mdi-bag-personal-tag-outline",
        new MdiMeta(
            "bag-personal-tag-outline",
            "F1B0D",
            Arrays.asList(),
            Arrays.asList("property-tag-outline"),
            "Matthew Terry",
            "6.9.96"));
  }

  public static MdiIcon bag_suitcase() {
    return MdiIcon.create(
        "mdi-bag-suitcase",
        new MdiMeta(
            "bag-suitcase",
            "F158B",
            Arrays.asList("Transportation + Flying"),
            Arrays.asList(),
            "Google",
            "5.5.55"));
  }

  public static MdiIcon bag_suitcase_off() {
    return MdiIcon.create(
        "mdi-bag-suitcase-off",
        new MdiMeta(
            "bag-suitcase-off",
            "F158D",
            Arrays.asList("Transportation + Flying"),
            Arrays.asList(),
            "Google",
            "5.5.55"));
  }

  public static MdiIcon bag_suitcase_off_outline() {
    return MdiIcon.create(
        "mdi-bag-suitcase-off-outline",
        new MdiMeta(
            "bag-suitcase-off-outline",
            "F158E",
            Arrays.asList("Transportation + Flying"),
            Arrays.asList(),
            "Google",
            "5.5.55"));
  }

  public static MdiIcon bag_suitcase_outline() {
    return MdiIcon.create(
        "mdi-bag-suitcase-outline",
        new MdiMeta(
            "bag-suitcase-outline",
            "F158C",
            Arrays.asList("Transportation + Flying"),
            Arrays.asList(),
            "Google",
            "5.5.55"));
  }

  public static MdiIcon baguette() {
    return MdiIcon.create(
        "mdi-baguette",
        new MdiMeta(
            "baguette",
            "F0F3E",
            Arrays.asList("Food / Drink"),
            Arrays.asList("bread", "bakery", "french-baguette", "loaf"),
            "Nick",
            "3.9.97"));
  }

  public static MdiIcon balcony() {
    return MdiIcon.create(
        "mdi-balcony",
        new MdiMeta(
            "balcony",
            "F1817",
            Arrays.asList("Home Automation"),
            Arrays.asList("terrace", "patio", "veranda"),
            "Google",
            "6.1.95"));
  }

  public static MdiIcon balloon() {
    return MdiIcon.create(
        "mdi-balloon",
        new MdiMeta(
            "balloon",
            "F0A26",
            Arrays.asList("Holiday"),
            Arrays.asList("party-balloon"),
            "Michael Richins",
            "2.6.95"));
  }

  public static MdiIcon ballot() {
    return MdiIcon.create(
        "mdi-ballot",
        new MdiMeta("ballot", "F09C9", Arrays.asList(), Arrays.asList("vote"), "Google", "2.5.94"));
  }

  public static MdiIcon ballot_outline() {
    return MdiIcon.create(
        "mdi-ballot-outline",
        new MdiMeta(
            "ballot-outline",
            "F09CA",
            Arrays.asList(),
            Arrays.asList("vote-outline"),
            "Google",
            "2.5.94"));
  }

  public static MdiIcon ballot_recount() {
    return MdiIcon.create(
        "mdi-ballot-recount",
        new MdiMeta(
            "ballot-recount",
            "F0C39",
            Arrays.asList(),
            Arrays.asList("vote-recount"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon ballot_recount_outline() {
    return MdiIcon.create(
        "mdi-ballot-recount-outline",
        new MdiMeta(
            "ballot-recount-outline",
            "F0C3A",
            Arrays.asList(),
            Arrays.asList("vote-recount-outline"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon bandage() {
    return MdiIcon.create(
        "mdi-bandage",
        new MdiMeta(
            "bandage",
            "F0DAF",
            Arrays.asList(),
            Arrays.asList("band-aid", "plaster"),
            "Google",
            "3.5.94"));
  }

  public static MdiIcon bank() {
    return MdiIcon.create(
        "mdi-bank",
        new MdiMeta(
            "bank",
            "F0070",
            Arrays.asList("Banking", "Places"),
            Arrays.asList("account-balance", "museum"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon bank_check() {
    return MdiIcon.create(
        "mdi-bank-check",
        new MdiMeta(
            "bank-check",
            "F1655",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon bank_circle() {
    return MdiIcon.create(
        "mdi-bank-circle",
        new MdiMeta(
            "bank-circle",
            "F1C03",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Jeff Anders",
            "7.1.96"));
  }

  public static MdiIcon bank_circle_outline() {
    return MdiIcon.create(
        "mdi-bank-circle-outline",
        new MdiMeta(
            "bank-circle-outline",
            "F1C04",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Jeff Anders",
            "7.1.96"));
  }

  public static MdiIcon bank_minus() {
    return MdiIcon.create(
        "mdi-bank-minus",
        new MdiMeta(
            "bank-minus",
            "F0DB0",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Austin Andrews",
            "3.5.94"));
  }

  public static MdiIcon bank_off() {
    return MdiIcon.create(
        "mdi-bank-off",
        new MdiMeta(
            "bank-off",
            "F1656",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon bank_off_outline() {
    return MdiIcon.create(
        "mdi-bank-off-outline",
        new MdiMeta(
            "bank-off-outline",
            "F1657",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon bank_outline() {
    return MdiIcon.create(
        "mdi-bank-outline",
        new MdiMeta(
            "bank-outline",
            "F0E80",
            Arrays.asList("Banking"),
            Arrays.asList("museum-outline"),
            "Google",
            "3.7.94"));
  }

  public static MdiIcon bank_plus() {
    return MdiIcon.create(
        "mdi-bank-plus",
        new MdiMeta(
            "bank-plus",
            "F0DB1",
            Arrays.asList("Banking"),
            Arrays.asList("bank-add"),
            "Rosemary Stanley",
            "3.5.94"));
  }

  public static MdiIcon bank_remove() {
    return MdiIcon.create(
        "mdi-bank-remove",
        new MdiMeta(
            "bank-remove",
            "F0DB2",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Austin Andrews",
            "3.5.94"));
  }

  public static MdiIcon bank_transfer() {
    return MdiIcon.create(
        "mdi-bank-transfer",
        new MdiMeta(
            "bank-transfer",
            "F0A27",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "SarinManS",
            "2.6.95"));
  }

  public static MdiIcon bank_transfer_in() {
    return MdiIcon.create(
        "mdi-bank-transfer-in",
        new MdiMeta(
            "bank-transfer-in",
            "F0A28",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "SarinManS",
            "2.6.95"));
  }

  public static MdiIcon bank_transfer_out() {
    return MdiIcon.create(
        "mdi-bank-transfer-out",
        new MdiMeta(
            "bank-transfer-out",
            "F0A29",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "SarinManS",
            "2.6.95"));
  }

  public static MdiIcon barcode() {
    return MdiIcon.create(
        "mdi-barcode",
        new MdiMeta(
            "barcode", "F0071", Arrays.asList(), Arrays.asList(), "Austin Andrews", "1.5.54"));
  }

  public static MdiIcon barcode_off() {
    return MdiIcon.create(
        "mdi-barcode-off",
        new MdiMeta(
            "barcode-off",
            "F1236",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.6.95"));
  }

  public static MdiIcon barcode_scan() {
    return MdiIcon.create(
        "mdi-barcode-scan",
        new MdiMeta(
            "barcode-scan",
            "F0072",
            Arrays.asList(),
            Arrays.asList("barcode-scanner"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon barley() {
    return MdiIcon.create(
        "mdi-barley",
        new MdiMeta(
            "barley",
            "F0073",
            Arrays.asList("Agriculture", "Food / Drink"),
            Arrays.asList("grain", "wheat", "gluten"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon barley_off() {
    return MdiIcon.create(
        "mdi-barley-off",
        new MdiMeta(
            "barley-off",
            "F0B5D",
            Arrays.asList("Agriculture"),
            Arrays.asList("gluten-free", "grain-off", "wheat-off"),
            "Simran",
            "3.0.39"));
  }

  public static MdiIcon barn() {
    return MdiIcon.create(
        "mdi-barn",
        new MdiMeta(
            "barn",
            "F0B5E",
            Arrays.asList("Agriculture"),
            Arrays.asList("farm"),
            "SarinManS",
            "3.0.39"));
  }

  public static MdiIcon barrel() {
    return MdiIcon.create(
        "mdi-barrel",
        new MdiMeta(
            "barrel",
            "F0074",
            Arrays.asList(),
            Arrays.asList("oil-barrel", "energy", "fossil-fuel"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon barrel_outline() {
    return MdiIcon.create(
        "mdi-barrel-outline",
        new MdiMeta(
            "barrel-outline",
            "F1A28",
            Arrays.asList(),
            Arrays.asList("oil-barrel-outline", "fossil-fuel-outline", "energy-outline"),
            "Google",
            "6.7.96"));
  }

  public static MdiIcon baseball() {
    return MdiIcon.create(
        "mdi-baseball",
        new MdiMeta(
            "baseball", "F0852", Arrays.asList("Sport"), Arrays.asList(), "Nick", "2.1.99"));
  }

  public static MdiIcon baseball_bat() {
    return MdiIcon.create(
        "mdi-baseball-bat",
        new MdiMeta(
            "baseball-bat", "F0853", Arrays.asList("Sport"), Arrays.asList(), "Nick", "2.1.99"));
  }

  public static MdiIcon baseball_diamond() {
    return MdiIcon.create(
        "mdi-baseball-diamond",
        new MdiMeta(
            "baseball-diamond",
            "F15EC",
            Arrays.asList("Sport"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.6.55"));
  }

  public static MdiIcon baseball_diamond_outline() {
    return MdiIcon.create(
        "mdi-baseball-diamond-outline",
        new MdiMeta(
            "baseball-diamond-outline",
            "F15ED",
            Arrays.asList("Sport"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.6.55"));
  }

  public static MdiIcon baseball_outline() {
    return MdiIcon.create(
        "mdi-baseball-outline",
        new MdiMeta(
            "baseball-outline",
            "F1C5A",
            Arrays.asList("Sport"),
            Arrays.asList(),
            "Jeff Anders",
            "7.2.96"));
  }

  public static MdiIcon bash() {
    return MdiIcon.create(
        "mdi-bash",
        new MdiMeta(
            "bash",
            "F1183",
            Arrays.asList("Developer / Languages"),
            Arrays.asList(),
            "Michael Richins",
            "4.4.95"));
  }

  public static MdiIcon basket() {
    return MdiIcon.create(
        "mdi-basket",
        new MdiMeta(
            "basket",
            "F0076",
            Arrays.asList("Shopping"),
            Arrays.asList("shopping-basket", "skip"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon basket_check() {
    return MdiIcon.create(
        "mdi-basket-check",
        new MdiMeta(
            "basket-check",
            "F18E5",
            Arrays.asList("Shopping"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.3.95"));
  }

  public static MdiIcon basket_check_outline() {
    return MdiIcon.create(
        "mdi-basket-check-outline",
        new MdiMeta(
            "basket-check-outline",
            "F18E6",
            Arrays.asList("Shopping"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.3.95"));
  }

  public static MdiIcon basket_fill() {
    return MdiIcon.create(
        "mdi-basket-fill",
        new MdiMeta(
            "basket-fill",
            "F0077",
            Arrays.asList("Shopping"),
            Arrays.asList("skip-fill"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon basket_minus() {
    return MdiIcon.create(
        "mdi-basket-minus",
        new MdiMeta(
            "basket-minus",
            "F1523",
            Arrays.asList("Shopping"),
            Arrays.asList("shopping-basket-minus", "skip-minus"),
            "Michael Irigoyen",
            "5.4.55"));
  }

  public static MdiIcon basket_minus_outline() {
    return MdiIcon.create(
        "mdi-basket-minus-outline",
        new MdiMeta(
            "basket-minus-outline",
            "F1524",
            Arrays.asList("Shopping"),
            Arrays.asList("shopping-basket-minus-outline", "skip-minus-outline"),
            "Michael Irigoyen",
            "5.4.55"));
  }

  public static MdiIcon basket_off() {
    return MdiIcon.create(
        "mdi-basket-off",
        new MdiMeta(
            "basket-off",
            "F1525",
            Arrays.asList("Shopping"),
            Arrays.asList("shopping-basket-off", "skip-off"),
            "Michael Irigoyen",
            "5.4.55"));
  }

  public static MdiIcon basket_off_outline() {
    return MdiIcon.create(
        "mdi-basket-off-outline",
        new MdiMeta(
            "basket-off-outline",
            "F1526",
            Arrays.asList("Shopping"),
            Arrays.asList("shopping-basket-off-outline", "skip-off-outline"),
            "Michael Irigoyen",
            "5.4.55"));
  }

  public static MdiIcon basket_outline() {
    return MdiIcon.create(
        "mdi-basket-outline",
        new MdiMeta(
            "basket-outline",
            "F1181",
            Arrays.asList("Shopping"),
            Arrays.asList("shopping-basket-outline", "skip-outline"),
            "Google",
            "4.4.95"));
  }

  public static MdiIcon basket_plus() {
    return MdiIcon.create(
        "mdi-basket-plus",
        new MdiMeta(
            "basket-plus",
            "F1527",
            Arrays.asList("Shopping"),
            Arrays.asList("shopping-basket-plus", "skip-plus"),
            "Michael Irigoyen",
            "5.4.55"));
  }

  public static MdiIcon basket_plus_outline() {
    return MdiIcon.create(
        "mdi-basket-plus-outline",
        new MdiMeta(
            "basket-plus-outline",
            "F1528",
            Arrays.asList("Shopping"),
            Arrays.asList("shopping-basket-plus-outline", "skip-plus-outline"),
            "Michael Irigoyen",
            "5.4.55"));
  }

  public static MdiIcon basket_remove() {
    return MdiIcon.create(
        "mdi-basket-remove",
        new MdiMeta(
            "basket-remove",
            "F1529",
            Arrays.asList("Shopping"),
            Arrays.asList("shopping-basket-remove", "skip-remove"),
            "Michael Irigoyen",
            "5.4.55"));
  }

  public static MdiIcon basket_remove_outline() {
    return MdiIcon.create(
        "mdi-basket-remove-outline",
        new MdiMeta(
            "basket-remove-outline",
            "F152A",
            Arrays.asList("Shopping"),
            Arrays.asList("shopping-basket-remove-outline", "skip-remove-outline"),
            "Michael Irigoyen",
            "5.4.55"));
  }

  public static MdiIcon basket_unfill() {
    return MdiIcon.create(
        "mdi-basket-unfill",
        new MdiMeta(
            "basket-unfill",
            "F0078",
            Arrays.asList("Shopping"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon basketball() {
    return MdiIcon.create(
        "mdi-basketball",
        new MdiMeta(
            "basketball",
            "F0806",
            Arrays.asList("Sport"),
            Arrays.asList("youtube-sports"),
            "Google",
            "2.1.19"));
  }

  public static MdiIcon basketball_hoop() {
    return MdiIcon.create(
        "mdi-basketball-hoop",
        new MdiMeta(
            "basketball-hoop",
            "F0C3B",
            Arrays.asList("Sport"),
            Arrays.asList(),
            "Michael Richins",
            "3.2.89"));
  }

  public static MdiIcon basketball_hoop_outline() {
    return MdiIcon.create(
        "mdi-basketball-hoop-outline",
        new MdiMeta(
            "basketball-hoop-outline",
            "F0C3C",
            Arrays.asList("Sport"),
            Arrays.asList(),
            "Michael Richins",
            "3.2.89"));
  }

  public static MdiIcon bat() {
    return MdiIcon.create(
        "mdi-bat",
        new MdiMeta(
            "bat",
            "F0B5F",
            Arrays.asList("Holiday", "Animal"),
            Arrays.asList(),
            "Austin Andrews",
            "3.0.39"));
  }

  public static MdiIcon bathtub() {
    return MdiIcon.create(
        "mdi-bathtub",
        new MdiMeta(
            "bathtub",
            "F1818",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Google",
            "6.1.95"));
  }

  public static MdiIcon bathtub_outline() {
    return MdiIcon.create(
        "mdi-bathtub-outline",
        new MdiMeta(
            "bathtub-outline",
            "F1819",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Google",
            "6.1.95"));
  }

  public static MdiIcon battery() {
    return MdiIcon.create(
        "mdi-battery",
        new MdiMeta(
            "battery",
            "F0079",
            Arrays.asList("Battery", "Home Automation", "Automotive"),
            Arrays.asList("battery-full", "battery-std", "battery-100"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon battery_10() {
    return MdiIcon.create(
        "mdi-battery-10",
        new MdiMeta(
            "battery-10",
            "F007A",
            Arrays.asList("Battery", "Home Automation", "Automotive"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon battery_10_bluetooth() {
    return MdiIcon.create(
        "mdi-battery-10-bluetooth",
        new MdiMeta(
            "battery-10-bluetooth",
            "F093E",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.4.85"));
  }

  public static MdiIcon battery_20() {
    return MdiIcon.create(
        "mdi-battery-20",
        new MdiMeta(
            "battery-20",
            "F007B",
            Arrays.asList("Battery", "Home Automation", "Automotive"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon battery_20_bluetooth() {
    return MdiIcon.create(
        "mdi-battery-20-bluetooth",
        new MdiMeta(
            "battery-20-bluetooth",
            "F093F",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.4.85"));
  }

  public static MdiIcon battery_30() {
    return MdiIcon.create(
        "mdi-battery-30",
        new MdiMeta(
            "battery-30",
            "F007C",
            Arrays.asList("Battery", "Home Automation", "Automotive"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon battery_30_bluetooth() {
    return MdiIcon.create(
        "mdi-battery-30-bluetooth",
        new MdiMeta(
            "battery-30-bluetooth",
            "F0940",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.4.85"));
  }

  public static MdiIcon battery_40() {
    return MdiIcon.create(
        "mdi-battery-40",
        new MdiMeta(
            "battery-40",
            "F007D",
            Arrays.asList("Battery", "Home Automation", "Automotive"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon battery_40_bluetooth() {
    return MdiIcon.create(
        "mdi-battery-40-bluetooth",
        new MdiMeta(
            "battery-40-bluetooth",
            "F0941",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.4.85"));
  }

  public static MdiIcon battery_50() {
    return MdiIcon.create(
        "mdi-battery-50",
        new MdiMeta(
            "battery-50",
            "F007E",
            Arrays.asList("Battery", "Home Automation", "Automotive"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon battery_50_bluetooth() {
    return MdiIcon.create(
        "mdi-battery-50-bluetooth",
        new MdiMeta(
            "battery-50-bluetooth",
            "F0942",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.4.85"));
  }

  public static MdiIcon battery_60() {
    return MdiIcon.create(
        "mdi-battery-60",
        new MdiMeta(
            "battery-60",
            "F007F",
            Arrays.asList("Battery", "Home Automation", "Automotive"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon battery_60_bluetooth() {
    return MdiIcon.create(
        "mdi-battery-60-bluetooth",
        new MdiMeta(
            "battery-60-bluetooth",
            "F0943",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.4.85"));
  }

  public static MdiIcon battery_70() {
    return MdiIcon.create(
        "mdi-battery-70",
        new MdiMeta(
            "battery-70",
            "F0080",
            Arrays.asList("Battery", "Home Automation", "Automotive"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon battery_70_bluetooth() {
    return MdiIcon.create(
        "mdi-battery-70-bluetooth",
        new MdiMeta(
            "battery-70-bluetooth",
            "F0944",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.4.85"));
  }

  public static MdiIcon battery_80() {
    return MdiIcon.create(
        "mdi-battery-80",
        new MdiMeta(
            "battery-80",
            "F0081",
            Arrays.asList("Battery", "Home Automation", "Automotive"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon battery_80_bluetooth() {
    return MdiIcon.create(
        "mdi-battery-80-bluetooth",
        new MdiMeta(
            "battery-80-bluetooth",
            "F0945",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.4.85"));
  }

  public static MdiIcon battery_90() {
    return MdiIcon.create(
        "mdi-battery-90",
        new MdiMeta(
            "battery-90",
            "F0082",
            Arrays.asList("Battery", "Home Automation", "Automotive"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon battery_90_bluetooth() {
    return MdiIcon.create(
        "mdi-battery-90-bluetooth",
        new MdiMeta(
            "battery-90-bluetooth",
            "F0946",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.4.85"));
  }

  public static MdiIcon battery_alert() {
    return MdiIcon.create(
        "mdi-battery-alert",
        new MdiMeta(
            "battery-alert",
            "F0083",
            Arrays.asList("Battery", "Home Automation", "Alert / Error"),
            Arrays.asList("battery-warning"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon battery_alert_bluetooth() {
    return MdiIcon.create(
        "mdi-battery-alert-bluetooth",
        new MdiMeta(
            "battery-alert-bluetooth",
            "F0947",
            Arrays.asList("Alert / Error", "Battery"),
            Arrays.asList("battery-warning-bluetooth"),
            "GreenTurtwig",
            "2.4.85"));
  }

  public static MdiIcon battery_alert_variant() {
    return MdiIcon.create(
        "mdi-battery-alert-variant",
        new MdiMeta(
            "battery-alert-variant",
            "F10CC",
            Arrays.asList("Battery", "Alert / Error"),
            Arrays.asList(),
            "Austin Andrews",
            "4.3.95"));
  }

  public static MdiIcon battery_alert_variant_outline() {
    return MdiIcon.create(
        "mdi-battery-alert-variant-outline",
        new MdiMeta(
            "battery-alert-variant-outline",
            "F10CD",
            Arrays.asList("Battery", "Alert / Error"),
            Arrays.asList(),
            "Austin Andrews",
            "4.3.95"));
  }

  public static MdiIcon battery_arrow_down() {
    return MdiIcon.create(
        "mdi-battery-arrow-down",
        new MdiMeta(
            "battery-arrow-down",
            "F17DE",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "François Risoud",
            "6.1.95"));
  }

  public static MdiIcon battery_arrow_down_outline() {
    return MdiIcon.create(
        "mdi-battery-arrow-down-outline",
        new MdiMeta(
            "battery-arrow-down-outline",
            "F17DF",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "François Risoud",
            "6.1.95"));
  }

  public static MdiIcon battery_arrow_up() {
    return MdiIcon.create(
        "mdi-battery-arrow-up",
        new MdiMeta(
            "battery-arrow-up",
            "F17E0",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "François Risoud",
            "6.1.95"));
  }

  public static MdiIcon battery_arrow_up_outline() {
    return MdiIcon.create(
        "mdi-battery-arrow-up-outline",
        new MdiMeta(
            "battery-arrow-up-outline",
            "F17E1",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "François Risoud",
            "6.1.95"));
  }

  public static MdiIcon battery_bluetooth() {
    return MdiIcon.create(
        "mdi-battery-bluetooth",
        new MdiMeta(
            "battery-bluetooth",
            "F0948",
            Arrays.asList("Battery"),
            Arrays.asList("battery-bluetooth-100", "battery-bluetooth-full"),
            "GreenTurtwig",
            "2.4.85"));
  }

  public static MdiIcon battery_bluetooth_variant() {
    return MdiIcon.create(
        "mdi-battery-bluetooth-variant",
        new MdiMeta(
            "battery-bluetooth-variant",
            "F0949",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.4.85"));
  }

  public static MdiIcon battery_charging() {
    return MdiIcon.create(
        "mdi-battery-charging",
        new MdiMeta(
            "battery-charging",
            "F0084",
            Arrays.asList("Battery", "Home Automation", "Automotive"),
            Arrays.asList("battery-charging-full"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon battery_charging_10() {
    return MdiIcon.create(
        "mdi-battery-charging-10",
        new MdiMeta(
            "battery-charging-10",
            "F089C",
            Arrays.asList("Automotive", "Battery"),
            Arrays.asList(),
            "Google",
            "2.2.43"));
  }

  public static MdiIcon battery_charging_100() {
    return MdiIcon.create(
        "mdi-battery-charging-100",
        new MdiMeta(
            "battery-charging-100",
            "F0085",
            Arrays.asList("Battery", "Home Automation", "Automotive"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon battery_charging_20() {
    return MdiIcon.create(
        "mdi-battery-charging-20",
        new MdiMeta(
            "battery-charging-20",
            "F0086",
            Arrays.asList("Battery", "Home Automation", "Automotive"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon battery_charging_30() {
    return MdiIcon.create(
        "mdi-battery-charging-30",
        new MdiMeta(
            "battery-charging-30",
            "F0087",
            Arrays.asList("Battery", "Home Automation", "Automotive"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon battery_charging_40() {
    return MdiIcon.create(
        "mdi-battery-charging-40",
        new MdiMeta(
            "battery-charging-40",
            "F0088",
            Arrays.asList("Battery", "Home Automation", "Automotive"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon battery_charging_50() {
    return MdiIcon.create(
        "mdi-battery-charging-50",
        new MdiMeta(
            "battery-charging-50",
            "F089D",
            Arrays.asList("Automotive", "Battery"),
            Arrays.asList(),
            "Google",
            "2.2.43"));
  }

  public static MdiIcon battery_charging_60() {
    return MdiIcon.create(
        "mdi-battery-charging-60",
        new MdiMeta(
            "battery-charging-60",
            "F0089",
            Arrays.asList("Battery", "Home Automation", "Automotive"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon battery_charging_70() {
    return MdiIcon.create(
        "mdi-battery-charging-70",
        new MdiMeta(
            "battery-charging-70",
            "F089E",
            Arrays.asList("Automotive", "Battery"),
            Arrays.asList(),
            "Google",
            "2.2.43"));
  }

  public static MdiIcon battery_charging_80() {
    return MdiIcon.create(
        "mdi-battery-charging-80",
        new MdiMeta(
            "battery-charging-80",
            "F008A",
            Arrays.asList("Battery", "Home Automation", "Automotive"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon battery_charging_90() {
    return MdiIcon.create(
        "mdi-battery-charging-90",
        new MdiMeta(
            "battery-charging-90",
            "F008B",
            Arrays.asList("Battery", "Home Automation", "Automotive"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon battery_charging_high() {
    return MdiIcon.create(
        "mdi-battery-charging-high",
        new MdiMeta(
            "battery-charging-high",
            "F12A6",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.7.95"));
  }

  public static MdiIcon battery_charging_low() {
    return MdiIcon.create(
        "mdi-battery-charging-low",
        new MdiMeta(
            "battery-charging-low",
            "F12A4",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.7.95"));
  }

  public static MdiIcon battery_charging_medium() {
    return MdiIcon.create(
        "mdi-battery-charging-medium",
        new MdiMeta(
            "battery-charging-medium",
            "F12A5",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.7.95"));
  }

  public static MdiIcon battery_charging_outline() {
    return MdiIcon.create(
        "mdi-battery-charging-outline",
        new MdiMeta(
            "battery-charging-outline",
            "F089F",
            Arrays.asList("Automotive", "Battery"),
            Arrays.asList(),
            "Google",
            "2.2.43"));
  }

  public static MdiIcon battery_charging_wireless() {
    return MdiIcon.create(
        "mdi-battery-charging-wireless",
        new MdiMeta(
            "battery-charging-wireless",
            "F0807",
            Arrays.asList("Battery", "Home Automation"),
            Arrays.asList("battery-charging-wireless-full", "battery-charging-wireless-100"),
            "Michael Richins",
            "2.1.19"));
  }

  public static MdiIcon battery_charging_wireless_10() {
    return MdiIcon.create(
        "mdi-battery-charging-wireless-10",
        new MdiMeta(
            "battery-charging-wireless-10",
            "F0808",
            Arrays.asList("Battery", "Home Automation"),
            Arrays.asList(),
            "Michael Richins",
            "2.1.19"));
  }

  public static MdiIcon battery_charging_wireless_20() {
    return MdiIcon.create(
        "mdi-battery-charging-wireless-20",
        new MdiMeta(
            "battery-charging-wireless-20",
            "F0809",
            Arrays.asList("Battery", "Home Automation"),
            Arrays.asList(),
            "Michael Richins",
            "2.1.19"));
  }

  public static MdiIcon battery_charging_wireless_30() {
    return MdiIcon.create(
        "mdi-battery-charging-wireless-30",
        new MdiMeta(
            "battery-charging-wireless-30",
            "F080A",
            Arrays.asList("Battery", "Home Automation"),
            Arrays.asList(),
            "Michael Richins",
            "2.1.19"));
  }

  public static MdiIcon battery_charging_wireless_40() {
    return MdiIcon.create(
        "mdi-battery-charging-wireless-40",
        new MdiMeta(
            "battery-charging-wireless-40",
            "F080B",
            Arrays.asList("Battery", "Home Automation"),
            Arrays.asList(),
            "Michael Richins",
            "2.1.19"));
  }

  public static MdiIcon battery_charging_wireless_50() {
    return MdiIcon.create(
        "mdi-battery-charging-wireless-50",
        new MdiMeta(
            "battery-charging-wireless-50",
            "F080C",
            Arrays.asList("Battery", "Home Automation"),
            Arrays.asList(),
            "Michael Richins",
            "2.1.19"));
  }

  public static MdiIcon battery_charging_wireless_60() {
    return MdiIcon.create(
        "mdi-battery-charging-wireless-60",
        new MdiMeta(
            "battery-charging-wireless-60",
            "F080D",
            Arrays.asList("Battery", "Home Automation"),
            Arrays.asList(),
            "Michael Richins",
            "2.1.19"));
  }

  public static MdiIcon battery_charging_wireless_70() {
    return MdiIcon.create(
        "mdi-battery-charging-wireless-70",
        new MdiMeta(
            "battery-charging-wireless-70",
            "F080E",
            Arrays.asList("Battery", "Home Automation"),
            Arrays.asList(),
            "Michael Richins",
            "2.1.19"));
  }

  public static MdiIcon battery_charging_wireless_80() {
    return MdiIcon.create(
        "mdi-battery-charging-wireless-80",
        new MdiMeta(
            "battery-charging-wireless-80",
            "F080F",
            Arrays.asList("Battery", "Home Automation"),
            Arrays.asList(),
            "Michael Richins",
            "2.1.19"));
  }

  public static MdiIcon battery_charging_wireless_90() {
    return MdiIcon.create(
        "mdi-battery-charging-wireless-90",
        new MdiMeta(
            "battery-charging-wireless-90",
            "F0810",
            Arrays.asList("Battery", "Home Automation"),
            Arrays.asList(),
            "Michael Richins",
            "2.1.19"));
  }

  public static MdiIcon battery_charging_wireless_alert() {
    return MdiIcon.create(
        "mdi-battery-charging-wireless-alert",
        new MdiMeta(
            "battery-charging-wireless-alert",
            "F0811",
            Arrays.asList("Battery", "Home Automation", "Alert / Error"),
            Arrays.asList("battery-charging-wireless-warning"),
            "Michael Richins",
            "2.1.19"));
  }

  public static MdiIcon battery_charging_wireless_outline() {
    return MdiIcon.create(
        "mdi-battery-charging-wireless-outline",
        new MdiMeta(
            "battery-charging-wireless-outline",
            "F0812",
            Arrays.asList("Battery", "Home Automation"),
            Arrays.asList("battery-charging-wireless-empty", "battery-charging-wireless-0"),
            "Michael Richins",
            "2.1.19"));
  }

  public static MdiIcon battery_check() {
    return MdiIcon.create(
        "mdi-battery-check",
        new MdiMeta(
            "battery-check",
            "F17E2",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "François Risoud",
            "6.1.95"));
  }

  public static MdiIcon battery_check_outline() {
    return MdiIcon.create(
        "mdi-battery-check-outline",
        new MdiMeta(
            "battery-check-outline",
            "F17E3",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "François Risoud",
            "6.1.95"));
  }

  public static MdiIcon battery_clock() {
    return MdiIcon.create(
        "mdi-battery-clock",
        new MdiMeta(
            "battery-clock",
            "F19E5",
            Arrays.asList("Battery", "Home Automation", "Date / Time"),
            Arrays.asList("battery-full-clock", "battery-100-clock"),
            "Colton Wiscombe",
            "6.6.96"));
  }

  public static MdiIcon battery_clock_outline() {
    return MdiIcon.create(
        "mdi-battery-clock-outline",
        new MdiMeta(
            "battery-clock-outline",
            "F19E6",
            Arrays.asList("Battery", "Home Automation", "Date / Time"),
            Arrays.asList("batter-0-clock", "battery-empty-clock"),
            "Colton Wiscombe",
            "6.6.96"));
  }

  public static MdiIcon battery_heart() {
    return MdiIcon.create(
        "mdi-battery-heart",
        new MdiMeta(
            "battery-heart",
            "F120F",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "Michael Richins",
            "4.6.95"));
  }

  public static MdiIcon battery_heart_outline() {
    return MdiIcon.create(
        "mdi-battery-heart-outline",
        new MdiMeta(
            "battery-heart-outline",
            "F1210",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "Michael Richins",
            "4.6.95"));
  }

  public static MdiIcon battery_heart_variant() {
    return MdiIcon.create(
        "mdi-battery-heart-variant",
        new MdiMeta(
            "battery-heart-variant",
            "F1211",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "Michael Richins",
            "4.6.95"));
  }

  public static MdiIcon battery_high() {
    return MdiIcon.create(
        "mdi-battery-high",
        new MdiMeta(
            "battery-high",
            "F12A3",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "Austin Andrews",
            "4.7.95"));
  }

  public static MdiIcon battery_lock() {
    return MdiIcon.create(
        "mdi-battery-lock",
        new MdiMeta(
            "battery-lock",
            "F179C",
            Arrays.asList("Battery", "Lock"),
            Arrays.asList(),
            "François Risoud",
            "6.1.95"));
  }

  public static MdiIcon battery_lock_open() {
    return MdiIcon.create(
        "mdi-battery-lock-open",
        new MdiMeta(
            "battery-lock-open",
            "F179D",
            Arrays.asList("Battery", "Lock"),
            Arrays.asList(),
            "François Risoud",
            "6.1.95"));
  }

  public static MdiIcon battery_low() {
    return MdiIcon.create(
        "mdi-battery-low",
        new MdiMeta(
            "battery-low",
            "F12A1",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "Austin Andrews",
            "4.7.95"));
  }

  public static MdiIcon battery_medium() {
    return MdiIcon.create(
        "mdi-battery-medium",
        new MdiMeta(
            "battery-medium",
            "F12A2",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "Austin Andrews",
            "4.7.95"));
  }

  public static MdiIcon battery_minus() {
    return MdiIcon.create(
        "mdi-battery-minus",
        new MdiMeta(
            "battery-minus",
            "F17E4",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "François Risoud",
            "6.1.95"));
  }

  public static MdiIcon battery_minus_outline() {
    return MdiIcon.create(
        "mdi-battery-minus-outline",
        new MdiMeta(
            "battery-minus-outline",
            "F17E5",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "François Risoud",
            "6.1.95"));
  }

  public static MdiIcon battery_minus_variant() {
    return MdiIcon.create(
        "mdi-battery-minus-variant",
        new MdiMeta(
            "battery-minus-variant",
            "F008C",
            Arrays.asList("Battery", "Home Automation"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon battery_negative() {
    return MdiIcon.create(
        "mdi-battery-negative",
        new MdiMeta(
            "battery-negative",
            "F008D",
            Arrays.asList("Battery", "Home Automation"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon battery_off() {
    return MdiIcon.create(
        "mdi-battery-off",
        new MdiMeta(
            "battery-off",
            "F125D",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "Michael Richins",
            "4.7.95"));
  }

  public static MdiIcon battery_off_outline() {
    return MdiIcon.create(
        "mdi-battery-off-outline",
        new MdiMeta(
            "battery-off-outline",
            "F125E",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "Michael Richins",
            "4.7.95"));
  }

  public static MdiIcon battery_outline() {
    return MdiIcon.create(
        "mdi-battery-outline",
        new MdiMeta(
            "battery-outline",
            "F008E",
            Arrays.asList("Battery", "Home Automation", "Automotive"),
            Arrays.asList("battery-0", "battery-empty"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon battery_plus() {
    return MdiIcon.create(
        "mdi-battery-plus",
        new MdiMeta(
            "battery-plus",
            "F17E6",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "François Risoud",
            "6.1.95"));
  }

  public static MdiIcon battery_plus_outline() {
    return MdiIcon.create(
        "mdi-battery-plus-outline",
        new MdiMeta(
            "battery-plus-outline",
            "F17E7",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "François Risoud",
            "6.1.95"));
  }

  public static MdiIcon battery_plus_variant() {
    return MdiIcon.create(
        "mdi-battery-plus-variant",
        new MdiMeta(
            "battery-plus-variant",
            "F008F",
            Arrays.asList("Battery", "Home Automation"),
            Arrays.asList("battery-saver", "battery-add"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon battery_positive() {
    return MdiIcon.create(
        "mdi-battery-positive",
        new MdiMeta(
            "battery-positive",
            "F0090",
            Arrays.asList("Battery", "Home Automation"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon battery_remove() {
    return MdiIcon.create(
        "mdi-battery-remove",
        new MdiMeta(
            "battery-remove",
            "F17E8",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "François Risoud",
            "6.1.95"));
  }

  public static MdiIcon battery_remove_outline() {
    return MdiIcon.create(
        "mdi-battery-remove-outline",
        new MdiMeta(
            "battery-remove-outline",
            "F17E9",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "François Risoud",
            "6.1.95"));
  }

  public static MdiIcon battery_sync() {
    return MdiIcon.create(
        "mdi-battery-sync",
        new MdiMeta(
            "battery-sync",
            "F1834",
            Arrays.asList("Battery"),
            Arrays.asList("battery-saver", "battery-recycle", "battery-eco"),
            "Michael Irigoyen",
            "6.2.95"));
  }

  public static MdiIcon battery_sync_outline() {
    return MdiIcon.create(
        "mdi-battery-sync-outline",
        new MdiMeta(
            "battery-sync-outline",
            "F1835",
            Arrays.asList("Battery"),
            Arrays.asList(
                "battery-saver-outline", "battery-eco-outline", "battery-recycle-outline"),
            "Michael Irigoyen",
            "6.2.95"));
  }

  public static MdiIcon battery_unknown() {
    return MdiIcon.create(
        "mdi-battery-unknown",
        new MdiMeta(
            "battery-unknown",
            "F0091",
            Arrays.asList("Battery", "Home Automation"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon battery_unknown_bluetooth() {
    return MdiIcon.create(
        "mdi-battery-unknown-bluetooth",
        new MdiMeta(
            "battery-unknown-bluetooth",
            "F094A",
            Arrays.asList("Battery"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.4.85"));
  }

  public static MdiIcon beach() {
    return MdiIcon.create(
        "mdi-beach",
        new MdiMeta(
            "beach",
            "F0092",
            Arrays.asList("Places"),
            Arrays.asList("parasol"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon beaker() {
    return MdiIcon.create(
        "mdi-beaker",
        new MdiMeta(
            "beaker",
            "F0CEA",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.3.92"));
  }

  public static MdiIcon beaker_alert() {
    return MdiIcon.create(
        "mdi-beaker-alert",
        new MdiMeta(
            "beaker-alert",
            "F1229",
            Arrays.asList("Alert / Error", "Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon beaker_alert_outline() {
    return MdiIcon.create(
        "mdi-beaker-alert-outline",
        new MdiMeta(
            "beaker-alert-outline",
            "F122A",
            Arrays.asList("Alert / Error", "Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon beaker_check() {
    return MdiIcon.create(
        "mdi-beaker-check",
        new MdiMeta(
            "beaker-check",
            "F122B",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon beaker_check_outline() {
    return MdiIcon.create(
        "mdi-beaker-check-outline",
        new MdiMeta(
            "beaker-check-outline",
            "F122C",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon beaker_minus() {
    return MdiIcon.create(
        "mdi-beaker-minus",
        new MdiMeta(
            "beaker-minus",
            "F122D",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon beaker_minus_outline() {
    return MdiIcon.create(
        "mdi-beaker-minus-outline",
        new MdiMeta(
            "beaker-minus-outline",
            "F122E",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon beaker_outline() {
    return MdiIcon.create(
        "mdi-beaker-outline",
        new MdiMeta(
            "beaker-outline",
            "F0690",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Simran",
            "1.7.12"));
  }

  public static MdiIcon beaker_plus() {
    return MdiIcon.create(
        "mdi-beaker-plus",
        new MdiMeta(
            "beaker-plus",
            "F122F",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon beaker_plus_outline() {
    return MdiIcon.create(
        "mdi-beaker-plus-outline",
        new MdiMeta(
            "beaker-plus-outline",
            "F1230",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon beaker_question() {
    return MdiIcon.create(
        "mdi-beaker-question",
        new MdiMeta(
            "beaker-question",
            "F1231",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon beaker_question_outline() {
    return MdiIcon.create(
        "mdi-beaker-question-outline",
        new MdiMeta(
            "beaker-question-outline",
            "F1232",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon beaker_remove() {
    return MdiIcon.create(
        "mdi-beaker-remove",
        new MdiMeta(
            "beaker-remove",
            "F1233",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon beaker_remove_outline() {
    return MdiIcon.create(
        "mdi-beaker-remove-outline",
        new MdiMeta(
            "beaker-remove-outline",
            "F1234",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon bed() {
    return MdiIcon.create(
        "mdi-bed",
        new MdiMeta(
            "bed",
            "F02E3",
            Arrays.asList("Home Automation", "Holiday"),
            Arrays.asList("hotel", "guest-room"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon bed_clock() {
    return MdiIcon.create(
        "mdi-bed-clock",
        new MdiMeta(
            "bed-clock",
            "F1B94",
            Arrays.asList("Date / Time"),
            Arrays.asList("bed-schedule", "bed-time", "sleep-schedule", "sleep-time"),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon bed_double() {
    return MdiIcon.create(
        "mdi-bed-double",
        new MdiMeta(
            "bed-double",
            "F0FD4",
            Arrays.asList("Home Automation", "Holiday"),
            Arrays.asList("bedroom"),
            "Michael Richins",
            "4.2.95"));
  }

  public static MdiIcon bed_double_outline() {
    return MdiIcon.create(
        "mdi-bed-double-outline",
        new MdiMeta(
            "bed-double-outline",
            "F0FD3",
            Arrays.asList("Home Automation", "Holiday"),
            Arrays.asList("bedroom-outline"),
            "Google",
            "4.2.95"));
  }

  public static MdiIcon bed_empty() {
    return MdiIcon.create(
        "mdi-bed-empty",
        new MdiMeta(
            "bed-empty",
            "F08A0",
            Arrays.asList("Home Automation", "Holiday"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.2.43"));
  }

  public static MdiIcon bed_king() {
    return MdiIcon.create(
        "mdi-bed-king",
        new MdiMeta(
            "bed-king",
            "F0FD2",
            Arrays.asList("Home Automation", "Holiday"),
            Arrays.asList("bedroom"),
            "Google",
            "4.2.95"));
  }

  public static MdiIcon bed_king_outline() {
    return MdiIcon.create(
        "mdi-bed-king-outline",
        new MdiMeta(
            "bed-king-outline",
            "F0FD1",
            Arrays.asList("Home Automation", "Holiday"),
            Arrays.asList("bedroom-outline"),
            "Michael Richins",
            "4.2.95"));
  }

  public static MdiIcon bed_outline() {
    return MdiIcon.create(
        "mdi-bed-outline",
        new MdiMeta(
            "bed-outline",
            "F0099",
            Arrays.asList("Home Automation", "Holiday"),
            Arrays.asList("hotel-outline", "guest-room-outline"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon bed_queen() {
    return MdiIcon.create(
        "mdi-bed-queen",
        new MdiMeta(
            "bed-queen",
            "F0FD0",
            Arrays.asList("Home Automation", "Holiday"),
            Arrays.asList("bedroom"),
            "Michael Richins",
            "4.2.95"));
  }

  public static MdiIcon bed_queen_outline() {
    return MdiIcon.create(
        "mdi-bed-queen-outline",
        new MdiMeta(
            "bed-queen-outline",
            "F0FDB",
            Arrays.asList("Home Automation", "Holiday"),
            Arrays.asList("bedroom-outline"),
            "Michael Richins",
            "4.2.95"));
  }

  public static MdiIcon bed_single() {
    return MdiIcon.create(
        "mdi-bed-single",
        new MdiMeta(
            "bed-single",
            "F106D",
            Arrays.asList("Home Automation", "Holiday"),
            Arrays.asList("bedroom"),
            "Simran",
            "4.2.95"));
  }

  public static MdiIcon bed_single_outline() {
    return MdiIcon.create(
        "mdi-bed-single-outline",
        new MdiMeta(
            "bed-single-outline",
            "F106E",
            Arrays.asList("Home Automation", "Holiday"),
            Arrays.asList("bedroom-outline"),
            "Simran",
            "4.2.95"));
  }

  public static MdiIcon bee() {
    return MdiIcon.create(
        "mdi-bee",
        new MdiMeta(
            "bee",
            "F0FA1",
            Arrays.asList("Nature", "Agriculture", "Animal"),
            Arrays.asList("fly", "insect"),
            "Google",
            "4.0.96"));
  }

  public static MdiIcon bee_flower() {
    return MdiIcon.create(
        "mdi-bee-flower",
        new MdiMeta(
            "bee-flower",
            "F0FA2",
            Arrays.asList("Nature", "Agriculture"),
            Arrays.asList("fly-flower", "nature"),
            "Google",
            "4.0.96"));
  }

  public static MdiIcon beehive_off_outline() {
    return MdiIcon.create(
        "mdi-beehive-off-outline",
        new MdiMeta(
            "beehive-off-outline",
            "F13ED",
            Arrays.asList("Nature", "Agriculture"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.1.45"));
  }

  public static MdiIcon beehive_outline() {
    return MdiIcon.create(
        "mdi-beehive-outline",
        new MdiMeta(
            "beehive-outline",
            "F10CE",
            Arrays.asList("Nature", "Agriculture"),
            Arrays.asList("honey-outline"),
            "Michael Irigoyen",
            "4.3.95"));
  }

  public static MdiIcon beekeeper() {
    return MdiIcon.create(
        "mdi-beekeeper",
        new MdiMeta(
            "beekeeper",
            "F14E2",
            Arrays.asList("Nature", "Agriculture"),
            Arrays.asList("apiarists", "apiculturists", "honey-farmer"),
            "guenth39",
            "5.4.55"));
  }

  public static MdiIcon beer() {
    return MdiIcon.create(
        "mdi-beer",
        new MdiMeta(
            "beer",
            "F0098",
            Arrays.asList("Food / Drink"),
            Arrays.asList("pint", "pub", "bar", "drink", "cup-full"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon beer_outline() {
    return MdiIcon.create(
        "mdi-beer-outline",
        new MdiMeta(
            "beer-outline",
            "F130C",
            Arrays.asList("Food / Drink"),
            Arrays.asList(
                "drink-outline", "cup-full-outline", "pint-outline", "pub-outline", "bar-outline"),
            "Simran",
            "4.8.95"));
  }

  public static MdiIcon bell() {
    return MdiIcon.create(
        "mdi-bell",
        new MdiMeta(
            "bell",
            "F009A",
            Arrays.asList("Notification", "Home Automation", "Music"),
            Arrays.asList("notifications"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon bell_alert() {
    return MdiIcon.create(
        "mdi-bell-alert",
        new MdiMeta(
            "bell-alert",
            "F0D59",
            Arrays.asList("Alert / Error", "Notification"),
            Arrays.asList("bell-warning"),
            "Simran",
            "3.4.93"));
  }

  public static MdiIcon bell_alert_outline() {
    return MdiIcon.create(
        "mdi-bell-alert-outline",
        new MdiMeta(
            "bell-alert-outline",
            "F0E81",
            Arrays.asList("Alert / Error", "Notification"),
            Arrays.asList(),
            "Simran",
            "3.7.94"));
  }

  public static MdiIcon bell_badge() {
    return MdiIcon.create(
        "mdi-bell-badge",
        new MdiMeta(
            "bell-badge",
            "F116B",
            Arrays.asList("Notification"),
            Arrays.asList("bell-notification"),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon bell_badge_outline() {
    return MdiIcon.create(
        "mdi-bell-badge-outline",
        new MdiMeta(
            "bell-badge-outline",
            "F0178",
            Arrays.asList("Notification"),
            Arrays.asList("bell-notification-outline"),
            "Michael Irigoyen",
            "1.5.54"));
  }

  public static MdiIcon bell_cancel() {
    return MdiIcon.create(
        "mdi-bell-cancel",
        new MdiMeta(
            "bell-cancel",
            "F13E7",
            Arrays.asList("Notification"),
            Arrays.asList(),
            "Simran",
            "5.1.45"));
  }

  public static MdiIcon bell_cancel_outline() {
    return MdiIcon.create(
        "mdi-bell-cancel-outline",
        new MdiMeta(
            "bell-cancel-outline",
            "F13E8",
            Arrays.asList("Notification"),
            Arrays.asList(),
            "Simran",
            "5.1.45"));
  }

  public static MdiIcon bell_check() {
    return MdiIcon.create(
        "mdi-bell-check",
        new MdiMeta(
            "bell-check",
            "F11E5",
            Arrays.asList("Notification"),
            Arrays.asList(),
            "GreenTurtwig",
            "4.5.95"));
  }

  public static MdiIcon bell_check_outline() {
    return MdiIcon.create(
        "mdi-bell-check-outline",
        new MdiMeta(
            "bell-check-outline",
            "F11E6",
            Arrays.asList("Notification"),
            Arrays.asList(),
            "GreenTurtwig",
            "4.5.95"));
  }

  public static MdiIcon bell_circle() {
    return MdiIcon.create(
        "mdi-bell-circle",
        new MdiMeta(
            "bell-circle",
            "F0D5A",
            Arrays.asList("Notification"),
            Arrays.asList(),
            "Google",
            "3.4.93"));
  }

  public static MdiIcon bell_circle_outline() {
    return MdiIcon.create(
        "mdi-bell-circle-outline",
        new MdiMeta(
            "bell-circle-outline",
            "F0D5B",
            Arrays.asList("Notification"),
            Arrays.asList(),
            "Google",
            "3.4.93"));
  }

  public static MdiIcon bell_cog() {
    return MdiIcon.create(
        "mdi-bell-cog",
        new MdiMeta(
            "bell-cog",
            "F1A29",
            Arrays.asList("Notification", "Settings"),
            Arrays.asList("bell-settings", "notification-settings"),
            "Colton Wiscombe",
            "6.7.96"));
  }

  public static MdiIcon bell_cog_outline() {
    return MdiIcon.create(
        "mdi-bell-cog-outline",
        new MdiMeta(
            "bell-cog-outline",
            "F1A2A",
            Arrays.asList("Notification", "Settings"),
            Arrays.asList("bell-settings-outline", "notification-settings-outline"),
            "Colton Wiscombe",
            "6.7.96"));
  }

  public static MdiIcon bell_minus() {
    return MdiIcon.create(
        "mdi-bell-minus",
        new MdiMeta(
            "bell-minus",
            "F13E9",
            Arrays.asList("Notification"),
            Arrays.asList(),
            "Simran",
            "5.1.45"));
  }

  public static MdiIcon bell_minus_outline() {
    return MdiIcon.create(
        "mdi-bell-minus-outline",
        new MdiMeta(
            "bell-minus-outline",
            "F13EA",
            Arrays.asList("Notification"),
            Arrays.asList(),
            "Simran",
            "5.1.45"));
  }

  public static MdiIcon bell_off() {
    return MdiIcon.create(
        "mdi-bell-off",
        new MdiMeta(
            "bell-off",
            "F009B",
            Arrays.asList("Notification"),
            Arrays.asList("notifications-off"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon bell_off_outline() {
    return MdiIcon.create(
        "mdi-bell-off-outline",
        new MdiMeta(
            "bell-off-outline",
            "F0A91",
            Arrays.asList("Notification"),
            Arrays.asList(),
            "Google",
            "2.7.94"));
  }

  public static MdiIcon bell_outline() {
    return MdiIcon.create(
        "mdi-bell-outline",
        new MdiMeta(
            "bell-outline",
            "F009C",
            Arrays.asList("Notification", "Music", "Home Automation"),
            Arrays.asList("notifications-none"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon bell_plus() {
    return MdiIcon.create(
        "mdi-bell-plus",
        new MdiMeta(
            "bell-plus",
            "F009D",
            Arrays.asList("Notification"),
            Arrays.asList("add-alert", "bell-add"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon bell_plus_outline() {
    return MdiIcon.create(
        "mdi-bell-plus-outline",
        new MdiMeta(
            "bell-plus-outline",
            "F0A92",
            Arrays.asList("Notification"),
            Arrays.asList("bell-add-outline", "add-alert-outline"),
            "Simran",
            "2.7.94"));
  }

  public static MdiIcon bell_remove() {
    return MdiIcon.create(
        "mdi-bell-remove",
        new MdiMeta(
            "bell-remove",
            "F13EB",
            Arrays.asList("Notification"),
            Arrays.asList(),
            "Simran",
            "5.1.45"));
  }

  public static MdiIcon bell_remove_outline() {
    return MdiIcon.create(
        "mdi-bell-remove-outline",
        new MdiMeta(
            "bell-remove-outline",
            "F13EC",
            Arrays.asList("Notification"),
            Arrays.asList(),
            "Simran",
            "5.1.45"));
  }

  public static MdiIcon bell_ring() {
    return MdiIcon.create(
        "mdi-bell-ring",
        new MdiMeta(
            "bell-ring",
            "F009E",
            Arrays.asList("Notification"),
            Arrays.asList("notifications-active"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon bell_ring_outline() {
    return MdiIcon.create(
        "mdi-bell-ring-outline",
        new MdiMeta(
            "bell-ring-outline",
            "F009F",
            Arrays.asList("Notification"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon bell_sleep() {
    return MdiIcon.create(
        "mdi-bell-sleep",
        new MdiMeta(
            "bell-sleep",
            "F00A0",
            Arrays.asList("Notification"),
            Arrays.asList("notifications-paused"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon bell_sleep_outline() {
    return MdiIcon.create(
        "mdi-bell-sleep-outline",
        new MdiMeta(
            "bell-sleep-outline",
            "F0A93",
            Arrays.asList("Notification"),
            Arrays.asList(),
            "Google",
            "2.7.94"));
  }

  public static MdiIcon bench() {
    return MdiIcon.create(
        "mdi-bench",
        new MdiMeta("bench", "F1C21", Arrays.asList(), Arrays.asList(), "Jeff Anders", "7.2.96"));
  }

  public static MdiIcon bench_back() {
    return MdiIcon.create(
        "mdi-bench-back",
        new MdiMeta(
            "bench-back", "F1C22", Arrays.asList(), Arrays.asList(), "Jeff Anders", "7.2.96"));
  }

  public static MdiIcon beta() {
    return MdiIcon.create(
        "mdi-beta",
        new MdiMeta(
            "beta",
            "F00A1",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon betamax() {
    return MdiIcon.create(
        "mdi-betamax",
        new MdiMeta(
            "betamax", "F09CB", Arrays.asList(), Arrays.asList(), "GreenTurtwig", "2.5.94"));
  }

  public static MdiIcon biathlon() {
    return MdiIcon.create(
        "mdi-biathlon",
        new MdiMeta(
            "biathlon",
            "F0E14",
            Arrays.asList("Sport", "People / Family"),
            Arrays.asList("human-biathlon"),
            "Google",
            "3.6.95"));
  }

  public static MdiIcon bicycle() {
    return MdiIcon.create(
        "mdi-bicycle",
        new MdiMeta(
            "bicycle",
            "F109C",
            Arrays.asList("Transportation + Other", "Sport"),
            Arrays.asList("bike", "cycling"),
            "François Risoud",
            "4.2.95"));
  }

  public static MdiIcon bicycle_basket() {
    return MdiIcon.create(
        "mdi-bicycle-basket",
        new MdiMeta(
            "bicycle-basket",
            "F1235",
            Arrays.asList("Transportation + Other", "Sport"),
            Arrays.asList("bike-basket"),
            "François Risoud",
            "4.6.95"));
  }

  public static MdiIcon bicycle_cargo() {
    return MdiIcon.create(
        "mdi-bicycle-cargo",
        new MdiMeta(
            "bicycle-cargo",
            "F189C",
            Arrays.asList("Transportation + Other", "Sport"),
            Arrays.asList("bike-cargo"),
            "Teodor Sandu",
            "6.3.95"));
  }

  public static MdiIcon bicycle_electric() {
    return MdiIcon.create(
        "mdi-bicycle-electric",
        new MdiMeta(
            "bicycle-electric",
            "F15B4",
            Arrays.asList("Transportation + Other"),
            Arrays.asList("bike-electric"),
            "Michael Irigoyen",
            "5.6.55"));
  }

  public static MdiIcon bicycle_penny_farthing() {
    return MdiIcon.create(
        "mdi-bicycle-penny-farthing",
        new MdiMeta(
            "bicycle-penny-farthing",
            "F15E9",
            Arrays.asList("Transportation + Other", "Sport"),
            Arrays.asList("bicycle-high-wheel", "bicycle-antique"),
            "Colton Wiscombe",
            "5.6.55"));
  }

  public static MdiIcon bike() {
    return MdiIcon.create(
        "mdi-bike",
        new MdiMeta(
            "bike",
            "F00A3",
            Arrays.asList("Transportation + Other", "Sport"),
            Arrays.asList("bicycle", "cycling", "directions-bike"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon bike_fast() {
    return MdiIcon.create(
        "mdi-bike-fast",
        new MdiMeta(
            "bike-fast",
            "F111F",
            Arrays.asList("Transportation + Other", "Sport"),
            Arrays.asList("velocity"),
            "GreenTurtwig",
            "4.3.95"));
  }

  public static MdiIcon bike_pedal() {
    return MdiIcon.create(
        "mdi-bike-pedal",
        new MdiMeta(
            "bike-pedal",
            "F1C23",
            Arrays.asList("Transportation + Other", "Sport"),
            Arrays.asList("bike-pedal-flat"),
            "Jeff Anders",
            "7.2.96"));
  }

  public static MdiIcon bike_pedal_clipless() {
    return MdiIcon.create(
        "mdi-bike-pedal-clipless",
        new MdiMeta(
            "bike-pedal-clipless",
            "F1C24",
            Arrays.asList("Transportation + Other", "Sport"),
            Arrays.asList(),
            "Jeff Anders",
            "7.2.96"));
  }

  public static MdiIcon bike_pedal_mountain() {
    return MdiIcon.create(
        "mdi-bike-pedal-mountain",
        new MdiMeta(
            "bike-pedal-mountain",
            "F1C25",
            Arrays.asList("Transportation + Other", "Sport"),
            Arrays.asList(),
            "Jeff Anders",
            "7.2.96"));
  }

  public static MdiIcon billboard() {
    return MdiIcon.create(
        "mdi-billboard",
        new MdiMeta(
            "billboard", "F1010", Arrays.asList(), Arrays.asList(), "Michael Richins", "4.1.95"));
  }

  public static MdiIcon billiards() {
    return MdiIcon.create(
        "mdi-billiards",
        new MdiMeta(
            "billiards",
            "F0B61",
            Arrays.asList("Sport"),
            Arrays.asList("pool", "eight-ball"),
            "Michael Richins",
            "3.0.39"));
  }

  public static MdiIcon billiards_rack() {
    return MdiIcon.create(
        "mdi-billiards-rack",
        new MdiMeta(
            "billiards-rack",
            "F0B62",
            Arrays.asList("Sport"),
            Arrays.asList(
                "pool-table",
                "pool-rack",
                "snooker-rack",
                "pool-triangle",
                "billiards-triangle",
                "snooker-triangle"),
            "Michael Richins",
            "3.0.39"));
  }

  public static MdiIcon binoculars() {
    return MdiIcon.create(
        "mdi-binoculars",
        new MdiMeta(
            "binoculars", "F00A5", Arrays.asList(), Arrays.asList(), "Austin Andrews", "1.5.54"));
  }

  public static MdiIcon bio() {
    return MdiIcon.create(
        "mdi-bio",
        new MdiMeta("bio", "F00A6", Arrays.asList(), Arrays.asList(), "Austin Andrews", "1.5.54"));
  }

  public static MdiIcon biohazard() {
    return MdiIcon.create(
        "mdi-biohazard",
        new MdiMeta(
            "biohazard",
            "F00A7",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Yasmina Lembachar",
            "1.5.54"));
  }

  public static MdiIcon bird() {
    return MdiIcon.create(
        "mdi-bird",
        new MdiMeta(
            "bird",
            "F15C6",
            Arrays.asList("Animal"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.6.55"));
  }

  @Deprecated
  public static MdiIcon bitbucket() {
    return MdiIcon.create(
        "mdi-bitbucket",
        new MdiMeta(
            "bitbucket",
            "F00A8",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "1.5.54"));
  }

  @Deprecated
  public static MdiIcon bitcoin() {
    return MdiIcon.create(
        "mdi-bitcoin",
        new MdiMeta(
            "bitcoin",
            "F0813",
            Arrays.asList("Brand / Logo", "Banking", "Currency"),
            Arrays.asList(),
            "Contributors",
            "2.1.19"));
  }

  @Deprecated
  public static MdiIcon black_mesa() {
    return MdiIcon.create(
        "mdi-black-mesa",
        new MdiMeta(
            "black-mesa",
            "F00A9",
            Arrays.asList("Brand / Logo", "Gaming / RPG"),
            Arrays.asList(),
            "Contributors",
            "1.5.54"));
  }

  public static MdiIcon blender() {
    return MdiIcon.create(
        "mdi-blender",
        new MdiMeta(
            "blender",
            "F0CEB",
            Arrays.asList("Food / Drink", "Home Automation"),
            Arrays.asList("food-processor"),
            "Google",
            "3.3.92"));
  }

  public static MdiIcon blender_outline() {
    return MdiIcon.create(
        "mdi-blender-outline",
        new MdiMeta(
            "blender-outline",
            "F181A",
            Arrays.asList("Home Automation", "Food / Drink"),
            Arrays.asList("food-processor-outline"),
            "Google",
            "6.1.95"));
  }

  @Deprecated
  public static MdiIcon blender_software() {
    return MdiIcon.create(
        "mdi-blender-software",
        new MdiMeta(
            "blender-software",
            "F00AB",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "1.5.54"));
  }

  public static MdiIcon blinds() {
    return MdiIcon.create(
        "mdi-blinds",
        new MdiMeta(
            "blinds",
            "F00AC",
            Arrays.asList("Home Automation"),
            Arrays.asList("roller-shade-closed", "window-closed"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon blinds_horizontal() {
    return MdiIcon.create(
        "mdi-blinds-horizontal",
        new MdiMeta(
            "blinds-horizontal",
            "F1A2B",
            Arrays.asList("Home Automation"),
            Arrays.asList("blinds-open", "mini-blinds", "window-open"),
            "Google",
            "6.7.96"));
  }

  public static MdiIcon blinds_horizontal_closed() {
    return MdiIcon.create(
        "mdi-blinds-horizontal-closed",
        new MdiMeta(
            "blinds-horizontal-closed",
            "F1A2C",
            Arrays.asList("Home Automation"),
            Arrays.asList("mini-blinds", "window-closed"),
            "Google",
            "6.7.96"));
  }

  public static MdiIcon blinds_open() {
    return MdiIcon.create(
        "mdi-blinds-open",
        new MdiMeta(
            "blinds-open",
            "F1011",
            Arrays.asList("Home Automation"),
            Arrays.asList("roller-shade-open", "window-open"),
            "idevo89",
            "4.1.95"));
  }

  public static MdiIcon blinds_vertical() {
    return MdiIcon.create(
        "mdi-blinds-vertical",
        new MdiMeta(
            "blinds-vertical",
            "F1A2D",
            Arrays.asList("Home Automation"),
            Arrays.asList("window"),
            "Google",
            "6.7.96"));
  }

  public static MdiIcon blinds_vertical_closed() {
    return MdiIcon.create(
        "mdi-blinds-vertical-closed",
        new MdiMeta(
            "blinds-vertical-closed",
            "F1A2E",
            Arrays.asList("Home Automation"),
            Arrays.asList("window-closed"),
            "Google",
            "6.7.96"));
  }

  public static MdiIcon block_helper() {
    return MdiIcon.create(
        "mdi-block-helper",
        new MdiMeta(
            "block-helper", "F00AD", Arrays.asList(), Arrays.asList(), "Austin Andrews", "1.5.54"));
  }

  public static MdiIcon blood_bag() {
    return MdiIcon.create(
        "mdi-blood-bag",
        new MdiMeta(
            "blood-bag",
            "F0CEC",
            Arrays.asList("Medical / Hospital"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.3.92"));
  }

  public static MdiIcon bluetooth() {
    return MdiIcon.create(
        "mdi-bluetooth",
        new MdiMeta(
            "bluetooth", "F00AF", Arrays.asList(), Arrays.asList(), "Contributors", "1.5.54"));
  }

  public static MdiIcon bluetooth_audio() {
    return MdiIcon.create(
        "mdi-bluetooth-audio",
        new MdiMeta(
            "bluetooth-audio",
            "F00B0",
            Arrays.asList("Audio"),
            Arrays.asList("bluetooth-searching"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon bluetooth_connect() {
    return MdiIcon.create(
        "mdi-bluetooth-connect",
        new MdiMeta(
            "bluetooth-connect",
            "F00B1",
            Arrays.asList(),
            Arrays.asList("bluetooth-connected"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon bluetooth_off() {
    return MdiIcon.create(
        "mdi-bluetooth-off",
        new MdiMeta(
            "bluetooth-off",
            "F00B2",
            Arrays.asList(),
            Arrays.asList("bluetooth-disabled"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon bluetooth_settings() {
    return MdiIcon.create(
        "mdi-bluetooth-settings",
        new MdiMeta(
            "bluetooth-settings",
            "F00B3",
            Arrays.asList("Settings"),
            Arrays.asList("settings-bluetooth"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon bluetooth_transfer() {
    return MdiIcon.create(
        "mdi-bluetooth-transfer",
        new MdiMeta(
            "bluetooth-transfer", "F00B4", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon blur() {
    return MdiIcon.create(
        "mdi-blur",
        new MdiMeta(
            "blur", "F00B5", Arrays.asList(), Arrays.asList("blur-on"), "Google", "1.5.54"));
  }

  public static MdiIcon blur_linear() {
    return MdiIcon.create(
        "mdi-blur-linear",
        new MdiMeta("blur-linear", "F00B6", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon blur_off() {
    return MdiIcon.create(
        "mdi-blur-off",
        new MdiMeta("blur-off", "F00B7", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon blur_radial() {
    return MdiIcon.create(
        "mdi-blur-radial",
        new MdiMeta(
            "blur-radial",
            "F00B8",
            Arrays.asList(),
            Arrays.asList("blur-circular"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon bolt() {
    return MdiIcon.create(
        "mdi-bolt",
        new MdiMeta(
            "bolt",
            "F0DB3",
            Arrays.asList("Hardware / Tools"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.5.94"));
  }

  public static MdiIcon bomb() {
    return MdiIcon.create(
        "mdi-bomb",
        new MdiMeta(
            "bomb",
            "F0691",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "Austin Andrews",
            "1.7.12"));
  }

  public static MdiIcon bomb_off() {
    return MdiIcon.create(
        "mdi-bomb-off",
        new MdiMeta(
            "bomb-off",
            "F06C5",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "Roberto Graham",
            "1.8.36"));
  }

  public static MdiIcon bone() {
    return MdiIcon.create(
        "mdi-bone",
        new MdiMeta(
            "bone",
            "F00B9",
            Arrays.asList("Animal", "Holiday"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon bone_off() {
    return MdiIcon.create(
        "mdi-bone-off",
        new MdiMeta(
            "bone-off",
            "F19E0",
            Arrays.asList("Animal", "Holiday"),
            Arrays.asList(),
            "Simran",
            "6.6.96"));
  }

  public static MdiIcon book() {
    return MdiIcon.create(
        "mdi-book",
        new MdiMeta(
            "book", "F00BA", Arrays.asList(), Arrays.asList("git-repository"), "Google", "1.5.54"));
  }

  public static MdiIcon book_account() {
    return MdiIcon.create(
        "mdi-book-account",
        new MdiMeta(
            "book-account",
            "F13AD",
            Arrays.asList("Account / User"),
            Arrays.asList(),
            "Michael Richins",
            "5.0.45"));
  }

  public static MdiIcon book_account_outline() {
    return MdiIcon.create(
        "mdi-book-account-outline",
        new MdiMeta(
            "book-account-outline",
            "F13AE",
            Arrays.asList("Account / User"),
            Arrays.asList(),
            "Michael Richins",
            "5.0.45"));
  }

  public static MdiIcon book_alert() {
    return MdiIcon.create(
        "mdi-book-alert",
        new MdiMeta(
            "book-alert",
            "F167C",
            Arrays.asList("Alert / Error"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_alert_outline() {
    return MdiIcon.create(
        "mdi-book-alert-outline",
        new MdiMeta(
            "book-alert-outline",
            "F167D",
            Arrays.asList("Alert / Error"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_alphabet() {
    return MdiIcon.create(
        "mdi-book-alphabet",
        new MdiMeta(
            "book-alphabet",
            "F061D",
            Arrays.asList(),
            Arrays.asList("dictionary"),
            "Christopher Schreiner",
            "1.6.50"));
  }

  public static MdiIcon book_arrow_down() {
    return MdiIcon.create(
        "mdi-book-arrow-down",
        new MdiMeta(
            "book-arrow-down",
            "F167E",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_arrow_down_outline() {
    return MdiIcon.create(
        "mdi-book-arrow-down-outline",
        new MdiMeta(
            "book-arrow-down-outline",
            "F167F",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_arrow_left() {
    return MdiIcon.create(
        "mdi-book-arrow-left",
        new MdiMeta(
            "book-arrow-left",
            "F1680",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_arrow_left_outline() {
    return MdiIcon.create(
        "mdi-book-arrow-left-outline",
        new MdiMeta(
            "book-arrow-left-outline",
            "F1681",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_arrow_right() {
    return MdiIcon.create(
        "mdi-book-arrow-right",
        new MdiMeta(
            "book-arrow-right",
            "F1682",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_arrow_right_outline() {
    return MdiIcon.create(
        "mdi-book-arrow-right-outline",
        new MdiMeta(
            "book-arrow-right-outline",
            "F1683",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_arrow_up() {
    return MdiIcon.create(
        "mdi-book-arrow-up",
        new MdiMeta(
            "book-arrow-up",
            "F1684",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_arrow_up_outline() {
    return MdiIcon.create(
        "mdi-book-arrow-up-outline",
        new MdiMeta(
            "book-arrow-up-outline",
            "F1685",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_cancel() {
    return MdiIcon.create(
        "mdi-book-cancel",
        new MdiMeta(
            "book-cancel", "F1686", Arrays.asList(), Arrays.asList(), "Colton Wiscombe", "5.8.55"));
  }

  public static MdiIcon book_cancel_outline() {
    return MdiIcon.create(
        "mdi-book-cancel-outline",
        new MdiMeta(
            "book-cancel-outline",
            "F1687",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_check() {
    return MdiIcon.create(
        "mdi-book-check",
        new MdiMeta(
            "book-check", "F14F3", Arrays.asList(), Arrays.asList(), "Austin Andrews", "5.4.55"));
  }

  public static MdiIcon book_check_outline() {
    return MdiIcon.create(
        "mdi-book-check-outline",
        new MdiMeta(
            "book-check-outline",
            "F14F4",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "5.4.55"));
  }

  public static MdiIcon book_clock() {
    return MdiIcon.create(
        "mdi-book-clock",
        new MdiMeta(
            "book-clock",
            "F1688",
            Arrays.asList("Date / Time"),
            Arrays.asList("book-schedule", "book-time"),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_clock_outline() {
    return MdiIcon.create(
        "mdi-book-clock-outline",
        new MdiMeta(
            "book-clock-outline",
            "F1689",
            Arrays.asList("Date / Time"),
            Arrays.asList("book-schedule", "book-time"),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_cog() {
    return MdiIcon.create(
        "mdi-book-cog",
        new MdiMeta(
            "book-cog",
            "F168A",
            Arrays.asList("Settings"),
            Arrays.asList("book-settings"),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_cog_outline() {
    return MdiIcon.create(
        "mdi-book-cog-outline",
        new MdiMeta(
            "book-cog-outline",
            "F168B",
            Arrays.asList("Settings"),
            Arrays.asList("book-settings-outline"),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_cross() {
    return MdiIcon.create(
        "mdi-book-cross",
        new MdiMeta(
            "book-cross",
            "F00A2",
            Arrays.asList("Religion"),
            Arrays.asList("bible"),
            "Christopher Schreiner",
            "1.5.54"));
  }

  public static MdiIcon book_edit() {
    return MdiIcon.create(
        "mdi-book-edit",
        new MdiMeta(
            "book-edit",
            "F168C",
            Arrays.asList("Edit / Modify"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_edit_outline() {
    return MdiIcon.create(
        "mdi-book-edit-outline",
        new MdiMeta(
            "book-edit-outline",
            "F168D",
            Arrays.asList("Edit / Modify"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_education() {
    return MdiIcon.create(
        "mdi-book-education",
        new MdiMeta(
            "book-education",
            "F16C9",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_education_outline() {
    return MdiIcon.create(
        "mdi-book-education-outline",
        new MdiMeta(
            "book-education-outline",
            "F16CA",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_heart() {
    return MdiIcon.create(
        "mdi-book-heart",
        new MdiMeta(
            "book-heart",
            "F1A1D",
            Arrays.asList(),
            Arrays.asList("book-favorite", "book-love"),
            "Austin Andrews",
            "6.6.96"));
  }

  public static MdiIcon book_heart_outline() {
    return MdiIcon.create(
        "mdi-book-heart-outline",
        new MdiMeta(
            "book-heart-outline",
            "F1A1E",
            Arrays.asList(),
            Arrays.asList("book-favorite-outline", "book-love-outline"),
            "Austin Andrews",
            "6.6.96"));
  }

  public static MdiIcon book_information_variant() {
    return MdiIcon.create(
        "mdi-book-information-variant",
        new MdiMeta(
            "book-information-variant",
            "F106F",
            Arrays.asList(),
            Arrays.asList("encyclopedia"),
            "Terren",
            "4.2.95"));
  }

  public static MdiIcon book_lock() {
    return MdiIcon.create(
        "mdi-book-lock",
        new MdiMeta(
            "book-lock",
            "F079A",
            Arrays.asList("Lock"),
            Arrays.asList("book-secure"),
            "Michael Richins",
            "2.0.46"));
  }

  public static MdiIcon book_lock_open() {
    return MdiIcon.create(
        "mdi-book-lock-open",
        new MdiMeta(
            "book-lock-open",
            "F079B",
            Arrays.asList("Lock"),
            Arrays.asList("book-unsecure"),
            "Michael Richins",
            "2.0.46"));
  }

  public static MdiIcon book_lock_open_outline() {
    return MdiIcon.create(
        "mdi-book-lock-open-outline",
        new MdiMeta(
            "book-lock-open-outline",
            "F168E",
            Arrays.asList("Lock"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_lock_outline() {
    return MdiIcon.create(
        "mdi-book-lock-outline",
        new MdiMeta(
            "book-lock-outline",
            "F168F",
            Arrays.asList("Lock"),
            Arrays.asList("book-secure-outline"),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_marker() {
    return MdiIcon.create(
        "mdi-book-marker",
        new MdiMeta(
            "book-marker",
            "F1690",
            Arrays.asList("Navigation"),
            Arrays.asList("book-location"),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_marker_outline() {
    return MdiIcon.create(
        "mdi-book-marker-outline",
        new MdiMeta(
            "book-marker-outline",
            "F1691",
            Arrays.asList("Navigation"),
            Arrays.asList("book-location-outline"),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_minus() {
    return MdiIcon.create(
        "mdi-book-minus",
        new MdiMeta("book-minus", "F05D9", Arrays.asList(), Arrays.asList(), "Simran", "1.5.54"));
  }

  public static MdiIcon book_minus_multiple() {
    return MdiIcon.create(
        "mdi-book-minus-multiple",
        new MdiMeta(
            "book-minus-multiple",
            "F0A94",
            Arrays.asList(),
            Arrays.asList("books-minus"),
            "Perth Totty",
            "2.7.94"));
  }

  public static MdiIcon book_minus_multiple_outline() {
    return MdiIcon.create(
        "mdi-book-minus-multiple-outline",
        new MdiMeta(
            "book-minus-multiple-outline",
            "F090B",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "2.3.50"));
  }

  public static MdiIcon book_minus_outline() {
    return MdiIcon.create(
        "mdi-book-minus-outline",
        new MdiMeta(
            "book-minus-outline",
            "F1692",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_multiple() {
    return MdiIcon.create(
        "mdi-book-multiple",
        new MdiMeta(
            "book-multiple",
            "F00BB",
            Arrays.asList(),
            Arrays.asList("books"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon book_multiple_outline() {
    return MdiIcon.create(
        "mdi-book-multiple-outline",
        new MdiMeta(
            "book-multiple-outline",
            "F0436",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "1.5.54"));
  }

  public static MdiIcon book_music() {
    return MdiIcon.create(
        "mdi-book-music",
        new MdiMeta(
            "book-music",
            "F0067",
            Arrays.asList("Audio", "Music"),
            Arrays.asList("audio-book"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon book_music_outline() {
    return MdiIcon.create(
        "mdi-book-music-outline",
        new MdiMeta(
            "book-music-outline",
            "F1693",
            Arrays.asList("Music"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_off() {
    return MdiIcon.create(
        "mdi-book-off",
        new MdiMeta(
            "book-off", "F1694", Arrays.asList(), Arrays.asList(), "Colton Wiscombe", "5.8.55"));
  }

  public static MdiIcon book_off_outline() {
    return MdiIcon.create(
        "mdi-book-off-outline",
        new MdiMeta(
            "book-off-outline",
            "F1695",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_open() {
    return MdiIcon.create(
        "mdi-book-open",
        new MdiMeta(
            "book-open",
            "F00BD",
            Arrays.asList(),
            Arrays.asList("chrome-reader-mode"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon book_open_blank_variant() {
    return MdiIcon.create(
        "mdi-book-open-blank-variant",
        new MdiMeta(
            "book-open-blank-variant",
            "F00BE",
            Arrays.asList(),
            Arrays.asList("import-contacts"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon book_open_outline() {
    return MdiIcon.create(
        "mdi-book-open-outline",
        new MdiMeta(
            "book-open-outline", "F0B63", Arrays.asList(), Arrays.asList(), "Google", "3.0.39"));
  }

  public static MdiIcon book_open_page_variant() {
    return MdiIcon.create(
        "mdi-book-open-page-variant",
        new MdiMeta(
            "book-open-page-variant",
            "F05DA",
            Arrays.asList(),
            Arrays.asList("auto-stories"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon book_open_page_variant_outline() {
    return MdiIcon.create(
        "mdi-book-open-page-variant-outline",
        new MdiMeta(
            "book-open-page-variant-outline",
            "F15D6",
            Arrays.asList(),
            Arrays.asList(),
            "Google",
            "5.6.55"));
  }

  public static MdiIcon book_open_variant() {
    return MdiIcon.create(
        "mdi-book-open-variant",
        new MdiMeta(
            "book-open-variant", "F14F7", Arrays.asList(), Arrays.asList(), "Google", "5.4.55"));
  }

  public static MdiIcon book_outline() {
    return MdiIcon.create(
        "mdi-book-outline",
        new MdiMeta("book-outline", "F0B64", Arrays.asList(), Arrays.asList(), "Google", "3.0.39"));
  }

  public static MdiIcon book_play() {
    return MdiIcon.create(
        "mdi-book-play",
        new MdiMeta(
            "book-play", "F0E82", Arrays.asList(), Arrays.asList(), "Austin Andrews", "3.7.94"));
  }

  public static MdiIcon book_play_outline() {
    return MdiIcon.create(
        "mdi-book-play-outline",
        new MdiMeta(
            "book-play-outline",
            "F0E83",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "3.7.94"));
  }

  public static MdiIcon book_plus() {
    return MdiIcon.create(
        "mdi-book-plus",
        new MdiMeta(
            "book-plus", "F05DB", Arrays.asList(), Arrays.asList("book-add"), "Simran", "1.5.54"));
  }

  public static MdiIcon book_plus_multiple() {
    return MdiIcon.create(
        "mdi-book-plus-multiple",
        new MdiMeta(
            "book-plus-multiple",
            "F0A95",
            Arrays.asList(),
            Arrays.asList("books-plus", "book-multiple-add", "books-add"),
            "Perth Totty",
            "2.7.94"));
  }

  public static MdiIcon book_plus_multiple_outline() {
    return MdiIcon.create(
        "mdi-book-plus-multiple-outline",
        new MdiMeta(
            "book-plus-multiple-outline",
            "F0ADE",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "2.7.94"));
  }

  public static MdiIcon book_plus_outline() {
    return MdiIcon.create(
        "mdi-book-plus-outline",
        new MdiMeta(
            "book-plus-outline",
            "F1696",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_refresh() {
    return MdiIcon.create(
        "mdi-book-refresh",
        new MdiMeta(
            "book-refresh",
            "F1697",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_refresh_outline() {
    return MdiIcon.create(
        "mdi-book-refresh-outline",
        new MdiMeta(
            "book-refresh-outline",
            "F1698",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_remove() {
    return MdiIcon.create(
        "mdi-book-remove",
        new MdiMeta(
            "book-remove", "F0A97", Arrays.asList(), Arrays.asList(), "Perth Totty", "2.7.94"));
  }

  public static MdiIcon book_remove_multiple() {
    return MdiIcon.create(
        "mdi-book-remove-multiple",
        new MdiMeta(
            "book-remove-multiple",
            "F0A96",
            Arrays.asList(),
            Arrays.asList("books-remove"),
            "Perth Totty",
            "2.7.94"));
  }

  public static MdiIcon book_remove_multiple_outline() {
    return MdiIcon.create(
        "mdi-book-remove-multiple-outline",
        new MdiMeta(
            "book-remove-multiple-outline",
            "F04CA",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "1.5.54"));
  }

  public static MdiIcon book_remove_outline() {
    return MdiIcon.create(
        "mdi-book-remove-outline",
        new MdiMeta(
            "book-remove-outline",
            "F1699",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_search() {
    return MdiIcon.create(
        "mdi-book-search",
        new MdiMeta(
            "book-search", "F0E84", Arrays.asList(), Arrays.asList(), "Austin Andrews", "3.7.94"));
  }

  public static MdiIcon book_search_outline() {
    return MdiIcon.create(
        "mdi-book-search-outline",
        new MdiMeta(
            "book-search-outline",
            "F0E85",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "3.7.94"));
  }

  public static MdiIcon book_settings() {
    return MdiIcon.create(
        "mdi-book-settings",
        new MdiMeta(
            "book-settings",
            "F169A",
            Arrays.asList("Settings"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_settings_outline() {
    return MdiIcon.create(
        "mdi-book-settings-outline",
        new MdiMeta(
            "book-settings-outline",
            "F169B",
            Arrays.asList("Settings"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_sync() {
    return MdiIcon.create(
        "mdi-book-sync",
        new MdiMeta(
            "book-sync", "F169C", Arrays.asList(), Arrays.asList(), "Colton Wiscombe", "5.8.55"));
  }

  public static MdiIcon book_sync_outline() {
    return MdiIcon.create(
        "mdi-book-sync-outline",
        new MdiMeta(
            "book-sync-outline",
            "F16C8",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon book_variant() {
    return MdiIcon.create(
        "mdi-book-variant",
        new MdiMeta(
            "book-variant", "F00BF", Arrays.asList(), Arrays.asList("class"), "Google", "1.5.54"));
  }

  public static MdiIcon bookmark() {
    return MdiIcon.create(
        "mdi-bookmark",
        new MdiMeta(
            "bookmark", "F00C0", Arrays.asList(), Arrays.asList("turned-in"), "Google", "1.5.54"));
  }

  public static MdiIcon bookmark_box() {
    return MdiIcon.create(
        "mdi-bookmark-box",
        new MdiMeta(
            "bookmark-box", "F1B75", Arrays.asList(), Arrays.asList(), "Jeff Anders", "7.0.96"));
  }

  public static MdiIcon bookmark_box_multiple() {
    return MdiIcon.create(
        "mdi-bookmark-box-multiple",
        new MdiMeta(
            "bookmark-box-multiple",
            "F196C",
            Arrays.asList(),
            Arrays.asList("collections-bookmark", "library-bookmark"),
            "Google",
            "6.5.95"));
  }

  public static MdiIcon bookmark_box_multiple_outline() {
    return MdiIcon.create(
        "mdi-bookmark-box-multiple-outline",
        new MdiMeta(
            "bookmark-box-multiple-outline",
            "F196D",
            Arrays.asList(),
            Arrays.asList("collections-bookmark-outline", "library-bookmark-outline"),
            "Michael Irigoyen",
            "6.5.95"));
  }

  public static MdiIcon bookmark_box_outline() {
    return MdiIcon.create(
        "mdi-bookmark-box-outline",
        new MdiMeta(
            "bookmark-box-outline",
            "F1B76",
            Arrays.asList(),
            Arrays.asList(),
            "Jeff Anders",
            "7.0.96"));
  }

  public static MdiIcon bookmark_check() {
    return MdiIcon.create(
        "mdi-bookmark-check",
        new MdiMeta(
            "bookmark-check",
            "F00C1",
            Arrays.asList(),
            Arrays.asList("bookmark-tick", "bookmark-success"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon bookmark_check_outline() {
    return MdiIcon.create(
        "mdi-bookmark-check-outline",
        new MdiMeta(
            "bookmark-check-outline",
            "F137B",
            Arrays.asList(),
            Arrays.asList("bookmark-success-outline"),
            "Simran",
            "4.9.95"));
  }

  public static MdiIcon bookmark_minus() {
    return MdiIcon.create(
        "mdi-bookmark-minus",
        new MdiMeta(
            "bookmark-minus",
            "F09CC",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon bookmark_minus_outline() {
    return MdiIcon.create(
        "mdi-bookmark-minus-outline",
        new MdiMeta(
            "bookmark-minus-outline",
            "F09CD",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon bookmark_multiple() {
    return MdiIcon.create(
        "mdi-bookmark-multiple",
        new MdiMeta(
            "bookmark-multiple", "F0E15", Arrays.asList(), Arrays.asList(), "Google", "3.6.95"));
  }

  public static MdiIcon bookmark_multiple_outline() {
    return MdiIcon.create(
        "mdi-bookmark-multiple-outline",
        new MdiMeta(
            "bookmark-multiple-outline",
            "F0E16",
            Arrays.asList(),
            Arrays.asList(),
            "Google",
            "3.6.95"));
  }

  public static MdiIcon bookmark_music() {
    return MdiIcon.create(
        "mdi-bookmark-music",
        new MdiMeta(
            "bookmark-music",
            "F00C2",
            Arrays.asList("Music"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon bookmark_music_outline() {
    return MdiIcon.create(
        "mdi-bookmark-music-outline",
        new MdiMeta(
            "bookmark-music-outline",
            "F1379",
            Arrays.asList("Music"),
            Arrays.asList(),
            "Simran",
            "4.9.95"));
  }

  public static MdiIcon bookmark_off() {
    return MdiIcon.create(
        "mdi-bookmark-off",
        new MdiMeta(
            "bookmark-off",
            "F09CE",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon bookmark_off_outline() {
    return MdiIcon.create(
        "mdi-bookmark-off-outline",
        new MdiMeta(
            "bookmark-off-outline",
            "F09CF",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon bookmark_outline() {
    return MdiIcon.create(
        "mdi-bookmark-outline",
        new MdiMeta(
            "bookmark-outline",
            "F00C3",
            Arrays.asList(),
            Arrays.asList("bookmark-border", "turned-in-not"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon bookmark_plus() {
    return MdiIcon.create(
        "mdi-bookmark-plus",
        new MdiMeta(
            "bookmark-plus",
            "F00C5",
            Arrays.asList(),
            Arrays.asList("bookmark-add"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon bookmark_plus_outline() {
    return MdiIcon.create(
        "mdi-bookmark-plus-outline",
        new MdiMeta(
            "bookmark-plus-outline",
            "F00C4",
            Arrays.asList(),
            Arrays.asList("bookmark-add-outline"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon bookmark_remove() {
    return MdiIcon.create(
        "mdi-bookmark-remove",
        new MdiMeta(
            "bookmark-remove",
            "F00C6",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon bookmark_remove_outline() {
    return MdiIcon.create(
        "mdi-bookmark-remove-outline",
        new MdiMeta(
            "bookmark-remove-outline",
            "F137A",
            Arrays.asList(),
            Arrays.asList(),
            "Simran",
            "4.9.95"));
  }

  public static MdiIcon bookshelf() {
    return MdiIcon.create(
        "mdi-bookshelf",
        new MdiMeta(
            "bookshelf",
            "F125F",
            Arrays.asList(),
            Arrays.asList(),
            "Thomas de Saint-Exupéry",
            "4.7.95"));
  }

  public static MdiIcon boom_gate() {
    return MdiIcon.create(
        "mdi-boom-gate",
        new MdiMeta(
            "boom-gate",
            "F0E86",
            Arrays.asList("Transportation + Road", "Home Automation"),
            Arrays.asList("boom-arm", "boom-barrier", "arm-barrier", "barrier", "automatic-gate"),
            "Michael Richins",
            "3.7.94"));
  }

  public static MdiIcon boom_gate_alert() {
    return MdiIcon.create(
        "mdi-boom-gate-alert",
        new MdiMeta(
            "boom-gate-alert",
            "F0E87",
            Arrays.asList("Alert / Error", "Transportation + Road"),
            Arrays.asList(
                "boom-arm-alert",
                "boom-barrier-alert",
                "arm-barrier-alert",
                "barrier-alert",
                "automatic-gate-alert"),
            "Michael Richins",
            "3.7.94"));
  }

  public static MdiIcon boom_gate_alert_outline() {
    return MdiIcon.create(
        "mdi-boom-gate-alert-outline",
        new MdiMeta(
            "boom-gate-alert-outline",
            "F0E88",
            Arrays.asList("Alert / Error", "Transportation + Road"),
            Arrays.asList(
                "boom-arm-alert-outline",
                "boom-barrier-alert-outline",
                "arm-barrier-alert-outline",
                "barrier-alert-outline",
                "automatic-gate-alert-outline"),
            "Michael Richins",
            "3.7.94"));
  }

  public static MdiIcon boom_gate_arrow_down() {
    return MdiIcon.create(
        "mdi-boom-gate-arrow-down",
        new MdiMeta(
            "boom-gate-arrow-down",
            "F0E89",
            Arrays.asList("Transportation + Road"),
            Arrays.asList(
                "boom-arm-down",
                "boom-barrier-down",
                "arm-barrier-down",
                "barrier-down",
                "automatic-gate-down"),
            "Michael Richins",
            "3.7.94"));
  }

  public static MdiIcon boom_gate_arrow_down_outline() {
    return MdiIcon.create(
        "mdi-boom-gate-arrow-down-outline",
        new MdiMeta(
            "boom-gate-arrow-down-outline",
            "F0E8A",
            Arrays.asList("Transportation + Road"),
            Arrays.asList(
                "boom-arm-down-outline",
                "boom-barrier-down-outline",
                "arm-barrier-down-outline",
                "barrier-down-outline",
                "automatic-gate-down-outline"),
            "Michael Richins",
            "3.7.94"));
  }

  public static MdiIcon boom_gate_arrow_up() {
    return MdiIcon.create(
        "mdi-boom-gate-arrow-up",
        new MdiMeta(
            "boom-gate-arrow-up",
            "F0E8C",
            Arrays.asList("Transportation + Road"),
            Arrays.asList(
                "boom-arm-up",
                "boom-barrier-up",
                "arm-barrier-up",
                "barrier-up",
                "automatic-gate-up"),
            "Michael Richins",
            "3.7.94"));
  }

  public static MdiIcon boom_gate_arrow_up_outline() {
    return MdiIcon.create(
        "mdi-boom-gate-arrow-up-outline",
        new MdiMeta(
            "boom-gate-arrow-up-outline",
            "F0E8D",
            Arrays.asList("Transportation + Road"),
            Arrays.asList(
                "boom-arm-up-outline",
                "boom-barrier-up-outline",
                "arm-barrier-up-outline",
                "barrier-up-outline",
                "automatic-gate-up-outline"),
            "Michael Richins",
            "3.7.94"));
  }

  public static MdiIcon boom_gate_outline() {
    return MdiIcon.create(
        "mdi-boom-gate-outline",
        new MdiMeta(
            "boom-gate-outline",
            "F0E8B",
            Arrays.asList("Transportation + Road", "Home Automation"),
            Arrays.asList(
                "boom-arm-outline",
                "boom-barrier-outline",
                "arm-barrier-outline",
                "barrier-outline",
                "automatic-gate-outline"),
            "Michael Richins",
            "3.7.94"));
  }

  public static MdiIcon boom_gate_up() {
    return MdiIcon.create(
        "mdi-boom-gate-up",
        new MdiMeta(
            "boom-gate-up",
            "F17F9",
            Arrays.asList("Transportation + Road", "Home Automation"),
            Arrays.asList(
                "boom-arm-up",
                "boom-barrier-up",
                "arm-barrier-up",
                "barrier-up",
                "automatic-gate-up"),
            "Michael Irigoyen",
            "6.1.95"));
  }

  public static MdiIcon boom_gate_up_outline() {
    return MdiIcon.create(
        "mdi-boom-gate-up-outline",
        new MdiMeta(
            "boom-gate-up-outline",
            "F17FA",
            Arrays.asList("Transportation + Road", "Home Automation"),
            Arrays.asList(
                "boom-arm-up-outline",
                "boom-barrier-up-outline",
                "arm-barrier-up-outline",
                "barrier-up-outline",
                "automatic-gate-up-outline"),
            "Michael Irigoyen",
            "6.1.95"));
  }

  public static MdiIcon boombox() {
    return MdiIcon.create(
        "mdi-boombox",
        new MdiMeta(
            "boombox",
            "F05DC",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon boomerang() {
    return MdiIcon.create(
        "mdi-boomerang",
        new MdiMeta(
            "boomerang",
            "F10CF",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.3.95"));
  }

  @Deprecated
  public static MdiIcon bootstrap() {
    return MdiIcon.create(
        "mdi-bootstrap",
        new MdiMeta(
            "bootstrap",
            "F06C6",
            Arrays.asList("Brand / Logo", "Developer / Languages"),
            Arrays.asList(),
            "Contributors",
            "1.8.36"));
  }

  public static MdiIcon border_all() {
    return MdiIcon.create(
        "mdi-border-all",
        new MdiMeta(
            "border-all",
            "F00C7",
            Arrays.asList("Text / Content / Format"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon border_all_variant() {
    return MdiIcon.create(
        "mdi-border-all-variant",
        new MdiMeta(
            "border-all-variant",
            "F08A1",
            Arrays.asList("Text / Content / Format"),
            Arrays.asList(),
            "Austin Andrews",
            "2.2.43"));
  }

  public static MdiIcon border_bottom() {
    return MdiIcon.create(
        "mdi-border-bottom",
        new MdiMeta(
            "border-bottom",
            "F00C8",
            Arrays.asList("Text / Content / Format"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon border_bottom_variant() {
    return MdiIcon.create(
        "mdi-border-bottom-variant",
        new MdiMeta(
            "border-bottom-variant",
            "F08A2",
            Arrays.asList("Text / Content / Format"),
            Arrays.asList(),
            "Austin Andrews",
            "2.2.43"));
  }

  public static MdiIcon border_color() {
    return MdiIcon.create(
        "mdi-border-color",
        new MdiMeta(
            "border-color",
            "F00C9",
            Arrays.asList("Color", "Text / Content / Format"),
            Arrays.asList("border-colour"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon border_horizontal() {
    return MdiIcon.create(
        "mdi-border-horizontal",
        new MdiMeta(
            "border-horizontal",
            "F00CA",
            Arrays.asList("Text / Content / Format"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon border_inside() {
    return MdiIcon.create(
        "mdi-border-inside",
        new MdiMeta(
            "border-inside",
            "F00CB",
            Arrays.asList("Text / Content / Format"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon border_left() {
    return MdiIcon.create(
        "mdi-border-left",
        new MdiMeta(
            "border-left",
            "F00CC",
            Arrays.asList("Text / Content / Format"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon border_left_variant() {
    return MdiIcon.create(
        "mdi-border-left-variant",
        new MdiMeta(
            "border-left-variant",
            "F08A3",
            Arrays.asList("Text / Content / Format"),
            Arrays.asList(),
            "Austin Andrews",
            "2.2.43"));
  }

  public static MdiIcon border_none() {
    return MdiIcon.create(
        "mdi-border-none",
        new MdiMeta(
            "border-none",
            "F00CD",
            Arrays.asList("Text / Content / Format"),
            Arrays.asList("border-clear"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon border_none_variant() {
    return MdiIcon.create(
        "mdi-border-none-variant",
        new MdiMeta(
            "border-none-variant",
            "F08A4",
            Arrays.asList("Text / Content / Format"),
            Arrays.asList(),
            "Austin Andrews",
            "2.2.43"));
  }

  public static MdiIcon border_outside() {
    return MdiIcon.create(
        "mdi-border-outside",
        new MdiMeta(
            "border-outside",
            "F00CE",
            Arrays.asList("Text / Content / Format"),
            Arrays.asList("border-outer"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon border_radius() {
    return MdiIcon.create(
        "mdi-border-radius",
        new MdiMeta(
            "border-radius",
            "F1AF4",
            Arrays.asList("Text / Content / Format"),
            Arrays.asList("border-round-corners"),
            "Sintija",
            "6.9.96"));
  }

  public static MdiIcon border_right() {
    return MdiIcon.create(
        "mdi-border-right",
        new MdiMeta(
            "border-right",
            "F00CF",
            Arrays.asList("Text / Content / Format"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon border_right_variant() {
    return MdiIcon.create(
        "mdi-border-right-variant",
        new MdiMeta(
            "border-right-variant",
            "F08A5",
            Arrays.asList("Text / Content / Format"),
            Arrays.asList(),
            "Austin Andrews",
            "2.2.43"));
  }

  public static MdiIcon border_style() {
    return MdiIcon.create(
        "mdi-border-style",
        new MdiMeta(
            "border-style",
            "F00D0",
            Arrays.asList("Text / Content / Format"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon border_top() {
    return MdiIcon.create(
        "mdi-border-top",
        new MdiMeta(
            "border-top",
            "F00D1",
            Arrays.asList("Text / Content / Format"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon border_top_variant() {
    return MdiIcon.create(
        "mdi-border-top-variant",
        new MdiMeta(
            "border-top-variant",
            "F08A6",
            Arrays.asList("Text / Content / Format"),
            Arrays.asList(),
            "Austin Andrews",
            "2.2.43"));
  }

  public static MdiIcon border_vertical() {
    return MdiIcon.create(
        "mdi-border-vertical",
        new MdiMeta(
            "border-vertical",
            "F00D2",
            Arrays.asList("Text / Content / Format"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon bottle_soda() {
    return MdiIcon.create(
        "mdi-bottle-soda",
        new MdiMeta(
            "bottle-soda",
            "F1070",
            Arrays.asList("Food / Drink"),
            Arrays.asList("bottle-coke", "bottle-pop"),
            "Michael Richins",
            "4.2.95"));
  }

  public static MdiIcon bottle_soda_classic() {
    return MdiIcon.create(
        "mdi-bottle-soda-classic",
        new MdiMeta(
            "bottle-soda-classic",
            "F1071",
            Arrays.asList("Food / Drink"),
            Arrays.asList("bottle-coke-classic", "bottle-pop-classic"),
            "Michael Richins",
            "4.2.95"));
  }

  public static MdiIcon bottle_soda_classic_outline() {
    return MdiIcon.create(
        "mdi-bottle-soda-classic-outline",
        new MdiMeta(
            "bottle-soda-classic-outline",
            "F1363",
            Arrays.asList(),
            Arrays.asList(),
            "Simran",
            "4.9.95"));
  }

  public static MdiIcon bottle_soda_outline() {
    return MdiIcon.create(
        "mdi-bottle-soda-outline",
        new MdiMeta(
            "bottle-soda-outline",
            "F1072",
            Arrays.asList("Food / Drink"),
            Arrays.asList("bottle-coke-outline", "bottle-pop-outline"),
            "Michael Richins",
            "4.2.95"));
  }

  public static MdiIcon bottle_tonic() {
    return MdiIcon.create(
        "mdi-bottle-tonic",
        new MdiMeta(
            "bottle-tonic",
            "F112E",
            Arrays.asList("Science"),
            Arrays.asList("flask"),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon bottle_tonic_outline() {
    return MdiIcon.create(
        "mdi-bottle-tonic-outline",
        new MdiMeta(
            "bottle-tonic-outline",
            "F112F",
            Arrays.asList("Science"),
            Arrays.asList("flask-outline"),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon bottle_tonic_plus() {
    return MdiIcon.create(
        "mdi-bottle-tonic-plus",
        new MdiMeta(
            "bottle-tonic-plus",
            "F1130",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("health-potion"),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon bottle_tonic_plus_outline() {
    return MdiIcon.create(
        "mdi-bottle-tonic-plus-outline",
        new MdiMeta(
            "bottle-tonic-plus-outline",
            "F1131",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("health-potion-outline"),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon bottle_tonic_skull() {
    return MdiIcon.create(
        "mdi-bottle-tonic-skull",
        new MdiMeta(
            "bottle-tonic-skull",
            "F1132",
            Arrays.asList("Gaming / RPG", "Holiday"),
            Arrays.asList("poison", "moonshine"),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon bottle_tonic_skull_outline() {
    return MdiIcon.create(
        "mdi-bottle-tonic-skull-outline",
        new MdiMeta(
            "bottle-tonic-skull-outline",
            "F1133",
            Arrays.asList("Gaming / RPG", "Holiday"),
            Arrays.asList("poison-outline", "moonshine-outline"),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon bottle_wine() {
    return MdiIcon.create(
        "mdi-bottle-wine",
        new MdiMeta(
            "bottle-wine",
            "F0854",
            Arrays.asList("Food / Drink"),
            Arrays.asList(),
            "James Coyle",
            "2.1.99"));
  }

  public static MdiIcon bottle_wine_outline() {
    return MdiIcon.create(
        "mdi-bottle-wine-outline",
        new MdiMeta(
            "bottle-wine-outline",
            "F1310",
            Arrays.asList("Food / Drink"),
            Arrays.asList(),
            "Simran",
            "4.8.95"));
  }

  public static MdiIcon bow_arrow() {
    return MdiIcon.create(
        "mdi-bow-arrow",
        new MdiMeta(
            "bow-arrow",
            "F1841",
            Arrays.asList("Gaming / RPG", "Sport"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon bow_tie() {
    return MdiIcon.create(
        "mdi-bow-tie",
        new MdiMeta(
            "bow-tie",
            "F0678",
            Arrays.asList("Clothing"),
            Arrays.asList(),
            "Thomas Hunsaker",
            "1.7.12"));
  }

  public static MdiIcon bowl() {
    return MdiIcon.create(
        "mdi-bowl",
        new MdiMeta(
            "bowl",
            "F028E",
            Arrays.asList("Food / Drink"),
            Arrays.asList(),
            "Michael Irigoyen",
            "1.5.54"));
  }

  public static MdiIcon bowl_mix() {
    return MdiIcon.create(
        "mdi-bowl-mix",
        new MdiMeta(
            "bowl-mix",
            "F0617",
            Arrays.asList("Food / Drink"),
            Arrays.asList("mixing-bowl"),
            "Austin Andrews",
            "1.6.50"));
  }

  public static MdiIcon bowl_mix_outline() {
    return MdiIcon.create(
        "mdi-bowl-mix-outline",
        new MdiMeta(
            "bowl-mix-outline",
            "F02E4",
            Arrays.asList("Food / Drink"),
            Arrays.asList("mixing-bowl-outline"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon bowl_outline() {
    return MdiIcon.create(
        "mdi-bowl-outline",
        new MdiMeta(
            "bowl-outline",
            "F02A9",
            Arrays.asList("Food / Drink"),
            Arrays.asList(),
            "Michael Irigoyen",
            "1.5.54"));
  }

  public static MdiIcon bowling() {
    return MdiIcon.create(
        "mdi-bowling",
        new MdiMeta(
            "bowling",
            "F00D3",
            Arrays.asList("Sport"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  @Deprecated
  public static MdiIcon box() {
    return MdiIcon.create(
        "mdi-box",
        new MdiMeta(
            "box",
            "F00D4",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "1.5.54"));
  }

  public static MdiIcon box_cutter() {
    return MdiIcon.create(
        "mdi-box-cutter",
        new MdiMeta(
            "box-cutter",
            "F00D5",
            Arrays.asList("Hardware / Tools"),
            Arrays.asList("stanley-knife"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon box_cutter_off() {
    return MdiIcon.create(
        "mdi-box-cutter-off",
        new MdiMeta(
            "box-cutter-off", "F0B4A", Arrays.asList(), Arrays.asList(), "nilsfast", "2.8.94"));
  }

  public static MdiIcon box_shadow() {
    return MdiIcon.create(
        "mdi-box-shadow",
        new MdiMeta("box-shadow", "F0637", Arrays.asList(), Arrays.asList(), "Simran", "1.6.50"));
  }

  public static MdiIcon boxing_glove() {
    return MdiIcon.create(
        "mdi-boxing-glove",
        new MdiMeta(
            "boxing-glove",
            "F0B65",
            Arrays.asList("Sport"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.0.39"));
  }

  public static MdiIcon braille() {
    return MdiIcon.create(
        "mdi-braille",
        new MdiMeta(
            "braille",
            "F09D0",
            Arrays.asList(),
            Arrays.asList("touch-reading", "hand-reading"),
            "Michael Richins",
            "2.5.94"));
  }

  public static MdiIcon brain() {
    return MdiIcon.create(
        "mdi-brain",
        new MdiMeta(
            "brain",
            "F09D1",
            Arrays.asList("Medical / Hospital"),
            Arrays.asList(),
            "Michael Richins",
            "2.5.94"));
  }

  public static MdiIcon bread_slice() {
    return MdiIcon.create(
        "mdi-bread-slice",
        new MdiMeta(
            "bread-slice",
            "F0CEE",
            Arrays.asList("Food / Drink"),
            Arrays.asList(),
            "Nick",
            "3.3.92"));
  }

  public static MdiIcon bread_slice_outline() {
    return MdiIcon.create(
        "mdi-bread-slice-outline",
        new MdiMeta(
            "bread-slice-outline",
            "F0CEF",
            Arrays.asList("Food / Drink"),
            Arrays.asList(),
            "Nick",
            "3.3.92"));
  }

  public static MdiIcon bridge() {
    return MdiIcon.create(
        "mdi-bridge",
        new MdiMeta(
            "bridge",
            "F0618",
            Arrays.asList("Places"),
            Arrays.asList(),
            "Austin Andrews",
            "1.6.50"));
  }

  public static MdiIcon briefcase() {
    return MdiIcon.create(
        "mdi-briefcase",
        new MdiMeta(
            "briefcase", "F00D6", Arrays.asList(), Arrays.asList("work"), "Google", "1.5.54"));
  }

  public static MdiIcon briefcase_account() {
    return MdiIcon.create(
        "mdi-briefcase-account",
        new MdiMeta(
            "briefcase-account",
            "F0CF0",
            Arrays.asList("Account / User"),
            Arrays.asList("briefcase-person", "briefcase-user"),
            "Michael Irigoyen",
            "3.3.92"));
  }

  public static MdiIcon briefcase_account_outline() {
    return MdiIcon.create(
        "mdi-briefcase-account-outline",
        new MdiMeta(
            "briefcase-account-outline",
            "F0CF1",
            Arrays.asList("Account / User"),
            Arrays.asList("briefcase-person-outline", "briefcase-user-outline"),
            "Michael Irigoyen",
            "3.3.92"));
  }

  public static MdiIcon briefcase_arrow_left_right() {
    return MdiIcon.create(
        "mdi-briefcase-arrow-left-right",
        new MdiMeta(
            "briefcase-arrow-left-right",
            "F1A8D",
            Arrays.asList(),
            Arrays.asList("briefcase-transfer", "briefcase-exchange", "briefcase-swap"),
            "Michael Irigoyen",
            "6.8.96"));
  }

  public static MdiIcon briefcase_arrow_left_right_outline() {
    return MdiIcon.create(
        "mdi-briefcase-arrow-left-right-outline",
        new MdiMeta(
            "briefcase-arrow-left-right-outline",
            "F1A8E",
            Arrays.asList(),
            Arrays.asList(
                "briefcase-exchange-outline",
                "briefcase-transfer-outline",
                "briefcase-swap-outline"),
            "Michael Irigoyen",
            "6.8.96"));
  }

  public static MdiIcon briefcase_arrow_up_down() {
    return MdiIcon.create(
        "mdi-briefcase-arrow-up-down",
        new MdiMeta(
            "briefcase-arrow-up-down",
            "F1A8F",
            Arrays.asList(),
            Arrays.asList("briefcase-exchange", "briefcase-transfer", "briefcase-swap"),
            "Michael Irigoyen",
            "6.8.96"));
  }

  public static MdiIcon briefcase_arrow_up_down_outline() {
    return MdiIcon.create(
        "mdi-briefcase-arrow-up-down-outline",
        new MdiMeta(
            "briefcase-arrow-up-down-outline",
            "F1A90",
            Arrays.asList(),
            Arrays.asList(
                "briefcase-exchange-outline",
                "briefcase-transfer-outline",
                "briefcase-swap-outline"),
            "Michael Irigoyen",
            "6.8.96"));
  }

  public static MdiIcon briefcase_check() {
    return MdiIcon.create(
        "mdi-briefcase-check",
        new MdiMeta(
            "briefcase-check",
            "F00D7",
            Arrays.asList(),
            Arrays.asList("briefcase-tick"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon briefcase_check_outline() {
    return MdiIcon.create(
        "mdi-briefcase-check-outline",
        new MdiMeta(
            "briefcase-check-outline",
            "F131E",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.8.95"));
  }

  public static MdiIcon briefcase_clock() {
    return MdiIcon.create(
        "mdi-briefcase-clock",
        new MdiMeta(
            "briefcase-clock",
            "F10D0",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Richins",
            "4.3.95"));
  }

  public static MdiIcon briefcase_clock_outline() {
    return MdiIcon.create(
        "mdi-briefcase-clock-outline",
        new MdiMeta(
            "briefcase-clock-outline",
            "F10D1",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Richins",
            "4.3.95"));
  }

  public static MdiIcon briefcase_download() {
    return MdiIcon.create(
        "mdi-briefcase-download",
        new MdiMeta(
            "briefcase-download", "F00D8", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon briefcase_download_outline() {
    return MdiIcon.create(
        "mdi-briefcase-download-outline",
        new MdiMeta(
            "briefcase-download-outline",
            "F0C3D",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon briefcase_edit() {
    return MdiIcon.create(
        "mdi-briefcase-edit",
        new MdiMeta(
            "briefcase-edit",
            "F0A98",
            Arrays.asList("Edit / Modify"),
            Arrays.asList(),
            "theminanaji",
            "2.7.94"));
  }

  public static MdiIcon briefcase_edit_outline() {
    return MdiIcon.create(
        "mdi-briefcase-edit-outline",
        new MdiMeta(
            "briefcase-edit-outline",
            "F0C3E",
            Arrays.asList("Edit / Modify"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon briefcase_eye() {
    return MdiIcon.create(
        "mdi-briefcase-eye",
        new MdiMeta(
            "briefcase-eye",
            "F17D9",
            Arrays.asList(),
            Arrays.asList("briefcase-view"),
            "Michael Irigoyen",
            "6.1.95"));
  }

  public static MdiIcon briefcase_eye_outline() {
    return MdiIcon.create(
        "mdi-briefcase-eye-outline",
        new MdiMeta(
            "briefcase-eye-outline",
            "F17DA",
            Arrays.asList(),
            Arrays.asList("briefcase-view-outline"),
            "Andrej Sharapov",
            "6.1.95"));
  }

  public static MdiIcon briefcase_minus() {
    return MdiIcon.create(
        "mdi-briefcase-minus",
        new MdiMeta(
            "briefcase-minus",
            "F0A2A",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.6.95"));
  }

  public static MdiIcon briefcase_minus_outline() {
    return MdiIcon.create(
        "mdi-briefcase-minus-outline",
        new MdiMeta(
            "briefcase-minus-outline",
            "F0C3F",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon briefcase_off() {
    return MdiIcon.create(
        "mdi-briefcase-off",
        new MdiMeta(
            "briefcase-off",
            "F1658",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon briefcase_off_outline() {
    return MdiIcon.create(
        "mdi-briefcase-off-outline",
        new MdiMeta(
            "briefcase-off-outline",
            "F1659",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon briefcase_outline() {
    return MdiIcon.create(
        "mdi-briefcase-outline",
        new MdiMeta(
            "briefcase-outline",
            "F0814",
            Arrays.asList(),
            Arrays.asList("work-outline"),
            "Google",
            "2.1.19"));
  }

  public static MdiIcon briefcase_plus() {
    return MdiIcon.create(
        "mdi-briefcase-plus",
        new MdiMeta(
            "briefcase-plus",
            "F0A2B",
            Arrays.asList(),
            Arrays.asList("briefcase-add"),
            "Michael Irigoyen",
            "2.6.95"));
  }

  public static MdiIcon briefcase_plus_outline() {
    return MdiIcon.create(
        "mdi-briefcase-plus-outline",
        new MdiMeta(
            "briefcase-plus-outline",
            "F0C40",
            Arrays.asList(),
            Arrays.asList("briefcase-add-outline"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon briefcase_remove() {
    return MdiIcon.create(
        "mdi-briefcase-remove",
        new MdiMeta(
            "briefcase-remove",
            "F0A2C",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.6.95"));
  }

  public static MdiIcon briefcase_remove_outline() {
    return MdiIcon.create(
        "mdi-briefcase-remove-outline",
        new MdiMeta(
            "briefcase-remove-outline",
            "F0C41",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon briefcase_search() {
    return MdiIcon.create(
        "mdi-briefcase-search",
        new MdiMeta(
            "briefcase-search",
            "F0A2D",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "2.6.95"));
  }

  public static MdiIcon briefcase_search_outline() {
    return MdiIcon.create(
        "mdi-briefcase-search-outline",
        new MdiMeta(
            "briefcase-search-outline",
            "F0C42",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon briefcase_upload() {
    return MdiIcon.create(
        "mdi-briefcase-upload",
        new MdiMeta(
            "briefcase-upload",
            "F00D9",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon briefcase_upload_outline() {
    return MdiIcon.create(
        "mdi-briefcase-upload-outline",
        new MdiMeta(
            "briefcase-upload-outline",
            "F0C43",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon briefcase_variant() {
    return MdiIcon.create(
        "mdi-briefcase-variant",
        new MdiMeta(
            "briefcase-variant", "F1494", Arrays.asList(), Arrays.asList(), "Google", "5.3.45"));
  }

  public static MdiIcon briefcase_variant_off() {
    return MdiIcon.create(
        "mdi-briefcase-variant-off",
        new MdiMeta(
            "briefcase-variant-off",
            "F165A",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon briefcase_variant_off_outline() {
    return MdiIcon.create(
        "mdi-briefcase-variant-off-outline",
        new MdiMeta(
            "briefcase-variant-off-outline",
            "F165B",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon briefcase_variant_outline() {
    return MdiIcon.create(
        "mdi-briefcase-variant-outline",
        new MdiMeta(
            "briefcase-variant-outline",
            "F1495",
            Arrays.asList(),
            Arrays.asList(),
            "Google",
            "5.3.45"));
  }

  public static MdiIcon brightness_1() {
    return MdiIcon.create(
        "mdi-brightness-1",
        new MdiMeta("brightness-1", "F00DA", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon brightness_2() {
    return MdiIcon.create(
        "mdi-brightness-2",
        new MdiMeta("brightness-2", "F00DB", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon brightness_3() {
    return MdiIcon.create(
        "mdi-brightness-3",
        new MdiMeta("brightness-3", "F00DC", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon brightness_4() {
    return MdiIcon.create(
        "mdi-brightness-4",
        new MdiMeta(
            "brightness-4",
            "F00DD",
            Arrays.asList(),
            Arrays.asList("theme-light-dark"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon brightness_5() {
    return MdiIcon.create(
        "mdi-brightness-5",
        new MdiMeta(
            "brightness-5",
            "F00DE",
            Arrays.asList(),
            Arrays.asList("brightness-low"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon brightness_6() {
    return MdiIcon.create(
        "mdi-brightness-6",
        new MdiMeta(
            "brightness-6",
            "F00DF",
            Arrays.asList(),
            Arrays.asList("brightness-medium", "theme-light-dark"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon brightness_7() {
    return MdiIcon.create(
        "mdi-brightness-7",
        new MdiMeta(
            "brightness-7",
            "F00E0",
            Arrays.asList("Home Automation"),
            Arrays.asList("brightness-high"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon brightness_auto() {
    return MdiIcon.create(
        "mdi-brightness-auto",
        new MdiMeta(
            "brightness-auto", "F00E1", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon brightness_percent() {
    return MdiIcon.create(
        "mdi-brightness-percent",
        new MdiMeta(
            "brightness-percent",
            "F0CF2",
            Arrays.asList("Shopping"),
            Arrays.asList("discount", "sale"),
            "Michael Irigoyen",
            "3.3.92"));
  }

  public static MdiIcon broadcast() {
    return MdiIcon.create(
        "mdi-broadcast",
        new MdiMeta(
            "broadcast",
            "F1720",
            Arrays.asList("Weather"),
            Arrays.asList("signal"),
            "Google",
            "5.9.55"));
  }

  public static MdiIcon broadcast_off() {
    return MdiIcon.create(
        "mdi-broadcast-off",
        new MdiMeta(
            "broadcast-off",
            "F1721",
            Arrays.asList("Weather"),
            Arrays.asList("signal-off"),
            "Google",
            "5.9.55"));
  }

  public static MdiIcon broom() {
    return MdiIcon.create(
        "mdi-broom",
        new MdiMeta(
            "broom", "F00E2", Arrays.asList(), Arrays.asList(), "Austin Andrews", "1.5.54"));
  }

  public static MdiIcon brush() {
    return MdiIcon.create(
        "mdi-brush",
        new MdiMeta(
            "brush",
            "F00E3",
            Arrays.asList("Drawing / Art"),
            Arrays.asList("paintbrush"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon brush_off() {
    return MdiIcon.create(
        "mdi-brush-off",
        new MdiMeta(
            "brush-off", "F1771", Arrays.asList(), Arrays.asList(), "Teodor Sandu", "6.1.95"));
  }

  public static MdiIcon brush_outline() {
    return MdiIcon.create(
        "mdi-brush-outline",
        new MdiMeta(
            "brush-outline",
            "F1A0D",
            Arrays.asList("Drawing / Art"),
            Arrays.asList("paintbrush-outline"),
            "Google",
            "6.6.96"));
  }

  public static MdiIcon brush_variant() {
    return MdiIcon.create(
        "mdi-brush-variant",
        new MdiMeta(
            "brush-variant",
            "F1813",
            Arrays.asList("Drawing / Art"),
            Arrays.asList("paintbrush"),
            "Google",
            "6.1.95"));
  }

  public static MdiIcon bucket() {
    return MdiIcon.create(
        "mdi-bucket",
        new MdiMeta(
            "bucket", "F1415", Arrays.asList(), Arrays.asList(), "Austin Andrews", "5.1.45"));
  }

  public static MdiIcon bucket_outline() {
    return MdiIcon.create(
        "mdi-bucket-outline",
        new MdiMeta(
            "bucket-outline",
            "F1416",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "5.1.45"));
  }

  public static MdiIcon buffet() {
    return MdiIcon.create(
        "mdi-buffet",
        new MdiMeta(
            "buffet",
            "F0578",
            Arrays.asList("Home Automation"),
            Arrays.asList("sideboard"),
            "nilsfast",
            "1.5.54"));
  }

  public static MdiIcon bug() {
    return MdiIcon.create(
        "mdi-bug",
        new MdiMeta(
            "bug",
            "F00E4",
            Arrays.asList("Nature", "Animal"),
            Arrays.asList("bug-report"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon bug_check() {
    return MdiIcon.create(
        "mdi-bug-check",
        new MdiMeta(
            "bug-check",
            "F0A2E",
            Arrays.asList("Animal"),
            Arrays.asList("bug-tick"),
            "Michael Richins",
            "2.6.95"));
  }

  public static MdiIcon bug_check_outline() {
    return MdiIcon.create(
        "mdi-bug-check-outline",
        new MdiMeta(
            "bug-check-outline",
            "F0A2F",
            Arrays.asList("Animal"),
            Arrays.asList("bug-tick-outline"),
            "Michael Richins",
            "2.6.95"));
  }

  public static MdiIcon bug_outline() {
    return MdiIcon.create(
        "mdi-bug-outline",
        new MdiMeta(
            "bug-outline",
            "F0A30",
            Arrays.asList("Nature", "Animal"),
            Arrays.asList(),
            "Google",
            "2.6.95"));
  }

  public static MdiIcon bug_pause() {
    return MdiIcon.create(
        "mdi-bug-pause",
        new MdiMeta(
            "bug-pause", "F1AF5", Arrays.asList(), Arrays.asList(), "Michael Irigoyen", "6.9.96"));
  }

  public static MdiIcon bug_pause_outline() {
    return MdiIcon.create(
        "mdi-bug-pause-outline",
        new MdiMeta(
            "bug-pause-outline",
            "F1AF6",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.9.96"));
  }

  public static MdiIcon bug_play() {
    return MdiIcon.create(
        "mdi-bug-play",
        new MdiMeta(
            "bug-play",
            "F1AF7",
            Arrays.asList(),
            Arrays.asList("bug-start"),
            "Austin Andrews",
            "6.9.96"));
  }

  public static MdiIcon bug_play_outline() {
    return MdiIcon.create(
        "mdi-bug-play-outline",
        new MdiMeta(
            "bug-play-outline",
            "F1AF8",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.9.96"));
  }

  public static MdiIcon bug_stop() {
    return MdiIcon.create(
        "mdi-bug-stop",
        new MdiMeta(
            "bug-stop", "F1AF9", Arrays.asList(), Arrays.asList(), "Michael Irigoyen", "6.9.96"));
  }

  public static MdiIcon bug_stop_outline() {
    return MdiIcon.create(
        "mdi-bug-stop-outline",
        new MdiMeta(
            "bug-stop-outline",
            "F1AFA",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.9.96"));
  }

  public static MdiIcon bugle() {
    return MdiIcon.create(
        "mdi-bugle",
        new MdiMeta(
            "bugle",
            "F0DB4",
            Arrays.asList("Automotive", "Music"),
            Arrays.asList("car-horn"),
            "Michael Irigoyen",
            "3.5.94"));
  }

  public static MdiIcon bulkhead_light() {
    return MdiIcon.create(
        "mdi-bulkhead-light",
        new MdiMeta(
            "bulkhead-light",
            "F1A2F",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.7.96"));
  }

  public static MdiIcon bulldozer() {
    return MdiIcon.create(
        "mdi-bulldozer",
        new MdiMeta(
            "bulldozer",
            "F0B22",
            Arrays.asList("Hardware / Tools"),
            Arrays.asList(),
            "Louistwee",
            "2.8.94"));
  }

  public static MdiIcon bullet() {
    return MdiIcon.create(
        "mdi-bullet",
        new MdiMeta(
            "bullet", "F0CF3", Arrays.asList(), Arrays.asList(), "Michael Irigoyen", "3.3.92"));
  }

  public static MdiIcon bulletin_board() {
    return MdiIcon.create(
        "mdi-bulletin-board",
        new MdiMeta(
            "bulletin-board",
            "F00E5",
            Arrays.asList(),
            Arrays.asList("notice-board"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon bullhorn() {
    return MdiIcon.create(
        "mdi-bullhorn",
        new MdiMeta(
            "bullhorn",
            "F00E6",
            Arrays.asList(),
            Arrays.asList("announcement", "megaphone", "loudspeaker"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon bullhorn_outline() {
    return MdiIcon.create(
        "mdi-bullhorn-outline",
        new MdiMeta(
            "bullhorn-outline",
            "F0B23",
            Arrays.asList(),
            Arrays.asList("announcement-outline", "megaphone-outline", "loudspeaker-outline"),
            "Google",
            "2.8.94"));
  }

  public static MdiIcon bullhorn_variant() {
    return MdiIcon.create(
        "mdi-bullhorn-variant",
        new MdiMeta(
            "bullhorn-variant",
            "F196E",
            Arrays.asList(),
            Arrays.asList("announcement", "megaphone", "loudspeaker"),
            "nlsve",
            "6.5.95"));
  }

  public static MdiIcon bullhorn_variant_outline() {
    return MdiIcon.create(
        "mdi-bullhorn-variant-outline",
        new MdiMeta(
            "bullhorn-variant-outline",
            "F196F",
            Arrays.asList(),
            Arrays.asList("announcement-outline", "megaphone-outline", "loudspeaker-outline"),
            "nlsve",
            "6.5.95"));
  }

  public static MdiIcon bullseye() {
    return MdiIcon.create(
        "mdi-bullseye",
        new MdiMeta(
            "bullseye",
            "F05DD",
            Arrays.asList("Sport"),
            Arrays.asList("target"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon bullseye_arrow() {
    return MdiIcon.create(
        "mdi-bullseye-arrow",
        new MdiMeta(
            "bullseye-arrow",
            "F08C9",
            Arrays.asList("Sport"),
            Arrays.asList("target-arrow"),
            "Simran",
            "2.3.50"));
  }

  @Deprecated
  public static MdiIcon bulma() {
    return MdiIcon.create(
        "mdi-bulma",
        new MdiMeta(
            "bulma",
            "F12E7",
            Arrays.asList("Developer / Languages", "Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "4.8.95"));
  }

  public static MdiIcon bunk_bed() {
    return MdiIcon.create(
        "mdi-bunk-bed",
        new MdiMeta(
            "bunk-bed",
            "F1302",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Simran",
            "4.8.95"));
  }

  public static MdiIcon bunk_bed_outline() {
    return MdiIcon.create(
        "mdi-bunk-bed-outline",
        new MdiMeta(
            "bunk-bed-outline",
            "F0097",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon bus() {
    return MdiIcon.create(
        "mdi-bus",
        new MdiMeta(
            "bus",
            "F00E7",
            Arrays.asList("Navigation", "Transportation + Road"),
            Arrays.asList("directions-bus"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon bus_alert() {
    return MdiIcon.create(
        "mdi-bus-alert",
        new MdiMeta(
            "bus-alert",
            "F0A99",
            Arrays.asList("Alert / Error", "Transportation + Road"),
            Arrays.asList("bus-warning"),
            "Google",
            "2.7.94"));
  }

  public static MdiIcon bus_articulated_end() {
    return MdiIcon.create(
        "mdi-bus-articulated-end",
        new MdiMeta(
            "bus-articulated-end",
            "F079C",
            Arrays.asList("Transportation + Road"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.0.46"));
  }

  public static MdiIcon bus_articulated_front() {
    return MdiIcon.create(
        "mdi-bus-articulated-front",
        new MdiMeta(
            "bus-articulated-front",
            "F079D",
            Arrays.asList("Transportation + Road"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.0.46"));
  }

  public static MdiIcon bus_clock() {
    return MdiIcon.create(
        "mdi-bus-clock",
        new MdiMeta(
            "bus-clock",
            "F08CA",
            Arrays.asList("Date / Time", "Transportation + Road"),
            Arrays.asList("departure-board"),
            "Google",
            "2.3.50"));
  }

  public static MdiIcon bus_double_decker() {
    return MdiIcon.create(
        "mdi-bus-double-decker",
        new MdiMeta(
            "bus-double-decker",
            "F079E",
            Arrays.asList("Transportation + Road"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.0.46"));
  }

  public static MdiIcon bus_electric() {
    return MdiIcon.create(
        "mdi-bus-electric",
        new MdiMeta(
            "bus-electric",
            "F191D",
            Arrays.asList("Transportation + Road"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon bus_marker() {
    return MdiIcon.create(
        "mdi-bus-marker",
        new MdiMeta(
            "bus-marker",
            "F1212",
            Arrays.asList("Navigation"),
            Arrays.asList("bus-location", "bus-stop"),
            "Michael Richins",
            "4.6.95"));
  }

  public static MdiIcon bus_multiple() {
    return MdiIcon.create(
        "mdi-bus-multiple",
        new MdiMeta(
            "bus-multiple",
            "F0F3F",
            Arrays.asList("Transportation + Road"),
            Arrays.asList("fleet"),
            "Michael Richins",
            "3.9.97"));
  }

  public static MdiIcon bus_school() {
    return MdiIcon.create(
        "mdi-bus-school",
        new MdiMeta(
            "bus-school",
            "F079F",
            Arrays.asList("Transportation + Road"),
            Arrays.asList("education"),
            "GreenTurtwig",
            "2.0.46"));
  }

  public static MdiIcon bus_side() {
    return MdiIcon.create(
        "mdi-bus-side",
        new MdiMeta(
            "bus-side",
            "F07A0",
            Arrays.asList("Transportation + Road"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.0.46"));
  }

  public static MdiIcon bus_stop() {
    return MdiIcon.create(
        "mdi-bus-stop",
        new MdiMeta(
            "bus-stop",
            "F1012",
            Arrays.asList("Transportation + Road", "Navigation"),
            Arrays.asList(),
            "Michael Richins",
            "4.1.95"));
  }

  public static MdiIcon bus_stop_covered() {
    return MdiIcon.create(
        "mdi-bus-stop-covered",
        new MdiMeta(
            "bus-stop-covered",
            "F1013",
            Arrays.asList("Transportation + Road", "Navigation"),
            Arrays.asList(),
            "Michael Richins",
            "4.1.95"));
  }

  public static MdiIcon bus_stop_uncovered() {
    return MdiIcon.create(
        "mdi-bus-stop-uncovered",
        new MdiMeta(
            "bus-stop-uncovered",
            "F1014",
            Arrays.asList("Transportation + Road", "Navigation"),
            Arrays.asList(),
            "Michael Richins",
            "4.1.95"));
  }

  public static MdiIcon butterfly() {
    return MdiIcon.create(
        "mdi-butterfly",
        new MdiMeta(
            "butterfly",
            "F1589",
            Arrays.asList("Nature", "Animal"),
            Arrays.asList(),
            "Nicolas Gres",
            "5.5.55"));
  }

  public static MdiIcon butterfly_outline() {
    return MdiIcon.create(
        "mdi-butterfly-outline",
        new MdiMeta(
            "butterfly-outline",
            "F158A",
            Arrays.asList("Nature", "Animal"),
            Arrays.asList(),
            "Nicolas Gres",
            "5.5.55"));
  }

  public static MdiIcon button_cursor() {
    return MdiIcon.create(
        "mdi-button-cursor",
        new MdiMeta(
            "button-cursor",
            "F1B4F",
            Arrays.asList("Form"),
            Arrays.asList(),
            "Andrej Sharapov",
            "6.9.96"));
  }

  public static MdiIcon button_pointer() {
    return MdiIcon.create(
        "mdi-button-pointer",
        new MdiMeta(
            "button-pointer",
            "F1B50",
            Arrays.asList("Form"),
            Arrays.asList(),
            "Andrej Sharapov",
            "6.9.96"));
  }

  public static MdiIcon cabin_a_frame() {
    return MdiIcon.create(
        "mdi-cabin-a-frame",
        new MdiMeta(
            "cabin-a-frame",
            "F188C",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Jeff Anders",
            "6.2.95"));
  }

  public static MdiIcon cable_data() {
    return MdiIcon.create(
        "mdi-cable-data",
        new MdiMeta(
            "cable-data", "F1394", Arrays.asList(), Arrays.asList(), "GreenTurtwig", "5.0.45"));
  }

  public static MdiIcon cached() {
    return MdiIcon.create(
        "mdi-cached",
        new MdiMeta(
            "cached",
            "F00E8",
            Arrays.asList("Arrow"),
            Arrays.asList("counterclockwise-arrows", "circular-arrows", "circle-arrows", "sync"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cactus() {
    return MdiIcon.create(
        "mdi-cactus",
        new MdiMeta(
            "cactus",
            "F0DB5",
            Arrays.asList("Nature"),
            Arrays.asList(),
            "Andrew Nenakhov",
            "3.5.94"));
  }

  public static MdiIcon cake() {
    return MdiIcon.create(
        "mdi-cake",
        new MdiMeta(
            "cake",
            "F00E9",
            Arrays.asList("Holiday", "Food / Drink"),
            Arrays.asList("birthday-cake"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cake_layered() {
    return MdiIcon.create(
        "mdi-cake-layered",
        new MdiMeta(
            "cake-layered",
            "F00EA",
            Arrays.asList("Holiday", "Food / Drink"),
            Arrays.asList("birthday-cake"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cake_variant() {
    return MdiIcon.create(
        "mdi-cake-variant",
        new MdiMeta(
            "cake-variant",
            "F00EB",
            Arrays.asList("Holiday", "Food / Drink"),
            Arrays.asList("birthday-cake"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cake_variant_outline() {
    return MdiIcon.create(
        "mdi-cake-variant-outline",
        new MdiMeta(
            "cake-variant-outline",
            "F17F0",
            Arrays.asList("Holiday", "Food / Drink"),
            Arrays.asList("birthday-cake-outline"),
            "Google",
            "6.1.95"));
  }

  public static MdiIcon calculator() {
    return MdiIcon.create(
        "mdi-calculator",
        new MdiMeta(
            "calculator",
            "F00EC",
            Arrays.asList("Math"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon calculator_variant() {
    return MdiIcon.create(
        "mdi-calculator-variant",
        new MdiMeta(
            "calculator-variant",
            "F0A9A",
            Arrays.asList("Math"),
            Arrays.asList(),
            "Google",
            "2.7.94"));
  }

  public static MdiIcon calculator_variant_outline() {
    return MdiIcon.create(
        "mdi-calculator-variant-outline",
        new MdiMeta(
            "calculator-variant-outline",
            "F15A6",
            Arrays.asList("Math"),
            Arrays.asList(),
            "Google",
            "5.5.55"));
  }

  public static MdiIcon calendar() {
    return MdiIcon.create(
        "mdi-calendar",
        new MdiMeta(
            "calendar",
            "F00ED",
            Arrays.asList("Date / Time"),
            Arrays.asList("event", "insert-invitation"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon calendar_account() {
    return MdiIcon.create(
        "mdi-calendar-account",
        new MdiMeta(
            "calendar-account",
            "F0ED7",
            Arrays.asList("Date / Time", "Account / User"),
            Arrays.asList("calendar-user"),
            "Michael Richins",
            "3.8.95"));
  }

  public static MdiIcon calendar_account_outline() {
    return MdiIcon.create(
        "mdi-calendar-account-outline",
        new MdiMeta(
            "calendar-account-outline",
            "F0ED8",
            Arrays.asList("Date / Time", "Account / User"),
            Arrays.asList("calendar-user-outline"),
            "Michael Richins",
            "3.8.95"));
  }

  public static MdiIcon calendar_alert() {
    return MdiIcon.create(
        "mdi-calendar-alert",
        new MdiMeta(
            "calendar-alert",
            "F0A31",
            Arrays.asList("Date / Time", "Alert / Error"),
            Arrays.asList("event-alert", "calendar-warning"),
            "Simran",
            "2.6.95"));
  }

  public static MdiIcon calendar_alert_outline() {
    return MdiIcon.create(
        "mdi-calendar-alert-outline",
        new MdiMeta(
            "calendar-alert-outline",
            "F1B62",
            Arrays.asList("Date / Time", "Alert / Error"),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon calendar_arrow_left() {
    return MdiIcon.create(
        "mdi-calendar-arrow-left",
        new MdiMeta(
            "calendar-arrow-left",
            "F1134",
            Arrays.asList("Date / Time"),
            Arrays.asList("reschedule"),
            "Terren",
            "4.4.95"));
  }

  public static MdiIcon calendar_arrow_right() {
    return MdiIcon.create(
        "mdi-calendar-arrow-right",
        new MdiMeta(
            "calendar-arrow-right",
            "F1135",
            Arrays.asList("Date / Time"),
            Arrays.asList("reschedule"),
            "Terren",
            "4.4.95"));
  }

  public static MdiIcon calendar_badge() {
    return MdiIcon.create(
        "mdi-calendar-badge",
        new MdiMeta(
            "calendar-badge",
            "F1B9D",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon calendar_badge_outline() {
    return MdiIcon.create(
        "mdi-calendar-badge-outline",
        new MdiMeta(
            "calendar-badge-outline",
            "F1B9E",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon calendar_blank() {
    return MdiIcon.create(
        "mdi-calendar-blank",
        new MdiMeta(
            "calendar-blank",
            "F00EE",
            Arrays.asList("Date / Time"),
            Arrays.asList("calendar-today"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon calendar_blank_multiple() {
    return MdiIcon.create(
        "mdi-calendar-blank-multiple",
        new MdiMeta(
            "calendar-blank-multiple",
            "F1073",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "James Coyle",
            "4.2.95"));
  }

  public static MdiIcon calendar_blank_outline() {
    return MdiIcon.create(
        "mdi-calendar-blank-outline",
        new MdiMeta(
            "calendar-blank-outline",
            "F0B66",
            Arrays.asList("Date / Time"),
            Arrays.asList("event-blank-outline"),
            "Google",
            "3.0.39"));
  }

  public static MdiIcon calendar_check() {
    return MdiIcon.create(
        "mdi-calendar-check",
        new MdiMeta(
            "calendar-check",
            "F00EF",
            Arrays.asList("Date / Time"),
            Arrays.asList(
                "event-available", "calendar-task", "calendar-tick", "event-tick", "event-check"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon calendar_check_outline() {
    return MdiIcon.create(
        "mdi-calendar-check-outline",
        new MdiMeta(
            "calendar-check-outline",
            "F0C44",
            Arrays.asList("Date / Time"),
            Arrays.asList(
                "event-available-outline",
                "event-check-outline",
                "event-tick-outline",
                "calendar-task-outline",
                "calendar-tick-outline"),
            "Google",
            "3.2.89"));
  }

  public static MdiIcon calendar_clock() {
    return MdiIcon.create(
        "mdi-calendar-clock",
        new MdiMeta(
            "calendar-clock",
            "F00F0",
            Arrays.asList("Date / Time"),
            Arrays.asList("event-clock", "event-time", "calendar-time"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon calendar_clock_outline() {
    return MdiIcon.create(
        "mdi-calendar-clock-outline",
        new MdiMeta(
            "calendar-clock-outline",
            "F16E1",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "GreenTurtwig",
            "5.9.55"));
  }

  public static MdiIcon calendar_collapse_horizontal() {
    return MdiIcon.create(
        "mdi-calendar-collapse-horizontal",
        new MdiMeta(
            "calendar-collapse-horizontal",
            "F189D",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Austin Andrews",
            "6.3.95"));
  }

  public static MdiIcon calendar_collapse_horizontal_outline() {
    return MdiIcon.create(
        "mdi-calendar-collapse-horizontal-outline",
        new MdiMeta(
            "calendar-collapse-horizontal-outline",
            "F1B63",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon calendar_cursor() {
    return MdiIcon.create(
        "mdi-calendar-cursor",
        new MdiMeta(
            "calendar-cursor",
            "F157B",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.5.55"));
  }

  public static MdiIcon calendar_cursor_outline() {
    return MdiIcon.create(
        "mdi-calendar-cursor-outline",
        new MdiMeta(
            "calendar-cursor-outline",
            "F1B64",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon calendar_edit() {
    return MdiIcon.create(
        "mdi-calendar-edit",
        new MdiMeta(
            "calendar-edit",
            "F08A7",
            Arrays.asList("Date / Time", "Edit / Modify"),
            Arrays.asList("event-edit"),
            "Michael Richins",
            "2.2.43"));
  }

  public static MdiIcon calendar_edit_outline() {
    return MdiIcon.create(
        "mdi-calendar-edit-outline",
        new MdiMeta(
            "calendar-edit-outline",
            "F1B65",
            Arrays.asList("Date / Time", "Edit / Modify"),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon calendar_end() {
    return MdiIcon.create(
        "mdi-calendar-end",
        new MdiMeta(
            "calendar-end",
            "F166C",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Austin Andrews",
            "5.7.55"));
  }

  public static MdiIcon calendar_end_outline() {
    return MdiIcon.create(
        "mdi-calendar-end-outline",
        new MdiMeta(
            "calendar-end-outline",
            "F1B66",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon calendar_expand_horizontal() {
    return MdiIcon.create(
        "mdi-calendar-expand-horizontal",
        new MdiMeta(
            "calendar-expand-horizontal",
            "F189E",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Austin Andrews",
            "6.3.95"));
  }

  public static MdiIcon calendar_expand_horizontal_outline() {
    return MdiIcon.create(
        "mdi-calendar-expand-horizontal-outline",
        new MdiMeta(
            "calendar-expand-horizontal-outline",
            "F1B67",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon calendar_export() {
    return MdiIcon.create(
        "mdi-calendar-export",
        new MdiMeta(
            "calendar-export",
            "F0B24",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Richins",
            "2.8.94"));
  }

  public static MdiIcon calendar_export_outline() {
    return MdiIcon.create(
        "mdi-calendar-export-outline",
        new MdiMeta(
            "calendar-export-outline",
            "F1B68",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon calendar_filter() {
    return MdiIcon.create(
        "mdi-calendar-filter",
        new MdiMeta(
            "calendar-filter",
            "F1A32",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Andrej Sharapov",
            "6.7.96"));
  }

  public static MdiIcon calendar_filter_outline() {
    return MdiIcon.create(
        "mdi-calendar-filter-outline",
        new MdiMeta(
            "calendar-filter-outline",
            "F1A33",
            Arrays.asList("Date / Time"),
            Arrays.asList("event-week-end-outline"),
            "Andrej Sharapov",
            "6.7.96"));
  }

  public static MdiIcon calendar_heart() {
    return MdiIcon.create(
        "mdi-calendar-heart",
        new MdiMeta(
            "calendar-heart",
            "F09D2",
            Arrays.asList("Date / Time"),
            Arrays.asList("event-heart"),
            "Austin Andrews",
            "2.5.94"));
  }

  public static MdiIcon calendar_heart_outline() {
    return MdiIcon.create(
        "mdi-calendar-heart-outline",
        new MdiMeta(
            "calendar-heart-outline",
            "F1B69",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon calendar_import() {
    return MdiIcon.create(
        "mdi-calendar-import",
        new MdiMeta(
            "calendar-import",
            "F0B25",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Richins",
            "2.8.94"));
  }

  public static MdiIcon calendar_import_outline() {
    return MdiIcon.create(
        "mdi-calendar-import-outline",
        new MdiMeta(
            "calendar-import-outline",
            "F1B6A",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon calendar_lock() {
    return MdiIcon.create(
        "mdi-calendar-lock",
        new MdiMeta(
            "calendar-lock",
            "F1641",
            Arrays.asList("Date / Time", "Lock"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon calendar_lock_open() {
    return MdiIcon.create(
        "mdi-calendar-lock-open",
        new MdiMeta(
            "calendar-lock-open",
            "F1B5B",
            Arrays.asList("Lock", "Date / Time"),
            Arrays.asList(),
            "Andrej Sharapov",
            "7.0.96"));
  }

  public static MdiIcon calendar_lock_open_outline() {
    return MdiIcon.create(
        "mdi-calendar-lock-open-outline",
        new MdiMeta(
            "calendar-lock-open-outline",
            "F1B5C",
            Arrays.asList("Lock", "Date / Time"),
            Arrays.asList(),
            "Andrej Sharapov",
            "7.0.96"));
  }

  public static MdiIcon calendar_lock_outline() {
    return MdiIcon.create(
        "mdi-calendar-lock-outline",
        new MdiMeta(
            "calendar-lock-outline",
            "F1642",
            Arrays.asList("Date / Time", "Lock"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon calendar_minus() {
    return MdiIcon.create(
        "mdi-calendar-minus",
        new MdiMeta(
            "calendar-minus",
            "F0D5C",
            Arrays.asList("Date / Time"),
            Arrays.asList("event-minus"),
            "ButchMonkey",
            "3.4.93"));
  }

  public static MdiIcon calendar_minus_outline() {
    return MdiIcon.create(
        "mdi-calendar-minus-outline",
        new MdiMeta(
            "calendar-minus-outline",
            "F1B6B",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon calendar_month() {
    return MdiIcon.create(
        "mdi-calendar-month",
        new MdiMeta(
            "calendar-month",
            "F0E17",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Terren",
            "3.6.95"));
  }

  public static MdiIcon calendar_month_outline() {
    return MdiIcon.create(
        "mdi-calendar-month-outline",
        new MdiMeta(
            "calendar-month-outline",
            "F0E18",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Terren",
            "3.6.95"));
  }

  public static MdiIcon calendar_multiple() {
    return MdiIcon.create(
        "mdi-calendar-multiple",
        new MdiMeta(
            "calendar-multiple",
            "F00F1",
            Arrays.asList("Date / Time"),
            Arrays.asList("event-multiple", "calendars", "events"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon calendar_multiple_check() {
    return MdiIcon.create(
        "mdi-calendar-multiple-check",
        new MdiMeta(
            "calendar-multiple-check",
            "F00F2",
            Arrays.asList("Date / Time"),
            Arrays.asList(
                "event-multiple-check",
                "calendar-multiple-tick",
                "calendars-check",
                "calendars-tick",
                "event-multiple-tick",
                "events-check",
                "events-tick"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon calendar_multiselect() {
    return MdiIcon.create(
        "mdi-calendar-multiselect",
        new MdiMeta(
            "calendar-multiselect",
            "F0A32",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Austin Andrews",
            "2.6.95"));
  }

  public static MdiIcon calendar_multiselect_outline() {
    return MdiIcon.create(
        "mdi-calendar-multiselect-outline",
        new MdiMeta(
            "calendar-multiselect-outline",
            "F1B55",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Andrej Sharapov",
            "7.0.96"));
  }

  public static MdiIcon calendar_outline() {
    return MdiIcon.create(
        "mdi-calendar-outline",
        new MdiMeta(
            "calendar-outline",
            "F0B67",
            Arrays.asList("Date / Time"),
            Arrays.asList("event-outline"),
            "Google",
            "3.0.39"));
  }

  public static MdiIcon calendar_plus() {
    return MdiIcon.create(
        "mdi-calendar-plus",
        new MdiMeta(
            "calendar-plus",
            "F00F3",
            Arrays.asList("Date / Time"),
            Arrays.asList("event-plus", "calendar-add", "event-add"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon calendar_plus_outline() {
    return MdiIcon.create(
        "mdi-calendar-plus-outline",
        new MdiMeta(
            "calendar-plus-outline",
            "F1B6C",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon calendar_question() {
    return MdiIcon.create(
        "mdi-calendar-question",
        new MdiMeta(
            "calendar-question",
            "F0692",
            Arrays.asList("Date / Time"),
            Arrays.asList("calendar-rsvp", "event-question", "calendar-help"),
            "Simran",
            "1.7.12"));
  }

  public static MdiIcon calendar_question_outline() {
    return MdiIcon.create(
        "mdi-calendar-question-outline",
        new MdiMeta(
            "calendar-question-outline",
            "F1B6D",
            Arrays.asList("Date / Time"),
            Arrays.asList("calendar-help-outline"),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon calendar_range() {
    return MdiIcon.create(
        "mdi-calendar-range",
        new MdiMeta(
            "calendar-range",
            "F0679",
            Arrays.asList("Date / Time"),
            Arrays.asList("date-range", "calendar-week", "event-range"),
            "Google",
            "1.7.12"));
  }

  public static MdiIcon calendar_range_outline() {
    return MdiIcon.create(
        "mdi-calendar-range-outline",
        new MdiMeta(
            "calendar-range-outline",
            "F0B68",
            Arrays.asList("Date / Time"),
            Arrays.asList("event-range-outline"),
            "Google",
            "3.0.39"));
  }

  public static MdiIcon calendar_refresh() {
    return MdiIcon.create(
        "mdi-calendar-refresh",
        new MdiMeta(
            "calendar-refresh",
            "F01E1",
            Arrays.asList("Date / Time"),
            Arrays.asList("calendar-repeat"),
            "Michael Irigoyen",
            "1.5.54"));
  }

  public static MdiIcon calendar_refresh_outline() {
    return MdiIcon.create(
        "mdi-calendar-refresh-outline",
        new MdiMeta(
            "calendar-refresh-outline",
            "F0203",
            Arrays.asList("Date / Time"),
            Arrays.asList("calendar-repeat-outline"),
            "Michael Irigoyen",
            "1.5.54"));
  }

  public static MdiIcon calendar_remove() {
    return MdiIcon.create(
        "mdi-calendar-remove",
        new MdiMeta(
            "calendar-remove",
            "F00F4",
            Arrays.asList("Date / Time"),
            Arrays.asList("event-busy", "event-remove"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon calendar_remove_outline() {
    return MdiIcon.create(
        "mdi-calendar-remove-outline",
        new MdiMeta(
            "calendar-remove-outline",
            "F0C45",
            Arrays.asList("Date / Time"),
            Arrays.asList("event-busy-outline", "event-remove-outline"),
            "Google",
            "3.2.89"));
  }

  public static MdiIcon calendar_search() {
    return MdiIcon.create(
        "mdi-calendar-search",
        new MdiMeta(
            "calendar-search",
            "F094C",
            Arrays.asList("Date / Time"),
            Arrays.asList("event-search"),
            "GreenTurtwig",
            "2.4.85"));
  }

  public static MdiIcon calendar_search_outline() {
    return MdiIcon.create(
        "mdi-calendar-search-outline",
        new MdiMeta(
            "calendar-search-outline",
            "F1B6E",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon calendar_star() {
    return MdiIcon.create(
        "mdi-calendar-star",
        new MdiMeta(
            "calendar-star",
            "F09D3",
            Arrays.asList("Date / Time"),
            Arrays.asList("event-star", "calendar-favorite"),
            "Michael Richins",
            "2.5.94"));
  }

  public static MdiIcon calendar_star_four_points() {
    return MdiIcon.create(
        "mdi-calendar-star-four-points",
        new MdiMeta(
            "calendar-star-four-points",
            "F1C1F",
            Arrays.asList("Date / Time"),
            Arrays.asList("calendar-auto", "event-star-four-points", "event-auto"),
            "Jeff Anders",
            "7.2.96"));
  }

  public static MdiIcon calendar_star_outline() {
    return MdiIcon.create(
        "mdi-calendar-star-outline",
        new MdiMeta(
            "calendar-star-outline",
            "F1B53",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Andrej Sharapov",
            "6.9.96"));
  }

  public static MdiIcon calendar_start() {
    return MdiIcon.create(
        "mdi-calendar-start",
        new MdiMeta(
            "calendar-start",
            "F166D",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Austin Andrews",
            "5.7.55"));
  }

  public static MdiIcon calendar_start_outline() {
    return MdiIcon.create(
        "mdi-calendar-start-outline",
        new MdiMeta(
            "calendar-start-outline",
            "F1B6F",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon calendar_sync() {
    return MdiIcon.create(
        "mdi-calendar-sync",
        new MdiMeta(
            "calendar-sync",
            "F0E8E",
            Arrays.asList("Date / Time"),
            Arrays.asList("calendar-repeat"),
            "Michael Richins",
            "3.7.94"));
  }

  public static MdiIcon calendar_sync_outline() {
    return MdiIcon.create(
        "mdi-calendar-sync-outline",
        new MdiMeta(
            "calendar-sync-outline",
            "F0E8F",
            Arrays.asList("Date / Time"),
            Arrays.asList("calendar-repeat-outline"),
            "Michael Richins",
            "3.7.94"));
  }

  public static MdiIcon calendar_text() {
    return MdiIcon.create(
        "mdi-calendar-text",
        new MdiMeta(
            "calendar-text",
            "F00F5",
            Arrays.asList("Date / Time"),
            Arrays.asList("event-note", "event-text"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon calendar_text_outline() {
    return MdiIcon.create(
        "mdi-calendar-text-outline",
        new MdiMeta(
            "calendar-text-outline",
            "F0C46",
            Arrays.asList("Date / Time"),
            Arrays.asList("event-text-outline", "event-note-outline"),
            "Google",
            "3.2.89"));
  }

  public static MdiIcon calendar_today() {
    return MdiIcon.create(
        "mdi-calendar-today",
        new MdiMeta(
            "calendar-today",
            "F00F6",
            Arrays.asList("Date / Time"),
            Arrays.asList("calendar-day"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon calendar_today_outline() {
    return MdiIcon.create(
        "mdi-calendar-today-outline",
        new MdiMeta(
            "calendar-today-outline",
            "F1A30",
            Arrays.asList("Date / Time"),
            Arrays.asList("calendar-day-outline"),
            "Michael Irigoyen",
            "6.7.96"));
  }

  public static MdiIcon calendar_week() {
    return MdiIcon.create(
        "mdi-calendar-week",
        new MdiMeta(
            "calendar-week",
            "F0A33",
            Arrays.asList("Date / Time"),
            Arrays.asList("event-week"),
            "Simran",
            "2.6.95"));
  }

  public static MdiIcon calendar_week_begin() {
    return MdiIcon.create(
        "mdi-calendar-week-begin",
        new MdiMeta(
            "calendar-week-begin",
            "F0A34",
            Arrays.asList("Date / Time"),
            Arrays.asList("event-week-begin"),
            "Simran",
            "2.6.95"));
  }

  public static MdiIcon calendar_week_begin_outline() {
    return MdiIcon.create(
        "mdi-calendar-week-begin-outline",
        new MdiMeta(
            "calendar-week-begin-outline",
            "F1A31",
            Arrays.asList("Date / Time"),
            Arrays.asList("event-week-begin-outline"),
            "Michael Irigoyen",
            "6.7.96"));
  }

  public static MdiIcon calendar_week_outline() {
    return MdiIcon.create(
        "mdi-calendar-week-outline",
        new MdiMeta(
            "calendar-week-outline",
            "F1A34",
            Arrays.asList("Date / Time"),
            Arrays.asList("event-week-outline"),
            "Michael Irigoyen",
            "6.7.96"));
  }

  public static MdiIcon calendar_weekend() {
    return MdiIcon.create(
        "mdi-calendar-weekend",
        new MdiMeta(
            "calendar-weekend",
            "F0ED9",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Crissov",
            "3.8.95"));
  }

  public static MdiIcon calendar_weekend_outline() {
    return MdiIcon.create(
        "mdi-calendar-weekend-outline",
        new MdiMeta(
            "calendar-weekend-outline",
            "F0EDA",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Crissov",
            "3.8.95"));
  }

  public static MdiIcon call_made() {
    return MdiIcon.create(
        "mdi-call-made",
        new MdiMeta(
            "call-made",
            "F00F7",
            Arrays.asList("Cellphone / Phone", "Arrow"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon call_merge() {
    return MdiIcon.create(
        "mdi-call-merge",
        new MdiMeta(
            "call-merge",
            "F00F8",
            Arrays.asList("Cellphone / Phone", "Arrow"),
            Arrays.asList("merge-type"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon call_missed() {
    return MdiIcon.create(
        "mdi-call-missed",
        new MdiMeta(
            "call-missed",
            "F00F9",
            Arrays.asList("Cellphone / Phone", "Arrow"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon call_received() {
    return MdiIcon.create(
        "mdi-call-received",
        new MdiMeta(
            "call-received",
            "F00FA",
            Arrays.asList("Cellphone / Phone", "Arrow"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon call_split() {
    return MdiIcon.create(
        "mdi-call-split",
        new MdiMeta(
            "call-split",
            "F00FB",
            Arrays.asList("Cellphone / Phone", "Arrow"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon camcorder() {
    return MdiIcon.create(
        "mdi-camcorder",
        new MdiMeta(
            "camcorder",
            "F00FC",
            Arrays.asList("Video / Movie"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon camcorder_off() {
    return MdiIcon.create(
        "mdi-camcorder-off",
        new MdiMeta(
            "camcorder-off",
            "F00FF",
            Arrays.asList("Video / Movie"),
            Arrays.asList(),
            "Michael Irigoyen",
            "1.5.54"));
  }

  public static MdiIcon camera() {
    return MdiIcon.create(
        "mdi-camera",
        new MdiMeta(
            "camera",
            "F0100",
            Arrays.asList("Photography", "Home Automation"),
            Arrays.asList("photography", "camera-alt", "local-see", "photo-camera"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon camera_account() {
    return MdiIcon.create(
        "mdi-camera-account",
        new MdiMeta(
            "camera-account",
            "F08CB",
            Arrays.asList("Account / User", "Photography"),
            Arrays.asList("camera-user"),
            "Google",
            "2.3.50"));
  }

  public static MdiIcon camera_burst() {
    return MdiIcon.create(
        "mdi-camera-burst",
        new MdiMeta(
            "camera-burst",
            "F0693",
            Arrays.asList("Photography"),
            Arrays.asList("burst-mode"),
            "Google",
            "1.7.12"));
  }

  public static MdiIcon camera_control() {
    return MdiIcon.create(
        "mdi-camera-control",
        new MdiMeta(
            "camera-control",
            "F0B69",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Google",
            "3.0.39"));
  }

  public static MdiIcon camera_document() {
    return MdiIcon.create(
        "mdi-camera-document",
        new MdiMeta(
            "camera-document",
            "F1871",
            Arrays.asList("Photography"),
            Arrays.asList("overhead-projector"),
            "snis",
            "6.2.95"));
  }

  public static MdiIcon camera_document_off() {
    return MdiIcon.create(
        "mdi-camera-document-off",
        new MdiMeta(
            "camera-document-off",
            "F1872",
            Arrays.asList("Photography"),
            Arrays.asList("overhead-projector-off"),
            "snis",
            "6.2.95"));
  }

  public static MdiIcon camera_enhance() {
    return MdiIcon.create(
        "mdi-camera-enhance",
        new MdiMeta(
            "camera-enhance",
            "F0101",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon camera_enhance_outline() {
    return MdiIcon.create(
        "mdi-camera-enhance-outline",
        new MdiMeta(
            "camera-enhance-outline",
            "F0B6A",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Google",
            "3.0.39"));
  }

  public static MdiIcon camera_flip() {
    return MdiIcon.create(
        "mdi-camera-flip",
        new MdiMeta(
            "camera-flip",
            "F15D9",
            Arrays.asList("Photography"),
            Arrays.asList("camera-sync", "camera-refresh"),
            "Michael Irigoyen",
            "5.6.55"));
  }

  public static MdiIcon camera_flip_outline() {
    return MdiIcon.create(
        "mdi-camera-flip-outline",
        new MdiMeta(
            "camera-flip-outline",
            "F15DA",
            Arrays.asList("Photography"),
            Arrays.asList("camera-sync-outline", "camera-refresh-outline"),
            "Michael Irigoyen",
            "5.6.55"));
  }

  public static MdiIcon camera_front() {
    return MdiIcon.create(
        "mdi-camera-front",
        new MdiMeta(
            "camera-front",
            "F0102",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon camera_front_variant() {
    return MdiIcon.create(
        "mdi-camera-front-variant",
        new MdiMeta(
            "camera-front-variant",
            "F0103",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon camera_gopro() {
    return MdiIcon.create(
        "mdi-camera-gopro",
        new MdiMeta(
            "camera-gopro",
            "F07A1",
            Arrays.asList("Photography", "Device / Tech"),
            Arrays.asList(),
            "Michael Richins",
            "2.0.46"));
  }

  public static MdiIcon camera_image() {
    return MdiIcon.create(
        "mdi-camera-image",
        new MdiMeta(
            "camera-image",
            "F08CC",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Google",
            "2.3.50"));
  }

  public static MdiIcon camera_iris() {
    return MdiIcon.create(
        "mdi-camera-iris",
        new MdiMeta(
            "camera-iris",
            "F0104",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon camera_lock() {
    return MdiIcon.create(
        "mdi-camera-lock",
        new MdiMeta(
            "camera-lock",
            "F1A14",
            Arrays.asList("Photography", "Lock"),
            Arrays.asList(),
            "Austin Andrews",
            "6.6.96"));
  }

  public static MdiIcon camera_lock_open() {
    return MdiIcon.create(
        "mdi-camera-lock-open",
        new MdiMeta(
            "camera-lock-open",
            "F1C0D",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.1.96"));
  }

  public static MdiIcon camera_lock_open_outline() {
    return MdiIcon.create(
        "mdi-camera-lock-open-outline",
        new MdiMeta(
            "camera-lock-open-outline",
            "F1C0E",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.1.96"));
  }

  public static MdiIcon camera_lock_outline() {
    return MdiIcon.create(
        "mdi-camera-lock-outline",
        new MdiMeta(
            "camera-lock-outline",
            "F1A15",
            Arrays.asList("Photography", "Lock"),
            Arrays.asList(),
            "Austin Andrews",
            "6.6.96"));
  }

  public static MdiIcon camera_marker() {
    return MdiIcon.create(
        "mdi-camera-marker",
        new MdiMeta(
            "camera-marker",
            "F19A7",
            Arrays.asList("Photography", "Navigation"),
            Arrays.asList("camera-location"),
            "Simran",
            "6.5.95"));
  }

  public static MdiIcon camera_marker_outline() {
    return MdiIcon.create(
        "mdi-camera-marker-outline",
        new MdiMeta(
            "camera-marker-outline",
            "F19A8",
            Arrays.asList("Photography", "Navigation"),
            Arrays.asList("camera-location-outline"),
            "Simran",
            "6.5.95"));
  }

  public static MdiIcon camera_metering_center() {
    return MdiIcon.create(
        "mdi-camera-metering-center",
        new MdiMeta(
            "camera-metering-center",
            "F07A2",
            Arrays.asList("Photography"),
            Arrays.asList("camera-metering-centre"),
            "Andy Martinez",
            "2.0.46"));
  }

  public static MdiIcon camera_metering_matrix() {
    return MdiIcon.create(
        "mdi-camera-metering-matrix",
        new MdiMeta(
            "camera-metering-matrix",
            "F07A3",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Andy Martinez",
            "2.0.46"));
  }

  public static MdiIcon camera_metering_partial() {
    return MdiIcon.create(
        "mdi-camera-metering-partial",
        new MdiMeta(
            "camera-metering-partial",
            "F07A4",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Andy Martinez",
            "2.0.46"));
  }

  public static MdiIcon camera_metering_spot() {
    return MdiIcon.create(
        "mdi-camera-metering-spot",
        new MdiMeta(
            "camera-metering-spot",
            "F07A5",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Andy Martinez",
            "2.0.46"));
  }

  public static MdiIcon camera_off() {
    return MdiIcon.create(
        "mdi-camera-off",
        new MdiMeta(
            "camera-off",
            "F05DF",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon camera_off_outline() {
    return MdiIcon.create(
        "mdi-camera-off-outline",
        new MdiMeta(
            "camera-off-outline",
            "F19BF",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.5.95"));
  }

  public static MdiIcon camera_outline() {
    return MdiIcon.create(
        "mdi-camera-outline",
        new MdiMeta(
            "camera-outline",
            "F0D5D",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Google",
            "3.4.93"));
  }

  public static MdiIcon camera_party_mode() {
    return MdiIcon.create(
        "mdi-camera-party-mode",
        new MdiMeta(
            "camera-party-mode",
            "F0105",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon camera_plus() {
    return MdiIcon.create(
        "mdi-camera-plus",
        new MdiMeta(
            "camera-plus",
            "F0EDB",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Google",
            "3.8.95"));
  }

  public static MdiIcon camera_plus_outline() {
    return MdiIcon.create(
        "mdi-camera-plus-outline",
        new MdiMeta(
            "camera-plus-outline",
            "F0EDC",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Google",
            "3.8.95"));
  }

  public static MdiIcon camera_rear() {
    return MdiIcon.create(
        "mdi-camera-rear",
        new MdiMeta(
            "camera-rear",
            "F0106",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon camera_rear_variant() {
    return MdiIcon.create(
        "mdi-camera-rear-variant",
        new MdiMeta(
            "camera-rear-variant",
            "F0107",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon camera_retake() {
    return MdiIcon.create(
        "mdi-camera-retake",
        new MdiMeta(
            "camera-retake",
            "F0E19",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Michael Richins",
            "3.6.95"));
  }

  public static MdiIcon camera_retake_outline() {
    return MdiIcon.create(
        "mdi-camera-retake-outline",
        new MdiMeta(
            "camera-retake-outline",
            "F0E1A",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Michael Richins",
            "3.6.95"));
  }

  public static MdiIcon camera_switch() {
    return MdiIcon.create(
        "mdi-camera-switch",
        new MdiMeta(
            "camera-switch",
            "F0108",
            Arrays.asList("Photography"),
            Arrays.asList("switch-camera"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon camera_switch_outline() {
    return MdiIcon.create(
        "mdi-camera-switch-outline",
        new MdiMeta(
            "camera-switch-outline",
            "F084A",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Google",
            "2.1.99"));
  }

  public static MdiIcon camera_timer() {
    return MdiIcon.create(
        "mdi-camera-timer",
        new MdiMeta(
            "camera-timer",
            "F0109",
            Arrays.asList("Date / Time", "Photography"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon camera_wireless() {
    return MdiIcon.create(
        "mdi-camera-wireless",
        new MdiMeta(
            "camera-wireless",
            "F0DB6",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Google",
            "3.5.94"));
  }

  public static MdiIcon camera_wireless_outline() {
    return MdiIcon.create(
        "mdi-camera-wireless-outline",
        new MdiMeta(
            "camera-wireless-outline",
            "F0DB7",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Google",
            "3.5.94"));
  }

  public static MdiIcon campfire() {
    return MdiIcon.create(
        "mdi-campfire",
        new MdiMeta(
            "campfire", "F0EDD", Arrays.asList(), Arrays.asList(), "Michael Irigoyen", "3.8.95"));
  }

  public static MdiIcon cancel() {
    return MdiIcon.create(
        "mdi-cancel",
        new MdiMeta(
            "cancel",
            "F073A",
            Arrays.asList(),
            Arrays.asList(
                "prohibited",
                "ban",
                "do-not-disturb-alt",
                "denied",
                "block",
                "forbid",
                "no",
                "clear"),
            "Google",
            "1.9.32"));
  }

  public static MdiIcon candelabra() {
    return MdiIcon.create(
        "mdi-candelabra",
        new MdiMeta(
            "candelabra",
            "F17D2",
            Arrays.asList("Home Automation", "Holiday"),
            Arrays.asList("candle", "candelabrum"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon candelabra_fire() {
    return MdiIcon.create(
        "mdi-candelabra-fire",
        new MdiMeta(
            "candelabra-fire",
            "F17D3",
            Arrays.asList("Home Automation", "Holiday"),
            Arrays.asList(
                "candelabrum-fire",
                "candelabrum-flame",
                "candelabra-flame",
                "candle-fire",
                "candle-flame"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon candle() {
    return MdiIcon.create(
        "mdi-candle",
        new MdiMeta(
            "candle",
            "F05E2",
            Arrays.asList("Holiday", "Home Automation"),
            Arrays.asList("candle-flame", "candle-fire"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon candy() {
    return MdiIcon.create(
        "mdi-candy",
        new MdiMeta(
            "candy",
            "F1970",
            Arrays.asList("Food / Drink"),
            Arrays.asList("treat", "chocolate"),
            "Michael Irigoyen",
            "6.5.95"));
  }

  public static MdiIcon candy_off() {
    return MdiIcon.create(
        "mdi-candy-off",
        new MdiMeta(
            "candy-off",
            "F1971",
            Arrays.asList("Food / Drink"),
            Arrays.asList("chocolate-off", "treat-off"),
            "Michael Irigoyen",
            "6.5.95"));
  }

  public static MdiIcon candy_off_outline() {
    return MdiIcon.create(
        "mdi-candy-off-outline",
        new MdiMeta(
            "candy-off-outline",
            "F1972",
            Arrays.asList("Food / Drink", "Gaming / RPG"),
            Arrays.asList("chocolate-off-outline", "treat-off-outline", "navi-off"),
            "Michael Irigoyen",
            "6.5.95"));
  }

  public static MdiIcon candy_outline() {
    return MdiIcon.create(
        "mdi-candy-outline",
        new MdiMeta(
            "candy-outline",
            "F1973",
            Arrays.asList("Food / Drink", "Gaming / RPG"),
            Arrays.asList("chocolate-outline", "treat-outline", "navi", "hey-listen", "fairy"),
            "Michael Irigoyen",
            "6.5.95"));
  }

  public static MdiIcon candycane() {
    return MdiIcon.create(
        "mdi-candycane",
        new MdiMeta(
            "candycane",
            "F010A",
            Arrays.asList("Holiday", "Food / Drink"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon cannabis() {
    return MdiIcon.create(
        "mdi-cannabis",
        new MdiMeta(
            "cannabis",
            "F07A6",
            Arrays.asList("Nature", "Medical / Hospital"),
            Arrays.asList("weed", "pot", "marijuana"),
            "Austin Andrews",
            "2.0.46"));
  }

  public static MdiIcon cannabis_off() {
    return MdiIcon.create(
        "mdi-cannabis-off",
        new MdiMeta(
            "cannabis-off",
            "F166E",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon caps_lock() {
    return MdiIcon.create(
        "mdi-caps-lock",
        new MdiMeta(
            "caps-lock",
            "F0A9B",
            Arrays.asList("Text / Content / Format"),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.7.94"));
  }

  public static MdiIcon car() {
    return MdiIcon.create(
        "mdi-car",
        new MdiMeta(
            "car",
            "F010B",
            Arrays.asList("Transportation + Road", "Navigation", "Automotive"),
            Arrays.asList("directions-car", "drive-eta", "time-to-leave"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon car_2_plus() {
    return MdiIcon.create(
        "mdi-car-2-plus",
        new MdiMeta(
            "car-2-plus",
            "F1015",
            Arrays.asList("Transportation + Road", "Automotive"),
            Arrays.asList("hov-lane", "high-occupancy-vehicle-lane", "carpool-lane"),
            "Michael Irigoyen",
            "4.1.95"));
  }

  public static MdiIcon car_3_plus() {
    return MdiIcon.create(
        "mdi-car-3-plus",
        new MdiMeta(
            "car-3-plus",
            "F1016",
            Arrays.asList("Transportation + Road", "Automotive"),
            Arrays.asList("hov-lane", "high-occupancy-vehicle-lane", "carpool-lane"),
            "Michael Irigoyen",
            "4.1.95"));
  }

  public static MdiIcon car_arrow_left() {
    return MdiIcon.create(
        "mdi-car-arrow-left",
        new MdiMeta(
            "car-arrow-left",
            "F13B2",
            Arrays.asList("Automotive", "Transportation + Road"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.0.45"));
  }

  public static MdiIcon car_arrow_right() {
    return MdiIcon.create(
        "mdi-car-arrow-right",
        new MdiMeta(
            "car-arrow-right",
            "F13B3",
            Arrays.asList("Automotive", "Transportation + Road"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.0.45"));
  }

  public static MdiIcon car_back() {
    return MdiIcon.create(
        "mdi-car-back",
        new MdiMeta(
            "car-back",
            "F0E1B",
            Arrays.asList("Automotive", "Transportation + Road"),
            Arrays.asList(),
            "Michael Richins",
            "3.6.95"));
  }

  public static MdiIcon car_battery() {
    return MdiIcon.create(
        "mdi-car-battery",
        new MdiMeta(
            "car-battery",
            "F010C",
            Arrays.asList("Battery", "Automotive"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon car_brake_abs() {
    return MdiIcon.create(
        "mdi-car-brake-abs",
        new MdiMeta(
            "car-brake-abs",
            "F0C47",
            Arrays.asList("Automotive"),
            Arrays.asList("anti-lock-brake-system", "anti-lock-braking-system"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon car_brake_alert() {
    return MdiIcon.create(
        "mdi-car-brake-alert",
        new MdiMeta(
            "car-brake-alert",
            "F0C48",
            Arrays.asList("Automotive", "Alert / Error"),
            Arrays.asList(
                "car-parking-brake",
                "car-handbrake",
                "car-hand-brake",
                "car-emergency-brake",
                "car-brake-warning"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon car_brake_fluid_level() {
    return MdiIcon.create(
        "mdi-car-brake-fluid-level",
        new MdiMeta(
            "car-brake-fluid-level",
            "F1909",
            Arrays.asList("Automotive"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon car_brake_hold() {
    return MdiIcon.create(
        "mdi-car-brake-hold",
        new MdiMeta(
            "car-brake-hold",
            "F0D5E",
            Arrays.asList("Automotive"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.4.93"));
  }

  public static MdiIcon car_brake_low_pressure() {
    return MdiIcon.create(
        "mdi-car-brake-low-pressure",
        new MdiMeta(
            "car-brake-low-pressure",
            "F190A",
            Arrays.asList("Automotive"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon car_brake_parking() {
    return MdiIcon.create(
        "mdi-car-brake-parking",
        new MdiMeta(
            "car-brake-parking",
            "F0D5F",
            Arrays.asList("Automotive"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.4.93"));
  }

  public static MdiIcon car_brake_retarder() {
    return MdiIcon.create(
        "mdi-car-brake-retarder",
        new MdiMeta(
            "car-brake-retarder",
            "F1017",
            Arrays.asList("Automotive"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.1.95"));
  }

  public static MdiIcon car_brake_temperature() {
    return MdiIcon.create(
        "mdi-car-brake-temperature",
        new MdiMeta(
            "car-brake-temperature",
            "F190B",
            Arrays.asList("Automotive"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon car_brake_worn_linings() {
    return MdiIcon.create(
        "mdi-car-brake-worn-linings",
        new MdiMeta(
            "car-brake-worn-linings",
            "F190C",
            Arrays.asList("Automotive"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon car_child_seat() {
    return MdiIcon.create(
        "mdi-car-child-seat",
        new MdiMeta(
            "car-child-seat",
            "F0FA3",
            Arrays.asList("Automotive", "People / Family"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.0.96"));
  }

  public static MdiIcon car_clock() {
    return MdiIcon.create(
        "mdi-car-clock",
        new MdiMeta(
            "car-clock",
            "F1974",
            Arrays.asList("Date / Time", "Automotive"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.5.95"));
  }

  public static MdiIcon car_clutch() {
    return MdiIcon.create(
        "mdi-car-clutch",
        new MdiMeta(
            "car-clutch",
            "F1018",
            Arrays.asList("Automotive"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.1.95"));
  }

  public static MdiIcon car_cog() {
    return MdiIcon.create(
        "mdi-car-cog",
        new MdiMeta(
            "car-cog",
            "F13CC",
            Arrays.asList("Automotive", "Settings", "Transportation + Road"),
            Arrays.asList("car-settings"),
            "Simran",
            "5.1.45"));
  }

  public static MdiIcon car_connected() {
    return MdiIcon.create(
        "mdi-car-connected",
        new MdiMeta(
            "car-connected",
            "F010D",
            Arrays.asList("Transportation + Road", "Automotive"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon car_convertible() {
    return MdiIcon.create(
        "mdi-car-convertible",
        new MdiMeta(
            "car-convertible",
            "F07A7",
            Arrays.asList("Transportation + Road", "Automotive"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.0.46"));
  }

  public static MdiIcon car_coolant_level() {
    return MdiIcon.create(
        "mdi-car-coolant-level",
        new MdiMeta(
            "car-coolant-level",
            "F1019",
            Arrays.asList("Automotive"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.1.95"));
  }

  public static MdiIcon car_cruise_control() {
    return MdiIcon.create(
        "mdi-car-cruise-control",
        new MdiMeta(
            "car-cruise-control",
            "F0D60",
            Arrays.asList("Automotive"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.4.93"));
  }

  public static MdiIcon car_defrost_front() {
    return MdiIcon.create(
        "mdi-car-defrost-front",
        new MdiMeta(
            "car-defrost-front",
            "F0D61",
            Arrays.asList("Automotive"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.4.93"));
  }

  public static MdiIcon car_defrost_rear() {
    return MdiIcon.create(
        "mdi-car-defrost-rear",
        new MdiMeta(
            "car-defrost-rear",
            "F0D62",
            Arrays.asList("Automotive"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.4.93"));
  }

  public static MdiIcon car_door() {
    return MdiIcon.create(
        "mdi-car-door",
        new MdiMeta(
            "car-door",
            "F0B6B",
            Arrays.asList("Automotive"),
            Arrays.asList(),
            "Austin Andrews",
            "3.0.39"));
  }

  public static MdiIcon car_door_lock() {
    return MdiIcon.create(
        "mdi-car-door-lock",
        new MdiMeta(
            "car-door-lock",
            "F109D",
            Arrays.asList("Automotive", "Lock"),
            Arrays.asList(),
            "Michael Richins",
            "4.2.95"));
  }

  public static MdiIcon car_electric() {
    return MdiIcon.create(
        "mdi-car-electric",
        new MdiMeta(
            "car-electric",
            "F0B6C",
            Arrays.asList("Transportation + Road", "Automotive"),
            Arrays.asList(),
            "Google",
            "3.0.39"));
  }

  public static MdiIcon car_electric_outline() {
    return MdiIcon.create(
        "mdi-car-electric-outline",
        new MdiMeta(
            "car-electric-outline",
            "F15B5",
            Arrays.asList("Transportation + Road", "Automotive"),
            Arrays.asList(),
            "Google",
            "5.6.55"));
  }

  public static MdiIcon car_emergency() {
    return MdiIcon.create(
        "mdi-car-emergency",
        new MdiMeta(
            "car-emergency",
            "F160F",
            Arrays.asList("Transportation + Road", "Automotive"),
            Arrays.asList("car-police"),
            "GreenTurtwig",
            "5.6.55"));
  }

  public static MdiIcon car_esp() {
    return MdiIcon.create(
        "mdi-car-esp",
        new MdiMeta(
            "car-esp",
            "F0C49",
            Arrays.asList("Automotive"),
            Arrays.asList("electronic-stability-program"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon car_estate() {
    return MdiIcon.create(
        "mdi-car-estate",
        new MdiMeta(
            "car-estate",
            "F07A8",
            Arrays.asList("Transportation + Road", "Automotive"),
            Arrays.asList("car-suv", "car-sports-utility-vehicle"),
            "GreenTurtwig",
            "2.0.46"));
  }

  public static MdiIcon car_hatchback() {
    return MdiIcon.create(
        "mdi-car-hatchback",
        new MdiMeta(
            "car-hatchback",
            "F07A9",
            Arrays.asList("Transportation + Road", "Automotive"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.0.46"));
  }

  public static MdiIcon car_info() {
    return MdiIcon.create(
        "mdi-car-info",
        new MdiMeta(
            "car-info",
            "F11BE",
            Arrays.asList("Automotive"),
            Arrays.asList(),
            "Michael Richins",
            "4.5.95"));
  }

  public static MdiIcon car_key() {
    return MdiIcon.create(
        "mdi-car-key",
        new MdiMeta(
            "car-key",
            "F0B6D",
            Arrays.asList("Transportation + Road", "Automotive"),
            Arrays.asList("car-rental", "rent-a-car"),
            "GreenTurtwig",
            "3.0.39"));
  }

  public static MdiIcon car_lifted_pickup() {
    return MdiIcon.create(
        "mdi-car-lifted-pickup",
        new MdiMeta(
            "car-lifted-pickup",
            "F152D",
            Arrays.asList("Automotive", "Agriculture"),
            Arrays.asList(),
            "Austin Andrews",
            "5.4.55"));
  }

  public static MdiIcon car_light_alert() {
    return MdiIcon.create(
        "mdi-car-light-alert",
        new MdiMeta(
            "car-light-alert",
            "F190D",
            Arrays.asList("Alert / Error", "Automotive"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon car_light_dimmed() {
    return MdiIcon.create(
        "mdi-car-light-dimmed",
        new MdiMeta(
            "car-light-dimmed",
            "F0C4A",
            Arrays.asList("Automotive"),
            Arrays.asList("head-light-dimmed", "low-beam"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon car_light_fog() {
    return MdiIcon.create(
        "mdi-car-light-fog",
        new MdiMeta(
            "car-light-fog",
            "F0C4B",
            Arrays.asList("Automotive"),
            Arrays.asList("head-light-fog"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon car_light_high() {
    return MdiIcon.create(
        "mdi-car-light-high",
        new MdiMeta(
            "car-light-high",
            "F0C4C",
            Arrays.asList("Automotive"),
            Arrays.asList("head-light-high", "high-beam"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon car_limousine() {
    return MdiIcon.create(
        "mdi-car-limousine",
        new MdiMeta(
            "car-limousine",
            "F08CD",
            Arrays.asList("Transportation + Road", "Automotive"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.3.50"));
  }

  public static MdiIcon car_multiple() {
    return MdiIcon.create(
        "mdi-car-multiple",
        new MdiMeta(
            "car-multiple",
            "F0B6E",
            Arrays.asList("Transportation + Road", "Automotive"),
            Arrays.asList(),
            "Michael Richins",
            "3.0.39"));
  }

  public static MdiIcon car_off() {
    return MdiIcon.create(
        "mdi-car-off",
        new MdiMeta(
            "car-off",
            "F0E1C",
            Arrays.asList("Automotive"),
            Arrays.asList(),
            "Michael Richins",
            "3.6.95"));
  }

  public static MdiIcon car_outline() {
    return MdiIcon.create(
        "mdi-car-outline",
        new MdiMeta(
            "car-outline",
            "F14ED",
            Arrays.asList("Automotive"),
            Arrays.asList(),
            "Google",
            "5.4.55"));
  }

  public static MdiIcon car_parking_lights() {
    return MdiIcon.create(
        "mdi-car-parking-lights",
        new MdiMeta(
            "car-parking-lights",
            "F0D63",
            Arrays.asList("Automotive"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.4.93"));
  }

  public static MdiIcon car_pickup() {
    return MdiIcon.create(
        "mdi-car-pickup",
        new MdiMeta(
            "car-pickup",
            "F07AA",
            Arrays.asList("Transportation + Road", "Automotive", "Agriculture"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.0.46"));
  }

  public static MdiIcon car_search() {
    return MdiIcon.create(
        "mdi-car-search",
        new MdiMeta(
            "car-search",
            "F1B8D",
            Arrays.asList("Automotive"),
            Arrays.asList("car-find"),
            "tetzla",
            "7.0.96"));
  }

  public static MdiIcon car_search_outline() {
    return MdiIcon.create(
        "mdi-car-search-outline",
        new MdiMeta(
            "car-search-outline",
            "F1B8E",
            Arrays.asList("Automotive"),
            Arrays.asList("car-find-outline"),
            "tetzla",
            "7.0.96"));
  }

  public static MdiIcon car_seat() {
    return MdiIcon.create(
        "mdi-car-seat",
        new MdiMeta(
            "car-seat",
            "F0FA4",
            Arrays.asList("Automotive"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.0.96"));
  }

  public static MdiIcon car_seat_cooler() {
    return MdiIcon.create(
        "mdi-car-seat-cooler",
        new MdiMeta(
            "car-seat-cooler",
            "F0FA5",
            Arrays.asList("Automotive"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.0.96"));
  }

  public static MdiIcon car_seat_heater() {
    return MdiIcon.create(
        "mdi-car-seat-heater",
        new MdiMeta(
            "car-seat-heater",
            "F0FA6",
            Arrays.asList("Automotive"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.0.96"));
  }

  public static MdiIcon car_select() {
    return MdiIcon.create(
        "mdi-car-select",
        new MdiMeta(
            "car-select",
            "F1879",
            Arrays.asList("Automotive"),
            Arrays.asList("car-location"),
            "Jeff Anders",
            "6.2.95"));
  }

  public static MdiIcon car_settings() {
    return MdiIcon.create(
        "mdi-car-settings",
        new MdiMeta(
            "car-settings",
            "F13CD",
            Arrays.asList("Automotive", "Settings"),
            Arrays.asList(),
            "Simran",
            "5.1.45"));
  }

  public static MdiIcon car_shift_pattern() {
    return MdiIcon.create(
        "mdi-car-shift-pattern",
        new MdiMeta(
            "car-shift-pattern",
            "F0F40",
            Arrays.asList("Automotive"),
            Arrays.asList("car-transmission", "car-manual-transmission"),
            "Colton Wiscombe",
            "3.9.97"));
  }

  public static MdiIcon car_side() {
    return MdiIcon.create(
        "mdi-car-side",
        new MdiMeta(
            "car-side",
            "F07AB",
            Arrays.asList("Transportation + Road", "Automotive"),
            Arrays.asList("car-saloon"),
            "GreenTurtwig",
            "2.0.46"));
  }

  public static MdiIcon car_speed_limiter() {
    return MdiIcon.create(
        "mdi-car-speed-limiter",
        new MdiMeta(
            "car-speed-limiter",
            "F190E",
            Arrays.asList("Automotive"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon car_sports() {
    return MdiIcon.create(
        "mdi-car-sports",
        new MdiMeta(
            "car-sports",
            "F07AC",
            Arrays.asList("Transportation + Road", "Sport", "Automotive"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.0.46"));
  }

  public static MdiIcon car_tire_alert() {
    return MdiIcon.create(
        "mdi-car-tire-alert",
        new MdiMeta(
            "car-tire-alert",
            "F0C4D",
            Arrays.asList("Automotive", "Alert / Error"),
            Arrays.asList("car-tyre-alert", "car-tyre-warning", "car-tire-warning"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon car_traction_control() {
    return MdiIcon.create(
        "mdi-car-traction-control",
        new MdiMeta(
            "car-traction-control",
            "F0D64",
            Arrays.asList("Automotive"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.4.93"));
  }

  public static MdiIcon car_turbocharger() {
    return MdiIcon.create(
        "mdi-car-turbocharger",
        new MdiMeta(
            "car-turbocharger",
            "F101A",
            Arrays.asList("Automotive"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.1.95"));
  }

  public static MdiIcon car_wash() {
    return MdiIcon.create(
        "mdi-car-wash",
        new MdiMeta(
            "car-wash",
            "F010E",
            Arrays.asList("Transportation + Road", "Places", "Automotive"),
            Arrays.asList("local-car-wash"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon car_windshield() {
    return MdiIcon.create(
        "mdi-car-windshield",
        new MdiMeta(
            "car-windshield",
            "F101B",
            Arrays.asList("Automotive"),
            Arrays.asList("car-front-glass"),
            "Michael Richins",
            "4.1.95"));
  }

  public static MdiIcon car_windshield_outline() {
    return MdiIcon.create(
        "mdi-car-windshield-outline",
        new MdiMeta(
            "car-windshield-outline",
            "F101C",
            Arrays.asList("Automotive"),
            Arrays.asList("car-front-glass-outline"),
            "Michael Richins",
            "4.1.95"));
  }

  public static MdiIcon car_wireless() {
    return MdiIcon.create(
        "mdi-car-wireless",
        new MdiMeta(
            "car-wireless",
            "F1878",
            Arrays.asList("Automotive"),
            Arrays.asList("car-autonomous", "car-self-driving", "car-smart"),
            "Michael Irigoyen",
            "6.2.95"));
  }

  public static MdiIcon car_wrench() {
    return MdiIcon.create(
        "mdi-car-wrench",
        new MdiMeta(
            "car-wrench",
            "F1814",
            Arrays.asList("Automotive", "Hardware / Tools"),
            Arrays.asList("car-repair", "mechanic"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon carabiner() {
    return MdiIcon.create(
        "mdi-carabiner",
        new MdiMeta(
            "carabiner",
            "F14C0",
            Arrays.asList("Sport"),
            Arrays.asList("karabiner", "rock-climbing"),
            "Google",
            "5.3.45"));
  }

  public static MdiIcon caravan() {
    return MdiIcon.create(
        "mdi-caravan",
        new MdiMeta(
            "caravan",
            "F07AD",
            Arrays.asList("Transportation + Road", "Home Automation", "Automotive"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.0.46"));
  }

  public static MdiIcon card() {
    return MdiIcon.create(
        "mdi-card",
        new MdiMeta(
            "card", "F0B6F", Arrays.asList("Form"), Arrays.asList("button"), "Rynco Li", "3.0.39"));
  }

  public static MdiIcon card_account_details() {
    return MdiIcon.create(
        "mdi-card-account-details",
        new MdiMeta(
            "card-account-details",
            "F05D2",
            Arrays.asList("Account / User"),
            Arrays.asList(
                "identification-card",
                "user-card-details",
                "id-card",
                "person-card-details",
                "drivers-license",
                "business-card"),
            "Christopher Schreiner",
            "1.5.54"));
  }

  public static MdiIcon card_account_details_outline() {
    return MdiIcon.create(
        "mdi-card-account-details-outline",
        new MdiMeta(
            "card-account-details-outline",
            "F0DAB",
            Arrays.asList("Account / User"),
            Arrays.asList(
                "identification-card-outline",
                "user-card-details-outline",
                "id-card-outline",
                "person-card-details-outline",
                "drivers-license-outline",
                "business-card-outline"),
            "Michael Richins",
            "3.5.94"));
  }

  public static MdiIcon card_account_details_star() {
    return MdiIcon.create(
        "mdi-card-account-details-star",
        new MdiMeta(
            "card-account-details-star",
            "F02A3",
            Arrays.asList("Account / User"),
            Arrays.asList("card-account-details-favorite"),
            "Michael Richins",
            "1.5.54"));
  }

  public static MdiIcon card_account_details_star_outline() {
    return MdiIcon.create(
        "mdi-card-account-details-star-outline",
        new MdiMeta(
            "card-account-details-star-outline",
            "F06DB",
            Arrays.asList("Account / User"),
            Arrays.asList("card-account-details-favorite-outline"),
            "Michael Richins",
            "1.8.36"));
  }

  public static MdiIcon card_account_mail() {
    return MdiIcon.create(
        "mdi-card-account-mail",
        new MdiMeta(
            "card-account-mail",
            "F018E",
            Arrays.asList("Account / User"),
            Arrays.asList("contact-mail"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon card_account_mail_outline() {
    return MdiIcon.create(
        "mdi-card-account-mail-outline",
        new MdiMeta(
            "card-account-mail-outline",
            "F0E98",
            Arrays.asList("Account / User"),
            Arrays.asList("contact-mail-outline"),
            "Google",
            "3.7.94"));
  }

  public static MdiIcon card_account_phone() {
    return MdiIcon.create(
        "mdi-card-account-phone",
        new MdiMeta(
            "card-account-phone",
            "F0E99",
            Arrays.asList("Account / User"),
            Arrays.asList("contact-phone"),
            "Google",
            "3.7.94"));
  }

  public static MdiIcon card_account_phone_outline() {
    return MdiIcon.create(
        "mdi-card-account-phone-outline",
        new MdiMeta(
            "card-account-phone-outline",
            "F0E9A",
            Arrays.asList("Account / User"),
            Arrays.asList("contact-phone-outline"),
            "Google",
            "3.7.94"));
  }

  public static MdiIcon card_bulleted() {
    return MdiIcon.create(
        "mdi-card-bulleted",
        new MdiMeta(
            "card-bulleted", "F0B70", Arrays.asList(), Arrays.asList(), "Rynco Li", "3.0.39"));
  }

  public static MdiIcon card_bulleted_off() {
    return MdiIcon.create(
        "mdi-card-bulleted-off",
        new MdiMeta(
            "card-bulleted-off", "F0B71", Arrays.asList(), Arrays.asList(), "Rynco Li", "3.0.39"));
  }

  public static MdiIcon card_bulleted_off_outline() {
    return MdiIcon.create(
        "mdi-card-bulleted-off-outline",
        new MdiMeta(
            "card-bulleted-off-outline",
            "F0B72",
            Arrays.asList(),
            Arrays.asList(),
            "Rynco Li",
            "3.0.39"));
  }

  public static MdiIcon card_bulleted_outline() {
    return MdiIcon.create(
        "mdi-card-bulleted-outline",
        new MdiMeta(
            "card-bulleted-outline",
            "F0B73",
            Arrays.asList(),
            Arrays.asList(),
            "Rynco Li",
            "3.0.39"));
  }

  public static MdiIcon card_bulleted_settings() {
    return MdiIcon.create(
        "mdi-card-bulleted-settings",
        new MdiMeta(
            "card-bulleted-settings",
            "F0B74",
            Arrays.asList("Settings"),
            Arrays.asList(),
            "Rynco Li",
            "3.0.39"));
  }

  public static MdiIcon card_bulleted_settings_outline() {
    return MdiIcon.create(
        "mdi-card-bulleted-settings-outline",
        new MdiMeta(
            "card-bulleted-settings-outline",
            "F0B75",
            Arrays.asList("Settings"),
            Arrays.asList(),
            "Rynco Li",
            "3.0.39"));
  }

  public static MdiIcon card_minus() {
    return MdiIcon.create(
        "mdi-card-minus",
        new MdiMeta(
            "card-minus", "F1600", Arrays.asList(), Arrays.asList(), "Colton Wiscombe", "5.6.55"));
  }

  public static MdiIcon card_minus_outline() {
    return MdiIcon.create(
        "mdi-card-minus-outline",
        new MdiMeta(
            "card-minus-outline",
            "F1601",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.6.55"));
  }

  public static MdiIcon card_multiple() {
    return MdiIcon.create(
        "mdi-card-multiple",
        new MdiMeta(
            "card-multiple", "F17F1", Arrays.asList(), Arrays.asList(), "Jeff Anders", "6.1.95"));
  }

  public static MdiIcon card_multiple_outline() {
    return MdiIcon.create(
        "mdi-card-multiple-outline",
        new MdiMeta(
            "card-multiple-outline",
            "F17F2",
            Arrays.asList(),
            Arrays.asList(),
            "Jeff Anders",
            "6.1.95"));
  }

  public static MdiIcon card_off() {
    return MdiIcon.create(
        "mdi-card-off",
        new MdiMeta(
            "card-off", "F1602", Arrays.asList(), Arrays.asList(), "Colton Wiscombe", "5.6.55"));
  }

  public static MdiIcon card_off_outline() {
    return MdiIcon.create(
        "mdi-card-off-outline",
        new MdiMeta(
            "card-off-outline",
            "F1603",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.6.55"));
  }

  public static MdiIcon card_outline() {
    return MdiIcon.create(
        "mdi-card-outline",
        new MdiMeta(
            "card-outline",
            "F0B76",
            Arrays.asList("Form"),
            Arrays.asList("button-outline"),
            "Rynco Li",
            "3.0.39"));
  }

  public static MdiIcon card_plus() {
    return MdiIcon.create(
        "mdi-card-plus",
        new MdiMeta(
            "card-plus", "F11FF", Arrays.asList(), Arrays.asList(), "Michael Irigoyen", "4.6.95"));
  }

  public static MdiIcon card_plus_outline() {
    return MdiIcon.create(
        "mdi-card-plus-outline",
        new MdiMeta(
            "card-plus-outline",
            "F1200",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.6.95"));
  }

  public static MdiIcon card_remove() {
    return MdiIcon.create(
        "mdi-card-remove",
        new MdiMeta(
            "card-remove", "F1604", Arrays.asList(), Arrays.asList(), "Colton Wiscombe", "5.6.55"));
  }

  public static MdiIcon card_remove_outline() {
    return MdiIcon.create(
        "mdi-card-remove-outline",
        new MdiMeta(
            "card-remove-outline",
            "F1605",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.6.55"));
  }

  public static MdiIcon card_search() {
    return MdiIcon.create(
        "mdi-card-search",
        new MdiMeta(
            "card-search",
            "F1074",
            Arrays.asList(),
            Arrays.asList("pageview"),
            "Google",
            "4.2.95"));
  }

  public static MdiIcon card_search_outline() {
    return MdiIcon.create(
        "mdi-card-search-outline",
        new MdiMeta(
            "card-search-outline",
            "F1075",
            Arrays.asList(),
            Arrays.asList("pageview-outline"),
            "Google",
            "4.2.95"));
  }

  public static MdiIcon card_text() {
    return MdiIcon.create(
        "mdi-card-text",
        new MdiMeta("card-text", "F0B77", Arrays.asList(), Arrays.asList(), "Rynco Li", "3.0.39"));
  }

  public static MdiIcon card_text_outline() {
    return MdiIcon.create(
        "mdi-card-text-outline",
        new MdiMeta(
            "card-text-outline", "F0B78", Arrays.asList(), Arrays.asList(), "Rynco Li", "3.0.39"));
  }

  public static MdiIcon cards() {
    return MdiIcon.create(
        "mdi-cards",
        new MdiMeta(
            "cards", "F0638", Arrays.asList("Gaming / RPG"), Arrays.asList(), "Simran", "1.6.50"));
  }

  public static MdiIcon cards_club() {
    return MdiIcon.create(
        "mdi-cards-club",
        new MdiMeta(
            "cards-club",
            "F08CE",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("suit-clubs", "poker-club"),
            "Nick",
            "2.3.50"));
  }

  public static MdiIcon cards_club_outline() {
    return MdiIcon.create(
        "mdi-cards-club-outline",
        new MdiMeta(
            "cards-club-outline",
            "F189F",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.3.95"));
  }

  public static MdiIcon cards_diamond() {
    return MdiIcon.create(
        "mdi-cards-diamond",
        new MdiMeta(
            "cards-diamond",
            "F08CF",
            Arrays.asList("Gaming / RPG", "Transportation + Road"),
            Arrays.asList(
                "suit-diamonds",
                "hov-lane",
                "high-occupancy-vehicle-lane",
                "carpool-lane",
                "poker-diamond"),
            "Nick",
            "2.3.50"));
  }

  public static MdiIcon cards_diamond_outline() {
    return MdiIcon.create(
        "mdi-cards-diamond-outline",
        new MdiMeta(
            "cards-diamond-outline",
            "F101D",
            Arrays.asList("Transportation + Road"),
            Arrays.asList(
                "hov-lane-outline",
                "high-occupancy-vehicle-lane-outline",
                "carpool-lane-outline",
                "poker-diamond-outline"),
            "Michael Richins",
            "4.1.95"));
  }

  public static MdiIcon cards_heart() {
    return MdiIcon.create(
        "mdi-cards-heart",
        new MdiMeta(
            "cards-heart",
            "F08D0",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("suit-hearts", "poker-heart"),
            "Nick",
            "2.3.50"));
  }

  public static MdiIcon cards_heart_outline() {
    return MdiIcon.create(
        "mdi-cards-heart-outline",
        new MdiMeta(
            "cards-heart-outline",
            "F18A0",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.3.95"));
  }

  public static MdiIcon cards_outline() {
    return MdiIcon.create(
        "mdi-cards-outline",
        new MdiMeta(
            "cards-outline",
            "F0639",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "Simran",
            "1.6.50"));
  }

  public static MdiIcon cards_playing() {
    return MdiIcon.create(
        "mdi-cards-playing",
        new MdiMeta(
            "cards-playing",
            "F18A1",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.3.95"));
  }

  public static MdiIcon cards_playing_club() {
    return MdiIcon.create(
        "mdi-cards-playing-club",
        new MdiMeta(
            "cards-playing-club",
            "F18A2",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "GreenTurtwig",
            "6.3.95"));
  }

  public static MdiIcon cards_playing_club_multiple() {
    return MdiIcon.create(
        "mdi-cards-playing-club-multiple",
        new MdiMeta(
            "cards-playing-club-multiple",
            "F18A3",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "GreenTurtwig",
            "6.3.95"));
  }

  public static MdiIcon cards_playing_club_multiple_outline() {
    return MdiIcon.create(
        "mdi-cards-playing-club-multiple-outline",
        new MdiMeta(
            "cards-playing-club-multiple-outline",
            "F18A4",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "GreenTurtwig",
            "6.3.95"));
  }

  public static MdiIcon cards_playing_club_outline() {
    return MdiIcon.create(
        "mdi-cards-playing-club-outline",
        new MdiMeta(
            "cards-playing-club-outline",
            "F18A5",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "GreenTurtwig",
            "6.3.95"));
  }

  public static MdiIcon cards_playing_diamond() {
    return MdiIcon.create(
        "mdi-cards-playing-diamond",
        new MdiMeta(
            "cards-playing-diamond",
            "F18A6",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "GreenTurtwig",
            "6.3.95"));
  }

  public static MdiIcon cards_playing_diamond_multiple() {
    return MdiIcon.create(
        "mdi-cards-playing-diamond-multiple",
        new MdiMeta(
            "cards-playing-diamond-multiple",
            "F18A7",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "GreenTurtwig",
            "6.3.95"));
  }

  public static MdiIcon cards_playing_diamond_multiple_outline() {
    return MdiIcon.create(
        "mdi-cards-playing-diamond-multiple-outline",
        new MdiMeta(
            "cards-playing-diamond-multiple-outline",
            "F18A8",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "GreenTurtwig",
            "6.3.95"));
  }

  public static MdiIcon cards_playing_diamond_outline() {
    return MdiIcon.create(
        "mdi-cards-playing-diamond-outline",
        new MdiMeta(
            "cards-playing-diamond-outline",
            "F18A9",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "GreenTurtwig",
            "6.3.95"));
  }

  public static MdiIcon cards_playing_heart() {
    return MdiIcon.create(
        "mdi-cards-playing-heart",
        new MdiMeta(
            "cards-playing-heart",
            "F18AA",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "GreenTurtwig",
            "6.3.95"));
  }

  public static MdiIcon cards_playing_heart_multiple() {
    return MdiIcon.create(
        "mdi-cards-playing-heart-multiple",
        new MdiMeta(
            "cards-playing-heart-multiple",
            "F18AB",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "GreenTurtwig",
            "6.3.95"));
  }

  public static MdiIcon cards_playing_heart_multiple_outline() {
    return MdiIcon.create(
        "mdi-cards-playing-heart-multiple-outline",
        new MdiMeta(
            "cards-playing-heart-multiple-outline",
            "F18AC",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "GreenTurtwig",
            "6.3.95"));
  }

  public static MdiIcon cards_playing_heart_outline() {
    return MdiIcon.create(
        "mdi-cards-playing-heart-outline",
        new MdiMeta(
            "cards-playing-heart-outline",
            "F18AD",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "GreenTurtwig",
            "6.3.95"));
  }

  public static MdiIcon cards_playing_outline() {
    return MdiIcon.create(
        "mdi-cards-playing-outline",
        new MdiMeta(
            "cards-playing-outline",
            "F063A",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "Simran",
            "1.6.50"));
  }

  public static MdiIcon cards_playing_spade() {
    return MdiIcon.create(
        "mdi-cards-playing-spade",
        new MdiMeta(
            "cards-playing-spade",
            "F18AE",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "GreenTurtwig",
            "6.3.95"));
  }

  public static MdiIcon cards_playing_spade_multiple() {
    return MdiIcon.create(
        "mdi-cards-playing-spade-multiple",
        new MdiMeta(
            "cards-playing-spade-multiple",
            "F18AF",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "GreenTurtwig",
            "6.3.95"));
  }

  public static MdiIcon cards_playing_spade_multiple_outline() {
    return MdiIcon.create(
        "mdi-cards-playing-spade-multiple-outline",
        new MdiMeta(
            "cards-playing-spade-multiple-outline",
            "F18B0",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "GreenTurtwig",
            "6.3.95"));
  }

  public static MdiIcon cards_playing_spade_outline() {
    return MdiIcon.create(
        "mdi-cards-playing-spade-outline",
        new MdiMeta(
            "cards-playing-spade-outline",
            "F18B1",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "GreenTurtwig",
            "6.3.95"));
  }

  public static MdiIcon cards_spade() {
    return MdiIcon.create(
        "mdi-cards-spade",
        new MdiMeta(
            "cards-spade",
            "F08D1",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("suit-spades", "poker-spade"),
            "Nick",
            "2.3.50"));
  }

  public static MdiIcon cards_spade_outline() {
    return MdiIcon.create(
        "mdi-cards-spade-outline",
        new MdiMeta(
            "cards-spade-outline",
            "F18B2",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.3.95"));
  }

  public static MdiIcon cards_variant() {
    return MdiIcon.create(
        "mdi-cards-variant",
        new MdiMeta(
            "cards-variant",
            "F06C7",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "Case Sandberg",
            "1.8.36"));
  }

  public static MdiIcon carrot() {
    return MdiIcon.create(
        "mdi-carrot",
        new MdiMeta(
            "carrot",
            "F010F",
            Arrays.asList("Agriculture", "Food / Drink"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon cart() {
    return MdiIcon.create(
        "mdi-cart",
        new MdiMeta(
            "cart",
            "F0110",
            Arrays.asList("Shopping"),
            Arrays.asList("trolley", "local-grocery-store", "shopping-cart"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cart_arrow_down() {
    return MdiIcon.create(
        "mdi-cart-arrow-down",
        new MdiMeta(
            "cart-arrow-down",
            "F0D66",
            Arrays.asList("Shopping"),
            Arrays.asList("shopping-cart-arrow-down", "trolley-arrow-down"),
            "Simran",
            "3.4.93"));
  }

  public static MdiIcon cart_arrow_right() {
    return MdiIcon.create(
        "mdi-cart-arrow-right",
        new MdiMeta(
            "cart-arrow-right",
            "F0C4E",
            Arrays.asList("Shopping"),
            Arrays.asList("trolley-arrow-right", "shopping-cart-arrow-right"),
            "Michael Richins",
            "3.2.89"));
  }

  public static MdiIcon cart_arrow_up() {
    return MdiIcon.create(
        "mdi-cart-arrow-up",
        new MdiMeta(
            "cart-arrow-up",
            "F0D67",
            Arrays.asList("Shopping"),
            Arrays.asList("shopping-cart-arrow-up", "trolley-arrow-up"),
            "Simran",
            "3.4.93"));
  }

  public static MdiIcon cart_check() {
    return MdiIcon.create(
        "mdi-cart-check",
        new MdiMeta(
            "cart-check",
            "F15EA",
            Arrays.asList("Shopping"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.6.55"));
  }

  public static MdiIcon cart_heart() {
    return MdiIcon.create(
        "mdi-cart-heart",
        new MdiMeta(
            "cart-heart",
            "F18E0",
            Arrays.asList("Shopping"),
            Arrays.asList("cart-favorite", "shopping-favorite"),
            "Michael Irigoyen",
            "6.3.95"));
  }

  public static MdiIcon cart_minus() {
    return MdiIcon.create(
        "mdi-cart-minus",
        new MdiMeta(
            "cart-minus",
            "F0D68",
            Arrays.asList("Shopping"),
            Arrays.asList("shopping-cart-minus", "trolley-minus"),
            "Simran",
            "3.4.93"));
  }

  public static MdiIcon cart_off() {
    return MdiIcon.create(
        "mdi-cart-off",
        new MdiMeta(
            "cart-off",
            "F066B",
            Arrays.asList("Shopping"),
            Arrays.asList("trolley-off", "remove-shopping-cart", "shopping-cart-off"),
            "Google",
            "1.6.50"));
  }

  public static MdiIcon cart_outline() {
    return MdiIcon.create(
        "mdi-cart-outline",
        new MdiMeta(
            "cart-outline",
            "F0111",
            Arrays.asList("Shopping"),
            Arrays.asList("trolley-outline", "shopping-cart-outline"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cart_percent() {
    return MdiIcon.create(
        "mdi-cart-percent",
        new MdiMeta(
            "cart-percent",
            "F1BAE",
            Arrays.asList("Shopping"),
            Arrays.asList("cart-discount", "cart-sale", "trolley-percent"),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon cart_plus() {
    return MdiIcon.create(
        "mdi-cart-plus",
        new MdiMeta(
            "cart-plus",
            "F0112",
            Arrays.asList("Shopping"),
            Arrays.asList(
                "trolley-plus",
                "add-shopping-cart",
                "shopping-cart-plus",
                "cart-add",
                "trolley-add",
                "shopping-cart-add"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cart_remove() {
    return MdiIcon.create(
        "mdi-cart-remove",
        new MdiMeta(
            "cart-remove",
            "F0D69",
            Arrays.asList("Shopping"),
            Arrays.asList("trolley-remove", "shopping-cart-remove"),
            "Simran",
            "3.4.93"));
  }

  public static MdiIcon cart_variant() {
    return MdiIcon.create(
        "mdi-cart-variant",
        new MdiMeta(
            "cart-variant",
            "F15EB",
            Arrays.asList("Shopping"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.6.55"));
  }

  public static MdiIcon case_sensitive_alt() {
    return MdiIcon.create(
        "mdi-case-sensitive-alt",
        new MdiMeta(
            "case-sensitive-alt",
            "F0113",
            Arrays.asList(),
            Arrays.asList(),
            "Doug C. Hardester",
            "1.5.54"));
  }

  public static MdiIcon cash() {
    return MdiIcon.create(
        "mdi-cash",
        new MdiMeta(
            "cash",
            "F0114",
            Arrays.asList("Currency", "Banking", "Shopping"),
            Arrays.asList("money"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon cash_100() {
    return MdiIcon.create(
        "mdi-cash-100",
        new MdiMeta(
            "cash-100",
            "F0115",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList("money-100"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cash_check() {
    return MdiIcon.create(
        "mdi-cash-check",
        new MdiMeta(
            "cash-check",
            "F14EE",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList(),
            "Lucas Crivellari Macieira",
            "5.4.55"));
  }

  public static MdiIcon cash_clock() {
    return MdiIcon.create(
        "mdi-cash-clock",
        new MdiMeta(
            "cash-clock",
            "F1A91",
            Arrays.asList("Banking", "Currency", "Date / Time"),
            Arrays.asList("cash-schedule", "payment-schedule", "payment-clock", "auto-pay"),
            "Michael Irigoyen",
            "6.8.96"));
  }

  public static MdiIcon cash_fast() {
    return MdiIcon.create(
        "mdi-cash-fast",
        new MdiMeta(
            "cash-fast",
            "F185C",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList("instant-deposit", "instant-transfer", "instant-cash"),
            "Jeff Anders",
            "6.2.95"));
  }

  public static MdiIcon cash_lock() {
    return MdiIcon.create(
        "mdi-cash-lock",
        new MdiMeta(
            "cash-lock",
            "F14EA",
            Arrays.asList("Lock", "Currency", "Banking"),
            Arrays.asList(),
            "Austin Andrews",
            "5.4.55"));
  }

  public static MdiIcon cash_lock_open() {
    return MdiIcon.create(
        "mdi-cash-lock-open",
        new MdiMeta(
            "cash-lock-open",
            "F14EB",
            Arrays.asList("Lock", "Currency", "Banking"),
            Arrays.asList(),
            "Austin Andrews",
            "5.4.55"));
  }

  public static MdiIcon cash_marker() {
    return MdiIcon.create(
        "mdi-cash-marker",
        new MdiMeta(
            "cash-marker",
            "F0DB8",
            Arrays.asList("Banking", "Currency", "Navigation"),
            Arrays.asList("cod", "cash-on-delivery", "cash-location"),
            "Michael Irigoyen",
            "3.5.94"));
  }

  public static MdiIcon cash_minus() {
    return MdiIcon.create(
        "mdi-cash-minus",
        new MdiMeta(
            "cash-minus",
            "F1260",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList(),
            "sergiocarlotto",
            "4.7.95"));
  }

  public static MdiIcon cash_multiple() {
    return MdiIcon.create(
        "mdi-cash-multiple",
        new MdiMeta(
            "cash-multiple",
            "F0116",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList("money"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon cash_off() {
    return MdiIcon.create(
        "mdi-cash-off",
        new MdiMeta(
            "cash-off",
            "F1C79",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList(),
            "Andrej Sharapov",
            "7.2.96"));
  }

  public static MdiIcon cash_plus() {
    return MdiIcon.create(
        "mdi-cash-plus",
        new MdiMeta(
            "cash-plus",
            "F1261",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList(),
            "sergiocarlotto",
            "4.7.95"));
  }

  public static MdiIcon cash_refund() {
    return MdiIcon.create(
        "mdi-cash-refund",
        new MdiMeta(
            "cash-refund",
            "F0A9C",
            Arrays.asList("Banking", "Currency"),
            Arrays.asList("cash-return", "cash-chargeback"),
            "Michael Richins",
            "2.7.94"));
  }

  public static MdiIcon cash_register() {
    return MdiIcon.create(
        "mdi-cash-register",
        new MdiMeta(
            "cash-register",
            "F0CF4",
            Arrays.asList("Shopping", "Banking"),
            Arrays.asList("till"),
            "TheManuz",
            "3.3.92"));
  }

  public static MdiIcon cash_remove() {
    return MdiIcon.create(
        "mdi-cash-remove",
        new MdiMeta(
            "cash-remove",
            "F1262",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList(),
            "Austin Andrews",
            "4.7.95"));
  }

  public static MdiIcon cash_sync() {
    return MdiIcon.create(
        "mdi-cash-sync",
        new MdiMeta(
            "cash-sync",
            "F1A92",
            Arrays.asList("Banking", "Currency"),
            Arrays.asList("auto-pay", "recurring-payment", "scheduled-payment", "cash-cycle"),
            "Michael Irigoyen",
            "6.8.96"));
  }

  public static MdiIcon cassette() {
    return MdiIcon.create(
        "mdi-cassette",
        new MdiMeta(
            "cassette",
            "F09D4",
            Arrays.asList("Music"),
            Arrays.asList("tape"),
            "GreenTurtwig",
            "2.5.94"));
  }

  public static MdiIcon cast() {
    return MdiIcon.create(
        "mdi-cast",
        new MdiMeta(
            "cast",
            "F0118",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cast_audio() {
    return MdiIcon.create(
        "mdi-cast-audio",
        new MdiMeta(
            "cast-audio",
            "F101E",
            Arrays.asList("Audio"),
            Arrays.asList("cast-speaker"),
            "Kinetic Screen",
            "4.1.95"));
  }

  public static MdiIcon cast_audio_variant() {
    return MdiIcon.create(
        "mdi-cast-audio-variant",
        new MdiMeta(
            "cast-audio-variant",
            "F1749",
            Arrays.asList(),
            Arrays.asList("apple-airplay"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon cast_connected() {
    return MdiIcon.create(
        "mdi-cast-connected",
        new MdiMeta(
            "cast-connected",
            "F0119",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cast_education() {
    return MdiIcon.create(
        "mdi-cast-education",
        new MdiMeta(
            "cast-education",
            "F0E1D",
            Arrays.asList(),
            Arrays.asList("cast-school", "school-online", "cast-tutorial"),
            "Google",
            "3.6.95"));
  }

  public static MdiIcon cast_off() {
    return MdiIcon.create(
        "mdi-cast-off",
        new MdiMeta(
            "cast-off",
            "F078A",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Simran",
            "1.9.32"));
  }

  public static MdiIcon cast_variant() {
    return MdiIcon.create(
        "mdi-cast-variant",
        new MdiMeta(
            "cast-variant",
            "F001F",
            Arrays.asList("Home Automation"),
            Arrays.asList("apple", "airplay"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon castle() {
    return MdiIcon.create(
        "mdi-castle",
        new MdiMeta(
            "castle",
            "F011A",
            Arrays.asList("Places"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon cat() {
    return MdiIcon.create(
        "mdi-cat",
        new MdiMeta(
            "cat",
            "F011B",
            Arrays.asList("Animal", "Holiday"),
            Arrays.asList("emoji-cat", "emoticon-cat"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon cctv() {
    return MdiIcon.create(
        "mdi-cctv",
        new MdiMeta(
            "cctv",
            "F07AE",
            Arrays.asList("Home Automation"),
            Arrays.asList("closed-circuit-television", "security-camera"),
            "Roberto Graham",
            "2.0.46"));
  }

  public static MdiIcon cctv_off() {
    return MdiIcon.create(
        "mdi-cctv-off",
        new MdiMeta(
            "cctv-off",
            "F185F",
            Arrays.asList("Home Automation"),
            Arrays.asList("closed-circuit-television-off", "security-camera-off"),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon ceiling_fan() {
    return MdiIcon.create(
        "mdi-ceiling-fan",
        new MdiMeta(
            "ceiling-fan",
            "F1797",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "nilsfast",
            "6.1.95"));
  }

  public static MdiIcon ceiling_fan_light() {
    return MdiIcon.create(
        "mdi-ceiling-fan-light",
        new MdiMeta(
            "ceiling-fan-light",
            "F1798",
            Arrays.asList("Home Automation"),
            Arrays.asList("ceiling-fan-on"),
            "nilsfast",
            "6.1.95"));
  }

  public static MdiIcon ceiling_light() {
    return MdiIcon.create(
        "mdi-ceiling-light",
        new MdiMeta(
            "ceiling-light",
            "F0769",
            Arrays.asList("Home Automation"),
            Arrays.asList("ceiling-lamp"),
            "GreenTurtwig",
            "1.9.32"));
  }

  public static MdiIcon ceiling_light_multiple() {
    return MdiIcon.create(
        "mdi-ceiling-light-multiple",
        new MdiMeta(
            "ceiling-light-multiple",
            "F18DD",
            Arrays.asList("Home Automation"),
            Arrays.asList("ceiling-lamp-multiple"),
            "Michael Irigoyen",
            "6.3.95"));
  }

  public static MdiIcon ceiling_light_multiple_outline() {
    return MdiIcon.create(
        "mdi-ceiling-light-multiple-outline",
        new MdiMeta(
            "ceiling-light-multiple-outline",
            "F18DE",
            Arrays.asList("Home Automation"),
            Arrays.asList("ceiling-lamp-multiple-outline"),
            "Michael Irigoyen",
            "6.3.95"));
  }

  public static MdiIcon ceiling_light_outline() {
    return MdiIcon.create(
        "mdi-ceiling-light-outline",
        new MdiMeta(
            "ceiling-light-outline",
            "F17C7",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Teodor Sandu",
            "6.1.95"));
  }

  public static MdiIcon cellphone() {
    return MdiIcon.create(
        "mdi-cellphone",
        new MdiMeta(
            "cellphone",
            "F011C",
            Arrays.asList("Cellphone / Phone", "Device / Tech"),
            Arrays.asList(
                "mobile-phone", "smartphone", "stay-current-portrait", "stay-primary-portrait"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cellphone_arrow_down() {
    return MdiIcon.create(
        "mdi-cellphone-arrow-down",
        new MdiMeta(
            "cellphone-arrow-down",
            "F09D5",
            Arrays.asList("Cellphone / Phone", "Device / Tech"),
            Arrays.asList(
                "cellphone-system-update", "mobile-phone-arrow-down", "smartphone-arrow-down"),
            "Google",
            "2.5.94"));
  }

  public static MdiIcon cellphone_arrow_down_variant() {
    return MdiIcon.create(
        "mdi-cellphone-arrow-down-variant",
        new MdiMeta(
            "cellphone-arrow-down-variant",
            "F19C5",
            Arrays.asList("Cellphone / Phone"),
            Arrays.asList("cellphone-download"),
            "Michael Irigoyen",
            "6.6.96"));
  }

  public static MdiIcon cellphone_basic() {
    return MdiIcon.create(
        "mdi-cellphone-basic",
        new MdiMeta(
            "cellphone-basic",
            "F011E",
            Arrays.asList("Cellphone / Phone", "Device / Tech"),
            Arrays.asList("mobile-phone-basic"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon cellphone_charging() {
    return MdiIcon.create(
        "mdi-cellphone-charging",
        new MdiMeta(
            "cellphone-charging",
            "F1397",
            Arrays.asList("Cellphone / Phone"),
            Arrays.asList(),
            "Moma Design Studio",
            "5.0.45"));
  }

  public static MdiIcon cellphone_check() {
    return MdiIcon.create(
        "mdi-cellphone-check",
        new MdiMeta(
            "cellphone-check",
            "F17FD",
            Arrays.asList("Cellphone / Phone"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.1.95"));
  }

  public static MdiIcon cellphone_cog() {
    return MdiIcon.create(
        "mdi-cellphone-cog",
        new MdiMeta(
            "cellphone-cog",
            "F0951",
            Arrays.asList("Settings", "Cellphone / Phone", "Device / Tech"),
            Arrays.asList(
                "phonelink-setup", "mobile-phone-settings-variant", "smartphone-settings-variant"),
            "Google",
            "2.4.85"));
  }

  public static MdiIcon cellphone_dock() {
    return MdiIcon.create(
        "mdi-cellphone-dock",
        new MdiMeta(
            "cellphone-dock",
            "F011F",
            Arrays.asList("Cellphone / Phone", "Device / Tech"),
            Arrays.asList("mobile-phone-dock", "smartphone-dock"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cellphone_information() {
    return MdiIcon.create(
        "mdi-cellphone-information",
        new MdiMeta(
            "cellphone-information",
            "F0F41",
            Arrays.asList("Cellphone / Phone"),
            Arrays.asList("mobile-phone-information", "smartphone-information"),
            "Google",
            "3.9.97"));
  }

  public static MdiIcon cellphone_key() {
    return MdiIcon.create(
        "mdi-cellphone-key",
        new MdiMeta(
            "cellphone-key",
            "F094E",
            Arrays.asList("Cellphone / Phone", "Device / Tech"),
            Arrays.asList("mobile-phone-key", "smartphone-key"),
            "GreenTurtwig",
            "2.4.85"));
  }

  public static MdiIcon cellphone_link() {
    return MdiIcon.create(
        "mdi-cellphone-link",
        new MdiMeta(
            "cellphone-link",
            "F0121",
            Arrays.asList("Cellphone / Phone", "Device / Tech"),
            Arrays.asList("mobile-phone-link", "smartphone-link", "devices"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cellphone_link_off() {
    return MdiIcon.create(
        "mdi-cellphone-link-off",
        new MdiMeta(
            "cellphone-link-off",
            "F0122",
            Arrays.asList("Cellphone / Phone", "Device / Tech"),
            Arrays.asList("mobile-phone-link-off", "smartphone-link-off", "phonelink-off"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cellphone_lock() {
    return MdiIcon.create(
        "mdi-cellphone-lock",
        new MdiMeta(
            "cellphone-lock",
            "F094F",
            Arrays.asList("Cellphone / Phone", "Lock", "Device / Tech"),
            Arrays.asList("phonelink-lock", "mobile-phone-lock", "smartphone-lock"),
            "Google",
            "2.4.85"));
  }

  public static MdiIcon cellphone_marker() {
    return MdiIcon.create(
        "mdi-cellphone-marker",
        new MdiMeta(
            "cellphone-marker",
            "F183A",
            Arrays.asList("Cellphone / Phone", "Navigation"),
            Arrays.asList("cellphone-location", "cellphone-map", "find-my-phone", "cellphone-gps"),
            "Michael Irigoyen",
            "6.2.95"));
  }

  public static MdiIcon cellphone_message() {
    return MdiIcon.create(
        "mdi-cellphone-message",
        new MdiMeta(
            "cellphone-message",
            "F08D3",
            Arrays.asList("Cellphone / Phone", "Device / Tech"),
            Arrays.asList("mobile-phone-message", "smartphone-message"),
            "Austin Andrews",
            "2.3.50"));
  }

  public static MdiIcon cellphone_message_off() {
    return MdiIcon.create(
        "mdi-cellphone-message-off",
        new MdiMeta(
            "cellphone-message-off",
            "F10D2",
            Arrays.asList("Cellphone / Phone"),
            Arrays.asList(),
            "Terren",
            "4.3.95"));
  }

  public static MdiIcon cellphone_nfc() {
    return MdiIcon.create(
        "mdi-cellphone-nfc",
        new MdiMeta(
            "cellphone-nfc",
            "F0E90",
            Arrays.asList("Automotive", "Cellphone / Phone", "Device / Tech"),
            Arrays.asList(),
            "Google",
            "3.7.94"));
  }

  public static MdiIcon cellphone_nfc_off() {
    return MdiIcon.create(
        "mdi-cellphone-nfc-off",
        new MdiMeta(
            "cellphone-nfc-off",
            "F12D8",
            Arrays.asList("Cellphone / Phone"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.8.95"));
  }

  public static MdiIcon cellphone_off() {
    return MdiIcon.create(
        "mdi-cellphone-off",
        new MdiMeta(
            "cellphone-off",
            "F0950",
            Arrays.asList("Cellphone / Phone", "Device / Tech"),
            Arrays.asList("mobile-phone-off", "smartphone-off", "mobile-off"),
            "Google",
            "2.4.85"));
  }

  public static MdiIcon cellphone_play() {
    return MdiIcon.create(
        "mdi-cellphone-play",
        new MdiMeta(
            "cellphone-play",
            "F101F",
            Arrays.asList("Cellphone / Phone"),
            Arrays.asList(),
            "Google",
            "4.1.95"));
  }

  public static MdiIcon cellphone_remove() {
    return MdiIcon.create(
        "mdi-cellphone-remove",
        new MdiMeta(
            "cellphone-remove",
            "F094D",
            Arrays.asList("Cellphone / Phone", "Device / Tech"),
            Arrays.asList(
                "phonelink-erase", "mobile-phone-erase", "smartphone-erase", "cellphone-erase"),
            "Michael Irigoyen",
            "2.4.85"));
  }

  public static MdiIcon cellphone_screenshot() {
    return MdiIcon.create(
        "mdi-cellphone-screenshot",
        new MdiMeta(
            "cellphone-screenshot",
            "F0A35",
            Arrays.asList("Cellphone / Phone", "Device / Tech"),
            Arrays.asList(),
            "Google",
            "2.6.95"));
  }

  public static MdiIcon cellphone_settings() {
    return MdiIcon.create(
        "mdi-cellphone-settings",
        new MdiMeta(
            "cellphone-settings",
            "F0123",
            Arrays.asList("Cellphone / Phone", "Settings", "Device / Tech"),
            Arrays.asList("mobile-phone-settings", "smartphone-settings", "settings-cell"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cellphone_sound() {
    return MdiIcon.create(
        "mdi-cellphone-sound",
        new MdiMeta(
            "cellphone-sound",
            "F0952",
            Arrays.asList("Cellphone / Phone", "Device / Tech"),
            Arrays.asList("phonelink-ring", "mobile-phone-sound", "smartphone-sound"),
            "Google",
            "2.4.85"));
  }

  public static MdiIcon cellphone_text() {
    return MdiIcon.create(
        "mdi-cellphone-text",
        new MdiMeta(
            "cellphone-text",
            "F08D2",
            Arrays.asList("Cellphone / Phone", "Device / Tech"),
            Arrays.asList("mobile-phone-text", "smartphone-text"),
            "Austin Andrews",
            "2.3.50"));
  }

  public static MdiIcon cellphone_wireless() {
    return MdiIcon.create(
        "mdi-cellphone-wireless",
        new MdiMeta(
            "cellphone-wireless",
            "F0815",
            Arrays.asList("Cellphone / Phone", "Device / Tech"),
            Arrays.asList("mobile-phone-wireless", "smartphone-wireless"),
            "Austin Andrews",
            "2.1.19"));
  }

  @Deprecated
  public static MdiIcon centos() {
    return MdiIcon.create(
        "mdi-centos",
        new MdiMeta(
            "centos",
            "F111A",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "4.3.95"));
  }

  public static MdiIcon certificate() {
    return MdiIcon.create(
        "mdi-certificate",
        new MdiMeta(
            "certificate",
            "F0124",
            Arrays.asList(),
            Arrays.asList("diploma", "seal"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon certificate_outline() {
    return MdiIcon.create(
        "mdi-certificate-outline",
        new MdiMeta(
            "certificate-outline",
            "F1188",
            Arrays.asList(),
            Arrays.asList("diploma-outline", "seal-outline"),
            "Michael Richins",
            "4.4.95"));
  }

  public static MdiIcon chair_rolling() {
    return MdiIcon.create(
        "mdi-chair-rolling",
        new MdiMeta(
            "chair-rolling",
            "F0F48",
            Arrays.asList("Home Automation"),
            Arrays.asList("office-chair", "study-chair"),
            "Michael Irigoyen",
            "3.9.97"));
  }

  public static MdiIcon chair_school() {
    return MdiIcon.create(
        "mdi-chair-school",
        new MdiMeta(
            "chair-school",
            "F0125",
            Arrays.asList(),
            Arrays.asList("desk", "education", "learn"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon chandelier() {
    return MdiIcon.create(
        "mdi-chandelier",
        new MdiMeta(
            "chandelier",
            "F1793",
            Arrays.asList("Home Automation"),
            Arrays.asList("ceiling-light", "girandole", "candelabra-lamp", "suspended-light"),
            "Michael Irigoyen",
            "6.1.95"));
  }

  public static MdiIcon charity() {
    return MdiIcon.create(
        "mdi-charity",
        new MdiMeta(
            "charity",
            "F0C4F",
            Arrays.asList(),
            Arrays.asList("super-chat-for-good"),
            "Google",
            "3.2.89"));
  }

  public static MdiIcon chart_arc() {
    return MdiIcon.create(
        "mdi-chart-arc",
        new MdiMeta(
            "chart-arc",
            "F0126",
            Arrays.asList("Math"),
            Arrays.asList("report-arc", "widget-arc"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon chart_areaspline() {
    return MdiIcon.create(
        "mdi-chart-areaspline",
        new MdiMeta(
            "chart-areaspline",
            "F0127",
            Arrays.asList("Math"),
            Arrays.asList("report-areaspline", "widget-areaspline", "graph-areaspline"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon chart_areaspline_variant() {
    return MdiIcon.create(
        "mdi-chart-areaspline-variant",
        new MdiMeta(
            "chart-areaspline-variant",
            "F0E91",
            Arrays.asList("Math"),
            Arrays.asList(
                "report-areaspline-variant",
                "widget-areaspline-variant",
                "graph-areaspline-variant"),
            "Michael Richins",
            "3.7.94"));
  }

  public static MdiIcon chart_bar() {
    return MdiIcon.create(
        "mdi-chart-bar",
        new MdiMeta(
            "chart-bar",
            "F0128",
            Arrays.asList("Math"),
            Arrays.asList("report-bar", "widget-bar", "graph-bar"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon chart_bar_stacked() {
    return MdiIcon.create(
        "mdi-chart-bar-stacked",
        new MdiMeta(
            "chart-bar-stacked",
            "F076A",
            Arrays.asList("Math"),
            Arrays.asList("report-bar-stacked", "widget-bar-stacked", "graph-bar-stacked"),
            "Austin Andrews",
            "1.9.32"));
  }

  public static MdiIcon chart_bell_curve() {
    return MdiIcon.create(
        "mdi-chart-bell-curve",
        new MdiMeta(
            "chart-bell-curve",
            "F0C50",
            Arrays.asList("Math"),
            Arrays.asList("report-bell-curve", "widget-bell-curve", "graph-bell-curve"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon chart_bell_curve_cumulative() {
    return MdiIcon.create(
        "mdi-chart-bell-curve-cumulative",
        new MdiMeta(
            "chart-bell-curve-cumulative",
            "F0FA7",
            Arrays.asList("Math"),
            Arrays.asList(
                "report-bell-curve-cumulative",
                "widget-bell-curve-cumulative",
                "graph-bell-curve-cumulative"),
            "Michael Irigoyen",
            "4.0.96"));
  }

  public static MdiIcon chart_box() {
    return MdiIcon.create(
        "mdi-chart-box",
        new MdiMeta(
            "chart-box",
            "F154D",
            Arrays.asList("Math"),
            Arrays.asList("poll-box", "report-box", "widget-box", "graph-box"),
            "Google",
            "5.4.55"));
  }

  public static MdiIcon chart_box_outline() {
    return MdiIcon.create(
        "mdi-chart-box-outline",
        new MdiMeta(
            "chart-box-outline",
            "F154E",
            Arrays.asList("Math"),
            Arrays.asList(
                "poll-box-outline",
                "report-box-outline",
                "widget-box-outline",
                "graph-box-outline"),
            "Google",
            "5.4.55"));
  }

  public static MdiIcon chart_box_plus_outline() {
    return MdiIcon.create(
        "mdi-chart-box-plus-outline",
        new MdiMeta(
            "chart-box-plus-outline",
            "F154F",
            Arrays.asList("Math"),
            Arrays.asList(
                "report-box-plus-outline", "widget-box-plus-outline", "graph-box-plus-outline"),
            "Google",
            "5.4.55"));
  }

  public static MdiIcon chart_bubble() {
    return MdiIcon.create(
        "mdi-chart-bubble",
        new MdiMeta(
            "chart-bubble",
            "F05E3",
            Arrays.asList("Math"),
            Arrays.asList("bubble-chart", "report-bubble", "widget-bubble"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon chart_donut() {
    return MdiIcon.create(
        "mdi-chart-donut",
        new MdiMeta(
            "chart-donut",
            "F07AF",
            Arrays.asList("Math"),
            Arrays.asList("chart-doughnut", "data-usage", "report-donut", "widget-donut"),
            "Google",
            "2.0.46"));
  }

  public static MdiIcon chart_donut_variant() {
    return MdiIcon.create(
        "mdi-chart-donut-variant",
        new MdiMeta(
            "chart-donut-variant",
            "F07B0",
            Arrays.asList("Math"),
            Arrays.asList("chart-doughnut-variant", "report-donut-variant", "widget-donut-variant"),
            "Austin Andrews",
            "2.0.46"));
  }

  public static MdiIcon chart_gantt() {
    return MdiIcon.create(
        "mdi-chart-gantt",
        new MdiMeta(
            "chart-gantt",
            "F066C",
            Arrays.asList("Math"),
            Arrays.asList("report-gantt", "timeline", "widget-gantt", "roadmap"),
            "Austin Andrews",
            "1.6.50"));
  }

  public static MdiIcon chart_histogram() {
    return MdiIcon.create(
        "mdi-chart-histogram",
        new MdiMeta(
            "chart-histogram",
            "F0129",
            Arrays.asList("Math"),
            Arrays.asList("report-histogram", "widget-histogram", "graph-histogram"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon chart_line() {
    return MdiIcon.create(
        "mdi-chart-line",
        new MdiMeta(
            "chart-line",
            "F012A",
            Arrays.asList("Math"),
            Arrays.asList("report-line", "widget-line", "graph-line"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon chart_line_stacked() {
    return MdiIcon.create(
        "mdi-chart-line-stacked",
        new MdiMeta(
            "chart-line-stacked",
            "F076B",
            Arrays.asList("Math"),
            Arrays.asList("report-line-stacked", "widget-line-stacked", "graph-line-stacked"),
            "Haley Halcyon",
            "1.9.32"));
  }

  public static MdiIcon chart_line_variant() {
    return MdiIcon.create(
        "mdi-chart-line-variant",
        new MdiMeta(
            "chart-line-variant",
            "F07B1",
            Arrays.asList("Math"),
            Arrays.asList(
                "show-chart", "report-line-variant", "widget-line-variant", "graph-line-variant"),
            "Google",
            "2.0.46"));
  }

  public static MdiIcon chart_multiline() {
    return MdiIcon.create(
        "mdi-chart-multiline",
        new MdiMeta(
            "chart-multiline",
            "F08D4",
            Arrays.asList("Math"),
            Arrays.asList("report-multiline", "widget-multiline", "graph-multiline"),
            "Google",
            "2.3.50"));
  }

  public static MdiIcon chart_multiple() {
    return MdiIcon.create(
        "mdi-chart-multiple",
        new MdiMeta(
            "chart-multiple",
            "F1213",
            Arrays.asList("Math"),
            Arrays.asList("report-multiple", "widget-multiple", "graph-multiple"),
            "Michael Richins",
            "4.6.95"));
  }

  public static MdiIcon chart_pie() {
    return MdiIcon.create(
        "mdi-chart-pie",
        new MdiMeta(
            "chart-pie",
            "F012B",
            Arrays.asList("Math"),
            Arrays.asList("report-pie", "widget-pie", "graph-pie"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon chart_pie_outline() {
    return MdiIcon.create(
        "mdi-chart-pie-outline",
        new MdiMeta(
            "chart-pie-outline",
            "F1BDF",
            Arrays.asList("Math"),
            Arrays.asList("report-pie-outline", "widget-pie-outline", "graph-pie-outline"),
            "Google",
            "7.1.96"));
  }

  public static MdiIcon chart_ppf() {
    return MdiIcon.create(
        "mdi-chart-ppf",
        new MdiMeta(
            "chart-ppf",
            "F1380",
            Arrays.asList("Math"),
            Arrays.asList(
                "chart-production-possibility-frontier", "report-ppf", "widget-ppf", "graph-ppf"),
            "Simran",
            "4.9.95"));
  }

  public static MdiIcon chart_sankey() {
    return MdiIcon.create(
        "mdi-chart-sankey",
        new MdiMeta(
            "chart-sankey",
            "F11DF",
            Arrays.asList("Math"),
            Arrays.asList("chart-snakey", "report-sankey", "widget-sankey", "graph-sankey"),
            "Michael Richins",
            "4.5.95"));
  }

  public static MdiIcon chart_sankey_variant() {
    return MdiIcon.create(
        "mdi-chart-sankey-variant",
        new MdiMeta(
            "chart-sankey-variant",
            "F11E0",
            Arrays.asList("Math"),
            Arrays.asList(
                "chart-snakey-variant",
                "report-sankey-variant",
                "widget-sankey-variant",
                "graph-sankey-variant"),
            "Michael Richins",
            "4.5.95"));
  }

  public static MdiIcon chart_scatter_plot() {
    return MdiIcon.create(
        "mdi-chart-scatter-plot",
        new MdiMeta(
            "chart-scatter-plot",
            "F0E92",
            Arrays.asList("Math"),
            Arrays.asList("report-scatter-plot", "widget-scatter-plot", "graph-scatter-plot"),
            "Michael Irigoyen",
            "3.7.94"));
  }

  public static MdiIcon chart_scatter_plot_hexbin() {
    return MdiIcon.create(
        "mdi-chart-scatter-plot-hexbin",
        new MdiMeta(
            "chart-scatter-plot-hexbin",
            "F066D",
            Arrays.asList("Math"),
            Arrays.asList(
                "chart-scatterplot-hexbin",
                "report-scatter-plot-hexbin",
                "widget-scatter-plot-hexbin",
                "graph-scatter-plot-hexbin"),
            "Austin Andrews",
            "1.6.50"));
  }

  public static MdiIcon chart_timeline() {
    return MdiIcon.create(
        "mdi-chart-timeline",
        new MdiMeta(
            "chart-timeline",
            "F066E",
            Arrays.asList("Math"),
            Arrays.asList("report-timeline", "widget-timeline", "graph-timeline", "roadmap"),
            "Austin Andrews",
            "1.6.50"));
  }

  public static MdiIcon chart_timeline_variant() {
    return MdiIcon.create(
        "mdi-chart-timeline-variant",
        new MdiMeta(
            "chart-timeline-variant",
            "F0E93",
            Arrays.asList("Math"),
            Arrays.asList(
                "report-timeline-variant",
                "widget-timeline-variant",
                "graph-timeline-variant",
                "report-line",
                "widget-line",
                "graph-line"),
            "Google",
            "3.7.94"));
  }

  public static MdiIcon chart_timeline_variant_shimmer() {
    return MdiIcon.create(
        "mdi-chart-timeline-variant-shimmer",
        new MdiMeta(
            "chart-timeline-variant-shimmer",
            "F15B6",
            Arrays.asList("Math"),
            Arrays.asList(
                "report-timeline-variant-shimmer",
                "widget-timeline-variant-shimmer",
                "graph-timeline-variant-shimmer",
                "report-line-shimmer",
                "widget-line-shimmer",
                "graph-line-shimmer"),
            "Google",
            "5.6.55"));
  }

  public static MdiIcon chart_tree() {
    return MdiIcon.create(
        "mdi-chart-tree",
        new MdiMeta(
            "chart-tree",
            "F0E94",
            Arrays.asList("Math"),
            Arrays.asList("report-tree", "widget-tree"),
            "Google",
            "3.7.94"));
  }

  public static MdiIcon chart_waterfall() {
    return MdiIcon.create(
        "mdi-chart-waterfall",
        new MdiMeta(
            "chart-waterfall",
            "F1918",
            Arrays.asList("Math"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon chat() {
    return MdiIcon.create(
        "mdi-chat",
        new MdiMeta("chat", "F0B79", Arrays.asList(), Arrays.asList(), "Austin Andrews", "3.0.39"));
  }

  public static MdiIcon chat_alert() {
    return MdiIcon.create(
        "mdi-chat-alert",
        new MdiMeta(
            "chat-alert",
            "F0B7A",
            Arrays.asList("Alert / Error"),
            Arrays.asList("chat-warning"),
            "Austin Andrews",
            "3.0.39"));
  }

  public static MdiIcon chat_alert_outline() {
    return MdiIcon.create(
        "mdi-chat-alert-outline",
        new MdiMeta(
            "chat-alert-outline",
            "F12C9",
            Arrays.asList("Alert / Error"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.8.95"));
  }

  public static MdiIcon chat_minus() {
    return MdiIcon.create(
        "mdi-chat-minus",
        new MdiMeta(
            "chat-minus", "F1410", Arrays.asList(), Arrays.asList(), "Austin Andrews", "5.1.45"));
  }

  public static MdiIcon chat_minus_outline() {
    return MdiIcon.create(
        "mdi-chat-minus-outline",
        new MdiMeta(
            "chat-minus-outline",
            "F1413",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "5.1.45"));
  }

  public static MdiIcon chat_outline() {
    return MdiIcon.create(
        "mdi-chat-outline",
        new MdiMeta(
            "chat-outline",
            "F0EDE",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "3.8.95"));
  }

  public static MdiIcon chat_plus() {
    return MdiIcon.create(
        "mdi-chat-plus",
        new MdiMeta(
            "chat-plus", "F140F", Arrays.asList(), Arrays.asList(), "Austin Andrews", "5.1.45"));
  }

  public static MdiIcon chat_plus_outline() {
    return MdiIcon.create(
        "mdi-chat-plus-outline",
        new MdiMeta(
            "chat-plus-outline",
            "F1412",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "5.1.45"));
  }

  public static MdiIcon chat_processing() {
    return MdiIcon.create(
        "mdi-chat-processing",
        new MdiMeta(
            "chat-processing",
            "F0B7B",
            Arrays.asList(),
            Arrays.asList("chat-typing"),
            "Austin Andrews",
            "3.0.39"));
  }

  public static MdiIcon chat_processing_outline() {
    return MdiIcon.create(
        "mdi-chat-processing-outline",
        new MdiMeta(
            "chat-processing-outline",
            "F12CA",
            Arrays.asList(),
            Arrays.asList("chat-typing-outline"),
            "Michael Irigoyen",
            "4.8.95"));
  }

  public static MdiIcon chat_question() {
    return MdiIcon.create(
        "mdi-chat-question",
        new MdiMeta(
            "chat-question",
            "F1738",
            Arrays.asList(),
            Arrays.asList("chat-help"),
            "Colton Wiscombe",
            "5.9.55"));
  }

  public static MdiIcon chat_question_outline() {
    return MdiIcon.create(
        "mdi-chat-question-outline",
        new MdiMeta(
            "chat-question-outline",
            "F1739",
            Arrays.asList(),
            Arrays.asList("chat-help-outline"),
            "Colton Wiscombe",
            "5.9.55"));
  }

  public static MdiIcon chat_remove() {
    return MdiIcon.create(
        "mdi-chat-remove",
        new MdiMeta(
            "chat-remove", "F1411", Arrays.asList(), Arrays.asList(), "Austin Andrews", "5.1.45"));
  }

  public static MdiIcon chat_remove_outline() {
    return MdiIcon.create(
        "mdi-chat-remove-outline",
        new MdiMeta(
            "chat-remove-outline",
            "F1414",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "5.1.45"));
  }

  public static MdiIcon chat_sleep() {
    return MdiIcon.create(
        "mdi-chat-sleep",
        new MdiMeta(
            "chat-sleep", "F12D1", Arrays.asList(), Arrays.asList(), "Michael Irigoyen", "4.8.95"));
  }

  public static MdiIcon chat_sleep_outline() {
    return MdiIcon.create(
        "mdi-chat-sleep-outline",
        new MdiMeta(
            "chat-sleep-outline",
            "F12D2",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.8.95"));
  }

  public static MdiIcon check() {
    return MdiIcon.create(
        "mdi-check",
        new MdiMeta(
            "check",
            "F012C",
            Arrays.asList("Form"),
            Arrays.asList("tick", "done", "success"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon check_all() {
    return MdiIcon.create(
        "mdi-check-all",
        new MdiMeta(
            "check-all",
            "F012D",
            Arrays.asList(),
            Arrays.asList("tick-all", "done-all", "check-multiple", "checks", "ticks"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon check_bold() {
    return MdiIcon.create(
        "mdi-check-bold",
        new MdiMeta(
            "check-bold",
            "F0E1E",
            Arrays.asList(),
            Arrays.asList("check-thick", "success-thick", "success-bold"),
            "Michael Richins",
            "3.6.95"));
  }

  public static MdiIcon check_circle() {
    return MdiIcon.create(
        "mdi-check-circle",
        new MdiMeta(
            "check-circle",
            "F05E0",
            Arrays.asList("Form"),
            Arrays.asList("tick-circle", "success-circle"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon check_circle_outline() {
    return MdiIcon.create(
        "mdi-check-circle-outline",
        new MdiMeta(
            "check-circle-outline",
            "F05E1",
            Arrays.asList("Form"),
            Arrays.asList("tick-circle-outline", "success-circle-outline"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon check_decagram() {
    return MdiIcon.create(
        "mdi-check-decagram",
        new MdiMeta(
            "check-decagram",
            "F0791",
            Arrays.asList(),
            Arrays.asList("verified", "decagram-check", "approve", "approval", "tick-decagram"),
            "Michael Richins",
            "2.0.46"));
  }

  public static MdiIcon check_decagram_outline() {
    return MdiIcon.create(
        "mdi-check-decagram-outline",
        new MdiMeta(
            "check-decagram-outline",
            "F1740",
            Arrays.asList(),
            Arrays.asList("approve", "approval", "verified"),
            "Jeff Anders",
            "5.9.55"));
  }

  public static MdiIcon check_network() {
    return MdiIcon.create(
        "mdi-check-network",
        new MdiMeta(
            "check-network",
            "F0C53",
            Arrays.asList(),
            Arrays.asList("tick-network"),
            "Michael Richins",
            "3.2.89"));
  }

  public static MdiIcon check_network_outline() {
    return MdiIcon.create(
        "mdi-check-network-outline",
        new MdiMeta(
            "check-network-outline",
            "F0C54",
            Arrays.asList(),
            Arrays.asList("tick-network-outline"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon check_outline() {
    return MdiIcon.create(
        "mdi-check-outline",
        new MdiMeta(
            "check-outline",
            "F0855",
            Arrays.asList(),
            Arrays.asList("done-outline", "tick-outline", "sucess-outline"),
            "Google",
            "2.1.99"));
  }

  public static MdiIcon check_underline() {
    return MdiIcon.create(
        "mdi-check-underline",
        new MdiMeta(
            "check-underline",
            "F0E1F",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "3.6.95"));
  }

  public static MdiIcon check_underline_circle() {
    return MdiIcon.create(
        "mdi-check-underline-circle",
        new MdiMeta(
            "check-underline-circle",
            "F0E20",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.6.95"));
  }

  public static MdiIcon check_underline_circle_outline() {
    return MdiIcon.create(
        "mdi-check-underline-circle-outline",
        new MdiMeta(
            "check-underline-circle-outline",
            "F0E21",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.6.95"));
  }

  public static MdiIcon checkbook() {
    return MdiIcon.create(
        "mdi-checkbook",
        new MdiMeta(
            "checkbook",
            "F0A9D",
            Arrays.asList("Banking"),
            Arrays.asList("chequebook", "cheque-book"),
            "Google",
            "2.7.94"));
  }

  public static MdiIcon checkbook_arrow_left() {
    return MdiIcon.create(
        "mdi-checkbook-arrow-left",
        new MdiMeta(
            "checkbook-arrow-left",
            "F1C1D",
            Arrays.asList("Banking"),
            Arrays.asList("chequebook-arrow-left"),
            "Jeff Anders",
            "7.2.96"));
  }

  public static MdiIcon checkbook_arrow_right() {
    return MdiIcon.create(
        "mdi-checkbook-arrow-right",
        new MdiMeta(
            "checkbook-arrow-right",
            "F1C1E",
            Arrays.asList("Banking"),
            Arrays.asList("chequebook-arrow-right"),
            "Jeff Anders",
            "7.2.96"));
  }

  public static MdiIcon checkbox_blank() {
    return MdiIcon.create(
        "mdi-checkbox-blank",
        new MdiMeta(
            "checkbox-blank", "F012E", Arrays.asList("Form"), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon checkbox_blank_badge() {
    return MdiIcon.create(
        "mdi-checkbox-blank-badge",
        new MdiMeta(
            "checkbox-blank-badge",
            "F1176",
            Arrays.asList("Notification", "Form"),
            Arrays.asList("checkbox-blank-notification", "app-notification", "app-badge"),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon checkbox_blank_badge_outline() {
    return MdiIcon.create(
        "mdi-checkbox-blank-badge-outline",
        new MdiMeta(
            "checkbox-blank-badge-outline",
            "F0117",
            Arrays.asList("Notification", "Form"),
            Arrays.asList(
                "checkbox-blank-notification-outline",
                "app-notification-outline",
                "app-badge-outline"),
            "Michael Irigoyen",
            "1.5.54"));
  }

  public static MdiIcon checkbox_blank_circle() {
    return MdiIcon.create(
        "mdi-checkbox-blank-circle",
        new MdiMeta(
            "checkbox-blank-circle",
            "F012F",
            Arrays.asList("Form"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon checkbox_blank_circle_outline() {
    return MdiIcon.create(
        "mdi-checkbox-blank-circle-outline",
        new MdiMeta(
            "checkbox-blank-circle-outline",
            "F0130",
            Arrays.asList("Form"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon checkbox_blank_off() {
    return MdiIcon.create(
        "mdi-checkbox-blank-off",
        new MdiMeta(
            "checkbox-blank-off",
            "F12EC",
            Arrays.asList("Form"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.8.95"));
  }

  public static MdiIcon checkbox_blank_off_outline() {
    return MdiIcon.create(
        "mdi-checkbox-blank-off-outline",
        new MdiMeta(
            "checkbox-blank-off-outline",
            "F12ED",
            Arrays.asList("Form"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.8.95"));
  }

  public static MdiIcon checkbox_blank_outline() {
    return MdiIcon.create(
        "mdi-checkbox-blank-outline",
        new MdiMeta(
            "checkbox-blank-outline",
            "F0131",
            Arrays.asList("Form"),
            Arrays.asList("check-box-outline-blank", "maximize"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon checkbox_intermediate() {
    return MdiIcon.create(
        "mdi-checkbox-intermediate",
        new MdiMeta(
            "checkbox-intermediate",
            "F0856",
            Arrays.asList("Form"),
            Arrays.asList("checkbox-indeterminate"),
            "Michael Richins",
            "2.1.99"));
  }

  public static MdiIcon checkbox_intermediate_variant() {
    return MdiIcon.create(
        "mdi-checkbox-intermediate-variant",
        new MdiMeta(
            "checkbox-intermediate-variant",
            "F1B54",
            Arrays.asList("Form"),
            Arrays.asList("checkbox-indeterminate-variant"),
            "Andy Giesen",
            "6.9.96"));
  }

  public static MdiIcon checkbox_marked() {
    return MdiIcon.create(
        "mdi-checkbox-marked",
        new MdiMeta(
            "checkbox-marked",
            "F0132",
            Arrays.asList("Form"),
            Arrays.asList("check-box"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon checkbox_marked_circle() {
    return MdiIcon.create(
        "mdi-checkbox-marked-circle",
        new MdiMeta(
            "checkbox-marked-circle",
            "F0133",
            Arrays.asList("Form"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon checkbox_marked_circle_auto_outline() {
    return MdiIcon.create(
        "mdi-checkbox-marked-circle-auto-outline",
        new MdiMeta(
            "checkbox-marked-circle-auto-outline",
            "F1C26",
            Arrays.asList("Form"),
            Arrays.asList("task-auto", "todo-auto"),
            "Jeff Anders",
            "7.2.96"));
  }

  public static MdiIcon checkbox_marked_circle_minus_outline() {
    return MdiIcon.create(
        "mdi-checkbox-marked-circle-minus-outline",
        new MdiMeta(
            "checkbox-marked-circle-minus-outline",
            "F1C27",
            Arrays.asList("Form"),
            Arrays.asList("todo-minus", "task-minus"),
            "Jeff Anders",
            "7.2.96"));
  }

  public static MdiIcon checkbox_marked_circle_outline() {
    return MdiIcon.create(
        "mdi-checkbox-marked-circle-outline",
        new MdiMeta(
            "checkbox-marked-circle-outline",
            "F0134",
            Arrays.asList("Form"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon checkbox_marked_circle_plus_outline() {
    return MdiIcon.create(
        "mdi-checkbox-marked-circle-plus-outline",
        new MdiMeta(
            "checkbox-marked-circle-plus-outline",
            "F1927",
            Arrays.asList("Form"),
            Arrays.asList("task-plus", "task-add", "todo-plus", "todo-add"),
            "Teodor Sandu",
            "6.4.95"));
  }

  public static MdiIcon checkbox_marked_outline() {
    return MdiIcon.create(
        "mdi-checkbox-marked-outline",
        new MdiMeta(
            "checkbox-marked-outline",
            "F0135",
            Arrays.asList("Form"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon checkbox_multiple_blank() {
    return MdiIcon.create(
        "mdi-checkbox-multiple-blank",
        new MdiMeta(
            "checkbox-multiple-blank",
            "F0136",
            Arrays.asList("Form"),
            Arrays.asList("checkboxes-blank"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon checkbox_multiple_blank_circle() {
    return MdiIcon.create(
        "mdi-checkbox-multiple-blank-circle",
        new MdiMeta(
            "checkbox-multiple-blank-circle",
            "F063B",
            Arrays.asList("Form"),
            Arrays.asList("checkboxes-blank-circle"),
            "Simran",
            "1.6.50"));
  }

  public static MdiIcon checkbox_multiple_blank_circle_outline() {
    return MdiIcon.create(
        "mdi-checkbox-multiple-blank-circle-outline",
        new MdiMeta(
            "checkbox-multiple-blank-circle-outline",
            "F063C",
            Arrays.asList("Form"),
            Arrays.asList("checkboxes-blank-circle-outline"),
            "Simran",
            "1.6.50"));
  }

  public static MdiIcon checkbox_multiple_blank_outline() {
    return MdiIcon.create(
        "mdi-checkbox-multiple-blank-outline",
        new MdiMeta(
            "checkbox-multiple-blank-outline",
            "F0137",
            Arrays.asList("Form"),
            Arrays.asList("checkboxes-blank-outline"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon checkbox_multiple_marked() {
    return MdiIcon.create(
        "mdi-checkbox-multiple-marked",
        new MdiMeta(
            "checkbox-multiple-marked",
            "F0138",
            Arrays.asList("Form"),
            Arrays.asList("checkboxes-marked"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon checkbox_multiple_marked_circle() {
    return MdiIcon.create(
        "mdi-checkbox-multiple-marked-circle",
        new MdiMeta(
            "checkbox-multiple-marked-circle",
            "F063D",
            Arrays.asList("Form"),
            Arrays.asList("checkboxes-marked-circle"),
            "Simran",
            "1.6.50"));
  }

  public static MdiIcon checkbox_multiple_marked_circle_outline() {
    return MdiIcon.create(
        "mdi-checkbox-multiple-marked-circle-outline",
        new MdiMeta(
            "checkbox-multiple-marked-circle-outline",
            "F063E",
            Arrays.asList("Form"),
            Arrays.asList("checkboxes-marked-circle-outline"),
            "Simran",
            "1.6.50"));
  }

  public static MdiIcon checkbox_multiple_marked_outline() {
    return MdiIcon.create(
        "mdi-checkbox-multiple-marked-outline",
        new MdiMeta(
            "checkbox-multiple-marked-outline",
            "F0139",
            Arrays.asList("Form"),
            Arrays.asList("checkboxes-marked-outline"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon checkbox_multiple_outline() {
    return MdiIcon.create(
        "mdi-checkbox-multiple-outline",
        new MdiMeta(
            "checkbox-multiple-outline",
            "F0C51",
            Arrays.asList("Form"),
            Arrays.asList("check-boxes-outline", "tick-box-multiple-outline"),
            "Michael Richins",
            "3.2.89"));
  }

  public static MdiIcon checkbox_outline() {
    return MdiIcon.create(
        "mdi-checkbox-outline",
        new MdiMeta(
            "checkbox-outline",
            "F0C52",
            Arrays.asList("Form"),
            Arrays.asList(),
            "Michael Richins",
            "3.2.89"));
  }

  public static MdiIcon checkerboard() {
    return MdiIcon.create(
        "mdi-checkerboard",
        new MdiMeta(
            "checkerboard",
            "F013A",
            Arrays.asList("Gaming / RPG", "Geographic Information System"),
            Arrays.asList("raster"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon checkerboard_minus() {
    return MdiIcon.create(
        "mdi-checkerboard-minus",
        new MdiMeta(
            "checkerboard-minus",
            "F1202",
            Arrays.asList("Geographic Information System"),
            Arrays.asList("raster-minus"),
            "Michael Irigoyen",
            "4.6.95"));
  }

  public static MdiIcon checkerboard_plus() {
    return MdiIcon.create(
        "mdi-checkerboard-plus",
        new MdiMeta(
            "checkerboard-plus",
            "F1201",
            Arrays.asList("Geographic Information System"),
            Arrays.asList("raster-plus"),
            "Michael Irigoyen",
            "4.6.95"));
  }

  public static MdiIcon checkerboard_remove() {
    return MdiIcon.create(
        "mdi-checkerboard-remove",
        new MdiMeta(
            "checkerboard-remove",
            "F1203",
            Arrays.asList("Geographic Information System"),
            Arrays.asList("raster-remove"),
            "Michael Irigoyen",
            "4.6.95"));
  }

  public static MdiIcon cheese() {
    return MdiIcon.create(
        "mdi-cheese",
        new MdiMeta(
            "cheese",
            "F12B9",
            Arrays.asList("Food / Drink"),
            Arrays.asList("swiss-cheese"),
            "Thomas de Saint-Exupéry",
            "4.7.95"));
  }

  public static MdiIcon cheese_off() {
    return MdiIcon.create(
        "mdi-cheese-off",
        new MdiMeta(
            "cheese-off",
            "F13EE",
            Arrays.asList("Food / Drink"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.1.45"));
  }

  public static MdiIcon chef_hat() {
    return MdiIcon.create(
        "mdi-chef-hat",
        new MdiMeta(
            "chef-hat",
            "F0B7C",
            Arrays.asList("Clothing"),
            Arrays.asList("toque", "cook"),
            "Simran",
            "3.0.39"));
  }

  public static MdiIcon chemical_weapon() {
    return MdiIcon.create(
        "mdi-chemical-weapon",
        new MdiMeta(
            "chemical-weapon", "F013B", Arrays.asList(), Arrays.asList(), "Simran", "1.5.54"));
  }

  public static MdiIcon chess_bishop() {
    return MdiIcon.create(
        "mdi-chess-bishop",
        new MdiMeta(
            "chess-bishop",
            "F085C",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "Michael Richins",
            "2.1.99"));
  }

  public static MdiIcon chess_king() {
    return MdiIcon.create(
        "mdi-chess-king",
        new MdiMeta(
            "chess-king",
            "F0857",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("crown", "royalty"),
            "Michael Richins",
            "2.1.99"));
  }

  public static MdiIcon chess_knight() {
    return MdiIcon.create(
        "mdi-chess-knight",
        new MdiMeta(
            "chess-knight",
            "F0858",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("chess-horse"),
            "Michael Richins",
            "2.1.99"));
  }

  public static MdiIcon chess_pawn() {
    return MdiIcon.create(
        "mdi-chess-pawn",
        new MdiMeta(
            "chess-pawn",
            "F0859",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "Michael Richins",
            "2.1.99"));
  }

  public static MdiIcon chess_queen() {
    return MdiIcon.create(
        "mdi-chess-queen",
        new MdiMeta(
            "chess-queen",
            "F085A",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("crown", "royalty"),
            "Michael Richins",
            "2.1.99"));
  }

  public static MdiIcon chess_rook() {
    return MdiIcon.create(
        "mdi-chess-rook",
        new MdiMeta(
            "chess-rook",
            "F085B",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("chess-castle", "chess-tower"),
            "Michael Richins",
            "2.1.99"));
  }

  public static MdiIcon chevron_double_down() {
    return MdiIcon.create(
        "mdi-chevron-double-down",
        new MdiMeta(
            "chevron-double-down",
            "F013C",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon chevron_double_left() {
    return MdiIcon.create(
        "mdi-chevron-double-left",
        new MdiMeta(
            "chevron-double-left",
            "F013D",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon chevron_double_right() {
    return MdiIcon.create(
        "mdi-chevron-double-right",
        new MdiMeta(
            "chevron-double-right",
            "F013E",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon chevron_double_up() {
    return MdiIcon.create(
        "mdi-chevron-double-up",
        new MdiMeta(
            "chevron-double-up",
            "F013F",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon chevron_down() {
    return MdiIcon.create(
        "mdi-chevron-down",
        new MdiMeta(
            "chevron-down",
            "F0140",
            Arrays.asList("Arrow"),
            Arrays.asList("expand-more", "keyboard-arrow-down"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon chevron_down_box() {
    return MdiIcon.create(
        "mdi-chevron-down-box",
        new MdiMeta(
            "chevron-down-box",
            "F09D6",
            Arrays.asList("Form", "Arrow"),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon chevron_down_box_outline() {
    return MdiIcon.create(
        "mdi-chevron-down-box-outline",
        new MdiMeta(
            "chevron-down-box-outline",
            "F09D7",
            Arrays.asList("Form", "Arrow"),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon chevron_down_circle() {
    return MdiIcon.create(
        "mdi-chevron-down-circle",
        new MdiMeta(
            "chevron-down-circle",
            "F0B26",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "SarinManS",
            "2.8.94"));
  }

  public static MdiIcon chevron_down_circle_outline() {
    return MdiIcon.create(
        "mdi-chevron-down-circle-outline",
        new MdiMeta(
            "chevron-down-circle-outline",
            "F0B27",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "SarinManS",
            "2.8.94"));
  }

  public static MdiIcon chevron_left() {
    return MdiIcon.create(
        "mdi-chevron-left",
        new MdiMeta(
            "chevron-left",
            "F0141",
            Arrays.asList("Arrow"),
            Arrays.asList("keyboard-arrow-left", "navigate-before"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon chevron_left_box() {
    return MdiIcon.create(
        "mdi-chevron-left-box",
        new MdiMeta(
            "chevron-left-box",
            "F09D8",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon chevron_left_box_outline() {
    return MdiIcon.create(
        "mdi-chevron-left-box-outline",
        new MdiMeta(
            "chevron-left-box-outline",
            "F09D9",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon chevron_left_circle() {
    return MdiIcon.create(
        "mdi-chevron-left-circle",
        new MdiMeta(
            "chevron-left-circle",
            "F0B28",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "SarinManS",
            "2.8.94"));
  }

  public static MdiIcon chevron_left_circle_outline() {
    return MdiIcon.create(
        "mdi-chevron-left-circle-outline",
        new MdiMeta(
            "chevron-left-circle-outline",
            "F0B29",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "SarinManS",
            "2.8.94"));
  }

  public static MdiIcon chevron_right() {
    return MdiIcon.create(
        "mdi-chevron-right",
        new MdiMeta(
            "chevron-right",
            "F0142",
            Arrays.asList("Arrow"),
            Arrays.asList("keyboard-arrow-right", "navigate-next"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon chevron_right_box() {
    return MdiIcon.create(
        "mdi-chevron-right-box",
        new MdiMeta(
            "chevron-right-box",
            "F09DA",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon chevron_right_box_outline() {
    return MdiIcon.create(
        "mdi-chevron-right-box-outline",
        new MdiMeta(
            "chevron-right-box-outline",
            "F09DB",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon chevron_right_circle() {
    return MdiIcon.create(
        "mdi-chevron-right-circle",
        new MdiMeta(
            "chevron-right-circle",
            "F0B2A",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "SarinManS",
            "2.8.94"));
  }

  public static MdiIcon chevron_right_circle_outline() {
    return MdiIcon.create(
        "mdi-chevron-right-circle-outline",
        new MdiMeta(
            "chevron-right-circle-outline",
            "F0B2B",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "SarinManS",
            "2.8.94"));
  }

  public static MdiIcon chevron_triple_down() {
    return MdiIcon.create(
        "mdi-chevron-triple-down",
        new MdiMeta(
            "chevron-triple-down", "F0DB9", Arrays.asList(), Arrays.asList(), "Google", "3.5.94"));
  }

  public static MdiIcon chevron_triple_left() {
    return MdiIcon.create(
        "mdi-chevron-triple-left",
        new MdiMeta(
            "chevron-triple-left", "F0DBA", Arrays.asList(), Arrays.asList(), "Google", "3.5.94"));
  }

  public static MdiIcon chevron_triple_right() {
    return MdiIcon.create(
        "mdi-chevron-triple-right",
        new MdiMeta(
            "chevron-triple-right", "F0DBB", Arrays.asList(), Arrays.asList(), "Google", "3.5.94"));
  }

  public static MdiIcon chevron_triple_up() {
    return MdiIcon.create(
        "mdi-chevron-triple-up",
        new MdiMeta(
            "chevron-triple-up",
            "F0DBC",
            Arrays.asList(),
            Arrays.asList("rank"),
            "Google",
            "3.5.94"));
  }

  public static MdiIcon chevron_up() {
    return MdiIcon.create(
        "mdi-chevron-up",
        new MdiMeta(
            "chevron-up",
            "F0143",
            Arrays.asList("Arrow", "Math"),
            Arrays.asList("expand-less", "keyboard-arrow-up", "caret"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon chevron_up_box() {
    return MdiIcon.create(
        "mdi-chevron-up-box",
        new MdiMeta(
            "chevron-up-box",
            "F09DC",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon chevron_up_box_outline() {
    return MdiIcon.create(
        "mdi-chevron-up-box-outline",
        new MdiMeta(
            "chevron-up-box-outline",
            "F09DD",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon chevron_up_circle() {
    return MdiIcon.create(
        "mdi-chevron-up-circle",
        new MdiMeta(
            "chevron-up-circle",
            "F0B2C",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "SarinManS",
            "2.8.94"));
  }

  public static MdiIcon chevron_up_circle_outline() {
    return MdiIcon.create(
        "mdi-chevron-up-circle-outline",
        new MdiMeta(
            "chevron-up-circle-outline",
            "F0B2D",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "SarinManS",
            "2.8.94"));
  }

  public static MdiIcon chili_alert() {
    return MdiIcon.create(
        "mdi-chili-alert",
        new MdiMeta(
            "chili-alert",
            "F17EA",
            Arrays.asList("Alert / Error"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon chili_alert_outline() {
    return MdiIcon.create(
        "mdi-chili-alert-outline",
        new MdiMeta(
            "chili-alert-outline",
            "F17EB",
            Arrays.asList("Alert / Error"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon chili_hot() {
    return MdiIcon.create(
        "mdi-chili-hot",
        new MdiMeta(
            "chili-hot",
            "F07B2",
            Arrays.asList("Food / Drink"),
            Arrays.asList("chilli-hot", "pepper", "spicy"),
            "Andy Martinez",
            "2.0.46"));
  }

  public static MdiIcon chili_hot_outline() {
    return MdiIcon.create(
        "mdi-chili-hot-outline",
        new MdiMeta(
            "chili-hot-outline",
            "F17EC",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon chili_medium() {
    return MdiIcon.create(
        "mdi-chili-medium",
        new MdiMeta(
            "chili-medium",
            "F07B3",
            Arrays.asList("Food / Drink"),
            Arrays.asList("chilli-medium", "pepper", "spicy"),
            "Andy Martinez",
            "2.0.46"));
  }

  public static MdiIcon chili_medium_outline() {
    return MdiIcon.create(
        "mdi-chili-medium-outline",
        new MdiMeta(
            "chili-medium-outline",
            "F17ED",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon chili_mild() {
    return MdiIcon.create(
        "mdi-chili-mild",
        new MdiMeta(
            "chili-mild",
            "F07B4",
            Arrays.asList("Food / Drink", "Agriculture"),
            Arrays.asList("chilli-mild", "pepper", "spicy"),
            "Andy Martinez",
            "2.0.46"));
  }

  public static MdiIcon chili_mild_outline() {
    return MdiIcon.create(
        "mdi-chili-mild-outline",
        new MdiMeta(
            "chili-mild-outline",
            "F17EE",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon chili_off() {
    return MdiIcon.create(
        "mdi-chili-off",
        new MdiMeta(
            "chili-off",
            "F1467",
            Arrays.asList("Food / Drink"),
            Arrays.asList("chilli-off", "pepper-off", "spicy-off"),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon chili_off_outline() {
    return MdiIcon.create(
        "mdi-chili-off-outline",
        new MdiMeta(
            "chili-off-outline",
            "F17EF",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon chip() {
    return MdiIcon.create(
        "mdi-chip",
        new MdiMeta(
            "chip",
            "F061A",
            Arrays.asList(),
            Arrays.asList("integrated-circuit"),
            "Austin Andrews",
            "1.6.50"));
  }

  public static MdiIcon church() {
    return MdiIcon.create(
        "mdi-church",
        new MdiMeta(
            "church",
            "F0144",
            Arrays.asList("Religion", "Places"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon church_outline() {
    return MdiIcon.create(
        "mdi-church-outline",
        new MdiMeta(
            "church-outline",
            "F1B02",
            Arrays.asList("Places", "Religion"),
            Arrays.asList(),
            "Google",
            "6.9.96"));
  }

  public static MdiIcon cigar() {
    return MdiIcon.create(
        "mdi-cigar",
        new MdiMeta(
            "cigar", "F1189", Arrays.asList(), Arrays.asList(), "Michael Richins", "4.4.95"));
  }

  public static MdiIcon cigar_off() {
    return MdiIcon.create(
        "mdi-cigar-off",
        new MdiMeta(
            "cigar-off", "F141B", Arrays.asList(), Arrays.asList(), "Michael Irigoyen", "5.2.45"));
  }

  public static MdiIcon circle() {
    return MdiIcon.create(
        "mdi-circle",
        new MdiMeta(
            "circle",
            "F0765",
            Arrays.asList("Shape"),
            Arrays.asList("lens"),
            "Austin Andrews",
            "1.9.32"));
  }

  public static MdiIcon circle_box() {
    return MdiIcon.create(
        "mdi-circle-box",
        new MdiMeta(
            "circle-box", "F15DC", Arrays.asList(), Arrays.asList(), "Michael Irigoyen", "5.6.55"));
  }

  public static MdiIcon circle_box_outline() {
    return MdiIcon.create(
        "mdi-circle-box-outline",
        new MdiMeta(
            "circle-box-outline",
            "F15DD",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.6.55"));
  }

  public static MdiIcon circle_double() {
    return MdiIcon.create(
        "mdi-circle-double",
        new MdiMeta(
            "circle-double",
            "F0E95",
            Arrays.asList("Shape"),
            Arrays.asList(),
            "ginlime",
            "3.7.94"));
  }

  public static MdiIcon circle_edit_outline() {
    return MdiIcon.create(
        "mdi-circle-edit-outline",
        new MdiMeta(
            "circle-edit-outline",
            "F08D5",
            Arrays.asList("Edit / Modify"),
            Arrays.asList(),
            "Google",
            "2.3.50"));
  }

  public static MdiIcon circle_expand() {
    return MdiIcon.create(
        "mdi-circle-expand",
        new MdiMeta(
            "circle-expand", "F0E96", Arrays.asList(), Arrays.asList(), "Google", "3.7.94"));
  }

  public static MdiIcon circle_half() {
    return MdiIcon.create(
        "mdi-circle-half",
        new MdiMeta(
            "circle-half",
            "F1395",
            Arrays.asList("Shape"),
            Arrays.asList("brightness-half"),
            "Simran",
            "5.0.45"));
  }

  public static MdiIcon circle_half_full() {
    return MdiIcon.create(
        "mdi-circle-half-full",
        new MdiMeta(
            "circle-half-full",
            "F1396",
            Arrays.asList("Shape"),
            Arrays.asList(),
            "Simran",
            "5.0.45"));
  }

  public static MdiIcon circle_medium() {
    return MdiIcon.create(
        "mdi-circle-medium",
        new MdiMeta(
            "circle-medium",
            "F09DE",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon circle_multiple() {
    return MdiIcon.create(
        "mdi-circle-multiple",
        new MdiMeta(
            "circle-multiple",
            "F0B38",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList("coins"),
            "Michael Richins",
            "2.8.94"));
  }

  public static MdiIcon circle_multiple_outline() {
    return MdiIcon.create(
        "mdi-circle-multiple-outline",
        new MdiMeta(
            "circle-multiple-outline",
            "F0695",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList("toll", "coins-outline"),
            "Google",
            "1.7.12"));
  }

  public static MdiIcon circle_off_outline() {
    return MdiIcon.create(
        "mdi-circle-off-outline",
        new MdiMeta(
            "circle-off-outline",
            "F10D3",
            Arrays.asList(),
            Arrays.asList("null-off"),
            "Simran",
            "4.3.95"));
  }

  public static MdiIcon circle_opacity() {
    return MdiIcon.create(
        "mdi-circle-opacity",
        new MdiMeta(
            "circle-opacity",
            "F1853",
            Arrays.asList("Shape", "Drawing / Art"),
            Arrays.asList("circle-transparent"),
            "Michael Irigoyen",
            "6.2.95"));
  }

  public static MdiIcon circle_outline() {
    return MdiIcon.create(
        "mdi-circle-outline",
        new MdiMeta(
            "circle-outline",
            "F0766",
            Arrays.asList("Shape"),
            Arrays.asList("null"),
            "Austin Andrews",
            "1.9.32"));
  }

  public static MdiIcon circle_slice_1() {
    return MdiIcon.create(
        "mdi-circle-slice-1",
        new MdiMeta(
            "circle-slice-1", "F0A9E", Arrays.asList(), Arrays.asList(), "SarinManS", "2.7.94"));
  }

  public static MdiIcon circle_slice_2() {
    return MdiIcon.create(
        "mdi-circle-slice-2",
        new MdiMeta(
            "circle-slice-2", "F0A9F", Arrays.asList(), Arrays.asList(), "SarinManS", "2.7.94"));
  }

  public static MdiIcon circle_slice_3() {
    return MdiIcon.create(
        "mdi-circle-slice-3",
        new MdiMeta(
            "circle-slice-3", "F0AA0", Arrays.asList(), Arrays.asList(), "SarinManS", "2.7.94"));
  }

  public static MdiIcon circle_slice_4() {
    return MdiIcon.create(
        "mdi-circle-slice-4",
        new MdiMeta(
            "circle-slice-4", "F0AA1", Arrays.asList(), Arrays.asList(), "SarinManS", "2.7.94"));
  }

  public static MdiIcon circle_slice_5() {
    return MdiIcon.create(
        "mdi-circle-slice-5",
        new MdiMeta(
            "circle-slice-5", "F0AA2", Arrays.asList(), Arrays.asList(), "SarinManS", "2.7.94"));
  }

  public static MdiIcon circle_slice_6() {
    return MdiIcon.create(
        "mdi-circle-slice-6",
        new MdiMeta(
            "circle-slice-6", "F0AA3", Arrays.asList(), Arrays.asList(), "SarinManS", "2.7.94"));
  }

  public static MdiIcon circle_slice_7() {
    return MdiIcon.create(
        "mdi-circle-slice-7",
        new MdiMeta(
            "circle-slice-7", "F0AA4", Arrays.asList(), Arrays.asList(), "SarinManS", "2.7.94"));
  }

  public static MdiIcon circle_slice_8() {
    return MdiIcon.create(
        "mdi-circle-slice-8",
        new MdiMeta(
            "circle-slice-8", "F0AA5", Arrays.asList(), Arrays.asList(), "SarinManS", "2.7.94"));
  }

  public static MdiIcon circle_small() {
    return MdiIcon.create(
        "mdi-circle-small",
        new MdiMeta(
            "circle-small",
            "F09DF",
            Arrays.asList("Math"),
            Arrays.asList("bullet", "multiplication", "dot"),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon circular_saw() {
    return MdiIcon.create(
        "mdi-circular-saw",
        new MdiMeta(
            "circular-saw",
            "F0E22",
            Arrays.asList("Hardware / Tools"),
            Arrays.asList(),
            "Augustin Ursu",
            "3.6.95"));
  }

  public static MdiIcon city() {
    return MdiIcon.create(
        "mdi-city",
        new MdiMeta(
            "city",
            "F0146",
            Arrays.asList("Places"),
            Arrays.asList("location-city"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon city_switch() {
    return MdiIcon.create(
        "mdi-city-switch",
        new MdiMeta(
            "city-switch",
            "F1C28",
            Arrays.asList("Places"),
            Arrays.asList("city-swap"),
            "Jeff Anders",
            "7.2.96"));
  }

  public static MdiIcon city_variant() {
    return MdiIcon.create(
        "mdi-city-variant",
        new MdiMeta(
            "city-variant",
            "F0A36",
            Arrays.asList("Places"),
            Arrays.asList(),
            "Michael Richins",
            "2.6.95"));
  }

  public static MdiIcon city_variant_outline() {
    return MdiIcon.create(
        "mdi-city-variant-outline",
        new MdiMeta(
            "city-variant-outline",
            "F0A37",
            Arrays.asList("Places"),
            Arrays.asList(),
            "Michael Richins",
            "2.6.95"));
  }

  public static MdiIcon clipboard() {
    return MdiIcon.create(
        "mdi-clipboard",
        new MdiMeta(
            "clipboard", "F0147", Arrays.asList(), Arrays.asList(), "Austin Andrews", "1.5.54"));
  }

  public static MdiIcon clipboard_account() {
    return MdiIcon.create(
        "mdi-clipboard-account",
        new MdiMeta(
            "clipboard-account",
            "F0148",
            Arrays.asList("Account / User"),
            Arrays.asList("clipboard-user", "assignment-ind", "clipboard-person"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon clipboard_account_outline() {
    return MdiIcon.create(
        "mdi-clipboard-account-outline",
        new MdiMeta(
            "clipboard-account-outline",
            "F0C55",
            Arrays.asList("Account / User"),
            Arrays.asList(
                "clipboard-user-outline", "clipboard-person-outline", "assignment-ind-outline"),
            "James Coyle",
            "3.2.89"));
  }

  public static MdiIcon clipboard_alert() {
    return MdiIcon.create(
        "mdi-clipboard-alert",
        new MdiMeta(
            "clipboard-alert",
            "F0149",
            Arrays.asList("Alert / Error"),
            Arrays.asList("clipboard-warning", "assignment-late"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon clipboard_alert_outline() {
    return MdiIcon.create(
        "mdi-clipboard-alert-outline",
        new MdiMeta(
            "clipboard-alert-outline",
            "F0CF7",
            Arrays.asList("Alert / Error"),
            Arrays.asList("clipboard-warning-outline"),
            "James Coyle",
            "3.3.92"));
  }

  public static MdiIcon clipboard_arrow_down() {
    return MdiIcon.create(
        "mdi-clipboard-arrow-down",
        new MdiMeta(
            "clipboard-arrow-down",
            "F014A",
            Arrays.asList(),
            Arrays.asList("assignment-returned", "clipboard-arrow-bottom"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon clipboard_arrow_down_outline() {
    return MdiIcon.create(
        "mdi-clipboard-arrow-down-outline",
        new MdiMeta(
            "clipboard-arrow-down-outline",
            "F0C56",
            Arrays.asList(),
            Arrays.asList("assignment-returned-outline", "clipboard-arrow-bottom-outline"),
            "Google",
            "3.2.89"));
  }

  public static MdiIcon clipboard_arrow_left() {
    return MdiIcon.create(
        "mdi-clipboard-arrow-left",
        new MdiMeta(
            "clipboard-arrow-left",
            "F014B",
            Arrays.asList(),
            Arrays.asList("assignment-return"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon clipboard_arrow_left_outline() {
    return MdiIcon.create(
        "mdi-clipboard-arrow-left-outline",
        new MdiMeta(
            "clipboard-arrow-left-outline",
            "F0CF8",
            Arrays.asList(),
            Arrays.asList(),
            "James Coyle",
            "3.3.92"));
  }

  public static MdiIcon clipboard_arrow_right() {
    return MdiIcon.create(
        "mdi-clipboard-arrow-right",
        new MdiMeta(
            "clipboard-arrow-right",
            "F0CF9",
            Arrays.asList(),
            Arrays.asList(),
            "James Coyle",
            "3.3.92"));
  }

  public static MdiIcon clipboard_arrow_right_outline() {
    return MdiIcon.create(
        "mdi-clipboard-arrow-right-outline",
        new MdiMeta(
            "clipboard-arrow-right-outline",
            "F0CFA",
            Arrays.asList(),
            Arrays.asList(),
            "James Coyle",
            "3.3.92"));
  }

  public static MdiIcon clipboard_arrow_up() {
    return MdiIcon.create(
        "mdi-clipboard-arrow-up",
        new MdiMeta(
            "clipboard-arrow-up",
            "F0C57",
            Arrays.asList(),
            Arrays.asList("clipboard-arrow-top"),
            "James Coyle",
            "3.2.89"));
  }

  public static MdiIcon clipboard_arrow_up_outline() {
    return MdiIcon.create(
        "mdi-clipboard-arrow-up-outline",
        new MdiMeta(
            "clipboard-arrow-up-outline",
            "F0C58",
            Arrays.asList(),
            Arrays.asList("clipboard-arrow-top-outline"),
            "James Coyle",
            "3.2.89"));
  }

  public static MdiIcon clipboard_check() {
    return MdiIcon.create(
        "mdi-clipboard-check",
        new MdiMeta(
            "clipboard-check",
            "F014E",
            Arrays.asList(),
            Arrays.asList("assignment-turned-in", "clipboard-tick"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon clipboard_check_multiple() {
    return MdiIcon.create(
        "mdi-clipboard-check-multiple",
        new MdiMeta(
            "clipboard-check-multiple",
            "F1263",
            Arrays.asList(),
            Arrays.asList(),
            "frankgrinaert",
            "4.7.95"));
  }

  public static MdiIcon clipboard_check_multiple_outline() {
    return MdiIcon.create(
        "mdi-clipboard-check-multiple-outline",
        new MdiMeta(
            "clipboard-check-multiple-outline",
            "F1264",
            Arrays.asList(),
            Arrays.asList(),
            "frankgrinaert",
            "4.7.95"));
  }

  public static MdiIcon clipboard_check_outline() {
    return MdiIcon.create(
        "mdi-clipboard-check-outline",
        new MdiMeta(
            "clipboard-check-outline",
            "F08A8",
            Arrays.asList(),
            Arrays.asList("clipboard-tick-outline"),
            "James Coyle",
            "2.2.43"));
  }

  public static MdiIcon clipboard_clock() {
    return MdiIcon.create(
        "mdi-clipboard-clock",
        new MdiMeta(
            "clipboard-clock",
            "F16E2",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.9.55"));
  }

  public static MdiIcon clipboard_clock_outline() {
    return MdiIcon.create(
        "mdi-clipboard-clock-outline",
        new MdiMeta(
            "clipboard-clock-outline",
            "F16E3",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.9.55"));
  }

  public static MdiIcon clipboard_edit() {
    return MdiIcon.create(
        "mdi-clipboard-edit",
        new MdiMeta(
            "clipboard-edit",
            "F14E5",
            Arrays.asList("Edit / Modify"),
            Arrays.asList(),
            "Alison Moura",
            "5.4.55"));
  }

  public static MdiIcon clipboard_edit_outline() {
    return MdiIcon.create(
        "mdi-clipboard-edit-outline",
        new MdiMeta(
            "clipboard-edit-outline",
            "F14E6",
            Arrays.asList("Edit / Modify"),
            Arrays.asList(),
            "Alison Moura",
            "5.4.55"));
  }

  public static MdiIcon clipboard_file() {
    return MdiIcon.create(
        "mdi-clipboard-file",
        new MdiMeta(
            "clipboard-file",
            "F1265",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "frankgrinaert",
            "4.7.95"));
  }

  public static MdiIcon clipboard_file_outline() {
    return MdiIcon.create(
        "mdi-clipboard-file-outline",
        new MdiMeta(
            "clipboard-file-outline",
            "F1266",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "frankgrinaert",
            "4.7.95"));
  }

  public static MdiIcon clipboard_flow() {
    return MdiIcon.create(
        "mdi-clipboard-flow",
        new MdiMeta(
            "clipboard-flow",
            "F06C8",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "1.8.36"));
  }

  public static MdiIcon clipboard_flow_outline() {
    return MdiIcon.create(
        "mdi-clipboard-flow-outline",
        new MdiMeta(
            "clipboard-flow-outline",
            "F1117",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.3.95"));
  }

  public static MdiIcon clipboard_list() {
    return MdiIcon.create(
        "mdi-clipboard-list",
        new MdiMeta(
            "clipboard-list",
            "F10D4",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.3.95"));
  }

  public static MdiIcon clipboard_list_outline() {
    return MdiIcon.create(
        "mdi-clipboard-list-outline",
        new MdiMeta(
            "clipboard-list-outline",
            "F10D5",
            Arrays.asList(),
            Arrays.asList(),
            "kevin-hens",
            "4.3.95"));
  }

  public static MdiIcon clipboard_minus() {
    return MdiIcon.create(
        "mdi-clipboard-minus",
        new MdiMeta(
            "clipboard-minus",
            "F1618",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon clipboard_minus_outline() {
    return MdiIcon.create(
        "mdi-clipboard-minus-outline",
        new MdiMeta(
            "clipboard-minus-outline",
            "F1619",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon clipboard_multiple() {
    return MdiIcon.create(
        "mdi-clipboard-multiple",
        new MdiMeta(
            "clipboard-multiple",
            "F1267",
            Arrays.asList(),
            Arrays.asList(),
            "frankgrinaert",
            "4.7.95"));
  }

  public static MdiIcon clipboard_multiple_outline() {
    return MdiIcon.create(
        "mdi-clipboard-multiple-outline",
        new MdiMeta(
            "clipboard-multiple-outline",
            "F1268",
            Arrays.asList(),
            Arrays.asList(),
            "frankgrinaert",
            "4.7.95"));
  }

  public static MdiIcon clipboard_off() {
    return MdiIcon.create(
        "mdi-clipboard-off",
        new MdiMeta(
            "clipboard-off",
            "F161A",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon clipboard_off_outline() {
    return MdiIcon.create(
        "mdi-clipboard-off-outline",
        new MdiMeta(
            "clipboard-off-outline",
            "F161B",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon clipboard_outline() {
    return MdiIcon.create(
        "mdi-clipboard-outline",
        new MdiMeta(
            "clipboard-outline",
            "F014C",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon clipboard_play() {
    return MdiIcon.create(
        "mdi-clipboard-play",
        new MdiMeta(
            "clipboard-play",
            "F0C59",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "3.2.89"));
  }

  public static MdiIcon clipboard_play_multiple() {
    return MdiIcon.create(
        "mdi-clipboard-play-multiple",
        new MdiMeta(
            "clipboard-play-multiple",
            "F1269",
            Arrays.asList(),
            Arrays.asList(),
            "frankgrinaert",
            "4.7.95"));
  }

  public static MdiIcon clipboard_play_multiple_outline() {
    return MdiIcon.create(
        "mdi-clipboard-play-multiple-outline",
        new MdiMeta(
            "clipboard-play-multiple-outline",
            "F126A",
            Arrays.asList(),
            Arrays.asList(),
            "frankgrinaert",
            "4.7.95"));
  }

  public static MdiIcon clipboard_play_outline() {
    return MdiIcon.create(
        "mdi-clipboard-play-outline",
        new MdiMeta(
            "clipboard-play-outline",
            "F0C5A",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "3.2.89"));
  }

  public static MdiIcon clipboard_plus() {
    return MdiIcon.create(
        "mdi-clipboard-plus",
        new MdiMeta(
            "clipboard-plus",
            "F0751",
            Arrays.asList(),
            Arrays.asList("clipboard-add"),
            "Austin Andrews",
            "1.9.32"));
  }

  public static MdiIcon clipboard_plus_outline() {
    return MdiIcon.create(
        "mdi-clipboard-plus-outline",
        new MdiMeta(
            "clipboard-plus-outline",
            "F131F",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.8.95"));
  }

  public static MdiIcon clipboard_pulse() {
    return MdiIcon.create(
        "mdi-clipboard-pulse",
        new MdiMeta(
            "clipboard-pulse",
            "F085D",
            Arrays.asList("Medical / Hospital"),
            Arrays.asList("clipboard-vitals"),
            "Simran",
            "2.1.99"));
  }

  public static MdiIcon clipboard_pulse_outline() {
    return MdiIcon.create(
        "mdi-clipboard-pulse-outline",
        new MdiMeta(
            "clipboard-pulse-outline",
            "F085E",
            Arrays.asList("Medical / Hospital"),
            Arrays.asList("clipboard-vitals-outline"),
            "Simran",
            "2.1.99"));
  }

  public static MdiIcon clipboard_remove() {
    return MdiIcon.create(
        "mdi-clipboard-remove",
        new MdiMeta(
            "clipboard-remove",
            "F161C",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon clipboard_remove_outline() {
    return MdiIcon.create(
        "mdi-clipboard-remove-outline",
        new MdiMeta(
            "clipboard-remove-outline",
            "F161D",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon clipboard_search() {
    return MdiIcon.create(
        "mdi-clipboard-search",
        new MdiMeta(
            "clipboard-search",
            "F161E",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon clipboard_search_outline() {
    return MdiIcon.create(
        "mdi-clipboard-search-outline",
        new MdiMeta(
            "clipboard-search-outline",
            "F161F",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon clipboard_text() {
    return MdiIcon.create(
        "mdi-clipboard-text",
        new MdiMeta(
            "clipboard-text",
            "F014D",
            Arrays.asList(),
            Arrays.asList("assignment"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon clipboard_text_clock() {
    return MdiIcon.create(
        "mdi-clipboard-text-clock",
        new MdiMeta(
            "clipboard-text-clock",
            "F18F9",
            Arrays.asList("Date / Time"),
            Arrays.asList("clipboard-text-date", "clipboard-text-time", "clipboard-text-history"),
            "Michael Irigoyen",
            "6.3.95"));
  }

  public static MdiIcon clipboard_text_clock_outline() {
    return MdiIcon.create(
        "mdi-clipboard-text-clock-outline",
        new MdiMeta(
            "clipboard-text-clock-outline",
            "F18FA",
            Arrays.asList("Date / Time"),
            Arrays.asList(
                "clipboard-text-date-outline",
                "clipboard-text-time-outline",
                "clipboard-text-history-outline"),
            "Michael Irigoyen",
            "6.3.95"));
  }

  public static MdiIcon clipboard_text_multiple() {
    return MdiIcon.create(
        "mdi-clipboard-text-multiple",
        new MdiMeta(
            "clipboard-text-multiple",
            "F126B",
            Arrays.asList(),
            Arrays.asList(),
            "frankgrinaert",
            "4.7.95"));
  }

  public static MdiIcon clipboard_text_multiple_outline() {
    return MdiIcon.create(
        "mdi-clipboard-text-multiple-outline",
        new MdiMeta(
            "clipboard-text-multiple-outline",
            "F126C",
            Arrays.asList(),
            Arrays.asList(),
            "frankgrinaert",
            "4.7.95"));
  }

  public static MdiIcon clipboard_text_off() {
    return MdiIcon.create(
        "mdi-clipboard-text-off",
        new MdiMeta(
            "clipboard-text-off",
            "F1620",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon clipboard_text_off_outline() {
    return MdiIcon.create(
        "mdi-clipboard-text-off-outline",
        new MdiMeta(
            "clipboard-text-off-outline",
            "F1621",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon clipboard_text_outline() {
    return MdiIcon.create(
        "mdi-clipboard-text-outline",
        new MdiMeta(
            "clipboard-text-outline",
            "F0A38",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "2.6.95"));
  }

  public static MdiIcon clipboard_text_play() {
    return MdiIcon.create(
        "mdi-clipboard-text-play",
        new MdiMeta(
            "clipboard-text-play",
            "F0C5B",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "3.2.89"));
  }

  public static MdiIcon clipboard_text_play_outline() {
    return MdiIcon.create(
        "mdi-clipboard-text-play-outline",
        new MdiMeta(
            "clipboard-text-play-outline",
            "F0C5C",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "3.2.89"));
  }

  public static MdiIcon clipboard_text_search() {
    return MdiIcon.create(
        "mdi-clipboard-text-search",
        new MdiMeta(
            "clipboard-text-search",
            "F1622",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon clipboard_text_search_outline() {
    return MdiIcon.create(
        "mdi-clipboard-text-search-outline",
        new MdiMeta(
            "clipboard-text-search-outline",
            "F1623",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon clippy() {
    return MdiIcon.create(
        "mdi-clippy",
        new MdiMeta("clippy", "F014F", Arrays.asList(), Arrays.asList(), "Contributors", "1.5.54"));
  }

  public static MdiIcon clock() {
    return MdiIcon.create(
        "mdi-clock",
        new MdiMeta(
            "clock",
            "F0954",
            Arrays.asList("Date / Time"),
            Arrays.asList("watch-later"),
            "Google",
            "2.4.85"));
  }

  public static MdiIcon clock_alert() {
    return MdiIcon.create(
        "mdi-clock-alert",
        new MdiMeta(
            "clock-alert",
            "F0955",
            Arrays.asList("Date / Time", "Alert / Error"),
            Arrays.asList("clock-warning"),
            "Simran",
            "2.4.85"));
  }

  public static MdiIcon clock_alert_outline() {
    return MdiIcon.create(
        "mdi-clock-alert-outline",
        new MdiMeta(
            "clock-alert-outline",
            "F05CE",
            Arrays.asList("Date / Time", "Alert / Error"),
            Arrays.asList("clock-warning"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon clock_check() {
    return MdiIcon.create(
        "mdi-clock-check",
        new MdiMeta(
            "clock-check",
            "F0FA8",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.0.96"));
  }

  public static MdiIcon clock_check_outline() {
    return MdiIcon.create(
        "mdi-clock-check-outline",
        new MdiMeta(
            "clock-check-outline",
            "F0FA9",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.0.96"));
  }

  public static MdiIcon clock_digital() {
    return MdiIcon.create(
        "mdi-clock-digital",
        new MdiMeta(
            "clock-digital",
            "F0E97",
            Arrays.asList("Date / Time", "Home Automation"),
            Arrays.asList(),
            "GreenTurtwig",
            "3.7.94"));
  }

  public static MdiIcon clock_edit() {
    return MdiIcon.create(
        "mdi-clock-edit",
        new MdiMeta(
            "clock-edit",
            "F19BA",
            Arrays.asList("Date / Time", "Edit / Modify"),
            Arrays.asList(),
            "Sidney Alcantara",
            "6.5.95"));
  }

  public static MdiIcon clock_edit_outline() {
    return MdiIcon.create(
        "mdi-clock-edit-outline",
        new MdiMeta(
            "clock-edit-outline",
            "F19BB",
            Arrays.asList("Date / Time", "Edit / Modify"),
            Arrays.asList(),
            "Sidney Alcantara",
            "6.5.95"));
  }

  public static MdiIcon clock_end() {
    return MdiIcon.create(
        "mdi-clock-end",
        new MdiMeta(
            "clock-end",
            "F0151",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon clock_fast() {
    return MdiIcon.create(
        "mdi-clock-fast",
        new MdiMeta(
            "clock-fast",
            "F0152",
            Arrays.asList("Date / Time"),
            Arrays.asList("velocity"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon clock_in() {
    return MdiIcon.create(
        "mdi-clock-in",
        new MdiMeta(
            "clock-in",
            "F0153",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon clock_minus() {
    return MdiIcon.create(
        "mdi-clock-minus",
        new MdiMeta(
            "clock-minus",
            "F1863",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.2.95"));
  }

  public static MdiIcon clock_minus_outline() {
    return MdiIcon.create(
        "mdi-clock-minus-outline",
        new MdiMeta(
            "clock-minus-outline",
            "F1864",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Dylan Oli",
            "6.2.95"));
  }

  public static MdiIcon clock_out() {
    return MdiIcon.create(
        "mdi-clock-out",
        new MdiMeta(
            "clock-out",
            "F0154",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon clock_outline() {
    return MdiIcon.create(
        "mdi-clock-outline",
        new MdiMeta(
            "clock-outline",
            "F0150",
            Arrays.asList("Date / Time"),
            Arrays.asList("access-time", "query-builder", "schedule"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon clock_plus() {
    return MdiIcon.create(
        "mdi-clock-plus",
        new MdiMeta(
            "clock-plus",
            "F1861",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.2.95"));
  }

  public static MdiIcon clock_plus_outline() {
    return MdiIcon.create(
        "mdi-clock-plus-outline",
        new MdiMeta(
            "clock-plus-outline",
            "F1862",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Dylan Oli",
            "6.2.95"));
  }

  public static MdiIcon clock_remove() {
    return MdiIcon.create(
        "mdi-clock-remove",
        new MdiMeta(
            "clock-remove",
            "F1865",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.2.95"));
  }

  public static MdiIcon clock_remove_outline() {
    return MdiIcon.create(
        "mdi-clock-remove-outline",
        new MdiMeta(
            "clock-remove-outline",
            "F1866",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Dylan Oli",
            "6.2.95"));
  }

  public static MdiIcon clock_star_four_points() {
    return MdiIcon.create(
        "mdi-clock-star-four-points",
        new MdiMeta(
            "clock-star-four-points",
            "F1C29",
            Arrays.asList("Date / Time"),
            Arrays.asList("clock-auto"),
            "Jeff Anders",
            "7.2.96"));
  }

  public static MdiIcon clock_star_four_points_outline() {
    return MdiIcon.create(
        "mdi-clock-star-four-points-outline",
        new MdiMeta(
            "clock-star-four-points-outline",
            "F1C2A",
            Arrays.asList("Date / Time"),
            Arrays.asList("clock-auto-outline"),
            "Jeff Anders",
            "7.2.96"));
  }

  public static MdiIcon clock_start() {
    return MdiIcon.create(
        "mdi-clock-start",
        new MdiMeta(
            "clock-start",
            "F0155",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon clock_time_eight() {
    return MdiIcon.create(
        "mdi-clock-time-eight",
        new MdiMeta(
            "clock-time-eight",
            "F1446",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon clock_time_eight_outline() {
    return MdiIcon.create(
        "mdi-clock-time-eight-outline",
        new MdiMeta(
            "clock-time-eight-outline",
            "F1452",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon clock_time_eleven() {
    return MdiIcon.create(
        "mdi-clock-time-eleven",
        new MdiMeta(
            "clock-time-eleven",
            "F1449",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon clock_time_eleven_outline() {
    return MdiIcon.create(
        "mdi-clock-time-eleven-outline",
        new MdiMeta(
            "clock-time-eleven-outline",
            "F1455",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon clock_time_five() {
    return MdiIcon.create(
        "mdi-clock-time-five",
        new MdiMeta(
            "clock-time-five",
            "F1443",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon clock_time_five_outline() {
    return MdiIcon.create(
        "mdi-clock-time-five-outline",
        new MdiMeta(
            "clock-time-five-outline",
            "F144F",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon clock_time_four() {
    return MdiIcon.create(
        "mdi-clock-time-four",
        new MdiMeta(
            "clock-time-four",
            "F1442",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon clock_time_four_outline() {
    return MdiIcon.create(
        "mdi-clock-time-four-outline",
        new MdiMeta(
            "clock-time-four-outline",
            "F144E",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon clock_time_nine() {
    return MdiIcon.create(
        "mdi-clock-time-nine",
        new MdiMeta(
            "clock-time-nine",
            "F1447",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon clock_time_nine_outline() {
    return MdiIcon.create(
        "mdi-clock-time-nine-outline",
        new MdiMeta(
            "clock-time-nine-outline",
            "F1453",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon clock_time_one() {
    return MdiIcon.create(
        "mdi-clock-time-one",
        new MdiMeta(
            "clock-time-one",
            "F143F",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon clock_time_one_outline() {
    return MdiIcon.create(
        "mdi-clock-time-one-outline",
        new MdiMeta(
            "clock-time-one-outline",
            "F144B",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon clock_time_seven() {
    return MdiIcon.create(
        "mdi-clock-time-seven",
        new MdiMeta(
            "clock-time-seven",
            "F1445",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon clock_time_seven_outline() {
    return MdiIcon.create(
        "mdi-clock-time-seven-outline",
        new MdiMeta(
            "clock-time-seven-outline",
            "F1451",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon clock_time_six() {
    return MdiIcon.create(
        "mdi-clock-time-six",
        new MdiMeta(
            "clock-time-six",
            "F1444",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon clock_time_six_outline() {
    return MdiIcon.create(
        "mdi-clock-time-six-outline",
        new MdiMeta(
            "clock-time-six-outline",
            "F1450",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon clock_time_ten() {
    return MdiIcon.create(
        "mdi-clock-time-ten",
        new MdiMeta(
            "clock-time-ten",
            "F1448",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon clock_time_ten_outline() {
    return MdiIcon.create(
        "mdi-clock-time-ten-outline",
        new MdiMeta(
            "clock-time-ten-outline",
            "F1454",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon clock_time_three() {
    return MdiIcon.create(
        "mdi-clock-time-three",
        new MdiMeta(
            "clock-time-three",
            "F1441",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon clock_time_three_outline() {
    return MdiIcon.create(
        "mdi-clock-time-three-outline",
        new MdiMeta(
            "clock-time-three-outline",
            "F144D",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon clock_time_twelve() {
    return MdiIcon.create(
        "mdi-clock-time-twelve",
        new MdiMeta(
            "clock-time-twelve",
            "F144A",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon clock_time_twelve_outline() {
    return MdiIcon.create(
        "mdi-clock-time-twelve-outline",
        new MdiMeta(
            "clock-time-twelve-outline",
            "F1456",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon clock_time_two() {
    return MdiIcon.create(
        "mdi-clock-time-two",
        new MdiMeta(
            "clock-time-two",
            "F1440",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon clock_time_two_outline() {
    return MdiIcon.create(
        "mdi-clock-time-two-outline",
        new MdiMeta(
            "clock-time-two-outline",
            "F144C",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon close() {
    return MdiIcon.create(
        "mdi-close",
        new MdiMeta(
            "close",
            "F0156",
            Arrays.asList("Math", "Form"),
            Arrays.asList("clear", "multiply", "remove", "cancel"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon close_box() {
    return MdiIcon.create(
        "mdi-close-box",
        new MdiMeta(
            "close-box",
            "F0157",
            Arrays.asList("Math", "Form"),
            Arrays.asList("multiply-box", "clear-box", "cancel-box", "remove-box"),
            "Gabriel",
            "1.5.54"));
  }

  public static MdiIcon close_box_multiple() {
    return MdiIcon.create(
        "mdi-close-box-multiple",
        new MdiMeta(
            "close-box-multiple",
            "F0C5D",
            Arrays.asList("Form"),
            Arrays.asList(
                "close-boxes",
                "library-remove",
                "library-close",
                "multiply-boxes",
                "multiply-box-multiple",
                "cancel-box-multiple",
                "remove-box-multiple"),
            "Michael Richins",
            "3.2.89"));
  }

  public static MdiIcon close_box_multiple_outline() {
    return MdiIcon.create(
        "mdi-close-box-multiple-outline",
        new MdiMeta(
            "close-box-multiple-outline",
            "F0C5E",
            Arrays.asList("Form"),
            Arrays.asList(
                "close-boxes-outline",
                "library-remove-outline",
                "library-close-outline",
                "multiply-boxes-outline",
                "multiply-box-multiple-outline",
                "remove-box-multiple",
                "cancel-box-multiple"),
            "Michael Richins",
            "3.2.89"));
  }

  public static MdiIcon close_box_outline() {
    return MdiIcon.create(
        "mdi-close-box-outline",
        new MdiMeta(
            "close-box-outline",
            "F0158",
            Arrays.asList("Math", "Form"),
            Arrays.asList(
                "multiply-box-outline",
                "clear-box-outline",
                "remove-box-outline",
                "cancel-box-outline"),
            "Gabriel",
            "1.5.54"));
  }

  public static MdiIcon close_circle() {
    return MdiIcon.create(
        "mdi-close-circle",
        new MdiMeta(
            "close-circle",
            "F0159",
            Arrays.asList("Form"),
            Arrays.asList("remove-circle", "cancel-circle", "multiply-circle", "clear-circle"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon close_circle_multiple() {
    return MdiIcon.create(
        "mdi-close-circle-multiple",
        new MdiMeta(
            "close-circle-multiple",
            "F062A",
            Arrays.asList("Form"),
            Arrays.asList(
                "remove-circle-multiple",
                "coins-close",
                "coins-remove",
                "clear-circle-multiple",
                "multiply-circle-multiple"),
            "Michael Irigoyen",
            "1.6.50"));
  }

  public static MdiIcon close_circle_multiple_outline() {
    return MdiIcon.create(
        "mdi-close-circle-multiple-outline",
        new MdiMeta(
            "close-circle-multiple-outline",
            "F0883",
            Arrays.asList("Form"),
            Arrays.asList(
                "remove-circle-multiple-outline",
                "coins-close-outline",
                "coins-remove-outline",
                "cancel-circle-multiple-outline",
                "multiply-circle-multiple-outline",
                "clear-circle-multiple-outline"),
            "Michael Irigoyen",
            "2.1.99"));
  }

  public static MdiIcon close_circle_outline() {
    return MdiIcon.create(
        "mdi-close-circle-outline",
        new MdiMeta(
            "close-circle-outline",
            "F015A",
            Arrays.asList("Form"),
            Arrays.asList(
                "highlight-off",
                "multiply-circle-outline",
                "remove-circle-outline",
                "clear-circle-outline",
                "cancel-circle-outline"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon close_network() {
    return MdiIcon.create(
        "mdi-close-network",
        new MdiMeta(
            "close-network",
            "F015B",
            Arrays.asList(),
            Arrays.asList("remove-network", "cancel-network", "multiply-network", "clear-network"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon close_network_outline() {
    return MdiIcon.create(
        "mdi-close-network-outline",
        new MdiMeta(
            "close-network-outline",
            "F0C5F",
            Arrays.asList(),
            Arrays.asList(
                "remove-network-outline",
                "cancel-network-outline",
                "multiply-network-outline",
                "clear-network-outline"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon close_octagon() {
    return MdiIcon.create(
        "mdi-close-octagon",
        new MdiMeta(
            "close-octagon",
            "F015C",
            Arrays.asList(),
            Arrays.asList(
                "dangerous",
                "multiply-octagon",
                "remove-octagon",
                "cancel-octagon",
                "clear-octagon",
                "stop-remove"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon close_octagon_outline() {
    return MdiIcon.create(
        "mdi-close-octagon-outline",
        new MdiMeta(
            "close-octagon-outline",
            "F015D",
            Arrays.asList(),
            Arrays.asList(
                "remove-octagon-outline",
                "multiply-octagon-outline",
                "clear-octagon-outline",
                "cancel-octagon-outline",
                "stop-remove-outline"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon close_outline() {
    return MdiIcon.create(
        "mdi-close-outline",
        new MdiMeta(
            "close-outline",
            "F06C9",
            Arrays.asList(),
            Arrays.asList("remove-outline", "cancel-outline", "multiply-outline", "clear-outline"),
            "Michael Irigoyen",
            "1.8.36"));
  }

  public static MdiIcon close_thick() {
    return MdiIcon.create(
        "mdi-close-thick",
        new MdiMeta(
            "close-thick",
            "F1398",
            Arrays.asList(),
            Arrays.asList(
                "close-bold",
                "remove-thick",
                "remove-bold",
                "multiply-thick",
                "multiply-bold",
                "clear-thick",
                "clear-bold",
                "cancel-thick",
                "cancel-bold"),
            "Austin Andrews",
            "5.0.45"));
  }

  public static MdiIcon closed_caption() {
    return MdiIcon.create(
        "mdi-closed-caption",
        new MdiMeta(
            "closed-caption", "F015E", Arrays.asList(), Arrays.asList("cc"), "Google", "1.5.54"));
  }

  public static MdiIcon closed_caption_outline() {
    return MdiIcon.create(
        "mdi-closed-caption-outline",
        new MdiMeta(
            "closed-caption-outline",
            "F0DBD",
            Arrays.asList(),
            Arrays.asList("cc-outline"),
            "Google",
            "3.5.94"));
  }

  public static MdiIcon cloud() {
    return MdiIcon.create(
        "mdi-cloud",
        new MdiMeta(
            "cloud",
            "F015F",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList("wb-cloudy"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cloud_alert() {
    return MdiIcon.create(
        "mdi-cloud-alert",
        new MdiMeta(
            "cloud-alert",
            "F09E0",
            Arrays.asList("Alert / Error", "Cloud", "Weather"),
            Arrays.asList("cloud-warning"),
            "TheChilliPL",
            "2.5.94"));
  }

  public static MdiIcon cloud_alert_outline() {
    return MdiIcon.create(
        "mdi-cloud-alert-outline",
        new MdiMeta(
            "cloud-alert-outline",
            "F1BE0",
            Arrays.asList("Alert / Error", "Weather", "Cloud"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_arrow_down() {
    return MdiIcon.create(
        "mdi-cloud-arrow-down",
        new MdiMeta(
            "cloud-arrow-down",
            "F1BE1",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_arrow_down_outline() {
    return MdiIcon.create(
        "mdi-cloud-arrow-down-outline",
        new MdiMeta(
            "cloud-arrow-down-outline",
            "F1BE2",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_arrow_left() {
    return MdiIcon.create(
        "mdi-cloud-arrow-left",
        new MdiMeta(
            "cloud-arrow-left",
            "F1BE3",
            Arrays.asList("Weather", "Cloud"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_arrow_left_outline() {
    return MdiIcon.create(
        "mdi-cloud-arrow-left-outline",
        new MdiMeta(
            "cloud-arrow-left-outline",
            "F1BE4",
            Arrays.asList("Weather", "Cloud"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_arrow_right() {
    return MdiIcon.create(
        "mdi-cloud-arrow-right",
        new MdiMeta(
            "cloud-arrow-right",
            "F1BE5",
            Arrays.asList("Weather", "Cloud"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_arrow_right_outline() {
    return MdiIcon.create(
        "mdi-cloud-arrow-right-outline",
        new MdiMeta(
            "cloud-arrow-right-outline",
            "F1BE6",
            Arrays.asList("Weather", "Cloud"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_arrow_up() {
    return MdiIcon.create(
        "mdi-cloud-arrow-up",
        new MdiMeta(
            "cloud-arrow-up",
            "F1BE7",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_arrow_up_outline() {
    return MdiIcon.create(
        "mdi-cloud-arrow-up-outline",
        new MdiMeta(
            "cloud-arrow-up-outline",
            "F1BE8",
            Arrays.asList("Weather", "Cloud"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_braces() {
    return MdiIcon.create(
        "mdi-cloud-braces",
        new MdiMeta(
            "cloud-braces",
            "F07B5",
            Arrays.asList("Cloud", "Developer / Languages"),
            Arrays.asList("cloud-json"),
            "Andy Martinez",
            "2.0.46"));
  }

  public static MdiIcon cloud_cancel() {
    return MdiIcon.create(
        "mdi-cloud-cancel",
        new MdiMeta(
            "cloud-cancel",
            "F1BE9",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_cancel_outline() {
    return MdiIcon.create(
        "mdi-cloud-cancel-outline",
        new MdiMeta(
            "cloud-cancel-outline",
            "F1BEA",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_check() {
    return MdiIcon.create(
        "mdi-cloud-check",
        new MdiMeta(
            "cloud-check",
            "F1BEB",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_check_outline() {
    return MdiIcon.create(
        "mdi-cloud-check-outline",
        new MdiMeta(
            "cloud-check-outline",
            "F1BEC",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_check_variant() {
    return MdiIcon.create(
        "mdi-cloud-check-variant",
        new MdiMeta(
            "cloud-check-variant",
            "F0160",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList("cloud-done", "cloud-tick"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cloud_check_variant_outline() {
    return MdiIcon.create(
        "mdi-cloud-check-variant-outline",
        new MdiMeta(
            "cloud-check-variant-outline",
            "F12CC",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.8.95"));
  }

  public static MdiIcon cloud_circle() {
    return MdiIcon.create(
        "mdi-cloud-circle",
        new MdiMeta(
            "cloud-circle",
            "F0161",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cloud_circle_outline() {
    return MdiIcon.create(
        "mdi-cloud-circle-outline",
        new MdiMeta(
            "cloud-circle-outline",
            "F1BED",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Google",
            "7.1.96"));
  }

  public static MdiIcon cloud_clock() {
    return MdiIcon.create(
        "mdi-cloud-clock",
        new MdiMeta(
            "cloud-clock",
            "F1BEE",
            Arrays.asList("Weather", "Cloud"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_clock_outline() {
    return MdiIcon.create(
        "mdi-cloud-clock-outline",
        new MdiMeta(
            "cloud-clock-outline",
            "F1BEF",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_cog() {
    return MdiIcon.create(
        "mdi-cloud-cog",
        new MdiMeta(
            "cloud-cog",
            "F1BF0",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_cog_outline() {
    return MdiIcon.create(
        "mdi-cloud-cog-outline",
        new MdiMeta(
            "cloud-cog-outline",
            "F1BF1",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_download() {
    return MdiIcon.create(
        "mdi-cloud-download",
        new MdiMeta(
            "cloud-download",
            "F0162",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cloud_download_outline() {
    return MdiIcon.create(
        "mdi-cloud-download-outline",
        new MdiMeta(
            "cloud-download-outline",
            "F0B7D",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Google",
            "3.0.39"));
  }

  public static MdiIcon cloud_lock() {
    return MdiIcon.create(
        "mdi-cloud-lock",
        new MdiMeta(
            "cloud-lock",
            "F11F1",
            Arrays.asList("Cloud", "Lock"),
            Arrays.asList(),
            "Michael Richins",
            "4.5.95"));
  }

  public static MdiIcon cloud_lock_open() {
    return MdiIcon.create(
        "mdi-cloud-lock-open",
        new MdiMeta(
            "cloud-lock-open",
            "F1BF2",
            Arrays.asList("Cloud"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_lock_open_outline() {
    return MdiIcon.create(
        "mdi-cloud-lock-open-outline",
        new MdiMeta(
            "cloud-lock-open-outline",
            "F1BF3",
            Arrays.asList("Cloud"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_lock_outline() {
    return MdiIcon.create(
        "mdi-cloud-lock-outline",
        new MdiMeta(
            "cloud-lock-outline",
            "F11F2",
            Arrays.asList("Cloud", "Lock"),
            Arrays.asList(),
            "Michael Richins",
            "4.5.95"));
  }

  public static MdiIcon cloud_minus() {
    return MdiIcon.create(
        "mdi-cloud-minus",
        new MdiMeta(
            "cloud-minus",
            "F1BF4",
            Arrays.asList("Cloud"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_minus_outline() {
    return MdiIcon.create(
        "mdi-cloud-minus-outline",
        new MdiMeta(
            "cloud-minus-outline",
            "F1BF5",
            Arrays.asList("Cloud"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_off() {
    return MdiIcon.create(
        "mdi-cloud-off",
        new MdiMeta(
            "cloud-off",
            "F1BF6",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Google",
            "7.1.96"));
  }

  public static MdiIcon cloud_off_outline() {
    return MdiIcon.create(
        "mdi-cloud-off-outline",
        new MdiMeta(
            "cloud-off-outline",
            "F0164",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cloud_outline() {
    return MdiIcon.create(
        "mdi-cloud-outline",
        new MdiMeta(
            "cloud-outline",
            "F0163",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList("cloud-queue"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cloud_percent() {
    return MdiIcon.create(
        "mdi-cloud-percent",
        new MdiMeta(
            "cloud-percent",
            "F1A35",
            Arrays.asList("Weather", "Cloud", "Nature"),
            Arrays.asList("humidity", "rain-chance", "cloud-discount"),
            "Simran",
            "6.7.96"));
  }

  public static MdiIcon cloud_percent_outline() {
    return MdiIcon.create(
        "mdi-cloud-percent-outline",
        new MdiMeta(
            "cloud-percent-outline",
            "F1A36",
            Arrays.asList("Weather", "Cloud", "Nature"),
            Arrays.asList("cloud-discount-outline", "humidity-outline", "rain-chance-outline"),
            "Simran",
            "6.7.96"));
  }

  public static MdiIcon cloud_plus() {
    return MdiIcon.create(
        "mdi-cloud-plus",
        new MdiMeta(
            "cloud-plus",
            "F1BF7",
            Arrays.asList("Cloud"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_plus_outline() {
    return MdiIcon.create(
        "mdi-cloud-plus-outline",
        new MdiMeta(
            "cloud-plus-outline",
            "F1BF8",
            Arrays.asList("Cloud"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_print() {
    return MdiIcon.create(
        "mdi-cloud-print",
        new MdiMeta(
            "cloud-print",
            "F0165",
            Arrays.asList("Cloud", "Printer", "Home Automation"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon cloud_print_outline() {
    return MdiIcon.create(
        "mdi-cloud-print-outline",
        new MdiMeta(
            "cloud-print-outline",
            "F0166",
            Arrays.asList("Cloud", "Printer", "Home Automation"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon cloud_question() {
    return MdiIcon.create(
        "mdi-cloud-question",
        new MdiMeta(
            "cloud-question",
            "F0A39",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.6.95"));
  }

  public static MdiIcon cloud_question_outline() {
    return MdiIcon.create(
        "mdi-cloud-question-outline",
        new MdiMeta(
            "cloud-question-outline",
            "F1BF9",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_refresh() {
    return MdiIcon.create(
        "mdi-cloud-refresh",
        new MdiMeta(
            "cloud-refresh",
            "F1BFA",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_refresh_outline() {
    return MdiIcon.create(
        "mdi-cloud-refresh-outline",
        new MdiMeta(
            "cloud-refresh-outline",
            "F1BFB",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_refresh_variant() {
    return MdiIcon.create(
        "mdi-cloud-refresh-variant",
        new MdiMeta(
            "cloud-refresh-variant",
            "F052A",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon cloud_refresh_variant_outline() {
    return MdiIcon.create(
        "mdi-cloud-refresh-variant-outline",
        new MdiMeta(
            "cloud-refresh-variant-outline",
            "F1BFC",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_remove() {
    return MdiIcon.create(
        "mdi-cloud-remove",
        new MdiMeta(
            "cloud-remove",
            "F1BFD",
            Arrays.asList("Cloud"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_remove_outline() {
    return MdiIcon.create(
        "mdi-cloud-remove-outline",
        new MdiMeta(
            "cloud-remove-outline",
            "F1BFE",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Colton Wiscombe",
            "7.1.96"));
  }

  public static MdiIcon cloud_search() {
    return MdiIcon.create(
        "mdi-cloud-search",
        new MdiMeta(
            "cloud-search",
            "F0956",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Michael Richins",
            "2.4.85"));
  }

  public static MdiIcon cloud_search_outline() {
    return MdiIcon.create(
        "mdi-cloud-search-outline",
        new MdiMeta(
            "cloud-search-outline",
            "F0957",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Michael Richins",
            "2.4.85"));
  }

  public static MdiIcon cloud_sync() {
    return MdiIcon.create(
        "mdi-cloud-sync",
        new MdiMeta(
            "cloud-sync",
            "F063F",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Michael Irigoyen",
            "1.6.50"));
  }

  public static MdiIcon cloud_sync_outline() {
    return MdiIcon.create(
        "mdi-cloud-sync-outline",
        new MdiMeta(
            "cloud-sync-outline",
            "F12D6",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.8.95"));
  }

  public static MdiIcon cloud_tags() {
    return MdiIcon.create(
        "mdi-cloud-tags",
        new MdiMeta(
            "cloud-tags",
            "F07B6",
            Arrays.asList("Cloud"),
            Arrays.asList("cloud-xml"),
            "Andy Martinez",
            "2.0.46"));
  }

  public static MdiIcon cloud_upload() {
    return MdiIcon.create(
        "mdi-cloud-upload",
        new MdiMeta(
            "cloud-upload",
            "F0167",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList("backup"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cloud_upload_outline() {
    return MdiIcon.create(
        "mdi-cloud-upload-outline",
        new MdiMeta(
            "cloud-upload-outline",
            "F0B7E",
            Arrays.asList("Cloud", "Weather"),
            Arrays.asList("backup-outline"),
            "Google",
            "3.0.39"));
  }

  public static MdiIcon clouds() {
    return MdiIcon.create(
        "mdi-clouds",
        new MdiMeta(
            "clouds",
            "F1B95",
            Arrays.asList("Weather", "Cloud"),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon clover() {
    return MdiIcon.create(
        "mdi-clover",
        new MdiMeta(
            "clover",
            "F0816",
            Arrays.asList("Nature"),
            Arrays.asList("luck"),
            "Michael Richins",
            "2.1.19"));
  }

  public static MdiIcon clover_outline() {
    return MdiIcon.create(
        "mdi-clover-outline",
        new MdiMeta(
            "clover-outline",
            "F1C62",
            Arrays.asList("Nature"),
            Arrays.asList("luck-outline"),
            "Jeff Anders",
            "7.2.96"));
  }

  public static MdiIcon coach_lamp() {
    return MdiIcon.create(
        "mdi-coach-lamp",
        new MdiMeta(
            "coach-lamp",
            "F1020",
            Arrays.asList("Home Automation"),
            Arrays.asList("coach-light", "carriage-lamp", "carriage-light"),
            "Borre Haugen",
            "4.1.95"));
  }

  public static MdiIcon coach_lamp_variant() {
    return MdiIcon.create(
        "mdi-coach-lamp-variant",
        new MdiMeta(
            "coach-lamp-variant",
            "F1A37",
            Arrays.asList("Home Automation"),
            Arrays.asList("coach-light", "carriage-light", "carriage-lamp"),
            "Borre Haugen",
            "6.7.96"));
  }

  public static MdiIcon coat_rack() {
    return MdiIcon.create(
        "mdi-coat-rack",
        new MdiMeta(
            "coat-rack",
            "F109E",
            Arrays.asList("Home Automation", "Clothing"),
            Arrays.asList("foyer", "hallway", "entry-room"),
            "Michael Richins",
            "4.2.95"));
  }

  public static MdiIcon code_array() {
    return MdiIcon.create(
        "mdi-code-array",
        new MdiMeta(
            "code-array",
            "F0168",
            Arrays.asList("Developer / Languages"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon code_braces() {
    return MdiIcon.create(
        "mdi-code-braces",
        new MdiMeta(
            "code-braces",
            "F0169",
            Arrays.asList("Developer / Languages", "Math"),
            Arrays.asList("set"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon code_braces_box() {
    return MdiIcon.create(
        "mdi-code-braces-box",
        new MdiMeta(
            "code-braces-box",
            "F10D6",
            Arrays.asList("Developer / Languages"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.3.95"));
  }

  public static MdiIcon code_brackets() {
    return MdiIcon.create(
        "mdi-code-brackets",
        new MdiMeta(
            "code-brackets",
            "F016A",
            Arrays.asList("Developer / Languages", "Math"),
            Arrays.asList("square-brackets"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon code_equal() {
    return MdiIcon.create(
        "mdi-code-equal",
        new MdiMeta(
            "code-equal",
            "F016B",
            Arrays.asList("Developer / Languages"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon code_greater_than() {
    return MdiIcon.create(
        "mdi-code-greater-than",
        new MdiMeta(
            "code-greater-than",
            "F016C",
            Arrays.asList("Developer / Languages", "Math"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon code_greater_than_or_equal() {
    return MdiIcon.create(
        "mdi-code-greater-than-or-equal",
        new MdiMeta(
            "code-greater-than-or-equal",
            "F016D",
            Arrays.asList("Developer / Languages", "Math"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon code_json() {
    return MdiIcon.create(
        "mdi-code-json",
        new MdiMeta(
            "code-json",
            "F0626",
            Arrays.asList("Developer / Languages"),
            Arrays.asList(),
            "Austin Andrews",
            "1.6.50"));
  }

  public static MdiIcon code_less_than() {
    return MdiIcon.create(
        "mdi-code-less-than",
        new MdiMeta(
            "code-less-than",
            "F016E",
            Arrays.asList("Developer / Languages", "Math"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon code_less_than_or_equal() {
    return MdiIcon.create(
        "mdi-code-less-than-or-equal",
        new MdiMeta(
            "code-less-than-or-equal",
            "F016F",
            Arrays.asList("Developer / Languages", "Math"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon code_not_equal() {
    return MdiIcon.create(
        "mdi-code-not-equal",
        new MdiMeta(
            "code-not-equal",
            "F0170",
            Arrays.asList("Developer / Languages"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon code_not_equal_variant() {
    return MdiIcon.create(
        "mdi-code-not-equal-variant",
        new MdiMeta(
            "code-not-equal-variant",
            "F0171",
            Arrays.asList("Developer / Languages"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon code_parentheses() {
    return MdiIcon.create(
        "mdi-code-parentheses",
        new MdiMeta(
            "code-parentheses",
            "F0172",
            Arrays.asList("Developer / Languages"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon code_parentheses_box() {
    return MdiIcon.create(
        "mdi-code-parentheses-box",
        new MdiMeta(
            "code-parentheses-box",
            "F10D7",
            Arrays.asList("Developer / Languages"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.3.95"));
  }

  public static MdiIcon code_string() {
    return MdiIcon.create(
        "mdi-code-string",
        new MdiMeta(
            "code-string",
            "F0173",
            Arrays.asList("Developer / Languages"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon code_tags() {
    return MdiIcon.create(
        "mdi-code-tags",
        new MdiMeta(
            "code-tags",
            "F0174",
            Arrays.asList("Developer / Languages"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon code_tags_check() {
    return MdiIcon.create(
        "mdi-code-tags-check",
        new MdiMeta(
            "code-tags-check",
            "F0694",
            Arrays.asList("Developer / Languages"),
            Arrays.asList("code-tags-tick"),
            "Simran",
            "1.7.12"));
  }

  @Deprecated
  public static MdiIcon codepen() {
    return MdiIcon.create(
        "mdi-codepen",
        new MdiMeta(
            "codepen",
            "F0175",
            Arrays.asList("Brand / Logo", "Developer / Languages"),
            Arrays.asList(),
            "Contributors",
            "1.5.54"));
  }

  public static MdiIcon coffee() {
    return MdiIcon.create(
        "mdi-coffee",
        new MdiMeta(
            "coffee",
            "F0176",
            Arrays.asList("Food / Drink"),
            Arrays.asList("tea", "cup", "free-breakfast", "local-cafe", "drink"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon coffee_maker() {
    return MdiIcon.create(
        "mdi-coffee-maker",
        new MdiMeta(
            "coffee-maker",
            "F109F",
            Arrays.asList("Home Automation", "Food / Drink"),
            Arrays.asList("espresso-maker", "coffee-machine", "espresso-machine"),
            "Google",
            "4.2.95"));
  }

  public static MdiIcon coffee_maker_check() {
    return MdiIcon.create(
        "mdi-coffee-maker-check",
        new MdiMeta(
            "coffee-maker-check",
            "F1931",
            Arrays.asList("Home Automation", "Food / Drink"),
            Arrays.asList("coffee-maker-done", "coffee-maker-complete"),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon coffee_maker_check_outline() {
    return MdiIcon.create(
        "mdi-coffee-maker-check-outline",
        new MdiMeta(
            "coffee-maker-check-outline",
            "F1932",
            Arrays.asList("Home Automation", "Food / Drink"),
            Arrays.asList("coffee-maker-complete-outline", "coffee-maker-done-outline"),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon coffee_maker_outline() {
    return MdiIcon.create(
        "mdi-coffee-maker-outline",
        new MdiMeta(
            "coffee-maker-outline",
            "F181B",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Google",
            "6.1.95"));
  }

  public static MdiIcon coffee_off() {
    return MdiIcon.create(
        "mdi-coffee-off",
        new MdiMeta(
            "coffee-off",
            "F0FAA",
            Arrays.asList("Food / Drink"),
            Arrays.asList(
                "drink-off", "tea-off", "cup-off", "free-breakfast-off", "local-cafe-off"),
            "Michael Irigoyen",
            "3.9.97"));
  }

  public static MdiIcon coffee_off_outline() {
    return MdiIcon.create(
        "mdi-coffee-off-outline",
        new MdiMeta(
            "coffee-off-outline",
            "F0FAB",
            Arrays.asList("Food / Drink"),
            Arrays.asList(
                "drink-off-outline",
                "cup-off-outline",
                "tea-off-outline",
                "free-breakfast-off-outline",
                "local-cafe-off-outline"),
            "Michael Irigoyen",
            "3.9.97"));
  }

  public static MdiIcon coffee_outline() {
    return MdiIcon.create(
        "mdi-coffee-outline",
        new MdiMeta(
            "coffee-outline",
            "F06CA",
            Arrays.asList("Food / Drink"),
            Arrays.asList(
                "tea-outline",
                "cup-outline",
                "drink-outline",
                "free-breakfast-outline",
                "local-cafe-outline"),
            "Google",
            "1.8.36"));
  }

  public static MdiIcon coffee_to_go() {
    return MdiIcon.create(
        "mdi-coffee-to-go",
        new MdiMeta(
            "coffee-to-go",
            "F0177",
            Arrays.asList("Food / Drink"),
            Arrays.asList(
                "tea-to-go",
                "drink-to-go",
                "cup-to-go",
                "free-breakfast-to-go",
                "local-cafe-to-go"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon coffee_to_go_outline() {
    return MdiIcon.create(
        "mdi-coffee-to-go-outline",
        new MdiMeta(
            "coffee-to-go-outline",
            "F130E",
            Arrays.asList("Food / Drink"),
            Arrays.asList(
                "tea-to-go-outline",
                "cup-to-go-outline",
                "drink-to-go-outline",
                "free-breakfast-to-go-outline",
                "local-cafe-to-go-outline"),
            "Simran",
            "4.8.95"));
  }

  public static MdiIcon coffin() {
    return MdiIcon.create(
        "mdi-coffin",
        new MdiMeta(
            "coffin",
            "F0B7F",
            Arrays.asList("Holiday"),
            Arrays.asList("death", "dead"),
            "Michael Irigoyen",
            "3.0.39"));
  }

  public static MdiIcon cog() {
    return MdiIcon.create(
        "mdi-cog",
        new MdiMeta(
            "cog",
            "F0493",
            Arrays.asList("Settings"),
            Arrays.asList("settings", "gear"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cog_box() {
    return MdiIcon.create(
        "mdi-cog-box",
        new MdiMeta(
            "cog-box",
            "F0494",
            Arrays.asList("Settings"),
            Arrays.asList("gear-box", "settings-applications", "settings-box"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cog_clockwise() {
    return MdiIcon.create(
        "mdi-cog-clockwise",
        new MdiMeta(
            "cog-clockwise",
            "F11DD",
            Arrays.asList("Settings"),
            Arrays.asList(),
            "François Risoud",
            "4.5.95"));
  }

  public static MdiIcon cog_counterclockwise() {
    return MdiIcon.create(
        "mdi-cog-counterclockwise",
        new MdiMeta(
            "cog-counterclockwise",
            "F11DE",
            Arrays.asList("Settings"),
            Arrays.asList(),
            "François Risoud",
            "4.5.95"));
  }

  public static MdiIcon cog_off() {
    return MdiIcon.create(
        "mdi-cog-off",
        new MdiMeta(
            "cog-off",
            "F13CE",
            Arrays.asList("Settings"),
            Arrays.asList("settings-off"),
            "Simran",
            "5.1.45"));
  }

  public static MdiIcon cog_off_outline() {
    return MdiIcon.create(
        "mdi-cog-off-outline",
        new MdiMeta(
            "cog-off-outline",
            "F13CF",
            Arrays.asList("Settings"),
            Arrays.asList("settings-off-outline"),
            "Michael Irigoyen",
            "5.1.45"));
  }

  public static MdiIcon cog_outline() {
    return MdiIcon.create(
        "mdi-cog-outline",
        new MdiMeta(
            "cog-outline",
            "F08BB",
            Arrays.asList("Settings"),
            Arrays.asList("gear-outline", "settings-outline"),
            "Google",
            "2.2.43"));
  }

  public static MdiIcon cog_pause() {
    return MdiIcon.create(
        "mdi-cog-pause",
        new MdiMeta(
            "cog-pause",
            "F1933",
            Arrays.asList("Settings"),
            Arrays.asList("settings-pause", "gear-pause"),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon cog_pause_outline() {
    return MdiIcon.create(
        "mdi-cog-pause-outline",
        new MdiMeta(
            "cog-pause-outline",
            "F1934",
            Arrays.asList("Settings"),
            Arrays.asList("settings-pause-outline", "gear-pause-outline"),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon cog_play() {
    return MdiIcon.create(
        "mdi-cog-play",
        new MdiMeta(
            "cog-play",
            "F1935",
            Arrays.asList("Settings"),
            Arrays.asList("settings-play", "gear-play"),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon cog_play_outline() {
    return MdiIcon.create(
        "mdi-cog-play-outline",
        new MdiMeta(
            "cog-play-outline",
            "F1936",
            Arrays.asList("Settings"),
            Arrays.asList("settings-play-outline", "gear-play-outline"),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon cog_refresh() {
    return MdiIcon.create(
        "mdi-cog-refresh",
        new MdiMeta(
            "cog-refresh",
            "F145E",
            Arrays.asList("Settings"),
            Arrays.asList("settings-refresh"),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon cog_refresh_outline() {
    return MdiIcon.create(
        "mdi-cog-refresh-outline",
        new MdiMeta(
            "cog-refresh-outline",
            "F145F",
            Arrays.asList("Settings"),
            Arrays.asList("settings-refresh-outline"),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon cog_stop() {
    return MdiIcon.create(
        "mdi-cog-stop",
        new MdiMeta(
            "cog-stop",
            "F1937",
            Arrays.asList("Settings"),
            Arrays.asList("settings-stop", "gear-stop"),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon cog_stop_outline() {
    return MdiIcon.create(
        "mdi-cog-stop-outline",
        new MdiMeta(
            "cog-stop-outline",
            "F1938",
            Arrays.asList("Settings"),
            Arrays.asList("settings-stop-outline", "gear-stop-outline"),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon cog_sync() {
    return MdiIcon.create(
        "mdi-cog-sync",
        new MdiMeta(
            "cog-sync",
            "F1460",
            Arrays.asList("Settings"),
            Arrays.asList("settings-sync"),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon cog_sync_outline() {
    return MdiIcon.create(
        "mdi-cog-sync-outline",
        new MdiMeta(
            "cog-sync-outline",
            "F1461",
            Arrays.asList("Settings"),
            Arrays.asList("settings-sync-outline"),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon cog_transfer() {
    return MdiIcon.create(
        "mdi-cog-transfer",
        new MdiMeta(
            "cog-transfer",
            "F105B",
            Arrays.asList("Settings"),
            Arrays.asList("settings-transfer"),
            "Michael Richins",
            "4.1.95"));
  }

  public static MdiIcon cog_transfer_outline() {
    return MdiIcon.create(
        "mdi-cog-transfer-outline",
        new MdiMeta(
            "cog-transfer-outline",
            "F105C",
            Arrays.asList("Settings"),
            Arrays.asList("settings-transfer-outline"),
            "Michael Richins",
            "4.1.95"));
  }

  public static MdiIcon cogs() {
    return MdiIcon.create(
        "mdi-cogs",
        new MdiMeta(
            "cogs",
            "F08D6",
            Arrays.asList("Settings"),
            Arrays.asList("settings", "manufacturing"),
            "Google",
            "2.3.50"));
  }

  public static MdiIcon collage() {
    return MdiIcon.create(
        "mdi-collage",
        new MdiMeta(
            "collage",
            "F0640",
            Arrays.asList(),
            Arrays.asList("auto-awesome-mosaic"),
            "Google",
            "1.6.50"));
  }

  public static MdiIcon collapse_all() {
    return MdiIcon.create(
        "mdi-collapse-all",
        new MdiMeta(
            "collapse-all",
            "F0AA6",
            Arrays.asList(),
            Arrays.asList("animation-minus"),
            "Michael Irigoyen",
            "2.7.94"));
  }

  public static MdiIcon collapse_all_outline() {
    return MdiIcon.create(
        "mdi-collapse-all-outline",
        new MdiMeta(
            "collapse-all-outline",
            "F0AA7",
            Arrays.asList(),
            Arrays.asList("animation-minus-outline"),
            "Michael Irigoyen",
            "2.7.94"));
  }

  public static MdiIcon color_helper() {
    return MdiIcon.create(
        "mdi-color-helper",
        new MdiMeta(
            "color-helper",
            "F0179",
            Arrays.asList("Text / Content / Format", "Color"),
            Arrays.asList("colour-helper"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon comma() {
    return MdiIcon.create(
        "mdi-comma",
        new MdiMeta(
            "comma", "F0E23", Arrays.asList(), Arrays.asList(), "Michael Richins", "3.6.95"));
  }

  public static MdiIcon comma_box() {
    return MdiIcon.create(
        "mdi-comma-box",
        new MdiMeta(
            "comma-box", "F0E2B", Arrays.asList(), Arrays.asList(), "Michael Richins", "3.6.95"));
  }

  public static MdiIcon comma_box_outline() {
    return MdiIcon.create(
        "mdi-comma-box-outline",
        new MdiMeta(
            "comma-box-outline",
            "F0E24",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "3.6.95"));
  }

  public static MdiIcon comma_circle() {
    return MdiIcon.create(
        "mdi-comma-circle",
        new MdiMeta(
            "comma-circle",
            "F0E25",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "3.6.95"));
  }

  public static MdiIcon comma_circle_outline() {
    return MdiIcon.create(
        "mdi-comma-circle-outline",
        new MdiMeta(
            "comma-circle-outline",
            "F0E26",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "3.6.95"));
  }

  public static MdiIcon comment() {
    return MdiIcon.create(
        "mdi-comment",
        new MdiMeta(
            "comment", "F017A", Arrays.asList(), Arrays.asList(), "Austin Andrews", "1.5.54"));
  }

  public static MdiIcon comment_account() {
    return MdiIcon.create(
        "mdi-comment-account",
        new MdiMeta(
            "comment-account",
            "F017B",
            Arrays.asList("Account / User"),
            Arrays.asList("comment-user", "comment-person"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon comment_account_outline() {
    return MdiIcon.create(
        "mdi-comment-account-outline",
        new MdiMeta(
            "comment-account-outline",
            "F017C",
            Arrays.asList("Account / User"),
            Arrays.asList("comment-user-outline", "comment-person-outline"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon comment_alert() {
    return MdiIcon.create(
        "mdi-comment-alert",
        new MdiMeta(
            "comment-alert",
            "F017D",
            Arrays.asList("Alert / Error"),
            Arrays.asList("comment-warning"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon comment_alert_outline() {
    return MdiIcon.create(
        "mdi-comment-alert-outline",
        new MdiMeta(
            "comment-alert-outline",
            "F017E",
            Arrays.asList("Alert / Error"),
            Arrays.asList("comment-warning-outline"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon comment_arrow_left() {
    return MdiIcon.create(
        "mdi-comment-arrow-left",
        new MdiMeta(
            "comment-arrow-left",
            "F09E1",
            Arrays.asList(),
            Arrays.asList("comment-previous"),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon comment_arrow_left_outline() {
    return MdiIcon.create(
        "mdi-comment-arrow-left-outline",
        new MdiMeta(
            "comment-arrow-left-outline",
            "F09E2",
            Arrays.asList(),
            Arrays.asList("comment-previous-outline"),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon comment_arrow_right() {
    return MdiIcon.create(
        "mdi-comment-arrow-right",
        new MdiMeta(
            "comment-arrow-right",
            "F09E3",
            Arrays.asList(),
            Arrays.asList("comment-next"),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon comment_arrow_right_outline() {
    return MdiIcon.create(
        "mdi-comment-arrow-right-outline",
        new MdiMeta(
            "comment-arrow-right-outline",
            "F09E4",
            Arrays.asList(),
            Arrays.asList("comment-next-outline"),
            "Michael Irigoyen",
            "2.5.94"));
  }

  public static MdiIcon comment_bookmark() {
    return MdiIcon.create(
        "mdi-comment-bookmark",
        new MdiMeta(
            "comment-bookmark",
            "F15AE",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.5.55"));
  }

  public static MdiIcon comment_bookmark_outline() {
    return MdiIcon.create(
        "mdi-comment-bookmark-outline",
        new MdiMeta(
            "comment-bookmark-outline",
            "F15AF",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.5.55"));
  }

  public static MdiIcon comment_check() {
    return MdiIcon.create(
        "mdi-comment-check",
        new MdiMeta(
            "comment-check",
            "F017F",
            Arrays.asList(),
            Arrays.asList("comment-tick"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon comment_check_outline() {
    return MdiIcon.create(
        "mdi-comment-check-outline",
        new MdiMeta(
            "comment-check-outline",
            "F0180",
            Arrays.asList(),
            Arrays.asList("comment-tick-outline"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon comment_edit() {
    return MdiIcon.create(
        "mdi-comment-edit",
        new MdiMeta(
            "comment-edit",
            "F11BF",
            Arrays.asList("Edit / Modify"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.5.95"));
  }

  public static MdiIcon comment_edit_outline() {
    return MdiIcon.create(
        "mdi-comment-edit-outline",
        new MdiMeta(
            "comment-edit-outline",
            "F12C4",
            Arrays.asList("Edit / Modify"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.8.95"));
  }

  public static MdiIcon comment_eye() {
    return MdiIcon.create(
        "mdi-comment-eye",
        new MdiMeta(
            "comment-eye",
            "F0A3A",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.6.95"));
  }

  public static MdiIcon comment_eye_outline() {
    return MdiIcon.create(
        "mdi-comment-eye-outline",
        new MdiMeta(
            "comment-eye-outline",
            "F0A3B",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.6.95"));
  }

  public static MdiIcon comment_flash() {
    return MdiIcon.create(
        "mdi-comment-flash",
        new MdiMeta(
            "comment-flash",
            "F15B0",
            Arrays.asList(),
            Arrays.asList("comment-quick"),
            "Michael Irigoyen",
            "5.5.55"));
  }

  public static MdiIcon comment_flash_outline() {
    return MdiIcon.create(
        "mdi-comment-flash-outline",
        new MdiMeta(
            "comment-flash-outline",
            "F15B1",
            Arrays.asList(),
            Arrays.asList("comment-quick-outline"),
            "Michael Irigoyen",
            "5.5.55"));
  }

  public static MdiIcon comment_minus() {
    return MdiIcon.create(
        "mdi-comment-minus",
        new MdiMeta(
            "comment-minus",
            "F15DF",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.6.55"));
  }

  public static MdiIcon comment_minus_outline() {
    return MdiIcon.create(
        "mdi-comment-minus-outline",
        new MdiMeta(
            "comment-minus-outline",
            "F15E0",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.6.55"));
  }

  public static MdiIcon comment_multiple() {
    return MdiIcon.create(
        "mdi-comment-multiple",
        new MdiMeta(
            "comment-multiple",
            "F085F",
            Arrays.asList(),
            Arrays.asList("comments"),
            "Michael Richins",
            "2.1.99"));
  }

  public static MdiIcon comment_multiple_outline() {
    return MdiIcon.create(
        "mdi-comment-multiple-outline",
        new MdiMeta(
            "comment-multiple-outline",
            "F0181",
            Arrays.asList(),
            Arrays.asList("comments-outline"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon comment_off() {
    return MdiIcon.create(
        "mdi-comment-off",
        new MdiMeta(
            "comment-off", "F15E1", Arrays.asList(), Arrays.asList(), "Colton Wiscombe", "5.6.55"));
  }

  public static MdiIcon comment_off_outline() {
    return MdiIcon.create(
        "mdi-comment-off-outline",
        new MdiMeta(
            "comment-off-outline",
            "F15E2",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.6.55"));
  }

  public static MdiIcon comment_outline() {
    return MdiIcon.create(
        "mdi-comment-outline",
        new MdiMeta(
            "comment-outline",
            "F0182",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon comment_plus() {
    return MdiIcon.create(
        "mdi-comment-plus",
        new MdiMeta(
            "comment-plus",
            "F09E5",
            Arrays.asList(),
            Arrays.asList("comment-add"),
            "Peter Noble",
            "2.5.94"));
  }

  public static MdiIcon comment_plus_outline() {
    return MdiIcon.create(
        "mdi-comment-plus-outline",
        new MdiMeta(
            "comment-plus-outline",
            "F0183",
            Arrays.asList(),
            Arrays.asList("comment-add-outline"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon comment_processing() {
    return MdiIcon.create(
        "mdi-comment-processing",
        new MdiMeta(
            "comment-processing",
            "F0184",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon comment_processing_outline() {
    return MdiIcon.create(
        "mdi-comment-processing-outline",
        new MdiMeta(
            "comment-processing-outline",
            "F0185",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon comment_question() {
    return MdiIcon.create(
        "mdi-comment-question",
        new MdiMeta(
            "comment-question",
            "F0817",
            Arrays.asList(),
            Arrays.asList("comment-help"),
            "Austin Andrews",
            "2.1.19"));
  }

  public static MdiIcon comment_question_outline() {
    return MdiIcon.create(
        "mdi-comment-question-outline",
        new MdiMeta(
            "comment-question-outline",
            "F0186",
            Arrays.asList(),
            Arrays.asList("comment-help-outline"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon comment_quote() {
    return MdiIcon.create(
        "mdi-comment-quote",
        new MdiMeta(
            "comment-quote",
            "F1021",
            Arrays.asList(),
            Arrays.asList("feedback"),
            "Michael Irigoyen",
            "4.1.95"));
  }

  public static MdiIcon comment_quote_outline() {
    return MdiIcon.create(
        "mdi-comment-quote-outline",
        new MdiMeta(
            "comment-quote-outline",
            "F1022",
            Arrays.asList(),
            Arrays.asList("feedback-outline"),
            "Michael Irigoyen",
            "4.1.95"));
  }

  public static MdiIcon comment_remove() {
    return MdiIcon.create(
        "mdi-comment-remove",
        new MdiMeta(
            "comment-remove",
            "F05DE",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon comment_remove_outline() {
    return MdiIcon.create(
        "mdi-comment-remove-outline",
        new MdiMeta(
            "comment-remove-outline",
            "F0187",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon comment_search() {
    return MdiIcon.create(
        "mdi-comment-search",
        new MdiMeta(
            "comment-search", "F0A3C", Arrays.asList(), Arrays.asList(), "GreenTurtwig", "2.6.95"));
  }

  public static MdiIcon comment_search_outline() {
    return MdiIcon.create(
        "mdi-comment-search-outline",
        new MdiMeta(
            "comment-search-outline",
            "F0A3D",
            Arrays.asList(),
            Arrays.asList(),
            "GreenTurtwig",
            "2.6.95"));
  }

  public static MdiIcon comment_text() {
    return MdiIcon.create(
        "mdi-comment-text",
        new MdiMeta(
            "comment-text", "F0188", Arrays.asList(), Arrays.asList(), "Austin Andrews", "1.5.54"));
  }

  public static MdiIcon comment_text_multiple() {
    return MdiIcon.create(
        "mdi-comment-text-multiple",
        new MdiMeta(
            "comment-text-multiple",
            "F0860",
            Arrays.asList(),
            Arrays.asList("comments-text"),
            "Michael Richins",
            "2.1.99"));
  }

  public static MdiIcon comment_text_multiple_outline() {
    return MdiIcon.create(
        "mdi-comment-text-multiple-outline",
        new MdiMeta(
            "comment-text-multiple-outline",
            "F0861",
            Arrays.asList(),
            Arrays.asList("comments-text-outline"),
            "Michael Richins",
            "2.1.99"));
  }

  public static MdiIcon comment_text_outline() {
    return MdiIcon.create(
        "mdi-comment-text-outline",
        new MdiMeta(
            "comment-text-outline",
            "F0189",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon compare() {
    return MdiIcon.create(
        "mdi-compare",
        new MdiMeta(
            "compare",
            "F018A",
            Arrays.asList(),
            Arrays.asList("theme-light-dark"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon compare_horizontal() {
    return MdiIcon.create(
        "mdi-compare-horizontal",
        new MdiMeta(
            "compare-horizontal",
            "F1492",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Google",
            "5.3.45"));
  }

  public static MdiIcon compare_remove() {
    return MdiIcon.create(
        "mdi-compare-remove",
        new MdiMeta(
            "compare-remove", "F18B3", Arrays.asList(), Arrays.asList(), "nilsfast", "6.3.95"));
  }

  public static MdiIcon compare_vertical() {
    return MdiIcon.create(
        "mdi-compare-vertical",
        new MdiMeta(
            "compare-vertical",
            "F1493",
            Arrays.asList("Arrow"),
            Arrays.asList(),
            "Google",
            "5.3.45"));
  }

  public static MdiIcon compass() {
    return MdiIcon.create(
        "mdi-compass",
        new MdiMeta(
            "compass",
            "F018B",
            Arrays.asList("Navigation", "Geographic Information System"),
            Arrays.asList("explore"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon compass_off() {
    return MdiIcon.create(
        "mdi-compass-off",
        new MdiMeta(
            "compass-off",
            "F0B80",
            Arrays.asList("Geographic Information System", "Navigation"),
            Arrays.asList(),
            "Google",
            "3.0.39"));
  }

  public static MdiIcon compass_off_outline() {
    return MdiIcon.create(
        "mdi-compass-off-outline",
        new MdiMeta(
            "compass-off-outline",
            "F0B81",
            Arrays.asList("Geographic Information System", "Navigation"),
            Arrays.asList(),
            "Google",
            "3.0.39"));
  }

  public static MdiIcon compass_outline() {
    return MdiIcon.create(
        "mdi-compass-outline",
        new MdiMeta(
            "compass-outline",
            "F018C",
            Arrays.asList("Navigation", "Geographic Information System"),
            Arrays.asList(),
            "Gabriel",
            "1.5.54"));
  }

  public static MdiIcon compass_rose() {
    return MdiIcon.create(
        "mdi-compass-rose",
        new MdiMeta(
            "compass-rose",
            "F1382",
            Arrays.asList("Navigation"),
            Arrays.asList(),
            "Michael Richins",
            "4.9.95"));
  }

  public static MdiIcon compost() {
    return MdiIcon.create(
        "mdi-compost",
        new MdiMeta(
            "compost",
            "F1A38",
            Arrays.asList("Agriculture", "Nature"),
            Arrays.asList("regeneration", "regenerative-agriculture"),
            "Google",
            "6.7.96"));
  }

  public static MdiIcon cone() {
    return MdiIcon.create(
        "mdi-cone",
        new MdiMeta(
            "cone", "F194C", Arrays.asList("Shape"), Arrays.asList(), "Colton Wiscombe", "6.4.95"));
  }

  public static MdiIcon cone_off() {
    return MdiIcon.create(
        "mdi-cone-off",
        new MdiMeta(
            "cone-off",
            "F194D",
            Arrays.asList("Shape"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.4.95"));
  }

  public static MdiIcon connection() {
    return MdiIcon.create(
        "mdi-connection",
        new MdiMeta(
            "connection",
            "F1616",
            Arrays.asList("Home Automation"),
            Arrays.asList("plug"),
            "Michael Irigoyen",
            "5.6.55"));
  }

  public static MdiIcon console() {
    return MdiIcon.create(
        "mdi-console",
        new MdiMeta(
            "console",
            "F018D",
            Arrays.asList(),
            Arrays.asList("terminal"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon console_line() {
    return MdiIcon.create(
        "mdi-console-line",
        new MdiMeta(
            "console-line",
            "F07B7",
            Arrays.asList(),
            Arrays.asList("terminal-line"),
            "Austin Andrews",
            "2.0.46"));
  }

  public static MdiIcon console_network() {
    return MdiIcon.create(
        "mdi-console-network",
        new MdiMeta(
            "console-network",
            "F08A9",
            Arrays.asList(),
            Arrays.asList("terminal-network"),
            "Michael Richins",
            "2.2.43"));
  }

  public static MdiIcon console_network_outline() {
    return MdiIcon.create(
        "mdi-console-network-outline",
        new MdiMeta(
            "console-network-outline",
            "F0C60",
            Arrays.asList(),
            Arrays.asList("terminal-network-outline"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon consolidate() {
    return MdiIcon.create(
        "mdi-consolidate",
        new MdiMeta(
            "consolidate",
            "F10D8",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.3.95"));
  }

  public static MdiIcon contactless_payment() {
    return MdiIcon.create(
        "mdi-contactless-payment",
        new MdiMeta(
            "contactless-payment",
            "F0D6A",
            Arrays.asList("Currency"),
            Arrays.asList(),
            "Michael Richins",
            "3.4.93"));
  }

  public static MdiIcon contactless_payment_circle() {
    return MdiIcon.create(
        "mdi-contactless-payment-circle",
        new MdiMeta(
            "contactless-payment-circle",
            "F0321",
            Arrays.asList("Currency"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon contactless_payment_circle_outline() {
    return MdiIcon.create(
        "mdi-contactless-payment-circle-outline",
        new MdiMeta(
            "contactless-payment-circle-outline",
            "F0408",
            Arrays.asList("Currency"),
            Arrays.asList(),
            "Michael Irigoyen",
            "1.5.54"));
  }

  public static MdiIcon contacts() {
    return MdiIcon.create(
        "mdi-contacts",
        new MdiMeta("contacts", "F06CB", Arrays.asList(), Arrays.asList(), "Google", "1.8.36"));
  }

  public static MdiIcon contacts_outline() {
    return MdiIcon.create(
        "mdi-contacts-outline",
        new MdiMeta(
            "contacts-outline", "F05B8", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon contain() {
    return MdiIcon.create(
        "mdi-contain",
        new MdiMeta(
            "contain", "F0A3E", Arrays.asList(), Arrays.asList(), "Michael Richins", "2.6.95"));
  }

  public static MdiIcon contain_end() {
    return MdiIcon.create(
        "mdi-contain-end",
        new MdiMeta(
            "contain-end", "F0A3F", Arrays.asList(), Arrays.asList(), "Michael Richins", "2.6.95"));
  }

  public static MdiIcon contain_start() {
    return MdiIcon.create(
        "mdi-contain-start",
        new MdiMeta(
            "contain-start",
            "F0A40",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "2.6.95"));
  }

  public static MdiIcon content_copy() {
    return MdiIcon.create(
        "mdi-content-copy",
        new MdiMeta(
            "content-copy",
            "F018F",
            Arrays.asList("Text / Content / Format"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon content_cut() {
    return MdiIcon.create(
        "mdi-content-cut",
        new MdiMeta(
            "content-cut",
            "F0190",
            Arrays.asList("Health / Beauty", "Text / Content / Format"),
            Arrays.asList("scissors", "clip"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon content_duplicate() {
    return MdiIcon.create(
        "mdi-content-duplicate",
        new MdiMeta(
            "content-duplicate",
            "F0191",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon content_paste() {
    return MdiIcon.create(
        "mdi-content-paste",
        new MdiMeta(
            "content-paste",
            "F0192",
            Arrays.asList("Text / Content / Format"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon content_save() {
    return MdiIcon.create(
        "mdi-content-save",
        new MdiMeta(
            "content-save",
            "F0193",
            Arrays.asList(),
            Arrays.asList("floppy-disc", "floppy-disk"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon content_save_alert() {
    return MdiIcon.create(
        "mdi-content-save-alert",
        new MdiMeta(
            "content-save-alert",
            "F0F42",
            Arrays.asList("Alert / Error"),
            Arrays.asList("floppy-disc-alert"),
            "Michael Richins",
            "3.9.97"));
  }

  public static MdiIcon content_save_alert_outline() {
    return MdiIcon.create(
        "mdi-content-save-alert-outline",
        new MdiMeta(
            "content-save-alert-outline",
            "F0F43",
            Arrays.asList("Alert / Error"),
            Arrays.asList("floppy-disc-alert-outline"),
            "Michael Richins",
            "3.9.97"));
  }

  public static MdiIcon content_save_all() {
    return MdiIcon.create(
        "mdi-content-save-all",
        new MdiMeta(
            "content-save-all",
            "F0194",
            Arrays.asList(),
            Arrays.asList("floppy-disc-multiple"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon content_save_all_outline() {
    return MdiIcon.create(
        "mdi-content-save-all-outline",
        new MdiMeta(
            "content-save-all-outline",
            "F0F44",
            Arrays.asList(),
            Arrays.asList("floppy-disc-multiple-outline"),
            "Michael Irigoyen",
            "3.9.97"));
  }

  public static MdiIcon content_save_check() {
    return MdiIcon.create(
        "mdi-content-save-check",
        new MdiMeta(
            "content-save-check",
            "F18EA",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.3.95"));
  }

  public static MdiIcon content_save_check_outline() {
    return MdiIcon.create(
        "mdi-content-save-check-outline",
        new MdiMeta(
            "content-save-check-outline",
            "F18EB",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.3.95"));
  }

  public static MdiIcon content_save_cog() {
    return MdiIcon.create(
        "mdi-content-save-cog",
        new MdiMeta(
            "content-save-cog",
            "F145B",
            Arrays.asList("Settings"),
            Arrays.asList("floppy-disc-cog"),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon content_save_cog_outline() {
    return MdiIcon.create(
        "mdi-content-save-cog-outline",
        new MdiMeta(
            "content-save-cog-outline",
            "F145C",
            Arrays.asList("Settings"),
            Arrays.asList("floppy-disc-cog-outline"),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon content_save_edit() {
    return MdiIcon.create(
        "mdi-content-save-edit",
        new MdiMeta(
            "content-save-edit",
            "F0CFB",
            Arrays.asList("Edit / Modify"),
            Arrays.asList("floppy-disc-edit"),
            "Michael Irigoyen",
            "3.3.92"));
  }

  public static MdiIcon content_save_edit_outline() {
    return MdiIcon.create(
        "mdi-content-save-edit-outline",
        new MdiMeta(
            "content-save-edit-outline",
            "F0CFC",
            Arrays.asList("Edit / Modify"),
            Arrays.asList("floppy-disc-edit-outline"),
            "Michael Irigoyen",
            "3.3.92"));
  }

  public static MdiIcon content_save_minus() {
    return MdiIcon.create(
        "mdi-content-save-minus",
        new MdiMeta(
            "content-save-minus",
            "F1B43",
            Arrays.asList(),
            Arrays.asList(),
            "Hans Böhm",
            "6.9.96"));
  }

  public static MdiIcon content_save_minus_outline() {
    return MdiIcon.create(
        "mdi-content-save-minus-outline",
        new MdiMeta(
            "content-save-minus-outline",
            "F1B44",
            Arrays.asList(),
            Arrays.asList(),
            "Hans Böhm",
            "6.9.96"));
  }

  public static MdiIcon content_save_move() {
    return MdiIcon.create(
        "mdi-content-save-move",
        new MdiMeta(
            "content-save-move",
            "F0E27",
            Arrays.asList(),
            Arrays.asList("floppy-disc-move"),
            "Michael Richins",
            "3.6.95"));
  }

  public static MdiIcon content_save_move_outline() {
    return MdiIcon.create(
        "mdi-content-save-move-outline",
        new MdiMeta(
            "content-save-move-outline",
            "F0E28",
            Arrays.asList(),
            Arrays.asList("floppy-disc-move-outline"),
            "Michael Richins",
            "3.6.95"));
  }

  public static MdiIcon content_save_off() {
    return MdiIcon.create(
        "mdi-content-save-off",
        new MdiMeta(
            "content-save-off",
            "F1643",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon content_save_off_outline() {
    return MdiIcon.create(
        "mdi-content-save-off-outline",
        new MdiMeta(
            "content-save-off-outline",
            "F1644",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon content_save_outline() {
    return MdiIcon.create(
        "mdi-content-save-outline",
        new MdiMeta(
            "content-save-outline", "F0818", Arrays.asList(), Arrays.asList(), "Google", "2.1.19"));
  }

  public static MdiIcon content_save_plus() {
    return MdiIcon.create(
        "mdi-content-save-plus",
        new MdiMeta(
            "content-save-plus",
            "F1B41",
            Arrays.asList(),
            Arrays.asList("content-save-add"),
            "Hans Böhm",
            "6.9.96"));
  }

  public static MdiIcon content_save_plus_outline() {
    return MdiIcon.create(
        "mdi-content-save-plus-outline",
        new MdiMeta(
            "content-save-plus-outline",
            "F1B42",
            Arrays.asList(),
            Arrays.asList("content-save-add-outline"),
            "Hans Böhm",
            "6.9.96"));
  }

  public static MdiIcon content_save_settings() {
    return MdiIcon.create(
        "mdi-content-save-settings",
        new MdiMeta(
            "content-save-settings",
            "F061B",
            Arrays.asList("Settings"),
            Arrays.asList("floppy-disc-settings"),
            "Simran",
            "1.6.50"));
  }

  public static MdiIcon content_save_settings_outline() {
    return MdiIcon.create(
        "mdi-content-save-settings-outline",
        new MdiMeta(
            "content-save-settings-outline",
            "F0B2E",
            Arrays.asList("Settings"),
            Arrays.asList("floppy-disc-settings-outline"),
            "Ruslan Garifullin",
            "2.8.94"));
  }

  public static MdiIcon contrast() {
    return MdiIcon.create(
        "mdi-contrast",
        new MdiMeta(
            "contrast", "F0195", Arrays.asList(), Arrays.asList(), "Austin Andrews", "1.5.54"));
  }

  public static MdiIcon contrast_box() {
    return MdiIcon.create(
        "mdi-contrast-box",
        new MdiMeta("contrast-box", "F0196", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon contrast_circle() {
    return MdiIcon.create(
        "mdi-contrast-circle",
        new MdiMeta(
            "contrast-circle", "F0197", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon controller() {
    return MdiIcon.create(
        "mdi-controller",
        new MdiMeta(
            "controller",
            "F02B4",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("gamepad"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon controller_classic() {
    return MdiIcon.create(
        "mdi-controller-classic",
        new MdiMeta(
            "controller-classic",
            "F0B82",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("gamepad-classic"),
            "Austin Andrews",
            "3.0.39"));
  }

  public static MdiIcon controller_classic_outline() {
    return MdiIcon.create(
        "mdi-controller-classic-outline",
        new MdiMeta(
            "controller-classic-outline",
            "F0B83",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("gamepad-classic-outline"),
            "Austin Andrews",
            "3.0.39"));
  }

  public static MdiIcon controller_off() {
    return MdiIcon.create(
        "mdi-controller-off",
        new MdiMeta(
            "controller-off",
            "F02B5",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("gamepad-off"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cookie() {
    return MdiIcon.create(
        "mdi-cookie",
        new MdiMeta(
            "cookie",
            "F0198",
            Arrays.asList("Food / Drink"),
            Arrays.asList("biscuit"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cookie_alert() {
    return MdiIcon.create(
        "mdi-cookie-alert",
        new MdiMeta(
            "cookie-alert",
            "F16D0",
            Arrays.asList("Food / Drink", "Alert / Error"),
            Arrays.asList("biscuit-alert"),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon cookie_alert_outline() {
    return MdiIcon.create(
        "mdi-cookie-alert-outline",
        new MdiMeta(
            "cookie-alert-outline",
            "F16D1",
            Arrays.asList("Food / Drink", "Alert / Error"),
            Arrays.asList("biscuit-alert-outline"),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon cookie_check() {
    return MdiIcon.create(
        "mdi-cookie-check",
        new MdiMeta(
            "cookie-check",
            "F16D2",
            Arrays.asList("Food / Drink"),
            Arrays.asList("biscuit-check"),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon cookie_check_outline() {
    return MdiIcon.create(
        "mdi-cookie-check-outline",
        new MdiMeta(
            "cookie-check-outline",
            "F16D3",
            Arrays.asList("Food / Drink"),
            Arrays.asList("biscuit-check-outline"),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon cookie_clock() {
    return MdiIcon.create(
        "mdi-cookie-clock",
        new MdiMeta(
            "cookie-clock",
            "F16E4",
            Arrays.asList("Food / Drink", "Date / Time"),
            Arrays.asList("biscuit-clock"),
            "Colton Wiscombe",
            "5.9.55"));
  }

  public static MdiIcon cookie_clock_outline() {
    return MdiIcon.create(
        "mdi-cookie-clock-outline",
        new MdiMeta(
            "cookie-clock-outline",
            "F16E5",
            Arrays.asList("Food / Drink", "Date / Time"),
            Arrays.asList("biscuit-clock-outline"),
            "Colton Wiscombe",
            "5.9.55"));
  }

  public static MdiIcon cookie_cog() {
    return MdiIcon.create(
        "mdi-cookie-cog",
        new MdiMeta(
            "cookie-cog",
            "F16D4",
            Arrays.asList("Food / Drink", "Settings"),
            Arrays.asList("biscuit-cog"),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon cookie_cog_outline() {
    return MdiIcon.create(
        "mdi-cookie-cog-outline",
        new MdiMeta(
            "cookie-cog-outline",
            "F16D5",
            Arrays.asList("Food / Drink", "Settings"),
            Arrays.asList("biscuit-cog-outline"),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon cookie_edit() {
    return MdiIcon.create(
        "mdi-cookie-edit",
        new MdiMeta(
            "cookie-edit",
            "F16E6",
            Arrays.asList("Food / Drink", "Edit / Modify"),
            Arrays.asList("biscuit-edit"),
            "Colton Wiscombe",
            "5.9.55"));
  }

  public static MdiIcon cookie_edit_outline() {
    return MdiIcon.create(
        "mdi-cookie-edit-outline",
        new MdiMeta(
            "cookie-edit-outline",
            "F16E7",
            Arrays.asList("Food / Drink", "Edit / Modify"),
            Arrays.asList("biscuit-edit-outline"),
            "Colton Wiscombe",
            "5.9.55"));
  }

  public static MdiIcon cookie_lock() {
    return MdiIcon.create(
        "mdi-cookie-lock",
        new MdiMeta(
            "cookie-lock",
            "F16E8",
            Arrays.asList("Food / Drink", "Lock"),
            Arrays.asList("biscuit-lock"),
            "Colton Wiscombe",
            "5.9.55"));
  }

  public static MdiIcon cookie_lock_outline() {
    return MdiIcon.create(
        "mdi-cookie-lock-outline",
        new MdiMeta(
            "cookie-lock-outline",
            "F16E9",
            Arrays.asList("Food / Drink", "Lock"),
            Arrays.asList("biscuit-lock-outline"),
            "Colton Wiscombe",
            "5.9.55"));
  }

  public static MdiIcon cookie_minus() {
    return MdiIcon.create(
        "mdi-cookie-minus",
        new MdiMeta(
            "cookie-minus",
            "F16DA",
            Arrays.asList("Food / Drink"),
            Arrays.asList("biscuit-minus"),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon cookie_minus_outline() {
    return MdiIcon.create(
        "mdi-cookie-minus-outline",
        new MdiMeta(
            "cookie-minus-outline",
            "F16DB",
            Arrays.asList("Food / Drink"),
            Arrays.asList("biscuit-minus-outline"),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon cookie_off() {
    return MdiIcon.create(
        "mdi-cookie-off",
        new MdiMeta(
            "cookie-off",
            "F16EA",
            Arrays.asList("Food / Drink"),
            Arrays.asList("biscuit-off"),
            "Colton Wiscombe",
            "5.9.55"));
  }

  public static MdiIcon cookie_off_outline() {
    return MdiIcon.create(
        "mdi-cookie-off-outline",
        new MdiMeta(
            "cookie-off-outline",
            "F16EB",
            Arrays.asList("Food / Drink"),
            Arrays.asList("biscuit-off-outline"),
            "Colton Wiscombe",
            "5.9.55"));
  }

  public static MdiIcon cookie_outline() {
    return MdiIcon.create(
        "mdi-cookie-outline",
        new MdiMeta(
            "cookie-outline",
            "F16DE",
            Arrays.asList("Food / Drink"),
            Arrays.asList("biscuit-outline"),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon cookie_plus() {
    return MdiIcon.create(
        "mdi-cookie-plus",
        new MdiMeta(
            "cookie-plus",
            "F16D6",
            Arrays.asList("Food / Drink"),
            Arrays.asList("biscuit-plus"),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon cookie_plus_outline() {
    return MdiIcon.create(
        "mdi-cookie-plus-outline",
        new MdiMeta(
            "cookie-plus-outline",
            "F16D7",
            Arrays.asList("Food / Drink"),
            Arrays.asList("biscuit-plus-outline"),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon cookie_refresh() {
    return MdiIcon.create(
        "mdi-cookie-refresh",
        new MdiMeta(
            "cookie-refresh",
            "F16EC",
            Arrays.asList("Food / Drink"),
            Arrays.asList("biscuit-refresh"),
            "Colton Wiscombe",
            "5.9.55"));
  }

  public static MdiIcon cookie_refresh_outline() {
    return MdiIcon.create(
        "mdi-cookie-refresh-outline",
        new MdiMeta(
            "cookie-refresh-outline",
            "F16ED",
            Arrays.asList("Food / Drink"),
            Arrays.asList("biscuit-refresh-outline"),
            "Colton Wiscombe",
            "5.9.55"));
  }

  public static MdiIcon cookie_remove() {
    return MdiIcon.create(
        "mdi-cookie-remove",
        new MdiMeta(
            "cookie-remove",
            "F16D8",
            Arrays.asList("Food / Drink"),
            Arrays.asList("biscuit-remove"),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon cookie_remove_outline() {
    return MdiIcon.create(
        "mdi-cookie-remove-outline",
        new MdiMeta(
            "cookie-remove-outline",
            "F16D9",
            Arrays.asList("Food / Drink"),
            Arrays.asList("biscuit-remove-outline"),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon cookie_settings() {
    return MdiIcon.create(
        "mdi-cookie-settings",
        new MdiMeta(
            "cookie-settings",
            "F16DC",
            Arrays.asList("Food / Drink", "Settings"),
            Arrays.asList("biscuit-settings", "cookie-crumbs", "biscuit-crumbs"),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon cookie_settings_outline() {
    return MdiIcon.create(
        "mdi-cookie-settings-outline",
        new MdiMeta(
            "cookie-settings-outline",
            "F16DD",
            Arrays.asList("Food / Drink", "Settings"),
            Arrays.asList(
                "biscuit-settings-outline", "cookie-crumbs-outline", "biscuit-crumbs-outline"),
            "Colton Wiscombe",
            "5.8.55"));
  }

  public static MdiIcon coolant_temperature() {
    return MdiIcon.create(
        "mdi-coolant-temperature",
        new MdiMeta(
            "coolant-temperature",
            "F03C8",
            Arrays.asList("Automotive"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon copyleft() {
    return MdiIcon.create(
        "mdi-copyleft",
        new MdiMeta(
            "copyleft", "F1939", Arrays.asList(), Arrays.asList(), "Michael Irigoyen", "6.4.95"));
  }

  public static MdiIcon copyright() {
    return MdiIcon.create(
        "mdi-copyright",
        new MdiMeta("copyright", "F05E6", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  @Deprecated
  public static MdiIcon cordova() {
    return MdiIcon.create(
        "mdi-cordova",
        new MdiMeta(
            "cordova",
            "F0958",
            Arrays.asList("Brand / Logo", "Developer / Languages"),
            Arrays.asList(),
            "Contributors",
            "2.4.85"));
  }

  public static MdiIcon corn() {
    return MdiIcon.create(
        "mdi-corn",
        new MdiMeta(
            "corn",
            "F07B8",
            Arrays.asList("Agriculture", "Food / Drink"),
            Arrays.asList(),
            "Thomas Hunsaker",
            "2.0.46"));
  }

  public static MdiIcon corn_off() {
    return MdiIcon.create(
        "mdi-corn-off",
        new MdiMeta(
            "corn-off",
            "F13EF",
            Arrays.asList("Food / Drink", "Agriculture"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.1.45"));
  }

  public static MdiIcon cosine_wave() {
    return MdiIcon.create(
        "mdi-cosine-wave",
        new MdiMeta(
            "cosine-wave",
            "F1479",
            Arrays.asList("Audio"),
            Arrays.asList("frequency", "amplitude"),
            "Haley Halcyon",
            "5.2.45"));
  }

  public static MdiIcon counter() {
    return MdiIcon.create(
        "mdi-counter",
        new MdiMeta(
            "counter",
            "F0199",
            Arrays.asList("Automotive"),
            Arrays.asList("score", "numbers", "odometer"),
            "Christopher Schreiner",
            "1.5.54"));
  }

  public static MdiIcon countertop() {
    return MdiIcon.create(
        "mdi-countertop",
        new MdiMeta(
            "countertop",
            "F181C",
            Arrays.asList("Home Automation"),
            Arrays.asList("kitchen-counter", "sink"),
            "Google",
            "6.1.95"));
  }

  public static MdiIcon countertop_outline() {
    return MdiIcon.create(
        "mdi-countertop-outline",
        new MdiMeta(
            "countertop-outline",
            "F181D",
            Arrays.asList("Home Automation"),
            Arrays.asList("kitchen-counter-outline", "sink-outline"),
            "Google",
            "6.1.95"));
  }

  public static MdiIcon cow() {
    return MdiIcon.create(
        "mdi-cow",
        new MdiMeta(
            "cow",
            "F019A",
            Arrays.asList("Animal", "Agriculture"),
            Arrays.asList("emoji-cow", "emoticon-cow"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon cow_off() {
    return MdiIcon.create(
        "mdi-cow-off",
        new MdiMeta(
            "cow-off",
            "F18FC",
            Arrays.asList("Food / Drink", "Agriculture", "Animal"),
            Arrays.asList("dairy-off", "dairy-free"),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon cpu_32_bit() {
    return MdiIcon.create(
        "mdi-cpu-32-bit",
        new MdiMeta(
            "cpu-32-bit",
            "F0EDF",
            Arrays.asList(),
            Arrays.asList("chip-32-bit"),
            "GreenTurtwig",
            "3.8.95"));
  }

  public static MdiIcon cpu_64_bit() {
    return MdiIcon.create(
        "mdi-cpu-64-bit",
        new MdiMeta(
            "cpu-64-bit",
            "F0EE0",
            Arrays.asList(),
            Arrays.asList("chip-64-bit"),
            "GreenTurtwig",
            "3.8.95"));
  }

  public static MdiIcon cradle() {
    return MdiIcon.create(
        "mdi-cradle",
        new MdiMeta(
            "cradle",
            "F198B",
            Arrays.asList("People / Family", "Home Automation"),
            Arrays.asList("crib", "bassinet", "baby", "nursery", "baby-room"),
            "Google",
            "6.5.95"));
  }

  public static MdiIcon cradle_outline() {
    return MdiIcon.create(
        "mdi-cradle-outline",
        new MdiMeta(
            "cradle-outline",
            "F1991",
            Arrays.asList("People / Family", "Home Automation"),
            Arrays.asList("bassinet", "crib", "baby", "nursery-outline", "baby-room-outline"),
            "Google",
            "6.5.95"));
  }

  public static MdiIcon crane() {
    return MdiIcon.create(
        "mdi-crane",
        new MdiMeta(
            "crane", "F0862", Arrays.asList(), Arrays.asList(), "Michael Irigoyen", "2.1.99"));
  }

  public static MdiIcon creation() {
    return MdiIcon.create(
        "mdi-creation",
        new MdiMeta(
            "creation",
            "F0674",
            Arrays.asList(),
            Arrays.asList("auto-awesome"),
            "Google",
            "1.7.12"));
  }

  public static MdiIcon creation_outline() {
    return MdiIcon.create(
        "mdi-creation-outline",
        new MdiMeta(
            "creation-outline",
            "F1C2B",
            Arrays.asList(),
            Arrays.asList("auto-awesome-outline"),
            "Jeff Anders",
            "7.2.96"));
  }

  @Deprecated
  public static MdiIcon creative_commons() {
    return MdiIcon.create(
        "mdi-creative-commons",
        new MdiMeta(
            "creative-commons",
            "F0D6B",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "3.4.93"));
  }

  public static MdiIcon credit_card() {
    return MdiIcon.create(
        "mdi-credit-card",
        new MdiMeta(
            "credit-card",
            "F0FEF",
            Arrays.asList("Banking", "Currency"),
            Arrays.asList(),
            "Michael Richins",
            "4.0.96"));
  }

  public static MdiIcon credit_card_check() {
    return MdiIcon.create(
        "mdi-credit-card-check",
        new MdiMeta(
            "credit-card-check",
            "F13D0",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.1.45"));
  }

  public static MdiIcon credit_card_check_outline() {
    return MdiIcon.create(
        "mdi-credit-card-check-outline",
        new MdiMeta(
            "credit-card-check-outline",
            "F13D1",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.1.45"));
  }

  public static MdiIcon credit_card_chip() {
    return MdiIcon.create(
        "mdi-credit-card-chip",
        new MdiMeta(
            "credit-card-chip",
            "F190F",
            Arrays.asList("Banking"),
            Arrays.asList("credit-card-icc-chip"),
            "Jeff Anders",
            "6.4.95"));
  }

  public static MdiIcon credit_card_chip_outline() {
    return MdiIcon.create(
        "mdi-credit-card-chip-outline",
        new MdiMeta(
            "credit-card-chip-outline",
            "F1910",
            Arrays.asList("Banking"),
            Arrays.asList("credit-card-icc-chip-outline"),
            "Jeff Anders",
            "6.4.95"));
  }

  public static MdiIcon credit_card_clock() {
    return MdiIcon.create(
        "mdi-credit-card-clock",
        new MdiMeta(
            "credit-card-clock",
            "F0EE1",
            Arrays.asList("Banking", "Date / Time"),
            Arrays.asList(),
            "Michael Richins",
            "3.8.95"));
  }

  public static MdiIcon credit_card_clock_outline() {
    return MdiIcon.create(
        "mdi-credit-card-clock-outline",
        new MdiMeta(
            "credit-card-clock-outline",
            "F0EE2",
            Arrays.asList("Banking", "Date / Time"),
            Arrays.asList(),
            "Michael Richins",
            "3.8.95"));
  }

  public static MdiIcon credit_card_edit() {
    return MdiIcon.create(
        "mdi-credit-card-edit",
        new MdiMeta(
            "credit-card-edit",
            "F17D7",
            Arrays.asList("Edit / Modify", "Banking"),
            Arrays.asList(),
            "Jeff Anders",
            "6.1.95"));
  }

  public static MdiIcon credit_card_edit_outline() {
    return MdiIcon.create(
        "mdi-credit-card-edit-outline",
        new MdiMeta(
            "credit-card-edit-outline",
            "F17D8",
            Arrays.asList("Edit / Modify", "Banking"),
            Arrays.asList(),
            "Jeff Anders",
            "6.1.95"));
  }

  public static MdiIcon credit_card_fast() {
    return MdiIcon.create(
        "mdi-credit-card-fast",
        new MdiMeta(
            "credit-card-fast",
            "F1911",
            Arrays.asList("Banking"),
            Arrays.asList("credit-card-swipe"),
            "Jeff Anders",
            "6.4.95"));
  }

  public static MdiIcon credit_card_fast_outline() {
    return MdiIcon.create(
        "mdi-credit-card-fast-outline",
        new MdiMeta(
            "credit-card-fast-outline",
            "F1912",
            Arrays.asList("Banking"),
            Arrays.asList("credit-card-swipe-outline"),
            "Jeff Anders",
            "6.4.95"));
  }

  public static MdiIcon credit_card_lock() {
    return MdiIcon.create(
        "mdi-credit-card-lock",
        new MdiMeta(
            "credit-card-lock",
            "F18E7",
            Arrays.asList("Banking", "Lock"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.3.95"));
  }

  public static MdiIcon credit_card_lock_outline() {
    return MdiIcon.create(
        "mdi-credit-card-lock-outline",
        new MdiMeta(
            "credit-card-lock-outline",
            "F18E8",
            Arrays.asList("Banking", "Lock"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.3.95"));
  }

  public static MdiIcon credit_card_marker() {
    return MdiIcon.create(
        "mdi-credit-card-marker",
        new MdiMeta(
            "credit-card-marker",
            "F06A8",
            Arrays.asList("Banking", "Navigation"),
            Arrays.asList("credit-card-location", "payment-on-delivery"),
            "Michael Irigoyen",
            "1.7.12"));
  }

  public static MdiIcon credit_card_marker_outline() {
    return MdiIcon.create(
        "mdi-credit-card-marker-outline",
        new MdiMeta(
            "credit-card-marker-outline",
            "F0DBE",
            Arrays.asList("Banking", "Navigation"),
            Arrays.asList("cod", "payment-on-delivery-outline", "credit-card-location-outline"),
            "Michael Irigoyen",
            "3.5.94"));
  }

  public static MdiIcon credit_card_minus() {
    return MdiIcon.create(
        "mdi-credit-card-minus",
        new MdiMeta(
            "credit-card-minus",
            "F0FAC",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Michael Richins",
            "4.0.96"));
  }

  public static MdiIcon credit_card_minus_outline() {
    return MdiIcon.create(
        "mdi-credit-card-minus-outline",
        new MdiMeta(
            "credit-card-minus-outline",
            "F0FAD",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Michael Richins",
            "4.0.96"));
  }

  public static MdiIcon credit_card_multiple() {
    return MdiIcon.create(
        "mdi-credit-card-multiple",
        new MdiMeta(
            "credit-card-multiple",
            "F0FF0",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Michael Richins",
            "4.0.96"));
  }

  public static MdiIcon credit_card_multiple_outline() {
    return MdiIcon.create(
        "mdi-credit-card-multiple-outline",
        new MdiMeta(
            "credit-card-multiple-outline",
            "F019C",
            Arrays.asList("Banking"),
            Arrays.asList("credit-cards"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon credit_card_off() {
    return MdiIcon.create(
        "mdi-credit-card-off",
        new MdiMeta(
            "credit-card-off",
            "F0FF1",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Michael Richins",
            "4.0.96"));
  }

  public static MdiIcon credit_card_off_outline() {
    return MdiIcon.create(
        "mdi-credit-card-off-outline",
        new MdiMeta(
            "credit-card-off-outline",
            "F05E4",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon credit_card_outline() {
    return MdiIcon.create(
        "mdi-credit-card-outline",
        new MdiMeta(
            "credit-card-outline",
            "F019B",
            Arrays.asList("Shopping", "Banking", "Currency"),
            Arrays.asList("payment"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon credit_card_plus() {
    return MdiIcon.create(
        "mdi-credit-card-plus",
        new MdiMeta(
            "credit-card-plus",
            "F0FF2",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Michael Richins",
            "4.0.96"));
  }

  public static MdiIcon credit_card_plus_outline() {
    return MdiIcon.create(
        "mdi-credit-card-plus-outline",
        new MdiMeta(
            "credit-card-plus-outline",
            "F0676",
            Arrays.asList("Banking"),
            Arrays.asList("credit-card-add"),
            "Austin Andrews",
            "1.7.12"));
  }

  public static MdiIcon credit_card_refresh() {
    return MdiIcon.create(
        "mdi-credit-card-refresh",
        new MdiMeta(
            "credit-card-refresh",
            "F1645",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon credit_card_refresh_outline() {
    return MdiIcon.create(
        "mdi-credit-card-refresh-outline",
        new MdiMeta(
            "credit-card-refresh-outline",
            "F1646",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon credit_card_refund() {
    return MdiIcon.create(
        "mdi-credit-card-refund",
        new MdiMeta(
            "credit-card-refund",
            "F0FF3",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Michael Richins",
            "4.0.96"));
  }

  public static MdiIcon credit_card_refund_outline() {
    return MdiIcon.create(
        "mdi-credit-card-refund-outline",
        new MdiMeta(
            "credit-card-refund-outline",
            "F0AA8",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Michael Richins",
            "2.7.94"));
  }

  public static MdiIcon credit_card_remove() {
    return MdiIcon.create(
        "mdi-credit-card-remove",
        new MdiMeta(
            "credit-card-remove",
            "F0FAE",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Michael Richins",
            "4.0.96"));
  }

  public static MdiIcon credit_card_remove_outline() {
    return MdiIcon.create(
        "mdi-credit-card-remove-outline",
        new MdiMeta(
            "credit-card-remove-outline",
            "F0FAF",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Michael Richins",
            "4.0.96"));
  }

  public static MdiIcon credit_card_scan() {
    return MdiIcon.create(
        "mdi-credit-card-scan",
        new MdiMeta(
            "credit-card-scan",
            "F0FF4",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Michael Richins",
            "4.0.96"));
  }

  public static MdiIcon credit_card_scan_outline() {
    return MdiIcon.create(
        "mdi-credit-card-scan-outline",
        new MdiMeta(
            "credit-card-scan-outline",
            "F019D",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon credit_card_search() {
    return MdiIcon.create(
        "mdi-credit-card-search",
        new MdiMeta(
            "credit-card-search",
            "F1647",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon credit_card_search_outline() {
    return MdiIcon.create(
        "mdi-credit-card-search-outline",
        new MdiMeta(
            "credit-card-search-outline",
            "F1648",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon credit_card_settings() {
    return MdiIcon.create(
        "mdi-credit-card-settings",
        new MdiMeta(
            "credit-card-settings",
            "F0FF5",
            Arrays.asList("Banking", "Settings"),
            Arrays.asList(),
            "Michael Richins",
            "4.0.96"));
  }

  public static MdiIcon credit_card_settings_outline() {
    return MdiIcon.create(
        "mdi-credit-card-settings-outline",
        new MdiMeta(
            "credit-card-settings-outline",
            "F08D7",
            Arrays.asList("Banking", "Settings"),
            Arrays.asList("payment-settings"),
            "Peter Noble",
            "2.3.50"));
  }

  public static MdiIcon credit_card_sync() {
    return MdiIcon.create(
        "mdi-credit-card-sync",
        new MdiMeta(
            "credit-card-sync",
            "F1649",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon credit_card_sync_outline() {
    return MdiIcon.create(
        "mdi-credit-card-sync-outline",
        new MdiMeta(
            "credit-card-sync-outline",
            "F164A",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon credit_card_wireless() {
    return MdiIcon.create(
        "mdi-credit-card-wireless",
        new MdiMeta(
            "credit-card-wireless",
            "F0802",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.1.19"));
  }

  public static MdiIcon credit_card_wireless_off() {
    return MdiIcon.create(
        "mdi-credit-card-wireless-off",
        new MdiMeta(
            "credit-card-wireless-off",
            "F057A",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon credit_card_wireless_off_outline() {
    return MdiIcon.create(
        "mdi-credit-card-wireless-off-outline",
        new MdiMeta(
            "credit-card-wireless-off-outline",
            "F057B",
            Arrays.asList("Banking"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon credit_card_wireless_outline() {
    return MdiIcon.create(
        "mdi-credit-card-wireless-outline",
        new MdiMeta(
            "credit-card-wireless-outline",
            "F0D6C",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList("credit-card-contactless"),
            "Michael Richins",
            "3.4.93"));
  }

  public static MdiIcon cricket() {
    return MdiIcon.create(
        "mdi-cricket",
        new MdiMeta(
            "cricket",
            "F0D6D",
            Arrays.asList("Sport"),
            Arrays.asList("cricket-bat"),
            "Google",
            "3.4.93"));
  }

  public static MdiIcon crop() {
    return MdiIcon.create(
        "mdi-crop",
        new MdiMeta("crop", "F019E", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon crop_free() {
    return MdiIcon.create(
        "mdi-crop-free",
        new MdiMeta("crop-free", "F019F", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon crop_landscape() {
    return MdiIcon.create(
        "mdi-crop-landscape",
        new MdiMeta(
            "crop-landscape",
            "F01A0",
            Arrays.asList(),
            Arrays.asList("crop-5-4"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon crop_portrait() {
    return MdiIcon.create(
        "mdi-crop-portrait",
        new MdiMeta(
            "crop-portrait", "F01A1", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon crop_rotate() {
    return MdiIcon.create(
        "mdi-crop-rotate",
        new MdiMeta("crop-rotate", "F0696", Arrays.asList(), Arrays.asList(), "Google", "1.7.12"));
  }

  public static MdiIcon crop_square() {
    return MdiIcon.create(
        "mdi-crop-square",
        new MdiMeta("crop-square", "F01A2", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon cross() {
    return MdiIcon.create(
        "mdi-cross",
        new MdiMeta(
            "cross",
            "F0953",
            Arrays.asList("Religion", "Holiday"),
            Arrays.asList("christianity", "religion-christian"),
            "Nick",
            "2.4.85"));
  }

  public static MdiIcon cross_bolnisi() {
    return MdiIcon.create(
        "mdi-cross-bolnisi",
        new MdiMeta(
            "cross-bolnisi",
            "F0CED",
            Arrays.asList("Religion"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.3.92"));
  }

  public static MdiIcon cross_celtic() {
    return MdiIcon.create(
        "mdi-cross-celtic",
        new MdiMeta(
            "cross-celtic",
            "F0CF5",
            Arrays.asList("Religion", "Holiday"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.3.92"));
  }

  public static MdiIcon cross_outline() {
    return MdiIcon.create(
        "mdi-cross-outline",
        new MdiMeta(
            "cross-outline",
            "F0CF6",
            Arrays.asList("Religion"),
            Arrays.asList("religion-christian-outline", "christianity-outline"),
            "Michael Irigoyen",
            "3.3.92"));
  }

  public static MdiIcon crosshairs() {
    return MdiIcon.create(
        "mdi-crosshairs",
        new MdiMeta(
            "crosshairs",
            "F01A3",
            Arrays.asList("Geographic Information System"),
            Arrays.asList("gps-not-fixed", "location-searching"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon crosshairs_gps() {
    return MdiIcon.create(
        "mdi-crosshairs-gps",
        new MdiMeta(
            "crosshairs-gps",
            "F01A4",
            Arrays.asList("Navigation", "Geographic Information System"),
            Arrays.asList("gps-fixed", "my-location"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon crosshairs_off() {
    return MdiIcon.create(
        "mdi-crosshairs-off",
        new MdiMeta(
            "crosshairs-off",
            "F0F45",
            Arrays.asList("Geographic Information System"),
            Arrays.asList(),
            "Google",
            "3.9.97"));
  }

  public static MdiIcon crosshairs_question() {
    return MdiIcon.create(
        "mdi-crosshairs-question",
        new MdiMeta(
            "crosshairs-question",
            "F1136",
            Arrays.asList("Navigation", "Geographic Information System"),
            Arrays.asList("crosshairs-unknown", "gps-unknown"),
            "Google",
            "4.4.95"));
  }

  public static MdiIcon crowd() {
    return MdiIcon.create(
        "mdi-crowd",
        new MdiMeta(
            "crowd",
            "F1975",
            Arrays.asList("Account / User", "People / Family"),
            Arrays.asList("family", "crowd-source", "crowdsource"),
            "Google",
            "6.5.95"));
  }

  public static MdiIcon crown() {
    return MdiIcon.create(
        "mdi-crown",
        new MdiMeta(
            "crown", "F01A5", Arrays.asList(), Arrays.asList(), "Austin Andrews", "1.5.54"));
  }

  public static MdiIcon crown_circle() {
    return MdiIcon.create(
        "mdi-crown-circle",
        new MdiMeta(
            "crown-circle",
            "F17DC",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("checkers"),
            "Michael Irigoyen",
            "6.1.95"));
  }

  public static MdiIcon crown_circle_outline() {
    return MdiIcon.create(
        "mdi-crown-circle-outline",
        new MdiMeta(
            "crown-circle-outline",
            "F17DD",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("checkers-outline"),
            "Michael Irigoyen",
            "6.1.95"));
  }

  public static MdiIcon crown_outline() {
    return MdiIcon.create(
        "mdi-crown-outline",
        new MdiMeta(
            "crown-outline", "F11D0", Arrays.asList(), Arrays.asList(), "frankgrinaert", "4.5.95"));
  }

  @Deprecated
  public static MdiIcon cryengine() {
    return MdiIcon.create(
        "mdi-cryengine",
        new MdiMeta(
            "cryengine",
            "F0959",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "2.4.85"));
  }

  public static MdiIcon crystal_ball() {
    return MdiIcon.create(
        "mdi-crystal-ball",
        new MdiMeta(
            "crystal-ball",
            "F0B2F",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "Austin Andrews",
            "2.8.94"));
  }

  public static MdiIcon cube() {
    return MdiIcon.create(
        "mdi-cube",
        new MdiMeta(
            "cube", "F01A6", Arrays.asList("Shape"), Arrays.asList(), "Austin Andrews", "1.5.54"));
  }

  public static MdiIcon cube_off() {
    return MdiIcon.create(
        "mdi-cube-off",
        new MdiMeta(
            "cube-off", "F141C", Arrays.asList(), Arrays.asList(), "Michael Irigoyen", "5.2.45"));
  }

  public static MdiIcon cube_off_outline() {
    return MdiIcon.create(
        "mdi-cube-off-outline",
        new MdiMeta(
            "cube-off-outline",
            "F141D",
            Arrays.asList("Food / Drink"),
            Arrays.asList("sugar-off", "sugar-cube-off", "sugar-free"),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon cube_outline() {
    return MdiIcon.create(
        "mdi-cube-outline",
        new MdiMeta(
            "cube-outline",
            "F01A7",
            Arrays.asList("Shape", "Food / Drink"),
            Arrays.asList("sugar", "sugar-cube"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon cube_scan() {
    return MdiIcon.create(
        "mdi-cube-scan",
        new MdiMeta(
            "cube-scan",
            "F0B84",
            Arrays.asList(),
            Arrays.asList("view-in-ar", "view-in-augmented-reality"),
            "Google",
            "3.0.39"));
  }

  public static MdiIcon cube_send() {
    return MdiIcon.create(
        "mdi-cube-send",
        new MdiMeta("cube-send", "F01A8", Arrays.asList(), Arrays.asList(), "Simran", "1.5.54"));
  }

  public static MdiIcon cube_unfolded() {
    return MdiIcon.create(
        "mdi-cube-unfolded",
        new MdiMeta(
            "cube-unfolded",
            "F01A9",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon cup() {
    return MdiIcon.create(
        "mdi-cup",
        new MdiMeta(
            "cup",
            "F01AA",
            Arrays.asList("Food / Drink"),
            Arrays.asList("glass", "drink"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon cup_off() {
    return MdiIcon.create(
        "mdi-cup-off",
        new MdiMeta(
            "cup-off",
            "F05E5",
            Arrays.asList("Food / Drink"),
            Arrays.asList("glass-off", "drink-off"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon cup_off_outline() {
    return MdiIcon.create(
        "mdi-cup-off-outline",
        new MdiMeta(
            "cup-off-outline",
            "F137D",
            Arrays.asList("Food / Drink"),
            Arrays.asList("glass-off-outline", "drink-off-outline"),
            "Simran",
            "4.9.95"));
  }

  public static MdiIcon cup_outline() {
    return MdiIcon.create(
        "mdi-cup-outline",
        new MdiMeta(
            "cup-outline",
            "F130F",
            Arrays.asList("Food / Drink"),
            Arrays.asList("glass-outline", "drink-outline", "cup-empty"),
            "Simran",
            "4.8.95"));
  }

  public static MdiIcon cup_water() {
    return MdiIcon.create(
        "mdi-cup-water",
        new MdiMeta(
            "cup-water",
            "F01AB",
            Arrays.asList("Food / Drink"),
            Arrays.asList(
                "local-drink", "glass-water", "drink-water", "cup-liquid", "glass-liquid"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon cupboard() {
    return MdiIcon.create(
        "mdi-cupboard",
        new MdiMeta(
            "cupboard",
            "F0F46",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "GreenTurtwig",
            "3.9.97"));
  }

  public static MdiIcon cupboard_outline() {
    return MdiIcon.create(
        "mdi-cupboard-outline",
        new MdiMeta(
            "cupboard-outline",
            "F0F47",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "GreenTurtwig",
            "3.9.97"));
  }

  public static MdiIcon cupcake() {
    return MdiIcon.create(
        "mdi-cupcake",
        new MdiMeta(
            "cupcake", "F095A", Arrays.asList("Food / Drink"), Arrays.asList(), "Nick", "2.4.85"));
  }

  public static MdiIcon curling() {
    return MdiIcon.create(
        "mdi-curling",
        new MdiMeta("curling", "F0863", Arrays.asList("Sport"), Arrays.asList(), "Nick", "2.1.99"));
  }

  public static MdiIcon currency_bdt() {
    return MdiIcon.create(
        "mdi-currency-bdt",
        new MdiMeta(
            "currency-bdt",
            "F0864",
            Arrays.asList("Banking", "Currency"),
            Arrays.asList("taka", "bangladeshi-taka"),
            "Michael Richins",
            "2.1.99"));
  }

  public static MdiIcon currency_brl() {
    return MdiIcon.create(
        "mdi-currency-brl",
        new MdiMeta(
            "currency-brl",
            "F0B85",
            Arrays.asList("Banking", "Currency"),
            Arrays.asList("brazilian-real"),
            "Austin Andrews",
            "3.0.39"));
  }

  public static MdiIcon currency_btc() {
    return MdiIcon.create(
        "mdi-currency-btc",
        new MdiMeta(
            "currency-btc",
            "F01AC",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList("bitcoin"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon currency_cny() {
    return MdiIcon.create(
        "mdi-currency-cny",
        new MdiMeta(
            "currency-cny",
            "F07BA",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList("yuan", "renminbi"),
            "Google",
            "2.0.46"));
  }

  public static MdiIcon currency_eth() {
    return MdiIcon.create(
        "mdi-currency-eth",
        new MdiMeta(
            "currency-eth",
            "F07BB",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList("ethereum", "xi"),
            "Peter Noble",
            "2.0.46"));
  }

  public static MdiIcon currency_eur() {
    return MdiIcon.create(
        "mdi-currency-eur",
        new MdiMeta(
            "currency-eur",
            "F01AD",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList("euro", "euro-symbol"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon currency_eur_off() {
    return MdiIcon.create(
        "mdi-currency-eur-off",
        new MdiMeta(
            "currency-eur-off",
            "F1315",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.8.95"));
  }

  public static MdiIcon currency_fra() {
    return MdiIcon.create(
        "mdi-currency-fra",
        new MdiMeta(
            "currency-fra",
            "F1A39",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList(),
            "Google",
            "6.7.96"));
  }

  public static MdiIcon currency_gbp() {
    return MdiIcon.create(
        "mdi-currency-gbp",
        new MdiMeta(
            "currency-gbp",
            "F01AE",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList("pound", "sterling"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon currency_ils() {
    return MdiIcon.create(
        "mdi-currency-ils",
        new MdiMeta(
            "currency-ils",
            "F0C61",
            Arrays.asList("Banking", "Currency"),
            Arrays.asList(),
            "Austin Andrews",
            "3.2.89"));
  }

  public static MdiIcon currency_inr() {
    return MdiIcon.create(
        "mdi-currency-inr",
        new MdiMeta(
            "currency-inr",
            "F01AF",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList("rupee"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon currency_jpy() {
    return MdiIcon.create(
        "mdi-currency-jpy",
        new MdiMeta(
            "currency-jpy",
            "F07BC",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList("yen"),
            "Google",
            "2.0.46"));
  }

  public static MdiIcon currency_krw() {
    return MdiIcon.create(
        "mdi-currency-krw",
        new MdiMeta(
            "currency-krw",
            "F07BD",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList("won"),
            "Haley Halcyon",
            "2.0.46"));
  }

  public static MdiIcon currency_kzt() {
    return MdiIcon.create(
        "mdi-currency-kzt",
        new MdiMeta(
            "currency-kzt",
            "F0865",
            Arrays.asList("Banking", "Currency"),
            Arrays.asList("kazakhstani-tenge"),
            "Augustin Ursu",
            "2.1.99"));
  }

  public static MdiIcon currency_mnt() {
    return MdiIcon.create(
        "mdi-currency-mnt",
        new MdiMeta(
            "currency-mnt",
            "F1512",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList("currency-mongolian-tugrug"),
            "Colton Wiscombe",
            "5.4.55"));
  }

  public static MdiIcon currency_ngn() {
    return MdiIcon.create(
        "mdi-currency-ngn",
        new MdiMeta(
            "currency-ngn",
            "F01B0",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList("naira"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon currency_php() {
    return MdiIcon.create(
        "mdi-currency-php",
        new MdiMeta(
            "currency-php",
            "F09E6",
            Arrays.asList("Banking", "Currency"),
            Arrays.asList("philippine-peso"),
            "Michael Richins",
            "2.5.94"));
  }

  public static MdiIcon currency_rial() {
    return MdiIcon.create(
        "mdi-currency-rial",
        new MdiMeta(
            "currency-rial",
            "F0E9C",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList(
                "currency-riyal", "currency-irr", "currency-omr", "currency-yer", "currency-sar"),
            "Haley Halcyon",
            "3.7.94"));
  }

  public static MdiIcon currency_rub() {
    return MdiIcon.create(
        "mdi-currency-rub",
        new MdiMeta(
            "currency-rub",
            "F01B1",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList("ruble"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon currency_rupee() {
    return MdiIcon.create(
        "mdi-currency-rupee",
        new MdiMeta(
            "currency-rupee",
            "F1976",
            Arrays.asList("Banking", "Currency"),
            Arrays.asList("currency-npr", "currency-pkr", "currency-lkr", "currency-inr"),
            "Google",
            "6.5.95"));
  }

  public static MdiIcon currency_sign() {
    return MdiIcon.create(
        "mdi-currency-sign",
        new MdiMeta(
            "currency-sign",
            "F07BE",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList("currency-scarab"),
            "Michael Richins",
            "2.0.46"));
  }

  public static MdiIcon currency_thb() {
    return MdiIcon.create(
        "mdi-currency-thb",
        new MdiMeta(
            "currency-thb",
            "F1C05",
            Arrays.asList("Banking"),
            Arrays.asList("currency-thai-baht"),
            "Michael Irigoyen",
            "7.1.96"));
  }

  public static MdiIcon currency_try() {
    return MdiIcon.create(
        "mdi-currency-try",
        new MdiMeta(
            "currency-try",
            "F01B2",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList("lira"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon currency_twd() {
    return MdiIcon.create(
        "mdi-currency-twd",
        new MdiMeta(
            "currency-twd",
            "F07BF",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList("new-taiwan-dollar"),
            "Haley Halcyon",
            "2.0.46"));
  }

  public static MdiIcon currency_uah() {
    return MdiIcon.create(
        "mdi-currency-uah",
        new MdiMeta(
            "currency-uah",
            "F1B9B",
            Arrays.asList("Banking"),
            Arrays.asList("currency-hryvnia", "currency-ukraine"),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon currency_usd() {
    return MdiIcon.create(
        "mdi-currency-usd",
        new MdiMeta(
            "currency-usd",
            "F01C1",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList("attach-money", "dollar"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon currency_usd_off() {
    return MdiIcon.create(
        "mdi-currency-usd-off",
        new MdiMeta(
            "currency-usd-off",
            "F067A",
            Arrays.asList("Currency", "Banking"),
            Arrays.asList("money-off", "dollar-off"),
            "Google",
            "1.7.12"));
  }

  public static MdiIcon current_ac() {
    return MdiIcon.create(
        "mdi-current-ac",
        new MdiMeta(
            "current-ac",
            "F1480",
            Arrays.asList(),
            Arrays.asList("alternating-current"),
            "Michael Irigoyen",
            "5.3.45"));
  }

  public static MdiIcon current_dc() {
    return MdiIcon.create(
        "mdi-current-dc",
        new MdiMeta(
            "current-dc",
            "F095C",
            Arrays.asList("Battery"),
            Arrays.asList("direct-current"),
            "Nick",
            "2.4.85"));
  }

  public static MdiIcon cursor_default() {
    return MdiIcon.create(
        "mdi-cursor-default",
        new MdiMeta(
            "cursor-default",
            "F01C0",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon cursor_default_click() {
    return MdiIcon.create(
        "mdi-cursor-default-click",
        new MdiMeta(
            "cursor-default-click",
            "F0CFD",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.3.92"));
  }

  public static MdiIcon cursor_default_click_outline() {
    return MdiIcon.create(
        "mdi-cursor-default-click-outline",
        new MdiMeta(
            "cursor-default-click-outline",
            "F0CFE",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.3.92"));
  }

  public static MdiIcon cursor_default_gesture() {
    return MdiIcon.create(
        "mdi-cursor-default-gesture",
        new MdiMeta(
            "cursor-default-gesture",
            "F1127",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.3.95"));
  }

  public static MdiIcon cursor_default_gesture_outline() {
    return MdiIcon.create(
        "mdi-cursor-default-gesture-outline",
        new MdiMeta(
            "cursor-default-gesture-outline",
            "F1128",
            Arrays.asList(),
            Arrays.asList(),
            "mchvn",
            "4.3.95"));
  }

  public static MdiIcon cursor_default_outline() {
    return MdiIcon.create(
        "mdi-cursor-default-outline",
        new MdiMeta(
            "cursor-default-outline",
            "F01BF",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon cursor_move() {
    return MdiIcon.create(
        "mdi-cursor-move",
        new MdiMeta(
            "cursor-move", "F01BE", Arrays.asList(), Arrays.asList(), "Austin Andrews", "1.5.54"));
  }

  public static MdiIcon cursor_pointer() {
    return MdiIcon.create(
        "mdi-cursor-pointer",
        new MdiMeta(
            "cursor-pointer",
            "F01BD",
            Arrays.asList(),
            Arrays.asList("cursor-hand"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon cursor_text() {
    return MdiIcon.create(
        "mdi-cursor-text",
        new MdiMeta(
            "cursor-text", "F05E7", Arrays.asList(), Arrays.asList(), "Austin Andrews", "1.5.54"));
  }

  public static MdiIcon curtains() {
    return MdiIcon.create(
        "mdi-curtains",
        new MdiMeta(
            "curtains",
            "F1846",
            Arrays.asList("Home Automation"),
            Arrays.asList("drapes", "window"),
            "Teodor Sandu",
            "6.2.95"));
  }

  public static MdiIcon curtains_closed() {
    return MdiIcon.create(
        "mdi-curtains-closed",
        new MdiMeta(
            "curtains-closed",
            "F1847",
            Arrays.asList("Home Automation"),
            Arrays.asList("drapes-closed", "window-closed"),
            "Teodor Sandu",
            "6.2.95"));
  }

  public static MdiIcon cylinder() {
    return MdiIcon.create(
        "mdi-cylinder",
        new MdiMeta(
            "cylinder",
            "F194E",
            Arrays.asList("Shape"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.4.95"));
  }

  public static MdiIcon cylinder_off() {
    return MdiIcon.create(
        "mdi-cylinder-off",
        new MdiMeta(
            "cylinder-off",
            "F194F",
            Arrays.asList("Shape"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.4.95"));
  }

  public static MdiIcon dance_ballroom() {
    return MdiIcon.create(
        "mdi-dance-ballroom",
        new MdiMeta(
            "dance-ballroom",
            "F15FB",
            Arrays.asList("People / Family"),
            Arrays.asList("human-dance-ballroom"),
            "Michael Irigoyen",
            "5.6.55"));
  }

  public static MdiIcon dance_pole() {
    return MdiIcon.create(
        "mdi-dance-pole",
        new MdiMeta(
            "dance-pole",
            "F1578",
            Arrays.asList("Sport", "People / Family"),
            Arrays.asList("kho-kho", "human-dance-pole"),
            "Haley Halcyon",
            "5.5.55"));
  }

  public static MdiIcon data_matrix() {
    return MdiIcon.create(
        "mdi-data-matrix",
        new MdiMeta(
            "data-matrix", "F153C", Arrays.asList(), Arrays.asList(), "David Koníř", "5.4.55"));
  }

  public static MdiIcon data_matrix_edit() {
    return MdiIcon.create(
        "mdi-data-matrix-edit",
        new MdiMeta(
            "data-matrix-edit",
            "F153D",
            Arrays.asList("Edit / Modify"),
            Arrays.asList(),
            "David Koníř",
            "5.4.55"));
  }

  public static MdiIcon data_matrix_minus() {
    return MdiIcon.create(
        "mdi-data-matrix-minus",
        new MdiMeta(
            "data-matrix-minus",
            "F153E",
            Arrays.asList(),
            Arrays.asList(),
            "David Koníř",
            "5.4.55"));
  }

  public static MdiIcon data_matrix_plus() {
    return MdiIcon.create(
        "mdi-data-matrix-plus",
        new MdiMeta(
            "data-matrix-plus",
            "F153F",
            Arrays.asList(),
            Arrays.asList(),
            "David Koníř",
            "5.4.55"));
  }

  public static MdiIcon data_matrix_remove() {
    return MdiIcon.create(
        "mdi-data-matrix-remove",
        new MdiMeta(
            "data-matrix-remove",
            "F1540",
            Arrays.asList(),
            Arrays.asList(),
            "David Koníř",
            "5.4.55"));
  }

  public static MdiIcon data_matrix_scan() {
    return MdiIcon.create(
        "mdi-data-matrix-scan",
        new MdiMeta(
            "data-matrix-scan",
            "F1541",
            Arrays.asList(),
            Arrays.asList(),
            "David Koníř",
            "5.4.55"));
  }

  public static MdiIcon database() {
    return MdiIcon.create(
        "mdi-database",
        new MdiMeta(
            "database",
            "F01BC",
            Arrays.asList("Geographic Information System", "Database"),
            Arrays.asList("storage"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon database_alert() {
    return MdiIcon.create(
        "mdi-database-alert",
        new MdiMeta(
            "database-alert",
            "F163A",
            Arrays.asList("Database", "Alert / Error"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_alert_outline() {
    return MdiIcon.create(
        "mdi-database-alert-outline",
        new MdiMeta(
            "database-alert-outline",
            "F1624",
            Arrays.asList("Database", "Alert / Error"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_arrow_down() {
    return MdiIcon.create(
        "mdi-database-arrow-down",
        new MdiMeta(
            "database-arrow-down",
            "F163B",
            Arrays.asList("Database"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_arrow_down_outline() {
    return MdiIcon.create(
        "mdi-database-arrow-down-outline",
        new MdiMeta(
            "database-arrow-down-outline",
            "F1625",
            Arrays.asList("Database"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_arrow_left() {
    return MdiIcon.create(
        "mdi-database-arrow-left",
        new MdiMeta(
            "database-arrow-left",
            "F163C",
            Arrays.asList("Database"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_arrow_left_outline() {
    return MdiIcon.create(
        "mdi-database-arrow-left-outline",
        new MdiMeta(
            "database-arrow-left-outline",
            "F1626",
            Arrays.asList("Database"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_arrow_right() {
    return MdiIcon.create(
        "mdi-database-arrow-right",
        new MdiMeta(
            "database-arrow-right",
            "F163D",
            Arrays.asList("Database"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_arrow_right_outline() {
    return MdiIcon.create(
        "mdi-database-arrow-right-outline",
        new MdiMeta(
            "database-arrow-right-outline",
            "F1627",
            Arrays.asList("Database"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_arrow_up() {
    return MdiIcon.create(
        "mdi-database-arrow-up",
        new MdiMeta(
            "database-arrow-up",
            "F163E",
            Arrays.asList("Database"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_arrow_up_outline() {
    return MdiIcon.create(
        "mdi-database-arrow-up-outline",
        new MdiMeta(
            "database-arrow-up-outline",
            "F1628",
            Arrays.asList("Database"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_check() {
    return MdiIcon.create(
        "mdi-database-check",
        new MdiMeta(
            "database-check",
            "F0AA9",
            Arrays.asList("Geographic Information System", "Database"),
            Arrays.asList("database-tick"),
            "Andrew Nenakhov",
            "2.7.94"));
  }

  public static MdiIcon database_check_outline() {
    return MdiIcon.create(
        "mdi-database-check-outline",
        new MdiMeta(
            "database-check-outline",
            "F1629",
            Arrays.asList("Database"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_clock() {
    return MdiIcon.create(
        "mdi-database-clock",
        new MdiMeta(
            "database-clock",
            "F163F",
            Arrays.asList("Database", "Date / Time"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_clock_outline() {
    return MdiIcon.create(
        "mdi-database-clock-outline",
        new MdiMeta(
            "database-clock-outline",
            "F162A",
            Arrays.asList("Database", "Date / Time"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_cog() {
    return MdiIcon.create(
        "mdi-database-cog",
        new MdiMeta(
            "database-cog",
            "F164B",
            Arrays.asList("Database", "Settings"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_cog_outline() {
    return MdiIcon.create(
        "mdi-database-cog-outline",
        new MdiMeta(
            "database-cog-outline",
            "F164C",
            Arrays.asList("Database", "Settings"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_edit() {
    return MdiIcon.create(
        "mdi-database-edit",
        new MdiMeta(
            "database-edit",
            "F0B86",
            Arrays.asList("Edit / Modify", "Geographic Information System", "Database"),
            Arrays.asList(),
            "Michael Richins",
            "3.0.39"));
  }

  public static MdiIcon database_edit_outline() {
    return MdiIcon.create(
        "mdi-database-edit-outline",
        new MdiMeta(
            "database-edit-outline",
            "F162B",
            Arrays.asList("Database", "Edit / Modify"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_export() {
    return MdiIcon.create(
        "mdi-database-export",
        new MdiMeta(
            "database-export",
            "F095E",
            Arrays.asList("Geographic Information System", "Database"),
            Arrays.asList(),
            "Michael Richins",
            "2.4.85"));
  }

  public static MdiIcon database_export_outline() {
    return MdiIcon.create(
        "mdi-database-export-outline",
        new MdiMeta(
            "database-export-outline",
            "F162C",
            Arrays.asList("Database"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_eye() {
    return MdiIcon.create(
        "mdi-database-eye",
        new MdiMeta(
            "database-eye",
            "F191F",
            Arrays.asList("Database"),
            Arrays.asList("database-view"),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon database_eye_off() {
    return MdiIcon.create(
        "mdi-database-eye-off",
        new MdiMeta(
            "database-eye-off",
            "F1920",
            Arrays.asList("Database"),
            Arrays.asList("database-view-off"),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon database_eye_off_outline() {
    return MdiIcon.create(
        "mdi-database-eye-off-outline",
        new MdiMeta(
            "database-eye-off-outline",
            "F1921",
            Arrays.asList("Database"),
            Arrays.asList("database-view-off-outline"),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon database_eye_outline() {
    return MdiIcon.create(
        "mdi-database-eye-outline",
        new MdiMeta(
            "database-eye-outline",
            "F1922",
            Arrays.asList("Database"),
            Arrays.asList("database-view-outline"),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon database_import() {
    return MdiIcon.create(
        "mdi-database-import",
        new MdiMeta(
            "database-import",
            "F095D",
            Arrays.asList("Geographic Information System", "Database"),
            Arrays.asList(),
            "Michael Richins",
            "2.4.85"));
  }

  public static MdiIcon database_import_outline() {
    return MdiIcon.create(
        "mdi-database-import-outline",
        new MdiMeta(
            "database-import-outline",
            "F162D",
            Arrays.asList("Database"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_lock() {
    return MdiIcon.create(
        "mdi-database-lock",
        new MdiMeta(
            "database-lock",
            "F0AAA",
            Arrays.asList("Lock", "Geographic Information System", "Database"),
            Arrays.asList(),
            "Andrew Nenakhov",
            "2.7.94"));
  }

  public static MdiIcon database_lock_outline() {
    return MdiIcon.create(
        "mdi-database-lock-outline",
        new MdiMeta(
            "database-lock-outline",
            "F162E",
            Arrays.asList("Database", "Lock"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_marker() {
    return MdiIcon.create(
        "mdi-database-marker",
        new MdiMeta(
            "database-marker",
            "F12F6",
            Arrays.asList("Geographic Information System", "Database", "Navigation"),
            Arrays.asList("database-location"),
            "Michael Irigoyen",
            "4.8.95"));
  }

  public static MdiIcon database_marker_outline() {
    return MdiIcon.create(
        "mdi-database-marker-outline",
        new MdiMeta(
            "database-marker-outline",
            "F162F",
            Arrays.asList("Database", "Navigation"),
            Arrays.asList("database-location-outline"),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_minus() {
    return MdiIcon.create(
        "mdi-database-minus",
        new MdiMeta(
            "database-minus",
            "F01BB",
            Arrays.asList("Geographic Information System", "Database"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon database_minus_outline() {
    return MdiIcon.create(
        "mdi-database-minus-outline",
        new MdiMeta(
            "database-minus-outline",
            "F1630",
            Arrays.asList("Database"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_off() {
    return MdiIcon.create(
        "mdi-database-off",
        new MdiMeta(
            "database-off",
            "F1640",
            Arrays.asList("Database"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_off_outline() {
    return MdiIcon.create(
        "mdi-database-off-outline",
        new MdiMeta(
            "database-off-outline",
            "F1631",
            Arrays.asList("Database"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_outline() {
    return MdiIcon.create(
        "mdi-database-outline",
        new MdiMeta(
            "database-outline",
            "F1632",
            Arrays.asList("Database"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_plus() {
    return MdiIcon.create(
        "mdi-database-plus",
        new MdiMeta(
            "database-plus",
            "F01BA",
            Arrays.asList("Geographic Information System", "Database"),
            Arrays.asList("database-add"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon database_plus_outline() {
    return MdiIcon.create(
        "mdi-database-plus-outline",
        new MdiMeta(
            "database-plus-outline",
            "F1633",
            Arrays.asList("Database"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_refresh() {
    return MdiIcon.create(
        "mdi-database-refresh",
        new MdiMeta(
            "database-refresh",
            "F05C2",
            Arrays.asList("Database"),
            Arrays.asList(),
            "Michael Richins",
            "1.5.54"));
  }

  public static MdiIcon database_refresh_outline() {
    return MdiIcon.create(
        "mdi-database-refresh-outline",
        new MdiMeta(
            "database-refresh-outline",
            "F1634",
            Arrays.asList("Database"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_remove() {
    return MdiIcon.create(
        "mdi-database-remove",
        new MdiMeta(
            "database-remove",
            "F0D00",
            Arrays.asList("Geographic Information System", "Database"),
            Arrays.asList(),
            "Michael Richins",
            "3.3.92"));
  }

  public static MdiIcon database_remove_outline() {
    return MdiIcon.create(
        "mdi-database-remove-outline",
        new MdiMeta(
            "database-remove-outline",
            "F1635",
            Arrays.asList("Database"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_search() {
    return MdiIcon.create(
        "mdi-database-search",
        new MdiMeta(
            "database-search",
            "F0866",
            Arrays.asList("Geographic Information System", "Database"),
            Arrays.asList("sql-query"),
            "GreenTurtwig",
            "2.1.99"));
  }

  public static MdiIcon database_search_outline() {
    return MdiIcon.create(
        "mdi-database-search-outline",
        new MdiMeta(
            "database-search-outline",
            "F1636",
            Arrays.asList("Database"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_settings() {
    return MdiIcon.create(
        "mdi-database-settings",
        new MdiMeta(
            "database-settings",
            "F0D01",
            Arrays.asList("Settings", "Geographic Information System", "Database"),
            Arrays.asList(),
            "Michael Richins",
            "3.3.92"));
  }

  public static MdiIcon database_settings_outline() {
    return MdiIcon.create(
        "mdi-database-settings-outline",
        new MdiMeta(
            "database-settings-outline",
            "F1637",
            Arrays.asList("Database", "Settings"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon database_sync() {
    return MdiIcon.create(
        "mdi-database-sync",
        new MdiMeta(
            "database-sync",
            "F0CFF",
            Arrays.asList("Geographic Information System", "Database"),
            Arrays.asList(),
            "Michael Richins",
            "3.3.92"));
  }

  public static MdiIcon database_sync_outline() {
    return MdiIcon.create(
        "mdi-database-sync-outline",
        new MdiMeta(
            "database-sync-outline",
            "F1638",
            Arrays.asList("Database"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon death_star() {
    return MdiIcon.create(
        "mdi-death-star",
        new MdiMeta(
            "death-star", "F08D8", Arrays.asList(), Arrays.asList(), "Colton Wiscombe", "2.3.50"));
  }

  public static MdiIcon death_star_variant() {
    return MdiIcon.create(
        "mdi-death-star-variant",
        new MdiMeta(
            "death-star-variant",
            "F08D9",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "2.3.50"));
  }

  public static MdiIcon deathly_hallows() {
    return MdiIcon.create(
        "mdi-deathly-hallows",
        new MdiMeta(
            "deathly-hallows",
            "F0B87",
            Arrays.asList(),
            Arrays.asList("harry-potter"),
            "Michael Richins",
            "3.0.39"));
  }

  @Deprecated
  public static MdiIcon debian() {
    return MdiIcon.create(
        "mdi-debian",
        new MdiMeta(
            "debian",
            "F08DA",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "2.3.50"));
  }

  public static MdiIcon debug_step_into() {
    return MdiIcon.create(
        "mdi-debug-step-into",
        new MdiMeta(
            "debug-step-into",
            "F01B9",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon debug_step_out() {
    return MdiIcon.create(
        "mdi-debug-step-out",
        new MdiMeta(
            "debug-step-out",
            "F01B8",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon debug_step_over() {
    return MdiIcon.create(
        "mdi-debug-step-over",
        new MdiMeta(
            "debug-step-over",
            "F01B7",
            Arrays.asList(),
            Arrays.asList("skip", "jump"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon decagram() {
    return MdiIcon.create(
        "mdi-decagram",
        new MdiMeta(
            "decagram",
            "F076C",
            Arrays.asList("Shape"),
            Arrays.asList("starburst"),
            "Austin Andrews",
            "1.9.32"));
  }

  public static MdiIcon decagram_outline() {
    return MdiIcon.create(
        "mdi-decagram-outline",
        new MdiMeta(
            "decagram-outline",
            "F076D",
            Arrays.asList("Shape"),
            Arrays.asList("starburst-outline"),
            "Austin Andrews",
            "1.9.32"));
  }

  public static MdiIcon decimal() {
    return MdiIcon.create(
        "mdi-decimal",
        new MdiMeta(
            "decimal",
            "F10A1",
            Arrays.asList("Math"),
            Arrays.asList(),
            "Michael Richins",
            "4.2.95"));
  }

  public static MdiIcon decimal_comma() {
    return MdiIcon.create(
        "mdi-decimal-comma",
        new MdiMeta(
            "decimal-comma",
            "F10A2",
            Arrays.asList("Math"),
            Arrays.asList(),
            "Michael Richins",
            "4.2.95"));
  }

  public static MdiIcon decimal_comma_decrease() {
    return MdiIcon.create(
        "mdi-decimal-comma-decrease",
        new MdiMeta(
            "decimal-comma-decrease",
            "F10A3",
            Arrays.asList("Math"),
            Arrays.asList(),
            "Michael Richins",
            "4.2.95"));
  }

  public static MdiIcon decimal_comma_increase() {
    return MdiIcon.create(
        "mdi-decimal-comma-increase",
        new MdiMeta(
            "decimal-comma-increase",
            "F10A4",
            Arrays.asList("Math"),
            Arrays.asList(),
            "Michael Richins",
            "4.2.95"));
  }

  public static MdiIcon decimal_decrease() {
    return MdiIcon.create(
        "mdi-decimal-decrease",
        new MdiMeta(
            "decimal-decrease",
            "F01B6",
            Arrays.asList("Math"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon decimal_increase() {
    return MdiIcon.create(
        "mdi-decimal-increase",
        new MdiMeta(
            "decimal-increase",
            "F01B5",
            Arrays.asList("Math"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon delete() {
    return MdiIcon.create(
        "mdi-delete",
        new MdiMeta(
            "delete",
            "F01B4",
            Arrays.asList(),
            Arrays.asList(
                "trash", "bin", "rubbish", "garbage", "rubbish-bin", "trash-can", "garbage-can"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon delete_alert() {
    return MdiIcon.create(
        "mdi-delete-alert",
        new MdiMeta(
            "delete-alert",
            "F10A5",
            Arrays.asList("Alert / Error"),
            Arrays.asList(),
            "idevo89",
            "4.2.95"));
  }

  public static MdiIcon delete_alert_outline() {
    return MdiIcon.create(
        "mdi-delete-alert-outline",
        new MdiMeta(
            "delete-alert-outline",
            "F10A6",
            Arrays.asList("Alert / Error"),
            Arrays.asList(),
            "idevo89",
            "4.2.95"));
  }

  public static MdiIcon delete_circle() {
    return MdiIcon.create(
        "mdi-delete-circle",
        new MdiMeta(
            "delete-circle",
            "F0683",
            Arrays.asList(),
            Arrays.asList(
                "trash-circle",
                "bin-circle",
                "garbage-can-circle",
                "garbage-circle",
                "rubbish-bin-circle",
                "rubbish-circle",
                "trash-can-circle"),
            "Austin Andrews",
            "1.7.12"));
  }

  public static MdiIcon delete_circle_outline() {
    return MdiIcon.create(
        "mdi-delete-circle-outline",
        new MdiMeta(
            "delete-circle-outline",
            "F0B88",
            Arrays.asList(),
            Arrays.asList(
                "bin-circle-outline",
                "garbage-can-circle-outline",
                "garbage-circle-outline",
                "rubbish-bin-circle-outline",
                "rubbish-circle-outline",
                "trash-can-circle-outline",
                "trash-circle-outline"),
            "TheChilliPL",
            "3.0.39"));
  }

  public static MdiIcon delete_clock() {
    return MdiIcon.create(
        "mdi-delete-clock",
        new MdiMeta(
            "delete-clock",
            "F1556",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "CoreyVidal",
            "5.5.55"));
  }

  public static MdiIcon delete_clock_outline() {
    return MdiIcon.create(
        "mdi-delete-clock-outline",
        new MdiMeta(
            "delete-clock-outline",
            "F1557",
            Arrays.asList("Date / Time"),
            Arrays.asList(),
            "CoreyVidal",
            "5.5.55"));
  }

  public static MdiIcon delete_empty() {
    return MdiIcon.create(
        "mdi-delete-empty",
        new MdiMeta(
            "delete-empty",
            "F06CC",
            Arrays.asList(),
            Arrays.asList(
                "trash-empty",
                "bin-empty",
                "rubbish-empty",
                "rubbish-bin-empty",
                "trash-can-empty",
                "garbage-empty",
                "garbage-can-empty"),
            "Austin Andrews",
            "1.8.36"));
  }

  public static MdiIcon delete_empty_outline() {
    return MdiIcon.create(
        "mdi-delete-empty-outline",
        new MdiMeta(
            "delete-empty-outline",
            "F0E9D",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "3.7.94"));
  }

  public static MdiIcon delete_forever() {
    return MdiIcon.create(
        "mdi-delete-forever",
        new MdiMeta(
            "delete-forever", "F05E8", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon delete_forever_outline() {
    return MdiIcon.create(
        "mdi-delete-forever-outline",
        new MdiMeta(
            "delete-forever-outline",
            "F0B89",
            Arrays.asList(),
            Arrays.asList(),
            "Google",
            "3.0.39"));
  }

  public static MdiIcon delete_off() {
    return MdiIcon.create(
        "mdi-delete-off",
        new MdiMeta("delete-off", "F10A7", Arrays.asList(), Arrays.asList(), "idevo89", "4.2.95"));
  }

  public static MdiIcon delete_off_outline() {
    return MdiIcon.create(
        "mdi-delete-off-outline",
        new MdiMeta(
            "delete-off-outline", "F10A8", Arrays.asList(), Arrays.asList(), "idevo89", "4.2.95"));
  }

  public static MdiIcon delete_outline() {
    return MdiIcon.create(
        "mdi-delete-outline",
        new MdiMeta(
            "delete-outline",
            "F09E7",
            Arrays.asList(),
            Arrays.asList(
                "garbage-outline",
                "bin-outline",
                "rubbish-outline",
                "garbage-can-outline",
                "rubbish-bin-outline",
                "trash-outline",
                "trash-can-outline"),
            "Google",
            "2.5.94"));
  }

  public static MdiIcon delete_restore() {
    return MdiIcon.create(
        "mdi-delete-restore",
        new MdiMeta(
            "delete-restore",
            "F0819",
            Arrays.asList(),
            Arrays.asList("trash-restore", "bin-restore", "restore-from-trash"),
            "Google",
            "2.1.19"));
  }

  public static MdiIcon delete_sweep() {
    return MdiIcon.create(
        "mdi-delete-sweep",
        new MdiMeta("delete-sweep", "F05E9", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon delete_sweep_outline() {
    return MdiIcon.create(
        "mdi-delete-sweep-outline",
        new MdiMeta(
            "delete-sweep-outline", "F0C62", Arrays.asList(), Arrays.asList(), "Google", "3.2.89"));
  }

  public static MdiIcon delete_variant() {
    return MdiIcon.create(
        "mdi-delete-variant",
        new MdiMeta(
            "delete-variant",
            "F01B3",
            Arrays.asList(),
            Arrays.asList("trash-variant", "bin-variant", "cup-ice", "drink-ice"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon delta() {
    return MdiIcon.create(
        "mdi-delta",
        new MdiMeta(
            "delta",
            "F01C2",
            Arrays.asList("Math", "Alpha / Numeric"),
            Arrays.asList("change-history"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon desk() {
    return MdiIcon.create(
        "mdi-desk",
        new MdiMeta("desk", "F1239", Arrays.asList(), Arrays.asList(), "Gabriel Grant", "4.6.95"));
  }

  public static MdiIcon desk_lamp() {
    return MdiIcon.create(
        "mdi-desk-lamp",
        new MdiMeta(
            "desk-lamp",
            "F095F",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Contributors",
            "2.4.85"));
  }

  public static MdiIcon desk_lamp_off() {
    return MdiIcon.create(
        "mdi-desk-lamp-off",
        new MdiMeta(
            "desk-lamp-off",
            "F1B1F",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.9.96"));
  }

  public static MdiIcon desk_lamp_on() {
    return MdiIcon.create(
        "mdi-desk-lamp-on",
        new MdiMeta(
            "desk-lamp-on",
            "F1B20",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.9.96"));
  }

  public static MdiIcon deskphone() {
    return MdiIcon.create(
        "mdi-deskphone",
        new MdiMeta(
            "deskphone",
            "F01C3",
            Arrays.asList("Cellphone / Phone", "Device / Tech"),
            Arrays.asList(),
            "Chris Litherland",
            "1.5.54"));
  }

  public static MdiIcon desktop_classic() {
    return MdiIcon.create(
        "mdi-desktop-classic",
        new MdiMeta(
            "desktop-classic",
            "F07C0",
            Arrays.asList("Device / Tech", "Home Automation"),
            Arrays.asList("computer-classic"),
            "GreenTurtwig",
            "2.0.46"));
  }

  public static MdiIcon desktop_tower() {
    return MdiIcon.create(
        "mdi-desktop-tower",
        new MdiMeta(
            "desktop-tower",
            "F01C5",
            Arrays.asList("Device / Tech", "Home Automation"),
            Arrays.asList(),
            "Chris Litherland",
            "1.5.54"));
  }

  public static MdiIcon desktop_tower_monitor() {
    return MdiIcon.create(
        "mdi-desktop-tower-monitor",
        new MdiMeta(
            "desktop-tower-monitor",
            "F0AAB",
            Arrays.asList("Device / Tech"),
            Arrays.asList(),
            "SarinManS",
            "2.7.94"));
  }

  public static MdiIcon details() {
    return MdiIcon.create(
        "mdi-details",
        new MdiMeta("details", "F01C6", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  @Deprecated
  public static MdiIcon dev_to() {
    return MdiIcon.create(
        "mdi-dev-to",
        new MdiMeta(
            "dev-to",
            "F0D6E",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "3.4.93"));
  }

  public static MdiIcon developer_board() {
    return MdiIcon.create(
        "mdi-developer-board",
        new MdiMeta(
            "developer-board", "F0697", Arrays.asList(), Arrays.asList(), "Google", "1.7.12"));
  }

  @Deprecated
  public static MdiIcon deviantart() {
    return MdiIcon.create(
        "mdi-deviantart",
        new MdiMeta(
            "deviantart",
            "F01C7",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "1.5.54"));
  }

  public static MdiIcon devices() {
    return MdiIcon.create(
        "mdi-devices",
        new MdiMeta(
            "devices",
            "F0FB0",
            Arrays.asList("Device / Tech", "Home Automation", "Cellphone / Phone"),
            Arrays.asList(
                "monitor", "watch", "smartwatch", "smartphone", "cellphone", "television"),
            "Google",
            "4.0.96"));
  }

  public static MdiIcon dharmachakra() {
    return MdiIcon.create(
        "mdi-dharmachakra",
        new MdiMeta(
            "dharmachakra",
            "F094B",
            Arrays.asList("Religion"),
            Arrays.asList("dharma-wheel", "religion-buddhist", "buddhism"),
            "Nick",
            "2.4.85"));
  }

  public static MdiIcon diabetes() {
    return MdiIcon.create(
        "mdi-diabetes",
        new MdiMeta(
            "diabetes",
            "F1126",
            Arrays.asList("Medical / Hospital"),
            Arrays.asList("hand-blood"),
            "Michael Richins",
            "4.3.95"));
  }

  public static MdiIcon dialpad() {
    return MdiIcon.create(
        "mdi-dialpad",
        new MdiMeta(
            "dialpad", "F061C", Arrays.asList(), Arrays.asList("keypad"), "Google", "1.6.50"));
  }

  public static MdiIcon diameter() {
    return MdiIcon.create(
        "mdi-diameter",
        new MdiMeta(
            "diameter",
            "F0C63",
            Arrays.asList("Math"),
            Arrays.asList("circle-diameter", "sphere-diameter"),
            "Michael Richins",
            "3.2.89"));
  }

  public static MdiIcon diameter_outline() {
    return MdiIcon.create(
        "mdi-diameter-outline",
        new MdiMeta(
            "diameter-outline",
            "F0C64",
            Arrays.asList("Math"),
            Arrays.asList("circle-diameter-outline", "sphere-diameter-outline"),
            "Michael Richins",
            "3.2.89"));
  }

  public static MdiIcon diameter_variant() {
    return MdiIcon.create(
        "mdi-diameter-variant",
        new MdiMeta(
            "diameter-variant",
            "F0C65",
            Arrays.asList("Math"),
            Arrays.asList("circle-diameter-variant", "sphere-diameter-variant"),
            "Michael Richins",
            "3.2.89"));
  }

  public static MdiIcon diamond() {
    return MdiIcon.create(
        "mdi-diamond",
        new MdiMeta(
            "diamond", "F0B8A", Arrays.asList(), Arrays.asList(), "Michael Richins", "3.0.39"));
  }

  public static MdiIcon diamond_outline() {
    return MdiIcon.create(
        "mdi-diamond-outline",
        new MdiMeta(
            "diamond-outline",
            "F0B8B",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "3.0.39"));
  }

  public static MdiIcon diamond_stone() {
    return MdiIcon.create(
        "mdi-diamond-stone",
        new MdiMeta(
            "diamond-stone", "F01C8", Arrays.asList(), Arrays.asList("jewel"), "Simran", "1.5.54"));
  }

  public static MdiIcon dice_1() {
    return MdiIcon.create(
        "mdi-dice-1",
        new MdiMeta(
            "dice-1",
            "F01CA",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("die-1", "dice-one"),
            "Yasmina Lembachar",
            "1.5.54"));
  }

  public static MdiIcon dice_1_outline() {
    return MdiIcon.create(
        "mdi-dice-1-outline",
        new MdiMeta(
            "dice-1-outline",
            "F114A",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon dice_2() {
    return MdiIcon.create(
        "mdi-dice-2",
        new MdiMeta(
            "dice-2",
            "F01CB",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("die-2", "dice-two"),
            "Yasmina Lembachar",
            "1.5.54"));
  }

  public static MdiIcon dice_2_outline() {
    return MdiIcon.create(
        "mdi-dice-2-outline",
        new MdiMeta(
            "dice-2-outline",
            "F114B",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon dice_3() {
    return MdiIcon.create(
        "mdi-dice-3",
        new MdiMeta(
            "dice-3",
            "F01CC",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("die-3", "dice-three"),
            "Yasmina Lembachar",
            "1.5.54"));
  }

  public static MdiIcon dice_3_outline() {
    return MdiIcon.create(
        "mdi-dice-3-outline",
        new MdiMeta(
            "dice-3-outline",
            "F114C",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon dice_4() {
    return MdiIcon.create(
        "mdi-dice-4",
        new MdiMeta(
            "dice-4",
            "F01CD",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("die-4", "dice-four"),
            "Yasmina Lembachar",
            "1.5.54"));
  }

  public static MdiIcon dice_4_outline() {
    return MdiIcon.create(
        "mdi-dice-4-outline",
        new MdiMeta(
            "dice-4-outline",
            "F114D",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon dice_5() {
    return MdiIcon.create(
        "mdi-dice-5",
        new MdiMeta(
            "dice-5",
            "F01CE",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("die-5", "dice-five"),
            "Yasmina Lembachar",
            "1.5.54"));
  }

  public static MdiIcon dice_5_outline() {
    return MdiIcon.create(
        "mdi-dice-5-outline",
        new MdiMeta(
            "dice-5-outline",
            "F114E",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon dice_6() {
    return MdiIcon.create(
        "mdi-dice-6",
        new MdiMeta(
            "dice-6",
            "F01CF",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("die-6", "dice-six"),
            "Yasmina Lembachar",
            "1.5.54"));
  }

  public static MdiIcon dice_6_outline() {
    return MdiIcon.create(
        "mdi-dice-6-outline",
        new MdiMeta(
            "dice-6-outline",
            "F114F",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon dice_d10() {
    return MdiIcon.create(
        "mdi-dice-d10",
        new MdiMeta(
            "dice-d10",
            "F1153",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon dice_d10_outline() {
    return MdiIcon.create(
        "mdi-dice-d10-outline",
        new MdiMeta(
            "dice-d10-outline",
            "F076F",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("die-d10"),
            "Austin Andrews",
            "1.9.32"));
  }

  public static MdiIcon dice_d12() {
    return MdiIcon.create(
        "mdi-dice-d12",
        new MdiMeta(
            "dice-d12",
            "F1154",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon dice_d12_outline() {
    return MdiIcon.create(
        "mdi-dice-d12-outline",
        new MdiMeta(
            "dice-d12-outline",
            "F0867",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "Michael Richins",
            "2.1.99"));
  }

  public static MdiIcon dice_d20() {
    return MdiIcon.create(
        "mdi-dice-d20",
        new MdiMeta(
            "dice-d20",
            "F1155",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon dice_d20_outline() {
    return MdiIcon.create(
        "mdi-dice-d20-outline",
        new MdiMeta(
            "dice-d20-outline",
            "F05EA",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("die-d20"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon dice_d4() {
    return MdiIcon.create(
        "mdi-dice-d4",
        new MdiMeta(
            "dice-d4",
            "F1150",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon dice_d4_outline() {
    return MdiIcon.create(
        "mdi-dice-d4-outline",
        new MdiMeta(
            "dice-d4-outline",
            "F05EB",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("die-d4"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon dice_d6() {
    return MdiIcon.create(
        "mdi-dice-d6",
        new MdiMeta(
            "dice-d6",
            "F1151",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon dice_d6_outline() {
    return MdiIcon.create(
        "mdi-dice-d6-outline",
        new MdiMeta(
            "dice-d6-outline",
            "F05ED",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("die-d6"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon dice_d8() {
    return MdiIcon.create(
        "mdi-dice-d8",
        new MdiMeta(
            "dice-d8",
            "F1152",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon dice_d8_outline() {
    return MdiIcon.create(
        "mdi-dice-d8-outline",
        new MdiMeta(
            "dice-d8-outline",
            "F05EC",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("die-d8"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon dice_multiple() {
    return MdiIcon.create(
        "mdi-dice-multiple",
        new MdiMeta(
            "dice-multiple",
            "F076E",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("die-multiple"),
            "Michael Richins",
            "1.9.32"));
  }

  public static MdiIcon dice_multiple_outline() {
    return MdiIcon.create(
        "mdi-dice-multiple-outline",
        new MdiMeta(
            "dice-multiple-outline",
            "F1156",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.4.95"));
  }

  @Deprecated
  public static MdiIcon digital_ocean() {
    return MdiIcon.create(
        "mdi-digital-ocean",
        new MdiMeta(
            "digital-ocean",
            "F1237",
            Arrays.asList("Developer / Languages", "Brand / Logo"),
            Arrays.asList(),
            "Michael Richins",
            "4.6.95"));
  }

  public static MdiIcon dip_switch() {
    return MdiIcon.create(
        "mdi-dip-switch",
        new MdiMeta(
            "dip-switch", "F07C1", Arrays.asList(), Arrays.asList(), "Austin Andrews", "2.0.46"));
  }

  public static MdiIcon directions() {
    return MdiIcon.create(
        "mdi-directions",
        new MdiMeta("directions", "F01D0", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon directions_fork() {
    return MdiIcon.create(
        "mdi-directions-fork",
        new MdiMeta(
            "directions-fork", "F0641", Arrays.asList(), Arrays.asList(), "Google", "1.6.50"));
  }

  public static MdiIcon disc() {
    return MdiIcon.create(
        "mdi-disc",
        new MdiMeta(
            "disc",
            "F05EE",
            Arrays.asList("Music"),
            Arrays.asList("cd-rom", "dvd"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon disc_alert() {
    return MdiIcon.create(
        "mdi-disc-alert",
        new MdiMeta(
            "disc-alert",
            "F01D1",
            Arrays.asList("Alert / Error"),
            Arrays.asList("disc-full", "disc-warning"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon disc_player() {
    return MdiIcon.create(
        "mdi-disc-player",
        new MdiMeta(
            "disc-player",
            "F0960",
            Arrays.asList("Home Automation", "Device / Tech"),
            Arrays.asList(),
            "Austin Andrews",
            "2.4.85"));
  }

  public static MdiIcon dishwasher() {
    return MdiIcon.create(
        "mdi-dishwasher",
        new MdiMeta(
            "dishwasher",
            "F0AAC",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Google",
            "2.7.94"));
  }

  public static MdiIcon dishwasher_alert() {
    return MdiIcon.create(
        "mdi-dishwasher-alert",
        new MdiMeta(
            "dishwasher-alert",
            "F11B8",
            Arrays.asList("Home Automation", "Alert / Error"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.5.95"));
  }

  public static MdiIcon dishwasher_off() {
    return MdiIcon.create(
        "mdi-dishwasher-off",
        new MdiMeta(
            "dishwasher-off",
            "F11B9",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.5.95"));
  }

  @Deprecated
  public static MdiIcon disqus() {
    return MdiIcon.create(
        "mdi-disqus",
        new MdiMeta(
            "disqus",
            "F01D2",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "1.5.54"));
  }

  public static MdiIcon distribute_horizontal_center() {
    return MdiIcon.create(
        "mdi-distribute-horizontal-center",
        new MdiMeta(
            "distribute-horizontal-center",
            "F11C9",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.5.95"));
  }

  public static MdiIcon distribute_horizontal_left() {
    return MdiIcon.create(
        "mdi-distribute-horizontal-left",
        new MdiMeta(
            "distribute-horizontal-left",
            "F11C8",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.5.95"));
  }

  public static MdiIcon distribute_horizontal_right() {
    return MdiIcon.create(
        "mdi-distribute-horizontal-right",
        new MdiMeta(
            "distribute-horizontal-right",
            "F11CA",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.5.95"));
  }

  public static MdiIcon distribute_vertical_bottom() {
    return MdiIcon.create(
        "mdi-distribute-vertical-bottom",
        new MdiMeta(
            "distribute-vertical-bottom",
            "F11CB",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.5.95"));
  }

  public static MdiIcon distribute_vertical_center() {
    return MdiIcon.create(
        "mdi-distribute-vertical-center",
        new MdiMeta(
            "distribute-vertical-center",
            "F11CC",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.5.95"));
  }

  public static MdiIcon distribute_vertical_top() {
    return MdiIcon.create(
        "mdi-distribute-vertical-top",
        new MdiMeta(
            "distribute-vertical-top",
            "F11CD",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.5.95"));
  }

  public static MdiIcon diversify() {
    return MdiIcon.create(
        "mdi-diversify",
        new MdiMeta("diversify", "F1877", Arrays.asList(), Arrays.asList(), "Simran", "6.2.95"));
  }

  public static MdiIcon diving() {
    return MdiIcon.create(
        "mdi-diving",
        new MdiMeta(
            "diving",
            "F1977",
            Arrays.asList("Sport", "People / Family"),
            Arrays.asList("swim-dive", "human-diving"),
            "Google",
            "6.5.95"));
  }

  public static MdiIcon diving_flippers() {
    return MdiIcon.create(
        "mdi-diving-flippers",
        new MdiMeta(
            "diving-flippers",
            "F0DBF",
            Arrays.asList("Sport"),
            Arrays.asList(),
            "Michael Richins",
            "3.5.94"));
  }

  public static MdiIcon diving_helmet() {
    return MdiIcon.create(
        "mdi-diving-helmet",
        new MdiMeta(
            "diving-helmet",
            "F0DC0",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "3.5.94"));
  }

  public static MdiIcon diving_scuba() {
    return MdiIcon.create(
        "mdi-diving-scuba",
        new MdiMeta(
            "diving-scuba", "F1B77", Arrays.asList("Sport"), Arrays.asList(), "Google", "7.0.96"));
  }

  public static MdiIcon diving_scuba_flag() {
    return MdiIcon.create(
        "mdi-diving-scuba-flag",
        new MdiMeta(
            "diving-scuba-flag",
            "F0DC2",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "3.5.94"));
  }

  public static MdiIcon diving_scuba_mask() {
    return MdiIcon.create(
        "mdi-diving-scuba-mask",
        new MdiMeta(
            "diving-scuba-mask",
            "F0DC1",
            Arrays.asList("Sport"),
            Arrays.asList(),
            "Michael Richins",
            "3.5.94"));
  }

  public static MdiIcon diving_scuba_tank() {
    return MdiIcon.create(
        "mdi-diving-scuba-tank",
        new MdiMeta(
            "diving-scuba-tank",
            "F0DC3",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "3.5.94"));
  }

  public static MdiIcon diving_scuba_tank_multiple() {
    return MdiIcon.create(
        "mdi-diving-scuba-tank-multiple",
        new MdiMeta(
            "diving-scuba-tank-multiple",
            "F0DC4",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "3.5.94"));
  }

  public static MdiIcon diving_snorkel() {
    return MdiIcon.create(
        "mdi-diving-snorkel",
        new MdiMeta(
            "diving-snorkel",
            "F0DC5",
            Arrays.asList("Sport"),
            Arrays.asList(),
            "Michael Richins",
            "3.5.94"));
  }

  public static MdiIcon division() {
    return MdiIcon.create(
        "mdi-division",
        new MdiMeta(
            "division",
            "F01D4",
            Arrays.asList("Math"),
            Arrays.asList("obelus"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon division_box() {
    return MdiIcon.create(
        "mdi-division-box",
        new MdiMeta(
            "division-box",
            "F01D5",
            Arrays.asList("Math"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  @Deprecated
  public static MdiIcon dlna() {
    return MdiIcon.create(
        "mdi-dlna",
        new MdiMeta(
            "dlna",
            "F0A41",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "2.6.95"));
  }

  public static MdiIcon dna() {
    return MdiIcon.create(
        "mdi-dna",
        new MdiMeta(
            "dna",
            "F0684",
            Arrays.asList("Science"),
            Arrays.asList("helix"),
            "Haley Halcyon",
            "1.7.12"));
  }

  public static MdiIcon dns() {
    return MdiIcon.create(
        "mdi-dns",
        new MdiMeta("dns", "F01D6", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon dns_outline() {
    return MdiIcon.create(
        "mdi-dns-outline",
        new MdiMeta("dns-outline", "F0B8C", Arrays.asList(), Arrays.asList(), "Google", "3.0.39"));
  }

  public static MdiIcon dock_bottom() {
    return MdiIcon.create(
        "mdi-dock-bottom",
        new MdiMeta(
            "dock-bottom", "F10A9", Arrays.asList(), Arrays.asList(), "Michael Richins", "4.2.95"));
  }

  public static MdiIcon dock_left() {
    return MdiIcon.create(
        "mdi-dock-left",
        new MdiMeta(
            "dock-left", "F10AA", Arrays.asList(), Arrays.asList(), "Michael Richins", "4.2.95"));
  }

  public static MdiIcon dock_right() {
    return MdiIcon.create(
        "mdi-dock-right",
        new MdiMeta(
            "dock-right", "F10AB", Arrays.asList(), Arrays.asList(), "Michael Richins", "4.2.95"));
  }

  public static MdiIcon dock_top() {
    return MdiIcon.create(
        "mdi-dock-top",
        new MdiMeta(
            "dock-top", "F1513", Arrays.asList(), Arrays.asList(), "Michael Irigoyen", "5.4.55"));
  }

  public static MdiIcon dock_window() {
    return MdiIcon.create(
        "mdi-dock-window",
        new MdiMeta(
            "dock-window", "F10AC", Arrays.asList(), Arrays.asList(), "Michael Richins", "4.2.95"));
  }

  @Deprecated
  public static MdiIcon docker() {
    return MdiIcon.create(
        "mdi-docker",
        new MdiMeta(
            "docker",
            "F0868",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "2.1.99"));
  }

  public static MdiIcon doctor() {
    return MdiIcon.create(
        "mdi-doctor",
        new MdiMeta(
            "doctor",
            "F0A42",
            Arrays.asList("Medical / Hospital"),
            Arrays.asList(),
            "Augustin Ursu",
            "2.6.95"));
  }

  public static MdiIcon dog() {
    return MdiIcon.create(
        "mdi-dog",
        new MdiMeta(
            "dog",
            "F0A43",
            Arrays.asList("Animal"),
            Arrays.asList("emoji-dog", "emoticon-dog"),
            "Michael Irigoyen",
            "2.6.95"));
  }

  public static MdiIcon dog_service() {
    return MdiIcon.create(
        "mdi-dog-service",
        new MdiMeta(
            "dog-service",
            "F0AAD",
            Arrays.asList("Animal"),
            Arrays.asList("guide-dog", "k9", "canine"),
            "Michael Richins",
            "2.7.94"));
  }

  public static MdiIcon dog_side() {
    return MdiIcon.create(
        "mdi-dog-side",
        new MdiMeta(
            "dog-side",
            "F0A44",
            Arrays.asList("Animal"),
            Arrays.asList("k9", "canine"),
            "Nick",
            "2.6.95"));
  }

  public static MdiIcon dog_side_off() {
    return MdiIcon.create(
        "mdi-dog-side-off",
        new MdiMeta(
            "dog-side-off",
            "F16EE",
            Arrays.asList("Animal"),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.9.55"));
  }

  @Deprecated
  public static MdiIcon dolby() {
    return MdiIcon.create(
        "mdi-dolby",
        new MdiMeta(
            "dolby",
            "F06B3",
            Arrays.asList("Audio", "Brand / Logo", "Home Automation"),
            Arrays.asList(),
            "Contributors",
            "1.7.22"));
  }

  public static MdiIcon dolly() {
    return MdiIcon.create(
        "mdi-dolly",
        new MdiMeta(
            "dolly",
            "F0E9E",
            Arrays.asList(),
            Arrays.asList("hand-truck", "trolley"),
            "Michael Irigoyen",
            "3.7.94"));
  }

  public static MdiIcon dolphin() {
    return MdiIcon.create(
        "mdi-dolphin",
        new MdiMeta(
            "dolphin",
            "F18B4",
            Arrays.asList("Animal"),
            Arrays.asList("porpoise"),
            "Colton Wiscombe",
            "6.3.95"));
  }

  public static MdiIcon domain() {
    return MdiIcon.create(
        "mdi-domain",
        new MdiMeta(
            "domain",
            "F01D7",
            Arrays.asList("Places"),
            Arrays.asList("building", "company", "business"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon domain_off() {
    return MdiIcon.create(
        "mdi-domain-off",
        new MdiMeta("domain-off", "F0D6F", Arrays.asList(), Arrays.asList(), "Google", "3.4.93"));
  }

  public static MdiIcon domain_plus() {
    return MdiIcon.create(
        "mdi-domain-plus",
        new MdiMeta(
            "domain-plus", "F10AD", Arrays.asList(), Arrays.asList(), "Michael Richins", "4.2.95"));
  }

  public static MdiIcon domain_remove() {
    return MdiIcon.create(
        "mdi-domain-remove",
        new MdiMeta(
            "domain-remove",
            "F10AE",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "4.2.95"));
  }

  public static MdiIcon domain_switch() {
    return MdiIcon.create(
        "mdi-domain-switch",
        new MdiMeta(
            "domain-switch", "F1C2C", Arrays.asList(), Arrays.asList(), "Jeff Anders", "7.2.96"));
  }

  public static MdiIcon dome_light() {
    return MdiIcon.create(
        "mdi-dome-light",
        new MdiMeta(
            "dome-light", "F141E", Arrays.asList(), Arrays.asList(), "Tim Grelka", "5.2.45"));
  }

  public static MdiIcon domino_mask() {
    return MdiIcon.create(
        "mdi-domino-mask",
        new MdiMeta(
            "domino-mask",
            "F1023",
            Arrays.asList(),
            Arrays.asList("robber-mask", "zorro-mask"),
            "Andrew Nenakhov",
            "4.1.95"));
  }

  public static MdiIcon donkey() {
    return MdiIcon.create(
        "mdi-donkey",
        new MdiMeta(
            "donkey", "F07C2", Arrays.asList("Animal"), Arrays.asList(), "Contributors", "2.0.46"));
  }

  public static MdiIcon door() {
    return MdiIcon.create(
        "mdi-door",
        new MdiMeta(
            "door",
            "F081A",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Haley Halcyon",
            "2.1.19"));
  }

  public static MdiIcon door_closed() {
    return MdiIcon.create(
        "mdi-door-closed",
        new MdiMeta(
            "door-closed",
            "F081B",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Haley Halcyon",
            "2.1.19"));
  }

  public static MdiIcon door_closed_lock() {
    return MdiIcon.create(
        "mdi-door-closed-lock",
        new MdiMeta(
            "door-closed-lock",
            "F10AF",
            Arrays.asList("Home Automation", "Lock"),
            Arrays.asList(),
            "Michael Richins",
            "4.2.95"));
  }

  public static MdiIcon door_open() {
    return MdiIcon.create(
        "mdi-door-open",
        new MdiMeta(
            "door-open",
            "F081C",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Haley Halcyon",
            "2.1.19"));
  }

  public static MdiIcon door_sliding() {
    return MdiIcon.create(
        "mdi-door-sliding",
        new MdiMeta(
            "door-sliding",
            "F181E",
            Arrays.asList("Home Automation"),
            Arrays.asList("patio-door", "french-door"),
            "Google",
            "6.1.95"));
  }

  public static MdiIcon door_sliding_lock() {
    return MdiIcon.create(
        "mdi-door-sliding-lock",
        new MdiMeta(
            "door-sliding-lock",
            "F181F",
            Arrays.asList("Home Automation", "Lock"),
            Arrays.asList("patio-door-lock", "french-door-lock"),
            "Michael Irigoyen",
            "6.1.95"));
  }

  public static MdiIcon door_sliding_open() {
    return MdiIcon.create(
        "mdi-door-sliding-open",
        new MdiMeta(
            "door-sliding-open",
            "F1820",
            Arrays.asList("Home Automation"),
            Arrays.asList("patio-door-open", "french-door-open"),
            "Michael Irigoyen",
            "6.1.95"));
  }

  public static MdiIcon doorbell() {
    return MdiIcon.create(
        "mdi-doorbell",
        new MdiMeta(
            "doorbell",
            "F12E6",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.8.95"));
  }

  public static MdiIcon doorbell_video() {
    return MdiIcon.create(
        "mdi-doorbell-video",
        new MdiMeta(
            "doorbell-video",
            "F0869",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.1.99"));
  }

  @Deprecated
  public static MdiIcon dot_net() {
    return MdiIcon.create(
        "mdi-dot-net",
        new MdiMeta(
            "dot-net",
            "F0AAE",
            Arrays.asList("Developer / Languages", "Brand / Logo"),
            Arrays.asList("microsoft-dot-net"),
            "Contributors",
            "2.7.94"));
  }

  public static MdiIcon dots_circle() {
    return MdiIcon.create(
        "mdi-dots-circle",
        new MdiMeta(
            "dots-circle",
            "F1978",
            Arrays.asList(),
            Arrays.asList("perimeter"),
            "Michael Irigoyen",
            "6.5.95"));
  }

  public static MdiIcon dots_grid() {
    return MdiIcon.create(
        "mdi-dots-grid",
        new MdiMeta(
            "dots-grid", "F15FC", Arrays.asList(), Arrays.asList(), "Jeff Anders", "5.6.55"));
  }

  public static MdiIcon dots_hexagon() {
    return MdiIcon.create(
        "mdi-dots-hexagon",
        new MdiMeta(
            "dots-hexagon", "F15FF", Arrays.asList(), Arrays.asList(), "Jeff Anders", "5.6.55"));
  }

  public static MdiIcon dots_horizontal() {
    return MdiIcon.create(
        "mdi-dots-horizontal",
        new MdiMeta(
            "dots-horizontal",
            "F01D8",
            Arrays.asList(),
            Arrays.asList("more", "ellipsis-horizontal", "more-horiz", "menu"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon dots_horizontal_circle() {
    return MdiIcon.create(
        "mdi-dots-horizontal-circle",
        new MdiMeta(
            "dots-horizontal-circle",
            "F07C3",
            Arrays.asList(),
            Arrays.asList("ellipsis-horizontal-circle", "more-circle", "menu"),
            "Google",
            "2.0.46"));
  }

  public static MdiIcon dots_horizontal_circle_outline() {
    return MdiIcon.create(
        "mdi-dots-horizontal-circle-outline",
        new MdiMeta(
            "dots-horizontal-circle-outline",
            "F0B8D",
            Arrays.asList(),
            Arrays.asList("ellipsis-horizontal-circle-outline", "more-circle-outline", "menu"),
            "Michael Richins",
            "3.0.39"));
  }

  public static MdiIcon dots_square() {
    return MdiIcon.create(
        "mdi-dots-square",
        new MdiMeta(
            "dots-square",
            "F15FD",
            Arrays.asList(),
            Arrays.asList("perimeter"),
            "Jeff Anders",
            "5.6.55"));
  }

  public static MdiIcon dots_triangle() {
    return MdiIcon.create(
        "mdi-dots-triangle",
        new MdiMeta(
            "dots-triangle", "F15FE", Arrays.asList(), Arrays.asList(), "Jeff Anders", "5.6.55"));
  }

  public static MdiIcon dots_vertical() {
    return MdiIcon.create(
        "mdi-dots-vertical",
        new MdiMeta(
            "dots-vertical",
            "F01D9",
            Arrays.asList(),
            Arrays.asList("ellipsis-vertical", "more-vert", "menu"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon dots_vertical_circle() {
    return MdiIcon.create(
        "mdi-dots-vertical-circle",
        new MdiMeta(
            "dots-vertical-circle",
            "F07C4",
            Arrays.asList(),
            Arrays.asList("ellipsis-vertical-circle", "menu"),
            "Austin Andrews",
            "2.0.46"));
  }

  public static MdiIcon dots_vertical_circle_outline() {
    return MdiIcon.create(
        "mdi-dots-vertical-circle-outline",
        new MdiMeta(
            "dots-vertical-circle-outline",
            "F0B8E",
            Arrays.asList(),
            Arrays.asList("ellipsis-vertical-circle-outline", "menu"),
            "Michael Richins",
            "3.0.39"));
  }

  public static MdiIcon download() {
    return MdiIcon.create(
        "mdi-download",
        new MdiMeta(
            "download",
            "F01DA",
            Arrays.asList(),
            Arrays.asList("file-download", "get-app"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon download_box() {
    return MdiIcon.create(
        "mdi-download-box",
        new MdiMeta(
            "download-box", "F1462", Arrays.asList(), Arrays.asList(), "Austin Andrews", "5.2.45"));
  }

  public static MdiIcon download_box_outline() {
    return MdiIcon.create(
        "mdi-download-box-outline",
        new MdiMeta(
            "download-box-outline",
            "F1463",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "5.2.45"));
  }

  public static MdiIcon download_circle() {
    return MdiIcon.create(
        "mdi-download-circle",
        new MdiMeta(
            "download-circle",
            "F1464",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "5.2.45"));
  }

  public static MdiIcon download_circle_outline() {
    return MdiIcon.create(
        "mdi-download-circle-outline",
        new MdiMeta(
            "download-circle-outline",
            "F1465",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "5.2.45"));
  }

  public static MdiIcon download_lock() {
    return MdiIcon.create(
        "mdi-download-lock",
        new MdiMeta(
            "download-lock",
            "F1320",
            Arrays.asList("Lock"),
            Arrays.asList(),
            "Michael Richins",
            "4.9.95"));
  }

  public static MdiIcon download_lock_outline() {
    return MdiIcon.create(
        "mdi-download-lock-outline",
        new MdiMeta(
            "download-lock-outline",
            "F1321",
            Arrays.asList("Lock"),
            Arrays.asList(),
            "Michael Richins",
            "4.9.95"));
  }

  public static MdiIcon download_multiple() {
    return MdiIcon.create(
        "mdi-download-multiple",
        new MdiMeta(
            "download-multiple",
            "F09E9",
            Arrays.asList(),
            Arrays.asList("downloads"),
            "GreenTurtwig",
            "2.5.94"));
  }

  public static MdiIcon download_network() {
    return MdiIcon.create(
        "mdi-download-network",
        new MdiMeta(
            "download-network",
            "F06F4",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.8.36"));
  }

  public static MdiIcon download_network_outline() {
    return MdiIcon.create(
        "mdi-download-network-outline",
        new MdiMeta(
            "download-network-outline",
            "F0C66",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon download_off() {
    return MdiIcon.create(
        "mdi-download-off",
        new MdiMeta(
            "download-off",
            "F10B0",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.2.95"));
  }

  public static MdiIcon download_off_outline() {
    return MdiIcon.create(
        "mdi-download-off-outline",
        new MdiMeta(
            "download-off-outline",
            "F10B1",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.2.95"));
  }

  public static MdiIcon download_outline() {
    return MdiIcon.create(
        "mdi-download-outline",
        new MdiMeta(
            "download-outline", "F0B8F", Arrays.asList(), Arrays.asList(), "Google", "3.0.39"));
  }

  public static MdiIcon drag() {
    return MdiIcon.create(
        "mdi-drag",
        new MdiMeta("drag", "F01DB", Arrays.asList(), Arrays.asList(), "Austin Andrews", "1.5.54"));
  }

  public static MdiIcon drag_horizontal() {
    return MdiIcon.create(
        "mdi-drag-horizontal",
        new MdiMeta(
            "drag-horizontal",
            "F01DC",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon drag_horizontal_variant() {
    return MdiIcon.create(
        "mdi-drag-horizontal-variant",
        new MdiMeta(
            "drag-horizontal-variant",
            "F12F0",
            Arrays.asList(),
            Arrays.asList(),
            "Google",
            "4.8.95"));
  }

  public static MdiIcon drag_variant() {
    return MdiIcon.create(
        "mdi-drag-variant",
        new MdiMeta(
            "drag-variant", "F0B90", Arrays.asList(), Arrays.asList(), "Austin Andrews", "3.0.39"));
  }

  public static MdiIcon drag_vertical() {
    return MdiIcon.create(
        "mdi-drag-vertical",
        new MdiMeta(
            "drag-vertical",
            "F01DD",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon drag_vertical_variant() {
    return MdiIcon.create(
        "mdi-drag-vertical-variant",
        new MdiMeta(
            "drag-vertical-variant",
            "F12F1",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.8.95"));
  }

  public static MdiIcon drama_masks() {
    return MdiIcon.create(
        "mdi-drama-masks",
        new MdiMeta(
            "drama-masks",
            "F0D02",
            Arrays.asList(),
            Arrays.asList("comedy", "tragedy", "theatre"),
            "Augustin Ursu",
            "3.3.92"));
  }

  public static MdiIcon draw() {
    return MdiIcon.create(
        "mdi-draw",
        new MdiMeta(
            "draw",
            "F0F49",
            Arrays.asList("Drawing / Art", "Form"),
            Arrays.asList("sign", "signature"),
            "Michael Irigoyen",
            "3.9.97"));
  }

  public static MdiIcon draw_pen() {
    return MdiIcon.create(
        "mdi-draw-pen",
        new MdiMeta(
            "draw-pen",
            "F19B9",
            Arrays.asList("Form", "Drawing / Art"),
            Arrays.asList("sign", "signature"),
            "Michael Irigoyen",
            "6.5.95"));
  }

  public static MdiIcon drawing() {
    return MdiIcon.create(
        "mdi-drawing",
        new MdiMeta(
            "drawing",
            "F01DE",
            Arrays.asList("Drawing / Art", "Shape"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon drawing_box() {
    return MdiIcon.create(
        "mdi-drawing-box",
        new MdiMeta(
            "drawing-box",
            "F01DF",
            Arrays.asList("Drawing / Art", "Shape"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon dresser() {
    return MdiIcon.create(
        "mdi-dresser",
        new MdiMeta(
            "dresser",
            "F0F4A",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "GreenTurtwig",
            "3.9.97"));
  }

  public static MdiIcon dresser_outline() {
    return MdiIcon.create(
        "mdi-dresser-outline",
        new MdiMeta(
            "dresser-outline",
            "F0F4B",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "GreenTurtwig",
            "3.9.97"));
  }

  public static MdiIcon drone() {
    return MdiIcon.create(
        "mdi-drone",
        new MdiMeta(
            "drone",
            "F01E2",
            Arrays.asList("Transportation + Flying"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  @Deprecated
  public static MdiIcon dropbox() {
    return MdiIcon.create(
        "mdi-dropbox",
        new MdiMeta(
            "dropbox",
            "F01E3",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "1.5.54"));
  }

  @Deprecated
  public static MdiIcon drupal() {
    return MdiIcon.create(
        "mdi-drupal",
        new MdiMeta(
            "drupal",
            "F01E4",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "1.5.54"));
  }

  public static MdiIcon duck() {
    return MdiIcon.create(
        "mdi-duck",
        new MdiMeta(
            "duck", "F01E5", Arrays.asList("Animal"), Arrays.asList(), "Austin Andrews", "1.5.54"));
  }

  public static MdiIcon dumbbell() {
    return MdiIcon.create(
        "mdi-dumbbell",
        new MdiMeta(
            "dumbbell",
            "F01E6",
            Arrays.asList("Sport"),
            Arrays.asList("weights", "fitness-center", "gym", "barbell"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon dump_truck() {
    return MdiIcon.create(
        "mdi-dump-truck",
        new MdiMeta(
            "dump-truck",
            "F0C67",
            Arrays.asList("Transportation + Road", "Hardware / Tools"),
            Arrays.asList("tipper-lorry"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon ear_hearing() {
    return MdiIcon.create(
        "mdi-ear-hearing",
        new MdiMeta(
            "ear-hearing",
            "F07C5",
            Arrays.asList("Medical / Hospital"),
            Arrays.asList(),
            "Google",
            "2.0.46"));
  }

  public static MdiIcon ear_hearing_loop() {
    return MdiIcon.create(
        "mdi-ear-hearing-loop",
        new MdiMeta(
            "ear-hearing-loop",
            "F1AEE",
            Arrays.asList("Medical / Hospital"),
            Arrays.asList("audio-induction-loop", "telecoil"),
            "Michael Irigoyen",
            "6.8.96"));
  }

  public static MdiIcon ear_hearing_off() {
    return MdiIcon.create(
        "mdi-ear-hearing-off",
        new MdiMeta(
            "ear-hearing-off",
            "F0A45",
            Arrays.asList("Medical / Hospital"),
            Arrays.asList("hearing-impaired"),
            "Henrique César Madeira",
            "2.6.95"));
  }

  public static MdiIcon earbuds() {
    return MdiIcon.create(
        "mdi-earbuds",
        new MdiMeta(
            "earbuds",
            "F184F",
            Arrays.asList("Audio", "Music"),
            Arrays.asList("headphones"),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon earbuds_off() {
    return MdiIcon.create(
        "mdi-earbuds-off",
        new MdiMeta(
            "earbuds-off",
            "F1850",
            Arrays.asList("Audio", "Music"),
            Arrays.asList("headphones-off"),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon earbuds_off_outline() {
    return MdiIcon.create(
        "mdi-earbuds-off-outline",
        new MdiMeta(
            "earbuds-off-outline",
            "F1851",
            Arrays.asList("Audio", "Music"),
            Arrays.asList("headphones-off-outline"),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon earbuds_outline() {
    return MdiIcon.create(
        "mdi-earbuds-outline",
        new MdiMeta(
            "earbuds-outline",
            "F1852",
            Arrays.asList("Audio", "Music"),
            Arrays.asList("headphones-outline"),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon earth() {
    return MdiIcon.create(
        "mdi-earth",
        new MdiMeta(
            "earth",
            "F01E7",
            Arrays.asList("Geographic Information System", "Navigation"),
            Arrays.asList("globe", "public", "planet", "world"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon earth_arrow_right() {
    return MdiIcon.create(
        "mdi-earth-arrow-right",
        new MdiMeta(
            "earth-arrow-right",
            "F1311",
            Arrays.asList("Navigation"),
            Arrays.asList("globe-arrow-right", "world-arrow-right", "planet-arrow-right"),
            "Michael Irigoyen",
            "4.8.95"));
  }

  public static MdiIcon earth_box() {
    return MdiIcon.create(
        "mdi-earth-box",
        new MdiMeta(
            "earth-box",
            "F06CD",
            Arrays.asList("Navigation"),
            Arrays.asList("globe-box", "world-box", "planet-box"),
            "GreenTurtwig",
            "1.8.36"));
  }

  public static MdiIcon earth_box_minus() {
    return MdiIcon.create(
        "mdi-earth-box-minus",
        new MdiMeta(
            "earth-box-minus",
            "F1407",
            Arrays.asList("Navigation"),
            Arrays.asList("globe-box-minus", "world-box-minus", "planet-box-minus"),
            "Muhammet Balsoy",
            "5.1.45"));
  }

  public static MdiIcon earth_box_off() {
    return MdiIcon.create(
        "mdi-earth-box-off",
        new MdiMeta(
            "earth-box-off",
            "F06CE",
            Arrays.asList("Navigation"),
            Arrays.asList("globe-box-off", "world-box-off", "planet-box-off"),
            "GreenTurtwig",
            "1.8.36"));
  }

  public static MdiIcon earth_box_plus() {
    return MdiIcon.create(
        "mdi-earth-box-plus",
        new MdiMeta(
            "earth-box-plus",
            "F1406",
            Arrays.asList("Navigation"),
            Arrays.asList("globe-box-plus", "world-box-plus", "planet-box-plus"),
            "Muhammet Balsoy",
            "5.1.45"));
  }

  public static MdiIcon earth_box_remove() {
    return MdiIcon.create(
        "mdi-earth-box-remove",
        new MdiMeta(
            "earth-box-remove",
            "F1408",
            Arrays.asList("Navigation"),
            Arrays.asList("globe-box-remove", "world-box-remove", "planet-box-remove"),
            "Muhammet Balsoy",
            "5.1.45"));
  }

  public static MdiIcon earth_minus() {
    return MdiIcon.create(
        "mdi-earth-minus",
        new MdiMeta(
            "earth-minus",
            "F1404",
            Arrays.asList("Navigation"),
            Arrays.asList("globe-minus", "world-minus", "planet-minus"),
            "Muhammet Balsoy",
            "5.1.45"));
  }

  public static MdiIcon earth_off() {
    return MdiIcon.create(
        "mdi-earth-off",
        new MdiMeta(
            "earth-off",
            "F01E8",
            Arrays.asList("Geographic Information System", "Navigation"),
            Arrays.asList("globe-off", "world-off", "planet-off"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon earth_plus() {
    return MdiIcon.create(
        "mdi-earth-plus",
        new MdiMeta(
            "earth-plus",
            "F1403",
            Arrays.asList("Navigation"),
            Arrays.asList("globe-plus", "world-plus", "planet-plus"),
            "Muhammet Balsoy",
            "5.1.45"));
  }

  public static MdiIcon earth_remove() {
    return MdiIcon.create(
        "mdi-earth-remove",
        new MdiMeta(
            "earth-remove",
            "F1405",
            Arrays.asList("Navigation"),
            Arrays.asList("globe-remove", "world-remove", "planet-remove"),
            "Muhammet Balsoy",
            "5.1.45"));
  }

  public static MdiIcon egg() {
    return MdiIcon.create(
        "mdi-egg",
        new MdiMeta(
            "egg",
            "F0AAF",
            Arrays.asList("Food / Drink", "Agriculture"),
            Arrays.asList(),
            "Michael Richins",
            "2.7.94"));
  }

  public static MdiIcon egg_easter() {
    return MdiIcon.create(
        "mdi-egg-easter",
        new MdiMeta(
            "egg-easter",
            "F0AB0",
            Arrays.asList("Holiday"),
            Arrays.asList(),
            "Michael Richins",
            "2.7.94"));
  }

  public static MdiIcon egg_fried() {
    return MdiIcon.create(
        "mdi-egg-fried",
        new MdiMeta(
            "egg-fried",
            "F184A",
            Arrays.asList("Food / Drink"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.2.95"));
  }

  public static MdiIcon egg_off() {
    return MdiIcon.create(
        "mdi-egg-off",
        new MdiMeta(
            "egg-off",
            "F13F0",
            Arrays.asList("Food / Drink", "Agriculture"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.1.45"));
  }

  public static MdiIcon egg_off_outline() {
    return MdiIcon.create(
        "mdi-egg-off-outline",
        new MdiMeta(
            "egg-off-outline",
            "F13F1",
            Arrays.asList("Food / Drink", "Agriculture"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.1.45"));
  }

  public static MdiIcon egg_outline() {
    return MdiIcon.create(
        "mdi-egg-outline",
        new MdiMeta(
            "egg-outline",
            "F13F2",
            Arrays.asList("Food / Drink", "Agriculture"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.1.45"));
  }

  public static MdiIcon eiffel_tower() {
    return MdiIcon.create(
        "mdi-eiffel-tower",
        new MdiMeta(
            "eiffel-tower",
            "F156B",
            Arrays.asList("Places"),
            Arrays.asList("paris", "france"),
            "Nicolas Gres",
            "5.5.55"));
  }

  public static MdiIcon eight_track() {
    return MdiIcon.create(
        "mdi-eight-track",
        new MdiMeta(
            "eight-track",
            "F09EA",
            Arrays.asList("Music"),
            Arrays.asList("8-track"),
            "GreenTurtwig",
            "2.5.94"));
  }

  public static MdiIcon eject() {
    return MdiIcon.create(
        "mdi-eject",
        new MdiMeta("eject", "F01EA", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon eject_circle() {
    return MdiIcon.create(
        "mdi-eject-circle",
        new MdiMeta(
            "eject-circle",
            "F1B23",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.9.96"));
  }

  public static MdiIcon eject_circle_outline() {
    return MdiIcon.create(
        "mdi-eject-circle-outline",
        new MdiMeta(
            "eject-circle-outline",
            "F1B24",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.9.96"));
  }

  public static MdiIcon eject_outline() {
    return MdiIcon.create(
        "mdi-eject-outline",
        new MdiMeta(
            "eject-outline", "F0B91", Arrays.asList(), Arrays.asList(), "Google", "3.0.39"));
  }

  public static MdiIcon electric_switch() {
    return MdiIcon.create(
        "mdi-electric-switch",
        new MdiMeta(
            "electric-switch", "F0E9F", Arrays.asList(), Arrays.asList(), "Louistwee", "3.7.94"));
  }

  public static MdiIcon electric_switch_closed() {
    return MdiIcon.create(
        "mdi-electric-switch-closed",
        new MdiMeta(
            "electric-switch-closed",
            "F10D9",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.3.95"));
  }

  @Deprecated
  public static MdiIcon electron_framework() {
    return MdiIcon.create(
        "mdi-electron-framework",
        new MdiMeta(
            "electron-framework",
            "F1024",
            Arrays.asList("Brand / Logo", "Developer / Languages"),
            Arrays.asList(),
            "Contributors",
            "4.1.95"));
  }

  public static MdiIcon elephant() {
    return MdiIcon.create(
        "mdi-elephant",
        new MdiMeta(
            "elephant",
            "F07C6",
            Arrays.asList("Animal"),
            Arrays.asList(),
            "Contributors",
            "2.0.46"));
  }

  public static MdiIcon elevation_decline() {
    return MdiIcon.create(
        "mdi-elevation-decline",
        new MdiMeta(
            "elevation-decline",
            "F01EB",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon elevation_rise() {
    return MdiIcon.create(
        "mdi-elevation-rise",
        new MdiMeta(
            "elevation-rise",
            "F01EC",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon elevator() {
    return MdiIcon.create(
        "mdi-elevator",
        new MdiMeta(
            "elevator",
            "F01ED",
            Arrays.asList("Transportation + Other"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon elevator_down() {
    return MdiIcon.create(
        "mdi-elevator-down",
        new MdiMeta(
            "elevator-down",
            "F12C2",
            Arrays.asList("Transportation + Other"),
            Arrays.asList(),
            "Austin Andrews",
            "4.8.95"));
  }

  public static MdiIcon elevator_passenger() {
    return MdiIcon.create(
        "mdi-elevator-passenger",
        new MdiMeta(
            "elevator-passenger",
            "F1381",
            Arrays.asList("Transportation + Other"),
            Arrays.asList(),
            "Google",
            "4.9.95"));
  }

  public static MdiIcon elevator_passenger_off() {
    return MdiIcon.create(
        "mdi-elevator-passenger-off",
        new MdiMeta(
            "elevator-passenger-off",
            "F1979",
            Arrays.asList("Transportation + Other"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.5.95"));
  }

  public static MdiIcon elevator_passenger_off_outline() {
    return MdiIcon.create(
        "mdi-elevator-passenger-off-outline",
        new MdiMeta(
            "elevator-passenger-off-outline",
            "F197A",
            Arrays.asList("Transportation + Other"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.5.95"));
  }

  public static MdiIcon elevator_passenger_outline() {
    return MdiIcon.create(
        "mdi-elevator-passenger-outline",
        new MdiMeta(
            "elevator-passenger-outline",
            "F197B",
            Arrays.asList("Transportation + Other"),
            Arrays.asList(),
            "Google",
            "6.5.95"));
  }

  public static MdiIcon elevator_up() {
    return MdiIcon.create(
        "mdi-elevator-up",
        new MdiMeta(
            "elevator-up",
            "F12C1",
            Arrays.asList("Transportation + Other"),
            Arrays.asList(),
            "Austin Andrews",
            "4.8.95"));
  }

  public static MdiIcon ellipse() {
    return MdiIcon.create(
        "mdi-ellipse",
        new MdiMeta(
            "ellipse",
            "F0EA0",
            Arrays.asList("Shape"),
            Arrays.asList(),
            "Michael Richins",
            "3.7.94"));
  }

  public static MdiIcon ellipse_outline() {
    return MdiIcon.create(
        "mdi-ellipse-outline",
        new MdiMeta(
            "ellipse-outline",
            "F0EA1",
            Arrays.asList("Shape"),
            Arrays.asList(),
            "Michael Richins",
            "3.7.94"));
  }

  public static MdiIcon email() {
    return MdiIcon.create(
        "mdi-email",
        new MdiMeta(
            "email",
            "F01EE",
            Arrays.asList(),
            Arrays.asList("local-post-office", "mail", "markunread", "envelope"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon email_alert() {
    return MdiIcon.create(
        "mdi-email-alert",
        new MdiMeta(
            "email-alert",
            "F06CF",
            Arrays.asList("Alert / Error"),
            Arrays.asList("email-warning", "envelope-alert", "envelope-warning"),
            "Austin Andrews",
            "1.8.36"));
  }

  public static MdiIcon email_alert_outline() {
    return MdiIcon.create(
        "mdi-email-alert-outline",
        new MdiMeta(
            "email-alert-outline",
            "F0D42",
            Arrays.asList("Alert / Error"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.4.93"));
  }

  public static MdiIcon email_arrow_left() {
    return MdiIcon.create(
        "mdi-email-arrow-left",
        new MdiMeta(
            "email-arrow-left",
            "F10DA",
            Arrays.asList(),
            Arrays.asList("email-receive"),
            "Michael Richins",
            "4.3.95"));
  }

  public static MdiIcon email_arrow_left_outline() {
    return MdiIcon.create(
        "mdi-email-arrow-left-outline",
        new MdiMeta(
            "email-arrow-left-outline",
            "F10DB",
            Arrays.asList(),
            Arrays.asList("email-receive-outline"),
            "Michael Richins",
            "4.3.95"));
  }

  public static MdiIcon email_arrow_right() {
    return MdiIcon.create(
        "mdi-email-arrow-right",
        new MdiMeta(
            "email-arrow-right",
            "F10DC",
            Arrays.asList(),
            Arrays.asList("email-send"),
            "Michael Richins",
            "4.3.95"));
  }

  public static MdiIcon email_arrow_right_outline() {
    return MdiIcon.create(
        "mdi-email-arrow-right-outline",
        new MdiMeta(
            "email-arrow-right-outline",
            "F10DD",
            Arrays.asList(),
            Arrays.asList("email-arrow-right-outline"),
            "Michael Richins",
            "4.3.95"));
  }

  public static MdiIcon email_box() {
    return MdiIcon.create(
        "mdi-email-box",
        new MdiMeta(
            "email-box",
            "F0D03",
            Arrays.asList(),
            Arrays.asList("envelope-box"),
            "GreenTurtwig",
            "3.3.92"));
  }

  public static MdiIcon email_check() {
    return MdiIcon.create(
        "mdi-email-check",
        new MdiMeta(
            "email-check",
            "F0AB1",
            Arrays.asList(),
            Arrays.asList("email-tick"),
            "Andrew Nenakhov",
            "2.7.94"));
  }

  public static MdiIcon email_check_outline() {
    return MdiIcon.create(
        "mdi-email-check-outline",
        new MdiMeta(
            "email-check-outline",
            "F0AB2",
            Arrays.asList(),
            Arrays.asList("email-tick-outline"),
            "Andrew Nenakhov",
            "2.7.94"));
  }

  public static MdiIcon email_edit() {
    return MdiIcon.create(
        "mdi-email-edit",
        new MdiMeta(
            "email-edit",
            "F0EE3",
            Arrays.asList("Edit / Modify"),
            Arrays.asList(),
            "Michael Richins",
            "3.8.95"));
  }

  public static MdiIcon email_edit_outline() {
    return MdiIcon.create(
        "mdi-email-edit-outline",
        new MdiMeta(
            "email-edit-outline",
            "F0EE4",
            Arrays.asList("Edit / Modify"),
            Arrays.asList(),
            "Michael Richins",
            "3.8.95"));
  }

  public static MdiIcon email_fast() {
    return MdiIcon.create(
        "mdi-email-fast",
        new MdiMeta(
            "email-fast",
            "F186F",
            Arrays.asList(),
            Arrays.asList("envelope-fast", "email-quick", "email-sent", "email-send"),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon email_fast_outline() {
    return MdiIcon.create(
        "mdi-email-fast-outline",
        new MdiMeta(
            "email-fast-outline",
            "F1870",
            Arrays.asList(),
            Arrays.asList(
                "email-send-outline",
                "email-sent-outline",
                "envelope-fast-outline",
                "email-quick-outline"),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon email_heart_outline() {
    return MdiIcon.create(
        "mdi-email-heart-outline",
        new MdiMeta(
            "email-heart-outline",
            "F1C5B",
            Arrays.asList(),
            Arrays.asList("love-letter", "envelope-heart-outline", "greeting-card"),
            "Jeff Anders",
            "7.2.96"));
  }

  public static MdiIcon email_lock() {
    return MdiIcon.create(
        "mdi-email-lock",
        new MdiMeta(
            "email-lock",
            "F01F1",
            Arrays.asList("Lock"),
            Arrays.asList("envelope-secure", "email-secure", "envelope-lock"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon email_lock_outline() {
    return MdiIcon.create(
        "mdi-email-lock-outline",
        new MdiMeta(
            "email-lock-outline",
            "F1B61",
            Arrays.asList("Lock"),
            Arrays.asList("email-secure-outline"),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon email_mark_as_unread() {
    return MdiIcon.create(
        "mdi-email-mark-as-unread",
        new MdiMeta(
            "email-mark-as-unread", "F0B92", Arrays.asList(), Arrays.asList(), "Google", "3.0.39"));
  }

  public static MdiIcon email_minus() {
    return MdiIcon.create(
        "mdi-email-minus",
        new MdiMeta(
            "email-minus",
            "F0EE5",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.8.95"));
  }

  public static MdiIcon email_minus_outline() {
    return MdiIcon.create(
        "mdi-email-minus-outline",
        new MdiMeta(
            "email-minus-outline",
            "F0EE6",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.8.95"));
  }

  public static MdiIcon email_multiple() {
    return MdiIcon.create(
        "mdi-email-multiple",
        new MdiMeta(
            "email-multiple",
            "F0EE7",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "3.8.95"));
  }

  public static MdiIcon email_multiple_outline() {
    return MdiIcon.create(
        "mdi-email-multiple-outline",
        new MdiMeta(
            "email-multiple-outline",
            "F0EE8",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "3.8.95"));
  }

  public static MdiIcon email_newsletter() {
    return MdiIcon.create(
        "mdi-email-newsletter",
        new MdiMeta(
            "email-newsletter",
            "F0FB1",
            Arrays.asList(),
            Arrays.asList(),
            "GreenTurtwig",
            "4.0.96"));
  }

  public static MdiIcon email_off() {
    return MdiIcon.create(
        "mdi-email-off",
        new MdiMeta(
            "email-off", "F13E3", Arrays.asList(), Arrays.asList(), "Michael Irigoyen", "5.1.45"));
  }

  public static MdiIcon email_off_outline() {
    return MdiIcon.create(
        "mdi-email-off-outline",
        new MdiMeta(
            "email-off-outline",
            "F13E4",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.1.45"));
  }

  public static MdiIcon email_open() {
    return MdiIcon.create(
        "mdi-email-open",
        new MdiMeta(
            "email-open",
            "F01EF",
            Arrays.asList(),
            Arrays.asList("drafts", "envelope-open"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon email_open_heart_outline() {
    return MdiIcon.create(
        "mdi-email-open-heart-outline",
        new MdiMeta(
            "email-open-heart-outline",
            "F1C5C",
            Arrays.asList(),
            Arrays.asList("love-letter-open", "greeting-card-open", "envelope-open-heart-outline"),
            "Jeff Anders",
            "7.2.96"));
  }

  public static MdiIcon email_open_multiple() {
    return MdiIcon.create(
        "mdi-email-open-multiple",
        new MdiMeta(
            "email-open-multiple",
            "F0EE9",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "3.8.95"));
  }

  public static MdiIcon email_open_multiple_outline() {
    return MdiIcon.create(
        "mdi-email-open-multiple-outline",
        new MdiMeta(
            "email-open-multiple-outline",
            "F0EEA",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "3.8.95"));
  }

  public static MdiIcon email_open_outline() {
    return MdiIcon.create(
        "mdi-email-open-outline",
        new MdiMeta(
            "email-open-outline",
            "F05EF",
            Arrays.asList(),
            Arrays.asList("envelope-open-outline"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon email_outline() {
    return MdiIcon.create(
        "mdi-email-outline",
        new MdiMeta(
            "email-outline",
            "F01F0",
            Arrays.asList(),
            Arrays.asList("mail-outline", "envelope-outline"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon email_plus() {
    return MdiIcon.create(
        "mdi-email-plus",
        new MdiMeta(
            "email-plus",
            "F09EB",
            Arrays.asList(),
            Arrays.asList("email-add", "envelope-add", "envelope-plus"),
            "GreenTurtwig",
            "2.5.94"));
  }

  public static MdiIcon email_plus_outline() {
    return MdiIcon.create(
        "mdi-email-plus-outline",
        new MdiMeta(
            "email-plus-outline",
            "F09EC",
            Arrays.asList(),
            Arrays.asList("email-add-outline", "envelope-add-outline", "envelope-plus-outline"),
            "GreenTurtwig",
            "2.5.94"));
  }

  public static MdiIcon email_remove() {
    return MdiIcon.create(
        "mdi-email-remove",
        new MdiMeta(
            "email-remove",
            "F1661",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon email_remove_outline() {
    return MdiIcon.create(
        "mdi-email-remove-outline",
        new MdiMeta(
            "email-remove-outline",
            "F1662",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.7.55"));
  }

  public static MdiIcon email_seal() {
    return MdiIcon.create(
        "mdi-email-seal",
        new MdiMeta(
            "email-seal",
            "F195B",
            Arrays.asList(),
            Arrays.asList(
                "email-certified",
                "mail-certified",
                "mail-seal",
                "email-verified",
                "mail-verified"),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon email_seal_outline() {
    return MdiIcon.create(
        "mdi-email-seal-outline",
        new MdiMeta(
            "email-seal-outline",
            "F195C",
            Arrays.asList(),
            Arrays.asList(
                "email-verified-outline",
                "email-certified-outline",
                "mail-verified-outline",
                "mail-certified-outline",
                "mail-seal-outline"),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon email_search() {
    return MdiIcon.create(
        "mdi-email-search",
        new MdiMeta(
            "email-search", "F0961", Arrays.asList(), Arrays.asList(), "GreenTurtwig", "2.4.85"));
  }

  public static MdiIcon email_search_outline() {
    return MdiIcon.create(
        "mdi-email-search-outline",
        new MdiMeta(
            "email-search-outline",
            "F0962",
            Arrays.asList(),
            Arrays.asList(),
            "GreenTurtwig",
            "2.4.85"));
  }

  public static MdiIcon email_sync() {
    return MdiIcon.create(
        "mdi-email-sync",
        new MdiMeta(
            "email-sync",
            "F12C7",
            Arrays.asList(),
            Arrays.asList("email-refresh", "email-resend"),
            "Simran",
            "4.8.95"));
  }

  public static MdiIcon email_sync_outline() {
    return MdiIcon.create(
        "mdi-email-sync-outline",
        new MdiMeta(
            "email-sync-outline",
            "F12C8",
            Arrays.asList(),
            Arrays.asList("email-refresh-outline", "email-resend-outline"),
            "Simran",
            "4.8.95"));
  }

  public static MdiIcon email_variant() {
    return MdiIcon.create(
        "mdi-email-variant",
        new MdiMeta(
            "email-variant",
            "F05F0",
            Arrays.asList(),
            Arrays.asList("envelope-variant"),
            "Austin Andrews",
            "1.5.54"));
  }

  @Deprecated
  public static MdiIcon ember() {
    return MdiIcon.create(
        "mdi-ember",
        new MdiMeta(
            "ember",
            "F0B30",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "2.8.94"));
  }

  @Deprecated
  public static MdiIcon emby() {
    return MdiIcon.create(
        "mdi-emby",
        new MdiMeta(
            "emby",
            "F06B4",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "1.7.22"));
  }

  public static MdiIcon emoticon() {
    return MdiIcon.create(
        "mdi-emoticon",
        new MdiMeta(
            "emoticon",
            "F0C68",
            Arrays.asList("Emoji"),
            Arrays.asList("smiley", "face", "emoji"),
            "Google",
            "3.2.89"));
  }

  public static MdiIcon emoticon_angry() {
    return MdiIcon.create(
        "mdi-emoticon-angry",
        new MdiMeta(
            "emoticon-angry",
            "F0C69",
            Arrays.asList("Emoji"),
            Arrays.asList("smiley-angry", "face-angry", "emoji-angry"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon emoticon_angry_outline() {
    return MdiIcon.create(
        "mdi-emoticon-angry-outline",
        new MdiMeta(
            "emoticon-angry-outline",
            "F0C6A",
            Arrays.asList("Emoji"),
            Arrays.asList("smiley-angry-outline", "face-angry-outline", "emoji-angry-outline"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon emoticon_confused() {
    return MdiIcon.create(
        "mdi-emoticon-confused",
        new MdiMeta(
            "emoticon-confused",
            "F10DE",
            Arrays.asList("Emoji"),
            Arrays.asList("face-confused", "emoji-confused"),
            "Michael Richins",
            "4.3.95"));
  }

  public static MdiIcon emoticon_confused_outline() {
    return MdiIcon.create(
        "mdi-emoticon-confused-outline",
        new MdiMeta(
            "emoticon-confused-outline",
            "F10DF",
            Arrays.asList("Emoji"),
            Arrays.asList("face-confused-outline", "emoji-confused-outline"),
            "Michael Richins",
            "4.3.95"));
  }

  public static MdiIcon emoticon_cool() {
    return MdiIcon.create(
        "mdi-emoticon-cool",
        new MdiMeta(
            "emoticon-cool",
            "F0C6B",
            Arrays.asList("Emoji"),
            Arrays.asList("smiley-cool", "face-cool", "face-sunglasses", "emoji-cool"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon emoticon_cool_outline() {
    return MdiIcon.create(
        "mdi-emoticon-cool-outline",
        new MdiMeta(
            "emoticon-cool-outline",
            "F01F3",
            Arrays.asList("Emoji"),
            Arrays.asList(
                "smiley-cool-outline",
                "face-cool-outline",
                "face-sunglasses-outline",
                "emoji-cool-outline"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon emoticon_cry() {
    return MdiIcon.create(
        "mdi-emoticon-cry",
        new MdiMeta(
            "emoticon-cry",
            "F0C6C",
            Arrays.asList("Emoji"),
            Arrays.asList("smiley-cry", "face-cry", "emoji-cry"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon emoticon_cry_outline() {
    return MdiIcon.create(
        "mdi-emoticon-cry-outline",
        new MdiMeta(
            "emoticon-cry-outline",
            "F0C6D",
            Arrays.asList("Emoji"),
            Arrays.asList("smiley-cry-outline", "face-cry-outline", "emoji-cry-outline"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon emoticon_dead() {
    return MdiIcon.create(
        "mdi-emoticon-dead",
        new MdiMeta(
            "emoticon-dead",
            "F0C6E",
            Arrays.asList("Emoji"),
            Arrays.asList("smiley-dead", "face-dead", "emoji-dead"),
            "Google",
            "3.2.89"));
  }

  public static MdiIcon emoticon_dead_outline() {
    return MdiIcon.create(
        "mdi-emoticon-dead-outline",
        new MdiMeta(
            "emoticon-dead-outline",
            "F069B",
            Arrays.asList("Emoji"),
            Arrays.asList("smiley-dead-outline", "face-dead-outline", "emoji-dead-outline"),
            "Google",
            "1.7.12"));
  }

  public static MdiIcon emoticon_devil() {
    return MdiIcon.create(
        "mdi-emoticon-devil",
        new MdiMeta(
            "emoticon-devil",
            "F0C6F",
            Arrays.asList("Emoji"),
            Arrays.asList("smiley-devil", "face-devil", "emoji-devil"),
            "Austin Andrews",
            "3.2.89"));
  }

  public static MdiIcon emoticon_devil_outline() {
    return MdiIcon.create(
        "mdi-emoticon-devil-outline",
        new MdiMeta(
            "emoticon-devil-outline",
            "F01F4",
            Arrays.asList("Emoji"),
            Arrays.asList("smiley-devil-outline", "face-devil-outline", "emoji-devil-outline"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon emoticon_excited() {
    return MdiIcon.create(
        "mdi-emoticon-excited",
        new MdiMeta(
            "emoticon-excited",
            "F0C70",
            Arrays.asList("Emoji"),
            Arrays.asList("smiley-excited", "face-excited", "emoji-excited"),
            "Google",
            "3.2.89"));
  }

  public static MdiIcon emoticon_excited_outline() {
    return MdiIcon.create(
        "mdi-emoticon-excited-outline",
        new MdiMeta(
            "emoticon-excited-outline",
            "F069C",
            Arrays.asList("Emoji"),
            Arrays.asList(
                "smiley-excited-outline", "face-excited-outline", "emoji-excited-outline"),
            "Google",
            "1.7.12"));
  }

  public static MdiIcon emoticon_frown() {
    return MdiIcon.create(
        "mdi-emoticon-frown",
        new MdiMeta(
            "emoticon-frown",
            "F0F4C",
            Arrays.asList("Emoji"),
            Arrays.asList("face-frown", "emoji-frown"),
            "Michael Irigoyen",
            "3.9.97"));
  }

  public static MdiIcon emoticon_frown_outline() {
    return MdiIcon.create(
        "mdi-emoticon-frown-outline",
        new MdiMeta(
            "emoticon-frown-outline",
            "F0F4D",
            Arrays.asList("Emoji"),
            Arrays.asList("face-frown-outline", "emoji-frown-outline"),
            "Google",
            "3.9.97"));
  }

  public static MdiIcon emoticon_happy() {
    return MdiIcon.create(
        "mdi-emoticon-happy",
        new MdiMeta(
            "emoticon-happy",
            "F0C71",
            Arrays.asList("Emoji"),
            Arrays.asList("smiley-happy", "face-happy", "emoji-happy"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon emoticon_happy_outline() {
    return MdiIcon.create(
        "mdi-emoticon-happy-outline",
        new MdiMeta(
            "emoticon-happy-outline",
            "F01F5",
            Arrays.asList("Emoji"),
            Arrays.asList("smiley-happy-outline", "face-happy-outline", "emoji-happy-outline"),
            "Gabriel",
            "1.5.54"));
  }

  public static MdiIcon emoticon_kiss() {
    return MdiIcon.create(
        "mdi-emoticon-kiss",
        new MdiMeta(
            "emoticon-kiss",
            "F0C72",
            Arrays.asList("Emoji"),
            Arrays.asList("smiley-kiss", "face-kiss", "emoji-kiss"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon emoticon_kiss_outline() {
    return MdiIcon.create(
        "mdi-emoticon-kiss-outline",
        new MdiMeta(
            "emoticon-kiss-outline",
            "F0C73",
            Arrays.asList("Emoji"),
            Arrays.asList("smiley-kiss-outline", "face-kiss-outline", "emoji-kiss-outline"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon emoticon_lol() {
    return MdiIcon.create(
        "mdi-emoticon-lol",
        new MdiMeta(
            "emoticon-lol",
            "F1214",
            Arrays.asList("Emoji"),
            Arrays.asList("face-lol", "emoji-lol"),
            "Michael Richins",
            "4.6.95"));
  }

  public static MdiIcon emoticon_lol_outline() {
    return MdiIcon.create(
        "mdi-emoticon-lol-outline",
        new MdiMeta(
            "emoticon-lol-outline",
            "F1215",
            Arrays.asList("Emoji"),
            Arrays.asList("face-lol-outline", "emoji-lol-outline"),
            "Michael Richins",
            "4.6.95"));
  }

  public static MdiIcon emoticon_neutral() {
    return MdiIcon.create(
        "mdi-emoticon-neutral",
        new MdiMeta(
            "emoticon-neutral",
            "F0C74",
            Arrays.asList("Emoji"),
            Arrays.asList("smiley-neutral", "face-neutral", "emoji-neutral"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon emoticon_neutral_outline() {
    return MdiIcon.create(
        "mdi-emoticon-neutral-outline",
        new MdiMeta(
            "emoticon-neutral-outline",
            "F01F6",
            Arrays.asList("Emoji"),
            Arrays.asList(
                "smiley-neutral-outline", "face-neutral-outline", "emoji-neutral-outline"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon emoticon_outline() {
    return MdiIcon.create(
        "mdi-emoticon-outline",
        new MdiMeta(
            "emoticon-outline",
            "F01F2",
            Arrays.asList("Emoji"),
            Arrays.asList(
                "insert-emoticon",
                "mood",
                "sentiment-very-satisfied",
                "tag-faces",
                "smiley-outline",
                "face-outline",
                "emoji-outline"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon emoticon_poop() {
    return MdiIcon.create(
        "mdi-emoticon-poop",
        new MdiMeta(
            "emoticon-poop",
            "F01F7",
            Arrays.asList("Emoji"),
            Arrays.asList("smiley-poop", "face-poop", "emoji-poop"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon emoticon_poop_outline() {
    return MdiIcon.create(
        "mdi-emoticon-poop-outline",
        new MdiMeta(
            "emoticon-poop-outline",
            "F0C75",
            Arrays.asList("Emoji"),
            Arrays.asList("face-poop-outline", "emoji-poop-outline"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon emoticon_sad() {
    return MdiIcon.create(
        "mdi-emoticon-sad",
        new MdiMeta(
            "emoticon-sad",
            "F0C76",
            Arrays.asList("Emoji"),
            Arrays.asList("smiley-sad", "face-sad", "emoji-sad"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon emoticon_sad_outline() {
    return MdiIcon.create(
        "mdi-emoticon-sad-outline",
        new MdiMeta(
            "emoticon-sad-outline",
            "F01F8",
            Arrays.asList("Emoji"),
            Arrays.asList("smiley-sad-outline", "face-sad-outline", "emoji-sad-outline"),
            "Gabriel",
            "1.5.54"));
  }

  public static MdiIcon emoticon_sick() {
    return MdiIcon.create(
        "mdi-emoticon-sick",
        new MdiMeta(
            "emoticon-sick",
            "F157C",
            Arrays.asList("Emoji", "Medical / Hospital"),
            Arrays.asList("face-sick", "fever", "emoji-sick"),
            "Google",
            "5.5.55"));
  }

  public static MdiIcon emoticon_sick_outline() {
    return MdiIcon.create(
        "mdi-emoticon-sick-outline",
        new MdiMeta(
            "emoticon-sick-outline",
            "F157D",
            Arrays.asList("Emoji", "Medical / Hospital"),
            Arrays.asList("face-sick-outline", "fever-outline", "emoji-sick-outline"),
            "Google",
            "5.5.55"));
  }

  public static MdiIcon emoticon_tongue() {
    return MdiIcon.create(
        "mdi-emoticon-tongue",
        new MdiMeta(
            "emoticon-tongue",
            "F01F9",
            Arrays.asList("Emoji"),
            Arrays.asList("smiley-tongue", "face-tongue", "emoji-tongue"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon emoticon_tongue_outline() {
    return MdiIcon.create(
        "mdi-emoticon-tongue-outline",
        new MdiMeta(
            "emoticon-tongue-outline",
            "F0C77",
            Arrays.asList("Emoji"),
            Arrays.asList("smiley-tongue-outline", "face-tongue-outline", "emoji-tongue-outline"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon emoticon_wink() {
    return MdiIcon.create(
        "mdi-emoticon-wink",
        new MdiMeta(
            "emoticon-wink",
            "F0C78",
            Arrays.asList("Emoji"),
            Arrays.asList("smiley-wink", "face-wink", "emoji-wink"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon emoticon_wink_outline() {
    return MdiIcon.create(
        "mdi-emoticon-wink-outline",
        new MdiMeta(
            "emoticon-wink-outline",
            "F0C79",
            Arrays.asList("Emoji"),
            Arrays.asList("smiley-wink-outline", "face-wink-outline", "emoji-wink-outline"),
            "Michael Irigoyen",
            "3.2.89"));
  }

  public static MdiIcon engine() {
    return MdiIcon.create(
        "mdi-engine",
        new MdiMeta(
            "engine",
            "F01FA",
            Arrays.asList("Automotive"),
            Arrays.asList("motor"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon engine_off() {
    return MdiIcon.create(
        "mdi-engine-off",
        new MdiMeta(
            "engine-off",
            "F0A46",
            Arrays.asList("Automotive"),
            Arrays.asList("motor-off"),
            "Michael Irigoyen",
            "2.6.95"));
  }

  public static MdiIcon engine_off_outline() {
    return MdiIcon.create(
        "mdi-engine-off-outline",
        new MdiMeta(
            "engine-off-outline",
            "F0A47",
            Arrays.asList("Automotive"),
            Arrays.asList("motor-off-outline"),
            "Michael Irigoyen",
            "2.6.95"));
  }

  public static MdiIcon engine_outline() {
    return MdiIcon.create(
        "mdi-engine-outline",
        new MdiMeta(
            "engine-outline",
            "F01FB",
            Arrays.asList("Automotive"),
            Arrays.asList("motor-outline"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon epsilon() {
    return MdiIcon.create(
        "mdi-epsilon",
        new MdiMeta(
            "epsilon",
            "F10E0",
            Arrays.asList("Alpha / Numeric"),
            Arrays.asList(),
            "Sascha Wohlgemuth",
            "4.3.95"));
  }

  public static MdiIcon equal() {
    return MdiIcon.create(
        "mdi-equal",
        new MdiMeta(
            "equal", "F01FC", Arrays.asList("Math"), Arrays.asList(), "Austin Andrews", "1.5.54"));
  }

  public static MdiIcon equal_box() {
    return MdiIcon.create(
        "mdi-equal-box",
        new MdiMeta(
            "equal-box",
            "F01FD",
            Arrays.asList("Math"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon equalizer() {
    return MdiIcon.create(
        "mdi-equalizer",
        new MdiMeta(
            "equalizer", "F0EA2", Arrays.asList("Audio"), Arrays.asList(), "Google", "3.7.94"));
  }

  public static MdiIcon equalizer_outline() {
    return MdiIcon.create(
        "mdi-equalizer-outline",
        new MdiMeta(
            "equalizer-outline",
            "F0EA3",
            Arrays.asList("Audio"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.7.94"));
  }

  public static MdiIcon eraser() {
    return MdiIcon.create(
        "mdi-eraser",
        new MdiMeta(
            "eraser", "F01FE", Arrays.asList(), Arrays.asList(), "Austin Andrews", "1.5.54"));
  }

  public static MdiIcon eraser_variant() {
    return MdiIcon.create(
        "mdi-eraser-variant",
        new MdiMeta(
            "eraser-variant", "F0642", Arrays.asList(), Arrays.asList(), "Google", "1.6.50"));
  }

  public static MdiIcon escalator() {
    return MdiIcon.create(
        "mdi-escalator",
        new MdiMeta(
            "escalator",
            "F01FF",
            Arrays.asList("Transportation + Other"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon escalator_box() {
    return MdiIcon.create(
        "mdi-escalator-box",
        new MdiMeta(
            "escalator-box",
            "F1399",
            Arrays.asList(),
            Arrays.asList(),
            "Moma Design Studio",
            "5.0.45"));
  }

  public static MdiIcon escalator_down() {
    return MdiIcon.create(
        "mdi-escalator-down",
        new MdiMeta(
            "escalator-down",
            "F12C0",
            Arrays.asList("Transportation + Other"),
            Arrays.asList(),
            "Austin Andrews",
            "4.8.95"));
  }

  public static MdiIcon escalator_up() {
    return MdiIcon.create(
        "mdi-escalator-up",
        new MdiMeta(
            "escalator-up",
            "F12BF",
            Arrays.asList("Transportation + Other"),
            Arrays.asList(),
            "Austin Andrews",
            "4.8.95"));
  }

  @Deprecated
  public static MdiIcon eslint() {
    return MdiIcon.create(
        "mdi-eslint",
        new MdiMeta(
            "eslint",
            "F0C7A",
            Arrays.asList("Developer / Languages", "Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "3.2.89"));
  }

  public static MdiIcon et() {
    return MdiIcon.create(
        "mdi-et",
        new MdiMeta("et", "F0AB3", Arrays.asList(), Arrays.asList(), "Michael Irigoyen", "2.7.94"));
  }

  @Deprecated
  public static MdiIcon ethereum() {
    return MdiIcon.create(
        "mdi-ethereum",
        new MdiMeta(
            "ethereum",
            "F086A",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "2.1.99"));
  }

  public static MdiIcon ethernet() {
    return MdiIcon.create(
        "mdi-ethernet",
        new MdiMeta("ethernet", "F0200", Arrays.asList(), Arrays.asList(), "Simran", "1.5.54"));
  }

  public static MdiIcon ethernet_cable() {
    return MdiIcon.create(
        "mdi-ethernet-cable",
        new MdiMeta(
            "ethernet-cable", "F0201", Arrays.asList(), Arrays.asList(), "Simran", "1.5.54"));
  }

  public static MdiIcon ethernet_cable_off() {
    return MdiIcon.create(
        "mdi-ethernet-cable-off",
        new MdiMeta(
            "ethernet-cable-off", "F0202", Arrays.asList(), Arrays.asList(), "Simran", "1.5.54"));
  }

  public static MdiIcon ev_plug_ccs1() {
    return MdiIcon.create(
        "mdi-ev-plug-ccs1",
        new MdiMeta(
            "ev-plug-ccs1",
            "F1519",
            Arrays.asList("Automotive"),
            Arrays.asList("ev-plug-ccs-combo-1", "ev-charger-ccs1"),
            "Michael Irigoyen",
            "5.4.55"));
  }

  public static MdiIcon ev_plug_ccs2() {
    return MdiIcon.create(
        "mdi-ev-plug-ccs2",
        new MdiMeta(
            "ev-plug-ccs2",
            "F151A",
            Arrays.asList("Automotive"),
            Arrays.asList("ev-plug-ccs-combo-2", "ev-charger-ccs2"),
            "Michael Irigoyen",
            "5.4.55"));
  }

  public static MdiIcon ev_plug_chademo() {
    return MdiIcon.create(
        "mdi-ev-plug-chademo",
        new MdiMeta(
            "ev-plug-chademo",
            "F151B",
            Arrays.asList("Automotive"),
            Arrays.asList("ev-charger-chademo"),
            "Michael Irigoyen",
            "5.4.55"));
  }

  public static MdiIcon ev_plug_tesla() {
    return MdiIcon.create(
        "mdi-ev-plug-tesla",
        new MdiMeta(
            "ev-plug-tesla",
            "F151C",
            Arrays.asList("Automotive"),
            Arrays.asList("ev-charger-tesla"),
            "Michael Irigoyen",
            "5.4.55"));
  }

  public static MdiIcon ev_plug_type1() {
    return MdiIcon.create(
        "mdi-ev-plug-type1",
        new MdiMeta(
            "ev-plug-type1",
            "F151D",
            Arrays.asList("Automotive"),
            Arrays.asList("ev-plug-j1772", "ev-charger-type1"),
            "Michael Irigoyen",
            "5.4.55"));
  }

  public static MdiIcon ev_plug_type2() {
    return MdiIcon.create(
        "mdi-ev-plug-type2",
        new MdiMeta(
            "ev-plug-type2",
            "F151E",
            Arrays.asList("Automotive"),
            Arrays.asList("ev-plug-mennekes", "ev-charger-type2"),
            "Michael Irigoyen",
            "5.4.55"));
  }

  public static MdiIcon ev_station() {
    return MdiIcon.create(
        "mdi-ev-station",
        new MdiMeta(
            "ev-station",
            "F05F1",
            Arrays.asList("Places", "Automotive"),
            Arrays.asList(
                "charging-station",
                "ev-charger",
                "wall-charger",
                "wallbox",
                "electric-vehicle-charger",
                "evse",
                "electric-charger"),
            "Google",
            "1.5.54"));
  }

  @Deprecated
  public static MdiIcon evernote() {
    return MdiIcon.create(
        "mdi-evernote",
        new MdiMeta(
            "evernote",
            "F0204",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "1.5.54"));
  }

  public static MdiIcon excavator() {
    return MdiIcon.create(
        "mdi-excavator",
        new MdiMeta(
            "excavator",
            "F1025",
            Arrays.asList("Hardware / Tools"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.1.95"));
  }

  public static MdiIcon exclamation() {
    return MdiIcon.create(
        "mdi-exclamation",
        new MdiMeta(
            "exclamation",
            "F0205",
            Arrays.asList("Math"),
            Arrays.asList("factorial"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon exclamation_thick() {
    return MdiIcon.create(
        "mdi-exclamation-thick",
        new MdiMeta(
            "exclamation-thick",
            "F1238",
            Arrays.asList(),
            Arrays.asList("exclamation-bold"),
            "frankgrinaert",
            "4.6.95"));
  }

  public static MdiIcon exit_run() {
    return MdiIcon.create(
        "mdi-exit-run",
        new MdiMeta(
            "exit-run",
            "F0A48",
            Arrays.asList("Home Automation"),
            Arrays.asList("emergency-exit"),
            "Simran",
            "2.6.95"));
  }

  public static MdiIcon exit_to_app() {
    return MdiIcon.create(
        "mdi-exit-to-app",
        new MdiMeta("exit-to-app", "F0206", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon expand_all() {
    return MdiIcon.create(
        "mdi-expand-all",
        new MdiMeta(
            "expand-all",
            "F0AB4",
            Arrays.asList(),
            Arrays.asList("animation-plus"),
            "Michael Irigoyen",
            "2.7.94"));
  }

  public static MdiIcon expand_all_outline() {
    return MdiIcon.create(
        "mdi-expand-all-outline",
        new MdiMeta(
            "expand-all-outline",
            "F0AB5",
            Arrays.asList(),
            Arrays.asList("animation-plus-outline"),
            "Michael Irigoyen",
            "2.7.94"));
  }

  public static MdiIcon expansion_card() {
    return MdiIcon.create(
        "mdi-expansion-card",
        new MdiMeta(
            "expansion-card",
            "F08AE",
            Arrays.asList("Gaming / RPG"),
            Arrays.asList("gpu", "graphics-processing-unit", "nic", "network-interface-card"),
            "GreenTurtwig",
            "2.2.43"));
  }

  public static MdiIcon expansion_card_variant() {
    return MdiIcon.create(
        "mdi-expansion-card-variant",
        new MdiMeta(
            "expansion-card-variant",
            "F0FB2",
            Arrays.asList(),
            Arrays.asList("graphics-processing-unit", "gpu", "network-interface-card", "nice"),
            "Michael Richins",
            "4.0.96"));
  }

  public static MdiIcon exponent() {
    return MdiIcon.create(
        "mdi-exponent",
        new MdiMeta(
            "exponent", "F0963", Arrays.asList("Math"), Arrays.asList("power"), "Nick", "2.4.85"));
  }

  public static MdiIcon exponent_box() {
    return MdiIcon.create(
        "mdi-exponent-box",
        new MdiMeta(
            "exponent-box",
            "F0964",
            Arrays.asList("Math"),
            Arrays.asList("power-box"),
            "Nick",
            "2.4.85"));
  }

  public static MdiIcon export() {
    return MdiIcon.create(
        "mdi-export",
        new MdiMeta(
            "export",
            "F0207",
            Arrays.asList(),
            Arrays.asList("output"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon export_variant() {
    return MdiIcon.create(
        "mdi-export-variant",
        new MdiMeta(
            "export-variant",
            "F0B93",
            Arrays.asList(),
            Arrays.asList("ios-share"),
            "Google",
            "3.0.39"));
  }

  public static MdiIcon eye() {
    return MdiIcon.create(
        "mdi-eye",
        new MdiMeta(
            "eye",
            "F0208",
            Arrays.asList(),
            Arrays.asList("show", "visibility", "remove-red-eye"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon eye_arrow_left() {
    return MdiIcon.create(
        "mdi-eye-arrow-left",
        new MdiMeta(
            "eye-arrow-left",
            "F18FD",
            Arrays.asList(),
            Arrays.asList("view-arrow-left"),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon eye_arrow_left_outline() {
    return MdiIcon.create(
        "mdi-eye-arrow-left-outline",
        new MdiMeta(
            "eye-arrow-left-outline",
            "F18FE",
            Arrays.asList(),
            Arrays.asList("view-arrow-left-outline"),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon eye_arrow_right() {
    return MdiIcon.create(
        "mdi-eye-arrow-right",
        new MdiMeta(
            "eye-arrow-right",
            "F18FF",
            Arrays.asList(),
            Arrays.asList("view-arrow-right"),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon eye_arrow_right_outline() {
    return MdiIcon.create(
        "mdi-eye-arrow-right-outline",
        new MdiMeta(
            "eye-arrow-right-outline",
            "F1900",
            Arrays.asList(),
            Arrays.asList("view-arrow-right-outline"),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon eye_check() {
    return MdiIcon.create(
        "mdi-eye-check",
        new MdiMeta(
            "eye-check",
            "F0D04",
            Arrays.asList(),
            Arrays.asList("eye-tick"),
            "Austin Andrews",
            "3.3.92"));
  }

  public static MdiIcon eye_check_outline() {
    return MdiIcon.create(
        "mdi-eye-check-outline",
        new MdiMeta(
            "eye-check-outline",
            "F0D05",
            Arrays.asList(),
            Arrays.asList("eye-tick-outline"),
            "Austin Andrews",
            "3.3.92"));
  }

  public static MdiIcon eye_circle() {
    return MdiIcon.create(
        "mdi-eye-circle",
        new MdiMeta(
            "eye-circle", "F0B94", Arrays.asList(), Arrays.asList(), "Michael Richins", "3.0.39"));
  }

  public static MdiIcon eye_circle_outline() {
    return MdiIcon.create(
        "mdi-eye-circle-outline",
        new MdiMeta(
            "eye-circle-outline",
            "F0B95",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "3.0.39"));
  }

  public static MdiIcon eye_lock() {
    return MdiIcon.create(
        "mdi-eye-lock",
        new MdiMeta(
            "eye-lock", "F1C06", Arrays.asList(), Arrays.asList(), "Michael Irigoyen", "7.1.96"));
  }

  public static MdiIcon eye_lock_open() {
    return MdiIcon.create(
        "mdi-eye-lock-open",
        new MdiMeta(
            "eye-lock-open",
            "F1C07",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.1.96"));
  }

  public static MdiIcon eye_lock_open_outline() {
    return MdiIcon.create(
        "mdi-eye-lock-open-outline",
        new MdiMeta(
            "eye-lock-open-outline",
            "F1C08",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.1.96"));
  }

  public static MdiIcon eye_lock_outline() {
    return MdiIcon.create(
        "mdi-eye-lock-outline",
        new MdiMeta(
            "eye-lock-outline",
            "F1C09",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.1.96"));
  }

  public static MdiIcon eye_minus() {
    return MdiIcon.create(
        "mdi-eye-minus",
        new MdiMeta(
            "eye-minus", "F1026", Arrays.asList(), Arrays.asList(), "Michael Irigoyen", "4.1.95"));
  }

  public static MdiIcon eye_minus_outline() {
    return MdiIcon.create(
        "mdi-eye-minus-outline",
        new MdiMeta(
            "eye-minus-outline",
            "F1027",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.1.95"));
  }

  public static MdiIcon eye_off() {
    return MdiIcon.create(
        "mdi-eye-off",
        new MdiMeta(
            "eye-off",
            "F0209",
            Arrays.asList(),
            Arrays.asList("hide", "visibility-off"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon eye_off_outline() {
    return MdiIcon.create(
        "mdi-eye-off-outline",
        new MdiMeta(
            "eye-off-outline",
            "F06D1",
            Arrays.asList(),
            Arrays.asList("hide-outline", "visibility-off-outline"),
            "Austin Andrews",
            "1.8.36"));
  }

  public static MdiIcon eye_outline() {
    return MdiIcon.create(
        "mdi-eye-outline",
        new MdiMeta(
            "eye-outline",
            "F06D0",
            Arrays.asList(),
            Arrays.asList("show-outline", "visibility-outline"),
            "Austin Andrews",
            "1.8.36"));
  }

  public static MdiIcon eye_plus() {
    return MdiIcon.create(
        "mdi-eye-plus",
        new MdiMeta(
            "eye-plus",
            "F086B",
            Arrays.asList(),
            Arrays.asList("eye-add"),
            "GreenTurtwig",
            "2.1.99"));
  }

  public static MdiIcon eye_plus_outline() {
    return MdiIcon.create(
        "mdi-eye-plus-outline",
        new MdiMeta(
            "eye-plus-outline",
            "F086C",
            Arrays.asList(),
            Arrays.asList("eye-add-outline"),
            "GreenTurtwig",
            "2.1.99"));
  }

  public static MdiIcon eye_refresh() {
    return MdiIcon.create(
        "mdi-eye-refresh",
        new MdiMeta(
            "eye-refresh",
            "F197C",
            Arrays.asList(),
            Arrays.asList("view-refresh"),
            "nlsve",
            "6.5.95"));
  }

  public static MdiIcon eye_refresh_outline() {
    return MdiIcon.create(
        "mdi-eye-refresh-outline",
        new MdiMeta(
            "eye-refresh-outline",
            "F197D",
            Arrays.asList(),
            Arrays.asList("view-refresh-outline"),
            "nlsve",
            "6.5.95"));
  }

  public static MdiIcon eye_remove() {
    return MdiIcon.create(
        "mdi-eye-remove",
        new MdiMeta(
            "eye-remove", "F15E3", Arrays.asList(), Arrays.asList(), "Colton Wiscombe", "5.6.55"));
  }

  public static MdiIcon eye_remove_outline() {
    return MdiIcon.create(
        "mdi-eye-remove-outline",
        new MdiMeta(
            "eye-remove-outline",
            "F15E4",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "5.6.55"));
  }

  public static MdiIcon eye_settings() {
    return MdiIcon.create(
        "mdi-eye-settings",
        new MdiMeta(
            "eye-settings",
            "F086D",
            Arrays.asList("Settings"),
            Arrays.asList(),
            "Michael Richins",
            "2.1.99"));
  }

  public static MdiIcon eye_settings_outline() {
    return MdiIcon.create(
        "mdi-eye-settings-outline",
        new MdiMeta(
            "eye-settings-outline",
            "F086E",
            Arrays.asList("Settings"),
            Arrays.asList(),
            "Michael Richins",
            "2.1.99"));
  }

  public static MdiIcon eyedropper() {
    return MdiIcon.create(
        "mdi-eyedropper",
        new MdiMeta(
            "eyedropper",
            "F020A",
            Arrays.asList("Color", "Drawing / Art", "Science"),
            Arrays.asList("pipette"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon eyedropper_minus() {
    return MdiIcon.create(
        "mdi-eyedropper-minus",
        new MdiMeta(
            "eyedropper-minus",
            "F13DD",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.1.45"));
  }

  public static MdiIcon eyedropper_off() {
    return MdiIcon.create(
        "mdi-eyedropper-off",
        new MdiMeta(
            "eyedropper-off",
            "F13DF",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.1.45"));
  }

  public static MdiIcon eyedropper_plus() {
    return MdiIcon.create(
        "mdi-eyedropper-plus",
        new MdiMeta(
            "eyedropper-plus",
            "F13DC",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.1.45"));
  }

  public static MdiIcon eyedropper_remove() {
    return MdiIcon.create(
        "mdi-eyedropper-remove",
        new MdiMeta(
            "eyedropper-remove",
            "F13DE",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.1.45"));
  }

  public static MdiIcon eyedropper_variant() {
    return MdiIcon.create(
        "mdi-eyedropper-variant",
        new MdiMeta(
            "eyedropper-variant",
            "F020B",
            Arrays.asList("Color", "Science"),
            Arrays.asList("colorize", "colourise", "pipette-variant"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon face_agent() {
    return MdiIcon.create(
        "mdi-face-agent",
        new MdiMeta(
            "face-agent",
            "F0D70",
            Arrays.asList(),
            Arrays.asList("customer-service", "support", "emoji-agent", "emoticon-agent"),
            "Mark Joseph Monserrat",
            "3.4.93"));
  }

  public static MdiIcon face_man() {
    return MdiIcon.create(
        "mdi-face-man",
        new MdiMeta(
            "face-man",
            "F0643",
            Arrays.asList("People / Family"),
            Arrays.asList("face-male", "emoji-man", "emoticon-man"),
            "Google",
            "1.6.50"));
  }

  public static MdiIcon face_man_outline() {
    return MdiIcon.create(
        "mdi-face-man-outline",
        new MdiMeta(
            "face-man-outline",
            "F0B96",
            Arrays.asList("People / Family"),
            Arrays.asList("face-male-outline", "emoji-man-outline", "emoticon-man-outline"),
            "Google",
            "3.0.39"));
  }

  public static MdiIcon face_man_profile() {
    return MdiIcon.create(
        "mdi-face-man-profile",
        new MdiMeta(
            "face-man-profile",
            "F0644",
            Arrays.asList("People / Family"),
            Arrays.asList("face-male-profile", "emoji-man-profile", "emoticon-man-profile"),
            "Google",
            "1.6.50"));
  }

  public static MdiIcon face_man_shimmer() {
    return MdiIcon.create(
        "mdi-face-man-shimmer",
        new MdiMeta(
            "face-man-shimmer",
            "F15CC",
            Arrays.asList("Photography", "Account / User", "Health / Beauty", "People / Family"),
            Arrays.asList(
                "face-retouching-natural",
                "face-male-shimmer",
                "emoji-man-shimmer",
                "emoticon-man-shimmer"),
            "Google",
            "5.6.55"));
  }

  public static MdiIcon face_man_shimmer_outline() {
    return MdiIcon.create(
        "mdi-face-man-shimmer-outline",
        new MdiMeta(
            "face-man-shimmer-outline",
            "F15CD",
            Arrays.asList("People / Family", "Photography", "Health / Beauty", "Account / User"),
            Arrays.asList(
                "face-retouching-natural-outline",
                "face-male-shimmer-outline",
                "emoji-man-shimmer-outline",
                "emoticon-man-shimmer-outline"),
            "Simran",
            "5.6.55"));
  }

  public static MdiIcon face_mask() {
    return MdiIcon.create(
        "mdi-face-mask",
        new MdiMeta(
            "face-mask",
            "F1586",
            Arrays.asList("Medical / Hospital", "Clothing"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.5.55"));
  }

  public static MdiIcon face_mask_outline() {
    return MdiIcon.create(
        "mdi-face-mask-outline",
        new MdiMeta(
            "face-mask-outline",
            "F1587",
            Arrays.asList("Medical / Hospital", "Clothing"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.5.55"));
  }

  public static MdiIcon face_recognition() {
    return MdiIcon.create(
        "mdi-face-recognition",
        new MdiMeta(
            "face-recognition",
            "F0C7B",
            Arrays.asList("Photography"),
            Arrays.asList("facial-recognition", "scan"),
            "Michael Richins",
            "3.2.89"));
  }

  public static MdiIcon face_woman() {
    return MdiIcon.create(
        "mdi-face-woman",
        new MdiMeta(
            "face-woman",
            "F1077",
            Arrays.asList("People / Family"),
            Arrays.asList("face-female", "emoji-woman", "emoticon-woman"),
            "Michael Irigoyen",
            "4.2.95"));
  }

  public static MdiIcon face_woman_outline() {
    return MdiIcon.create(
        "mdi-face-woman-outline",
        new MdiMeta(
            "face-woman-outline",
            "F1078",
            Arrays.asList("People / Family"),
            Arrays.asList("face-female-outline", "emoji-woman-outline", "emoticon-woman-outline"),
            "Michael Irigoyen",
            "4.2.95"));
  }

  public static MdiIcon face_woman_profile() {
    return MdiIcon.create(
        "mdi-face-woman-profile",
        new MdiMeta(
            "face-woman-profile",
            "F1076",
            Arrays.asList("People / Family"),
            Arrays.asList("face-female-profile", "emoji-woman-profile", "emoticon-woman-profile"),
            "Michael Irigoyen",
            "4.2.95"));
  }

  public static MdiIcon face_woman_shimmer() {
    return MdiIcon.create(
        "mdi-face-woman-shimmer",
        new MdiMeta(
            "face-woman-shimmer",
            "F15CE",
            Arrays.asList("People / Family", "Photography", "Health / Beauty", "Account / User"),
            Arrays.asList(
                "face-retouching-natural-woman",
                "face-female-shimmer",
                "emoji-woman-shimmer",
                "emoticon-woman-shimmer"),
            "Simran",
            "5.6.55"));
  }

  public static MdiIcon face_woman_shimmer_outline() {
    return MdiIcon.create(
        "mdi-face-woman-shimmer-outline",
        new MdiMeta(
            "face-woman-shimmer-outline",
            "F15CF",
            Arrays.asList("People / Family", "Photography", "Health / Beauty", "Account / User"),
            Arrays.asList(
                "face-retouching-natural-woman-outline",
                "face-female-shimmer-outline",
                "emoji-woman-shimmer-outline",
                "emoticon-woman-shimmer-outline"),
            "Simran",
            "5.6.55"));
  }

  @Deprecated
  public static MdiIcon facebook() {
    return MdiIcon.create(
        "mdi-facebook",
        new MdiMeta(
            "facebook",
            "F020C",
            Arrays.asList("Brand / Logo", "Social Media"),
            Arrays.asList(),
            "Contributors",
            "1.5.54"));
  }

  @Deprecated
  public static MdiIcon facebook_gaming() {
    return MdiIcon.create(
        "mdi-facebook-gaming",
        new MdiMeta(
            "facebook-gaming",
            "F07DD",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "2.0.46"));
  }

  @Deprecated
  public static MdiIcon facebook_messenger() {
    return MdiIcon.create(
        "mdi-facebook-messenger",
        new MdiMeta(
            "facebook-messenger",
            "F020E",
            Arrays.asList("Brand / Logo", "Social Media"),
            Arrays.asList(),
            "Contributors",
            "1.5.54"));
  }

  @Deprecated
  public static MdiIcon facebook_workplace() {
    return MdiIcon.create(
        "mdi-facebook-workplace",
        new MdiMeta(
            "facebook-workplace",
            "F0B31",
            Arrays.asList("Brand / Logo", "Social Media"),
            Arrays.asList(),
            "Contributors",
            "2.8.94"));
  }

  public static MdiIcon factory() {
    return MdiIcon.create(
        "mdi-factory",
        new MdiMeta(
            "factory",
            "F020F",
            Arrays.asList("Places"),
            Arrays.asList("industrial"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon family_tree() {
    return MdiIcon.create(
        "mdi-family-tree",
        new MdiMeta(
            "family-tree",
            "F160E",
            Arrays.asList("People / Family"),
            Arrays.asList(),
            "Simran",
            "5.6.55"));
  }

  public static MdiIcon fan() {
    return MdiIcon.create(
        "mdi-fan",
        new MdiMeta(
            "fan",
            "F0210",
            Arrays.asList("Home Automation", "Automotive"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon fan_alert() {
    return MdiIcon.create(
        "mdi-fan-alert",
        new MdiMeta(
            "fan-alert",
            "F146C",
            Arrays.asList("Home Automation", "Alert / Error"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon fan_auto() {
    return MdiIcon.create(
        "mdi-fan-auto",
        new MdiMeta("fan-auto", "F171D", Arrays.asList(), Arrays.asList(), "Hans Böhm", "5.9.55"));
  }

  public static MdiIcon fan_chevron_down() {
    return MdiIcon.create(
        "mdi-fan-chevron-down",
        new MdiMeta(
            "fan-chevron-down",
            "F146D",
            Arrays.asList("Home Automation"),
            Arrays.asList("fan-speed-down"),
            "GreenTurtwig",
            "5.2.45"));
  }

  public static MdiIcon fan_chevron_up() {
    return MdiIcon.create(
        "mdi-fan-chevron-up",
        new MdiMeta(
            "fan-chevron-up",
            "F146E",
            Arrays.asList("Home Automation"),
            Arrays.asList("fan-speed-up"),
            "GreenTurtwig",
            "5.2.45"));
  }

  public static MdiIcon fan_clock() {
    return MdiIcon.create(
        "mdi-fan-clock",
        new MdiMeta(
            "fan-clock",
            "F1A3A",
            Arrays.asList("Home Automation", "Date / Time"),
            Arrays.asList("fan-clock", "fan-schedule", "fan-timer"),
            "Michael Irigoyen",
            "6.7.96"));
  }

  public static MdiIcon fan_minus() {
    return MdiIcon.create(
        "mdi-fan-minus",
        new MdiMeta(
            "fan-minus",
            "F1470",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon fan_off() {
    return MdiIcon.create(
        "mdi-fan-off",
        new MdiMeta(
            "fan-off",
            "F081D",
            Arrays.asList("Home Automation", "Automotive"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.1.19"));
  }

  public static MdiIcon fan_plus() {
    return MdiIcon.create(
        "mdi-fan-plus",
        new MdiMeta(
            "fan-plus",
            "F146F",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon fan_remove() {
    return MdiIcon.create(
        "mdi-fan-remove",
        new MdiMeta(
            "fan-remove",
            "F1471",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon fan_speed_1() {
    return MdiIcon.create(
        "mdi-fan-speed-1",
        new MdiMeta(
            "fan-speed-1",
            "F1472",
            Arrays.asList("Home Automation"),
            Arrays.asList("fan-speed-low"),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon fan_speed_2() {
    return MdiIcon.create(
        "mdi-fan-speed-2",
        new MdiMeta(
            "fan-speed-2",
            "F1473",
            Arrays.asList("Home Automation"),
            Arrays.asList("fan-speed-medium"),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon fan_speed_3() {
    return MdiIcon.create(
        "mdi-fan-speed-3",
        new MdiMeta(
            "fan-speed-3",
            "F1474",
            Arrays.asList("Home Automation"),
            Arrays.asList("fan-speed-high"),
            "Michael Irigoyen",
            "5.2.45"));
  }

  public static MdiIcon fast_forward() {
    return MdiIcon.create(
        "mdi-fast-forward",
        new MdiMeta("fast-forward", "F0211", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon fast_forward_10() {
    return MdiIcon.create(
        "mdi-fast-forward-10",
        new MdiMeta(
            "fast-forward-10",
            "F0D71",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "3.4.93"));
  }

  public static MdiIcon fast_forward_15() {
    return MdiIcon.create(
        "mdi-fast-forward-15",
        new MdiMeta(
            "fast-forward-15",
            "F193A",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon fast_forward_30() {
    return MdiIcon.create(
        "mdi-fast-forward-30",
        new MdiMeta(
            "fast-forward-30",
            "F0D06",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "3.3.92"));
  }

  public static MdiIcon fast_forward_45() {
    return MdiIcon.create(
        "mdi-fast-forward-45",
        new MdiMeta(
            "fast-forward-45",
            "F1B12",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.9.96"));
  }

  public static MdiIcon fast_forward_5() {
    return MdiIcon.create(
        "mdi-fast-forward-5",
        new MdiMeta(
            "fast-forward-5",
            "F11F8",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon fast_forward_60() {
    return MdiIcon.create(
        "mdi-fast-forward-60",
        new MdiMeta(
            "fast-forward-60", "F160B", Arrays.asList(), Arrays.asList(), "Terren", "5.6.55"));
  }

  public static MdiIcon fast_forward_outline() {
    return MdiIcon.create(
        "mdi-fast-forward-outline",
        new MdiMeta(
            "fast-forward-outline", "F06D2", Arrays.asList(), Arrays.asList(), "Google", "1.8.36"));
  }

  public static MdiIcon faucet() {
    return MdiIcon.create(
        "mdi-faucet",
        new MdiMeta(
            "faucet",
            "F1B29",
            Arrays.asList("Home Automation"),
            Arrays.asList("kitchen-tap", "bathroom-tap", "sink"),
            "Michael Irigoyen",
            "6.9.96"));
  }

  public static MdiIcon faucet_variant() {
    return MdiIcon.create(
        "mdi-faucet-variant",
        new MdiMeta(
            "faucet-variant",
            "F1B2A",
            Arrays.asList("Home Automation"),
            Arrays.asList("bathroom-tap", "kitchen-tap", "sink"),
            "Michael Irigoyen",
            "6.9.96"));
  }

  public static MdiIcon fax() {
    return MdiIcon.create(
        "mdi-fax",
        new MdiMeta(
            "fax",
            "F0212",
            Arrays.asList("Printer", "Cellphone / Phone"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon feather() {
    return MdiIcon.create(
        "mdi-feather",
        new MdiMeta(
            "feather",
            "F06D3",
            Arrays.asList("Nature"),
            Arrays.asList("quill"),
            "Simran",
            "1.8.36"));
  }

  public static MdiIcon feature_search() {
    return MdiIcon.create(
        "mdi-feature-search",
        new MdiMeta(
            "feature-search",
            "F0A49",
            Arrays.asList(),
            Arrays.asList("box", "box-search"),
            "Simran",
            "2.6.95"));
  }

  public static MdiIcon feature_search_outline() {
    return MdiIcon.create(
        "mdi-feature-search-outline",
        new MdiMeta(
            "feature-search-outline",
            "F0A4A",
            Arrays.asList(),
            Arrays.asList("box", "box-outline", "box-search-outline"),
            "Simran",
            "2.6.95"));
  }

  @Deprecated
  public static MdiIcon fedora() {
    return MdiIcon.create(
        "mdi-fedora",
        new MdiMeta(
            "fedora",
            "F08DB",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Contributors",
            "2.3.50"));
  }

  public static MdiIcon fence() {
    return MdiIcon.create(
        "mdi-fence",
        new MdiMeta(
            "fence",
            "F179A",
            Arrays.asList("Home Automation", "Agriculture"),
            Arrays.asList("railway", "train-track"),
            "Michael Irigoyen",
            "6.1.95"));
  }

  public static MdiIcon fence_electric() {
    return MdiIcon.create(
        "mdi-fence-electric",
        new MdiMeta(
            "fence-electric",
            "F17F6",
            Arrays.asList("Home Automation", "Agriculture"),
            Arrays.asList("railway-electric", "train-track-electric"),
            "Michael Irigoyen",
            "6.1.95"));
  }

  public static MdiIcon fencing() {
    return MdiIcon.create(
        "mdi-fencing",
        new MdiMeta(
            "fencing",
            "F14C1",
            Arrays.asList("Sport"),
            Arrays.asList("sword-fight"),
            "Google",
            "5.3.45"));
  }

  public static MdiIcon ferris_wheel() {
    return MdiIcon.create(
        "mdi-ferris-wheel",
        new MdiMeta("ferris-wheel", "F0EA4", Arrays.asList(), Arrays.asList(), "Google", "3.7.94"));
  }

  public static MdiIcon ferry() {
    return MdiIcon.create(
        "mdi-ferry",
        new MdiMeta(
            "ferry",
            "F0213",
            Arrays.asList("Transportation + Water", "Navigation"),
            Arrays.asList("cargo-ship", "boat", "ship", "directions-boat", "directions-ferry"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon file() {
    return MdiIcon.create(
        "mdi-file",
        new MdiMeta(
            "file",
            "F0214",
            Arrays.asList("Files / Folders"),
            Arrays.asList("insert-drive-file", "draft", "paper"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon file_account() {
    return MdiIcon.create(
        "mdi-file-account",
        new MdiMeta(
            "file-account",
            "F073B",
            Arrays.asList("Account / User", "Files / Folders"),
            Arrays.asList("file-user", "resume"),
            "Austin Andrews",
            "1.9.32"));
  }

  public static MdiIcon file_account_outline() {
    return MdiIcon.create(
        "mdi-file-account-outline",
        new MdiMeta(
            "file-account-outline",
            "F1028",
            Arrays.asList("Files / Folders", "Account / User"),
            Arrays.asList(),
            "Terren",
            "4.1.95"));
  }

  public static MdiIcon file_alert() {
    return MdiIcon.create(
        "mdi-file-alert",
        new MdiMeta(
            "file-alert",
            "F0A4B",
            Arrays.asList("Files / Folders", "Alert / Error"),
            Arrays.asList("file-warning"),
            "Simran",
            "2.6.95"));
  }

  public static MdiIcon file_alert_outline() {
    return MdiIcon.create(
        "mdi-file-alert-outline",
        new MdiMeta(
            "file-alert-outline",
            "F0A4C",
            Arrays.asList("Files / Folders", "Alert / Error"),
            Arrays.asList("file-warning-outline"),
            "Simran",
            "2.6.95"));
  }

  public static MdiIcon file_arrow_left_right() {
    return MdiIcon.create(
        "mdi-file-arrow-left-right",
        new MdiMeta(
            "file-arrow-left-right",
            "F1A93",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-exchange", "file-transfer", "file-swap"),
            "Colton Wiscombe",
            "6.8.96"));
  }

  public static MdiIcon file_arrow_left_right_outline() {
    return MdiIcon.create(
        "mdi-file-arrow-left-right-outline",
        new MdiMeta(
            "file-arrow-left-right-outline",
            "F1A94",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-exchange-outline", "file-swap-outline", "file-transfer-outline"),
            "Colton Wiscombe",
            "6.8.96"));
  }

  public static MdiIcon file_arrow_up_down() {
    return MdiIcon.create(
        "mdi-file-arrow-up-down",
        new MdiMeta(
            "file-arrow-up-down",
            "F1A95",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-exchange", "file-swap", "file-transfer", "file-upload-download"),
            "Colton Wiscombe",
            "6.8.96"));
  }

  public static MdiIcon file_arrow_up_down_outline() {
    return MdiIcon.create(
        "mdi-file-arrow-up-down-outline",
        new MdiMeta(
            "file-arrow-up-down-outline",
            "F1A96",
            Arrays.asList("Files / Folders"),
            Arrays.asList(
                "file-exchange-outline",
                "file-swap-outline",
                "file-transfer-outline",
                "file-upload-download-outline"),
            "Colton Wiscombe",
            "6.8.96"));
  }

  public static MdiIcon file_cabinet() {
    return MdiIcon.create(
        "mdi-file-cabinet",
        new MdiMeta(
            "file-cabinet",
            "F0AB6",
            Arrays.asList("Files / Folders"),
            Arrays.asList("filing-cabinet"),
            "Michael Irigoyen",
            "2.7.94"));
  }

  public static MdiIcon file_cad() {
    return MdiIcon.create(
        "mdi-file-cad",
        new MdiMeta(
            "file-cad",
            "F0EEB",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "GreenTurtwig",
            "3.8.95"));
  }

  public static MdiIcon file_cad_box() {
    return MdiIcon.create(
        "mdi-file-cad-box",
        new MdiMeta(
            "file-cad-box",
            "F0EEC",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "GreenTurtwig",
            "3.8.95"));
  }

  public static MdiIcon file_cancel() {
    return MdiIcon.create(
        "mdi-file-cancel",
        new MdiMeta(
            "file-cancel",
            "F0DC6",
            Arrays.asList("Files / Folders"),
            Arrays.asList("ban", "forbid"),
            "Michael Irigoyen",
            "3.5.94"));
  }

  public static MdiIcon file_cancel_outline() {
    return MdiIcon.create(
        "mdi-file-cancel-outline",
        new MdiMeta(
            "file-cancel-outline",
            "F0DC7",
            Arrays.asList("Files / Folders"),
            Arrays.asList("ban", "forbid"),
            "Michael Irigoyen",
            "3.5.94"));
  }

  public static MdiIcon file_certificate() {
    return MdiIcon.create(
        "mdi-file-certificate",
        new MdiMeta(
            "file-certificate",
            "F1186",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Richins",
            "4.4.95"));
  }

  public static MdiIcon file_certificate_outline() {
    return MdiIcon.create(
        "mdi-file-certificate-outline",
        new MdiMeta(
            "file-certificate-outline",
            "F1187",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Richins",
            "4.4.95"));
  }

  public static MdiIcon file_chart() {
    return MdiIcon.create(
        "mdi-file-chart",
        new MdiMeta(
            "file-chart",
            "F0215",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-report", "file-graph"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon file_chart_check() {
    return MdiIcon.create(
        "mdi-file-chart-check",
        new MdiMeta(
            "file-chart-check",
            "F19C6",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Simran",
            "6.6.96"));
  }

  public static MdiIcon file_chart_check_outline() {
    return MdiIcon.create(
        "mdi-file-chart-check-outline",
        new MdiMeta(
            "file-chart-check-outline",
            "F19C7",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Simran",
            "6.6.96"));
  }

  public static MdiIcon file_chart_outline() {
    return MdiIcon.create(
        "mdi-file-chart-outline",
        new MdiMeta(
            "file-chart-outline",
            "F1029",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-graph-outline", "file-report-outline"),
            "Terren",
            "4.1.95"));
  }

  public static MdiIcon file_check() {
    return MdiIcon.create(
        "mdi-file-check",
        new MdiMeta(
            "file-check",
            "F0216",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-tick"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon file_check_outline() {
    return MdiIcon.create(
        "mdi-file-check-outline",
        new MdiMeta(
            "file-check-outline",
            "F0E29",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Simran",
            "3.6.95"));
  }

  public static MdiIcon file_clock() {
    return MdiIcon.create(
        "mdi-file-clock",
        new MdiMeta(
            "file-clock",
            "F12E1",
            Arrays.asList("Files / Folders", "Date / Time"),
            Arrays.asList(),
            "Simran",
            "4.8.95"));
  }

  public static MdiIcon file_clock_outline() {
    return MdiIcon.create(
        "mdi-file-clock-outline",
        new MdiMeta(
            "file-clock-outline",
            "F12E2",
            Arrays.asList("Files / Folders", "Date / Time"),
            Arrays.asList(),
            "Simran",
            "4.8.95"));
  }

  public static MdiIcon file_cloud() {
    return MdiIcon.create(
        "mdi-file-cloud",
        new MdiMeta(
            "file-cloud",
            "F0217",
            Arrays.asList("Cloud", "Files / Folders"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon file_cloud_outline() {
    return MdiIcon.create(
        "mdi-file-cloud-outline",
        new MdiMeta(
            "file-cloud-outline",
            "F102A",
            Arrays.asList("Files / Folders", "Cloud"),
            Arrays.asList(),
            "Terren",
            "4.1.95"));
  }

  public static MdiIcon file_code() {
    return MdiIcon.create(
        "mdi-file-code",
        new MdiMeta(
            "file-code",
            "F022E",
            Arrays.asList("Files / Folders", "Developer / Languages"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon file_code_outline() {
    return MdiIcon.create(
        "mdi-file-code-outline",
        new MdiMeta(
            "file-code-outline",
            "F102B",
            Arrays.asList("Files / Folders", "Developer / Languages"),
            Arrays.asList(),
            "Terren",
            "4.1.95"));
  }

  public static MdiIcon file_cog() {
    return MdiIcon.create(
        "mdi-file-cog",
        new MdiMeta(
            "file-cog",
            "F107B",
            Arrays.asList("Settings", "Files / Folders"),
            Arrays.asList("file-settings-cog"),
            "Simran",
            "4.2.95"));
  }

  public static MdiIcon file_cog_outline() {
    return MdiIcon.create(
        "mdi-file-cog-outline",
        new MdiMeta(
            "file-cog-outline",
            "F107C",
            Arrays.asList("Settings", "Files / Folders"),
            Arrays.asList("file-settings-cog-outline"),
            "Simran",
            "4.2.95"));
  }

  public static MdiIcon file_compare() {
    return MdiIcon.create(
        "mdi-file-compare",
        new MdiMeta(
            "file-compare",
            "F08AA",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.2.43"));
  }

  public static MdiIcon file_delimited() {
    return MdiIcon.create(
        "mdi-file-delimited",
        new MdiMeta(
            "file-delimited",
            "F0218",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-csv"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon file_delimited_outline() {
    return MdiIcon.create(
        "mdi-file-delimited-outline",
        new MdiMeta(
            "file-delimited-outline",
            "F0EA5",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-csv-outline"),
            "Terren",
            "3.7.94"));
  }

  public static MdiIcon file_document() {
    return MdiIcon.create(
        "mdi-file-document",
        new MdiMeta(
            "file-document",
            "F0219",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-text"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon file_document_alert() {
    return MdiIcon.create(
        "mdi-file-document-alert",
        new MdiMeta(
            "file-document-alert",
            "F1A97",
            Arrays.asList("Files / Folders", "Alert / Error"),
            Arrays.asList("file-document-error", "file-text-alert", "file-text-error"),
            "Simran",
            "6.8.96"));
  }

  public static MdiIcon file_document_alert_outline() {
    return MdiIcon.create(
        "mdi-file-document-alert-outline",
        new MdiMeta(
            "file-document-alert-outline",
            "F1A98",
            Arrays.asList("Files / Folders", "Alert / Error"),
            Arrays.asList(
                "file-document-error-outline",
                "file-text-error-outline",
                "file-text-alert-outline"),
            "Simran",
            "6.8.96"));
  }

  public static MdiIcon file_document_arrow_right() {
    return MdiIcon.create(
        "mdi-file-document-arrow-right",
        new MdiMeta(
            "file-document-arrow-right",
            "F1C0F",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-document-move", "file-text-move", "file-text-arrow-right"),
            "Andrej Sharapov",
            "7.1.96"));
  }

  public static MdiIcon file_document_arrow_right_outline() {
    return MdiIcon.create(
        "mdi-file-document-arrow-right-outline",
        new MdiMeta(
            "file-document-arrow-right-outline",
            "F1C10",
            Arrays.asList("Files / Folders"),
            Arrays.asList(
                "file-document-move-outline",
                "file-text-move-outline",
                "file-text-arrow-right-outline"),
            "Andrej Sharapov",
            "7.1.96"));
  }

  public static MdiIcon file_document_check() {
    return MdiIcon.create(
        "mdi-file-document-check",
        new MdiMeta(
            "file-document-check",
            "F1A99",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-document-tick", "file-text-tick", "file-text-check"),
            "Simran",
            "6.8.96"));
  }

  public static MdiIcon file_document_check_outline() {
    return MdiIcon.create(
        "mdi-file-document-check-outline",
        new MdiMeta(
            "file-document-check-outline",
            "F1A9A",
            Arrays.asList("Files / Folders"),
            Arrays.asList(
                "file-document-tick-outline", "file-text-tick-outline", "file-text-check-outline"),
            "Simran",
            "6.8.96"));
  }

  public static MdiIcon file_document_edit() {
    return MdiIcon.create(
        "mdi-file-document-edit",
        new MdiMeta(
            "file-document-edit",
            "F0DC8",
            Arrays.asList("Edit / Modify", "Files / Folders"),
            Arrays.asList("contract", "file-text-edit"),
            "GreenTurtwig",
            "3.5.94"));
  }

  public static MdiIcon file_document_edit_outline() {
    return MdiIcon.create(
        "mdi-file-document-edit-outline",
        new MdiMeta(
            "file-document-edit-outline",
            "F0DC9",
            Arrays.asList("Edit / Modify", "Files / Folders"),
            Arrays.asList("contract-outline", "file-text-edit-outline"),
            "Michael Irigoyen",
            "3.5.94"));
  }

  public static MdiIcon file_document_minus() {
    return MdiIcon.create(
        "mdi-file-document-minus",
        new MdiMeta(
            "file-document-minus",
            "F1A9B",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-text-minus"),
            "Simran",
            "6.8.96"));
  }

  public static MdiIcon file_document_minus_outline() {
    return MdiIcon.create(
        "mdi-file-document-minus-outline",
        new MdiMeta(
            "file-document-minus-outline",
            "F1A9C",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-text-minus-outline"),
            "Simran",
            "6.8.96"));
  }

  public static MdiIcon file_document_multiple() {
    return MdiIcon.create(
        "mdi-file-document-multiple",
        new MdiMeta(
            "file-document-multiple",
            "F1517",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-text-multiple"),
            "Robbert Gurdeep Singh",
            "5.4.55"));
  }

  public static MdiIcon file_document_multiple_outline() {
    return MdiIcon.create(
        "mdi-file-document-multiple-outline",
        new MdiMeta(
            "file-document-multiple-outline",
            "F1518",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-text-multiple-outline"),
            "Michael Irigoyen",
            "5.4.55"));
  }

  public static MdiIcon file_document_outline() {
    return MdiIcon.create(
        "mdi-file-document-outline",
        new MdiMeta(
            "file-document-outline",
            "F09EE",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-text-outline"),
            "Google",
            "2.5.94"));
  }

  public static MdiIcon file_document_plus() {
    return MdiIcon.create(
        "mdi-file-document-plus",
        new MdiMeta(
            "file-document-plus",
            "F1A9D",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-document-add", "file-text-add", "file-text-plus"),
            "Simran",
            "6.8.96"));
  }

  public static MdiIcon file_document_plus_outline() {
    return MdiIcon.create(
        "mdi-file-document-plus-outline",
        new MdiMeta(
            "file-document-plus-outline",
            "F1A9E",
            Arrays.asList("Files / Folders"),
            Arrays.asList(
                "file-document-add-outline", "file-text-plus-outline", "file-text-add-outline"),
            "Simran",
            "6.8.96"));
  }

  public static MdiIcon file_document_refresh() {
    return MdiIcon.create(
        "mdi-file-document-refresh",
        new MdiMeta(
            "file-document-refresh",
            "F1C7A",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Jeff Anders",
            "7.2.96"));
  }

  public static MdiIcon file_document_refresh_outline() {
    return MdiIcon.create(
        "mdi-file-document-refresh-outline",
        new MdiMeta(
            "file-document-refresh-outline",
            "F1C7B",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Jeff Anders",
            "7.2.96"));
  }

  public static MdiIcon file_document_remove() {
    return MdiIcon.create(
        "mdi-file-document-remove",
        new MdiMeta(
            "file-document-remove",
            "F1A9F",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-document-delete", "file-text-remove", "file-text-delete"),
            "Simran",
            "6.8.96"));
  }

  public static MdiIcon file_document_remove_outline() {
    return MdiIcon.create(
        "mdi-file-document-remove-outline",
        new MdiMeta(
            "file-document-remove-outline",
            "F1AA0",
            Arrays.asList("Files / Folders"),
            Arrays.asList(
                "file-document-delete-outline",
                "file-text-remove-outline",
                "file-text-delete-outline"),
            "Simran",
            "6.8.96"));
  }

  public static MdiIcon file_download() {
    return MdiIcon.create(
        "mdi-file-download",
        new MdiMeta(
            "file-download",
            "F0965",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.4.85"));
  }

  public static MdiIcon file_download_outline() {
    return MdiIcon.create(
        "mdi-file-download-outline",
        new MdiMeta(
            "file-download-outline",
            "F0966",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "2.4.85"));
  }

  public static MdiIcon file_edit() {
    return MdiIcon.create(
        "mdi-file-edit",
        new MdiMeta(
            "file-edit",
            "F11E7",
            Arrays.asList("Edit / Modify", "Files / Folders"),
            Arrays.asList(),
            "frankgrinaert",
            "4.5.95"));
  }

  public static MdiIcon file_edit_outline() {
    return MdiIcon.create(
        "mdi-file-edit-outline",
        new MdiMeta(
            "file-edit-outline",
            "F11E8",
            Arrays.asList("Edit / Modify", "Files / Folders"),
            Arrays.asList(),
            "frankgrinaert",
            "4.5.95"));
  }

  public static MdiIcon file_excel() {
    return MdiIcon.create(
        "mdi-file-excel",
        new MdiMeta(
            "file-excel",
            "F021B",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon file_excel_box() {
    return MdiIcon.create(
        "mdi-file-excel-box",
        new MdiMeta(
            "file-excel-box",
            "F021C",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon file_excel_box_outline() {
    return MdiIcon.create(
        "mdi-file-excel-box-outline",
        new MdiMeta(
            "file-excel-box-outline",
            "F102C",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Terren",
            "4.1.95"));
  }

  public static MdiIcon file_excel_outline() {
    return MdiIcon.create(
        "mdi-file-excel-outline",
        new MdiMeta(
            "file-excel-outline",
            "F102D",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Terren",
            "4.1.95"));
  }

  public static MdiIcon file_export() {
    return MdiIcon.create(
        "mdi-file-export",
        new MdiMeta(
            "file-export",
            "F021D",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon file_export_outline() {
    return MdiIcon.create(
        "mdi-file-export-outline",
        new MdiMeta(
            "file-export-outline",
            "F102E",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Terren",
            "4.1.95"));
  }

  public static MdiIcon file_eye() {
    return MdiIcon.create(
        "mdi-file-eye",
        new MdiMeta(
            "file-eye",
            "F0DCA",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.5.94"));
  }

  public static MdiIcon file_eye_outline() {
    return MdiIcon.create(
        "mdi-file-eye-outline",
        new MdiMeta(
            "file-eye-outline",
            "F0DCB",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.5.94"));
  }

  public static MdiIcon file_find() {
    return MdiIcon.create(
        "mdi-file-find",
        new MdiMeta(
            "file-find",
            "F021E",
            Arrays.asList("Files / Folders"),
            Arrays.asList("print-preview", "find-in-page"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon file_find_outline() {
    return MdiIcon.create(
        "mdi-file-find-outline",
        new MdiMeta(
            "file-find-outline",
            "F0B97",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Google",
            "3.0.39"));
  }

  public static MdiIcon file_gif_box() {
    return MdiIcon.create(
        "mdi-file-gif-box",
        new MdiMeta(
            "file-gif-box",
            "F0D78",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.4.93"));
  }

  public static MdiIcon file_hidden() {
    return MdiIcon.create(
        "mdi-file-hidden",
        new MdiMeta(
            "file-hidden",
            "F0613",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon file_image() {
    return MdiIcon.create(
        "mdi-file-image",
        new MdiMeta(
            "file-image",
            "F021F",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon file_image_marker() {
    return MdiIcon.create(
        "mdi-file-image-marker",
        new MdiMeta(
            "file-image-marker",
            "F1772",
            Arrays.asList("Files / Folders", "Navigation"),
            Arrays.asList("file-image-location"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon file_image_marker_outline() {
    return MdiIcon.create(
        "mdi-file-image-marker-outline",
        new MdiMeta(
            "file-image-marker-outline",
            "F1773",
            Arrays.asList("Files / Folders", "Navigation"),
            Arrays.asList("file-image-location-outline"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon file_image_minus() {
    return MdiIcon.create(
        "mdi-file-image-minus",
        new MdiMeta(
            "file-image-minus",
            "F193B",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon file_image_minus_outline() {
    return MdiIcon.create(
        "mdi-file-image-minus-outline",
        new MdiMeta(
            "file-image-minus-outline",
            "F193C",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon file_image_outline() {
    return MdiIcon.create(
        "mdi-file-image-outline",
        new MdiMeta(
            "file-image-outline",
            "F0EB0",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Terren",
            "3.7.94"));
  }

  public static MdiIcon file_image_plus() {
    return MdiIcon.create(
        "mdi-file-image-plus",
        new MdiMeta(
            "file-image-plus",
            "F193D",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-image-add"),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon file_image_plus_outline() {
    return MdiIcon.create(
        "mdi-file-image-plus-outline",
        new MdiMeta(
            "file-image-plus-outline",
            "F193E",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-image-add-outline"),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon file_image_remove() {
    return MdiIcon.create(
        "mdi-file-image-remove",
        new MdiMeta(
            "file-image-remove",
            "F193F",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon file_image_remove_outline() {
    return MdiIcon.create(
        "mdi-file-image-remove-outline",
        new MdiMeta(
            "file-image-remove-outline",
            "F1940",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.4.95"));
  }

  public static MdiIcon file_import() {
    return MdiIcon.create(
        "mdi-file-import",
        new MdiMeta(
            "file-import",
            "F0220",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon file_import_outline() {
    return MdiIcon.create(
        "mdi-file-import-outline",
        new MdiMeta(
            "file-import-outline",
            "F102F",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Terren",
            "4.1.95"));
  }

  public static MdiIcon file_jpg_box() {
    return MdiIcon.create(
        "mdi-file-jpg-box",
        new MdiMeta(
            "file-jpg-box",
            "F0225",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-jpeg-box", "image-jpg-box", "image-jpeg-box"),
            "Michael Irigoyen",
            "1.5.54"));
  }

  public static MdiIcon file_key() {
    return MdiIcon.create(
        "mdi-file-key",
        new MdiMeta(
            "file-key",
            "F1184",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Richins",
            "4.4.95"));
  }

  public static MdiIcon file_key_outline() {
    return MdiIcon.create(
        "mdi-file-key-outline",
        new MdiMeta(
            "file-key-outline",
            "F1185",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Richins",
            "4.4.95"));
  }

  public static MdiIcon file_link() {
    return MdiIcon.create(
        "mdi-file-link",
        new MdiMeta(
            "file-link",
            "F1177",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon file_link_outline() {
    return MdiIcon.create(
        "mdi-file-link-outline",
        new MdiMeta(
            "file-link-outline",
            "F1178",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon file_lock() {
    return MdiIcon.create(
        "mdi-file-lock",
        new MdiMeta(
            "file-lock",
            "F0221",
            Arrays.asList("Lock", "Files / Folders"),
            Arrays.asList(),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon file_lock_open() {
    return MdiIcon.create(
        "mdi-file-lock-open",
        new MdiMeta(
            "file-lock-open",
            "F19C8",
            Arrays.asList("Lock", "Files / Folders"),
            Arrays.asList(),
            "Simran",
            "6.6.96"));
  }

  public static MdiIcon file_lock_open_outline() {
    return MdiIcon.create(
        "mdi-file-lock-open-outline",
        new MdiMeta(
            "file-lock-open-outline",
            "F19C9",
            Arrays.asList("Lock", "Files / Folders"),
            Arrays.asList(),
            "Simran",
            "6.6.96"));
  }

  public static MdiIcon file_lock_outline() {
    return MdiIcon.create(
        "mdi-file-lock-outline",
        new MdiMeta(
            "file-lock-outline",
            "F1030",
            Arrays.asList("Files / Folders", "Lock"),
            Arrays.asList(),
            "Simran",
            "4.1.95"));
  }

  public static MdiIcon file_marker() {
    return MdiIcon.create(
        "mdi-file-marker",
        new MdiMeta(
            "file-marker",
            "F1774",
            Arrays.asList("Files / Folders", "Navigation"),
            Arrays.asList("file-location"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon file_marker_outline() {
    return MdiIcon.create(
        "mdi-file-marker-outline",
        new MdiMeta(
            "file-marker-outline",
            "F1775",
            Arrays.asList("Files / Folders", "Navigation"),
            Arrays.asList("file-location-outline"),
            "Colton Wiscombe",
            "6.1.95"));
  }

  public static MdiIcon file_minus() {
    return MdiIcon.create(
        "mdi-file-minus",
        new MdiMeta(
            "file-minus",
            "F1AA1",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Simran",
            "6.8.96"));
  }

  public static MdiIcon file_minus_outline() {
    return MdiIcon.create(
        "mdi-file-minus-outline",
        new MdiMeta(
            "file-minus-outline",
            "F1AA2",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Simran",
            "6.8.96"));
  }

  public static MdiIcon file_move() {
    return MdiIcon.create(
        "mdi-file-move",
        new MdiMeta(
            "file-move",
            "F0AB9",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Austin Andrews",
            "2.7.94"));
  }

  public static MdiIcon file_move_outline() {
    return MdiIcon.create(
        "mdi-file-move-outline",
        new MdiMeta(
            "file-move-outline",
            "F1031",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Terren",
            "4.1.95"));
  }

  public static MdiIcon file_multiple() {
    return MdiIcon.create(
        "mdi-file-multiple",
        new MdiMeta(
            "file-multiple",
            "F0222",
            Arrays.asList("Files / Folders"),
            Arrays.asList("files"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon file_multiple_outline() {
    return MdiIcon.create(
        "mdi-file-multiple-outline",
        new MdiMeta(
            "file-multiple-outline",
            "F1032",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Terren",
            "4.1.95"));
  }

  public static MdiIcon file_music() {
    return MdiIcon.create(
        "mdi-file-music",
        new MdiMeta(
            "file-music",
            "F0223",
            Arrays.asList("Files / Folders", "Music"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon file_music_outline() {
    return MdiIcon.create(
        "mdi-file-music-outline",
        new MdiMeta(
            "file-music-outline",
            "F0E2A",
            Arrays.asList("Files / Folders", "Music"),
            Arrays.asList(),
            "Terren",
            "3.6.95"));
  }

  public static MdiIcon file_outline() {
    return MdiIcon.create(
        "mdi-file-outline",
        new MdiMeta(
            "file-outline",
            "F0224",
            Arrays.asList("Files / Folders"),
            Arrays.asList("paper-outline"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon file_pdf_box() {
    return MdiIcon.create(
        "mdi-file-pdf-box",
        new MdiMeta(
            "file-pdf-box",
            "F0226",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-acrobat-box", "adobe-acrobat"),
            "Simran",
            "1.5.54"));
  }

  public static MdiIcon file_percent() {
    return MdiIcon.create(
        "mdi-file-percent",
        new MdiMeta(
            "file-percent",
            "F081E",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Richins",
            "2.1.19"));
  }

  public static MdiIcon file_percent_outline() {
    return MdiIcon.create(
        "mdi-file-percent-outline",
        new MdiMeta(
            "file-percent-outline",
            "F1033",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Terren",
            "4.1.95"));
  }

  public static MdiIcon file_phone() {
    return MdiIcon.create(
        "mdi-file-phone",
        new MdiMeta(
            "file-phone",
            "F1179",
            Arrays.asList("Files / Folders", "Cellphone / Phone"),
            Arrays.asList(),
            "Victor",
            "4.4.95"));
  }

  public static MdiIcon file_phone_outline() {
    return MdiIcon.create(
        "mdi-file-phone-outline",
        new MdiMeta(
            "file-phone-outline",
            "F117A",
            Arrays.asList("Files / Folders", "Cellphone / Phone"),
            Arrays.asList(),
            "Victor",
            "4.4.95"));
  }

  public static MdiIcon file_plus() {
    return MdiIcon.create(
        "mdi-file-plus",
        new MdiMeta(
            "file-plus",
            "F0752",
            Arrays.asList("Files / Folders"),
            Arrays.asList("note-add"),
            "Simran",
            "1.9.32"));
  }

  public static MdiIcon file_plus_outline() {
    return MdiIcon.create(
        "mdi-file-plus-outline",
        new MdiMeta(
            "file-plus-outline",
            "F0EED",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Simran",
            "3.8.95"));
  }

  public static MdiIcon file_png_box() {
    return MdiIcon.create(
        "mdi-file-png-box",
        new MdiMeta(
            "file-png-box",
            "F0E2D",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.6.95"));
  }

  public static MdiIcon file_powerpoint() {
    return MdiIcon.create(
        "mdi-file-powerpoint",
        new MdiMeta(
            "file-powerpoint",
            "F0227",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon file_powerpoint_box() {
    return MdiIcon.create(
        "mdi-file-powerpoint-box",
        new MdiMeta(
            "file-powerpoint-box",
            "F0228",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon file_powerpoint_box_outline() {
    return MdiIcon.create(
        "mdi-file-powerpoint-box-outline",
        new MdiMeta(
            "file-powerpoint-box-outline",
            "F1034",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Terren",
            "4.1.95"));
  }

  public static MdiIcon file_powerpoint_outline() {
    return MdiIcon.create(
        "mdi-file-powerpoint-outline",
        new MdiMeta(
            "file-powerpoint-outline",
            "F1035",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Terren",
            "4.1.95"));
  }

  public static MdiIcon file_presentation_box() {
    return MdiIcon.create(
        "mdi-file-presentation-box",
        new MdiMeta(
            "file-presentation-box",
            "F0229",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon file_question() {
    return MdiIcon.create(
        "mdi-file-question",
        new MdiMeta(
            "file-question",
            "F086F",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.1.99"));
  }

  public static MdiIcon file_question_outline() {
    return MdiIcon.create(
        "mdi-file-question-outline",
        new MdiMeta(
            "file-question-outline",
            "F1036",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Terren",
            "4.1.95"));
  }

  public static MdiIcon file_refresh() {
    return MdiIcon.create(
        "mdi-file-refresh",
        new MdiMeta(
            "file-refresh",
            "F0918",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Austin Andrews",
            "2.3.50"));
  }

  public static MdiIcon file_refresh_outline() {
    return MdiIcon.create(
        "mdi-file-refresh-outline",
        new MdiMeta(
            "file-refresh-outline",
            "F0541",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon file_remove() {
    return MdiIcon.create(
        "mdi-file-remove",
        new MdiMeta(
            "file-remove",
            "F0B98",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Simran",
            "3.0.39"));
  }

  public static MdiIcon file_remove_outline() {
    return MdiIcon.create(
        "mdi-file-remove-outline",
        new MdiMeta(
            "file-remove-outline",
            "F1037",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Simran",
            "4.1.95"));
  }

  public static MdiIcon file_replace() {
    return MdiIcon.create(
        "mdi-file-replace",
        new MdiMeta(
            "file-replace",
            "F0B32",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Richins",
            "2.8.94"));
  }

  public static MdiIcon file_replace_outline() {
    return MdiIcon.create(
        "mdi-file-replace-outline",
        new MdiMeta(
            "file-replace-outline",
            "F0B33",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Richins",
            "2.8.94"));
  }

  public static MdiIcon file_restore() {
    return MdiIcon.create(
        "mdi-file-restore",
        new MdiMeta(
            "file-restore",
            "F0670",
            Arrays.asList("Files / Folders"),
            Arrays.asList("restore-page"),
            "Google",
            "1.6.50"));
  }

  public static MdiIcon file_restore_outline() {
    return MdiIcon.create(
        "mdi-file-restore-outline",
        new MdiMeta(
            "file-restore-outline",
            "F1038",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Terren",
            "4.1.95"));
  }

  public static MdiIcon file_rotate_left() {
    return MdiIcon.create(
        "mdi-file-rotate-left",
        new MdiMeta(
            "file-rotate-left",
            "F1A3B",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-rotate-counter-clockwise", "file-rotate-ccw"),
            "Michael Irigoyen",
            "6.7.96"));
  }

  public static MdiIcon file_rotate_left_outline() {
    return MdiIcon.create(
        "mdi-file-rotate-left-outline",
        new MdiMeta(
            "file-rotate-left-outline",
            "F1A3C",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-rotate-counter-clockwise-outline", "file-rotate-ccw-outline"),
            "Michael Irigoyen",
            "6.7.96"));
  }

  public static MdiIcon file_rotate_right() {
    return MdiIcon.create(
        "mdi-file-rotate-right",
        new MdiMeta(
            "file-rotate-right",
            "F1A3D",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-rotate-clockwise"),
            "Michael Irigoyen",
            "6.7.96"));
  }

  public static MdiIcon file_rotate_right_outline() {
    return MdiIcon.create(
        "mdi-file-rotate-right-outline",
        new MdiMeta(
            "file-rotate-right-outline",
            "F1A3E",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-rotate-clockwise"),
            "Michael Irigoyen",
            "6.7.96"));
  }

  public static MdiIcon file_search() {
    return MdiIcon.create(
        "mdi-file-search",
        new MdiMeta(
            "file-search",
            "F0C7C",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Richins",
            "3.2.89"));
  }

  public static MdiIcon file_search_outline() {
    return MdiIcon.create(
        "mdi-file-search-outline",
        new MdiMeta(
            "file-search-outline",
            "F0C7D",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Richins",
            "3.2.89"));
  }

  public static MdiIcon file_send() {
    return MdiIcon.create(
        "mdi-file-send",
        new MdiMeta(
            "file-send",
            "F022A",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-move"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon file_send_outline() {
    return MdiIcon.create(
        "mdi-file-send-outline",
        new MdiMeta(
            "file-send-outline",
            "F1039",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Terren",
            "4.1.95"));
  }

  public static MdiIcon file_settings() {
    return MdiIcon.create(
        "mdi-file-settings",
        new MdiMeta(
            "file-settings",
            "F1079",
            Arrays.asList("Settings", "Files / Folders"),
            Arrays.asList(),
            "Simran",
            "4.2.95"));
  }

  public static MdiIcon file_settings_outline() {
    return MdiIcon.create(
        "mdi-file-settings-outline",
        new MdiMeta(
            "file-settings-outline",
            "F107A",
            Arrays.asList("Settings", "Files / Folders"),
            Arrays.asList(),
            "Simran",
            "4.2.95"));
  }

  public static MdiIcon file_sign() {
    return MdiIcon.create(
        "mdi-file-sign",
        new MdiMeta(
            "file-sign",
            "F19C3",
            Arrays.asList("Banking", "Files / Folders"),
            Arrays.asList("contract-sign", "document-sign"),
            "Michael Irigoyen",
            "6.5.95"));
  }

  public static MdiIcon file_star() {
    return MdiIcon.create(
        "mdi-file-star",
        new MdiMeta(
            "file-star",
            "F103A",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-favorite"),
            "Michael Irigoyen",
            "4.1.95"));
  }

  public static MdiIcon file_star_four_points() {
    return MdiIcon.create(
        "mdi-file-star-four-points",
        new MdiMeta(
            "file-star-four-points",
            "F1C2D",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-auto"),
            "Jeff Anders",
            "7.2.96"));
  }

  public static MdiIcon file_star_four_points_outline() {
    return MdiIcon.create(
        "mdi-file-star-four-points-outline",
        new MdiMeta(
            "file-star-four-points-outline",
            "F1C2E",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-auto-outline"),
            "Jeff Anders",
            "7.2.96"));
  }

  public static MdiIcon file_star_outline() {
    return MdiIcon.create(
        "mdi-file-star-outline",
        new MdiMeta(
            "file-star-outline",
            "F103B",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-favorite-outline"),
            "Michael Miday",
            "4.1.95"));
  }

  public static MdiIcon file_swap() {
    return MdiIcon.create(
        "mdi-file-swap",
        new MdiMeta(
            "file-swap",
            "F0FB4",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-transfer"),
            "Michael Richins",
            "4.0.96"));
  }

  public static MdiIcon file_swap_outline() {
    return MdiIcon.create(
        "mdi-file-swap-outline",
        new MdiMeta(
            "file-swap-outline",
            "F0FB5",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-transfer-outline"),
            "Michael Richins",
            "4.0.96"));
  }

  public static MdiIcon file_sync() {
    return MdiIcon.create(
        "mdi-file-sync",
        new MdiMeta(
            "file-sync",
            "F1216",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.6.95"));
  }

  public static MdiIcon file_sync_outline() {
    return MdiIcon.create(
        "mdi-file-sync-outline",
        new MdiMeta(
            "file-sync-outline",
            "F1217",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.6.95"));
  }

  public static MdiIcon file_table() {
    return MdiIcon.create(
        "mdi-file-table",
        new MdiMeta(
            "file-table",
            "F0C7E",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Richins",
            "3.2.89"));
  }

  public static MdiIcon file_table_box() {
    return MdiIcon.create(
        "mdi-file-table-box",
        new MdiMeta(
            "file-table-box",
            "F10E1",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.3.95"));
  }

  public static MdiIcon file_table_box_multiple() {
    return MdiIcon.create(
        "mdi-file-table-box-multiple",
        new MdiMeta(
            "file-table-box-multiple",
            "F10E2",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.3.95"));
  }

  public static MdiIcon file_table_box_multiple_outline() {
    return MdiIcon.create(
        "mdi-file-table-box-multiple-outline",
        new MdiMeta(
            "file-table-box-multiple-outline",
            "F10E3",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.3.95"));
  }

  public static MdiIcon file_table_box_outline() {
    return MdiIcon.create(
        "mdi-file-table-box-outline",
        new MdiMeta(
            "file-table-box-outline",
            "F10E4",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.3.95"));
  }

  public static MdiIcon file_table_outline() {
    return MdiIcon.create(
        "mdi-file-table-outline",
        new MdiMeta(
            "file-table-outline",
            "F0C7F",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Richins",
            "3.2.89"));
  }

  public static MdiIcon file_tree() {
    return MdiIcon.create(
        "mdi-file-tree",
        new MdiMeta(
            "file-tree",
            "F0645",
            Arrays.asList("Files / Folders"),
            Arrays.asList("subtasks"),
            "Kai Faust",
            "1.6.50"));
  }

  public static MdiIcon file_tree_outline() {
    return MdiIcon.create(
        "mdi-file-tree-outline",
        new MdiMeta(
            "file-tree-outline",
            "F13D2",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.1.45"));
  }

  public static MdiIcon file_undo() {
    return MdiIcon.create(
        "mdi-file-undo",
        new MdiMeta(
            "file-undo",
            "F08DC",
            Arrays.asList("Files / Folders"),
            Arrays.asList("file-revert", "file-discard"),
            "Michael Richins",
            "2.3.50"));
  }

  public static MdiIcon file_undo_outline() {
    return MdiIcon.create(
        "mdi-file-undo-outline",
        new MdiMeta(
            "file-undo-outline",
            "F103C",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Terren",
            "4.1.95"));
  }

  public static MdiIcon file_upload() {
    return MdiIcon.create(
        "mdi-file-upload",
        new MdiMeta(
            "file-upload",
            "F0A4D",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Richins",
            "2.6.95"));
  }

  public static MdiIcon file_upload_outline() {
    return MdiIcon.create(
        "mdi-file-upload-outline",
        new MdiMeta(
            "file-upload-outline",
            "F0A4E",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Richins",
            "2.6.95"));
  }

  public static MdiIcon file_video() {
    return MdiIcon.create(
        "mdi-file-video",
        new MdiMeta(
            "file-video",
            "F022B",
            Arrays.asList("Video / Movie", "Files / Folders"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon file_video_outline() {
    return MdiIcon.create(
        "mdi-file-video-outline",
        new MdiMeta(
            "file-video-outline",
            "F0E2C",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Peter Noble",
            "3.6.95"));
  }

  public static MdiIcon file_word() {
    return MdiIcon.create(
        "mdi-file-word",
        new MdiMeta(
            "file-word",
            "F022C",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon file_word_box() {
    return MdiIcon.create(
        "mdi-file-word-box",
        new MdiMeta(
            "file-word-box",
            "F022D",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon file_word_box_outline() {
    return MdiIcon.create(
        "mdi-file-word-box-outline",
        new MdiMeta(
            "file-word-box-outline",
            "F103D",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Terren",
            "4.1.95"));
  }

  public static MdiIcon file_word_outline() {
    return MdiIcon.create(
        "mdi-file-word-outline",
        new MdiMeta(
            "file-word-outline",
            "F103E",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Terren",
            "4.1.95"));
  }

  public static MdiIcon file_xml_box() {
    return MdiIcon.create(
        "mdi-file-xml-box",
        new MdiMeta(
            "file-xml-box",
            "F1B4B",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.9.96"));
  }

  public static MdiIcon film() {
    return MdiIcon.create(
        "mdi-film",
        new MdiMeta(
            "film",
            "F022F",
            Arrays.asList("Photography", "Video / Movie"),
            Arrays.asList("camera-roll"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon filmstrip() {
    return MdiIcon.create(
        "mdi-filmstrip",
        new MdiMeta(
            "filmstrip",
            "F0230",
            Arrays.asList("Video / Movie"),
            Arrays.asList("local-movies", "theaters"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon filmstrip_box() {
    return MdiIcon.create(
        "mdi-filmstrip-box",
        new MdiMeta(
            "filmstrip-box",
            "F0332",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon filmstrip_box_multiple() {
    return MdiIcon.create(
        "mdi-filmstrip-box-multiple",
        new MdiMeta(
            "filmstrip-box-multiple",
            "F0D18",
            Arrays.asList("Video / Movie"),
            Arrays.asList("library-movie"),
            "Google",
            "3.3.92"));
  }

  public static MdiIcon filmstrip_off() {
    return MdiIcon.create(
        "mdi-filmstrip-off",
        new MdiMeta(
            "filmstrip-off",
            "F0231",
            Arrays.asList("Video / Movie"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon filter() {
    return MdiIcon.create(
        "mdi-filter",
        new MdiMeta(
            "filter",
            "F0232",
            Arrays.asList(),
            Arrays.asList("funnel"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon filter_check() {
    return MdiIcon.create(
        "mdi-filter-check",
        new MdiMeta(
            "filter-check",
            "F18EC",
            Arrays.asList(),
            Arrays.asList("funnel-check"),
            "Michael Irigoyen",
            "6.3.95"));
  }

  public static MdiIcon filter_check_outline() {
    return MdiIcon.create(
        "mdi-filter-check-outline",
        new MdiMeta(
            "filter-check-outline",
            "F18ED",
            Arrays.asList(),
            Arrays.asList("funnel-check-outline"),
            "Michael Irigoyen",
            "6.3.95"));
  }

  public static MdiIcon filter_cog() {
    return MdiIcon.create(
        "mdi-filter-cog",
        new MdiMeta(
            "filter-cog",
            "F1AA3",
            Arrays.asList("Settings"),
            Arrays.asList(
                "funnel-settings", "filter-settings", "funnel-cog", "filter-gear", "funnel-gear"),
            "Simran",
            "6.8.96"));
  }

  public static MdiIcon filter_cog_outline() {
    return MdiIcon.create(
        "mdi-filter-cog-outline",
        new MdiMeta(
            "filter-cog-outline",
            "F1AA4",
            Arrays.asList("Settings"),
            Arrays.asList(
                "filter-settings-outline",
                "filter-gear-outline",
                "funnel-cog-outline",
                "funnel-settings-outline",
                "funnel-gear-outline"),
            "Simran",
            "6.8.96"));
  }

  public static MdiIcon filter_menu() {
    return MdiIcon.create(
        "mdi-filter-menu",
        new MdiMeta(
            "filter-menu", "F10E5", Arrays.asList(), Arrays.asList(), "Michael Richins", "4.3.95"));
  }

  public static MdiIcon filter_menu_outline() {
    return MdiIcon.create(
        "mdi-filter-menu-outline",
        new MdiMeta(
            "filter-menu-outline",
            "F10E6",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "4.3.95"));
  }

  public static MdiIcon filter_minus() {
    return MdiIcon.create(
        "mdi-filter-minus",
        new MdiMeta(
            "filter-minus",
            "F0EEE",
            Arrays.asList(),
            Arrays.asList("funnel-minus"),
            "GreenTurtwig",
            "3.8.95"));
  }

  public static MdiIcon filter_minus_outline() {
    return MdiIcon.create(
        "mdi-filter-minus-outline",
        new MdiMeta(
            "filter-minus-outline",
            "F0EEF",
            Arrays.asList(),
            Arrays.asList("funnel-minus-outline"),
            "GreenTurtwig",
            "3.8.95"));
  }

  public static MdiIcon filter_multiple() {
    return MdiIcon.create(
        "mdi-filter-multiple",
        new MdiMeta(
            "filter-multiple",
            "F1A3F",
            Arrays.asList(),
            Arrays.asList("funnel-multiple"),
            "Simran",
            "6.7.96"));
  }

  public static MdiIcon filter_multiple_outline() {
    return MdiIcon.create(
        "mdi-filter-multiple-outline",
        new MdiMeta(
            "filter-multiple-outline",
            "F1A40",
            Arrays.asList(),
            Arrays.asList("funnel-multiple-outline"),
            "Simran",
            "6.7.96"));
  }

  public static MdiIcon filter_off() {
    return MdiIcon.create(
        "mdi-filter-off",
        new MdiMeta("filter-off", "F14EF", Arrays.asList(), Arrays.asList(), "kikuchan", "5.4.55"));
  }

  public static MdiIcon filter_off_outline() {
    return MdiIcon.create(
        "mdi-filter-off-outline",
        new MdiMeta(
            "filter-off-outline", "F14F0", Arrays.asList(), Arrays.asList(), "kikuchan", "5.4.55"));
  }

  public static MdiIcon filter_outline() {
    return MdiIcon.create(
        "mdi-filter-outline",
        new MdiMeta(
            "filter-outline",
            "F0233",
            Arrays.asList(),
            Arrays.asList("funnel-outline"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon filter_plus() {
    return MdiIcon.create(
        "mdi-filter-plus",
        new MdiMeta(
            "filter-plus",
            "F0EF0",
            Arrays.asList(),
            Arrays.asList("funnel-plus"),
            "GreenTurtwig",
            "3.8.95"));
  }

  public static MdiIcon filter_plus_outline() {
    return MdiIcon.create(
        "mdi-filter-plus-outline",
        new MdiMeta(
            "filter-plus-outline",
            "F0EF1",
            Arrays.asList(),
            Arrays.asList("funnel-plus-outline"),
            "GreenTurtwig",
            "3.8.95"));
  }

  public static MdiIcon filter_remove() {
    return MdiIcon.create(
        "mdi-filter-remove",
        new MdiMeta(
            "filter-remove",
            "F0234",
            Arrays.asList(),
            Arrays.asList("funnel-remove"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon filter_remove_outline() {
    return MdiIcon.create(
        "mdi-filter-remove-outline",
        new MdiMeta(
            "filter-remove-outline",
            "F0235",
            Arrays.asList(),
            Arrays.asList("funnel-remove-outline"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon filter_settings() {
    return MdiIcon.create(
        "mdi-filter-settings",
        new MdiMeta(
            "filter-settings",
            "F1AA5",
            Arrays.asList("Settings"),
            Arrays.asList("funnel-settings"),
            "Simran",
            "6.8.96"));
  }

  public static MdiIcon filter_settings_outline() {
    return MdiIcon.create(
        "mdi-filter-settings-outline",
        new MdiMeta(
            "filter-settings-outline",
            "F1AA6",
            Arrays.asList("Settings"),
            Arrays.asList("funnel-settings-outline"),
            "Simran",
            "6.8.96"));
  }

  public static MdiIcon filter_variant() {
    return MdiIcon.create(
        "mdi-filter-variant",
        new MdiMeta(
            "filter-variant",
            "F0236",
            Arrays.asList(),
            Arrays.asList("filter-list"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon filter_variant_minus() {
    return MdiIcon.create(
        "mdi-filter-variant-minus",
        new MdiMeta(
            "filter-variant-minus",
            "F1112",
            Arrays.asList(),
            Arrays.asList(),
            "François Risoud",
            "4.3.95"));
  }

  public static MdiIcon filter_variant_plus() {
    return MdiIcon.create(
        "mdi-filter-variant-plus",
        new MdiMeta(
            "filter-variant-plus",
            "F1113",
            Arrays.asList(),
            Arrays.asList(),
            "François Risoud",
            "4.3.95"));
  }

  public static MdiIcon filter_variant_remove() {
    return MdiIcon.create(
        "mdi-filter-variant-remove",
        new MdiMeta(
            "filter-variant-remove",
            "F103F",
            Arrays.asList(),
            Arrays.asList(),
            "David Jackson",
            "4.1.95"));
  }

  public static MdiIcon finance() {
    return MdiIcon.create(
        "mdi-finance",
        new MdiMeta(
            "finance",
            "F081F",
            Arrays.asList("Banking", "Math"),
            Arrays.asList("chart-finance", "report-finance", "graph-bar"),
            "Google",
            "2.1.19"));
  }

  public static MdiIcon find_replace() {
    return MdiIcon.create(
        "mdi-find-replace",
        new MdiMeta("find-replace", "F06D4", Arrays.asList(), Arrays.asList(), "Google", "1.8.36"));
  }

  public static MdiIcon fingerprint() {
    return MdiIcon.create(
        "mdi-fingerprint",
        new MdiMeta("fingerprint", "F0237", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon fingerprint_off() {
    return MdiIcon.create(
        "mdi-fingerprint-off",
        new MdiMeta(
            "fingerprint-off",
            "F0EB1",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "3.7.94"));
  }

  public static MdiIcon fire() {
    return MdiIcon.create(
        "mdi-fire",
        new MdiMeta(
            "fire",
            "F0238",
            Arrays.asList("Home Automation"),
            Arrays.asList("whatshot", "flame", "gas", "natural-gas", "hot"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon fire_alert() {
    return MdiIcon.create(
        "mdi-fire-alert",
        new MdiMeta(
            "fire-alert",
            "F15D7",
            Arrays.asList("Alert / Error", "Home Automation"),
            Arrays.asList("flame-alert"),
            "Colton Wiscombe",
            "5.6.55"));
  }

  public static MdiIcon fire_circle() {
    return MdiIcon.create(
        "mdi-fire-circle",
        new MdiMeta(
            "fire-circle",
            "F1807",
            Arrays.asList("Home Automation"),
            Arrays.asList("flame-circle", "hot-circle", "gas-circle", "natural-gas-circle"),
            "Michael Irigoyen",
            "6.1.95"));
  }

  public static MdiIcon fire_extinguisher() {
    return MdiIcon.create(
        "mdi-fire-extinguisher",
        new MdiMeta(
            "fire-extinguisher",
            "F0EF2",
            Arrays.asList("Hardware / Tools", "Home Automation"),
            Arrays.asList(),
            "Simran",
            "3.8.95"));
  }

  public static MdiIcon fire_hydrant() {
    return MdiIcon.create(
        "mdi-fire-hydrant",
        new MdiMeta(
            "fire-hydrant",
            "F1137",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon fire_hydrant_alert() {
    return MdiIcon.create(
        "mdi-fire-hydrant-alert",
        new MdiMeta(
            "fire-hydrant-alert",
            "F1138",
            Arrays.asList("Alert / Error"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon fire_hydrant_off() {
    return MdiIcon.create(
        "mdi-fire-hydrant-off",
        new MdiMeta(
            "fire-hydrant-off",
            "F1139",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.4.95"));
  }

  public static MdiIcon fire_off() {
    return MdiIcon.create(
        "mdi-fire-off",
        new MdiMeta(
            "fire-off",
            "F1722",
            Arrays.asList("Home Automation"),
            Arrays.asList("flame-off"),
            "Michael Irigoyen",
            "5.9.55"));
  }

  public static MdiIcon fire_truck() {
    return MdiIcon.create(
        "mdi-fire-truck",
        new MdiMeta(
            "fire-truck",
            "F08AB",
            Arrays.asList("Transportation + Road"),
            Arrays.asList("fire-engine"),
            "Nick",
            "2.2.43"));
  }

  @Deprecated
  public static MdiIcon firebase() {
    return MdiIcon.create(
        "mdi-firebase",
        new MdiMeta(
            "firebase",
            "F0967",
            Arrays.asList("Brand / Logo"),
            Arrays.asList(),
            "Google",
            "2.4.85"));
  }

  @Deprecated
  public static MdiIcon firefox() {
    return MdiIcon.create(
        "mdi-firefox",
        new MdiMeta(
            "firefox",
            "F0239",
            Arrays.asList("Brand / Logo"),
            Arrays.asList("mozilla-firefox"),
            "Contributors",
            "1.5.54"));
  }

  public static MdiIcon fireplace() {
    return MdiIcon.create(
        "mdi-fireplace",
        new MdiMeta(
            "fireplace",
            "F0E2E",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.6.95"));
  }

  public static MdiIcon fireplace_off() {
    return MdiIcon.create(
        "mdi-fireplace-off",
        new MdiMeta(
            "fireplace-off",
            "F0E2F",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.6.95"));
  }

  public static MdiIcon firewire() {
    return MdiIcon.create(
        "mdi-firewire",
        new MdiMeta(
            "firewire", "F05BE", Arrays.asList(), Arrays.asList(), "Contributors", "1.5.54"));
  }

  public static MdiIcon firework() {
    return MdiIcon.create(
        "mdi-firework",
        new MdiMeta(
            "firework",
            "F0E30",
            Arrays.asList("Holiday"),
            Arrays.asList("bottle-rocket"),
            "Augustin Ursu",
            "3.6.95"));
  }

  public static MdiIcon firework_off() {
    return MdiIcon.create(
        "mdi-firework-off",
        new MdiMeta(
            "firework-off",
            "F1723",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.9.55"));
  }

  public static MdiIcon fish() {
    return MdiIcon.create(
        "mdi-fish",
        new MdiMeta(
            "fish",
            "F023A",
            Arrays.asList("Animal", "Food / Drink"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon fish_off() {
    return MdiIcon.create(
        "mdi-fish-off",
        new MdiMeta(
            "fish-off",
            "F13F3",
            Arrays.asList("Food / Drink"),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.1.45"));
  }

  public static MdiIcon fishbowl() {
    return MdiIcon.create(
        "mdi-fishbowl",
        new MdiMeta(
            "fishbowl",
            "F0EF3",
            Arrays.asList("Animal"),
            Arrays.asList("aquarium"),
            "Michael Irigoyen",
            "3.8.95"));
  }

  public static MdiIcon fishbowl_outline() {
    return MdiIcon.create(
        "mdi-fishbowl-outline",
        new MdiMeta(
            "fishbowl-outline",
            "F0EF4",
            Arrays.asList("Animal"),
            Arrays.asList("aquarium-outline"),
            "Michael Irigoyen",
            "3.8.95"));
  }

  public static MdiIcon fit_to_page() {
    return MdiIcon.create(
        "mdi-fit-to-page",
        new MdiMeta(
            "fit-to-page",
            "F0EF5",
            Arrays.asList("Text / Content / Format", "Arrow"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.8.95"));
  }

  public static MdiIcon fit_to_page_outline() {
    return MdiIcon.create(
        "mdi-fit-to-page-outline",
        new MdiMeta(
            "fit-to-page-outline",
            "F0EF6",
            Arrays.asList("Text / Content / Format", "Arrow"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.8.95"));
  }

  public static MdiIcon fit_to_screen() {
    return MdiIcon.create(
        "mdi-fit-to-screen",
        new MdiMeta(
            "fit-to-screen", "F18F4", Arrays.asList(), Arrays.asList(), "Google", "6.3.95"));
  }

  public static MdiIcon fit_to_screen_outline() {
    return MdiIcon.create(
        "mdi-fit-to-screen-outline",
        new MdiMeta(
            "fit-to-screen-outline",
            "F18F5",
            Arrays.asList(),
            Arrays.asList(),
            "Google",
            "6.3.95"));
  }

  public static MdiIcon flag() {
    return MdiIcon.create(
        "mdi-flag",
        new MdiMeta(
            "flag",
            "F023B",
            Arrays.asList(),
            Arrays.asList("assistant-photo"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon flag_checkered() {
    return MdiIcon.create(
        "mdi-flag-checkered",
        new MdiMeta(
            "flag-checkered",
            "F023C",
            Arrays.asList("Sport"),
            Arrays.asList("goal"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon flag_minus() {
    return MdiIcon.create(
        "mdi-flag-minus",
        new MdiMeta(
            "flag-minus", "F0B99", Arrays.asList(), Arrays.asList(), "Michael Richins", "3.0.39"));
  }

  public static MdiIcon flag_minus_outline() {
    return MdiIcon.create(
        "mdi-flag-minus-outline",
        new MdiMeta(
            "flag-minus-outline",
            "F10B2",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "4.2.95"));
  }

  public static MdiIcon flag_off() {
    return MdiIcon.create(
        "mdi-flag-off",
        new MdiMeta(
            "flag-off", "F18EE", Arrays.asList(), Arrays.asList(), "Michael Irigoyen", "6.3.95"));
  }

  public static MdiIcon flag_off_outline() {
    return MdiIcon.create(
        "mdi-flag-off-outline",
        new MdiMeta(
            "flag-off-outline",
            "F18EF",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.3.95"));
  }

  public static MdiIcon flag_outline() {
    return MdiIcon.create(
        "mdi-flag-outline",
        new MdiMeta("flag-outline", "F023D", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon flag_plus() {
    return MdiIcon.create(
        "mdi-flag-plus",
        new MdiMeta(
            "flag-plus",
            "F0B9A",
            Arrays.asList(),
            Arrays.asList("flag-add"),
            "Michael Richins",
            "3.0.39"));
  }

  public static MdiIcon flag_plus_outline() {
    return MdiIcon.create(
        "mdi-flag-plus-outline",
        new MdiMeta(
            "flag-plus-outline",
            "F10B3",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "4.2.95"));
  }

  public static MdiIcon flag_remove() {
    return MdiIcon.create(
        "mdi-flag-remove",
        new MdiMeta(
            "flag-remove", "F0B9B", Arrays.asList(), Arrays.asList(), "Michael Richins", "3.0.39"));
  }

  public static MdiIcon flag_remove_outline() {
    return MdiIcon.create(
        "mdi-flag-remove-outline",
        new MdiMeta(
            "flag-remove-outline",
            "F10B4",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Richins",
            "4.2.95"));
  }

  public static MdiIcon flag_triangle() {
    return MdiIcon.create(
        "mdi-flag-triangle",
        new MdiMeta(
            "flag-triangle",
            "F023F",
            Arrays.asList(),
            Arrays.asList("milestone"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon flag_variant() {
    return MdiIcon.create(
        "mdi-flag-variant",
        new MdiMeta(
            "flag-variant", "F0240", Arrays.asList(), Arrays.asList(), "Austin Andrews", "1.5.54"));
  }

  public static MdiIcon flag_variant_minus() {
    return MdiIcon.create(
        "mdi-flag-variant-minus",
        new MdiMeta(
            "flag-variant-minus",
            "F1BB4",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon flag_variant_minus_outline() {
    return MdiIcon.create(
        "mdi-flag-variant-minus-outline",
        new MdiMeta(
            "flag-variant-minus-outline",
            "F1BB5",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon flag_variant_off() {
    return MdiIcon.create(
        "mdi-flag-variant-off",
        new MdiMeta(
            "flag-variant-off",
            "F1BB0",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon flag_variant_off_outline() {
    return MdiIcon.create(
        "mdi-flag-variant-off-outline",
        new MdiMeta(
            "flag-variant-off-outline",
            "F1BB1",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon flag_variant_outline() {
    return MdiIcon.create(
        "mdi-flag-variant-outline",
        new MdiMeta(
            "flag-variant-outline",
            "F023E",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon flag_variant_plus() {
    return MdiIcon.create(
        "mdi-flag-variant-plus",
        new MdiMeta(
            "flag-variant-plus",
            "F1BB2",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon flag_variant_plus_outline() {
    return MdiIcon.create(
        "mdi-flag-variant-plus-outline",
        new MdiMeta(
            "flag-variant-plus-outline",
            "F1BB3",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon flag_variant_remove() {
    return MdiIcon.create(
        "mdi-flag-variant-remove",
        new MdiMeta(
            "flag-variant-remove",
            "F1BB6",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon flag_variant_remove_outline() {
    return MdiIcon.create(
        "mdi-flag-variant-remove-outline",
        new MdiMeta(
            "flag-variant-remove-outline",
            "F1BB7",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "7.0.96"));
  }

  public static MdiIcon flare() {
    return MdiIcon.create(
        "mdi-flare",
        new MdiMeta("flare", "F0D72", Arrays.asList(), Arrays.asList("star"), "Google", "3.4.93"));
  }

  public static MdiIcon flash() {
    return MdiIcon.create(
        "mdi-flash",
        new MdiMeta(
            "flash",
            "F0241",
            Arrays.asList("Weather"),
            Arrays.asList("lightning-bolt", "flash-on", "electricity"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon flash_alert() {
    return MdiIcon.create(
        "mdi-flash-alert",
        new MdiMeta(
            "flash-alert",
            "F0EF7",
            Arrays.asList("Weather", "Alert / Error"),
            Arrays.asList("lightning-alert", "storm-advisory"),
            "Michael Irigoyen",
            "3.8.95"));
  }

  public static MdiIcon flash_alert_outline() {
    return MdiIcon.create(
        "mdi-flash-alert-outline",
        new MdiMeta(
            "flash-alert-outline",
            "F0EF8",
            Arrays.asList("Weather", "Alert / Error"),
            Arrays.asList("lightning-alert-outline", "storm-advisory-outline"),
            "Michael Irigoyen",
            "3.8.95"));
  }

  public static MdiIcon flash_auto() {
    return MdiIcon.create(
        "mdi-flash-auto",
        new MdiMeta("flash-auto", "F0242", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon flash_off() {
    return MdiIcon.create(
        "mdi-flash-off",
        new MdiMeta("flash-off", "F0243", Arrays.asList(), Arrays.asList(), "Google", "1.5.54"));
  }

  public static MdiIcon flash_off_outline() {
    return MdiIcon.create(
        "mdi-flash-off-outline",
        new MdiMeta(
            "flash-off-outline",
            "F1B45",
            Arrays.asList(),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.9.96"));
  }

  public static MdiIcon flash_outline() {
    return MdiIcon.create(
        "mdi-flash-outline",
        new MdiMeta(
            "flash-outline",
            "F06D5",
            Arrays.asList("Weather"),
            Arrays.asList("lightning-bolt-outline"),
            "Michael Irigoyen",
            "1.8.36"));
  }

  public static MdiIcon flash_red_eye() {
    return MdiIcon.create(
        "mdi-flash-red-eye",
        new MdiMeta(
            "flash-red-eye",
            "F067B",
            Arrays.asList(),
            Arrays.asList(),
            "Austin Andrews",
            "1.7.12"));
  }

  public static MdiIcon flash_triangle() {
    return MdiIcon.create(
        "mdi-flash-triangle",
        new MdiMeta(
            "flash-triangle",
            "F1B1D",
            Arrays.asList("Home Automation"),
            Arrays.asList("high-voltage"),
            "tetzla",
            "6.9.96"));
  }

  public static MdiIcon flash_triangle_outline() {
    return MdiIcon.create(
        "mdi-flash-triangle-outline",
        new MdiMeta(
            "flash-triangle-outline",
            "F1B1E",
            Arrays.asList("Home Automation"),
            Arrays.asList("high-voltage-outline"),
            "tetzla",
            "6.9.96"));
  }

  public static MdiIcon flashlight() {
    return MdiIcon.create(
        "mdi-flashlight",
        new MdiMeta(
            "flashlight",
            "F0244",
            Arrays.asList(),
            Arrays.asList("torch"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon flashlight_off() {
    return MdiIcon.create(
        "mdi-flashlight-off",
        new MdiMeta(
            "flashlight-off",
            "F0245",
            Arrays.asList(),
            Arrays.asList("torch-off"),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon flask() {
    return MdiIcon.create(
        "mdi-flask",
        new MdiMeta(
            "flask",
            "F0093",
            Arrays.asList("Science", "Gaming / RPG"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon flask_empty() {
    return MdiIcon.create(
        "mdi-flask-empty",
        new MdiMeta(
            "flask-empty",
            "F0094",
            Arrays.asList("Science", "Gaming / RPG"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon flask_empty_minus() {
    return MdiIcon.create(
        "mdi-flask-empty-minus",
        new MdiMeta(
            "flask-empty-minus",
            "F123A",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon flask_empty_minus_outline() {
    return MdiIcon.create(
        "mdi-flask-empty-minus-outline",
        new MdiMeta(
            "flask-empty-minus-outline",
            "F123B",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon flask_empty_off() {
    return MdiIcon.create(
        "mdi-flask-empty-off",
        new MdiMeta(
            "flask-empty-off",
            "F13F4",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.1.45"));
  }

  public static MdiIcon flask_empty_off_outline() {
    return MdiIcon.create(
        "mdi-flask-empty-off-outline",
        new MdiMeta(
            "flask-empty-off-outline",
            "F13F5",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.1.45"));
  }

  public static MdiIcon flask_empty_outline() {
    return MdiIcon.create(
        "mdi-flask-empty-outline",
        new MdiMeta(
            "flask-empty-outline",
            "F0095",
            Arrays.asList("Science", "Gaming / RPG"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon flask_empty_plus() {
    return MdiIcon.create(
        "mdi-flask-empty-plus",
        new MdiMeta(
            "flask-empty-plus",
            "F123C",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon flask_empty_plus_outline() {
    return MdiIcon.create(
        "mdi-flask-empty-plus-outline",
        new MdiMeta(
            "flask-empty-plus-outline",
            "F123D",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon flask_empty_remove() {
    return MdiIcon.create(
        "mdi-flask-empty-remove",
        new MdiMeta(
            "flask-empty-remove",
            "F123E",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon flask_empty_remove_outline() {
    return MdiIcon.create(
        "mdi-flask-empty-remove-outline",
        new MdiMeta(
            "flask-empty-remove-outline",
            "F123F",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon flask_minus() {
    return MdiIcon.create(
        "mdi-flask-minus",
        new MdiMeta(
            "flask-minus",
            "F1240",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon flask_minus_outline() {
    return MdiIcon.create(
        "mdi-flask-minus-outline",
        new MdiMeta(
            "flask-minus-outline",
            "F1241",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon flask_off() {
    return MdiIcon.create(
        "mdi-flask-off",
        new MdiMeta(
            "flask-off", "F13F6", Arrays.asList(), Arrays.asList(), "Michael Irigoyen", "5.1.45"));
  }

  public static MdiIcon flask_off_outline() {
    return MdiIcon.create(
        "mdi-flask-off-outline",
        new MdiMeta(
            "flask-off-outline",
            "F13F7",
            Arrays.asList(),
            Arrays.asList(),
            "Michael Irigoyen",
            "5.1.45"));
  }

  public static MdiIcon flask_outline() {
    return MdiIcon.create(
        "mdi-flask-outline",
        new MdiMeta(
            "flask-outline",
            "F0096",
            Arrays.asList("Science", "Gaming / RPG"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon flask_plus() {
    return MdiIcon.create(
        "mdi-flask-plus",
        new MdiMeta(
            "flask-plus",
            "F1242",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon flask_plus_outline() {
    return MdiIcon.create(
        "mdi-flask-plus-outline",
        new MdiMeta(
            "flask-plus-outline",
            "F1243",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon flask_remove() {
    return MdiIcon.create(
        "mdi-flask-remove",
        new MdiMeta(
            "flask-remove",
            "F1244",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon flask_remove_outline() {
    return MdiIcon.create(
        "mdi-flask-remove-outline",
        new MdiMeta(
            "flask-remove-outline",
            "F1245",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon flask_round_bottom() {
    return MdiIcon.create(
        "mdi-flask-round-bottom",
        new MdiMeta(
            "flask-round-bottom",
            "F124B",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon flask_round_bottom_empty() {
    return MdiIcon.create(
        "mdi-flask-round-bottom-empty",
        new MdiMeta(
            "flask-round-bottom-empty",
            "F124C",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon flask_round_bottom_empty_outline() {
    return MdiIcon.create(
        "mdi-flask-round-bottom-empty-outline",
        new MdiMeta(
            "flask-round-bottom-empty-outline",
            "F124D",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon flask_round_bottom_outline() {
    return MdiIcon.create(
        "mdi-flask-round-bottom-outline",
        new MdiMeta(
            "flask-round-bottom-outline",
            "F124E",
            Arrays.asList("Science"),
            Arrays.asList(),
            "Austin Andrews",
            "4.6.95"));
  }

  public static MdiIcon fleur_de_lis() {
    return MdiIcon.create(
        "mdi-fleur-de-lis",
        new MdiMeta("fleur-de-lis", "F1303", Arrays.asList(), Arrays.asList(), "Nick", "4.8.95"));
  }

  public static MdiIcon flip_horizontal() {
    return MdiIcon.create(
        "mdi-flip-horizontal",
        new MdiMeta(
            "flip-horizontal",
            "F10E7",
            Arrays.asList("Arrange"),
            Arrays.asList(),
            "Google",
            "4.3.95"));
  }

  public static MdiIcon flip_to_back() {
    return MdiIcon.create(
        "mdi-flip-to-back",
        new MdiMeta(
            "flip-to-back",
            "F0247",
            Arrays.asList("Arrange"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon flip_to_front() {
    return MdiIcon.create(
        "mdi-flip-to-front",
        new MdiMeta(
            "flip-to-front",
            "F0248",
            Arrays.asList("Arrange"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon flip_vertical() {
    return MdiIcon.create(
        "mdi-flip-vertical",
        new MdiMeta(
            "flip-vertical",
            "F10E8",
            Arrays.asList("Arrange"),
            Arrays.asList(),
            "Google",
            "4.3.95"));
  }

  public static MdiIcon floor_lamp() {
    return MdiIcon.create(
        "mdi-floor-lamp",
        new MdiMeta(
            "floor-lamp",
            "F08DD",
            Arrays.asList("Home Automation"),
            Arrays.asList("floor-light"),
            "GreenTurtwig",
            "2.3.50"));
  }

  public static MdiIcon floor_lamp_dual() {
    return MdiIcon.create(
        "mdi-floor-lamp-dual",
        new MdiMeta(
            "floor-lamp-dual",
            "F1040",
            Arrays.asList("Home Automation"),
            Arrays.asList("floor-light-dual"),
            "Borre Haugen",
            "4.1.95"));
  }

  public static MdiIcon floor_lamp_dual_outline() {
    return MdiIcon.create(
        "mdi-floor-lamp-dual-outline",
        new MdiMeta(
            "floor-lamp-dual-outline",
            "F17CE",
            Arrays.asList("Home Automation"),
            Arrays.asList("floor-light-dual-outline"),
            "Michael Irigoyen",
            "6.1.95"));
  }

  public static MdiIcon floor_lamp_outline() {
    return MdiIcon.create(
        "mdi-floor-lamp-outline",
        new MdiMeta(
            "floor-lamp-outline",
            "F17C8",
            Arrays.asList("Home Automation"),
            Arrays.asList("floor-light-outline"),
            "Teodor Sandu",
            "6.1.95"));
  }

  public static MdiIcon floor_lamp_torchiere() {
    return MdiIcon.create(
        "mdi-floor-lamp-torchiere",
        new MdiMeta(
            "floor-lamp-torchiere",
            "F1747",
            Arrays.asList("Home Automation"),
            Arrays.asList("floor-light-torchiere"),
            "Michael Irigoyen",
            "6.1.95"));
  }

  public static MdiIcon floor_lamp_torchiere_outline() {
    return MdiIcon.create(
        "mdi-floor-lamp-torchiere-outline",
        new MdiMeta(
            "floor-lamp-torchiere-outline",
            "F17D6",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.1.95"));
  }

  public static MdiIcon floor_lamp_torchiere_variant() {
    return MdiIcon.create(
        "mdi-floor-lamp-torchiere-variant",
        new MdiMeta(
            "floor-lamp-torchiere-variant",
            "F1041",
            Arrays.asList("Home Automation"),
            Arrays.asList("floor-light-torchiere-variant"),
            "Borre Haugen",
            "4.1.95"));
  }

  public static MdiIcon floor_lamp_torchiere_variant_outline() {
    return MdiIcon.create(
        "mdi-floor-lamp-torchiere-variant-outline",
        new MdiMeta(
            "floor-lamp-torchiere-variant-outline",
            "F17CF",
            Arrays.asList("Home Automation"),
            Arrays.asList("floor-light-torchiere-variant-outline"),
            "Michael Irigoyen",
            "6.1.95"));
  }

  public static MdiIcon floor_plan() {
    return MdiIcon.create(
        "mdi-floor-plan",
        new MdiMeta(
            "floor-plan",
            "F0821",
            Arrays.asList("Home Automation"),
            Arrays.asList(),
            "james-fry",
            "2.1.19"));
  }

  public static MdiIcon floppy() {
    return MdiIcon.create(
        "mdi-floppy",
        new MdiMeta(
            "floppy", "F0249", Arrays.asList(), Arrays.asList(), "Austin Andrews", "1.5.54"));
  }

  public static MdiIcon floppy_variant() {
    return MdiIcon.create(
        "mdi-floppy-variant",
        new MdiMeta(
            "floppy-variant", "F09EF", Arrays.asList(), Arrays.asList(), "GreenTurtwig", "2.5.94"));
  }

  public static MdiIcon flower() {
    return MdiIcon.create(
        "mdi-flower",
        new MdiMeta(
            "flower",
            "F024A",
            Arrays.asList("Nature", "Agriculture"),
            Arrays.asList("local-florist", "plant"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon flower_outline() {
    return MdiIcon.create(
        "mdi-flower-outline",
        new MdiMeta(
            "flower-outline",
            "F09F0",
            Arrays.asList("Nature", "Agriculture"),
            Arrays.asList("local-florist-outline", "plant"),
            "Google",
            "2.5.94"));
  }

  public static MdiIcon flower_pollen() {
    return MdiIcon.create(
        "mdi-flower-pollen",
        new MdiMeta(
            "flower-pollen",
            "F1885",
            Arrays.asList("Nature", "Agriculture"),
            Arrays.asList("allergy"),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon flower_pollen_outline() {
    return MdiIcon.create(
        "mdi-flower-pollen-outline",
        new MdiMeta(
            "flower-pollen-outline",
            "F1886",
            Arrays.asList("Nature", "Agriculture"),
            Arrays.asList("allergy-outline"),
            "Colton Wiscombe",
            "6.2.95"));
  }

  public static MdiIcon flower_poppy() {
    return MdiIcon.create(
        "mdi-flower-poppy",
        new MdiMeta(
            "flower-poppy",
            "F0D08",
            Arrays.asList("Nature", "Agriculture"),
            Arrays.asList("plant"),
            "Colton Wiscombe",
            "3.3.92"));
  }

  public static MdiIcon flower_tulip() {
    return MdiIcon.create(
        "mdi-flower-tulip",
        new MdiMeta(
            "flower-tulip",
            "F09F1",
            Arrays.asList("Nature", "Agriculture"),
            Arrays.asList("plant"),
            "Michael Richins",
            "2.5.94"));
  }

  public static MdiIcon flower_tulip_outline() {
    return MdiIcon.create(
        "mdi-flower-tulip-outline",
        new MdiMeta(
            "flower-tulip-outline",
            "F09F2",
            Arrays.asList("Nature", "Agriculture"),
            Arrays.asList("plant"),
            "Michael Richins",
            "2.5.94"));
  }

  public static MdiIcon focus_auto() {
    return MdiIcon.create(
        "mdi-focus-auto",
        new MdiMeta(
            "focus-auto",
            "F0F4E",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Simran",
            "3.9.97"));
  }

  public static MdiIcon focus_field() {
    return MdiIcon.create(
        "mdi-focus-field",
        new MdiMeta(
            "focus-field",
            "F0F4F",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Simran",
            "3.9.97"));
  }

  public static MdiIcon focus_field_horizontal() {
    return MdiIcon.create(
        "mdi-focus-field-horizontal",
        new MdiMeta(
            "focus-field-horizontal",
            "F0F50",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Simran",
            "3.9.97"));
  }

  public static MdiIcon focus_field_vertical() {
    return MdiIcon.create(
        "mdi-focus-field-vertical",
        new MdiMeta(
            "focus-field-vertical",
            "F0F51",
            Arrays.asList("Photography"),
            Arrays.asList(),
            "Simran",
            "3.9.97"));
  }

  public static MdiIcon folder() {
    return MdiIcon.create(
        "mdi-folder",
        new MdiMeta(
            "folder",
            "F024B",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon folder_account() {
    return MdiIcon.create(
        "mdi-folder-account",
        new MdiMeta(
            "folder-account",
            "F024C",
            Arrays.asList("Account / User", "Files / Folders"),
            Arrays.asList("folder-user", "folder-shared"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon folder_account_outline() {
    return MdiIcon.create(
        "mdi-folder-account-outline",
        new MdiMeta(
            "folder-account-outline",
            "F0B9C",
            Arrays.asList("Files / Folders", "Account / User"),
            Arrays.asList("folder-user-outline", "folder-shared-outline"),
            "Google",
            "3.0.39"));
  }

  public static MdiIcon folder_alert() {
    return MdiIcon.create(
        "mdi-folder-alert",
        new MdiMeta(
            "folder-alert",
            "F0DCC",
            Arrays.asList("Files / Folders", "Alert / Error"),
            Arrays.asList("folder-warning"),
            "Michael Irigoyen",
            "3.5.94"));
  }

  public static MdiIcon folder_alert_outline() {
    return MdiIcon.create(
        "mdi-folder-alert-outline",
        new MdiMeta(
            "folder-alert-outline",
            "F0DCD",
            Arrays.asList("Files / Folders", "Alert / Error"),
            Arrays.asList("folder-warning-outline"),
            "Michael Irigoyen",
            "3.5.94"));
  }

  public static MdiIcon folder_arrow_down() {
    return MdiIcon.create(
        "mdi-folder-arrow-down",
        new MdiMeta(
            "folder-arrow-down",
            "F19E8",
            Arrays.asList("Files / Folders"),
            Arrays.asList("folder-download"),
            "Colton Wiscombe",
            "6.6.96"));
  }

  public static MdiIcon folder_arrow_down_outline() {
    return MdiIcon.create(
        "mdi-folder-arrow-down-outline",
        new MdiMeta(
            "folder-arrow-down-outline",
            "F19E9",
            Arrays.asList("Files / Folders"),
            Arrays.asList("folder-download-outline"),
            "Colton Wiscombe",
            "6.6.96"));
  }

  public static MdiIcon folder_arrow_left() {
    return MdiIcon.create(
        "mdi-folder-arrow-left",
        new MdiMeta(
            "folder-arrow-left",
            "F19EA",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.6.96"));
  }

  public static MdiIcon folder_arrow_left_outline() {
    return MdiIcon.create(
        "mdi-folder-arrow-left-outline",
        new MdiMeta(
            "folder-arrow-left-outline",
            "F19EB",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.6.96"));
  }

  public static MdiIcon folder_arrow_left_right() {
    return MdiIcon.create(
        "mdi-folder-arrow-left-right",
        new MdiMeta(
            "folder-arrow-left-right",
            "F19EC",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.6.96"));
  }

  public static MdiIcon folder_arrow_left_right_outline() {
    return MdiIcon.create(
        "mdi-folder-arrow-left-right-outline",
        new MdiMeta(
            "folder-arrow-left-right-outline",
            "F19ED",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.6.96"));
  }

  public static MdiIcon folder_arrow_right() {
    return MdiIcon.create(
        "mdi-folder-arrow-right",
        new MdiMeta(
            "folder-arrow-right",
            "F19EE",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.6.96"));
  }

  public static MdiIcon folder_arrow_right_outline() {
    return MdiIcon.create(
        "mdi-folder-arrow-right-outline",
        new MdiMeta(
            "folder-arrow-right-outline",
            "F19EF",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.6.96"));
  }

  public static MdiIcon folder_arrow_up() {
    return MdiIcon.create(
        "mdi-folder-arrow-up",
        new MdiMeta(
            "folder-arrow-up",
            "F19F0",
            Arrays.asList("Files / Folders"),
            Arrays.asList("folder-upload"),
            "Colton Wiscombe",
            "6.6.96"));
  }

  public static MdiIcon folder_arrow_up_down() {
    return MdiIcon.create(
        "mdi-folder-arrow-up-down",
        new MdiMeta(
            "folder-arrow-up-down",
            "F19F1",
            Arrays.asList("Files / Folders"),
            Arrays.asList("folder-transfer"),
            "Colton Wiscombe",
            "6.6.96"));
  }

  public static MdiIcon folder_arrow_up_down_outline() {
    return MdiIcon.create(
        "mdi-folder-arrow-up-down-outline",
        new MdiMeta(
            "folder-arrow-up-down-outline",
            "F19F2",
            Arrays.asList("Files / Folders"),
            Arrays.asList("folder-transfer-outline"),
            "Colton Wiscombe",
            "6.6.96"));
  }

  public static MdiIcon folder_arrow_up_outline() {
    return MdiIcon.create(
        "mdi-folder-arrow-up-outline",
        new MdiMeta(
            "folder-arrow-up-outline",
            "F19F3",
            Arrays.asList("Files / Folders"),
            Arrays.asList("folder-upload-outline"),
            "Colton Wiscombe",
            "6.6.96"));
  }

  public static MdiIcon folder_cancel() {
    return MdiIcon.create(
        "mdi-folder-cancel",
        new MdiMeta(
            "folder-cancel",
            "F19F4",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.6.96"));
  }

  public static MdiIcon folder_cancel_outline() {
    return MdiIcon.create(
        "mdi-folder-cancel-outline",
        new MdiMeta(
            "folder-cancel-outline",
            "F19F5",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.6.96"));
  }

  public static MdiIcon folder_check() {
    return MdiIcon.create(
        "mdi-folder-check",
        new MdiMeta(
            "folder-check",
            "F197E",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.5.95"));
  }

  public static MdiIcon folder_check_outline() {
    return MdiIcon.create(
        "mdi-folder-check-outline",
        new MdiMeta(
            "folder-check-outline",
            "F197F",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.5.95"));
  }

  public static MdiIcon folder_clock() {
    return MdiIcon.create(
        "mdi-folder-clock",
        new MdiMeta(
            "folder-clock",
            "F0ABA",
            Arrays.asList("Files / Folders", "Date / Time"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.7.94"));
  }

  public static MdiIcon folder_clock_outline() {
    return MdiIcon.create(
        "mdi-folder-clock-outline",
        new MdiMeta(
            "folder-clock-outline",
            "F0ABB",
            Arrays.asList("Files / Folders", "Date / Time"),
            Arrays.asList(),
            "Austin Andrews",
            "2.7.94"));
  }

  public static MdiIcon folder_cog() {
    return MdiIcon.create(
        "mdi-folder-cog",
        new MdiMeta(
            "folder-cog",
            "F107F",
            Arrays.asList("Settings", "Files / Folders"),
            Arrays.asList("folder-cog"),
            "Simran",
            "4.2.95"));
  }

  public static MdiIcon folder_cog_outline() {
    return MdiIcon.create(
        "mdi-folder-cog-outline",
        new MdiMeta(
            "folder-cog-outline",
            "F1080",
            Arrays.asList("Settings", "Files / Folders"),
            Arrays.asList("folder-cog-outline"),
            "Simran",
            "4.2.95"));
  }

  public static MdiIcon folder_download() {
    return MdiIcon.create(
        "mdi-folder-download",
        new MdiMeta(
            "folder-download",
            "F024D",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon folder_download_outline() {
    return MdiIcon.create(
        "mdi-folder-download-outline",
        new MdiMeta(
            "folder-download-outline",
            "F10E9",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Richins",
            "4.3.95"));
  }

  public static MdiIcon folder_edit() {
    return MdiIcon.create(
        "mdi-folder-edit",
        new MdiMeta(
            "folder-edit",
            "F08DE",
            Arrays.asList("Files / Folders", "Edit / Modify"),
            Arrays.asList(),
            "GreenTurtwig",
            "2.3.50"));
  }

  public static MdiIcon folder_edit_outline() {
    return MdiIcon.create(
        "mdi-folder-edit-outline",
        new MdiMeta(
            "folder-edit-outline",
            "F0DCE",
            Arrays.asList("Edit / Modify", "Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "3.5.94"));
  }

  public static MdiIcon folder_eye() {
    return MdiIcon.create(
        "mdi-folder-eye",
        new MdiMeta(
            "folder-eye",
            "F178A",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.1.95"));
  }

  public static MdiIcon folder_eye_outline() {
    return MdiIcon.create(
        "mdi-folder-eye-outline",
        new MdiMeta(
            "folder-eye-outline",
            "F178B",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.1.95"));
  }

  public static MdiIcon folder_file() {
    return MdiIcon.create(
        "mdi-folder-file",
        new MdiMeta(
            "folder-file",
            "F19F6",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.6.96"));
  }

  public static MdiIcon folder_file_outline() {
    return MdiIcon.create(
        "mdi-folder-file-outline",
        new MdiMeta(
            "folder-file-outline",
            "F19F7",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Colton Wiscombe",
            "6.6.96"));
  }

  @Deprecated
  public static MdiIcon folder_google_drive() {
    return MdiIcon.create(
        "mdi-folder-google-drive",
        new MdiMeta(
            "folder-google-drive",
            "F024E",
            Arrays.asList("Files / Folders", "Brand / Logo"),
            Arrays.asList("folder-mydrive"),
            "Google",
            "1.5.54"));
  }

  public static MdiIcon folder_heart() {
    return MdiIcon.create(
        "mdi-folder-heart",
        new MdiMeta(
            "folder-heart",
            "F10EA",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.3.95"));
  }

  public static MdiIcon folder_heart_outline() {
    return MdiIcon.create(
        "mdi-folder-heart-outline",
        new MdiMeta(
            "folder-heart-outline",
            "F10EB",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.3.95"));
  }

  public static MdiIcon folder_hidden() {
    return MdiIcon.create(
        "mdi-folder-hidden",
        new MdiMeta(
            "folder-hidden",
            "F179E",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "6.1.95"));
  }

  public static MdiIcon folder_home() {
    return MdiIcon.create(
        "mdi-folder-home",
        new MdiMeta(
            "folder-home",
            "F10B5",
            Arrays.asList("Files / Folders", "Home Automation"),
            Arrays.asList("folder-house"),
            "Mitch Berninger",
            "4.2.95"));
  }

  public static MdiIcon folder_home_outline() {
    return MdiIcon.create(
        "mdi-folder-home-outline",
        new MdiMeta(
            "folder-home-outline",
            "F10B6",
            Arrays.asList("Files / Folders", "Home Automation"),
            Arrays.asList("folder-house-outline"),
            "Mitch Berninger",
            "4.2.95"));
  }

  public static MdiIcon folder_image() {
    return MdiIcon.create(
        "mdi-folder-image",
        new MdiMeta(
            "folder-image",
            "F024F",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Austin Andrews",
            "1.5.54"));
  }

  public static MdiIcon folder_information() {
    return MdiIcon.create(
        "mdi-folder-information",
        new MdiMeta(
            "folder-information",
            "F10B7",
            Arrays.asList("Files / Folders"),
            Arrays.asList(),
            "Michael Irigoyen",
            "4.2.95"));
  }

  public static MdiIcon folder_information_outline() {
    return MdiIcon.create(
        "mdi-folder-information-outline",
        new MdiMeta(
            "folder-information-outline",
            "F10B8",
            Arrays.asList("Files / Folders"),
            A