/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "bo_IN" locale.
 */

import org.gwtproject.i18n.shared.cldr.DateTimeFormatInfoImpl;

public class DateTimeFormatInfoImpl_bo_IN extends DateTimeFormatInfoImpl_bo {

  @Override
  public String[] ampms() {
    return new String[] {
        "སྔ་དྲོ་",
        "ཕྱི་དྲོ་"
    };
  }

  @Override
  public String dateFormat() {
    return dateFormatMedium();
  }

  @Override
  public String dateFormatFull() {
    return "y MMMMའི་ཚེས་d, EEEE";
  }

  @Override
  public String dateFormatLong() {
    return "སྤྱི་ལོ་y MMMMའི་ཚེས་d";
  }

  @Override
  public String dateFormatMedium() {
    return "y ལོའི་MMMཚེས་d";
  }

  @Override
  public String dateFormatShort() {
    return "y-MM-dd";
  }

  @Override
  public String dateTime(String timePattern, String datePattern) {
    return dateTimeMedium(timePattern, datePattern);
  }

  @Override
  public String dateTimeFull(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String dateTimeLong(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String dateTimeMedium(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String dateTimeShort(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "སྤྱི་ལོ་སྔོན་",
        "སྤྱི་ལོ་"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "སྤྱི་ལོ་སྔོན་",
        "སྤྱི་ལོ་"
    };
  }

  @Override
  public int firstDayOfTheWeek() {
    return 0;
  }

  @Override
  public String formatDay() {
    return "d";
  }

  @Override
  public String formatHour12Minute() {
    return "h:mm a";
  }

  @Override
  public String formatHour12MinuteSecond() {
    return "h:mm:ss a";
  }

  @Override
  public String formatHour24Minute() {
    return "HH:mm";
  }

  @Override
  public String formatHour24MinuteSecond() {
    return "HH:mm:ss";
  }

  @Override
  public String formatMinuteSecond() {
    return "mm:ss";
  }

  @Override
  public String formatMonthAbbrev() {
    return "LLL";
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "MMMཚེས་d";
  }

  @Override
  public String formatMonthFull() {
    return "LLLL";
  }

  @Override
  public String formatMonthFullDay() {
    return "MMMMའི་ཚེས་d";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "MMMMཚེས་d, EEEE";
  }

  @Override
  public String formatMonthNumDay() {
    return "MM-dd";
  }

  @Override
  public String formatYear() {
    return "y";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "y LLL";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "y ལོའི་MMMཚེས་d";
  }

  @Override
  public String formatYearMonthFull() {
    return "y MMMM";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "སྤྱི་ལོ་y MMMMའི་ཚེས་d";
  }

  @Override
  public String formatYearMonthNum() {
    return "y-MM";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "y-M-d";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "y MMM d, EEE";
  }

  @Override
  public String formatYearQuarterFull() {
    return "y QQQQ";
  }

  @Override
  public String formatYearQuarterShort() {
    return "y Q";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "ཟླ་བ་དང་པོ",
        "ཟླ་བ་གཉིས་པ",
        "ཟླ་བ་གསུམ་པ",
        "ཟླ་བ་བཞི་པ",
        "ཟླ་བ་ལྔ་པ",
        "ཟླ་བ་དྲུག་པ",
        "ཟླ་བ་བདུན་པ",
        "ཟླ་བ་བརྒྱད་པ",
        "ཟླ་བ་དགུ་པ",
        "ཟླ་བ་བཅུ་པ",
        "ཟླ་བ་བཅུ་གཅིག་པ",
        "ཟླ་བ་བཅུ་གཉིས་པ"
    };
  }

  @Override
  public String[] monthsFullStandalone() {
    return new String[] {
        "ཟླ་བ་དང་པོ་",
        "ཟླ་བ་གཉིས་པ་",
        "ཟླ་བ་གསུམ་པ་",
        "ཟླ་བ་བཞི་པ་",
        "ཟླ་བ་ལྔ་པ་",
        "ཟླ་བ་དྲུག་པ་",
        "ཟླ་བ་བདུན་པ་",
        "ཟླ་བ་བརྒྱད་པ་",
        "ཟླ་བ་དགུ་པ་",
        "ཟླ་བ་བཅུ་པ་",
        "ཟླ་བ་བཅུ་གཅིག་པ་",
        "ཟླ་བ་བཅུ་གཉིས་པ་"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "1",
        "2",
        "3",
        "4",
        "5",
        "6",
        "7",
        "8",
        "9",
        "10",
        "11",
        "12"
    };
  }

  @Override
  public String[] monthsNarrowStandalone() {
    return monthsNarrow();
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "ཟླ་༡",
        "ཟླ་༢",
        "ཟླ་༣",
        "ཟླ་༤",
        "ཟླ་༥",
        "ཟླ་༦",
        "ཟླ་༧",
        "ཟླ་༨",
        "ཟླ་༩",
        "ཟླ་༡༠",
        "ཟླ་༡༡",
        "ཟླ་༡༢"
    };
  }

  @Override
  public String[] monthsShortStandalone() {
    return monthsShort();
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "དུས་ཚིགས་དང་པོ།",
        "དུས་ཚིགས་གཉིས་པ།",
        "དུས་ཚིགས་གསུམ་པ།",
        "དུས་ཚིགས་བཞི་པ།"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "དུས་ཚིགས་དང་པོ།",
        "དུས་ཚིགས་གཉིས་པ།",
        "དུས་ཚིགས་གསུམ་པ།",
        "དུས་ཚིགས་བཞི་པ།"
    };
  }

  @Override
  public String timeFormat() {
    return timeFormatMedium();
  }

  @Override
  public String timeFormatFull() {
    return "h:mm:ss a zzzz";
  }

  @Override
  public String timeFormatLong() {
    return "h:mm:ss a z";
  }

  @Override
  public String timeFormatMedium() {
    return "h:mm:ss a";
  }

  @Override
  public String timeFormatShort() {
    return "h:mm a";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "གཟའ་ཉི་མ་",
        "གཟའ་ཟླ་བ་",
        "གཟའ་མིག་དམར་",
        "གཟའ་ལྷག་པ་",
        "གཟའ་ཕུར་བུ་",
        "གཟའ་པ་སངས་",
        "གཟའ་སྤེན་པ་"
    };
  }

  @Override
  public String[] weekdaysFullStandalone() {
    return weekdaysFull();
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "ཉི",
        "ཟླ",
        "མིག",
        "ལྷག",
        "ཕུར",
        "སངས",
        "སྤེན"
    };
  }

  @Override
  public String[] weekdaysNarrowStandalone() {
    return weekdaysNarrow();
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "ཉི་མ་",
        "ཟླ་བ་",
        "མིག་དམར་",
        "ལྷག་པ་",
        "ཕུར་བུ་",
        "པ་སངས་",
        "སྤེན་པ་"
    };
  }

  @Override
  public String[] weekdaysShortStandalone() {
    return weekdaysShort();
  }

  @Override
  public int weekendEnd() {
    return 0;
  }

  @Override
  public int weekendStart() {
    return 0;
  }
}
