/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;

import org.gwtproject.i18n.shared.cldr.LocalizedNamesImplBase;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "bas" locale.
 */
public class LocalizedNamesImpl_bas extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "US",
        "AE",
        "GB",
        "AF",
        "ZA",
        "HT",
        "AL",
        "DZ",
        "AQ",
        "AR",
        "AM",
        "AW",
        "AS",
        "AX",
        "AZ",
        "AD",
        "AI",
        "AO",
        "AG",
        "BS",
        "BH",
        "BB",
        "BD",
        "BY",
        "BZ",
        "BJ",
        "FK",
        "KY",
        "CK",
        "VI",
        "VG",
        "MH",
        "MP",
        "SB",
        "TC",
        "IO",
        "BL",
        "BW",
        "BA",
        "BO",
        "BQ",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "BT",
        "BV",
        "BE",
        "BM",
        "TD",
        "CC",
        "CP",
        "CW",
        "CX",
        "CZ",
        "DK",
        "DG",
        "DM",
        "DO",
        "EA",
        "EG",
        "EH",
        "EC",
        "ER",
        "EE",
        "ET",
        "EU",
        "EZ",
        "FJ",
        "PH",
        "FI",
        "FO",
        "GA",
        "GM",
        "GH",
        "GE",
        "GG",
        "GI",
        "GN",
        "GW",
        "GQ",
        "PG",
        "GD",
        "GR",
        "GL",
        "GS",
        "GU",
        "GY",
        "GF",
        "GP",
        "GT",
        "HK",
        "HM",
        "IC",
        "IM",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IL",
        "IT",
        "JM",
        "DE",
        "JE",
        "DJ",
        "JP",
        "CV",
        "NC",
        "KH",
        "CM",
        "CA",
        "QA",
        "KZ",
        "KE",
        "CL",
        "CN",
        "CY",
        "KG",
        "KI",
        "CR",
        "KW",
        "CG",
        "CD",
        "HR",
        "CU",
        "CO",
        "KM",
        "KR",
        "KP",
        "LV",
        "LA",
        "LB",
        "LS",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MG",
        "MW",
        "MV",
        "ML",
        "MT",
        "MY",
        "MA",
        "MQ",
        "MK",
        "YT",
        "CI",
        "ME",
        "MF",
        "FM",
        "MO",
        "MD",
        "MC",
        "MU",
        "MR",
        "MZ",
        "MN",
        "MM",
        "MS",
        "MX",
        "NA",
        "NP",
        "NR",
        "NG",
        "NE",
        "NI",
        "NU",
        "NL",
        "KN",
        "LC",
        "SM",
        "PM",
        "VC",
        "SH",
        "NO",
        "OM",
        "NF",
        "AU",
        "AT",
        "PK",
        "PW",
        "PS",
        "PA",
        "ES",
        "PY",
        "PE",
        "PN",
        "PL",
        "PF",
        "FR",
        "PR",
        "PT",
        "QO",
        "RE",
        "RS",
        "RW",
        "RO",
        "RU",
        "SV",
        "WS",
        "ST",
        "SA",
        "SN",
        "SC",
        "SL",
        "NZ",
        "SY",
        "SG",
        "SJ",
        "SK",
        "SI",
        "SO",
        "LK",
        "SS",
        "SD",
        "SR",
        "CH",
        "SZ",
        "SE",
        "SX",
        "TA",
        "TJ",
        "TZ",
        "TH",
        "TW",
        "TF",
        "TL",
        "TG",
        "TK",
        "TT",
        "TN",
        "TM",
        "TR",
        "TV",
        "TO",
        "UG",
        "UA",
        "UM",
        "UN",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "XA",
        "XB",
        "XK",
        "YE",
        "JO",
        "ZM",
        "ZW",
        "CF",
        "HN",
        "HU",
    };
  }

  @Override
  protected void loadNameMap() {
    super.loadNameMap();
    namesMap.put("AD", "Àŋdɔ̂r");
    namesMap.put("AE", "Àdnà i Bilɔ̀ŋ bi Arābìà");
    namesMap.put("AF", "Àfgànìstâŋ");
    namesMap.put("AG", "Àŋtigà ɓɔ Bàrbudà");
    namesMap.put("AI", "Àŋgiyà");
    namesMap.put("AL", "Àlbanìà");
    namesMap.put("AM", "Àrmenìà");
    namesMap.put("AO", "Àŋgolà");
    namesMap.put("AR", "Àrgàŋtinà");
    namesMap.put("AT", "Òstrǐk");
    namesMap.put("AU", "Òstralìà");
    namesMap.put("AW", "Àrubà");
    namesMap.put("AZ", "Àzɛ̀rbajàŋ");
    namesMap.put("BA", "Bòhnià Ɛrzègòvinà");
    namesMap.put("BB", "Bàrbadò");
    namesMap.put("BD", "Bàŋglàdɛ̂s");
    namesMap.put("BE", "Bɛlgyùm");
    namesMap.put("BF", "Bùrkìnà Fasò");
    namesMap.put("BG", "Bùlgarìà");
    namesMap.put("BH", "Bàraìn");
    namesMap.put("BI", "Bùrundì");
    namesMap.put("BJ", "Bènɛ̂ŋ");
    namesMap.put("BM", "Bɛ̀rmudà");
    namesMap.put("BO", "Bòlivìà");
    namesMap.put("BR", "Bràsîl");
    namesMap.put("BS", "Bàhamàs");
    namesMap.put("BT", "Bùtân");
    namesMap.put("BW", "Bòdsùanà");
    namesMap.put("BY", "Bèlarùs");
    namesMap.put("BZ", "Bèlîs");
    namesMap.put("CA", "Kànadà");
    namesMap.put("CD", "Kòŋgo ìkɛŋi");
    namesMap.put("CF", "Ŋ̀ɛm Afrīkà");
    namesMap.put("CG", "Kòŋgo");
    namesMap.put("CH", "Sùwîs");
    namesMap.put("CI", "Màŋ mi Njɔ̂k");
    namesMap.put("CK", "Bìòn bi Kook");
    namesMap.put("CL", "Kìlî");
    namesMap.put("CM", "Kàmɛ̀rûn");
    namesMap.put("CN", "Kinà");
    namesMap.put("CO", "Kɔ̀lɔmbìà");
    namesMap.put("CR", "Kòstà Rikà");
    namesMap.put("CU", "Kubà");
    namesMap.put("CV", "Kabwɛ᷆r");
    namesMap.put("CY", "Kiprò");
    namesMap.put("DE", "Jamân");
    namesMap.put("DJ", "Jìbutì");
    namesMap.put("DK", "Dànmârk");
    namesMap.put("DM", "Dòmnîk");
    namesMap.put("DO", "Dòmnikà");
    namesMap.put("DZ", "Àlgerìà");
    namesMap.put("EC", "Èkwàtorìà");
    namesMap.put("EE", "Èstonìà");
    namesMap.put("EG", "Ègîptò");
    namesMap.put("ER", "Èrìtrěà");
    namesMap.put("ES", "Pànya");
    namesMap.put("ET", "Ètìopìà");
    namesMap.put("FI", "Fìnlând");
    namesMap.put("FK", "Bìòn bi Falkland");
    namesMap.put("FM", "Mìkrònesìà");
    namesMap.put("FR", "Pùlàsi / Fɛ̀lɛ̀nsi /");
    namesMap.put("GA", "Gàbɔ̂ŋ");
    namesMap.put("GB", "Àdnà i Lɔ̂ŋ");
    namesMap.put("GD", "Grènadà");
    namesMap.put("GE", "Gèɔrgìà");
    namesMap.put("GF", "Gùyanà Pùlàsi");
    namesMap.put("GH", "Ganà");
    namesMap.put("GI", "Gìlbràtâr");
    namesMap.put("GL", "Grǐnlànd");
    namesMap.put("GM", "Gàmbià");
    namesMap.put("GN", "Gìnê");
    namesMap.put("GP", "Gwàdèlûp");
    namesMap.put("GQ", "Gìne Èkwàtorìà");
    namesMap.put("GR", "Grǐkyà");
    namesMap.put("GT", "Gwàtèmalà");
    namesMap.put("GU", "Gùâm");
    namesMap.put("GW", "Gìne Bìsàô");
    namesMap.put("GY", "Gùyanà");
    namesMap.put("HN", "Ɔ̀ŋduràs");
    namesMap.put("HR", "Kròasìà");
    namesMap.put("HT", "Àitì");
    namesMap.put("HU", "Ɔ̀ŋgriì");
    namesMap.put("ID", "Indònèsià");
    namesMap.put("IE", "Ìrlând");
    namesMap.put("IL", "Isràɛ̂l");
    namesMap.put("IN", "Indìà");
    namesMap.put("IO", "Bìtèk bi Ŋgisì i Tūyɛ Īndìà");
    namesMap.put("IQ", "Ìrâk");
    namesMap.put("IR", "Ìrâŋ");
    namesMap.put("IS", "Ìslandìà");
    namesMap.put("IT", "Ìtalìà");
    namesMap.put("JM", "Jàmàikà");
    namesMap.put("JO", "Yɔ̀rdanià");
    namesMap.put("KE", "Kenìà");
    namesMap.put("KG", "Kìrgìzìstàŋ");
    namesMap.put("KH", "Kàmbodìà");
    namesMap.put("KI", "Kìrìbatì");
    namesMap.put("KM", "Kɔ̀mɔ̂r");
    namesMap.put("KN", "Nûmpubi Kîts nì Nevìs");
    namesMap.put("KP", "Kɔ̀re ì Ŋ̀ɔmbɔk");
    namesMap.put("KR", "Kɔ̀re ì Ŋ̀wɛ̀lmbɔk");
    namesMap.put("KW", "Kòwêt");
    namesMap.put("KY", "Bìòn bi Kaymàn");
    namesMap.put("KZ", "Kàzàkstâŋ");
    namesMap.put("LA", "Làôs");
    namesMap.put("LB", "Lèbanòn");
    namesMap.put("LC", "Nûmpubi Lusì");
    namesMap.put("LI", "Ligstɛntàn");
    namesMap.put("LK", "Srìlaŋkà");
    namesMap.put("LR", "Lìberìà");
    namesMap.put("LS", "Lesòtò");
    namesMap.put("LT", "Lìtùanìà");
    namesMap.put("LU", "Lùgsàmbûr");
    namesMap.put("LV", "Làdvià");
    namesMap.put("LY", "Libìà");
    namesMap.put("MA", "Màrokò");
    namesMap.put("MC", "Mònakò");
    namesMap.put("MD", "Moldavìà");
    namesMap.put("MG", "Màdàgàskâr");
    namesMap.put("MH", "Bìòn bi Marcàl");
    namesMap.put("MK", "Màsèdonìà");
    namesMap.put("ML", "Màli");
    namesMap.put("MM", "Myànmâr");
    namesMap.put("MN", "Mòŋgolìà");
    namesMap.put("MP", "Bìòn bi Marìanà ŋ̀ɔmbɔk");
    namesMap.put("MQ", "Màrtìnîk");
    namesMap.put("MR", "Mòrìtanìà");
    namesMap.put("MS", "Mɔ̀ŋseràt");
    namesMap.put("MT", "Maltà");
    namesMap.put("MU", "Mòrîs");
    namesMap.put("MV", "Màldîf");
    namesMap.put("MW", "Màlàwi");
    namesMap.put("MX", "Mɛ̀gsîk");
    namesMap.put("MY", "Màlɛ̀sìà");
    namesMap.put("MZ", "Mòsàmbîk");
    namesMap.put("NA", "Nàmibìà");
    namesMap.put("NC", "Kàlèdonìà Yɔ̀ndɔ");
    namesMap.put("NE", "Nìjɛ̂r");
    namesMap.put("NF", "Òn i Nɔrfɔ̂k");
    namesMap.put("NG", "Nìgerìà");
    namesMap.put("NI", "Nìkàragwà");
    namesMap.put("NL", "Ǹlɛndi");
    namesMap.put("NO", "Nɔ̀rvegìà");
    namesMap.put("NP", "Nèpâl");
    namesMap.put("NR", "Nerù");
    namesMap.put("NU", "Nìuɛ̀");
    namesMap.put("NZ", "Sìlând Yɔ̀ndɔ");
    namesMap.put("OM", "Òmân");
    namesMap.put("PA", "Pànàma");
    namesMap.put("PE", "Pèrû");
    namesMap.put("PF", "Pòlìnesìà Pùlàsi");
    namesMap.put("PG", "Gìne ì Pàpu");
    namesMap.put("PH", "Fìlìpîn");
    namesMap.put("PK", "Pàkìstân");
    namesMap.put("PL", "Pòlànd");
    namesMap.put("PM", "Nûmpubi Petrò nì Mikèlôn");
    namesMap.put("PN", "Pìdkaìrn");
    namesMap.put("PR", "Pɔ̀rtò Rikò");
    namesMap.put("PS", "Pàlɛ̀htinà Hyɔ̀ŋg nì Gazà");
    namesMap.put("PT", "Pɔ̀tɔkì");
    namesMap.put("PW", "Pàlaù");
    namesMap.put("PY", "Pàràgwê");
    namesMap.put("QA", "Kàtâr");
    namesMap.put("RE", "Rèunyɔ̂ŋ");
    namesMap.put("RO", "Rùmanìà");
    namesMap.put("RU", "Ruslànd");
    namesMap.put("RW", "Rùandà");
    namesMap.put("SA", "Sàudi Àrabìà");
    namesMap.put("SB", "Bìòn bi Salōmò");
    namesMap.put("SC", "Sèsɛ̂l");
    namesMap.put("SD", "Sùdâŋ");
    namesMap.put("SE", "Swedɛ̀n");
    namesMap.put("SG", "Sìŋgàpûr");
    namesMap.put("SH", "Nûmpubi Ɛlēnà");
    namesMap.put("SI", "Slòvanìà");
    namesMap.put("SK", "Slòvakìà");
    namesMap.put("SL", "Sièra Lèɔ̂n");
    namesMap.put("SM", "Nûmpubi Māatìn");
    namesMap.put("SN", "Sènègâl");
    namesMap.put("SO", "Sòmalìà");
    namesMap.put("SR", "Sùrinâm");
    namesMap.put("ST", "Sào Tòme ɓɔ Prɛ̀ŋcipè");
    namesMap.put("SV", "Sàlvàdɔ̂r");
    namesMap.put("SY", "Sirìà");
    namesMap.put("SZ", "Swàzìlând");
    namesMap.put("TC", "Bìòn bi Tûrks nì Kalkòs");
    namesMap.put("TD", "Câd");
    namesMap.put("TG", "Tògo");
    namesMap.put("TH", "Taylànd");
    namesMap.put("TJ", "Tàjìkìstaŋ");
    namesMap.put("TK", "Tòkèlaò");
    namesMap.put("TL", "Tìmɔ̂r lìkòl");
    namesMap.put("TM", "Tùrgmènìstân");
    namesMap.put("TN", "Tùnisìà");
    namesMap.put("TO", "Tɔŋgà");
    namesMap.put("TR", "Tùrkây");
    namesMap.put("TT", "Trìnidàd ɓɔ Tòbagò");
    namesMap.put("TV", "Tùvàlù");
    namesMap.put("TW", "Tàywân");
    namesMap.put("TZ", "Tànzànià");
    namesMap.put("UA", "Ùkrɛ̌n");
    namesMap.put("UG", "Ùgandà");
    namesMap.put("US", "Àdnà i Bilɔ̀ŋ bi Amerkà");
    namesMap.put("UY", "Ùrùgwêy");
    namesMap.put("UZ", "Ùzbèkìstân");
    namesMap.put("VA", "Vàtìkâŋ");
    namesMap.put("VC", "Nûmpubi Vɛ̂ŋsâŋ nì grènàdîn");
    namesMap.put("VE", "Vènèzùelà");
    namesMap.put("VG", "Bìòn bi kɔnji bi Ŋgisì");
    namesMap.put("VI", "Bìòn bi kɔnji bi U.S.");
    namesMap.put("VN", "Vìɛ̀dnâm");
    namesMap.put("VU", "Vànùatù");
    namesMap.put("WF", "Wàlîs nì Fùtunà");
    namesMap.put("WS", "Sàmoà");
    namesMap.put("YE", "Yèmɛ̂n");
    namesMap.put("YT", "Màyɔ̂t");
    namesMap.put("ZA", "Àfrǐkà Sɔ̀");
    namesMap.put("ZM", "Zàmbià");
    namesMap.put("ZW", "Zìmbàbwê");
  }

}
