/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;

import org.gwtproject.i18n.shared.cldr.LocalizedNamesImplBase;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ksb" locale.
 */
public class LocalizedNamesImpl_ksb extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "ZA",
        "AF",
        "IS",
        "AR",
        "AL",
        "DZ",
        "AM",
        "AW",
        "AD",
        "AO",
        "AI",
        "AG",
        "AQ",
        "AU",
        "AT",
        "AX",
        "IE",
        "AZ",
        "BB",
        "BH",
        "BS",
        "BD",
        "BE",
        "BY",
        "BZ",
        "BM",
        "BJ",
        "BL",
        "BR",
        "BN",
        "BO",
        "BA",
        "BW",
        "BQ",
        "BF",
        "MG",
        "BG",
        "BI",
        "BT",
        "BV",
        "CC",
        "TD",
        "CL",
        "CN",
        "CP",
        "CW",
        "CX",
        "DK",
        "DG",
        "DM",
        "EA",
        "EH",
        "EC",
        "ER",
        "SV",
        "IO",
        "EE",
        "EU",
        "EZ",
        "AE",
        "FJ",
        "PH",
        "FO",
        "GA",
        "GM",
        "GG",
        "GH",
        "GN",
        "GW",
        "GQ",
        "GD",
        "GL",
        "GS",
        "GY",
        "GP",
        "GU",
        "GT",
        "GF",
        "HT",
        "ES",
        "HK",
        "HM",
        "HN",
        "HU",
        "IC",
        "IQ",
        "IM",
        "IN",
        "ID",
        "IL",
        "IT",
        "JM",
        "CF",
        "CZ",
        "DO",
        "CD",
        "JP",
        "JE",
        "GI",
        "DJ",
        "GE",
        "KH",
        "CM",
        "CA",
        "QA",
        "KZ",
        "KE",
        "CV",
        "KI",
        "KG",
        "NF",
        "CI",
        "HR",
        "KP",
        "KR",
        "CO",
        "KM",
        "CG",
        "CR",
        "CU",
        "CY",
        "KW",
        "LA",
        "LU",
        "LV",
        "LB",
        "LS",
        "LR",
        "LY",
        "LI",
        "LT",
        "RE",
        "RO",
        "RW",
        "MW",
        "US",
        "MY",
        "ML",
        "MT",
        "MQ",
        "MK",
        "MR",
        "YT",
        "ME",
        "MX",
        "MF",
        "FM",
        "EG",
        "MO",
        "MV",
        "MD",
        "MU",
        "MA",
        "MC",
        "MN",
        "MS",
        "MZ",
        "MM",
        "NE",
        "NG",
        "NA",
        "NR",
        "NP",
        "NI",
        "NU",
        "NO",
        "NC",
        "NZ",
        "OM",
        "PK",
        "PY",
        "PW",
        "PA",
        "PG",
        "PE",
        "PN",
        "PL",
        "PF",
        "PR",
        "QO",
        "RS",
        "SM",
        "WS",
        "AS",
        "SH",
        "KN",
        "LC",
        "PM",
        "VC",
        "ST",
        "SA",
        "SN",
        "SC",
        "SL",
        "SY",
        "LK",
        "SG",
        "SJ",
        "SK",
        "SI",
        "SO",
        "SS",
        "SD",
        "SR",
        "SX",
        "TA",
        "TH",
        "TW",
        "TJ",
        "TZ",
        "TF",
        "TL",
        "TT",
        "TG",
        "TK",
        "TO",
        "TM",
        "TN",
        "TV",
        "IR",
        "FR",
        "FI",
        "UG",
        "GR",
        "ET",
        "NL",
        "GB",
        "DE",
        "PS",
        "UA",
        "PT",
        "UY",
        "RU",
        "UM",
        "UN",
        "SZ",
        "SE",
        "CH",
        "TR",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "CK",
        "FK",
        "KY",
        "MP",
        "MH",
        "SB",
        "TC",
        "VI",
        "VG",
        "WF",
        "XA",
        "XB",
        "XK",
        "YE",
        "JO",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMap() {
    super.loadNameMap();
    namesMap.put("AD", "Andola");
    namesMap.put("AE", "Falme za Kialabu");
    namesMap.put("AF", "Afuganistani");
    namesMap.put("AG", "Antigua na Balbuda");
    namesMap.put("AM", "Almenia");
    namesMap.put("AR", "Ajentina");
    namesMap.put("AS", "Samoa ya Malekani");
    namesMap.put("AT", "Austlia");
    namesMap.put("AU", "Austlalia");
    namesMap.put("AW", "Aluba");
    namesMap.put("AZ", "Azabajani");
    namesMap.put("BA", "Bosnia na Hezegovina");
    namesMap.put("BB", "Babadosi");
    namesMap.put("BD", "Bangladeshi");
    namesMap.put("BF", "Bukinafaso");
    namesMap.put("BG", "Bulgalia");
    namesMap.put("BH", "Bahaleni");
    namesMap.put("BI", "Bulundi");
    namesMap.put("BJ", "Benini");
    namesMap.put("BM", "Belmuda");
    namesMap.put("BN", "Blunei");
    namesMap.put("BR", "Blazili");
    namesMap.put("BS", "Bahama");
    namesMap.put("BT", "Butani");
    namesMap.put("BY", "Belalusi");
    namesMap.put("CA", "Kanada");
    namesMap.put("CD", "Jamhuli ya Kidemoklasia ya Kongo");
    namesMap.put("CF", "Jamhuli ya Afrika ya Gati");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Uswisi");
    namesMap.put("CI", "Kodivaa");
    namesMap.put("CK", "Visiwa vya Cook");
    namesMap.put("CM", "Kameluni");
    namesMap.put("CO", "Kolombia");
    namesMap.put("CR", "Kostalika");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kepuvede");
    namesMap.put("CY", "Kuplosi");
    namesMap.put("CZ", "Jamhuli ya Cheki");
    namesMap.put("DE", "Ujeumani");
    namesMap.put("DJ", "Jibuti");
    namesMap.put("DK", "Denmaki");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Jamhuli ya Dominika");
    namesMap.put("DZ", "Aljelia");
    namesMap.put("EC", "Ekwado");
    namesMap.put("EG", "Misli");
    namesMap.put("ER", "Elitlea");
    namesMap.put("ES", "Hispania");
    namesMap.put("ET", "Uhabeshi");
    namesMap.put("FI", "Ufini");
    namesMap.put("FK", "Visiwa vya Falkland");
    namesMap.put("FM", "Miklonesia");
    namesMap.put("FR", "Ufalansa");
    namesMap.put("GA", "Gaboni");
    namesMap.put("GB", "Uingeeza");
    namesMap.put("GD", "Glenada");
    namesMap.put("GE", "Jojia");
    namesMap.put("GF", "Gwiyana ya Ufalansa");
    namesMap.put("GI", "Jiblalta");
    namesMap.put("GL", "Glinlandi");
    namesMap.put("GN", "Gine");
    namesMap.put("GP", "Gwadelupe");
    namesMap.put("GQ", "Ginekweta");
    namesMap.put("GR", "Ugiiki");
    namesMap.put("GT", "Gwatemala");
    namesMap.put("GU", "Gwam");
    namesMap.put("GW", "Ginebisau");
    namesMap.put("HN", "Honduasi");
    namesMap.put("HR", "Kolasia");
    namesMap.put("HU", "Hungalia");
    namesMap.put("IE", "Ayalandi");
    namesMap.put("IL", "Islaeli");
    namesMap.put("IO", "Eneo ja Uingeeza mwe Bahali Hindi");
    namesMap.put("IQ", "Ilaki");
    namesMap.put("IR", "Uajemi");
    namesMap.put("IS", "Aislandi");
    namesMap.put("IT", "Italia");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JO", "Yoldani");
    namesMap.put("JP", "Japani");
    namesMap.put("KG", "Kiigizistani");
    namesMap.put("KH", "Kambodia");
    namesMap.put("KI", "Kiibati");
    namesMap.put("KM", "Komolo");
    namesMap.put("KN", "Santakitzi na Nevis");
    namesMap.put("KP", "Kolea Kaskazini");
    namesMap.put("KR", "Kolea Kusini");
    namesMap.put("KW", "Kuwaiti");
    namesMap.put("KY", "Visiwa vya Kayman");
    namesMap.put("KZ", "Kazakistani");
    namesMap.put("LA", "Laosi");
    namesMap.put("LB", "Lebanoni");
    namesMap.put("LC", "Santalusia");
    namesMap.put("LI", "Lishenteni");
    namesMap.put("LK", "Sililanka");
    namesMap.put("LR", "Libelia");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Litwania");
    namesMap.put("LU", "Lasembagi");
    namesMap.put("LV", "Lativia");
    namesMap.put("MA", "Moloko");
    namesMap.put("MC", "Monako");
    namesMap.put("MG", "Bukini");
    namesMap.put("MH", "Visiwa vya Mashal");
    namesMap.put("MK", "Masedonia");
    namesMap.put("MM", "Myama");
    namesMap.put("MP", "Visiwa vya Maliana vya Kaskazini");
    namesMap.put("MQ", "Maltiniki");
    namesMap.put("MR", "Maulitania");
    namesMap.put("MS", "Montselati");
    namesMap.put("MU", "Molisi");
    namesMap.put("MV", "Modivu");
    namesMap.put("MX", "Meksiko");
    namesMap.put("MY", "Malesia");
    namesMap.put("MZ", "Msumbiji");
    namesMap.put("NC", "Nyukaledonia");
    namesMap.put("NE", "Naija");
    namesMap.put("NF", "Kisiwa cha Nolfok");
    namesMap.put("NG", "Naijelia");
    namesMap.put("NI", "Nikalagwa");
    namesMap.put("NL", "Uholanzi");
    namesMap.put("NO", "Nolwei");
    namesMap.put("NP", "Nepali");
    namesMap.put("NR", "Naulu");
    namesMap.put("NZ", "Nyuzilandi");
    namesMap.put("OM", "Omani");
    namesMap.put("PE", "Pelu");
    namesMap.put("PF", "Polinesia ya Ufalansa");
    namesMap.put("PG", "Papua");
    namesMap.put("PH", "Filipino");
    namesMap.put("PK", "Pakistani");
    namesMap.put("PL", "Polandi");
    namesMap.put("PM", "Santapieli na Mikeloni");
    namesMap.put("PN", "Pitkailni");
    namesMap.put("PR", "Pwetoliko");
    namesMap.put("PS", "Ukingo wa Maghalibi na Ukanda wa Gaza wa Palestina");
    namesMap.put("PT", "Uleno");
    namesMap.put("PY", "Palagwai");
    namesMap.put("QA", "Katali");
    namesMap.put("RE", "Liyunioni");
    namesMap.put("RO", "Lomania");
    namesMap.put("RU", "Ulusi");
    namesMap.put("RW", "Lwanda");
    namesMap.put("SA", "Saudi");
    namesMap.put("SB", "Visiwa vya Solomon");
    namesMap.put("SC", "Shelisheli");
    namesMap.put("SD", "Sudani");
    namesMap.put("SE", "Uswidi");
    namesMap.put("SG", "Singapoo");
    namesMap.put("SH", "Santahelena");
    namesMap.put("SL", "Siela Leoni");
    namesMap.put("SM", "Samalino");
    namesMap.put("SN", "Senegali");
    namesMap.put("SR", "Sulinamu");
    namesMap.put("ST", "Sao Tome na Plincipe");
    namesMap.put("SV", "Elsavado");
    namesMap.put("SY", "Silia");
    namesMap.put("SZ", "Uswazi");
    namesMap.put("TC", "Visiwa vya Tulki na Kaiko");
    namesMap.put("TD", "Chadi");
    namesMap.put("TH", "Tailandi");
    namesMap.put("TJ", "Tajikistani");
    namesMap.put("TL", "Timoli ya Mashaliki");
    namesMap.put("TM", "Tulukimenistani");
    namesMap.put("TR", "Utuluki");
    namesMap.put("TT", "Tlinidad na Tobago");
    namesMap.put("TW", "Taiwani");
    namesMap.put("UA", "Uklaini");
    namesMap.put("US", "Malekani");
    namesMap.put("UY", "Ulugwai");
    namesMap.put("UZ", "Uzibekistani");
    namesMap.put("VA", "Vatikani");
    namesMap.put("VC", "Santavisenti na Glenadini");
    namesMap.put("VG", "Visiwa vya Vilgin vya Uingeeza");
    namesMap.put("VI", "Visiwa vya Vilgin vya Malekani");
    namesMap.put("VN", "Vietinamu");
    namesMap.put("WF", "Walis na Futuna");
    namesMap.put("YE", "Yemeni");
    namesMap.put("ZA", "Aflika Kusini");
  }

}
