/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;

import org.gwtproject.i18n.shared.cldr.LocalizedNamesImplBase;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ps" locale.
 */
public class LocalizedNamesImpl_ps extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "PK",
        "AF",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "XA",
        "XB",
        "AW",
        "AU",
        "IS",
        "AT",
        "AZ",
        "AR",
        "JO",
        "AM",
        "EU",
        "EZ",
        "ER",
        "GQ",
        "EE",
        "IL",
        "AC",
        "AF",
        "AX",
        "AL",
        "DZ",
        "DE",
        "AS",
        "AQ",
        "AD",
        "ID",
        "AG",
        "AO",
        "AI",
        "UZ",
        "UA",
        "IR",
        "EC",
        "IE",
        "IT",
        "BB",
        "BS",
        "BH",
        "BR",
        "GB",
        "BM",
        "BN",
        "BI",
        "VG",
        "BG",
        "BZ",
        "BD",
        "QO",
        "BT",
        "BW",
        "BF",
        "BA",
        "BO",
        "BV",
        "BY",
        "BE",
        "BJ",
        "TW",
        "TJ",
        "TR",
        "TA",
        "TZ",
        "TH",
        "TV",
        "TM",
        "TN",
        "TO",
        "TK",
        "TL",
        "JP",
        "GI",
        "DJ",
        "JE",
        "DO",
        "JM",
        "ET",
        "IM",
        "IO",
        "TC",
        "CI",
        "TF",
        "VI",
        "UM",
        "DM",
        "CX",
        "CP",
        "IC",
        "RU",
        "RO",
        "RW",
        "RE",
        "ZW",
        "ZM",
        "SV",
        "WS",
        "SM",
        "ST",
        "RS",
        "LK",
        "SA",
        "SI",
        "SK",
        "SB",
        "SZ",
        "SJ",
        "SR",
        "SY",
        "SO",
        "GS",
        "SS",
        "SD",
        "CH",
        "ZA",
        "KR",
        "SE",
        "SN",
        "BL",
        "SG",
        "EA",
        "LC",
        "MF",
        "SX",
        "SH",
        "VC",
        "PM",
        "KN",
        "SC",
        "SL",
        "MP",
        "KP",
        "IQ",
        "OM",
        "FO",
        "FK",
        "FJ",
        "FR",
        "PF",
        "GF",
        "PS",
        "PH",
        "FI",
        "CY",
        "KG",
        "KZ",
        "QA",
        "LA",
        "LR",
        "LB",
        "LS",
        "EH",
        "LU",
        "LV",
        "LY",
        "LT",
        "LI",
        "MH",
        "MQ",
        "MW",
        "MT",
        "MV",
        "ML",
        "MY",
        "MS",
        "YT",
        "US",
        "AE",
        "HU",
        "MG",
        "MA",
        "EG",
        "MN",
        "MK",
        "UN",
        "MR",
        "MU",
        "MZ",
        "MD",
        "MC",
        "ME",
        "MM",
        "MO",
        "FM",
        "MX",
        "NF",
        "NO",
        "NG",
        "NR",
        "NC",
        "NI",
        "NE",
        "NA",
        "NZ",
        "NU",
        "NP",
        "HM",
        "NL",
        "HN",
        "HK",
        "HT",
        "ES",
        "IN",
        "VA",
        "WF",
        "VU",
        "CF",
        "VE",
        "VN",
        "TT",
        "TG",
        "PY",
        "PA",
        "PG",
        "PK",
        "PW",
        "PR",
        "PT",
        "PL",
        "PN",
        "PE",
        "TD",
        "CZ",
        "CL",
        "CN",
        "DG",
        "DK",
        "CM",
        "CA",
        "CG",
        "CD",
        "HR",
        "KH",
        "CW",
        "CR",
        "XK",
        "CO",
        "KM",
        "CC",
        "CK",
        "KW",
        "KI",
        "BQ",
        "KY",
        "KE",
        "CU",
        "CV",
        "GA",
        "GP",
        "GM",
        "GH",
        "GD",
        "GG",
        "GL",
        "GT",
        "GU",
        "GY",
        "GN",
        "GW",
        "GE",
        "YE",
        "UY",
        "GR",
        "UG",
    };
  }

  @Override
  protected void loadNameMap() {
    super.loadNameMap();
    namesMap.put("001", "نړۍ");
    namesMap.put("002", "افريقا");
    namesMap.put("003", "شمالی امریکا");
    namesMap.put("005", "سويلي امريکا");
    namesMap.put("009", "سمندريه");
    namesMap.put("011", "لویدیځ افریقا");
    namesMap.put("013", "منخنۍ امريکا");
    namesMap.put("014", "ختیځ افریقا");
    namesMap.put("015", "شمالي افریقا");
    namesMap.put("017", "منځنۍ افریقا");
    namesMap.put("018", "سويلي افريقا");
    namesMap.put("019", "امريکې");
    namesMap.put("021", "شمالي امریکا");
    namesMap.put("029", "کیریبین");
    namesMap.put("030", "ختیځ آسیا");
    namesMap.put("034", "سويلي آسيا");
    namesMap.put("035", "سويلي ختيځ آسيا");
    namesMap.put("039", "سويلي اروپا");
    namesMap.put("053", "آسترالیا");
    namesMap.put("054", "ملانشیا");
    namesMap.put("057", "د مایکرونیسینین سیمه");
    namesMap.put("061", "پولنيسيا");
    namesMap.put("142", "آسيا");
    namesMap.put("143", "منځنۍ آسيا");
    namesMap.put("145", "لویدیځ آسیا");
    namesMap.put("150", "اروپا");
    namesMap.put("151", "ختيځه اروپا");
    namesMap.put("154", "شمالي اروپا");
    namesMap.put("155", "لویدیځه اروپا");
    namesMap.put("202", "سب سهارن افريقا");
    namesMap.put("419", "لاتیني امریکا");
    namesMap.put("AC", "اسينشان ټاپو");
    namesMap.put("AD", "اندورا");
    namesMap.put("AE", "متحده عرب امارات");
    namesMap.put("AF", "افغانستان");
    namesMap.put("AG", "انټيګوا او باربودا");
    namesMap.put("AI", "انګیلا");
    namesMap.put("AL", "البانیه");
    namesMap.put("AM", "ارمنستان");
    namesMap.put("AO", "انګولا");
    namesMap.put("AQ", "انتارکتیکا");
    namesMap.put("AR", "ارجنټاين");
    namesMap.put("AS", "امریکایی سمو");
    namesMap.put("AT", "اتریش");
    namesMap.put("AU", "آسټرالیا");
    namesMap.put("AW", "آروبا");
    namesMap.put("AX", "الاند ټاپوان");
    namesMap.put("AZ", "اذربايجان");
    namesMap.put("BA", "بوسنيا او هېرزګوينا");
    namesMap.put("BB", "باربادوس");
    namesMap.put("BD", "بنگله دېش");
    namesMap.put("BE", "بیلجیم");
    namesMap.put("BF", "بورکینا فاسو");
    namesMap.put("BG", "بلغاریه");
    namesMap.put("BH", "بحرين");
    namesMap.put("BI", "بروندي");
    namesMap.put("BJ", "بینن");
    namesMap.put("BL", "سينټ بارتيلمي");
    namesMap.put("BM", "برمودا");
    namesMap.put("BN", "برونائي");
    namesMap.put("BO", "بولیویا");
    namesMap.put("BQ", "کیریبین هالینډ");
    namesMap.put("BR", "برازیل");
    namesMap.put("BS", "باهماس");
    namesMap.put("BT", "بهوټان");
    namesMap.put("BV", "بوویټ ټاپو");
    namesMap.put("BW", "بوتسوانه");
    namesMap.put("BY", "بیلاروس");
    namesMap.put("BZ", "بلیز");
    namesMap.put("CA", "کاناډا");
    namesMap.put("CC", "کوکوز (کيلنګ) ټاپوګان");
    namesMap.put("CD", "کانګو - کینشاسا");
    namesMap.put("CF", "وسطي افريقا جمهور");
    namesMap.put("CG", "کانګو - بروزوییل");
    namesMap.put("CH", "سویس");
    namesMap.put("CI", "د عاج ساحل");
    namesMap.put("CK", "کوک ټاپوګان");
    namesMap.put("CL", "چیلي");
    namesMap.put("CM", "کامرون");
    namesMap.put("CN", "چین");
    namesMap.put("CO", "کولمبیا");
    namesMap.put("CP", "د کلپرټون ټاپو");
    namesMap.put("CR", "کوستاریکا");
    namesMap.put("CU", "کیوبا");
    namesMap.put("CV", "کیپ ورد");
    namesMap.put("CW", "کوراکاو");
    namesMap.put("CX", "د کريسمس ټاپو");
    namesMap.put("CY", "قبرس");
    namesMap.put("CZ", "چکیا");
    namesMap.put("DE", "المان");
    namesMap.put("DG", "ډایګو ګارسیا");
    namesMap.put("DJ", "جبوتي");
    namesMap.put("DK", "ډنمارک");
    namesMap.put("DM", "دومینیکا");
    namesMap.put("DO", "جمهوريه ډومينيکن");
    namesMap.put("DZ", "الجزایر");
    namesMap.put("EA", "سيوتا او ماليلا");
    namesMap.put("EC", "اکوادور");
    namesMap.put("EE", "استونیا");
    namesMap.put("EG", "مصر");
    namesMap.put("EH", "لويديځ صحارا");
    namesMap.put("ER", "اریتره");
    namesMap.put("ES", "هسپانیه");
    namesMap.put("ET", "حبشه");
    namesMap.put("EU", "اروپايي اتحاديه");
    namesMap.put("EZ", "اروپايي سيمه");
    namesMap.put("FI", "فنلینډ");
    namesMap.put("FJ", "فجي");
    namesMap.put("FK", "فاکلينډ ټاپوګان");
    namesMap.put("FM", "میکرونیزیا");
    namesMap.put("FO", "فارو ټاپو");
    namesMap.put("FR", "فرانسه");
    namesMap.put("GA", "ګابن");
    namesMap.put("GB", "برتانیه");
    namesMap.put("GD", "ګرنادا");
    namesMap.put("GE", "گورجستان");
    namesMap.put("GF", "فرانسوي ګانا");
    namesMap.put("GG", "ګرنسي");
    namesMap.put("GH", "ګانا");
    namesMap.put("GI", "جبل الطارق");
    namesMap.put("GL", "ګرینلینډ");
    namesMap.put("GM", "ګامبیا");
    namesMap.put("GN", "ګینه");
    namesMap.put("GP", "ګالډیپ");
    namesMap.put("GQ", "استوایی ګینه");
    namesMap.put("GR", "یونان");
    namesMap.put("GS", "سويلي جارجيا او سويلي سېنډوچ ټاپوګان");
    namesMap.put("GT", "ګواتیمالا");
    namesMap.put("GU", "ګوام");
    namesMap.put("GW", "ګینه بیسو");
    namesMap.put("GY", "ګیانا");
    namesMap.put("HK", "هانګ کانګ SAR چین");
    namesMap.put("HM", "هارډ او ميکډانلډ ټاپوګان");
    namesMap.put("HN", "هانډوراس");
    namesMap.put("HR", "کرواشيا");
    namesMap.put("HT", "هایټي");
    namesMap.put("HU", "مجارستان");
    namesMap.put("IC", "د کناري ټاپوګان");
    namesMap.put("ID", "اندونیزیا");
    namesMap.put("IE", "ایرلینډ");
    namesMap.put("IL", "اسراييل");
    namesMap.put("IM", "د آئل آف مین");
    namesMap.put("IN", "هند");
    namesMap.put("IO", "د بريتانوي هند سمندري سيمه");
    namesMap.put("IQ", "عراق");
    namesMap.put("IR", "ايران");
    namesMap.put("IS", "آیسلینډ");
    namesMap.put("IT", "ایټالیه");
    namesMap.put("JE", "جرسی");
    namesMap.put("JM", "جمیکا");
    namesMap.put("JO", "اردن");
    namesMap.put("JP", "جاپان");
    namesMap.put("KE", "کینیا");
    namesMap.put("KG", "قرغزستان");
    namesMap.put("KH", "کمبودیا");
    namesMap.put("KI", "کیري باتي");
    namesMap.put("KM", "کوموروس");
    namesMap.put("KN", "سینټ کټس او نیویس");
    namesMap.put("KP", "شمالی کوریا");
    namesMap.put("KR", "سویلي کوریا");
    namesMap.put("KW", "کویټ");
    namesMap.put("KY", "کیمان ټاپوګان");
    namesMap.put("KZ", "قزاقستان");
    namesMap.put("LA", "لاوس");
    namesMap.put("LB", "لبنان");
    namesMap.put("LC", "سینټ لوسیا");
    namesMap.put("LI", "لیختن اشتاین");
    namesMap.put("LK", "سريلنکا");
    namesMap.put("LR", "لایبریا");
    namesMap.put("LS", "لسوتو");
    namesMap.put("LT", "لیتوانیا");
    namesMap.put("LU", "لوګزامبورګ");
    namesMap.put("LV", "ليتهويا");
    namesMap.put("LY", "لیبیا");
    namesMap.put("MA", "مراکش");
    namesMap.put("MC", "موناکو");
    namesMap.put("MD", "مولدوا");
    namesMap.put("ME", "مونټینیګرو");
    namesMap.put("MF", "سینټ مارټن");
    namesMap.put("MG", "مدګاسکار");
    namesMap.put("MH", "مارشل ټاپوګان");
    namesMap.put("MK", "مقدونیه");
    namesMap.put("ML", "مالي");
    namesMap.put("MM", "ميانمار (برما)");
    namesMap.put("MN", "مغولستان");
    namesMap.put("MO", "مکا سار چین");
    namesMap.put("MP", "شمالي ماريانا ټاپوګان");
    namesMap.put("MQ", "مارټینیک");
    namesMap.put("MR", "موریتانیا");
    namesMap.put("MS", "مانټیسیرت");
    namesMap.put("MT", "مالتا");
    namesMap.put("MU", "موریشیس");
    namesMap.put("MV", "مالديپ");
    namesMap.put("MW", "مالاوي");
    namesMap.put("MX", "میکسیکو");
    namesMap.put("MY", "مالیزیا");
    namesMap.put("MZ", "موزمبيق");
    namesMap.put("NA", "نیمبیا");
    namesMap.put("NC", "نوی کالیډونیا");
    namesMap.put("NE", "نیجر");
    namesMap.put("NF", "نارفولک ټاپوګان");
    namesMap.put("NG", "نایجیریا");
    namesMap.put("NI", "نکاراګوا");
    namesMap.put("NL", "هالېنډ");
    namesMap.put("NO", "ناروۍ");
    namesMap.put("NP", "نیپال");
    namesMap.put("NR", "نایرو");
    namesMap.put("NU", "نیوو");
    namesMap.put("NZ", "نیوزیلنډ");
    namesMap.put("OM", "عمان");
    namesMap.put("PA", "پاناما");
    namesMap.put("PE", "پیرو");
    namesMap.put("PF", "فرانسوي پولينيسيا");
    namesMap.put("PG", "پاپوا نيو ګيني");
    namesMap.put("PH", "فلپين");
    namesMap.put("PK", "پاکستان");
    namesMap.put("PL", "پولنډ");
    namesMap.put("PM", "سینټ پییر او میکولون");
    namesMap.put("PN", "پيټکيرن ټاپوګان");
    namesMap.put("PR", "پورتو ریکو");
    namesMap.put("PS", "فلسطين سيمې");
    namesMap.put("PT", "پورتګال");
    namesMap.put("PW", "پلاؤ");
    namesMap.put("PY", "پاراګوی");
    namesMap.put("QA", "قطر");
    namesMap.put("QO", "بهرنۍ اوسيانه");
    namesMap.put("RE", "ریونین");
    namesMap.put("RO", "رومانیا");
    namesMap.put("RS", "سربيا");
    namesMap.put("RU", "روسیه");
    namesMap.put("RW", "روندا");
    namesMap.put("SA", "سعودي عربستان");
    namesMap.put("SB", "سليمان ټاپوګان");
    namesMap.put("SC", "سیچیلیس");
    namesMap.put("SD", "سوډان");
    namesMap.put("SE", "سویډن");
    namesMap.put("SG", "سينگاپور");
    namesMap.put("SH", "سینټ هیلینا");
    namesMap.put("SI", "سلوانیا");
    namesMap.put("SJ", "سوالبارد او جان ميين");
    namesMap.put("SK", "سلواکیا");
    namesMap.put("SL", "سییرا لیون");
    namesMap.put("SM", "سان مارینو");
    namesMap.put("SN", "سينيګال");
    namesMap.put("SO", "سومالیا");
    namesMap.put("SR", "سورینام");
    namesMap.put("SS", "سويلي سوډان");
    namesMap.put("ST", "ساو ټیم او پرنسیپ");
    namesMap.put("SV", "سالوېډور");
    namesMap.put("SX", "سینټ مارټین");
    namesMap.put("SY", "سوریه");
    namesMap.put("SZ", "سوازیلینډ");
    namesMap.put("TA", "تریستان دا کنها");
    namesMap.put("TC", "د ترکیې او کیکاسو ټاپو");
    namesMap.put("TD", "چاډ");
    namesMap.put("TF", "د فرانسې جنوبي سیمې");
    namesMap.put("TG", "ټوګو");
    namesMap.put("TH", "تهايلنډ");
    namesMap.put("TJ", "تاجکستان");
    namesMap.put("TK", "توکیلو");
    namesMap.put("TL", "تيمور-ليسټ");
    namesMap.put("TM", "تورکمنستان");
    namesMap.put("TN", "تونس");
    namesMap.put("TO", "تونګا");
    namesMap.put("TR", "ترکي");
    namesMap.put("TT", "ټرينيډاډ او ټوباګو");
    namesMap.put("TV", "توالیو");
    namesMap.put("TW", "تائيوان");
    namesMap.put("TZ", "تنزانیا");
    namesMap.put("UA", "اوکراین");
    namesMap.put("UG", "یوګانډا");
    namesMap.put("UM", "د متحده ایالاتو ټاپوګان");
    namesMap.put("UN", "ملگري ملتونه");
    namesMap.put("US", "متحده آيالات");
    namesMap.put("UY", "یوروګوی");
    namesMap.put("UZ", "اوزبکستان");
    namesMap.put("VA", "واتیکان ښار");
    namesMap.put("VC", "سینټ ویسنټینټ او ګرینډینز");
    namesMap.put("VE", "وینزویلا");
    namesMap.put("VG", "بریتانوی ویګور ټاپوګان");
    namesMap.put("VI", "د متحده آيالاتو ورجن ټاپوګان");
    namesMap.put("VN", "وېتنام");
    namesMap.put("VU", "واناتو");
    namesMap.put("WF", "والیس او فوتونا");
    namesMap.put("WS", "ساموا");
    namesMap.put("XK", "کوسوو");
    namesMap.put("YE", "یمن");
    namesMap.put("YT", "مايوټ");
    namesMap.put("ZA", "سویلي افریقا");
    namesMap.put("ZM", "زیمبیا");
    namesMap.put("ZW", "زیمبابوی");
    namesMap.put("ZZ", "نامعلومه سيمه");
  }

}
