/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;

import org.gwtproject.i18n.shared.cldr.LocalizedNamesImplBase;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "pt" locale.
 */
public class LocalizedNamesImpl_pt extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "BR",
        "AO",
        "PT",
        "MZ",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "ZA",
        "AL",
        "DE",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "SA",
        "DZ",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BY",
        "BO",
        "BA",
        "BW",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "BT",
        "CV",
        "CM",
        "KH",
        "CA",
        "QA",
        "KZ",
        "EA",
        "TD",
        "CL",
        "CN",
        "CY",
        "VA",
        "CO",
        "KM",
        "CD",
        "KP",
        "KR",
        "CI",
        "CR",
        "HR",
        "CU",
        "CW",
        "DG",
        "DK",
        "DJ",
        "DM",
        "EG",
        "SV",
        "AE",
        "EC",
        "ER",
        "SK",
        "SI",
        "ES",
        "US",
        "EE",
        "ET",
        "FJ",
        "PH",
        "FI",
        "FR",
        "GA",
        "GM",
        "GH",
        "GE",
        "GI",
        "GD",
        "GR",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GY",
        "GF",
        "GN",
        "GW",
        "GQ",
        "HT",
        "HN",
        "HK",
        "HU",
        "YE",
        "BV",
        "CX",
        "AC",
        "CP",
        "IM",
        "NF",
        "AX",
        "IC",
        "KY",
        "CC",
        "CK",
        "FO",
        "GS",
        "HM",
        "FK",
        "MP",
        "MH",
        "UM",
        "PN",
        "SB",
        "TC",
        "VI",
        "VG",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IE",
        "IS",
        "IL",
        "IT",
        "JM",
        "JP",
        "JE",
        "JO",
        "XK",
        "KW",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MK",
        "MG",
        "MY",
        "MW",
        "MV",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MU",
        "MR",
        "YT",
        "MX",
        "MM",
        "FM",
        "MZ",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "UN",
        "NA",
        "NR",
        "NP",
        "NI",
        "NE",
        "NG",
        "NU",
        "NO",
        "NC",
        "NZ",
        "QO",
        "OM",
        "NL",
        "BQ",
        "PW",
        "PA",
        "PG",
        "PK",
        "PY",
        "PE",
        "PF",
        "PL",
        "PR",
        "PT",
        "KE",
        "KG",
        "KI",
        "MO",
        "GB",
        "CF",
        "CG",
        "DO",
        "RE",
        "RO",
        "RW",
        "RU",
        "EH",
        "WS",
        "AS",
        "SM",
        "SH",
        "LC",
        "BL",
        "KN",
        "MF",
        "PM",
        "ST",
        "VC",
        "SC",
        "SN",
        "SL",
        "RS",
        "SG",
        "SX",
        "SY",
        "SO",
        "LK",
        "SZ",
        "SD",
        "SS",
        "SE",
        "CH",
        "SR",
        "SJ",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "CZ",
        "IO",
        "TF",
        "PS",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TM",
        "TR",
        "TV",
        "UA",
        "UG",
        "EU",
        "UY",
        "UZ",
        "VU",
        "VE",
        "VN",
        "WF",
        "XA",
        "XB",
        "ZM",
        "ZW",
        "EZ",
    };
  }

  @Override
  protected void loadNameMap() {
    super.loadNameMap();
    namesMap.put("001", "Mundo");
    namesMap.put("002", "África");
    namesMap.put("003", "América do Norte");
    namesMap.put("005", "América do Sul");
    namesMap.put("011", "África Ocidental");
    namesMap.put("013", "América Central");
    namesMap.put("014", "África Oriental");
    namesMap.put("015", "África do Norte");
    namesMap.put("017", "África Central");
    namesMap.put("018", "África Meridional");
    namesMap.put("019", "Américas");
    namesMap.put("021", "América Setentrional");
    namesMap.put("029", "Caribe");
    namesMap.put("030", "Ásia Oriental");
    namesMap.put("034", "Ásia Meridional");
    namesMap.put("035", "Sudeste Asiático");
    namesMap.put("039", "Europa Meridional");
    namesMap.put("053", "Australásia");
    namesMap.put("054", "Melanésia");
    namesMap.put("057", "Região da Micronésia");
    namesMap.put("061", "Polinésia");
    namesMap.put("142", "Ásia");
    namesMap.put("143", "Ásia Central");
    namesMap.put("145", "Ásia Ocidental");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Europa Oriental");
    namesMap.put("154", "Europa Setentrional");
    namesMap.put("155", "Europa Ocidental");
    namesMap.put("202", "África Subsaariana");
    namesMap.put("419", "América Latina");
    namesMap.put("AC", "Ilha de Ascensão");
    namesMap.put("AE", "Emirados Árabes Unidos");
    namesMap.put("AF", "Afeganistão");
    namesMap.put("AG", "Antígua e Barbuda");
    namesMap.put("AI", "Anguila");
    namesMap.put("AL", "Albânia");
    namesMap.put("AM", "Armênia");
    namesMap.put("AQ", "Antártida");
    namesMap.put("AS", "Samoa Americana");
    namesMap.put("AT", "Áustria");
    namesMap.put("AU", "Austrália");
    namesMap.put("AX", "Ilhas Aland");
    namesMap.put("AZ", "Azerbaijão");
    namesMap.put("BA", "Bósnia e Herzegovina");
    namesMap.put("BE", "Bélgica");
    namesMap.put("BF", "Burquina Faso");
    namesMap.put("BG", "Bulgária");
    namesMap.put("BH", "Bahrein");
    namesMap.put("BL", "São Bartolomeu");
    namesMap.put("BM", "Bermudas");
    namesMap.put("BO", "Bolívia");
    namesMap.put("BQ", "Países Baixos Caribenhos");
    namesMap.put("BR", "Brasil");
    namesMap.put("BT", "Butão");
    namesMap.put("BV", "Ilha Bouvet");
    namesMap.put("BW", "Botsuana");
    namesMap.put("BY", "Bielorrússia");
    namesMap.put("CA", "Canadá");
    namesMap.put("CC", "Ilhas Cocos (Keeling)");
    namesMap.put("CF", "República Centro-Africana");
    namesMap.put("CG", "República do Congo");
    namesMap.put("CH", "Suíça");
    namesMap.put("CI", "Costa do Marfim");
    namesMap.put("CK", "Ilhas Cook");
    namesMap.put("CM", "Camarões");
    namesMap.put("CO", "Colômbia");
    namesMap.put("CP", "Ilha de Clipperton");
    namesMap.put("CV", "Cabo Verde");
    namesMap.put("CX", "Ilha Christmas");
    namesMap.put("CY", "Chipre");
    namesMap.put("CZ", "Tchéquia");
    namesMap.put("DE", "Alemanha");
    namesMap.put("DJ", "Djibuti");
    namesMap.put("DK", "Dinamarca");
    namesMap.put("DO", "República Dominicana");
    namesMap.put("DZ", "Argélia");
    namesMap.put("EA", "Ceuta e Melilla");
    namesMap.put("EC", "Equador");
    namesMap.put("EE", "Estônia");
    namesMap.put("EG", "Egito");
    namesMap.put("EH", "Saara Ocidental");
    namesMap.put("ER", "Eritreia");
    namesMap.put("ES", "Espanha");
    namesMap.put("ET", "Etiópia");
    namesMap.put("EU", "União Europeia");
    namesMap.put("EZ", "zona do euro");
    namesMap.put("FI", "Finlândia");
    namesMap.put("FK", "Ilhas Malvinas");
    namesMap.put("FM", "Micronésia");
    namesMap.put("FO", "Ilhas Faroe");
    namesMap.put("FR", "França");
    namesMap.put("GA", "Gabão");
    namesMap.put("GB", "Reino Unido");
    namesMap.put("GD", "Granada");
    namesMap.put("GE", "Geórgia");
    namesMap.put("GF", "Guiana Francesa");
    namesMap.put("GH", "Gana");
    namesMap.put("GL", "Groenlândia");
    namesMap.put("GM", "Gâmbia");
    namesMap.put("GN", "Guiné");
    namesMap.put("GP", "Guadalupe");
    namesMap.put("GQ", "Guiné Equatorial");
    namesMap.put("GR", "Grécia");
    namesMap.put("GS", "Ilhas Geórgia do Sul e Sandwich do Sul");
    namesMap.put("GW", "Guiné-Bissau");
    namesMap.put("GY", "Guiana");
    namesMap.put("HK", "Hong Kong, RAE da China");
    namesMap.put("HM", "Ilhas Heard e McDonald");
    namesMap.put("HR", "Croácia");
    namesMap.put("HU", "Hungria");
    namesMap.put("IC", "Ilhas Canárias");
    namesMap.put("ID", "Indonésia");
    namesMap.put("IE", "Irlanda");
    namesMap.put("IM", "Ilha de Man");
    namesMap.put("IN", "Índia");
    namesMap.put("IO", "Território Britânico do Oceano Índico");
    namesMap.put("IQ", "Iraque");
    namesMap.put("IR", "Irã");
    namesMap.put("IS", "Islândia");
    namesMap.put("IT", "Itália");
    namesMap.put("JO", "Jordânia");
    namesMap.put("JP", "Japão");
    namesMap.put("KE", "Quênia");
    namesMap.put("KG", "Quirguistão");
    namesMap.put("KH", "Camboja");
    namesMap.put("KI", "Quiribati");
    namesMap.put("KM", "Comores");
    namesMap.put("KN", "São Cristóvão e Névis");
    namesMap.put("KP", "Coreia do Norte");
    namesMap.put("KR", "Coreia do Sul");
    namesMap.put("KY", "Ilhas Cayman");
    namesMap.put("KZ", "Cazaquistão");
    namesMap.put("LB", "Líbano");
    namesMap.put("LC", "Santa Lúcia");
    namesMap.put("LR", "Libéria");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Lituânia");
    namesMap.put("LU", "Luxemburgo");
    namesMap.put("LV", "Letônia");
    namesMap.put("LY", "Líbia");
    namesMap.put("MA", "Marrocos");
    namesMap.put("MC", "Mônaco");
    namesMap.put("MF", "São Martinho");
    namesMap.put("MH", "Ilhas Marshall");
    namesMap.put("MK", "Macedônia");
    namesMap.put("MM", "Mianmar (Birmânia)");
    namesMap.put("MN", "Mongólia");
    namesMap.put("MO", "RAE de Macau (China)");
    namesMap.put("MP", "Ilhas Marianas do Norte");
    namesMap.put("MQ", "Martinica");
    namesMap.put("MR", "Mauritânia");
    namesMap.put("MU", "Maurício");
    namesMap.put("MV", "Maldivas");
    namesMap.put("MW", "Malaui");
    namesMap.put("MX", "México");
    namesMap.put("MY", "Malásia");
    namesMap.put("MZ", "Moçambique");
    namesMap.put("NA", "Namíbia");
    namesMap.put("NC", "Nova Caledônia");
    namesMap.put("NE", "Níger");
    namesMap.put("NF", "Ilha Norfolk");
    namesMap.put("NG", "Nigéria");
    namesMap.put("NI", "Nicarágua");
    namesMap.put("NL", "Países Baixos");
    namesMap.put("NO", "Noruega");
    namesMap.put("NZ", "Nova Zelândia");
    namesMap.put("OM", "Omã");
    namesMap.put("PA", "Panamá");
    namesMap.put("PF", "Polinésia Francesa");
    namesMap.put("PG", "Papua-Nova Guiné");
    namesMap.put("PH", "Filipinas");
    namesMap.put("PK", "Paquistão");
    namesMap.put("PL", "Polônia");
    namesMap.put("PM", "São Pedro e Miquelão");
    namesMap.put("PN", "Ilhas Pitcairn");
    namesMap.put("PR", "Porto Rico");
    namesMap.put("PS", "Territórios palestinos");
    namesMap.put("PY", "Paraguai");
    namesMap.put("QA", "Catar");
    namesMap.put("QO", "Oceania Remota");
    namesMap.put("RE", "Reunião");
    namesMap.put("RO", "Romênia");
    namesMap.put("RS", "Sérvia");
    namesMap.put("RU", "Rússia");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Arábia Saudita");
    namesMap.put("SB", "Ilhas Salomão");
    namesMap.put("SC", "Seicheles");
    namesMap.put("SD", "Sudão");
    namesMap.put("SE", "Suécia");
    namesMap.put("SG", "Singapura");
    namesMap.put("SH", "Santa Helena");
    namesMap.put("SI", "Eslovênia");
    namesMap.put("SJ", "Svalbard e Jan Mayen");
    namesMap.put("SK", "Eslováquia");
    namesMap.put("SL", "Serra Leoa");
    namesMap.put("SO", "Somália");
    namesMap.put("SS", "Sudão do Sul");
    namesMap.put("ST", "São Tomé e Príncipe");
    namesMap.put("SY", "Síria");
    namesMap.put("SZ", "Suazilândia");
    namesMap.put("TA", "Tristão da Cunha");
    namesMap.put("TC", "Ilhas Turcas e Caicos");
    namesMap.put("TD", "Chade");
    namesMap.put("TF", "Territórios Franceses do Sul");
    namesMap.put("TH", "Tailândia");
    namesMap.put("TJ", "Tadjiquistão");
    namesMap.put("TM", "Turcomenistão");
    namesMap.put("TN", "Tunísia");
    namesMap.put("TR", "Turquia");
    namesMap.put("TT", "Trinidad e Tobago");
    namesMap.put("TZ", "Tanzânia");
    namesMap.put("UA", "Ucrânia");
    namesMap.put("UM", "Ilhas Menores Distantes dos EUA");
    namesMap.put("UN", "Nações Unidas");
    namesMap.put("US", "Estados Unidos");
    namesMap.put("UY", "Uruguai");
    namesMap.put("UZ", "Uzbequistão");
    namesMap.put("VA", "Cidade do Vaticano");
    namesMap.put("VC", "São Vicente e Granadinas");
    namesMap.put("VG", "Ilhas Virgens Britânicas");
    namesMap.put("VI", "Ilhas Virgens Americanas");
    namesMap.put("VN", "Vietnã");
    namesMap.put("WF", "Wallis e Futuna");
    namesMap.put("YE", "Iêmen");
    namesMap.put("ZA", "África do Sul");
    namesMap.put("ZM", "Zâmbia");
    namesMap.put("ZW", "Zimbábue");
    namesMap.put("ZZ", "Região desconhecida");
  }

}
