/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;

import org.gwtproject.i18n.shared.cldr.LocalizedNamesImplBase;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "qu" locale.
 */
public class LocalizedNamesImpl_qu extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "PE",
        "BO",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AE",
        "AF",
        "AG",
        "AI",
        "AL",
        "DE",
        "AD",
        "AO",
        "AQ",
        "SA",
        "DZ",
        "AR",
        "AM",
        "AU",
        "AT",
        "AW",
        "AX",
        "AZ",
        "BA",
        "BS",
        "BD",
        "BH",
        "BB",
        "BY",
        "BE",
        "BJ",
        "BF",
        "BL",
        "BM",
        "BO",
        "BQ",
        "BW",
        "BR",
        "BN",
        "BG",
        "BI",
        "BT",
        "BV",
        "BZ",
        "CA",
        "KH",
        "CM",
        "CF",
        "TD",
        "CL",
        "CN",
        "CY",
        "CK",
        "CO",
        "KM",
        "CG",
        "CD",
        "KP",
        "KR",
        "CR",
        "CI",
        "CP",
        "HR",
        "CU",
        "CW",
        "CV",
        "CZ",
        "DG",
        "DK",
        "DO",
        "DM",
        "EA",
        "EC",
        "VI",
        "EG",
        "EH",
        "SV",
        "ER",
        "MK",
        "SK",
        "SI",
        "ES",
        "US",
        "EE",
        "ET",
        "EU",
        "EZ",
        "PH",
        "FI",
        "FJ",
        "FK",
        "FO",
        "FR",
        "GA",
        "GM",
        "GD",
        "GE",
        "GF",
        "GH",
        "GI",
        "GL",
        "GP",
        "GR",
        "GS",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GQ",
        "GY",
        "HT",
        "HN",
        "HK",
        "HU",
        "IC",
        "IE",
        "IM",
        "IN",
        "ID",
        "IO",
        "IQ",
        "IR",
        "CX",
        "IS",
        "NF",
        "CC",
        "HM",
        "MP",
        "MH",
        "UM",
        "PN",
        "IL",
        "IT",
        "JE",
        "JM",
        "JO",
        "JP",
        "KZ",
        "KE",
        "KG",
        "KI",
        "KW",
        "KY",
        "LA",
        "LC",
        "LS",
        "LV",
        "LB",
        "LR",
        "LI",
        "LT",
        "LU",
        "LY",
        "MO",
        "MG",
        "MW",
        "MV",
        "ML",
        "MT",
        "MA",
        "MU",
        "MR",
        "ME",
        "MX",
        "FM",
        "MN",
        "MD",
        "MC",
        "MZ",
        "MQ",
        "MS",
        "MY",
        "MM",
        "NA",
        "NR",
        "NP",
        "NI",
        "NE",
        "NG",
        "NO",
        "NU",
        "NC",
        "NZ",
        "OM",
        "NL",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PF",
        "PL",
        "PT",
        "PR",
        "QA",
        "QO",
        "RE",
        "GB",
        "RO",
        "RW",
        "RU",
        "WS",
        "AS",
        "KN",
        "SM",
        "MF",
        "PM",
        "VA",
        "ST",
        "SB",
        "SN",
        "RS",
        "SC",
        "SH",
        "SL",
        "SG",
        "SX",
        "SY",
        "SJ",
        "SO",
        "LK",
        "SZ",
        "ZA",
        "SD",
        "SS",
        "SE",
        "CH",
        "SR",
        "TA",
        "TH",
        "TZ",
        "TJ",
        "TC",
        "TF",
        "TL",
        "TK",
        "TM",
        "TG",
        "TO",
        "TT",
        "TN",
        "TR",
        "TV",
        "TW",
        "UA",
        "UG",
        "UN",
        "UY",
        "UZ",
        "VU",
        "VC",
        "VE",
        "VG",
        "VN",
        "WF",
        "XA",
        "XB",
        "XK",
        "YE",
        "DJ",
        "YT",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMap() {
    super.loadNameMap();
    namesMap.put("AF", "Afganistán");
    namesMap.put("AS", "Samoa Americana");
    namesMap.put("AZ", "Azerbaiyán");
    namesMap.put("BE", "Bélgica");
    namesMap.put("BH", "Baréin");
    namesMap.put("BJ", "Benín");
    namesMap.put("BN", "Brunéi");
    namesMap.put("BQ", "Bonaire");
    namesMap.put("BR", "Brasil");
    namesMap.put("BT", "Bután");
    namesMap.put("BW", "Botsuana");
    namesMap.put("BY", "Belarús");
    namesMap.put("CC", "Islas Cocos");
    namesMap.put("CD", "Congo (RDC)");
    namesMap.put("CG", "Congo");
    namesMap.put("CH", "Suiza");
    namesMap.put("CM", "Camerún");
    namesMap.put("CW", "Curazao");
    namesMap.put("CX", "Isla Christmas");
    namesMap.put("CY", "Chipre");
    namesMap.put("DE", "Alemania");
    namesMap.put("DJ", "Yibuti");
    namesMap.put("DK", "Dinamarca");
    namesMap.put("DZ", "Argelia");
    namesMap.put("EG", "Egipto");
    namesMap.put("ES", "España");
    namesMap.put("ET", "Etiopía");
    namesMap.put("FI", "Finlandia");
    namesMap.put("FJ", "Fiyi");
    namesMap.put("FR", "Francia");
    namesMap.put("GA", "Gabón");
    namesMap.put("GB", "Reino Unido");
    namesMap.put("GG", "Guernesey");
    namesMap.put("GQ", "Guinea Ecuatorial");
    namesMap.put("GR", "Grecia");
    namesMap.put("GW", "Guinea-Bisáu");
    namesMap.put("HK", "Hong Kong (RAE)");
    namesMap.put("HM", "Islas Heard y McDonald");
    namesMap.put("HR", "Croacia");
    namesMap.put("HT", "Haití");
    namesMap.put("IQ", "Irak");
    namesMap.put("IR", "Irán");
    namesMap.put("IS", "Islandia");
    namesMap.put("IT", "Italia");
    namesMap.put("JO", "Jordania");
    namesMap.put("KE", "Kenia");
    namesMap.put("KG", "Kirguistán");
    namesMap.put("KH", "Camboya");
    namesMap.put("KM", "Comoras");
    namesMap.put("KN", "San Cristóbal y Nieves");
    namesMap.put("KP", "Corea del Norte");
    namesMap.put("KR", "Corea del Sur");
    namesMap.put("KZ", "Kazajistán");
    namesMap.put("LB", "Líbano");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Lituania");
    namesMap.put("LU", "Luxemburgo");
    namesMap.put("LV", "Letonia");
    namesMap.put("MA", "Marruecos");
    namesMap.put("MC", "Mónaco");
    namesMap.put("MF", "San Martín");
    namesMap.put("MH", "Islas Marshall");
    namesMap.put("MK", "ERY Macedonia");
    namesMap.put("ML", "Malí");
    namesMap.put("MM", "Myanmar");
    namesMap.put("MO", "Macao RAE");
    namesMap.put("MP", "Islas Marianas del Norte");
    namesMap.put("MU", "Mauricio");
    namesMap.put("MV", "Maldivas");
    namesMap.put("MX", "México");
    namesMap.put("NC", "Nueva Caledonia");
    namesMap.put("NE", "Níger");
    namesMap.put("NF", "Isla Norfolk");
    namesMap.put("NL", "Países Bajos");
    namesMap.put("NO", "Noruega");
    namesMap.put("OM", "Omán");
    namesMap.put("PA", "Panamá");
    namesMap.put("PE", "Perú");
    namesMap.put("PF", "Polinesia Francesa");
    namesMap.put("PG", "Papúa Nueva Guinea");
    namesMap.put("PH", "Filipinas");
    namesMap.put("PK", "Pakistán");
    namesMap.put("PL", "Polonia");
    namesMap.put("PM", "San Pedro y Miquelón");
    namesMap.put("PN", "Islas Pitcairn");
    namesMap.put("PS", "Palestina Kamachikuq");
    namesMap.put("PW", "Palaos");
    namesMap.put("RU", "Rusia");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Arabia Saudí");
    namesMap.put("SD", "Sudán");
    namesMap.put("SE", "Suecia");
    namesMap.put("SG", "Singapur");
    namesMap.put("SI", "Eslovenia");
    namesMap.put("SK", "Eslovaquia");
    namesMap.put("SL", "Sierra Leona");
    namesMap.put("SR", "Surinam");
    namesMap.put("SS", "Sudán del Sur");
    namesMap.put("ST", "Santo Tomé y Príncipe");
    namesMap.put("SY", "Siria");
    namesMap.put("SZ", "Suazilandia");
    namesMap.put("TF", "Territorios Australes Franceses");
    namesMap.put("TH", "Tailandia");
    namesMap.put("TJ", "Tayikistán");
    namesMap.put("TN", "Túnez");
    namesMap.put("TR", "Turquía");
    namesMap.put("TT", "Trinidad y Tobago");
    namesMap.put("UM", "Islas menores alejadas de los EE.UU.");
    namesMap.put("US", "Estados Unidos");
    namesMap.put("UZ", "Uzbekistán");
    namesMap.put("VA", "Santa Sede (Ciudad del Vaticano)");
    namesMap.put("VI", "EE.UU. Islas Vírgenes");
    namesMap.put("WF", "Wallis y Futuna");
    namesMap.put("ZA", "Sudáfrica");
    namesMap.put("ZW", "Zimbabue");
  }

}
