/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "cu" locale.
 */

import org.gwtproject.i18n.shared.cldr.DateTimeFormatInfoImpl;

public class DateTimeFormatInfoImpl_cu extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] {
        "ДП",
        "ПП"
    };
  }

  @Override
  public String dateFormat() {
    return dateFormatMedium();
  }

  @Override
  public String dateFormatFull() {
    return "EEEE, d MMMM 'л'. y.";
  }

  @Override
  public String dateFormatLong() {
    return "y MMMM d";
  }

  @Override
  public String dateFormatMedium() {
    return "y MMM d";
  }

  @Override
  public String dateFormatShort() {
    return "y.MM.dd";
  }

  @Override
  public String dateTime(String timePattern, String datePattern) {
    return dateTimeMedium(timePattern, datePattern);
  }

  @Override
  public String dateTimeFull(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String dateTimeLong(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String dateTimeMedium(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String dateTimeShort(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "пре́дъ р. х.",
        "по р. х."
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "пре́дъ р. х.",
        "ѿ р. х."
    };
  }

  @Override
  public int firstDayOfTheWeek() {
    return 1;
  }

  @Override
  public String formatDay() {
    return "d";
  }

  @Override
  public String formatHour12Minute() {
    return "h:mm a";
  }

  @Override
  public String formatHour12MinuteSecond() {
    return "h:mm:ss a";
  }

  @Override
  public String formatHour24Minute() {
    return "HH:mm";
  }

  @Override
  public String formatHour24MinuteSecond() {
    return "HH:mm:ss";
  }

  @Override
  public String formatMinuteSecond() {
    return "mm:ss";
  }

  @Override
  public String formatMonthAbbrev() {
    return "LLL";
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "MMM d";
  }

  @Override
  public String formatMonthFull() {
    return "LLLL";
  }

  @Override
  public String formatMonthFullDay() {
    return "MMMM d";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "EEEE, MMMM d";
  }

  @Override
  public String formatMonthNumDay() {
    return "M/d";
  }

  @Override
  public String formatYear() {
    return "y";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "MMM y";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "MMM d, y";
  }

  @Override
  public String formatYearMonthFull() {
    return "MMMM y";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "MMMM d, y";
  }

  @Override
  public String formatYearMonthNum() {
    return "M/y";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "M/d/y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "EEE, MMM d, y";
  }

  @Override
  public String formatYearQuarterFull() {
    return "QQQQ y";
  }

  @Override
  public String formatYearQuarterShort() {
    return "Q y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "і҆аннꙋа́рїа",
        "феврꙋа́рїа",
        "ма́рта",
        "а҆прі́ллїа",
        "ма́їа",
        "і҆ꙋ́нїа",
        "і҆ꙋ́лїа",
        "а҆́ѵгꙋста",
        "септе́мврїа",
        "ѻ҆ктѡ́врїа",
        "ное́мврїа",
        "деке́мврїа"
    };
  }

  @Override
  public String[] monthsFullStandalone() {
    return new String[] {
        "і҆аннꙋа́рїй",
        "феврꙋа́рїй",
        "ма́ртъ",
        "а҆прі́ллїй",
        "ма́їй",
        "і҆ꙋ́нїй",
        "і҆ꙋ́лїй",
        "а҆́ѵгꙋстъ",
        "септе́мврїй",
        "ѻ҆ктѡ́врїй",
        "ное́мврїй",
        "деке́мврїй"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "І҆",
        "Ф",
        "М",
        "А҆",
        "М",
        "І҆",
        "І҆",
        "А҆",
        "С",
        "Ѻ҆",
        "Н",
        "Д"
    };
  }

  @Override
  public String[] monthsNarrowStandalone() {
    return monthsNarrow();
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "і҆аⷩ҇",
        "феⷡ҇",
        "маⷬ҇",
        "а҆пⷬ҇",
        "маꙵ",
        "і҆ꙋⷩ҇",
        "і҆ꙋⷧ҇",
        "а҆́ѵⷢ҇",
        "сеⷫ҇",
        "ѻ҆кⷮ",
        "ноеⷨ",
        "деⷦ҇"
    };
  }

  @Override
  public String[] monthsShortStandalone() {
    return monthsShort();
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "а҃_ѧ че́тверть",
        "в҃_ѧ че́тверть",
        "г҃_ѧ че́тверть",
        "д҃_ѧ че́тверть"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "а҃_ѧ че́тверть",
        "в҃_ѧ че́тверть",
        "г҃_ѧ че́тверть",
        "д҃_ѧ че́тверть"
    };
  }

  @Override
  public String timeFormat() {
    return timeFormatMedium();
  }

  @Override
  public String timeFormatFull() {
    return "HH:mm:ss zzzz";
  }

  @Override
  public String timeFormatLong() {
    return "HH:mm:ss z";
  }

  @Override
  public String timeFormatMedium() {
    return "HH:mm:ss";
  }

  @Override
  public String timeFormatShort() {
    return "HH:mm";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "недѣ́лѧ",
        "понедѣ́льникъ",
        "вто́рникъ",
        "среда̀",
        "четверто́къ",
        "пѧто́къ",
        "сꙋббѡ́та"
    };
  }

  @Override
  public String[] weekdaysFullStandalone() {
    return weekdaysFull();
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "Н",
        "П",
        "В",
        "С",
        "Ч",
        "П",
        "С"
    };
  }

  @Override
  public String[] weekdaysNarrowStandalone() {
    return weekdaysNarrow();
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "ндⷧ҇ѧ",
        "пнⷣе",
        "втоⷬ҇",
        "срⷣе",
        "чеⷦ҇",
        "пѧⷦ҇",
        "сꙋⷠ҇"
    };
  }

  @Override
  public String[] weekdaysShortStandalone() {
    return weekdaysShort();
  }

  @Override
  public int weekendEnd() {
    return 0;
  }

  @Override
  public int weekendStart() {
    return 6;
  }
}
