/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "gl" locale.
 */

import org.gwtproject.i18n.shared.cldr.DateTimeFormatInfoImpl;

public class DateTimeFormatInfoImpl_gl extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] {
        "a.m.",
        "p.m."
    };
  }

  @Override
  public String dateFormat() {
    return dateFormatMedium();
  }

  @Override
  public String dateFormatFull() {
    return "EEEE, d 'de' MMMM 'de' y";
  }

  @Override
  public String dateFormatLong() {
    return "d 'de' MMMM 'de' y";
  }

  @Override
  public String dateFormatMedium() {
    return "d 'de' MMM 'de' y";
  }

  @Override
  public String dateFormatShort() {
    return "dd/MM/yy";
  }

  @Override
  public String dateTime(String timePattern, String datePattern) {
    return dateTimeMedium(timePattern, datePattern);
  }

  @Override
  public String dateTimeFull(String timePattern, String datePattern) {
    return timePattern + " 'do' " + datePattern;
  }

  @Override
  public String dateTimeLong(String timePattern, String datePattern) {
    return timePattern + " 'do' " + datePattern;
  }

  @Override
  public String dateTimeMedium(String timePattern, String datePattern) {
    return timePattern + ", " + datePattern;
  }

  @Override
  public String dateTimeShort(String timePattern, String datePattern) {
    return timePattern + ", " + datePattern;
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "antes de Cristo",
        "despois de Cristo"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "a.C.",
        "d.C."
    };
  }

  @Override
  public int firstDayOfTheWeek() {
    return 1;
  }

  @Override
  public String formatDay() {
    return "d";
  }

  @Override
  public String formatHour12Minute() {
    return "h:mm a";
  }

  @Override
  public String formatHour12MinuteSecond() {
    return "h:mm:ss a";
  }

  @Override
  public String formatHour24Minute() {
    return "HH:mm";
  }

  @Override
  public String formatHour24MinuteSecond() {
    return "HH:mm:ss";
  }

  @Override
  public String formatMinuteSecond() {
    return "mm:ss";
  }

  @Override
  public String formatMonthAbbrev() {
    return "LLL";
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "d 'de' MMM";
  }

  @Override
  public String formatMonthFull() {
    return "LLLL";
  }

  @Override
  public String formatMonthFullDay() {
    return "d 'de' MMMM";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "EEEE, d 'de' MMMM";
  }

  @Override
  public String formatMonthNumDay() {
    return "d/M";
  }

  @Override
  public String formatYear() {
    return "y";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "MMM 'de' y";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "d/MM/y";
  }

  @Override
  public String formatYearMonthFull() {
    return "MMMM 'de' y";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "d 'de' MMMM 'de' y";
  }

  @Override
  public String formatYearMonthNum() {
    return "M/y";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "d/M/y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "EEE, d/MM/y";
  }

  @Override
  public String formatYearQuarterFull() {
    return "QQQQ 'de' y";
  }

  @Override
  public String formatYearQuarterShort() {
    return "Q y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "xaneiro",
        "febreiro",
        "marzo",
        "abril",
        "maio",
        "xuño",
        "xullo",
        "agosto",
        "setembro",
        "outubro",
        "novembro",
        "decembro"
    };
  }

  @Override
  public String[] monthsFullStandalone() {
    return new String[] {
        "Xaneiro",
        "Febreiro",
        "Marzo",
        "Abril",
        "Maio",
        "Xuño",
        "Xullo",
        "Agosto",
        "Setembro",
        "Outubro",
        "Novembro",
        "Decembro"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "x.",
        "f.",
        "m.",
        "a.",
        "m.",
        "x.",
        "x.",
        "a.",
        "s.",
        "o.",
        "n.",
        "d."
    };
  }

  @Override
  public String[] monthsNarrowStandalone() {
    return new String[] {
        "X",
        "F",
        "M",
        "A",
        "M",
        "X",
        "X",
        "A",
        "S",
        "O",
        "N",
        "D"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "xan.",
        "feb.",
        "mar.",
        "abr.",
        "maio",
        "xuño",
        "xul.",
        "ago.",
        "set.",
        "out.",
        "nov.",
        "dec."
    };
  }

  @Override
  public String[] monthsShortStandalone() {
    return new String[] {
        "Xan.",
        "Feb.",
        "Mar.",
        "Abr.",
        "Maio",
        "Xuño",
        "Xul.",
        "Ago.",
        "Set.",
        "Out.",
        "Nov.",
        "Dec."
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "1.º trimestre",
        "2.º trimestre",
        "3.º trimestre",
        "4.º trimestre"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "T1",
        "T2",
        "T3",
        "T4"
    };
  }

  @Override
  public String timeFormat() {
    return timeFormatMedium();
  }

  @Override
  public String timeFormatFull() {
    return "HH:mm:ss zzzz";
  }

  @Override
  public String timeFormatLong() {
    return "HH:mm:ss z";
  }

  @Override
  public String timeFormatMedium() {
    return "HH:mm:ss";
  }

  @Override
  public String timeFormatShort() {
    return "HH:mm";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "domingo",
        "luns",
        "martes",
        "mércores",
        "xoves",
        "venres",
        "sábado"
    };
  }

  @Override
  public String[] weekdaysFullStandalone() {
    return new String[] {
        "Domingo",
        "Luns",
        "Martes",
        "Mércores",
        "Xoves",
        "Venres",
        "Sábado"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "d.",
        "l.",
        "m.",
        "m.",
        "x.",
        "v.",
        "s."
    };
  }

  @Override
  public String[] weekdaysNarrowStandalone() {
    return new String[] {
        "D",
        "L",
        "M",
        "M",
        "X",
        "V",
        "S"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "dom.",
        "luns",
        "mar.",
        "mér.",
        "xov.",
        "ven.",
        "sáb."
    };
  }

  @Override
  public String[] weekdaysShortStandalone() {
    return new String[] {
        "Dom.",
        "Luns",
        "Mar.",
        "Mér.",
        "Xov.",
        "Ven.",
        "Sáb."
    };
  }

  @Override
  public int weekendEnd() {
    return 0;
  }

  @Override
  public int weekendStart() {
    return 6;
  }
}
