/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "my" locale.
 */

import org.gwtproject.i18n.shared.cldr.DateTimeFormatInfoImpl;

public class DateTimeFormatInfoImpl_my extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] {
        "နံနက်",
        "ညနေ"
    };
  }

  @Override
  public String dateFormat() {
    return dateFormatMedium();
  }

  @Override
  public String dateFormatFull() {
    return "y၊ MMMM d၊ EEEE";
  }

  @Override
  public String dateFormatLong() {
    return "y၊ d MMMM";
  }

  @Override
  public String dateFormatMedium() {
    return "y၊ MMM d";
  }

  @Override
  public String dateFormatShort() {
    return "dd-MM-yy";
  }

  @Override
  public String dateTime(String timePattern, String datePattern) {
    return dateTimeMedium(timePattern, datePattern);
  }

  @Override
  public String dateTimeFull(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String dateTimeLong(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String dateTimeMedium(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String dateTimeShort(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "ခရစ်တော် မပေါ်မီနှစ်",
        "ခရစ်နှစ်"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "ဘီစီ",
        "အဒေီ"
    };
  }

  @Override
  public int firstDayOfTheWeek() {
    return 0;
  }

  @Override
  public String formatDay() {
    return "d";
  }

  @Override
  public String formatHour12Minute() {
    return "a h:mm";
  }

  @Override
  public String formatHour12MinuteSecond() {
    return "a h:mm:ss";
  }

  @Override
  public String formatHour24Minute() {
    return "B H:mm";
  }

  @Override
  public String formatHour24MinuteSecond() {
    return "B HH:mm:ss";
  }

  @Override
  public String formatMinuteSecond() {
    return "mm:ss";
  }

  @Override
  public String formatMonthAbbrev() {
    return "LLL";
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "d MMM";
  }

  @Override
  public String formatMonthFull() {
    return "LLLL";
  }

  @Override
  public String formatMonthFullDay() {
    return "MMMM d";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "MMMM d ရက် EEEEနေ့";
  }

  @Override
  public String formatMonthNumDay() {
    return "d/M";
  }

  @Override
  public String formatYear() {
    return "y";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "MMM y";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "y၊ MMM d";
  }

  @Override
  public String formatYearMonthFull() {
    return "y MMMM";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "y၊ d MMMM";
  }

  @Override
  public String formatYearMonthNum() {
    return "M/y";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "dd-MM-y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "y၊ MMM d၊ EEE";
  }

  @Override
  public String formatYearQuarterFull() {
    return "y QQQQ";
  }

  @Override
  public String formatYearQuarterShort() {
    return "y Q";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "ဇန်နဝါရီ",
        "ဖေဖော်ဝါရီ",
        "မတ်",
        "ဧပြီ",
        "မေ",
        "ဇွန်",
        "ဇူလိုင်",
        "ဩဂုတ်",
        "စက်တင်ဘာ",
        "အောက်တိုဘာ",
        "နိုဝင်ဘာ",
        "ဒီဇင်ဘာ"
    };
  }

  @Override
  public String[] monthsFullStandalone() {
    return monthsFull();
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "ဇ",
        "ဖ",
        "မ",
        "ဧ",
        "မ",
        "ဇ",
        "ဇ",
        "ဩ",
        "စ",
        "အ",
        "န",
        "ဒ"
    };
  }

  @Override
  public String[] monthsNarrowStandalone() {
    return monthsNarrow();
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "ဇန်",
        "ဖေ",
        "မတ်",
        "ဧ",
        "မေ",
        "ဇွန်",
        "ဇူ",
        "ဩ",
        "စက်",
        "အောက်",
        "နို",
        "ဒီ"
    };
  }

  @Override
  public String[] monthsShortStandalone() {
    return monthsShort();
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "ပထမ သုံးလပတ်",
        "ဒုတိယ သုံးလပတ်",
        "တတိယ သုံးလပတ်",
        "စတုတ္ထ သုံးလပတ်"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "ပထမ သုံးလပတ်",
        "ဒုတိယ သုံးလပတ်",
        "တတိယ သုံးလပတ်",
        "စတုတ္ထ သုံးလပတ်"
    };
  }

  @Override
  public String timeFormat() {
    return timeFormatMedium();
  }

  @Override
  public String timeFormatFull() {
    return "zzzz HH:mm:ss";
  }

  @Override
  public String timeFormatLong() {
    return "z HH:mm:ss";
  }

  @Override
  public String timeFormatMedium() {
    return "B HH:mm:ss";
  }

  @Override
  public String timeFormatShort() {
    return "B H:mm";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "တနင်္ဂနွေ",
        "တနင်္လာ",
        "အင်္ဂါ",
        "ဗုဒ္ဓဟူး",
        "ကြာသပတေး",
        "သောကြာ",
        "စနေ"
    };
  }

  @Override
  public String[] weekdaysFullStandalone() {
    return weekdaysFull();
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "တ",
        "တ",
        "အ",
        "ဗ",
        "က",
        "သ",
        "စ"
    };
  }

  @Override
  public String[] weekdaysNarrowStandalone() {
    return weekdaysNarrow();
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "တနင်္ဂနွေ",
        "တနင်္လာ",
        "အင်္ဂါ",
        "ဗုဒ္ဓဟူး",
        "ကြာသပတေး",
        "သောကြာ",
        "စနေ"
    };
  }

  @Override
  public String[] weekdaysShortStandalone() {
    return weekdaysShort();
  }

  @Override
  public int weekendEnd() {
    return 0;
  }

  @Override
  public int weekendStart() {
    return 6;
  }
}
