/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;

import org.gwtproject.i18n.shared.cldr.LocalizedNamesImplBase;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "cs" locale.
 */
public class LocalizedNamesImpl_cs extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "CZ",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AX",
        "AL",
        "DZ",
        "AS",
        "VI",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AC",
        "AU",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BY",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BV",
        "BR",
        "IO",
        "VG",
        "BN",
        "BG",
        "BF",
        "BI",
        "EA",
        "CP",
        "CK",
        "CW",
        "TD",
        "ME",
        "CZ",
        "CN",
        "DK",
        "DG",
        "DM",
        "DO",
        "DJ",
        "EG",
        "EC",
        "ER",
        "EE",
        "ET",
        "EZ",
        "EU",
        "FO",
        "FK",
        "FJ",
        "PH",
        "FI",
        "FR",
        "GF",
        "TF",
        "PF",
        "GA",
        "GM",
        "GH",
        "GI",
        "GD",
        "GL",
        "GE",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GY",
        "HT",
        "HM",
        "HN",
        "HK",
        "CL",
        "HR",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IT",
        "IL",
        "JM",
        "JP",
        "YE",
        "JE",
        "ZA",
        "GS",
        "KR",
        "SS",
        "JO",
        "KY",
        "KH",
        "CM",
        "CA",
        "IC",
        "CV",
        "BQ",
        "QA",
        "KZ",
        "KE",
        "KI",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "XK",
        "CR",
        "CU",
        "KW",
        "CY",
        "KG",
        "LA",
        "LS",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LV",
        "LU",
        "MO",
        "MG",
        "HU",
        "MK",
        "MY",
        "MW",
        "MV",
        "ML",
        "MT",
        "MA",
        "MH",
        "MQ",
        "MU",
        "MR",
        "YT",
        "UM",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "DE",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "NL",
        "NF",
        "NO",
        "NC",
        "NZ",
        "OM",
        "UN",
        "IM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "CI",
        "PL",
        "PR",
        "PT",
        "AT",
        "RE",
        "GQ",
        "RO",
        "RU",
        "RW",
        "GR",
        "PM",
        "SV",
        "WS",
        "SM",
        "SA",
        "SN",
        "KP",
        "MP",
        "SC",
        "SL",
        "SG",
        "SK",
        "SI",
        "SO",
        "AE",
        "GB",
        "US",
        "RS",
        "LK",
        "CF",
        "SD",
        "SR",
        "SH",
        "LC",
        "BL",
        "KN",
        "MF",
        "SX",
        "ST",
        "VC",
        "SZ",
        "SY",
        "SB",
        "ES",
        "SJ",
        "SE",
        "CH",
        "TJ",
        "TZ",
        "TH",
        "TW",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "UG",
        "UA",
        "UY",
        "UZ",
        "CX",
        "VU",
        "VA",
        "VE",
        "VN",
        "QO",
        "TL",
        "WF",
        "XA",
        "XB",
        "ZM",
        "EH",
        "ZW",
    };
  }

  @Override
  protected void loadNameMap() {
    super.loadNameMap();
    namesMap.put("001", "svět");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Severní Amerika");
    namesMap.put("005", "Jižní Amerika");
    namesMap.put("009", "Oceánie");
    namesMap.put("011", "západní Afrika");
    namesMap.put("013", "Střední Amerika");
    namesMap.put("014", "východní Afrika");
    namesMap.put("015", "severní Afrika");
    namesMap.put("017", "střední Afrika");
    namesMap.put("018", "jižní Afrika");
    namesMap.put("019", "Amerika");
    namesMap.put("021", "Severní Amerika (oblast)");
    namesMap.put("029", "Karibik");
    namesMap.put("030", "východní Asie");
    namesMap.put("034", "jižní Asie");
    namesMap.put("035", "jihovýchodní Asie");
    namesMap.put("039", "jižní Evropa");
    namesMap.put("053", "Australasie");
    namesMap.put("054", "Melanésie");
    namesMap.put("057", "Mikronésie (region)");
    namesMap.put("061", "Polynésie");
    namesMap.put("142", "Asie");
    namesMap.put("143", "Střední Asie");
    namesMap.put("145", "západní Asie");
    namesMap.put("150", "Evropa");
    namesMap.put("151", "východní Evropa");
    namesMap.put("154", "severní Evropa");
    namesMap.put("155", "západní Evropa");
    namesMap.put("202", "subsaharská Afrika");
    namesMap.put("419", "Latinská Amerika");
    namesMap.put("AC", "Ascension");
    namesMap.put("AE", "Spojené arabské emiráty");
    namesMap.put("AF", "Afghánistán");
    namesMap.put("AG", "Antigua a Barbuda");
    namesMap.put("AL", "Albánie");
    namesMap.put("AM", "Arménie");
    namesMap.put("AQ", "Antarktida");
    namesMap.put("AS", "Americká Samoa");
    namesMap.put("AT", "Rakousko");
    namesMap.put("AU", "Austrálie");
    namesMap.put("AX", "Ålandy");
    namesMap.put("AZ", "Ázerbájdžán");
    namesMap.put("BA", "Bosna a Hercegovina");
    namesMap.put("BD", "Bangladéš");
    namesMap.put("BE", "Belgie");
    namesMap.put("BG", "Bulharsko");
    namesMap.put("BH", "Bahrajn");
    namesMap.put("BL", "Svatý Bartoloměj");
    namesMap.put("BM", "Bermudy");
    namesMap.put("BN", "Brunej");
    namesMap.put("BO", "Bolívie");
    namesMap.put("BQ", "Karibské Nizozemsko");
    namesMap.put("BR", "Brazílie");
    namesMap.put("BS", "Bahamy");
    namesMap.put("BT", "Bhútán");
    namesMap.put("BV", "Bouvetův ostrov");
    namesMap.put("BY", "Bělorusko");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Kokosové ostrovy");
    namesMap.put("CD", "Kongo – Kinshasa");
    namesMap.put("CF", "Středoafrická republika");
    namesMap.put("CG", "Kongo – Brazzaville");
    namesMap.put("CH", "Švýcarsko");
    namesMap.put("CI", "Pobřeží slonoviny");
    namesMap.put("CK", "Cookovy ostrovy");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Čína");
    namesMap.put("CO", "Kolumbie");
    namesMap.put("CP", "Clippertonův ostrov");
    namesMap.put("CR", "Kostarika");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kapverdy");
    namesMap.put("CX", "Vánoční ostrov");
    namesMap.put("CY", "Kypr");
    namesMap.put("CZ", "Česko");
    namesMap.put("DE", "Německo");
    namesMap.put("DG", "Diego García");
    namesMap.put("DJ", "Džibutsko");
    namesMap.put("DK", "Dánsko");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Dominikánská republika");
    namesMap.put("DZ", "Alžírsko");
    namesMap.put("EA", "Ceuta a Melilla");
    namesMap.put("EC", "Ekvádor");
    namesMap.put("EE", "Estonsko");
    namesMap.put("EH", "Západní Sahara");
    namesMap.put("ES", "Španělsko");
    namesMap.put("ET", "Etiopie");
    namesMap.put("EU", "Evropská unie");
    namesMap.put("EZ", "eurozóna");
    namesMap.put("FI", "Finsko");
    namesMap.put("FJ", "Fidži");
    namesMap.put("FK", "Falklandské ostrovy");
    namesMap.put("FM", "Mikronésie");
    namesMap.put("FO", "Faerské ostrovy");
    namesMap.put("FR", "Francie");
    namesMap.put("GB", "Spojené království");
    namesMap.put("GE", "Gruzie");
    namesMap.put("GF", "Francouzská Guyana");
    namesMap.put("GL", "Grónsko");
    namesMap.put("GM", "Gambie");
    namesMap.put("GQ", "Rovníková Guinea");
    namesMap.put("GR", "Řecko");
    namesMap.put("GS", "Jižní Georgie a Jižní Sandwichovy ostrovy");
    namesMap.put("HK", "Hongkong – ZAO Číny");
    namesMap.put("HM", "Heardův ostrov a McDonaldovy ostrovy");
    namesMap.put("HR", "Chorvatsko");
    namesMap.put("HU", "Maďarsko");
    namesMap.put("IC", "Kanárské ostrovy");
    namesMap.put("ID", "Indonésie");
    namesMap.put("IE", "Irsko");
    namesMap.put("IL", "Izrael");
    namesMap.put("IM", "Ostrov Man");
    namesMap.put("IN", "Indie");
    namesMap.put("IO", "Britské indickooceánské území");
    namesMap.put("IQ", "Irák");
    namesMap.put("IR", "Írán");
    namesMap.put("IS", "Island");
    namesMap.put("IT", "Itálie");
    namesMap.put("JM", "Jamajka");
    namesMap.put("JO", "Jordánsko");
    namesMap.put("JP", "Japonsko");
    namesMap.put("KE", "Keňa");
    namesMap.put("KG", "Kyrgyzstán");
    namesMap.put("KH", "Kambodža");
    namesMap.put("KM", "Komory");
    namesMap.put("KN", "Svatý Kryštof a Nevis");
    namesMap.put("KP", "Severní Korea");
    namesMap.put("KR", "Jižní Korea");
    namesMap.put("KW", "Kuvajt");
    namesMap.put("KY", "Kajmanské ostrovy");
    namesMap.put("KZ", "Kazachstán");
    namesMap.put("LB", "Libanon");
    namesMap.put("LC", "Svatá Lucie");
    namesMap.put("LI", "Lichtenštejnsko");
    namesMap.put("LK", "Srí Lanka");
    namesMap.put("LR", "Libérie");
    namesMap.put("LT", "Litva");
    namesMap.put("LU", "Lucembursko");
    namesMap.put("LV", "Lotyšsko");
    namesMap.put("LY", "Libye");
    namesMap.put("MA", "Maroko");
    namesMap.put("MC", "Monako");
    namesMap.put("MD", "Moldavsko");
    namesMap.put("ME", "Černá Hora");
    namesMap.put("MF", "Svatý Martin (Francie)");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Marshallovy ostrovy");
    namesMap.put("MK", "Makedonie");
    namesMap.put("MM", "Myanmar (Barma)");
    namesMap.put("MN", "Mongolsko");
    namesMap.put("MO", "Macao – ZAO Číny");
    namesMap.put("MP", "Severní Mariany");
    namesMap.put("MQ", "Martinik");
    namesMap.put("MR", "Mauritánie");
    namesMap.put("MU", "Mauricius");
    namesMap.put("MV", "Maledivy");
    namesMap.put("MX", "Mexiko");
    namesMap.put("MY", "Malajsie");
    namesMap.put("MZ", "Mosambik");
    namesMap.put("NA", "Namibie");
    namesMap.put("NC", "Nová Kaledonie");
    namesMap.put("NF", "Norfolk");
    namesMap.put("NG", "Nigérie");
    namesMap.put("NI", "Nikaragua");
    namesMap.put("NL", "Nizozemsko");
    namesMap.put("NO", "Norsko");
    namesMap.put("NP", "Nepál");
    namesMap.put("NZ", "Nový Zéland");
    namesMap.put("OM", "Omán");
    namesMap.put("PF", "Francouzská Polynésie");
    namesMap.put("PG", "Papua-Nová Guinea");
    namesMap.put("PH", "Filipíny");
    namesMap.put("PK", "Pákistán");
    namesMap.put("PL", "Polsko");
    namesMap.put("PM", "Saint-Pierre a Miquelon");
    namesMap.put("PN", "Pitcairnovy ostrovy");
    namesMap.put("PR", "Portoriko");
    namesMap.put("PS", "Palestinská území");
    namesMap.put("PT", "Portugalsko");
    namesMap.put("QA", "Katar");
    namesMap.put("QO", "vnější Oceánie");
    namesMap.put("RO", "Rumunsko");
    namesMap.put("RS", "Srbsko");
    namesMap.put("RU", "Rusko");
    namesMap.put("SA", "Saúdská Arábie");
    namesMap.put("SB", "Šalamounovy ostrovy");
    namesMap.put("SC", "Seychely");
    namesMap.put("SD", "Súdán");
    namesMap.put("SE", "Švédsko");
    namesMap.put("SG", "Singapur");
    namesMap.put("SH", "Svatá Helena");
    namesMap.put("SI", "Slovinsko");
    namesMap.put("SJ", "Špicberky a Jan Mayen");
    namesMap.put("SK", "Slovensko");
    namesMap.put("SO", "Somálsko");
    namesMap.put("SR", "Surinam");
    namesMap.put("SS", "Jižní Súdán");
    namesMap.put("ST", "Svatý Tomáš a Princův ostrov");
    namesMap.put("SV", "Salvador");
    namesMap.put("SX", "Svatý Martin (Nizozemsko)");
    namesMap.put("SY", "Sýrie");
    namesMap.put("SZ", "Svazijsko");
    namesMap.put("TC", "Turks a Caicos");
    namesMap.put("TD", "Čad");
    namesMap.put("TF", "Francouzská jižní území");
    namesMap.put("TH", "Thajsko");
    namesMap.put("TJ", "Tádžikistán");
    namesMap.put("TL", "Východní Timor");
    namesMap.put("TM", "Turkmenistán");
    namesMap.put("TN", "Tunisko");
    namesMap.put("TR", "Turecko");
    namesMap.put("TT", "Trinidad a Tobago");
    namesMap.put("TW", "Tchaj-wan");
    namesMap.put("TZ", "Tanzanie");
    namesMap.put("UA", "Ukrajina");
    namesMap.put("UM", "Menší odlehlé ostrovy USA");
    namesMap.put("UN", "Organizace spojených národů");
    namesMap.put("US", "Spojené státy");
    namesMap.put("UZ", "Uzbekistán");
    namesMap.put("VA", "Vatikán");
    namesMap.put("VC", "Svatý Vincenc a Grenadiny");
    namesMap.put("VG", "Britské Panenské ostrovy");
    namesMap.put("VI", "Americké Panenské ostrovy");
    namesMap.put("WF", "Wallis a Futuna");
    namesMap.put("YE", "Jemen");
    namesMap.put("ZA", "Jihoafrická republika");
    namesMap.put("ZM", "Zambie");
    namesMap.put("ZZ", "neznámá oblast");
  }

}
