package org.dominokit.ui.tools.processor;

import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import org.dominokit.jackson.JsonSerializationContext;
import org.dominokit.jackson.JsonSerializer;
import org.dominokit.jackson.ser.BooleanJsonSerializer;
import org.dominokit.jackson.ser.CollectionJsonSerializer;
import org.dominokit.jackson.ser.StringJsonSerializer;
import org.dominokit.jackson.ser.bean.AbstractBeanJsonSerializer;
import org.dominokit.jackson.ser.bean.BeanPropertySerializer;

public final class MetaIconInfoBeanJsonSerializerImpl extends AbstractBeanJsonSerializer<MetaIconInfo> {
  private static final MetaIconInfoBeanJsonSerializerImpl INSTANCE = new MetaIconInfoBeanJsonSerializerImpl();

  public MetaIconInfoBeanJsonSerializerImpl() {
  }

  public static MetaIconInfoBeanJsonSerializerImpl getInstance() {
    return INSTANCE;
  }

  @Override
  public Class getSerializedType() {
    return MetaIconInfo.class;
  }

  @Override
  protected BeanPropertySerializer[] initSerializers() {
    BeanPropertySerializer[] result = new BeanPropertySerializer[7];
    result[0] = new BeanPropertySerializer<MetaIconInfo, String>("name") {
      @Override
      protected JsonSerializer<?> newSerializer() {
        return StringJsonSerializer.getInstance();
      }

      @Override
      public String getValue(MetaIconInfo bean, JsonSerializationContext ctx) {
        return bean.getName();
      }
    };
    result[1] = new BeanPropertySerializer<MetaIconInfo, String>("codepoint") {
      @Override
      protected JsonSerializer<?> newSerializer() {
        return StringJsonSerializer.getInstance();
      }

      @Override
      public String getValue(MetaIconInfo bean, JsonSerializationContext ctx) {
        return bean.getCodepoint();
      }
    };
    result[2] = new BeanPropertySerializer<MetaIconInfo, List<String>>("aliases") {
      @Override
      protected JsonSerializer<?> newSerializer() {
        return CollectionJsonSerializer.newInstance(StringJsonSerializer.getInstance());
      }

      @Override
      public List<String> getValue(MetaIconInfo bean, JsonSerializationContext ctx) {
        return bean.getAliases();
      }
    };
    result[3] = new BeanPropertySerializer<MetaIconInfo, List<String>>("tags") {
      @Override
      protected JsonSerializer<?> newSerializer() {
        return CollectionJsonSerializer.newInstance(StringJsonSerializer.getInstance());
      }

      @Override
      public List<String> getValue(MetaIconInfo bean, JsonSerializationContext ctx) {
        return bean.getTags();
      }
    };
    result[4] = new BeanPropertySerializer<MetaIconInfo, String>("author") {
      @Override
      protected JsonSerializer<?> newSerializer() {
        return StringJsonSerializer.getInstance();
      }

      @Override
      public String getValue(MetaIconInfo bean, JsonSerializationContext ctx) {
        return bean.getAuthor();
      }
    };
    result[5] = new BeanPropertySerializer<MetaIconInfo, String>("version") {
      @Override
      protected JsonSerializer<?> newSerializer() {
        return StringJsonSerializer.getInstance();
      }

      @Override
      public String getValue(MetaIconInfo bean, JsonSerializationContext ctx) {
        return bean.getVersion();
      }
    };
    result[6] = new BeanPropertySerializer<MetaIconInfo, Boolean>("deprecated") {
      @Override
      protected JsonSerializer<?> newSerializer() {
        return BooleanJsonSerializer.getInstance();
      }

      @Override
      public Boolean getValue(MetaIconInfo bean, JsonSerializationContext ctx) {
        return bean.isDeprecated();
      }
    };
    return result;
  }
}
