/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.ui.tools.processor;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;

public class CssToJavaCssConverter {
    public static void main(String[] args) throws IOException {
        InputStream source = CssToJavaCssConverter.class.getResourceAsStream("/converter-source.css");
        String css = IOUtils.toString((InputStream)source, (Charset)StandardCharsets.UTF_8);
        StringBuffer sb = new StringBuffer();
        String[] split = css.split("\\r?\\n|\\r");
        Arrays.stream(split).filter(line -> line.startsWith(".dui")).forEach(line -> sb.append(CssToJavaCssConverter.toJavaCss(line) + "\n"));
        System.out.println(sb);
    }

    private static String toJavaCss(String line) {
        return "CssClass " + CssToJavaCssConverter.asName(line) + " = () -> \"" + CssToJavaCssConverter.asStyleName(line) + "\";";
    }

    private static String asName(String line) {
        return line.replace(".dui", "dui").replace("duidui", "dui").replace("\\\\", "_").replace("-", "_").replace(" > * + *", "").replace(" {", "").toLowerCase();
    }

    private static String asStyleName(String line) {
        return line.substring(1).replace(" > * + *", "").replace("dui.dui", "dui").replace(" {", "");
    }
}

