/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.ui.tools.processor;

import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.dominokit.ui.tools.processor.MdiIconsSourceWriter;
import org.dominokit.ui.tools.processor.MetaIconInfo;
import org.dominokit.ui.tools.processor.MetaIconInfo_MapperImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdiIconsProcessingStep {
    private static final String MDI_VERSION = "v7.2.96";
    private static final Logger LOGGER = LoggerFactory.getLogger(MdiIconsProcessingStep.class);
    public static final String ICONS_ROOT_PACKAGE = "org.dominokit.domino.ui.icons";
    public static final String PUBLIC_ROOT = "org.dominokit.domino.ui.public";

    public static void main(String[] args) {
        MdiIconsProcessingStep.generateIcons();
        MdiIconsProcessingStep.updateFonts();
        MdiIconsProcessingStep.updateCss();
    }

    private static Path getIconRootPath() {
        return Paths.get("domino-ui/src/main/java", ICONS_ROOT_PACKAGE.replace(".", "/"));
    }

    private static Path getSourceRootPath() {
        return Paths.get("domino-ui/src/main/java", new String[0]);
    }

    private static Path getResourceRootPath() {
        return Paths.get("domino-ui/src/main/resources", new String[0]);
    }

    private static Path getResourcePublicRootPath() {
        return Paths.get("domino-ui/src/main/resources/org/dominokit/domino/ui/public", new String[0]);
    }

    private static void updateFonts() {
        MdiIconsProcessingStep.copyFont("materialdesignicons-webfont.eot");
        MdiIconsProcessingStep.copyFont("materialdesignicons-webfont.ttf");
        MdiIconsProcessingStep.copyFont("materialdesignicons-webfont.woff");
        MdiIconsProcessingStep.copyFont("materialdesignicons-webfont.woff2");
    }

    private static void updateCss() {
        MdiIconsProcessingStep.copyCss("materialdesignicons.css");
        MdiIconsProcessingStep.copyCss("materialdesignicons.css.map");
        MdiIconsProcessingStep.copyCss("materialdesignicons.min.css");
        MdiIconsProcessingStep.copyCss("materialdesignicons.min.css.map");
    }

    private static void copyFont(String fontName) {
        try (InputStream inputStream = new URL("https://github.com/Templarian/MaterialDesign-Webfont/blob/v7.2.96/fonts/" + fontName + "?raw=true").openStream();){
            MdiIconsProcessingStep.copyFont(fontName, inputStream);
        }
        catch (IOException e) {
            try {
                MdiIconsProcessingStep.copyFont(fontName, Files.newInputStream(Paths.get(MdiIconsProcessingStep.getResourceRootPath().toString(), "cached/mdi/fonts/" + fontName), new OpenOption[0]));
            }
            catch (IOException ex) {
                LOGGER.error("", (Throwable)ex);
            }
        }
    }

    private static void copyFont(String fontName, InputStream inputStream) throws IOException {
        Path path = Paths.get(MdiIconsProcessingStep.getResourcePublicRootPath().toString(), "css/fonts/" + fontName);
        OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);
        IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
        outputStream.close();
    }

    private static void copyCss(String cssName) {
        try (InputStream inputStream = new URL("https://raw.githubusercontent.com/Templarian/MaterialDesign-Webfont/v7.2.96/css/" + cssName + "?raw=true").openStream();){
            MdiIconsProcessingStep.copyCss(cssName, inputStream);
        }
        catch (IOException e) {
            try {
                MdiIconsProcessingStep.copyFont(cssName, Files.newInputStream(Paths.get(MdiIconsProcessingStep.getResourceRootPath().toString(), "cached/mdi/css/" + cssName), new OpenOption[0]));
            }
            catch (IOException ex) {
                LOGGER.error("", (Throwable)ex);
            }
        }
    }

    private static void copyCss(String cssName, InputStream inputStream) throws IOException {
        Path path = Paths.get(MdiIconsProcessingStep.getResourcePublicRootPath().toString(), "css/domino-ui/dui-components/mdi/" + cssName);
        System.out.println(path.toFile().getAbsolutePath().toString());
        OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);
        IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
        outputStream.close();
    }

    private static void generateIcons() {
        MdiIconsProcessingStep.writeSource(new MdiIconsSourceWriter(ICONS_ROOT_PACKAGE, MdiIconsProcessingStep.loadIconMetaInfo()).asTypeBuilder(), "org.dominokit.domino.ui.icons.lib");
    }

    protected static void writeSource(List<TypeSpec.Builder> builders, String rootPackage) {
        builders.forEach(builder -> {
            JavaFile javaFile = JavaFile.builder((String)rootPackage, (TypeSpec)builder.build()).build();
            MdiIconsProcessingStep.writeSource(javaFile);
        });
    }

    protected static void writeSource(JavaFile sourceFile) {
        try {
            sourceFile.writeTo(Paths.get(MdiIconsProcessingStep.getSourceRootPath().toString(), new String[0]));
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    private static List<MetaIconInfo> loadIconMetaInfo() {
        List<MetaIconInfo> list;
        block8: {
            InputStream meta = new URL("https://raw.githubusercontent.com/Templarian/MaterialDesign-SVG/v7.2.96/meta.json").openStream();
            try {
                String metaJson = IOUtils.toString((InputStream)meta, (String)"UTF-8");
                list = Arrays.asList((MetaIconInfo[])MetaIconInfo_MapperImpl.INSTANCE.readArray(metaJson, MetaIconInfo[]::new));
                if (meta == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (meta != null) {
                        try {
                            meta.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("", (Throwable)e);
                    return new ArrayList<MetaIconInfo>();
                }
            }
            meta.close();
        }
        return list;
    }
}

