/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.ui.tools.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.dominokit.ui.tools.processor.MetaIconInfo;

public class MdiIconsSourceWriter {
    public static final Set<String> RESERVED_KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null"));
    private static final String MDI_ICON_TYPE = "org.dominokit.domino.ui.icons.MdiIcon";
    private static final String MDI_ICON_FACTORY_TYPE = "org.dominokit.domino.ui.icons.MdiIconsByTagFactory";
    private static final String MDI_META_TYPE = "org.dominokit.domino.ui.icons.MdiMeta";
    public static final String UNTAGGED = "UnTagged";
    private final List<MetaIconInfo> metaIconInfos;
    private final String rootPackageName;

    protected MdiIconsSourceWriter(String rootPackage, List<MetaIconInfo> metaIconInfos) {
        this.metaIconInfos = metaIconInfos;
        this.rootPackageName = rootPackage + ".lib";
    }

    public List<TypeSpec.Builder> asTypeBuilder() {
        return new ArrayList<TypeSpec.Builder>(this.generateIconsByTag());
    }

    private List<TypeSpec.Builder> generateIconsByTag() {
        ArrayList<TypeSpec.Builder> types = new ArrayList<TypeSpec.Builder>();
        Set<String> tags = this.metaIconInfos.stream().map(MetaIconInfo::getTags).flatMap(Collection::stream).collect(Collectors.toSet());
        tags.forEach(tag -> types.addAll(this.generateByTagInterface((String)tag, this.metaIconInfos.stream().filter(metaIconInfo -> metaIconInfo.getTags().contains(tag)).collect(Collectors.toList()))));
        types.addAll(this.generateByTagInterface("", this.metaIconInfos.stream().filter(metaIconInfo -> metaIconInfo.getTags().isEmpty()).collect(Collectors.toList())));
        types.add(this.generateMdiIconsByTagInterface(tags));
        types.add(this.generateAllMdiIconsInterface());
        types.add(this.generateMdiTagsConstants(tags));
        types.add(this.generateMdiByTagFactory(tags));
        types.add(this.generateAllMdiIconsWithMetaInterface());
        return types;
    }

    private TypeSpec.Builder generateMdiByTagFactory(Set<String> tags) {
        ParameterizedTypeName listType = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get(Supplier.class), (TypeName[])new TypeName[]{ClassName.bestGuess((String)MDI_ICON_TYPE)})});
        return MdiIconsSourceWriter.classBuilder("MdiByTagFactory").addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(MethodSpec.methodBuilder((String)"get").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)listType).addParameter(ParameterSpec.builder((TypeName)TypeName.get(String.class), (String)"tag", (Modifier[])new Modifier[0]).build()).addCode(this.switchCodeBuilder(tags).build()).build());
    }

    public static TypeSpec.Builder classBuilder(String name) {
        return TypeSpec.classBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("This is a generated class, please don't modify\n", new Object[0]);
    }

    public static TypeSpec.Builder interfaceBuilder(String name) {
        return TypeSpec.interfaceBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("This is a generated class, please don't modify\n", new Object[0]);
    }

    private CodeBlock.Builder switchCodeBuilder(Set<String> tags) {
        ClassName tagsConstants = ClassName.bestGuess((String)(this.rootPackageName + ".MdiTags"));
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.beginControlFlow("switch(tag)", new Object[0]);
        tags.forEach(tag -> builder.addStatement("case $T.$L : return new $T().icons()", new Object[]{tagsConstants, this.tagToClassName((String)tag).toUpperCase(), ClassName.bestGuess((String)(this.rootPackageName + "." + this.tagToClassName((String)tag) + "_Factory"))}));
        builder.addStatement("case $T.$L : return new $T().icons()", new Object[]{tagsConstants, this.tagToClassName(UNTAGGED).toUpperCase(), ClassName.bestGuess((String)(this.rootPackageName + "." + this.tagToClassName(UNTAGGED) + "_Factory"))});
        builder.addStatement("default : throw new $T(tag)", new Object[]{TypeName.get(IllegalArgumentException.class)});
        builder.endControlFlow();
        return builder;
    }

    private TypeSpec.Builder generateMdiTagsConstants(Set<String> tags) {
        TypeSpec.Builder builder = MdiIconsSourceWriter.interfaceBuilder("MdiTags").addModifiers(new Modifier[]{Modifier.PUBLIC});
        tags.forEach(tag -> builder.addField(FieldSpec.builder((TypeName)TypeName.get(String.class), (String)this.tagToClassName((String)tag).toUpperCase(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{tag}).build()));
        builder.addField(FieldSpec.builder((TypeName)TypeName.get(String.class), (String)UNTAGGED.toUpperCase(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{""}).build());
        builder.addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{TypeName.get(String.class)}), (String)"TAGS", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$T.asList($L)", new Object[]{TypeName.get(Arrays.class), tags.stream().map(tag -> this.tagToClassName((String)tag).toUpperCase()).collect(Collectors.joining(","))}).build());
        return builder;
    }

    private TypeSpec.Builder generateAllMdiIconsInterface() {
        TypeSpec.Builder builder = MdiIconsSourceWriter.classBuilder("Icons").addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.metaIconInfos.forEach(metaIconInfo -> {
            MethodSpec.Builder iconMethod = MethodSpec.methodBuilder((String)this.unreservedKeywordName(metaIconInfo.getName().replace("-", "_"))).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).returns((TypeName)ClassName.bestGuess((String)MDI_ICON_TYPE)).addStatement("return $T.create($S)", new Object[]{ClassName.bestGuess((String)MDI_ICON_TYPE), "mdi-" + metaIconInfo.getName()});
            if (metaIconInfo.isDeprecated()) {
                iconMethod.addAnnotation(Deprecated.class);
            }
            builder.addMethod(iconMethod.build());
        });
        return builder;
    }

    private TypeSpec.Builder generateAllMdiIconsWithMetaInterface() {
        TypeSpec.Builder builder = MdiIconsSourceWriter.classBuilder("IconsMeta").addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.metaIconInfos.forEach(metaIconInfo -> {
            MethodSpec.Builder iconMethod = MethodSpec.methodBuilder((String)this.unreservedKeywordName(metaIconInfo.getName().replace("-", "_"))).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).returns((TypeName)ClassName.bestGuess((String)MDI_ICON_TYPE)).addStatement("return $T.create($S, new $T($S, $S, $T.asList($L), $T.asList($L), $S, $S))", new Object[]{ClassName.bestGuess((String)MDI_ICON_TYPE), "mdi-" + metaIconInfo.getName(), ClassName.bestGuess((String)MDI_META_TYPE), metaIconInfo.getName(), metaIconInfo.getCodepoint(), TypeName.get(Arrays.class), this.getStringLiteral(metaIconInfo.getTags()), TypeName.get(Arrays.class), this.getStringLiteral(metaIconInfo.getAliases()), metaIconInfo.getAuthor(), metaIconInfo.getVersion()});
            if (metaIconInfo.isDeprecated()) {
                iconMethod.addAnnotation(Deprecated.class);
            }
            builder.addMethod(iconMethod.build());
        });
        return builder;
    }

    private TypeSpec.Builder generateMdiIconsByTagInterface(Set<String> tags) {
        TypeSpec.Builder builder = MdiIconsSourceWriter.interfaceBuilder("MdiIconsByTag").addModifiers(new Modifier[]{Modifier.PUBLIC});
        tags.forEach(tag -> builder.addSuperinterface((TypeName)ClassName.bestGuess((String)(this.rootPackageName + "." + this.tagToClassName((String)tag)))));
        builder.addSuperinterface((TypeName)ClassName.bestGuess((String)(this.rootPackageName + ".UnTagged")));
        return builder;
    }

    private List<TypeSpec.Builder> generateByTagInterface(String tag, List<MetaIconInfo> icons) {
        ArrayList<TypeSpec.Builder> types = new ArrayList<TypeSpec.Builder>();
        String typeName = this.tagToClassName(tag);
        if (typeName.isEmpty()) {
            typeName = UNTAGGED;
        }
        TypeSpec.Builder builder = MdiIconsSourceWriter.interfaceBuilder(typeName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        ParameterizedTypeName listType = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get(Supplier.class), (TypeName[])new TypeName[]{ClassName.bestGuess((String)MDI_ICON_TYPE)})});
        CodeBlock.Builder staticInitializer = CodeBlock.builder();
        TypeSpec.Builder factoryBuilder = MdiIconsSourceWriter.classBuilder(typeName + "_Factory").addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ClassName.bestGuess((String)MDI_ICON_FACTORY_TYPE)).addField(FieldSpec.builder((TypeName)listType, (String)"icons", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T()", new Object[]{TypeName.get(ArrayList.class)}).build()).addField(FieldSpec.builder((TypeName)ClassName.bestGuess((String)(this.rootPackageName + "." + typeName)), (String)"tagIcons", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T(){}", new Object[]{ClassName.bestGuess((String)(this.rootPackageName + "." + typeName))}).build());
        icons.forEach(metaIconInfo -> {
            String methodName = this.unreservedKeywordName(metaIconInfo.getName().replace("-", "_") + this.methodPostFix(tag));
            MethodSpec.Builder iconMethod = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.DEFAULT}).returns((TypeName)ClassName.bestGuess((String)MDI_ICON_TYPE)).addStatement("return $T.create($S)", new Object[]{ClassName.bestGuess((String)MDI_ICON_TYPE), "mdi-" + metaIconInfo.getName()});
            if (metaIconInfo.isDeprecated()) {
                iconMethod.addAnnotation(Deprecated.class);
            }
            builder.addMethod(iconMethod.build());
            staticInitializer.addStatement("icons.add(()-> tagIcons." + methodName + "())", new Object[0]);
        });
        factoryBuilder.addStaticBlock(staticInitializer.build()).addMethod(MethodSpec.methodBuilder((String)"icons").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)listType).addStatement("return new $T<>(icons)", new Object[]{TypeName.get(ArrayList.class)}).build());
        types.add(builder);
        types.add(factoryBuilder);
        return types;
    }

    private String methodPostFix(String tag) {
        if (tag.isEmpty()) {
            return "";
        }
        return "_" + this.tagToClassName(tag).toLowerCase();
    }

    private String tagToClassName(String tag) {
        return tag.replace("/", "_").replace("+", "_").replace(" ", "");
    }

    private String getStringLiteral(List<String> stringList) {
        String literal = stringList.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(","));
        return Objects.isNull(literal) || literal.isEmpty() ? "" : literal;
    }

    private String unreservedKeywordName(String str) {
        if (RESERVED_KEYWORDS.contains(str)) {
            return str + "_";
        }
        return str;
    }
}

