/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.InetSocketAddress;
import java.time.Clock;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.drasyl.handler.discovery.AddPathAndSuperPeerEvent;
import org.drasyl.handler.discovery.AddPathEvent;
import org.drasyl.handler.discovery.PathEvent;
import org.drasyl.handler.discovery.PathRttEvent;
import org.drasyl.handler.discovery.RemovePathEvent;
import org.drasyl.handler.discovery.RemoveSuperPeerAndPathEvent;
import org.drasyl.identity.DrasylAddress;
import org.drasyl.util.EvictingQueue;
import org.drasyl.util.NumberUtil;
import org.drasyl.util.Preconditions;
import org.drasyl.util.internal.UnstableApi;

@UnstableApi
public class PeersRttHandler
extends ChannelInboundHandlerAdapter {
    private final long emitEventInterval;
    private final Map<DrasylAddress, PeerRtt> rtts;
    private ScheduledFuture<?> scheduledFuture;

    PeersRttHandler(long emitEventInterval, Map<DrasylAddress, PeerRtt> rtts) {
        this.emitEventInterval = Preconditions.requirePositive((long)emitEventInterval);
        this.rtts = Objects.requireNonNull(rtts);
    }

    public PeersRttHandler(long emitEventInterval) {
        this(emitEventInterval, new HashMap<DrasylAddress, PeerRtt>());
    }

    public PeersRttHandler() {
        this(5000L);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        if (ctx.channel().isActive()) {
            this.scheduleTask(ctx);
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.scheduleTask(ctx);
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
        ctx.fireChannelInactive();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof AddPathAndSuperPeerEvent) {
            DrasylAddress address = ((AddPathAndSuperPeerEvent)evt).getAddress();
            InetSocketAddress inetAddress = ((AddPathAndSuperPeerEvent)evt).getInetAddress();
            long rtt = ((AddPathAndSuperPeerEvent)evt).getRtt();
            PeerRtt peerRtt = new PeerRtt(PeerRtt.Role.SUPER, inetAddress, rtt);
            this.rtts.put(address, peerRtt);
        } else if (evt instanceof AddPathEvent) {
            DrasylAddress address = ((AddPathEvent)evt).getAddress();
            InetSocketAddress inetAddress = ((AddPathEvent)evt).getInetAddress();
            long rtt = ((AddPathEvent)evt).getRtt();
            PeerRtt peerRtt = new PeerRtt(PeerRtt.Role.DEFAULT, inetAddress, rtt);
            this.rtts.put(address, peerRtt);
        } else if (evt instanceof PathRttEvent) {
            DrasylAddress address = ((PathRttEvent)evt).getAddress();
            long rtt = ((PathRttEvent)evt).getRtt();
            PeerRtt peerRtt = this.rtts.get(address);
            if (peerRtt != null) {
                peerRtt.last(rtt);
            }
        } else if (evt instanceof RemoveSuperPeerAndPathEvent || evt instanceof RemovePathEvent) {
            this.rtts.remove(((PathEvent)evt).getAddress());
        }
        ctx.fireUserEventTriggered(evt);
    }

    private void scheduleTask(ChannelHandlerContext ctx) {
        this.scheduledFuture = ctx.executor().scheduleWithFixedDelay(() -> {
            PeersRttReport report = new PeersRttReport(this.rtts);
            ctx.fireUserEventTriggered((Object)report);
        }, 0L, this.emitEventInterval, TimeUnit.MILLISECONDS);
    }

    private static class EntryComparator
    implements Comparator<Map.Entry<DrasylAddress, PeerRtt>> {
        private EntryComparator() {
        }

        @Override
        public int compare(Map.Entry<DrasylAddress, PeerRtt> o1, Map.Entry<DrasylAddress, PeerRtt> o2) {
            return o1.getKey().toString().compareTo(o2.getKey().toString());
        }
    }

    public static class PeerRtt {
        public static final int RTTS_COUNT = 200;
        private final Role role;
        private final InetSocketAddress inetAddress;
        private final Queue<Long> records;
        private long sent;
        private long last;
        private long best;
        private long worst;

        PeerRtt(Role role, InetSocketAddress inetAddress, long rtt) {
            this.role = Objects.requireNonNull(role);
            this.inetAddress = Objects.requireNonNull(inetAddress);
            this.records = new EvictingQueue(200);
            this.records.add(rtt);
            this.sent = 1L;
            this.last = rtt;
            this.best = rtt;
            this.worst = rtt;
        }

        public Role role() {
            return this.role;
        }

        public InetSocketAddress inetAddress() {
            return this.inetAddress;
        }

        public long sent() {
            return this.sent;
        }

        public long last() {
            return this.last;
        }

        void last(long rtt) {
            this.records.add(rtt);
            ++this.sent;
            this.last = rtt;
            if (this.last < this.best) {
                this.best = this.last;
            } else if (this.last > this.worst) {
                this.worst = rtt;
            }
        }

        public double average() {
            return this.records.stream().mapToLong(l -> l).average().getAsDouble();
        }

        public long best() {
            return this.best;
        }

        public long worst() {
            return this.worst;
        }

        public double stDev() {
            return NumberUtil.sampleStandardDeviation((double[])this.records.stream().mapToDouble(d -> d.longValue()).toArray());
        }

        public static enum Role {
            SUPER("S"),
            CHILDREN("C"),
            DEFAULT("");

            private final String label;

            private Role(String label) {
                this.label = Objects.requireNonNull(label);
            }

            public String toString() {
                return this.label;
            }
        }
    }

    public static class PeersRttReport {
        private final long time;
        private final Map<DrasylAddress, PeerRtt> peers;

        PeersRttReport(long time, Map<DrasylAddress, PeerRtt> peers) {
            this.time = Preconditions.requirePositive((long)time);
            this.peers = Objects.requireNonNull(peers);
        }

        public PeersRttReport(Map<DrasylAddress, PeerRtt> peers) {
            this(System.currentTimeMillis(), peers);
        }

        public Map<DrasylAddress, PeerRtt> peers() {
            return this.peers;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.time), Clock.systemDefaultZone().getZone());
            builder.append(String.format("Time: %-35s%98s%n", DateTimeFormatter.RFC_1123_DATE_TIME.format(zonedDateTime), "RTTs"));
            builder.append(String.format("%-64s  %4s  %-45s  %4s  %4s  %4s  %4s  %4s  %5s%n", "Peer", "Role", "Inet Address", "Snt", "Last", " Avg", "Best", "Wrst", "StDev"));
            for (Map.Entry entry : this.peers.entrySet().stream().sorted(new EntryComparator()).collect(Collectors.toList())) {
                DrasylAddress address = (DrasylAddress)entry.getKey();
                PeerRtt peerRtt = (PeerRtt)entry.getValue();
                builder.append(String.format("%-64s  %-4s  %-45s  %4d  %4d  %,4.0f  %4d  %4d  %,5.1f%n", new Object[]{address, peerRtt.role(), peerRtt.inetAddress().getHostString() + ":" + peerRtt.inetAddress().getPort(), peerRtt.sent(), peerRtt.last(), peerRtt.average(), peerRtt.best(), peerRtt.worst(), peerRtt.stDev()}));
            }
            return builder.toString();
        }
    }
}

