/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.arq.gobackn;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.internal.StringUtil;
import java.util.List;
import org.drasyl.handler.arq.gobackn.GoBackNArqAck;
import org.drasyl.handler.arq.gobackn.GoBackNArqData;
import org.drasyl.handler.arq.gobackn.GoBackNArqMessage;
import org.drasyl.util.UnsignedInteger;

public class GoBackNArqCodec
extends MessageToMessageCodec<ByteBuf, GoBackNArqMessage> {
    public static final int MAGIC_NUMBER_DATA = 360023952;
    public static final int MAGIC_NUMBER_ACK = 360023955;
    public static final int MIN_MESSAGE_LENGTH = 8;

    protected void encode(ChannelHandlerContext ctx, GoBackNArqMessage msg, List<Object> out) throws Exception {
        if (msg instanceof GoBackNArqData) {
            ByteBuf buf = ctx.alloc().buffer(8 + ((GoBackNArqData)msg).content().readableBytes());
            buf.writeInt(360023952);
            buf.writeBytes(msg.sequenceNo().toBytes());
            buf.writeBytes(((GoBackNArqData)msg).content());
            out.add(buf);
        } else if (msg instanceof GoBackNArqAck) {
            ByteBuf buf = ctx.alloc().buffer(8);
            buf.writeInt(360023955);
            buf.writeBytes(msg.sequenceNo().toBytes());
            out.add(buf);
        } else {
            throw new EncoderException("Unknown GoBackNArqMessage type: " + StringUtil.simpleClassName((Object)msg));
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() >= 8) {
            in.markReaderIndex();
            int magicNumber = in.readInt();
            UnsignedInteger sequenceNo = UnsignedInteger.of((long)in.readUnsignedInt());
            switch (magicNumber) {
                case 360023952: {
                    out.add(new GoBackNArqData(sequenceNo, in.retain()));
                    break;
                }
                case 360023955: {
                    out.add(new GoBackNArqAck(sequenceNo));
                    break;
                }
                default: {
                    in.resetReaderIndex();
                    out.add(in.retain());
                    break;
                }
            }
        } else {
            out.add(in.retain());
        }
    }
}

