/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.arq.gobackn;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.drasyl.handler.arq.gobackn.GoBackNArqAck;
import org.drasyl.handler.arq.gobackn.GoBackNArqData;
import org.drasyl.util.UnsignedInteger;
import org.drasyl.util.logging.Logger;
import org.drasyl.util.logging.LoggerFactory;

public class GoBackNArqReceiverHandler
extends ChannelDuplexHandler {
    private static final Logger LOG = LoggerFactory.getLogger(GoBackNArqReceiverHandler.class);
    private UnsignedInteger nextSequenceNo;
    private final Duration ackClock;
    private ScheduledFuture<?> ackTask;
    private boolean ackRequired;

    public GoBackNArqReceiverHandler(UnsignedInteger nextSequenceNo, Duration ackClock) {
        this.nextSequenceNo = nextSequenceNo;
        this.ackClock = ackClock;
    }

    public GoBackNArqReceiverHandler(Duration ackClock) {
        this(UnsignedInteger.MIN_VALUE, ackClock);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelActive();
        this.ackTask(ctx);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        if (ctx.channel().isActive()) {
            this.ackTask(ctx);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        ctx.fireChannelInactive();
        this.stopAckTask();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof GoBackNArqData) {
            GoBackNArqData data = (GoBackNArqData)msg;
            this.ackRequired = true;
            if (!data.sequenceNo().equals((Object)this.nextSequenceNo)) {
                Supplier[] supplierArray = new Supplier[3];
                supplierArray[0] = () -> ((ChannelId)ctx.channel().id()).asShortText();
                supplierArray[1] = () -> data;
                supplierArray[2] = () -> this.nextSequenceNo;
                LOG.trace("[{}] Got unexpected data {}. Expected {}. Drop it.", supplierArray);
                data.release();
            } else {
                LOG.trace("[{}] Got expected {}. Pass through.", () -> ((ChannelId)ctx.channel().id()).asShortText(), () -> data);
                this.nextSequenceNo = this.nextSequenceNo.safeIncrement();
                ctx.fireChannelRead(msg);
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private void ackTask(ChannelHandlerContext ctx) {
        if (this.ackRequired) {
            this.ackRequired = false;
            ctx.writeAndFlush((Object)new GoBackNArqAck(this.nextSequenceNo.safeDecrement()));
        }
        this.ackTask = ctx.executor().schedule(() -> this.ackTask(ctx), this.ackClock.toMillis(), TimeUnit.MILLISECONDS);
    }

    private void stopAckTask() {
        if (this.ackTask != null) {
            this.ackTask.cancel(true);
        }
    }
}

