/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import org.drasyl.util.Preconditions;

public class MaxLengthFrameEncoder
extends MessageToMessageEncoder<ByteBuf> {
    private final int maxFrameLength;

    public MaxLengthFrameEncoder(int maxFrameLength) {
        this.maxFrameLength = Preconditions.requirePositive((int)maxFrameLength);
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        while (in.readableBytes() > 0) {
            out.add(in.readRetainedSlice(Math.min(in.readableBytes(), this.maxFrameLength)));
        }
    }
}

