/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.connection;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.List;
import org.drasyl.handler.connection.ConnectionHandshakeSegment;

@ChannelHandler.Sharable
public class ConnectionHandshakeCodec
extends MessageToMessageCodec<ByteBuf, ConnectionHandshakeSegment> {
    public static final int MAGIC_NUMBER = 852550535;
    public static final int MIN_MESSAGE_LENGTH = 13;

    protected void encode(ChannelHandlerContext ctx, ConnectionHandshakeSegment seg, List<Object> out) throws Exception {
        ByteBuf buf = ctx.alloc().buffer(13 + seg.content().readableBytes());
        buf.writeInt(852550535);
        buf.writeInt((int)seg.seq());
        buf.writeInt((int)seg.ack());
        buf.writeByte(seg.ctl());
        buf.writeBytes(seg.content());
        out.add(buf);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (in.readableBytes() >= 13) {
            in.markReaderIndex();
            if (852550535 == in.readInt()) {
                long seq = in.readUnsignedInt();
                long ack = in.readUnsignedInt();
                byte ctl = in.readByte();
                ConnectionHandshakeSegment seg = new ConnectionHandshakeSegment(seq, ack, ctl, in.discardSomeReadBytes().retain());
                out.add((Object)seg);
            } else {
                in.resetReaderIndex();
                out.add(in.retain());
            }
        } else {
            out.add(in.retain());
        }
    }
}

