/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.dht.chord;

import java.util.Objects;
import java.util.function.Supplier;
import org.drasyl.handler.dht.chord.ChordUtil;
import org.drasyl.identity.DrasylAddress;
import org.drasyl.util.logging.Logger;
import org.drasyl.util.logging.LoggerFactory;

public class ChordFingerTable {
    private static final Logger LOG = LoggerFactory.getLogger(ChordFingerTable.class);
    protected final DrasylAddress[] entries = new DrasylAddress[32];
    private final DrasylAddress localAddress;

    public ChordFingerTable(DrasylAddress localAddress) {
        this.localAddress = Objects.requireNonNull(localAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%-4s %-15s %-65s %-15s%n", "No.", "Start", "Address", "Id"));
        for (int i = 1; i <= this.entries.length; ++i) {
            long ithStart = ChordUtil.ithFingerStart(this.localAddress, i);
            sb.append(String.format("%2s   %-15s %-65s %-15s%n", i, ChordUtil.chordIdHex(ithStart) + " (" + ChordUtil.chordIdPosition(ithStart) + ")", this.entries[i - 1], this.entries[i - 1] != null ? ChordUtil.chordIdHex(this.entries[i - 1]) + " (" + ChordUtil.chordIdPosition(this.entries[i - 1]) + ")" : ""));
        }
        return sb.toString();
    }

    public DrasylAddress get(int i) {
        return this.entries[i - 1];
    }

    public DrasylAddress getSuccessor() {
        return this.get(1);
    }

    public boolean hasSuccessor() {
        return this.getSuccessor() != null;
    }

    public void removePeer(DrasylAddress value) {
        LOG.info("Remove peer `{}` from finger table.", (Object)value);
        for (int i = 32; i > 0; --i) {
            DrasylAddress ithFinger = this.entries[i - 1];
            if (ithFinger == null || !ithFinger.equals(value)) continue;
            this.entries[i - 1] = null;
        }
    }

    public boolean updateIthFinger(int i, DrasylAddress value) {
        boolean changed;
        DrasylAddress oldValue = this.entries[i - 1];
        this.entries[i - 1] = value;
        boolean bl = changed = !Objects.equals(value, oldValue);
        if (changed) {
            LOG.info("Updated {}th finger to `{}` ({} -> {} -> {}).", new Supplier[]{() -> String.format("%2s", i), () -> value, () -> oldValue != null ? String.format("%4s", ChordUtil.chordIdPosition(oldValue)) : "null", () -> value != null ? String.format("%4s", ChordUtil.chordIdPosition(value)) : "null", () -> String.format("%4s", ChordUtil.chordIdPosition(ChordUtil.ithFingerStart(this.localAddress, i)))});
        }
        return i == 1 && value != null && !value.equals(this.localAddress) && changed;
    }
}

