/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.dht.chord;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Objects;
import org.drasyl.handler.dht.chord.ChordUtil;
import org.drasyl.handler.dht.chord.LocalChordNode;
import org.drasyl.identity.DrasylAddress;
import org.drasyl.util.logging.Logger;
import org.drasyl.util.logging.LoggerFactory;

public class ChordJoinHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ChordJoinHandler.class);
    private final DrasylAddress contact;
    private final LocalChordNode localNode;
    private Future<Void> joinFuture;

    public ChordJoinHandler(DrasylAddress contact, LocalChordNode localNode) {
        this.contact = Objects.requireNonNull(contact);
        this.localNode = Objects.requireNonNull(localNode);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        if (ctx.channel().isActive()) {
            this.doJoin(ctx);
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.cancelJoin();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.doJoin(ctx);
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.cancelJoin();
        ctx.fireChannelInactive();
    }

    private void doJoin(ChannelHandlerContext ctx) {
        LOG.debug("Try to join Chord circle by asking `{}` to find the successor for my id `{}`.", (Object)this.contact, (Object)ChordUtil.chordIdHex(ctx.channel().localAddress()));
        this.joinFuture = this.localNode.join(this.contact).addListener((GenericFutureListener)((FutureListener)future -> {
            if (future.isSuccess()) {
                LOG.debug("Joined Chord circle.");
                ctx.pipeline().remove(ctx.name());
            } else {
                LOG.error("Failed to join Chord circle `{}`:", (Object)this.contact, (Object)future.cause());
                ctx.pipeline().fireExceptionCaught(future.cause());
                ctx.pipeline().close();
            }
        }));
    }

    private void cancelJoin() {
        if (this.joinFuture != null) {
            this.joinFuture.cancel(false);
            this.joinFuture = null;
        }
    }
}

