/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.membership.cyclon;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.internal.StringUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.drasyl.channel.OverlayAddressedMessage;
import org.drasyl.handler.membership.cyclon.CyclonMessage;
import org.drasyl.handler.membership.cyclon.CyclonNeighbor;
import org.drasyl.handler.membership.cyclon.CyclonShuffleRequest;
import org.drasyl.handler.membership.cyclon.CyclonShuffleResponse;
import org.drasyl.identity.DrasylAddress;
import org.drasyl.identity.IdentityPublicKey;

@ChannelHandler.Sharable
public class CyclonCodec
extends MessageToMessageCodec<OverlayAddressedMessage<ByteBuf>, OverlayAddressedMessage<CyclonMessage>> {
    public static final int MAGIC_NUMBER_REQUEST = -85766231;
    public static final int MAGIC_NUMBER_RESPONSE = -85766230;
    public static final int MIN_MESSAGE_LENGTH = 4;

    protected void encode(ChannelHandlerContext ctx, OverlayAddressedMessage<CyclonMessage> msg, List<Object> out) throws Exception {
        if (msg.content() instanceof CyclonShuffleRequest) {
            ByteBuf buf = ctx.alloc().buffer();
            buf.writeInt(-85766231);
            CyclonCodec.encodeNeighbors(buf, ((CyclonMessage)msg.content()).getNeighbors());
            out.add(msg.replace((Object)buf));
        } else if (msg.content() instanceof CyclonShuffleResponse) {
            ByteBuf buf = ctx.alloc().buffer();
            buf.writeInt(-85766230);
            CyclonCodec.encodeNeighbors(buf, ((CyclonMessage)msg.content()).getNeighbors());
            out.add(msg.replace((Object)buf));
        } else {
            throw new EncoderException("Unknown CyclonMessage type: " + StringUtil.simpleClassName(msg));
        }
    }

    protected void decode(ChannelHandlerContext ctx, OverlayAddressedMessage<ByteBuf> msg, List<Object> out) throws Exception {
        if (((ByteBuf)msg.content()).readableBytes() >= 4) {
            ((ByteBuf)msg.content()).markReaderIndex();
            int magicNumber = ((ByteBuf)msg.content()).readInt();
            switch (magicNumber) {
                case -85766231: {
                    Set<CyclonNeighbor> neighbors = CyclonCodec.decodeNeighbors((ByteBuf)msg.content());
                    out.add(msg.replace((Object)CyclonShuffleRequest.of(neighbors)));
                    break;
                }
                case -85766230: {
                    Set<CyclonNeighbor> neighbors = CyclonCodec.decodeNeighbors((ByteBuf)msg.content());
                    out.add(msg.replace((Object)CyclonShuffleResponse.of(neighbors)));
                    break;
                }
                default: {
                    ((ByteBuf)msg.content()).resetReaderIndex();
                    out.add(msg.retain());
                    break;
                }
            }
        } else {
            out.add(msg.retain());
        }
    }

    private static void encodeNeighbors(ByteBuf buf, Set<CyclonNeighbor> neighbors) {
        for (CyclonNeighbor neighbor : neighbors) {
            buf.writeBytes(neighbor.getAddress().toByteArray());
            buf.writeShort(neighbor.getAge());
        }
    }

    private static Set<CyclonNeighbor> decodeNeighbors(ByteBuf buf) {
        HashSet<CyclonNeighbor> neighbors = new HashSet<CyclonNeighbor>();
        while (buf.isReadable()) {
            byte[] addressBytes = new byte[32];
            buf.readBytes(addressBytes);
            IdentityPublicKey address = IdentityPublicKey.of((byte[])addressBytes);
            int age = buf.readUnsignedShort();
            CyclonNeighbor neighbor = CyclonNeighbor.of((DrasylAddress)address, age);
            neighbors.add(neighbor);
        }
        return neighbors;
    }
}

