/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.membership.cyclon;

import java.util.Objects;
import org.drasyl.identity.DrasylAddress;
import org.drasyl.util.Preconditions;

public final class CyclonNeighbor
implements Comparable<CyclonNeighbor> {
    private final DrasylAddress address;
    private int age;

    private CyclonNeighbor(DrasylAddress address, int age) {
        this.address = Objects.requireNonNull(address);
        this.age = Preconditions.requireNonNegative((int)age);
    }

    public DrasylAddress getAddress() {
        return this.address;
    }

    public int getAge() {
        return this.age;
    }

    public void increaseAgeByOne() {
        ++this.age;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CyclonNeighbor neighbor = (CyclonNeighbor)o;
        return this.address.equals(neighbor.address);
    }

    public int hashCode() {
        return Objects.hash(this.address);
    }

    public String toString() {
        return "CyclonNeighbor{address=" + this.address + ", age=" + this.age + "}";
    }

    @Override
    public int compareTo(CyclonNeighbor o) {
        return Integer.compare(this.age, o.age);
    }

    public static CyclonNeighbor of(DrasylAddress address, int age) {
        return new CyclonNeighbor(address, age);
    }

    public static CyclonNeighbor of(DrasylAddress address) {
        return CyclonNeighbor.of(address, 0);
    }
}

