/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.membership.cyclon;

import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.drasyl.channel.OverlayAddressedMessage;
import org.drasyl.handler.membership.cyclon.CyclonNeighbor;
import org.drasyl.handler.membership.cyclon.CyclonShuffleRequest;
import org.drasyl.handler.membership.cyclon.CyclonShuffleResponse;
import org.drasyl.handler.membership.cyclon.CyclonView;
import org.drasyl.identity.DrasylAddress;
import org.drasyl.util.Pair;
import org.drasyl.util.Preconditions;
import org.drasyl.util.RandomUtil;

public class CyclonShufflingClientHandler
extends SimpleChannelInboundHandler<AddressedEnvelope<CyclonShuffleResponse, SocketAddress>> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(CyclonShufflingClientHandler.class);
    private final int shuffleSize;
    private final int shuffleInterval;
    private final CyclonView view;
    private OverlayAddressedMessage<CyclonShuffleRequest> shuffleRequest;
    private Future<?> shuffleTask;

    CyclonShufflingClientHandler(int shuffleSize, int shuffleInterval, CyclonView view, OverlayAddressedMessage<CyclonShuffleRequest> shuffleRequest) {
        this.shuffleSize = Preconditions.requirePositive((int)shuffleSize);
        this.shuffleInterval = Preconditions.requirePositive((int)shuffleInterval);
        this.view = Objects.requireNonNull(view);
        this.shuffleRequest = shuffleRequest;
    }

    public CyclonShufflingClientHandler(int shuffleSize, int shuffleInterval, CyclonView view) {
        this(shuffleSize, shuffleInterval, view, null);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        if (ctx.channel().isActive()) {
            this.shuffleTask = ctx.executor().scheduleWithFixedDelay(() -> this.initiateShuffle(ctx), RandomUtil.randomLong((long)this.shuffleInterval), (long)this.shuffleInterval, TimeUnit.MILLISECONDS);
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.stopShuffling();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.executor().scheduleAtFixedRate(() -> this.initiateShuffle(ctx), RandomUtil.randomLong((long)this.shuffleInterval), (long)this.shuffleInterval, TimeUnit.MILLISECONDS);
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.stopShuffling();
        ctx.fireChannelInactive();
    }

    public boolean acceptInboundMessage(Object msg) {
        return msg instanceof AddressedEnvelope && ((AddressedEnvelope)msg).content() instanceof CyclonShuffleResponse && this.shuffleRequest != null && ((AddressedEnvelope)msg).sender().equals(this.shuffleRequest.recipient());
    }

    protected void channelRead0(ChannelHandlerContext ctx, AddressedEnvelope<CyclonShuffleResponse, SocketAddress> msg) {
        this.handleShuffleResponse(ctx, msg);
    }

    void initiateShuffle(ChannelHandlerContext ctx) {
        logger.trace("Start Shuffling...");
        if (this.shuffleRequest != null) {
            logger.debug("Shuffle request timed out.");
            this.shuffleRequest = null;
        }
        if (this.view.isEmpty()) {
            logger.debug("My view is empty. Nothing to do!");
            return;
        }
        logger.trace("Current neighbors: {}", (Object)this.view);
        logger.trace("Increase by one the age of all neighbors.");
        this.view.increaseAgeByOne();
        logger.trace("Select neighbor Q with the highest age among all neighbors, and \u2113 \u2212 1 other random neighbors.");
        Pair<CyclonNeighbor, Set<CyclonNeighbor>> result = this.view.highestAgeAndOtherRandomNeighbors(this.shuffleSize - 1);
        CyclonNeighbor q = (CyclonNeighbor)result.first();
        Set otherRandomNeighbors = (Set)result.second();
        logger.trace("Q = {}; other random neighbors = {}", (Object)q, (Object)otherRandomNeighbors);
        HashSet<CyclonNeighbor> neighborsSubset = new HashSet<CyclonNeighbor>(otherRandomNeighbors);
        logger.trace("Replace Q\u2019s entry with a new entry of age 0 and with P\u2019s address.");
        this.view.remove(q);
        neighborsSubset.add(CyclonNeighbor.of((DrasylAddress)ctx.channel().localAddress()));
        logger.trace("updated subset = {}", neighborsSubset);
        logger.trace("Send the updated subset to peer Q.");
        this.shuffleRequest = new OverlayAddressedMessage((Object)CyclonShuffleRequest.of(neighborsSubset), q.getAddress(), null);
        logger.debug("Send following shuffle request to `{}`:\n{}", (Object)this.shuffleRequest.recipient(), this.shuffleRequest.content());
        ctx.writeAndFlush(this.shuffleRequest).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.cause() != null) {
                logger.warn("Unable to send the following shuffle request to `{}`:\n{}", new Object[]{this.shuffleRequest.recipient(), this.shuffleRequest.content(), future.cause()});
            }
        }));
    }

    private void stopShuffling() {
        if (this.shuffleTask != null) {
            this.shuffleTask.cancel(false);
            this.shuffleTask = null;
        }
    }

    private void handleShuffleResponse(ChannelHandlerContext ctx, AddressedEnvelope<CyclonShuffleResponse, SocketAddress> msg) {
        logger.debug("Received following shuffle response from `{}`:\n{}", (Object)msg.sender(), msg.content());
        logger.trace("Current neighbors: {}", (Object)this.view);
        HashSet<CyclonNeighbor> receivedNeighbors = new HashSet<CyclonNeighbor>(((CyclonShuffleResponse)msg.content()).getNeighbors());
        receivedNeighbors.remove(CyclonNeighbor.of((DrasylAddress)ctx.channel().localAddress()));
        receivedNeighbors.removeAll(this.view.getNeighbors());
        this.view.update(receivedNeighbors, ((CyclonShuffleRequest)this.shuffleRequest.content()).getNeighbors());
        logger.debug("Successfully merged! New view is:\n{}", (Object)this.view);
        this.shuffleRequest = null;
    }
}

