/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.membership.cyclon;

import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.drasyl.channel.OverlayAddressedMessage;
import org.drasyl.handler.membership.cyclon.CyclonNeighbor;
import org.drasyl.handler.membership.cyclon.CyclonShuffleRequest;
import org.drasyl.handler.membership.cyclon.CyclonShuffleResponse;
import org.drasyl.handler.membership.cyclon.CyclonView;
import org.drasyl.identity.DrasylAddress;
import org.drasyl.util.Preconditions;

public class CyclonShufflingServerHandler
extends SimpleChannelInboundHandler<OverlayAddressedMessage<CyclonShuffleRequest>> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(CyclonShufflingServerHandler.class);
    private final int shuffleSize;
    private final CyclonView view;
    private final Function<ChannelHandlerContext, DrasylAddress> localAddressProvider;

    CyclonShufflingServerHandler(int shuffleSize, CyclonView view, Function<ChannelHandlerContext, DrasylAddress> localAddressProvider) {
        this.shuffleSize = Preconditions.requirePositive((int)shuffleSize);
        this.view = Objects.requireNonNull(view);
        this.localAddressProvider = Objects.requireNonNull(localAddressProvider);
    }

    public CyclonShufflingServerHandler(int shuffleSize, CyclonView view) {
        this(shuffleSize, view, ctx -> (DrasylAddress)ctx.channel().localAddress());
    }

    public boolean acceptInboundMessage(Object msg) {
        return msg instanceof AddressedEnvelope && ((AddressedEnvelope)msg).content() instanceof CyclonShuffleRequest;
    }

    protected void channelRead0(ChannelHandlerContext ctx, OverlayAddressedMessage<CyclonShuffleRequest> msg) {
        this.handleShuffleRequest(ctx, msg);
    }

    private void handleShuffleRequest(ChannelHandlerContext ctx, OverlayAddressedMessage<CyclonShuffleRequest> request) {
        logger.debug("Received following shuffle request from `{}`:\n{}", (Object)request.sender(), request.content());
        logger.trace("Current neighbors: {}", (Object)this.view);
        Set<CyclonNeighbor> randomNeighbors = this.view.randomNeighbors(this.shuffleSize);
        logger.trace("Random neighbors: {}", randomNeighbors);
        randomNeighbors.remove(CyclonNeighbor.of((DrasylAddress)request.sender()));
        OverlayAddressedMessage response = new OverlayAddressedMessage((Object)CyclonShuffleResponse.of(randomNeighbors), (DrasylAddress)request.sender(), null);
        logger.debug("Send following shuffle response to `{}`:\n{}", (Object)response.recipient(), response.content());
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.cause() != null) {
                logger.warn("Unable to send the following shuffle response to `{}`:\n{}", new Object[]{response.recipient(), response.content(), future.cause()});
            }
        }));
        HashSet<CyclonNeighbor> receivedNeighbors = new HashSet<CyclonNeighbor>(((CyclonShuffleRequest)request.content()).getNeighbors());
        receivedNeighbors.remove(CyclonNeighbor.of(this.localAddressProvider.apply(ctx)));
        receivedNeighbors.removeAll(this.view.getNeighbors());
        this.view.update(receivedNeighbors, randomNeighbors);
        logger.debug("Successfully merged! New view is:\n{}", (Object)this.view);
    }
}

