/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.pubsub;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.internal.StringUtil;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import org.drasyl.channel.OverlayAddressedMessage;
import org.drasyl.handler.pubsub.PubSubMessage;
import org.drasyl.handler.pubsub.PubSubPublish;
import org.drasyl.handler.pubsub.PubSubPublished;
import org.drasyl.handler.pubsub.PubSubSubscribe;
import org.drasyl.handler.pubsub.PubSubSubscribed;
import org.drasyl.handler.pubsub.PubSubUnsubscribe;
import org.drasyl.handler.pubsub.PubSubUnsubscribed;
import org.drasyl.identity.DrasylAddress;

@ChannelHandler.Sharable
public class PubSubCodec
extends MessageToMessageCodec<OverlayAddressedMessage<ByteBuf>, OverlayAddressedMessage<PubSubMessage>> {
    static final int MAGIC_NUMBER_PUBLISH = -616382829;
    static final int MAGIC_NUMBER_PUBLISHED = -616382828;
    static final int MAGIC_NUMBER_SUBSCRIBE = -616382827;
    static final int MAGIC_NUMBER_SUBSCRIBED = -616382826;
    static final int MAGIC_NUMBER_UNSUBSCRIBE = -616382825;
    static final int MAGIC_NUMBER_UNSUBSCRIBED = -616382824;
    public static final int MIN_MESSAGE_LENGTH = 20;

    public boolean acceptOutboundMessage(Object msg) {
        return msg instanceof OverlayAddressedMessage && ((OverlayAddressedMessage)msg).content() instanceof PubSubMessage;
    }

    protected void encode(ChannelHandlerContext ctx, OverlayAddressedMessage<PubSubMessage> msg, List<Object> out) throws Exception {
        if (msg.content() instanceof PubSubPublish) {
            ByteBuf buf = ctx.alloc().buffer();
            buf.writeInt(-616382829);
            buf.writeLong(((PubSubMessage)msg.content()).getId().getMostSignificantBits());
            buf.writeLong(((PubSubMessage)msg.content()).getId().getLeastSignificantBits());
            String topic = ((PubSubPublish)msg.content()).getTopic();
            buf.writeInt(topic.length());
            buf.writeCharSequence((CharSequence)topic, StandardCharsets.UTF_8);
            buf.writeBytes(((PubSubPublish)msg.content()).getContent());
            out.add(new OverlayAddressedMessage((Object)buf, (DrasylAddress)msg.recipient(), (DrasylAddress)msg.sender()));
        } else if (msg.content() instanceof PubSubPublished) {
            ByteBuf buf = ctx.alloc().buffer();
            buf.writeInt(-616382828);
            buf.writeLong(((PubSubMessage)msg.content()).getId().getMostSignificantBits());
            buf.writeLong(((PubSubMessage)msg.content()).getId().getLeastSignificantBits());
            out.add(new OverlayAddressedMessage((Object)buf, (DrasylAddress)msg.recipient(), (DrasylAddress)msg.sender()));
        } else if (msg.content() instanceof PubSubSubscribe) {
            ByteBuf buf = ctx.alloc().buffer();
            buf.writeInt(-616382827);
            buf.writeLong(((PubSubMessage)msg.content()).getId().getMostSignificantBits());
            buf.writeLong(((PubSubMessage)msg.content()).getId().getLeastSignificantBits());
            buf.writeCharSequence((CharSequence)((PubSubSubscribe)msg.content()).getTopic(), StandardCharsets.UTF_8);
            out.add(new OverlayAddressedMessage((Object)buf, (DrasylAddress)msg.recipient(), (DrasylAddress)msg.sender()));
        } else if (msg.content() instanceof PubSubSubscribed) {
            ByteBuf buf = ctx.alloc().buffer();
            buf.writeInt(-616382826);
            buf.writeLong(((PubSubMessage)msg.content()).getId().getMostSignificantBits());
            buf.writeLong(((PubSubMessage)msg.content()).getId().getLeastSignificantBits());
            out.add(new OverlayAddressedMessage((Object)buf, (DrasylAddress)msg.recipient(), (DrasylAddress)msg.sender()));
        } else if (msg.content() instanceof PubSubUnsubscribe) {
            ByteBuf buf = ctx.alloc().buffer();
            buf.writeInt(-616382825);
            buf.writeLong(((PubSubMessage)msg.content()).getId().getMostSignificantBits());
            buf.writeLong(((PubSubMessage)msg.content()).getId().getLeastSignificantBits());
            buf.writeCharSequence((CharSequence)((PubSubUnsubscribe)msg.content()).getTopic(), StandardCharsets.UTF_8);
            out.add(new OverlayAddressedMessage((Object)buf, (DrasylAddress)msg.recipient(), (DrasylAddress)msg.sender()));
        } else if (msg.content() instanceof PubSubUnsubscribed) {
            ByteBuf buf = ctx.alloc().buffer();
            buf.writeInt(-616382824);
            buf.writeLong(((PubSubMessage)msg.content()).getId().getMostSignificantBits());
            buf.writeLong(((PubSubMessage)msg.content()).getId().getLeastSignificantBits());
            out.add(new OverlayAddressedMessage((Object)buf, (DrasylAddress)msg.recipient(), (DrasylAddress)msg.sender()));
        } else {
            throw new EncoderException("Unknown PubSubMessage type: " + StringUtil.simpleClassName((Object)msg.content()));
        }
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return msg instanceof OverlayAddressedMessage && ((OverlayAddressedMessage)msg).content() instanceof ByteBuf;
    }

    protected void decode(ChannelHandlerContext ctx, OverlayAddressedMessage<ByteBuf> msg, List<Object> out) throws Exception {
        if (((ByteBuf)msg.content()).readableBytes() >= 20) {
            ((ByteBuf)msg.content()).markReaderIndex();
            int magicNumber = ((ByteBuf)msg.content()).readInt();
            switch (magicNumber) {
                case -616382829: {
                    UUID id = new UUID(((ByteBuf)msg.content()).readLong(), ((ByteBuf)msg.content()).readLong());
                    String topic = ((ByteBuf)msg.content()).readCharSequence(((ByteBuf)msg.content()).readInt(), StandardCharsets.UTF_8).toString();
                    ByteBuf content = ((ByteBuf)msg.content()).retain();
                    out.add(new OverlayAddressedMessage((Object)PubSubPublish.of(id, topic, content), (DrasylAddress)msg.recipient(), (DrasylAddress)msg.sender()));
                    break;
                }
                case -616382828: {
                    UUID id = new UUID(((ByteBuf)msg.content()).readLong(), ((ByteBuf)msg.content()).readLong());
                    out.add(new OverlayAddressedMessage((Object)PubSubPublished.of(id), (DrasylAddress)msg.recipient(), (DrasylAddress)msg.sender()));
                    break;
                }
                case -616382827: {
                    UUID id = new UUID(((ByteBuf)msg.content()).readLong(), ((ByteBuf)msg.content()).readLong());
                    String topic = ((ByteBuf)msg.content()).readCharSequence(((ByteBuf)msg.content()).readableBytes(), StandardCharsets.UTF_8).toString();
                    out.add(new OverlayAddressedMessage((Object)PubSubSubscribe.of(id, topic), (DrasylAddress)msg.recipient(), (DrasylAddress)msg.sender()));
                    break;
                }
                case -616382826: {
                    UUID id = new UUID(((ByteBuf)msg.content()).readLong(), ((ByteBuf)msg.content()).readLong());
                    out.add(new OverlayAddressedMessage((Object)PubSubSubscribed.of(id), (DrasylAddress)msg.recipient(), (DrasylAddress)msg.sender()));
                    break;
                }
                case -616382825: {
                    UUID id = new UUID(((ByteBuf)msg.content()).readLong(), ((ByteBuf)msg.content()).readLong());
                    String topic = ((ByteBuf)msg.content()).readCharSequence(((ByteBuf)msg.content()).readableBytes(), StandardCharsets.UTF_8).toString();
                    out.add(new OverlayAddressedMessage((Object)PubSubUnsubscribe.of(id, topic), (DrasylAddress)msg.recipient(), (DrasylAddress)msg.sender()));
                    break;
                }
                case -616382824: {
                    UUID id = new UUID(((ByteBuf)msg.content()).readLong(), ((ByteBuf)msg.content()).readLong());
                    out.add(new OverlayAddressedMessage((Object)PubSubUnsubscribed.of(id), (DrasylAddress)msg.recipient(), (DrasylAddress)msg.sender()));
                    break;
                }
                default: {
                    ((ByteBuf)msg.content()).resetReaderIndex();
                    out.add(msg.retain());
                    break;
                }
            }
        } else {
            out.add(msg.retain());
        }
    }
}

