/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.pubsub;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.DefaultByteBufHolder;
import java.util.Objects;
import java.util.UUID;
import org.drasyl.handler.pubsub.PubSubMessage;

public final class PubSubPublish
extends DefaultByteBufHolder
implements PubSubMessage {
    private final UUID id;
    private final String topic;

    private PubSubPublish(UUID id, String topic, ByteBuf content) {
        super(content);
        this.id = Objects.requireNonNull(id);
        this.topic = Objects.requireNonNull(topic);
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public String getTopic() {
        return this.topic;
    }

    public ByteBuf getContent() {
        return this.content();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PubSubPublish that = (PubSubPublish)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.topic, that.topic);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.id, this.topic);
    }

    static PubSubPublish of(UUID id, String topic, ByteBuf content) {
        return new PubSubPublish(id, topic, content);
    }

    public static PubSubPublish of(String topic, ByteBuf content) {
        return PubSubPublish.of(UUID.randomUUID(), topic, content);
    }
}

