/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.rmi;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.internal.StringUtil;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import org.drasyl.handler.rmi.message.RmiCancel;
import org.drasyl.handler.rmi.message.RmiError;
import org.drasyl.handler.rmi.message.RmiMessage;
import org.drasyl.handler.rmi.message.RmiRequest;
import org.drasyl.handler.rmi.message.RmiResponse;

@ChannelHandler.Sharable
public class RmiCodec
extends MessageToMessageCodec<AddressedEnvelope<ByteBuf, SocketAddress>, AddressedEnvelope<RmiMessage, SocketAddress>> {
    public static final int MAGIC_NUMBER_REQUEST = -760063585;
    public static final int MAGIC_NUMBER_RESPONSE = -760063584;
    public static final int MAGIC_NUMBER_ERROR = -760063583;
    public static final int MAGIC_NUMBER_CANCEL = -760063582;
    public static final int MIN_MESSAGE_LENGTH = 20;

    public boolean acceptOutboundMessage(Object msg) {
        return msg instanceof AddressedEnvelope && ((AddressedEnvelope)msg).content() instanceof RmiMessage;
    }

    protected void encode(ChannelHandlerContext ctx, AddressedEnvelope<RmiMessage, SocketAddress> msg, List<Object> out) throws Exception {
        if (msg.content() instanceof RmiRequest) {
            ByteBuf buf = ctx.alloc().buffer();
            buf.writeInt(-760063585);
            buf.writeLong(((RmiRequest)msg.content()).getId().getMostSignificantBits());
            buf.writeLong(((RmiRequest)msg.content()).getId().getLeastSignificantBits());
            buf.writeInt(((RmiRequest)msg.content()).getName());
            buf.writeInt(((RmiRequest)msg.content()).getMethod());
            buf.writeBytes(((RmiRequest)msg.content()).getArguments());
            out.add(new DefaultAddressedEnvelope((Object)buf, msg.recipient(), msg.sender()));
        } else if (msg.content() instanceof RmiResponse) {
            ByteBuf buf = ctx.alloc().buffer();
            buf.writeInt(-760063584);
            buf.writeLong(((RmiResponse)msg.content()).getId().getMostSignificantBits());
            buf.writeLong(((RmiResponse)msg.content()).getId().getLeastSignificantBits());
            buf.writeBytes(((RmiResponse)msg.content()).getResult());
            out.add(new DefaultAddressedEnvelope((Object)buf, msg.recipient(), msg.sender()));
        } else if (msg.content() instanceof RmiError) {
            ByteBuf buf = ctx.alloc().buffer();
            buf.writeInt(-760063583);
            buf.writeLong(((RmiError)msg.content()).getId().getMostSignificantBits());
            buf.writeLong(((RmiError)msg.content()).getId().getLeastSignificantBits());
            buf.writeCharSequence((CharSequence)((RmiError)msg.content()).getMessage(), StandardCharsets.UTF_8);
            out.add(new DefaultAddressedEnvelope((Object)buf, msg.recipient(), msg.sender()));
        } else if (msg.content() instanceof RmiCancel) {
            ByteBuf buf = ctx.alloc().buffer();
            buf.writeInt(-760063582);
            buf.writeLong(((RmiCancel)msg.content()).getId().getMostSignificantBits());
            buf.writeLong(((RmiCancel)msg.content()).getId().getLeastSignificantBits());
            out.add(new DefaultAddressedEnvelope((Object)buf, msg.recipient(), msg.sender()));
        } else {
            throw new EncoderException("Unknown RmiMessage type: " + StringUtil.simpleClassName((Object)msg.content()));
        }
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return msg instanceof AddressedEnvelope && ((AddressedEnvelope)msg).content() instanceof ByteBuf;
    }

    protected void decode(ChannelHandlerContext ctx, AddressedEnvelope<ByteBuf, SocketAddress> msg, List<Object> out) throws Exception {
        if (((ByteBuf)msg.content()).readableBytes() >= 20) {
            ((ByteBuf)msg.content()).markReaderIndex();
            int magicNumber = ((ByteBuf)msg.content()).readInt();
            switch (magicNumber) {
                case -760063585: {
                    UUID id = new UUID(((ByteBuf)msg.content()).readLong(), ((ByteBuf)msg.content()).readLong());
                    int name = ((ByteBuf)msg.content()).readInt();
                    int method = ((ByteBuf)msg.content()).readInt();
                    ByteBuf parameters = ((ByteBuf)msg.content()).retain();
                    out.add(new DefaultAddressedEnvelope((Object)RmiRequest.of(id, name, method, parameters), msg.recipient(), msg.sender()));
                    break;
                }
                case -760063584: {
                    UUID id = new UUID(((ByteBuf)msg.content()).readLong(), ((ByteBuf)msg.content()).readLong());
                    ByteBuf result = ((ByteBuf)msg.content()).retain();
                    out.add(new DefaultAddressedEnvelope((Object)RmiResponse.of(id, result), msg.recipient(), msg.sender()));
                    break;
                }
                case -760063583: {
                    UUID id = new UUID(((ByteBuf)msg.content()).readLong(), ((ByteBuf)msg.content()).readLong());
                    String message = ((ByteBuf)msg.content()).readCharSequence(((ByteBuf)msg.content()).readableBytes(), StandardCharsets.UTF_8).toString();
                    out.add(new DefaultAddressedEnvelope((Object)RmiError.of(id, message), msg.recipient(), msg.sender()));
                    break;
                }
                case -760063582: {
                    UUID id = new UUID(((ByteBuf)msg.content()).readLong(), ((ByteBuf)msg.content()).readLong());
                    out.add(new DefaultAddressedEnvelope((Object)RmiCancel.of(id), msg.recipient(), msg.sender()));
                    break;
                }
                default: {
                    ((ByteBuf)msg.content()).resetReaderIndex();
                    out.add(msg.retain());
                    break;
                }
            }
        } else {
            out.add(msg.retain());
        }
    }
}

