/*
 * Decompiled with CFR 0.152.
 */
package org.drasyl.handler.stream;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.MessageAggregator;
import org.drasyl.handler.stream.LastMessageChunk;
import org.drasyl.handler.stream.MessageChunk;
import org.drasyl.handler.stream.ReassembledMessage;

public class ChunkedMessageAggregator
extends MessageAggregator<MessageChunk, MessageChunk, MessageChunk, ReassembledMessage> {
    public ChunkedMessageAggregator(int maxContentLength) {
        super(maxContentLength);
    }

    protected boolean isStartMessage(MessageChunk msg) {
        return msg.chunkNo() == 0;
    }

    protected boolean isContentMessage(MessageChunk msg) {
        return true;
    }

    protected boolean isLastContentMessage(MessageChunk msg) {
        return msg instanceof LastMessageChunk;
    }

    protected boolean isAggregated(MessageChunk msg) {
        return false;
    }

    protected boolean isContentLengthInvalid(MessageChunk start, int maxContentLength) {
        return false;
    }

    protected Object newContinueResponse(MessageChunk start, int maxContentLength, ChannelPipeline pipeline) {
        return null;
    }

    protected boolean closeAfterContinueResponse(Object msg) {
        throw new UnsupportedOperationException();
    }

    protected boolean ignoreContentAfterContinueResponse(Object msg) {
        throw new UnsupportedOperationException();
    }

    protected ReassembledMessage beginAggregation(MessageChunk start, ByteBuf content) {
        return new ReassembledMessage(content);
    }
}

